/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.annotation.SuppressLint;
import android.app.Service;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.Binder;
import android.os.Handler;
import android.os.HandlerThread;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.util.UidVerifier;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.ChannelClient;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataEventBuffer;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.MessageEvent;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.internal.zzah;
import com.google.android.gms.wearable.internal.zzas;
import com.google.android.gms.wearable.internal.zzaw;
import com.google.android.gms.wearable.internal.zzen;
import com.google.android.gms.wearable.internal.zzfe;
import com.google.android.gms.wearable.internal.zzfo;
import com.google.android.gms.wearable.internal.zzhp;
import com.google.android.gms.wearable.internal.zzi;
import com.google.android.gms.wearable.internal.zzl;
import com.google.android.gms.wearable.zzk;
import com.google.android.gms.wearable.zzm;
import com.google.android.gms.wearable.zzn;
import com.google.android.gms.wearable.zzo;
import com.google.android.gms.wearable.zzp;
import com.google.android.gms.wearable.zzq;
import com.google.android.gms.wearable.zzr;
import com.google.android.gms.wearable.zzs;
import com.google.android.gms.wearable.zzt;
import java.util.List;

public class WearableListenerService
extends Service
implements CapabilityApi.CapabilityListener,
ChannelApi.ChannelListener,
DataApi.DataListener,
MessageApi.MessageListener {
    public static final String BIND_LISTENER_INTENT_ACTION = "com.google.android.gms.wearable.BIND_LISTENER";
    private ComponentName service;
    private zzc zzad;
    private IBinder zzae;
    private Intent zzaf;
    private Looper zzag;
    private final Object zzah = new Object();
    private boolean zzai;
    private zzas zzaj = new zzas(new zza(null));

    public WearableListenerService() {
    }

    public void onCreate() {
        super.onCreate();
        this.service = new ComponentName((Context)this, this.getClass().getName());
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            String string = String.valueOf(this.service);
            Log.d((String)"WearableLS", (String)new StringBuilder(10 + String.valueOf(string).length()).append("onCreate: ").append(string).toString());
        }
        this.zzad = new zzc(this.getLooper());
        this.zzaf = new Intent(BIND_LISTENER_INTENT_ACTION);
        this.zzaf.setComponent(this.service);
        this.zzae = new zzd(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDestroy() {
        Object object;
        if (Log.isLoggable((String)"WearableLS", (int)3)) {
            object = String.valueOf(this.service);
            Log.d((String)"WearableLS", (String)new StringBuilder(11 + String.valueOf(object).length()).append("onDestroy: ").append((String)object).toString());
        }
        object = this.zzah;
        synchronized (object) {
            this.zzai = true;
            if (this.zzad == null) {
                String string = String.valueOf(this.service);
                throw new IllegalStateException(new StringBuilder(111 + String.valueOf(string).length()).append("onDestroy: mServiceHandler not set, did you override onCreate() but forget to call super.onCreate()? component=").append(string).toString());
            }
            this.zzad.quit();
        }
        super.onDestroy();
    }

    public final IBinder onBind(Intent intent) {
        if (BIND_LISTENER_INTENT_ACTION.equals(intent.getAction())) {
            return this.zzae;
        }
        return null;
    }

    public Looper getLooper() {
        if (this.zzag == null) {
            HandlerThread handlerThread = new HandlerThread("WearableListenerService");
            handlerThread.start();
            this.zzag = handlerThread.getLooper();
        }
        return this.zzag;
    }

    @Override
    public void onDataChanged(DataEventBuffer dataEventBuffer) {
    }

    @Override
    public void onMessageReceived(MessageEvent messageEvent) {
    }

    public void onPeerConnected(Node node) {
    }

    public void onPeerDisconnected(Node node) {
    }

    public void onConnectedNodes(List<Node> list) {
    }

    @Override
    public void onCapabilityChanged(CapabilityInfo capabilityInfo) {
    }

    @Override
    public void onChannelOpened(Channel channel) {
    }

    @Override
    public void onChannelClosed(Channel channel, int n, int n2) {
    }

    @Override
    public void onInputClosed(Channel channel, int n, int n2) {
    }

    @Override
    public void onOutputClosed(Channel channel, int n, int n2) {
    }

    public void onChannelOpened(ChannelClient.Channel channel) {
    }

    public void onChannelClosed(ChannelClient.Channel channel, int n, int n2) {
    }

    public void onInputClosed(ChannelClient.Channel channel, int n, int n2) {
    }

    public void onOutputClosed(ChannelClient.Channel channel, int n, int n2) {
    }

    public void onNotificationReceived(com.google.android.gms.wearable.zzd zzd2) {
    }

    public void onEntityUpdate(com.google.android.gms.wearable.zzb zzb2) {
    }

    static /* synthetic */ zzas zzc(WearableListenerService wearableListenerService) {
        return wearableListenerService.zzaj;
    }

    final class zzd
    extends zzen {
        private volatile int zzam = -1;

        private zzd() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final void zza(DataHolder dataHolder) {
            com.google.android.gms.wearable.zzl zzl2 = new com.google.android.gms.wearable.zzl(this, dataHolder);
            try {
                String string = String.valueOf(dataHolder);
                int n = dataHolder.getCount();
                boolean bl = this.zza(zzl2, "onDataItemChanged", new StringBuilder(18 + String.valueOf(string).length()).append(string).append(", rows=").append(n).toString());
                if (bl) return;
            }
            catch (Throwable throwable) {
                dataHolder.close();
                throw throwable;
            }
            dataHolder.close();
        }

        @Override
        public final void zza(zzfe zzfe2) {
            zzm zzm2 = new zzm(this, zzfe2);
            this.zza(zzm2, "onMessageReceived", zzfe2);
        }

        @Override
        public final void zza(zzfo zzfo2) {
            zzn zzn2 = new zzn(this, zzfo2);
            this.zza(zzn2, "onPeerConnected", zzfo2);
        }

        @Override
        public final void zzb(zzfo zzfo2) {
            zzo zzo2 = new zzo(this, zzfo2);
            this.zza(zzo2, "onPeerDisconnected", zzfo2);
        }

        @Override
        public final void onConnectedNodes(List<zzfo> list) {
            zzp zzp2 = new zzp(this, list);
            this.zza(zzp2, "onConnectedNodes", list);
        }

        @Override
        public final void zza(zzah zzah2) {
            zzq zzq2 = new zzq(this, zzah2);
            this.zza(zzq2, "onConnectedCapabilityChanged", zzah2);
        }

        @Override
        public final void zza(zzl zzl2) {
            zzr zzr2 = new zzr(this, zzl2);
            this.zza(zzr2, "onNotificationReceived", (Object)zzl2);
        }

        @Override
        public final void zza(zzi zzi2) {
            zzs zzs2 = new zzs(this, zzi2);
            this.zza(zzs2, "onEntityUpdate", (Object)zzi2);
        }

        @Override
        public final void zza(zzaw zzaw2) {
            zzt zzt2 = new zzt(this, zzaw2);
            this.zza(zzt2, "onChannelEvent", (Object)zzaw2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final boolean zza(Runnable runnable, String string, Object object) {
            boolean bl;
            if (Log.isLoggable((String)"WearableLS", (int)3)) {
                Log.d((String)"WearableLS", (String)String.format("%s: %s %s", string, WearableListenerService.this.service.toString(), object));
            }
            zzd zzd2 = this;
            int n = Binder.getCallingUid();
            if (n == zzd2.zzam) {
                bl = true;
            } else if (zzhp.zza((Context)zzd2.WearableListenerService.this).zze("com.google.android.wearable.app.cn") && UidVerifier.uidHasPackageName((Context)zzd2.WearableListenerService.this, (int)n, (String)"com.google.android.wearable.app.cn")) {
                zzd2.zzam = n;
                bl = true;
            } else if (UidVerifier.isGooglePlayServicesUid((Context)zzd2.WearableListenerService.this, (int)n)) {
                zzd2.zzam = n;
                bl = true;
            } else {
                Log.e((String)"WearableLS", (String)new StringBuilder(57).append("Caller is not GooglePlayServices; caller UID: ").append(n).toString());
                bl = false;
            }
            if (!bl) {
                return false;
            }
            Object object2 = WearableListenerService.this.zzah;
            synchronized (object2) {
                if (WearableListenerService.this.zzai) {
                    return false;
                }
                WearableListenerService.this.zzad.post(runnable);
            }
            return true;
        }

        /* synthetic */ zzd(zzk zzk2) {
            this();
        }
    }

    final class zzc
    extends Handler {
        private boolean started;
        private final zzb zzal;

        zzc(Looper looper) {
            super(looper);
            this.zzal = new zzb(WearableListenerService.this, null);
        }

        public final void dispatchMessage(Message message) {
            this.zzb();
            try {
                super.dispatchMessage(message);
            }
            catch (Throwable throwable) {
                if (!this.hasMessages(0)) {
                    this.zzb("dispatch");
                }
                throw throwable;
            }
            if (!this.hasMessages(0)) {
                this.zzb("dispatch");
                return;
            }
        }

        final void quit() {
            this.getLooper().quit();
            this.zzb("quit");
        }

        @SuppressLint(value={"UntrackedBindService"})
        private final synchronized void zzb() {
            if (this.started) {
                return;
            }
            if (Log.isLoggable((String)"WearableLS", (int)2)) {
                String string = String.valueOf(WearableListenerService.this.service);
                Log.v((String)"WearableLS", (String)new StringBuilder(13 + String.valueOf(string).length()).append("bindService: ").append(string).toString());
            }
            WearableListenerService.this.bindService(WearableListenerService.this.zzaf, this.zzal, 1);
            this.started = true;
        }

        @SuppressLint(value={"UntrackedBindService"})
        private final synchronized void zzb(String string) {
            if (!this.started) {
                return;
            }
            if (Log.isLoggable((String)"WearableLS", (int)2)) {
                String string2 = String.valueOf(WearableListenerService.this.service);
                Log.v((String)"WearableLS", (String)new StringBuilder(17 + String.valueOf(string).length() + String.valueOf(string2).length()).append("unbindService: ").append(string).append(", ").append(string2).toString());
            }
            try {
                WearableListenerService.this.unbindService(this.zzal);
            }
            catch (RuntimeException runtimeException) {
                Log.e((String)"WearableLS", (String)"Exception when unbinding from local service", (Throwable)runtimeException);
            }
            this.started = false;
        }
    }

    final class zzb
    implements ServiceConnection {
        private zzb(WearableListenerService wearableListenerService) {
        }

        public final void onServiceConnected(ComponentName componentName, IBinder iBinder) {
        }

        public final void onServiceDisconnected(ComponentName componentName) {
        }

        /* synthetic */ zzb(WearableListenerService wearableListenerService, zzk zzk2) {
            this(wearableListenerService);
        }
    }

    final class zza
    extends ChannelClient.ChannelCallback {
        private zza() {
        }

        @Override
        public final void onChannelOpened(@NonNull ChannelClient.Channel channel) {
            WearableListenerService.this.onChannelOpened(channel);
        }

        @Override
        public final void onChannelClosed(@NonNull ChannelClient.Channel channel, int n, int n2) {
            WearableListenerService.this.onChannelClosed(channel, n, n2);
        }

        @Override
        public final void onInputClosed(@NonNull ChannelClient.Channel channel, int n, int n2) {
            WearableListenerService.this.onInputClosed(channel, n, n2);
        }

        @Override
        public final void onOutputClosed(@NonNull ChannelClient.Channel channel, int n, int n2) {
            WearableListenerService.this.onOutputClosed(channel, n, n2);
        }

        /* synthetic */ zza(zzk zzk2) {
            this();
        }
    }
}

