/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.annotation.KeepName;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.internal.zzda;

@SafeParcelable.Reserved(value={1})
@KeepName
@SafeParcelable.Class(creator="DataItemAssetParcelableCreator")
public class DataItemAssetParcelable
extends AbstractSafeParcelable
implements ReflectedParcelable,
DataItemAsset {
    public static final Parcelable.Creator<DataItemAssetParcelable> CREATOR = new zzda();
    @SafeParcelable.Field(id=2, getter="getId")
    private final String zzdm;
    @SafeParcelable.Field(id=3, getter="getDataItemKey")
    private final String zzdn;

    @SafeParcelable.Constructor
    DataItemAssetParcelable(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) String string2) {
        this.zzdm = string;
        this.zzdn = string2;
    }

    public DataItemAssetParcelable(DataItemAsset dataItemAsset) {
        this.zzdm = (String)Preconditions.checkNotNull((Object)dataItemAsset.getId());
        this.zzdn = (String)Preconditions.checkNotNull((Object)dataItemAsset.getDataItemKey());
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        DataItemAssetParcelable dataItemAssetParcelable = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)dataItemAssetParcelable.getId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)3, (String)dataItemAssetParcelable.getDataItemKey(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public boolean isDataValid() {
        return true;
    }

    @Override
    public String getId() {
        return this.zzdm;
    }

    @Override
    public String getDataItemKey() {
        return this.zzdn;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("DataItemAssetParcelable[");
        stringBuilder.append("@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        if (this.zzdm == null) {
            stringBuilder.append(",noid");
        } else {
            stringBuilder.append(",");
            stringBuilder.append(this.zzdm);
        }
        stringBuilder.append(", key=");
        stringBuilder.append(this.zzdn);
        stringBuilder.append("]");
        return stringBuilder.toString();
    }
}

