/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.app.Activity;
import android.content.Context;
import android.content.IntentFilter;
import android.net.Uri;
import android.os.Looper;
import android.support.annotation.NonNull;
import com.google.android.gms.common.api.GoogleApi;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.api.internal.ListenerHolders;
import com.google.android.gms.common.internal.Asserts;
import com.google.android.gms.common.internal.PendingResultUtil;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.CapabilityClient;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.internal.zzab;
import com.google.android.gms.wearable.internal.zzac;
import com.google.android.gms.wearable.internal.zzae;
import com.google.android.gms.wearable.internal.zzaf;
import com.google.android.gms.wearable.internal.zzag;
import com.google.android.gms.wearable.internal.zzgj;
import com.google.android.gms.wearable.internal.zzo;
import java.util.Map;

public final class zzaa
extends CapabilityClient {
    private final CapabilityApi zzbw = new zzo();

    public zzaa(@NonNull Context context, @NonNull GoogleApi.Settings settings) {
        super(context, settings);
    }

    public zzaa(@NonNull Activity activity, @NonNull GoogleApi.Settings settings) {
        super(activity, settings);
    }

    @Override
    public final Task<CapabilityInfo> getCapability(@NonNull String string, int n) {
        Asserts.checkNotNull((Object)string, (Object)"capability must not be null");
        return PendingResultUtil.toTask(this.zzbw.getCapability(this.asGoogleApiClient(), string, n), (PendingResultUtil.ResultConverter)zzab.zzbx);
    }

    @Override
    public final Task<Map<String, CapabilityInfo>> getAllCapabilities(int n) {
        return PendingResultUtil.toTask(this.zzbw.getAllCapabilities(this.asGoogleApiClient(), n), (PendingResultUtil.ResultConverter)zzac.zzbx);
    }

    @Override
    public final Task<Void> addLocalCapability(@NonNull String string) {
        Asserts.checkNotNull((Object)string, (Object)"capability must not be null");
        return PendingResultUtil.toVoidTask(this.zzbw.addLocalCapability(this.asGoogleApiClient(), string));
    }

    @Override
    public final Task<Void> removeLocalCapability(@NonNull String string) {
        Asserts.checkNotNull((Object)string, (Object)"capability must not be null");
        return PendingResultUtil.toVoidTask(this.zzbw.removeLocalCapability(this.asGoogleApiClient(), string));
    }

    @Override
    public final Task<Void> addListener(@NonNull CapabilityClient.OnCapabilityChangedListener onCapabilityChangedListener, @NonNull String string) {
        Asserts.checkNotNull((Object)onCapabilityChangedListener, (Object)"listener must not be null");
        Asserts.checkNotNull((Object)string, (Object)"capability must not be null");
        IntentFilter intentFilter = zzgj.zzc("com.google.android.gms.wearable.CAPABILITY_CHANGED");
        if (!string.startsWith("/")) {
            String string2 = String.valueOf(string);
            string = string2.length() != 0 ? "/".concat(string2) : new String("/");
        }
        intentFilter.addDataPath(string, 0);
        IntentFilter[] intentFilterArray = new IntentFilter[]{intentFilter};
        String string3 = String.valueOf(string);
        ListenerHolder listenerHolder = ListenerHolders.createListenerHolder((Object)onCapabilityChangedListener, (Looper)this.getLooper(), (String)(string3.length() != 0 ? "CapabilityListener:".concat(string3) : new String("CapabilityListener:")));
        zzae zzae2 = new zzae(onCapabilityChangedListener, string);
        return this.zza((ListenerHolder<CapabilityClient.OnCapabilityChangedListener>)listenerHolder, zzae2, intentFilterArray);
    }

    @Override
    public final Task<Boolean> removeListener(@NonNull CapabilityClient.OnCapabilityChangedListener onCapabilityChangedListener, String string) {
        Asserts.checkNotNull((Object)onCapabilityChangedListener, (Object)"listener must not be null");
        Asserts.checkNotNull((Object)string, (Object)"capability must not be null");
        if (!string.startsWith("/")) {
            String string2 = String.valueOf(string);
            string = string2.length() != 0 ? "/".concat(string2) : new String("/");
        }
        String string3 = String.valueOf(string);
        ListenerHolder listenerHolder = ListenerHolders.createListenerHolder((Object)onCapabilityChangedListener, (Looper)this.getLooper(), (String)(string3.length() != 0 ? "CapabilityListener:".concat(string3) : new String("CapabilityListener:")));
        return this.doUnregisterEventListener(listenerHolder.getListenerKey());
    }

    @Override
    public final Task<Void> addListener(@NonNull CapabilityClient.OnCapabilityChangedListener onCapabilityChangedListener, @NonNull Uri uri, int n) {
        Asserts.checkNotNull((Object)onCapabilityChangedListener, (Object)"listener must not be null");
        Asserts.checkNotNull((Object)uri, (Object)"uri must not be null");
        Preconditions.checkArgument((n == 0 || n == 1 ? 1 : 0) != 0, (Object)"invalid filter type");
        IntentFilter intentFilter = zzgj.zza("com.google.android.gms.wearable.CAPABILITY_CHANGED", uri, n);
        ListenerHolder listenerHolder = ListenerHolders.createListenerHolder((Object)onCapabilityChangedListener, (Looper)this.getLooper(), (String)"CapabilityListener");
        return this.zza((ListenerHolder<CapabilityClient.OnCapabilityChangedListener>)listenerHolder, onCapabilityChangedListener, new IntentFilter[]{intentFilter});
    }

    @Override
    public final Task<Boolean> removeListener(@NonNull CapabilityClient.OnCapabilityChangedListener onCapabilityChangedListener) {
        Asserts.checkNotNull((Object)onCapabilityChangedListener, (Object)"listener must not be null");
        ListenerHolder listenerHolder = ListenerHolders.createListenerHolder((Object)onCapabilityChangedListener, (Looper)this.getLooper(), (String)"CapabilityListener");
        return this.doUnregisterEventListener(listenerHolder.getListenerKey());
    }

    private final Task<Void> zza(ListenerHolder<CapabilityClient.OnCapabilityChangedListener> listenerHolder, CapabilityClient.OnCapabilityChangedListener onCapabilityChangedListener, IntentFilter[] intentFilterArray) {
        zzaf zzaf2 = new zzaf(onCapabilityChangedListener, intentFilterArray, listenerHolder, null);
        zzag zzag2 = new zzag(onCapabilityChangedListener, listenerHolder.getListenerKey(), null);
        return this.doRegisterEventListener(zzaf2, zzag2);
    }
}

