/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wearable.CapabilityInfo;
import com.google.android.gms.wearable.Node;
import com.google.android.gms.wearable.internal.zzai;
import com.google.android.gms.wearable.internal.zzfo;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.concurrent.GuardedBy;

@SafeParcelable.Reserved(value={1})
@SafeParcelable.Class(creator="CapabilityInfoParcelableCreator")
public final class zzah
extends AbstractSafeParcelable
implements CapabilityInfo {
    public static final Parcelable.Creator<zzah> CREATOR = new zzai();
    private final Object lock = new Object();
    @SafeParcelable.Field(id=2, getter="getName")
    private final String name;
    @SafeParcelable.Field(id=3, getter="getNodeParcelables")
    private final List<zzfo> zzca;
    @GuardedBy(value="lock")
    private Set<Node> zzbt;

    @SafeParcelable.Constructor
    public zzah(@SafeParcelable.Param(id=2) String string, @SafeParcelable.Param(id=3) List<zzfo> list) {
        this.name = string;
        this.zzca = list;
        this.zzbt = null;
        zzah zzah2 = this;
        Preconditions.checkNotNull((Object)zzah2.name);
        Preconditions.checkNotNull(zzah2.zzca);
    }

    @Override
    public final String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Set<Node> getNodes() {
        Object object = this.lock;
        synchronized (object) {
            if (this.zzbt == null) {
                this.zzbt = new HashSet<zzfo>(this.zzca);
            }
            return this.zzbt;
        }
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        zzah zzah2 = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)zzah2.getName(), (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)3, zzah2.zzca, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final String toString() {
        String string = this.name;
        String string2 = String.valueOf(this.zzca);
        return new StringBuilder(18 + String.valueOf(string).length() + String.valueOf(string2).length()).append("CapabilityInfo{").append(string).append(", ").append(string2).append("}").toString();
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        zzah zzah2 = (zzah)object;
        if (this.name != null ? !this.name.equals(zzah2.name) : zzah2.name != null) {
            return false;
        }
        return !(this.zzca != null ? !this.zzca.equals(zzah2.zzca) : zzah2.zzca != null);
    }

    public final int hashCode() {
        int n = 31 + (this.name != null ? this.name.hashCode() : 0);
        return n * 31 + (this.zzca != null ? this.zzca.hashCode() : 0);
    }
}

