/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.support.annotation.NonNull;
import android.util.Log;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.ListenerHolder;
import com.google.android.gms.common.internal.BaseGmsClient;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.CapabilityApi;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.MessageApi;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zza;
import com.google.android.gms.wearable.internal.zzek;
import com.google.android.gms.wearable.internal.zzep;
import com.google.android.gms.wearable.internal.zzeq;
import com.google.android.gms.wearable.internal.zzer;
import com.google.android.gms.wearable.internal.zzfu;
import com.google.android.gms.wearable.internal.zzgc;
import com.google.android.gms.wearable.internal.zzgx;
import com.google.android.gms.wearable.internal.zzhb;
import com.google.android.gms.wearable.internal.zzhh;
import com.google.android.gms.wearable.internal.zzhi;
import com.google.android.gms.wearable.internal.zzhj;
import com.google.android.gms.wearable.internal.zzhk;
import com.google.android.gms.wearable.internal.zzhp;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;

public final class zzhg
extends GmsClient<zzep> {
    private final ExecutorService zzew;
    private final zzer<Object> zzex = new zzer();
    private final zzer<Object> zzey = new zzer();
    private final zzer<ChannelApi.ChannelListener> zzez = new zzer();
    private final zzer<DataApi.DataListener> zzfa = new zzer();
    private final zzer<MessageApi.MessageListener> zzfb = new zzer();
    private final zzer<Object> zzfc = new zzer();
    private final zzer<Object> zzfd = new zzer();
    private final zzer<CapabilityApi.CapabilityListener> zzfe = new zzer();
    private final zzhp zzff;

    public zzhg(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, ClientSettings clientSettings) {
        this(context, looper, connectionCallbacks, onConnectionFailedListener, clientSettings, Executors.newCachedThreadPool(), zzhp.zza(context));
    }

    @VisibleForTesting
    private zzhg(Context context, Looper looper, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener, ClientSettings clientSettings, ExecutorService executorService, zzhp zzhp2) {
        super(context, looper, 14, clientSettings, connectionCallbacks, onConnectionFailedListener);
        this.zzew = (ExecutorService)Preconditions.checkNotNull((Object)executorService);
        this.zzff = zzhp2;
    }

    protected final String getStartServiceAction() {
        return "com.google.android.gms.wearable.BIND";
    }

    protected final String getStartServicePackage() {
        if (this.zzff.zze("com.google.android.wearable.app.cn")) {
            return "com.google.android.wearable.app.cn";
        }
        return "com.google.android.gms";
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.wearable.internal.IWearableService";
    }

    public final boolean requiresGooglePlayServices() {
        return !this.zzff.zze("com.google.android.wearable.app.cn");
    }

    protected final void onPostInitHandler(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (Log.isLoggable((String)"WearableClient", (int)2)) {
            Log.v((String)"WearableClient", (String)new StringBuilder(41).append("onPostInitHandler: statusCode ").append(n).toString());
        }
        if (n == 0) {
            this.zzex.zza(iBinder);
            this.zzey.zza(iBinder);
            this.zzez.zza(iBinder);
            this.zzfa.zza(iBinder);
            this.zzfb.zza(iBinder);
            this.zzfc.zza(iBinder);
            this.zzfd.zza(iBinder);
            this.zzfe.zza(iBinder);
        }
        super.onPostInitHandler(n, iBinder, bundle, n2);
    }

    public final void connect(@NonNull BaseGmsClient.ConnectionProgressReportCallbacks connectionProgressReportCallbacks) {
        if (!this.requiresGooglePlayServices()) {
            try {
                Bundle bundle = this.getContext().getPackageManager().getApplicationInfo((String)"com.google.android.wearable.app.cn", (int)128).metaData;
                int n = bundle != null ? bundle.getInt("com.google.android.wearable.api.version", 0) : 0;
                if (n < 8600000) {
                    Intent intent;
                    Context context;
                    Log.w((String)"WearableClient", (String)new StringBuilder(82).append("The Wear OS app is out of date. Requires API version 8600000 but found ").append(n).toString());
                    Context context2 = context = this.getContext();
                    Intent intent2 = new Intent("com.google.android.wearable.app.cn.UPDATE_ANDROID_WEAR").setPackage("com.google.android.wearable.app.cn");
                    if (context.getPackageManager().resolveActivity(intent2, 65536) != null) {
                        intent = intent2;
                    } else {
                        Uri uri = Uri.parse((String)"market://details").buildUpon().appendQueryParameter("id", "com.google.android.wearable.app.cn").build();
                        intent = new Intent("android.intent.action.VIEW", uri);
                    }
                    this.triggerNotAvailable(connectionProgressReportCallbacks, 6, PendingIntent.getActivity((Context)context2, (int)0, (Intent)intent, (int)0));
                    return;
                }
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                this.triggerNotAvailable(connectionProgressReportCallbacks, 16, null);
                return;
            }
        }
        super.connect(connectionProgressReportCallbacks);
    }

    public final void zza(BaseImplementation.ResultHolder<DataApi.DataItemResult> resultHolder, PutDataRequest putDataRequest) throws RemoteException {
        Object object = putDataRequest.getAssets().entrySet().iterator();
        while (object.hasNext()) {
            Object object2 = object.next().getValue();
            if (object2.getData() != null || object2.getDigest() != null || object2.getFd() != null || object2.getUri() != null) continue;
            String string = String.valueOf(putDataRequest.getUri());
            String string2 = String.valueOf(object2);
            throw new IllegalArgumentException(new StringBuilder(33 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Put for ").append(string).append(" contains invalid asset: ").append(string2).toString());
        }
        object = PutDataRequest.zza(putDataRequest.getUri());
        ((PutDataRequest)((Object)object)).setData(putDataRequest.getData());
        if (putDataRequest.isUrgent()) {
            ((PutDataRequest)((Object)object)).setUrgent();
        }
        ArrayList<FutureTask<Boolean>> arrayList = new ArrayList<FutureTask<Boolean>>();
        for (Map.Entry entry : putDataRequest.getAssets().entrySet()) {
            Object object3;
            Asset asset = (Asset)((Object)entry.getValue());
            if (asset.getData() != null) {
                String string;
                ParcelFileDescriptor[] parcelFileDescriptorArray;
                try {
                    parcelFileDescriptorArray = ParcelFileDescriptor.createPipe();
                }
                catch (IOException iOException) {
                    string = String.valueOf((Object)putDataRequest);
                    throw new IllegalStateException(new StringBuilder(60 + String.valueOf(string).length()).append("Unable to create ParcelFileDescriptor for asset in request: ").append(string).toString(), iOException);
                }
                if (Log.isLoggable((String)"WearableClient", (int)3)) {
                    object3 = String.valueOf((Object)asset);
                    string = String.valueOf(parcelFileDescriptorArray[0]);
                    String string3 = String.valueOf(parcelFileDescriptorArray[1]);
                    Log.d((String)"WearableClient", (String)new StringBuilder(61 + String.valueOf(object3).length() + String.valueOf(string).length() + String.valueOf(string3).length()).append("processAssets: replacing data with FD in asset: ").append((String)object3).append(" read:").append(string).append(" write:").append(string3).toString());
                }
                ((PutDataRequest)((Object)object)).putAsset((String)entry.getKey(), Asset.createFromFd(parcelFileDescriptorArray[0]));
                byte[] byArray = asset.getData();
                ParcelFileDescriptor parcelFileDescriptor = parcelFileDescriptorArray[1];
                zzhg zzhg2 = this;
                object3 = new FutureTask<Boolean>(new zzhh(zzhg2, parcelFileDescriptor, byArray));
                arrayList.add((FutureTask<Boolean>)object3);
                this.zzew.submit((Runnable)object3);
                continue;
            }
            if (asset.getUri() != null) {
                try {
                    object3 = Asset.createFromFd(this.getContext().getContentResolver().openFileDescriptor(asset.getUri(), "r"));
                    ((PutDataRequest)((Object)object)).putAsset((String)entry.getKey(), (Asset)((Object)object3));
                    continue;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    ((zza)new zzhb(resultHolder, arrayList)).zza(new zzfu(4005, null));
                    object3 = String.valueOf(asset.getUri());
                    Log.w((String)"WearableClient", (String)new StringBuilder(28 + String.valueOf(object3).length()).append("Couldn't resolve asset URI: ").append((String)object3).toString());
                    return;
                }
            }
            ((PutDataRequest)((Object)object)).putAsset((String)entry.getKey(), asset);
        }
        ((zzep)this.getService()).zza((zzek)new zzhb(resultHolder, arrayList), (PutDataRequest)((Object)object));
    }

    public final void zza(BaseImplementation.ResultHolder<DataApi.GetFdForAssetResult> resultHolder, Asset asset) throws RemoteException {
        ((zzep)this.getService()).zza((zzek)new zzgx(resultHolder), asset);
    }

    public final void zza(BaseImplementation.ResultHolder<Status> resultHolder, String string, Uri uri, boolean bl) {
        try {
            boolean bl2 = bl;
            Uri uri2 = uri;
            String string2 = string;
            BaseImplementation.ResultHolder<Status> resultHolder2 = resultHolder;
            zzhg zzhg2 = this;
            Preconditions.checkNotNull(resultHolder2);
            Preconditions.checkNotNull((Object)string2);
            Preconditions.checkNotNull((Object)uri2);
            this.zzew.execute(new zzhi(zzhg2, uri2, resultHolder2, bl2, string2));
            return;
        }
        catch (RuntimeException runtimeException) {
            resultHolder.setFailedResult(new Status(8));
            throw runtimeException;
        }
    }

    public final void zza(BaseImplementation.ResultHolder<Status> resultHolder, String string, Uri uri, long l, long l2) {
        try {
            long l3 = l2;
            long l4 = l;
            Uri uri2 = uri;
            String string2 = string;
            BaseImplementation.ResultHolder<Status> resultHolder2 = resultHolder;
            zzhg zzhg2 = this;
            Preconditions.checkNotNull(resultHolder2);
            Preconditions.checkNotNull((Object)string2);
            Preconditions.checkNotNull((Object)uri2);
            Preconditions.checkArgument((l4 >= 0L ? 1 : 0) != 0, (String)"startOffset is negative: %s", (Object[])new Object[]{l4});
            Preconditions.checkArgument((l3 >= -1L ? 1 : 0) != 0, (String)"invalid length: %s", (Object[])new Object[]{l3});
            this.zzew.execute(new zzhj(zzhg2, uri2, resultHolder2, string2, l4, l3));
            return;
        }
        catch (RuntimeException runtimeException) {
            resultHolder.setFailedResult(new Status(8));
            throw runtimeException;
        }
    }

    public final void zza(BaseImplementation.ResultHolder<Status> resultHolder, DataApi.DataListener dataListener, ListenerHolder<DataApi.DataListener> listenerHolder, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzfa.zza(this, resultHolder, dataListener, zzhk.zza(listenerHolder, intentFilterArray));
    }

    public final void zza(BaseImplementation.ResultHolder<Status> resultHolder, MessageApi.MessageListener messageListener, ListenerHolder<MessageApi.MessageListener> listenerHolder, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzfb.zza(this, resultHolder, messageListener, zzhk.zzb(listenerHolder, intentFilterArray));
    }

    public final void zza(BaseImplementation.ResultHolder<Status> resultHolder, CapabilityApi.CapabilityListener capabilityListener, ListenerHolder<CapabilityApi.CapabilityListener> listenerHolder, IntentFilter[] intentFilterArray) throws RemoteException {
        this.zzfe.zza(this, resultHolder, capabilityListener, zzhk.zzd(listenerHolder, intentFilterArray));
    }

    public final void zza(BaseImplementation.ResultHolder<Status> resultHolder, ChannelApi.ChannelListener channelListener, ListenerHolder<ChannelApi.ChannelListener> listenerHolder, @Nullable String string, IntentFilter[] intentFilterArray) throws RemoteException {
        if (string == null) {
            this.zzez.zza(this, resultHolder, channelListener, zzhk.zzc(listenerHolder, intentFilterArray));
            return;
        }
        zzgc zzgc2 = new zzgc(string, channelListener);
        this.zzez.zza(this, resultHolder, zzgc2, zzhk.zza(listenerHolder, string, intentFilterArray));
    }

    public final void zza(BaseImplementation.ResultHolder<Status> resultHolder, DataApi.DataListener dataListener) throws RemoteException {
        this.zzfa.zza(this, resultHolder, dataListener);
    }

    public final void zza(BaseImplementation.ResultHolder<Status> resultHolder, MessageApi.MessageListener messageListener) throws RemoteException {
        this.zzfb.zza(this, resultHolder, messageListener);
    }

    public final void zza(BaseImplementation.ResultHolder<Status> resultHolder, CapabilityApi.CapabilityListener capabilityListener) throws RemoteException {
        this.zzfe.zza(this, resultHolder, capabilityListener);
    }

    public final void zza(BaseImplementation.ResultHolder<Status> resultHolder, ChannelApi.ChannelListener channelListener, String string) throws RemoteException {
        if (string == null) {
            this.zzez.zza(this, resultHolder, channelListener);
            return;
        }
        zzgc zzgc2 = new zzgc(string, channelListener);
        this.zzez.zza(this, resultHolder, zzgc2);
    }

    public final int getMinApkVersion() {
        return 8600000;
    }

    protected final /* synthetic */ IInterface createServiceInterface(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.wearable.internal.IWearableService");
        if (iInterface instanceof zzep) {
            return (zzep)iInterface;
        }
        return new zzeq(iBinder2);
    }
}

