/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable;

import android.net.Uri;
import com.google.android.gms.internal.zznm;
import com.google.android.gms.internal.zznn;
import com.google.android.gms.internal.zznx;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataMap;
import java.util.ArrayList;

public class DataMapItem {
    private final Uri mUri;
    private final DataMap zzaKG;

    public static DataMapItem fromDataItem(DataItem dataItem) {
        if (dataItem == null) {
            throw new IllegalStateException("provided dataItem is null");
        }
        return new DataMapItem(dataItem);
    }

    private DataMapItem(DataItem source) {
        this.mUri = source.getUri();
        this.zzaKG = this.zza((DataItem)source.freeze());
    }

    public Uri getUri() {
        return this.mUri;
    }

    public DataMap getDataMap() {
        return this.zzaKG;
    }

    private DataMap zza(DataItem dataItem) {
        if (dataItem.getData() == null && dataItem.getAssets().size() > 0) {
            throw new IllegalArgumentException("Cannot create DataMapItem from a DataItem  that wasn't made with DataMapItem.");
        }
        if (dataItem.getData() == null) {
            return new DataMap();
        }
        try {
            ArrayList<Asset> arrayList = new ArrayList<Asset>();
            int n = dataItem.getAssets().size();
            for (int i = 0; i < n; ++i) {
                DataItemAsset dataItemAsset = dataItem.getAssets().get(Integer.toString(i));
                if (dataItemAsset == null) {
                    throw new IllegalStateException("Cannot find DataItemAsset referenced in data at " + i + " for " + dataItem);
                }
                Asset asset = Asset.createFromRef(dataItemAsset.getId());
                arrayList.add(asset);
            }
            zznm.zza zza2 = new zznm.zza(zznn.zzs(dataItem.getData()), arrayList);
            return zznm.zza(zza2);
        }
        catch (zznx zznx2) {
            throw new IllegalStateException("Unable to parse. Not a DataItem. Its uri: " + dataItem.getUri());
        }
    }
}

