/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.common.internal.zzv;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.internal.zzbk;
import com.google.android.gms.wearable.internal.zzf;
import com.google.android.gms.wearable.internal.zzi;
import com.google.android.gms.wearable.internal.zzl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ChannelImpl
implements SafeParcelable,
Channel {
    public static final Parcelable.Creator<ChannelImpl> CREATOR = new zzl();
    final int zzzH;
    private final String zzaLw;
    private final String zzaLC;
    private final String zzaLD;

    ChannelImpl(int versionCode, String token, String nodeId, String path) {
        this.zzzH = versionCode;
        this.zzaLw = (String)zzv.zzr((Object)token);
        this.zzaLC = (String)zzv.zzr((Object)nodeId);
        this.zzaLD = (String)zzv.zzr((Object)path);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzl.zza(this, dest, flags);
    }

    public String toString() {
        return "ChannelImpl{versionCode=" + this.zzzH + ", token='" + this.zzaLw + '\'' + ", nodeId='" + this.zzaLC + '\'' + ", path='" + this.zzaLD + '\'' + "}";
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ChannelImpl)) {
            return false;
        }
        ChannelImpl channelImpl = (ChannelImpl)other;
        return this.zzaLw.equals(channelImpl.zzaLw) && zzu.equal((Object)channelImpl.zzaLC, (Object)this.zzaLC) && zzu.equal((Object)channelImpl.zzaLD, (Object)this.zzaLD) && channelImpl.zzzH == this.zzzH;
    }

    public int hashCode() {
        return this.zzaLw.hashCode();
    }

    @Override
    public String getNodeId() {
        return this.zzaLC;
    }

    @Override
    public String getPath() {
        return this.zzaLD;
    }

    public String zzzh() {
        return this.zzaLw;
    }

    @Override
    public PendingResult<Status> close(GoogleApiClient client) {
        return client.zzb((zza.zza)new zzf<Status>(client){

            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zzu((zza.zzb<Status>)this, ChannelImpl.this.zzaLw);
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzb(x0);
            }
        });
    }

    @Override
    public PendingResult<Status> close(GoogleApiClient client, final int errorCode) {
        return client.zzb((zza.zza)new zzf<Status>(client){

            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zzh((zza.zzb<Status>)this, ChannelImpl.this.zzaLw, errorCode);
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzb(x0);
            }
        });
    }

    @Override
    public PendingResult<Channel.GetInputStreamResult> getInputStream(GoogleApiClient client) {
        return client.zzb((zza.zza)new zzf<Channel.GetInputStreamResult>(client){

            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zzv((zza.zzb<Channel.GetInputStreamResult>)this, ChannelImpl.this.zzaLw);
            }

            public Channel.GetInputStreamResult zzaV(Status status) {
                return new zza(status, null);
            }

            public /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzaV(x0);
            }
        });
    }

    @Override
    public PendingResult<Channel.GetOutputStreamResult> getOutputStream(GoogleApiClient client) {
        return client.zzb((zza.zza)new zzf<Channel.GetOutputStreamResult>(client){

            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zzw((zza.zzb<Channel.GetOutputStreamResult>)this, ChannelImpl.this.zzaLw);
            }

            public Channel.GetOutputStreamResult zzaW(Status status) {
                return new zzb(status, null);
            }

            public /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzaW(x0);
            }
        });
    }

    @Override
    public PendingResult<Status> receiveFile(GoogleApiClient client, final Uri uri, final boolean append) {
        zzv.zzb((Object)client, (Object)"client is null");
        zzv.zzb((Object)uri, (Object)"uri is null");
        return client.zzb((zza.zza)new zzf<Status>(client){

            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zza((zza.zzb<Status>)this, ChannelImpl.this.zzaLw, uri, append);
            }

            public Status zzb(Status status) {
                return status;
            }

            public /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzb(x0);
            }
        });
    }

    @Override
    public PendingResult<Status> sendFile(GoogleApiClient client, Uri uri) {
        return this.sendFile(client, uri, 0L, -1L);
    }

    @Override
    public PendingResult<Status> sendFile(GoogleApiClient client, final Uri uri, final long startOffset, final long length) {
        zzv.zzb((Object)client, (Object)"client is null");
        zzv.zzb((Object)this.zzaLw, (Object)"token is null");
        zzv.zzb((Object)uri, (Object)"uri is null");
        zzv.zzb((startOffset >= 0L ? 1 : 0) != 0, (String)"startOffset is negative: %s", (Object[])new Object[]{startOffset});
        zzv.zzb((length >= 0L || length == -1L ? 1 : 0) != 0, (String)"invalid length: %s", (Object[])new Object[]{length});
        return client.zzb((zza.zza)new zzf<Status>(client){

            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zza((zza.zzb<Status>)this, ChannelImpl.this.zzaLw, uri, startOffset, length);
            }

            public Status zzb(Status status) {
                return status;
            }

            public /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzb(x0);
            }
        });
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient client, ChannelApi.ChannelListener listener) {
        zzv.zzb((Object)client, (Object)"client is null");
        zzv.zzb((Object)listener, (Object)"listener is null");
        return client.zza((zza.zza)new zzi.zza(client, listener, this.zzaLw));
    }

    @Override
    public PendingResult<Status> removeListener(GoogleApiClient client, ChannelApi.ChannelListener listener) {
        zzv.zzb((Object)client, (Object)"client is null");
        zzv.zzb((Object)listener, (Object)"listener is null");
        return client.zza((zza.zza)new zzi.zzc(client, listener, this.zzaLw));
    }

    static final class zzb
    implements Channel.GetOutputStreamResult {
        private final Status zzKr;
        private final OutputStream zzaLJ;

        zzb(Status status, OutputStream outputStream) {
            this.zzKr = (Status)zzv.zzr((Object)status);
            this.zzaLJ = outputStream;
        }

        public Status getStatus() {
            return this.zzKr;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.zzaLJ;
        }

        public void release() {
            if (this.zzaLJ != null) {
                try {
                    this.zzaLJ.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static final class zza
    implements Channel.GetInputStreamResult {
        private final Status zzKr;
        private final InputStream zzaLI;

        zza(Status status, InputStream inputStream) {
            this.zzKr = (Status)zzv.zzr((Object)status);
            this.zzaLI = inputStream;
        }

        public Status getStatus() {
            return this.zzKr;
        }

        @Override
        public InputStream getInputStream() {
            return this.zzaLI;
        }

        public void release() {
            if (this.zzaLI != null) {
                try {
                    this.zzaLI.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

