/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.net.Uri;
import android.util.Log;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class zzaa
implements DataItem {
    private Uri mUri;
    private byte[] zzanX;
    private Map<String, DataItemAsset> zzaMb;

    public zzaa(DataItem dataItem) {
        this.mUri = dataItem.getUri();
        this.zzanX = dataItem.getData();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Map.Entry<String, DataItemAsset> entry : dataItem.getAssets().entrySet()) {
            if (entry.getKey() == null) continue;
            hashMap.put(entry.getKey(), entry.getValue().freeze());
        }
        this.zzaMb = Collections.unmodifiableMap(hashMap);
    }

    public DataItem zzzl() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    @Override
    public Uri getUri() {
        return this.mUri;
    }

    @Override
    public byte[] getData() {
        return this.zzanX;
    }

    @Override
    public Map<String, DataItemAsset> getAssets() {
        return this.zzaMb;
    }

    @Override
    public DataItem setData(byte[] data) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.toString(Log.isLoggable((String)"DataItem", (int)3));
    }

    public String toString(boolean verbose) {
        StringBuilder stringBuilder = new StringBuilder("DataItemEntity[");
        stringBuilder.append("@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append(",dataSz=" + (this.zzanX == null ? "null" : Integer.valueOf(this.zzanX.length)));
        stringBuilder.append(", numAssets=" + this.zzaMb.size());
        stringBuilder.append(", uri=" + this.mUri);
        if (!verbose) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        Set<String> set = this.zzaMb.keySet();
        for (String string : set) {
            stringBuilder.append("\n    " + string + ": " + this.zzaMb.get(string));
        }
        stringBuilder.append("\n  ]");
        return stringBuilder.toString();
    }

    public /* synthetic */ Object freeze() {
        return this.zzzl();
    }
}

