/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.IntentFilter;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.wearable.Asset;
import com.google.android.gms.wearable.DataApi;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.DataItemBuffer;
import com.google.android.gms.wearable.PutDataRequest;
import com.google.android.gms.wearable.internal.zzbk;
import com.google.android.gms.wearable.internal.zzf;
import java.io.IOException;
import java.io.InputStream;

public final class zzu
implements DataApi {
    @Override
    public PendingResult<DataApi.DataItemResult> putDataItem(GoogleApiClient client, final PutDataRequest request) {
        return client.zza((zza.zza)new zzf<DataApi.DataItemResult>(client){

            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zza((zza.zzb<DataApi.DataItemResult>)this, request);
            }

            public DataApi.DataItemResult zzaX(Status status) {
                return new zzb(status, null);
            }

            public /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzaX(x0);
            }
        });
    }

    @Override
    public PendingResult<DataApi.DataItemResult> getDataItem(GoogleApiClient client, final Uri uri) {
        return client.zza((zza.zza)new zzf<DataApi.DataItemResult>(client){

            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zza((zza.zzb<DataApi.DataItemResult>)this, uri);
            }

            protected DataApi.DataItemResult zzaX(Status status) {
                return new zzb(status, null);
            }

            protected /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzaX(x0);
            }
        });
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient client) {
        return client.zza((zza.zza)new zzf<DataItemBuffer>(client){

            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zzl((zza.zzb<DataItemBuffer>)this);
            }

            protected DataItemBuffer zzaY(Status status) {
                return new DataItemBuffer(DataHolder.zzaE((int)status.getStatusCode()));
            }

            protected /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzaY(x0);
            }
        });
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient client, Uri uri) {
        return this.getDataItems(client, uri, 0);
    }

    @Override
    public PendingResult<DataItemBuffer> getDataItems(GoogleApiClient client, final Uri uri, final int filterType) {
        return client.zza((zza.zza)new zzf<DataItemBuffer>(client){

            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zza((zza.zzb<DataItemBuffer>)this, uri, filterType);
            }

            protected DataItemBuffer zzaY(Status status) {
                return new DataItemBuffer(DataHolder.zzaE((int)status.getStatusCode()));
            }

            protected /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzaY(x0);
            }
        });
    }

    @Override
    public PendingResult<DataApi.DeleteDataItemsResult> deleteDataItems(GoogleApiClient client, Uri uri) {
        return this.deleteDataItems(client, uri, 0);
    }

    @Override
    public PendingResult<DataApi.DeleteDataItemsResult> deleteDataItems(GoogleApiClient client, final Uri uri, final int filterType) {
        return client.zza((zza.zza)new zzf<DataApi.DeleteDataItemsResult>(client){

            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zzb((zza.zzb<DataApi.DeleteDataItemsResult>)this, uri, filterType);
            }

            protected DataApi.DeleteDataItemsResult zzaZ(Status status) {
                return new zzc(status, 0);
            }

            protected /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzaZ(x0);
            }
        });
    }

    private void zza(Asset asset) {
        if (asset == null) {
            throw new IllegalArgumentException("asset is null");
        }
        if (asset.getDigest() == null) {
            throw new IllegalArgumentException("invalid asset");
        }
        if (asset.getData() != null) {
            throw new IllegalArgumentException("invalid asset");
        }
    }

    @Override
    public PendingResult<DataApi.GetFdForAssetResult> getFdForAsset(GoogleApiClient client, final Asset asset) {
        this.zza(asset);
        return client.zza((zza.zza)new zzf<DataApi.GetFdForAssetResult>(client){

            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zza((zza.zzb<DataApi.GetFdForAssetResult>)this, asset);
            }

            protected DataApi.GetFdForAssetResult zzba(Status status) {
                return new zzd(status, null);
            }

            protected /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzba(x0);
            }
        });
    }

    @Override
    public PendingResult<DataApi.GetFdForAssetResult> getFdForAsset(GoogleApiClient client, final DataItemAsset asset) {
        return client.zza((zza.zza)new zzf<DataApi.GetFdForAssetResult>(client){

            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zza((zza.zzb<DataApi.GetFdForAssetResult>)this, asset);
            }

            protected DataApi.GetFdForAssetResult zzba(Status status) {
                return new zzd(status, null);
            }

            protected /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzba(x0);
            }
        });
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient client, DataApi.DataListener listener) {
        return this.zza(client, listener, null);
    }

    private PendingResult<Status> zza(GoogleApiClient googleApiClient, DataApi.DataListener dataListener, IntentFilter[] intentFilterArray) {
        return googleApiClient.zza((zza.zza)new zza(googleApiClient, dataListener, intentFilterArray));
    }

    @Override
    public PendingResult<Status> removeListener(GoogleApiClient client, final DataApi.DataListener listener) {
        return client.zza((zza.zza)new zzf<Status>(client){

            protected void zza(zzbk zzbk2) throws RemoteException {
                zzbk2.zza((zza.zzb<Status>)this, listener);
            }

            public Status zzb(Status status) {
                return status;
            }

            public /* synthetic */ Result createFailedResult(Status x0) {
                return this.zzb(x0);
            }
        });
    }

    private static final class zza
    extends zzf<Status> {
        private DataApi.DataListener zzaLW;
        private IntentFilter[] zzaLX;

        private zza(GoogleApiClient googleApiClient, DataApi.DataListener dataListener, IntentFilter[] intentFilterArray) {
            super(googleApiClient);
            this.zzaLW = dataListener;
            this.zzaLX = intentFilterArray;
        }

        protected void zza(zzbk zzbk2) throws RemoteException {
            zzbk2.zza((zza.zzb<Status>)this, this.zzaLW, this.zzaLX);
            this.zzaLW = null;
            this.zzaLX = null;
        }

        public Status zzb(Status status) {
            this.zzaLW = null;
            this.zzaLX = null;
            return status;
        }

        public /* synthetic */ Result createFailedResult(Status x0) {
            return this.zzb(x0);
        }
    }

    public static class zzd
    implements DataApi.GetFdForAssetResult {
        private final Status zzKr;
        private volatile ParcelFileDescriptor zzaMa;
        private volatile InputStream zzaLI;
        private volatile boolean mClosed = false;

        public zzd(Status status, ParcelFileDescriptor parcelFileDescriptor) {
            this.zzKr = status;
            this.zzaMa = parcelFileDescriptor;
        }

        public Status getStatus() {
            return this.zzKr;
        }

        @Override
        public ParcelFileDescriptor getFd() {
            if (this.mClosed) {
                throw new IllegalStateException("Cannot access the file descriptor after release().");
            }
            return this.zzaMa;
        }

        @Override
        public InputStream getInputStream() {
            if (this.mClosed) {
                throw new IllegalStateException("Cannot access the input stream after release().");
            }
            if (this.zzaMa == null) {
                return null;
            }
            if (this.zzaLI == null) {
                this.zzaLI = new ParcelFileDescriptor.AutoCloseInputStream(this.zzaMa);
            }
            return this.zzaLI;
        }

        public void release() {
            if (this.zzaMa == null) {
                return;
            }
            if (this.mClosed) {
                throw new IllegalStateException("releasing an already released result.");
            }
            try {
                if (this.zzaLI != null) {
                    this.zzaLI.close();
                } else {
                    this.zzaMa.close();
                }
                this.mClosed = true;
                this.zzaMa = null;
                this.zzaLI = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class zzc
    implements DataApi.DeleteDataItemsResult {
        private final Status zzKr;
        private final int zzaLZ;

        public zzc(Status status, int n) {
            this.zzKr = status;
            this.zzaLZ = n;
        }

        public Status getStatus() {
            return this.zzKr;
        }

        @Override
        public int getNumDeleted() {
            return this.zzaLZ;
        }
    }

    public static class zzb
    implements DataApi.DataItemResult {
        private final Status zzKr;
        private final DataItem zzaLY;

        public zzb(Status status, DataItem dataItem) {
            this.zzKr = status;
            this.zzaLY = dataItem;
        }

        public Status getStatus() {
            return this.zzKr;
        }

        @Override
        public DataItem getDataItem() {
            return this.zzaLY;
        }
    }
}

