/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.content.IntentFilter;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.zza;
import com.google.android.gms.common.api.internal.zzq;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.internal.zzw;
import com.google.android.gms.common.internal.zzx;
import com.google.android.gms.wearable.Channel;
import com.google.android.gms.wearable.ChannelApi;
import com.google.android.gms.wearable.internal.zzb;
import com.google.android.gms.wearable.internal.zzbn;
import com.google.android.gms.wearable.internal.zzbp;
import com.google.android.gms.wearable.internal.zzi;
import com.google.android.gms.wearable.internal.zzl;
import com.google.android.gms.wearable.internal.zzo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ChannelImpl
implements SafeParcelable,
Channel {
    public static final Parcelable.Creator<ChannelImpl> CREATOR = new zzo();
    final int mVersionCode;
    private final String zzVo;
    private final String zzbrb;
    private final String mPath;

    ChannelImpl(int versionCode, String token, String nodeId, String path) {
        this.mVersionCode = versionCode;
        this.zzVo = (String)zzx.zzz((Object)token);
        this.zzbrb = (String)zzx.zzz((Object)nodeId);
        this.mPath = (String)zzx.zzz((Object)path);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzo.zza(this, dest, flags);
    }

    public String toString() {
        return "ChannelImpl{versionCode=" + this.mVersionCode + ", token='" + this.zzVo + '\'' + ", nodeId='" + this.zzbrb + '\'' + ", path='" + this.mPath + '\'' + "}";
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ChannelImpl)) {
            return false;
        }
        ChannelImpl channelImpl = (ChannelImpl)other;
        return this.zzVo.equals(channelImpl.zzVo) && zzw.equal((Object)channelImpl.zzbrb, (Object)this.zzbrb) && zzw.equal((Object)channelImpl.mPath, (Object)this.mPath) && channelImpl.mVersionCode == this.mVersionCode;
    }

    public int hashCode() {
        return this.zzVo.hashCode();
    }

    @Override
    public String getNodeId() {
        return this.zzbrb;
    }

    @Override
    public String getPath() {
        return this.mPath;
    }

    public String getToken() {
        return this.zzVo;
    }

    @Override
    public PendingResult<Status> close(GoogleApiClient client) {
        return client.zza((zza.zza)new zzi<Status>(client){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zzt((zza.zzb<Status>)this, ChannelImpl.this.zzVo);
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Status> close(GoogleApiClient client, final int errorCode) {
        return client.zza((zza.zza)new zzi<Status>(client){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zzh((zza.zzb<Status>)this, ChannelImpl.this.zzVo, errorCode);
            }

            protected Status zzb(Status status) {
                return status;
            }

            protected /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Channel.GetInputStreamResult> getInputStream(GoogleApiClient client) {
        return client.zza((zza.zza)new zzi<Channel.GetInputStreamResult>(client){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zzu((zza.zzb<Channel.GetInputStreamResult>)this, ChannelImpl.this.zzVo);
            }

            public Channel.GetInputStreamResult zzbt(Status status) {
                return new zza(status, null);
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzbt(status);
            }
        });
    }

    @Override
    public PendingResult<Channel.GetOutputStreamResult> getOutputStream(GoogleApiClient client) {
        return client.zza((zza.zza)new zzi<Channel.GetOutputStreamResult>(client){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zzv((zza.zzb<Channel.GetOutputStreamResult>)this, ChannelImpl.this.zzVo);
            }

            public Channel.GetOutputStreamResult zzbu(Status status) {
                return new zzb(status, null);
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzbu(status);
            }
        });
    }

    @Override
    public PendingResult<Status> receiveFile(GoogleApiClient client, final Uri uri, final boolean append) {
        zzx.zzb((Object)client, (Object)"client is null");
        zzx.zzb((Object)uri, (Object)"uri is null");
        return client.zza((zza.zza)new zzi<Status>(client){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zza.zzb<Status>)this, ChannelImpl.this.zzVo, uri, append);
            }

            public Status zzb(Status status) {
                return status;
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Status> sendFile(GoogleApiClient client, Uri uri) {
        return this.sendFile(client, uri, 0L, -1L);
    }

    @Override
    public PendingResult<Status> sendFile(GoogleApiClient client, final Uri uri, final long startOffset, final long length) {
        zzx.zzb((Object)client, (Object)"client is null");
        zzx.zzb((Object)this.zzVo, (Object)"token is null");
        zzx.zzb((Object)uri, (Object)"uri is null");
        zzx.zzb((startOffset >= 0L ? 1 : 0) != 0, (String)"startOffset is negative: %s", (Object[])new Object[]{startOffset});
        zzx.zzb((length >= 0L || length == -1L ? 1 : 0) != 0, (String)"invalid length: %s", (Object[])new Object[]{length});
        return client.zza((zza.zza)new zzi<Status>(client){

            protected void zza(zzbp zzbp2) throws RemoteException {
                zzbp2.zza((zza.zzb<Status>)this, ChannelImpl.this.zzVo, uri, startOffset, length);
            }

            public Status zzb(Status status) {
                return status;
            }

            public /* synthetic */ Result zzc(Status status) {
                return this.zzb(status);
            }
        });
    }

    @Override
    public PendingResult<Status> addListener(GoogleApiClient client, ChannelApi.ChannelListener listener) {
        IntentFilter[] intentFilterArray = new IntentFilter[]{zzbn.zzgM("com.google.android.gms.wearable.CHANNEL_EVENT")};
        return com.google.android.gms.wearable.internal.zzb.zza(client, ChannelImpl.zza(this.zzVo, intentFilterArray), listener);
    }

    @Override
    public PendingResult<Status> removeListener(GoogleApiClient client, ChannelApi.ChannelListener listener) {
        zzx.zzb((Object)client, (Object)"client is null");
        zzx.zzb((Object)listener, (Object)"listener is null");
        return client.zza((zza.zza)new zzl.zzb(client, listener, this.zzVo));
    }

    private static zzb.zza<ChannelApi.ChannelListener> zza(final String string, final IntentFilter[] intentFilterArray) {
        return new zzb.zza<ChannelApi.ChannelListener>(){

            @Override
            public void zza(zzbp zzbp2, zza.zzb<Status> zzb2, ChannelApi.ChannelListener channelListener, zzq<ChannelApi.ChannelListener> zzq2) throws RemoteException {
                zzbp2.zza(zzb2, channelListener, zzq2, string, intentFilterArray);
            }
        };
    }

    static final class zzb
    implements Channel.GetOutputStreamResult {
        private final Status zzUX;
        private final OutputStream zzbsi;

        zzb(Status status, OutputStream outputStream) {
            this.zzUX = (Status)zzx.zzz((Object)status);
            this.zzbsi = outputStream;
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public OutputStream getOutputStream() {
            return this.zzbsi;
        }

        public void release() {
            if (this.zzbsi != null) {
                try {
                    this.zzbsi.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    static final class zza
    implements Channel.GetInputStreamResult {
        private final Status zzUX;
        private final InputStream zzbsh;

        zza(Status status, InputStream inputStream) {
            this.zzUX = (Status)zzx.zzz((Object)status);
            this.zzbsh = inputStream;
        }

        public Status getStatus() {
            return this.zzUX;
        }

        @Override
        public InputStream getInputStream() {
            return this.zzbsh;
        }

        public void release() {
            if (this.zzbsh != null) {
                try {
                    this.zzbsh.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

