/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.wearable.internal;

import android.net.Uri;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.Log;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.wearable.DataItem;
import com.google.android.gms.wearable.DataItemAsset;
import com.google.android.gms.wearable.internal.DataItemAssetParcelable;
import com.google.android.gms.wearable.internal.zzae;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class DataItemParcelable
implements SafeParcelable,
DataItem {
    public static final Parcelable.Creator<DataItemParcelable> CREATOR = new zzae();
    final int mVersionCode;
    private final Uri mUri;
    private final Map<String, DataItemAsset> zzbsy;
    private byte[] zzaKm;

    DataItemParcelable(int versionCode, Uri uri, Bundle assetBundle, byte[] data) {
        this.mVersionCode = versionCode;
        this.mUri = uri;
        HashMap<String, DataItemAsset> hashMap = new HashMap<String, DataItemAsset>();
        assetBundle.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        for (String string : assetBundle.keySet()) {
            hashMap.put(string, (DataItemAssetParcelable)assetBundle.getParcelable(string));
        }
        this.zzbsy = hashMap;
        this.zzaKm = data;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        zzae.zza(this, dest, flags);
    }

    public DataItemParcelable zzIN() {
        return this;
    }

    public boolean isDataValid() {
        return true;
    }

    @Override
    public Uri getUri() {
        return this.mUri;
    }

    @Override
    public byte[] getData() {
        return this.zzaKm;
    }

    public DataItemParcelable zzz(byte[] byArray) {
        this.zzaKm = byArray;
        return this;
    }

    @Override
    public Map<String, DataItemAsset> getAssets() {
        return this.zzbsy;
    }

    public Bundle zzIv() {
        Bundle bundle = new Bundle();
        bundle.setClassLoader(DataItemAssetParcelable.class.getClassLoader());
        for (Map.Entry<String, DataItemAsset> entry : this.zzbsy.entrySet()) {
            bundle.putParcelable(entry.getKey(), (Parcelable)new DataItemAssetParcelable(entry.getValue()));
        }
        return bundle;
    }

    public String toString() {
        return this.toString(Log.isLoggable((String)"DataItem", (int)3));
    }

    public String toString(boolean verbose) {
        StringBuilder stringBuilder = new StringBuilder("DataItemParcelable[");
        stringBuilder.append("@");
        stringBuilder.append(Integer.toHexString(this.hashCode()));
        stringBuilder.append(",dataSz=" + (this.zzaKm == null ? "null" : Integer.valueOf(this.zzaKm.length)));
        stringBuilder.append(", numAssets=" + this.zzbsy.size());
        stringBuilder.append(", uri=" + this.mUri);
        if (!verbose) {
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
        stringBuilder.append("]\n  assets: ");
        Set<String> set = this.zzbsy.keySet();
        for (String string : set) {
            stringBuilder.append("\n    " + string + ": " + this.zzbsy.get(string));
        }
        stringBuilder.append("\n  ]");
        return stringBuilder.toString();
    }

    @Override
    public /* synthetic */ DataItem setData(byte[] byArray) {
        return this.zzz(byArray);
    }

    public /* synthetic */ Object freeze() {
        return this.zzIN();
    }
}

