/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dependencies;

import com.google.android.gms.dependencies.Artifact;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0003J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\b\u00a8\u0006\u0019"}, d2={"Lcom/google/android/gms/dependencies/ArtifactVersion;", "", "groupId", "", "artifactId", "version", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getArtifactId", "()Ljava/lang/String;", "getGroupId", "getVersion", "component1", "component2", "component3", "copy", "equals", "", "other", "getArtifact", "Lcom/google/android/gms/dependencies/Artifact;", "getGradleRef", "hashCode", "", "toString", "Companion", "strict-version-matcher-plugin"})
public final class ArtifactVersion {
    @NotNull
    private final String groupId;
    @NotNull
    private final String artifactId;
    @NotNull
    private final String version;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Artifact getArtifact() {
        return new Artifact(this.groupId, this.artifactId);
    }

    @NotNull
    public final String getGradleRef() {
        return this.groupId + ':' + this.artifactId + ':' + this.version;
    }

    @NotNull
    public final String getGroupId() {
        return this.groupId;
    }

    @NotNull
    public final String getArtifactId() {
        return this.artifactId;
    }

    @NotNull
    public final String getVersion() {
        return this.version;
    }

    public ArtifactVersion(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
    }

    @NotNull
    public final String component1() {
        return this.groupId;
    }

    @NotNull
    public final String component2() {
        return this.artifactId;
    }

    @NotNull
    public final String component3() {
        return this.version;
    }

    @NotNull
    public final ArtifactVersion copy(@NotNull String groupId, @NotNull String artifactId, @NotNull String version) {
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        Intrinsics.checkParameterIsNotNull((Object)artifactId, (String)"artifactId");
        Intrinsics.checkParameterIsNotNull((Object)version, (String)"version");
        return new ArtifactVersion(groupId, artifactId, version);
    }

    @NotNull
    public static /* synthetic */ ArtifactVersion copy$default(ArtifactVersion artifactVersion, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = artifactVersion.groupId;
        }
        if ((n & 2) != 0) {
            string2 = artifactVersion.artifactId;
        }
        if ((n & 4) != 0) {
            string3 = artifactVersion.version;
        }
        return artifactVersion.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "ArtifactVersion(groupId=" + this.groupId + ", artifactId=" + this.artifactId + ", version=" + this.version + ")";
    }

    public int hashCode() {
        String string = this.groupId;
        String string2 = this.artifactId;
        String string3 = this.version;
        return ((string != null ? string.hashCode() : 0) * 31 + (string2 != null ? string2.hashCode() : 0)) * 31 + (string3 != null ? string3.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof ArtifactVersion)) break block3;
                ArtifactVersion artifactVersion = (ArtifactVersion)object;
                if (!Intrinsics.areEqual((Object)this.groupId, (Object)artifactVersion.groupId) || !Intrinsics.areEqual((Object)this.artifactId, (Object)artifactVersion.artifactId) || !Intrinsics.areEqual((Object)this.version, (Object)artifactVersion.version)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lcom/google/android/gms/dependencies/ArtifactVersion$Companion;", "", "()V", "fromGradleRef", "Lcom/google/android/gms/dependencies/ArtifactVersion;", "referenceString", "", "fromGradleRefOrNull", "strict-version-matcher-plugin"})
    public static final class Companion {
        @NotNull
        public final ArtifactVersion fromGradleRef(@NotNull String referenceString) {
            Intrinsics.checkParameterIsNotNull((Object)referenceString, (String)"referenceString");
            List stringSplit = StringsKt.split$default((CharSequence)referenceString, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            if (stringSplit.size() < 3) {
                throw (Throwable)new IllegalArgumentException("Invalid Gradle reference string: " + referenceString);
            }
            return new ArtifactVersion((String)stringSplit.get(0), (String)stringSplit.get(1), (String)stringSplit.get(2));
        }

        @Nullable
        public final ArtifactVersion fromGradleRefOrNull(@NotNull String referenceString) {
            Intrinsics.checkParameterIsNotNull((Object)referenceString, (String)"referenceString");
            List stringSplit = StringsKt.split$default((CharSequence)referenceString, (String[])new String[]{":"}, (boolean)false, (int)0, (int)6, null);
            if (stringSplit.size() < 3) {
                return null;
            }
            return new ArtifactVersion((String)stringSplit.get(0), (String)stringSplit.get(1), (String)stringSplit.get(2));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

