/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dependencies;

import com.google.android.gms.dependencies.Artifact;
import com.google.android.gms.dependencies.ArtifactVersion;
import com.google.android.gms.dependencies.Dependency;
import com.google.android.gms.dependencies.DependencyAnalyzer;
import com.google.android.gms.dependencies.Node;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.GradleException;
import org.gradle.api.artifacts.DependencyResolutionListener;
import org.gradle.api.artifacts.ResolvableDependencies;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DependencyInspector
implements DependencyResolutionListener {
    private static final String GRADLE_PROJECT = "gradle.project";
    private static Logger logger = LoggerFactory.getLogger(DependencyInspector.class);
    private final DependencyAnalyzer dependencyAnalyzer;
    private final String projectName;
    private final String exceptionMessageAddendum;

    public DependencyInspector(@Nonnull DependencyAnalyzer dependencyAnalyzer, @Nonnull String projectName, @Nullable String exceptionMessageAddendum) {
        this.dependencyAnalyzer = dependencyAnalyzer;
        this.exceptionMessageAddendum = exceptionMessageAddendum;
        this.projectName = projectName;
    }

    private static String simplifyKnownGroupIds(@Nonnull String inputString) {
        return inputString.replace("com.google.android.gms", "c.g.a.g").replace("com.google.firebase", "c.g.f");
    }

    private static void printNode(int depth, @Nonnull Node n) {
        StringBuilder prefix = new StringBuilder();
        for (int z = 0; z < depth; ++z) {
            prefix.append("--");
        }
        prefix.append(" ");
        Dependency dep = n.getDependency();
        if (GRADLE_PROJECT.equals(n.getDependency().getFromArtifactVersion().getGroupId())) {
            String fromRef = dep.getFromArtifactVersion().getGradleRef().replace(GRADLE_PROJECT, "");
            String toRef = DependencyInspector.simplifyKnownGroupIds(dep.getToArtifact().getGradleRef());
            logger.info(prefix.toString() + fromRef + " task/module dep -> " + toRef + "@" + dep.getToArtifactVersionString());
        } else {
            String fromRef = DependencyInspector.simplifyKnownGroupIds(dep.getFromArtifactVersion().getGradleRef());
            String toRef = DependencyInspector.simplifyKnownGroupIds(dep.getToArtifact().getGradleRef());
            logger.info(prefix.toString() + fromRef + " library depends -> " + toRef + "@" + dep.getToArtifactVersionString());
        }
        if (n.getChild() != null) {
            DependencyInspector.printNode(depth + 1, n.getChild());
        }
    }

    private void registerDependencies(@Nonnull ResolvableDependencies resolvableDependencies, @Nonnull String projectName, @Nonnull String taskName) {
        ResolutionResult resolutionResult = resolvableDependencies.getResolutionResult();
        for (DependencyResult depResult : resolutionResult.getAllDependencies()) {
            ArtifactVersion toDep;
            ArtifactVersion fromDep;
            if (depResult.getFrom() == null || "".equals(depResult.getFrom().getId().getDisplayName()) || "project :".equals(depResult.getFrom().getId().getDisplayName())) {
                fromDep = ArtifactVersion.Companion.fromGradleRef("gradle.project:" + projectName + "-" + taskName + ":0.0.0");
            } else {
                String depFromString = "" + depResult.getFrom().getId().getDisplayName();
                if (depFromString.startsWith("project ")) {
                    String[] splitDepName = depFromString.split(":");
                    String depName = splitDepName.length > 1 ? splitDepName[1] : "module";
                    fromDep = ArtifactVersion.Companion.fromGradleRef("gradle.project:" + projectName + "-" + taskName + "-" + depName + ":0.0.0");
                } else {
                    try {
                        fromDep = ArtifactVersion.Companion.fromGradleRef(depFromString);
                    }
                    catch (IllegalArgumentException iae) {
                        logger.info("Skipping misunderstood FROM dep string: " + depFromString);
                        continue;
                    }
                }
            }
            if (depResult.getRequested() == null) continue;
            String toDepString = "" + depResult.getRequested();
            try {
                toDep = ArtifactVersion.Companion.fromGradleRef(toDepString);
            }
            catch (IllegalArgumentException iae) {
                logger.info("Skipping misunderstood TO dep string: " + toDepString);
                continue;
            }
            this.dependencyAnalyzer.registerDependency(Dependency.Companion.fromArtifactVersions(fromDep, toDep));
        }
    }

    public void beforeResolve(ResolvableDependencies resolvableDependencies) {
    }

    public void afterResolve(ResolvableDependencies resolvableDependencies) {
        String taskName = resolvableDependencies.getName();
        if (!taskName.contains("ompile")) {
            return;
        }
        logger.info("Registered task dependencies: " + this.projectName + ":" + taskName);
        if (resolvableDependencies.getResolutionResult() != null && resolvableDependencies.getResolutionResult().getAllDependencies() != null) {
            this.registerDependencies(resolvableDependencies, this.projectName, taskName);
        }
        logger.info("Starting dependency analysis");
        ResolutionResult resolutionResult = resolvableDependencies.getResolutionResult();
        HashMap<Artifact, ArtifactVersion> resolvedVersions = new HashMap<Artifact, ArtifactVersion>();
        for (ResolvedComponentResult resolvedComponentResult : resolutionResult.getAllComponents()) {
            ArtifactVersion version = ArtifactVersion.Companion.fromGradleRefOrNull(resolvedComponentResult.getId().toString());
            if (version == null) continue;
            resolvedVersions.put(version.getArtifact(), version);
        }
        if (resolvedVersions.size() < 1) {
            return;
        }
        Collection<Dependency> activeDeps = this.dependencyAnalyzer.getActiveDependencies(resolvedVersions.values());
        for (Dependency dep : activeDeps) {
            ArtifactVersion resolvedVersion;
            if (dep.isVersionCompatible((resolvedVersion = (ArtifactVersion)resolvedVersions.get(dep.getToArtifact())).getVersion())) continue;
            logger.warn("Dependency resolved to an incompatible version: " + dep);
            Collection<Node> depsPaths = this.dependencyAnalyzer.getPaths(resolvedVersion.getArtifact());
            logger.info("Dependency Resolution Help: Displaying all currently known paths to any version of the dependency: " + dep.getToArtifact());
            logger.info("NOTE: com.google.android.gms translated to c.g.a.g for brevity. Same for com.google.firebase -> c.g.f");
            for (Node n : depsPaths) {
                DependencyInspector.printNode(1, n);
            }
            throw new GradleException(this.getErrorMessage(dep, resolvedVersion, depsPaths));
        }
    }

    @NotNull
    private String getErrorMessage(@Nonnull Dependency dep, @Nonnull ArtifactVersion resolvedVersion, @Nonnull Collection<Node> depPaths) {
        StringBuilder errorMessage = new StringBuilder("In project '").append(this.projectName).append("' a resolved Google Play services library dependency depends on another at an exact version (e.g. \"").append(dep.getToArtifactVersionString()).append("\", but isn't being resolved to that version. Behavior exhibited by the library will be unknown.").append(System.lineSeparator()).append(System.lineSeparator()).append("Dependency failing: ").append(dep.getDisplayString()).append(", but ").append(dep.getToArtifact().getArtifactId()).append(" version was ").append(resolvedVersion.getVersion()).append(".").append(System.lineSeparator()).append(System.lineSeparator()).append("The following dependencies are project dependencies that are direct or have transitive dependencies that lead to the artifact with the issue.");
        HashSet<String> directDependencyStrings = new HashSet<String>();
        StringBuilder currentString = new StringBuilder();
        for (Node node : depPaths) {
            String[] projectNameParts = node.getDependency().getFromArtifactVersion().getArtifactId().split("-");
            if (projectNameParts[0].equals(projectNameParts[2])) {
                currentString.append("-- Project '").append(projectNameParts[0]).append("' depends onto ");
            } else {
                currentString.append("-- Project '").append(projectNameParts[0]).append("' depends on project '").append(projectNameParts[2]).append("' which depends onto ");
            }
            currentString.append(node.getDependency().getToArtifact().getGroupId()).append(":").append(node.getDependency().getToArtifact().getArtifactId()).append("@").append(node.getDependency().getToArtifactVersionString());
            directDependencyStrings.add(currentString.toString());
            currentString.delete(0, currentString.length());
        }
        for (String d : directDependencyStrings) {
            errorMessage.append(System.lineSeparator()).append(d);
        }
        errorMessage.append(System.lineSeparator()).append(System.lineSeparator()).append("For extended debugging info execute Gradle from the command line with ").append("./gradlew --info :").append(this.projectName).append(":assembleDebug to see the dependency paths to the artifact. ");
        if (this.exceptionMessageAddendum != null && !"".equals(this.exceptionMessageAddendum.trim())) {
            errorMessage.append(this.exceptionMessageAddendum);
        }
        return errorMessage.toString().replaceAll(".{120}(?=.)", "$0" + System.lineSeparator());
    }
}

