/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.dependencies;

import com.google.android.gms.dependencies.Version;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\b\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\bJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0011\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00032\b\u0010\u0015\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u0018\u001a\u00020\u0019H\u00d6\u0001J\u0006\u0010\u001a\u001a\u00020\u0019J\u000e\u0010\u001b\u001a\u00020\u00032\u0006\u0010\u001c\u001a\u00020\u0006R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\r\u00a8\u0006\u001e"}, d2={"Lcom/google/android/gms/dependencies/VersionRange;", "", "closedStart", "", "closedEnd", "rangeStart", "Lcom/google/android/gms/dependencies/Version;", "rangeEnd", "(ZZLcom/google/android/gms/dependencies/Version;Lcom/google/android/gms/dependencies/Version;)V", "getClosedEnd", "()Z", "getClosedStart", "getRangeEnd", "()Lcom/google/android/gms/dependencies/Version;", "getRangeStart", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "toVersionString", "versionInRange", "compareTo", "Companion", "strict-version-matcher-plugin"})
public final class VersionRange {
    private final boolean closedStart;
    private final boolean closedEnd;
    @NotNull
    private final Version rangeStart;
    @NotNull
    private final Version rangeEnd;
    private static final Pattern VERSION_RANGE_PATTERN;
    public static final Companion Companion;

    @NotNull
    public final String toVersionString() {
        return (this.closedStart ? "[" : "(") + this.rangeStart.getTrimmedString() + "," + this.rangeEnd.getTrimmedString() + (this.closedEnd ? "]" : ")");
    }

    public final boolean versionInRange(@NotNull Version compareTo) {
        Intrinsics.checkParameterIsNotNull((Object)compareTo, (String)"compareTo");
        if (this.closedStart ? Companion.versionCompare(this.rangeStart.getTrimmedString(), compareTo.getTrimmedString()) > 0 : Companion.versionCompare(this.rangeStart.getTrimmedString(), compareTo.getTrimmedString()) >= 0) {
            return false;
        }
        return !(this.closedEnd ? Companion.versionCompare(this.rangeEnd.getTrimmedString(), compareTo.getTrimmedString()) < 0 : Companion.versionCompare(this.rangeEnd.getTrimmedString(), compareTo.getTrimmedString()) <= 0);
    }

    public final boolean getClosedStart() {
        return this.closedStart;
    }

    public final boolean getClosedEnd() {
        return this.closedEnd;
    }

    @NotNull
    public final Version getRangeStart() {
        return this.rangeStart;
    }

    @NotNull
    public final Version getRangeEnd() {
        return this.rangeEnd;
    }

    public VersionRange(boolean closedStart, boolean closedEnd, @NotNull Version rangeStart, @NotNull Version rangeEnd) {
        Intrinsics.checkParameterIsNotNull((Object)rangeStart, (String)"rangeStart");
        Intrinsics.checkParameterIsNotNull((Object)rangeEnd, (String)"rangeEnd");
        this.closedStart = closedStart;
        this.closedEnd = closedEnd;
        this.rangeStart = rangeStart;
        this.rangeEnd = rangeEnd;
    }

    static {
        Companion = new Companion(null);
        VERSION_RANGE_PATTERN = Pattern.compile("\\[(\\d+\\.)*(\\d+)+(-\\w)*\\]");
    }

    public final boolean component1() {
        return this.closedStart;
    }

    public final boolean component2() {
        return this.closedEnd;
    }

    @NotNull
    public final Version component3() {
        return this.rangeStart;
    }

    @NotNull
    public final Version component4() {
        return this.rangeEnd;
    }

    @NotNull
    public final VersionRange copy(boolean closedStart, boolean closedEnd, @NotNull Version rangeStart, @NotNull Version rangeEnd) {
        Intrinsics.checkParameterIsNotNull((Object)rangeStart, (String)"rangeStart");
        Intrinsics.checkParameterIsNotNull((Object)rangeEnd, (String)"rangeEnd");
        return new VersionRange(closedStart, closedEnd, rangeStart, rangeEnd);
    }

    @NotNull
    public static /* synthetic */ VersionRange copy$default(VersionRange versionRange, boolean bl, boolean bl2, Version version, Version version2, int n, Object object) {
        if ((n & 1) != 0) {
            bl = versionRange.closedStart;
        }
        if ((n & 2) != 0) {
            bl2 = versionRange.closedEnd;
        }
        if ((n & 4) != 0) {
            version = versionRange.rangeStart;
        }
        if ((n & 8) != 0) {
            version2 = versionRange.rangeEnd;
        }
        return versionRange.copy(bl, bl2, version, version2);
    }

    @NotNull
    public String toString() {
        return "VersionRange(closedStart=" + this.closedStart + ", closedEnd=" + this.closedEnd + ", rangeStart=" + this.rangeStart + ", rangeEnd=" + this.rangeEnd + ")";
    }

    public int hashCode() {
        int n = this.closedStart ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        int n2 = n * 31;
        int n3 = this.closedEnd ? 1 : 0;
        if (n3 != 0) {
            n3 = 1;
        }
        Version version = this.rangeStart;
        Version version2 = this.rangeEnd;
        return ((n2 + n3) * 31 + (version != null ? ((Object)version).hashCode() : 0)) * 31 + (version2 != null ? ((Object)version2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof VersionRange)) break block3;
                VersionRange versionRange = (VersionRange)object;
                if (!(this.closedStart == versionRange.closedStart) || !(this.closedEnd == versionRange.closedEnd) || !Intrinsics.areEqual((Object)this.rangeStart, (Object)versionRange.rangeStart) || !Intrinsics.areEqual((Object)this.rangeEnd, (Object)versionRange.rangeEnd)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u000bR\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/google/android/gms/dependencies/VersionRange$Companion;", "", "()V", "VERSION_RANGE_PATTERN", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "getVERSION_RANGE_PATTERN", "()Ljava/util/regex/Pattern;", "fromString", "Lcom/google/android/gms/dependencies/VersionRange;", "versionRange", "", "versionCompare", "", "str1", "str2", "strict-version-matcher-plugin"})
    public static final class Companion {
        public final int versionCompare(@NotNull String str1, @NotNull String str2) {
            int i;
            Intrinsics.checkParameterIsNotNull((Object)str1, (String)"str1");
            Intrinsics.checkParameterIsNotNull((Object)str2, (String)"str2");
            List vals1 = StringsKt.split$default((CharSequence)str1, (String[])new String[]{"\\."}, (boolean)false, (int)0, (int)6, null);
            List vals2 = StringsKt.split$default((CharSequence)str2, (String[])new String[]{"\\."}, (boolean)false, (int)0, (int)6, null);
            for (i = 0; i < vals1.size() && i < vals2.size() && Intrinsics.areEqual((Object)((String)vals1.get(i)), (Object)((String)vals2.get(i))); ++i) {
            }
            if (i < vals1.size() && i < vals2.size()) {
                Integer n = Integer.valueOf((String)vals1.get(i));
                Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"Integer.valueOf(vals1[i])");
                int n2 = n;
                Integer n3 = Integer.valueOf((String)vals2.get(i));
                Intrinsics.checkExpressionValueIsNotNull((Object)n3, (String)"Integer.valueOf(vals2[i])");
                int diff = Integer.compare(n2, n3);
                return Integer.signum(diff);
            }
            return Integer.signum(vals1.size() - vals2.size());
        }

        public final Pattern getVERSION_RANGE_PATTERN() {
            return VERSION_RANGE_PATTERN;
        }

        @Nullable
        public final VersionRange fromString(@NotNull String versionRange) {
            Intrinsics.checkParameterIsNotNull((Object)versionRange, (String)"versionRange");
            Matcher versionRangeMatcher = this.getVERSION_RANGE_PATTERN().matcher(versionRange);
            if (versionRangeMatcher.matches()) {
                Version version = Version.Companion.fromString(versionRangeMatcher.group(1));
                if (version == null) {
                    return null;
                }
                Version v = version;
                return new VersionRange(true, true, v, v);
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

