/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.consent_sdk;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.graphics.Rect;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.DisplayCutout;
import android.view.Window;
import androidx.core.content.pm.PackageInfoCompat;
import com.google.android.gms.internal.consent_sdk.zza;
import com.google.android.gms.internal.consent_sdk.zzbn;
import com.google.android.gms.internal.consent_sdk.zzbp;
import com.google.android.gms.internal.consent_sdk.zzbr;
import com.google.android.gms.internal.consent_sdk.zzbs;
import com.google.android.gms.internal.consent_sdk.zzbt;
import com.google.android.gms.internal.consent_sdk.zzbu;
import com.google.android.gms.internal.consent_sdk.zzbv;
import com.google.android.gms.internal.consent_sdk.zzbw;
import com.google.android.gms.internal.consent_sdk.zzcb;
import com.google.android.gms.internal.consent_sdk.zzcc;
import com.google.android.gms.internal.consent_sdk.zzk;
import com.google.android.gms.internal.consent_sdk.zzn;
import com.google.android.gms.internal.consent_sdk.zzo;
import com.google.android.ump.ConsentDebugSettings;
import com.google.android.ump.ConsentRequestParameters;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.Nullable;

final class zzl {
    private final zzn zza;
    private final @Nullable Activity zzb;
    private final ConsentDebugSettings zzc;
    private final ConsentRequestParameters zzd;

    private zzl(zzn zzn2, @Nullable Activity activity, ConsentDebugSettings consentDebugSettings, ConsentRequestParameters consentRequestParameters) {
        this.zza = zzn2;
        this.zzb = activity;
        this.zzc = consentDebugSettings;
        this.zzd = consentRequestParameters;
    }

    private final zzbn zza() throws zzk {
        List<Object> list;
        Boolean bl;
        Object object;
        zzcb zzcb2;
        String string;
        Object object2;
        zzbn zzbn2 = new zzbn();
        new zzbn().zza = this.zzc();
        Object object3 = zzbn2;
        Object object4 = zzn.zzc(this.zza).zza();
        if (object4 != null) {
            ((zzbn)object3).zzb = ((zza)object4).zza;
            ((zzbn)object3).zzi = ((zza)object4).zzb;
        }
        Object object5 = this;
        if (!((zzl)object5).zzc.isTestDevice()) {
            object2 = Collections.emptyList();
        } else {
            object3 = new ArrayList();
            switch (((zzl)object5).zzc.getDebugGeography()) {
                case 0: {
                    break;
                }
                case 1: {
                    object3.add(zzbs.zzc);
                    break;
                }
                case 2: {
                    object3.add(zzbs.zzd);
                }
            }
            object2 = object3;
        }
        zzbn2.zzn = object2;
        object5 = this;
        object4 = zzn.zzb(((zzl)object5).zza).zzc();
        object3 = zzn.zza(((zzl)object5).zza);
        Object object6 = new HashMap<String, String>();
        Window window = object4.iterator();
        while (window.hasNext()) {
            Object object7;
            String string2;
            string = (String)window.next();
            zzcb2 = zzcc.zza((Context)object3, string);
            if (zzcb2 == null) {
                String string3 = String.valueOf(string);
                string2 = string3.length() != 0 ? "Fetching request info: failed for key: ".concat(string3) : new String("Fetching request info: failed for key: ");
                Log.d((String)"UserMessagingPlatform", (String)string2);
                continue;
            }
            object = object3.getSharedPreferences(zzcb2.zza, 0).getAll().get(zzcb2.zzb);
            if (object == null) {
                String string4 = String.valueOf(string);
                string2 = string4.length() != 0 ? "Stored info not exists: ".concat(string4) : new String("Stored info not exists: ");
                Log.d((String)"UserMessagingPlatform", (String)string2);
                continue;
            }
            if (object instanceof Boolean) {
                object7 = (Boolean)object != false ? "1" : "0";
            } else if (object instanceof Number) {
                object7 = object.toString();
            } else if (object instanceof String) {
                object7 = (String)object;
            } else {
                String string5 = String.valueOf(string);
                string2 = string5.length() != 0 ? "Failed to fetch stored info: ".concat(string5) : new String("Failed to fetch stored info: ");
                Log.d((String)"UserMessagingPlatform", (String)string2);
                continue;
            }
            object6.put((String)string, (String)object7);
        }
        zzbn2.zzj = object6;
        ConsentRequestParameters consentRequestParameters = this.zzd;
        zzbn2.zzd = null;
        consentRequestParameters = this.zzd;
        switch (0) {
            case 1: {
                bl = true;
                break;
            }
            case 2: {
                bl = false;
                break;
            }
            default: {
                bl = null;
            }
        }
        zzbn2.zzg = bl;
        zzbn2.zzh = this.zzd.isTagForUnderAgeOfConsent();
        consentRequestParameters = this.zzd;
        zzbn2.zzf = null;
        zzbn2.zze = Build.VERSION.SDK_INT >= 21 ? Locale.getDefault().toLanguageTag() : Locale.getDefault().toString();
        object5 = new zzbr();
        new zzbr().zzc = Build.VERSION.SDK_INT;
        ((zzbr)object5).zzb = Build.MODEL;
        ((zzbr)object5).zza = zzbu.zzb;
        zzbn2.zzc = object5;
        object5 = this;
        object3 = zzn.zza(((zzl)object5).zza).getResources().getConfiguration();
        zzn.zza(((zzl)object5).zza).getResources().getConfiguration();
        object4 = new zzbt();
        new zzbt().zza = ((Configuration)object3).screenWidthDp;
        ((zzbt)object4).zzb = ((Configuration)object3).screenHeightDp;
        ((zzbt)object4).zzc = zzn.zza((zzn)((zzl)object5).zza).getResources().getDisplayMetrics().density;
        object6 = object5;
        if (Build.VERSION.SDK_INT < 28) {
            list = Collections.emptyList();
        } else {
            window = ((zzl)object6).zzb == null ? null : ((zzl)object6).zzb.getWindow();
            string = window == null ? null : window.getDecorView();
            zzcb2 = string == null ? null : string.getRootWindowInsets();
            DisplayCutout displayCutout = zzcb2 == null ? null : zzcb2.getDisplayCutout();
            if (displayCutout == null) {
                list = Collections.emptyList();
            } else {
                displayCutout.getSafeInsetBottom();
                object = new ArrayList();
                for (String string2 : displayCutout.getBoundingRects()) {
                    if (string2 == null) continue;
                    zzbw zzbw2 = new zzbw();
                    new zzbw().zzb = ((Rect)string2).left;
                    zzbw2.zzc = ((Rect)string2).right;
                    zzbw2.zza = ((Rect)string2).top;
                    zzbw2.zzd = ((Rect)string2).bottom;
                    object.add((zzbw)zzbw2);
                }
                list = object;
            }
        }
        ((zzbt)object4).zzd = list;
        zzbn2.zzk = object4;
        zzbn2.zzl = this.zzb();
        object3 = new zzbv();
        new zzbv().zza = "1.0.0";
        zzbn2.zzm = object3;
        return zzbn2;
    }

    private final zzbp zzb() {
        Application application = zzn.zza(this.zza);
        PackageInfo packageInfo = null;
        try {
            packageInfo = zzn.zza(this.zza).getPackageManager().getPackageInfo(application.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        zzbp zzbp2 = new zzbp();
        new zzbp().zza = application.getPackageName();
        zzl zzl2 = this;
        CharSequence charSequence = zzn.zza(zzl2.zza).getPackageManager().getApplicationLabel(zzn.zza(zzl2.zza).getApplicationInfo());
        String string = zzbp2.zzb = charSequence != null ? charSequence.toString() : null;
        if (packageInfo != null) {
            zzbp2.zzc = Long.toString(PackageInfoCompat.getLongVersionCode((PackageInfo)packageInfo));
        }
        return zzbp2;
    }

    private final String zzc() throws zzk {
        String string = this.zzd.zza();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        Bundle bundle = null;
        try {
            bundle = zzn.zza((zzn)this.zza).getPackageManager().getApplicationInfo((String)zzn.zza((zzn)this.zza).getPackageName(), (int)128).metaData;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {}
        if (bundle != null) {
            string = bundle.getString("com.google.android.gms.ads.APPLICATION_ID");
        }
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        throw new zzk(3, "The UMP SDK requires a valid application ID in your AndroidManifest.xml through a com.google.android.gms.ads.APPLICATION_ID meta-data tag.\nExample AndroidManifest:\n    <meta-data\n        android:name=\"com.google.android.gms.ads.APPLICATION_ID\"\n        android:value=\"ca-app-pub-0000000000000000~0000000000\">");
    }

    /* synthetic */ zzl(zzn zzn2, Activity activity, ConsentDebugSettings consentDebugSettings, ConsentRequestParameters consentRequestParameters, zzo zzo2) {
        this(zzn2, activity, consentDebugSettings, consentRequestParameters);
    }

    static /* synthetic */ zzbn zza(zzl zzl2) throws zzk {
        return zzl2.zza();
    }
}

