/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.core;

import com.google.api.gax.core.Distribution;
import com.google.common.truth.Truth;
import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class DistributionTest {
    DistributionTest() {
    }

    @Test
    void testPercentile() {
        Distribution dist = this.of(15, 20, 35, 40, 50);
        Truth.assertThat((Integer)dist.getPercentile(5.0)).isEqualTo((Object)15);
        Truth.assertThat((Integer)dist.getPercentile(30.0)).isEqualTo((Object)20);
        Truth.assertThat((Integer)dist.getPercentile(40.0)).isEqualTo((Object)20);
        Truth.assertThat((Integer)dist.getPercentile(50.0)).isEqualTo((Object)35);
        Truth.assertThat((Integer)dist.getPercentile(100.0)).isEqualTo((Object)50);
        dist = this.of(3, 6, 7, 8, 8, 10, 13, 15, 16, 20);
        Truth.assertThat((Integer)dist.getPercentile(25.0)).isEqualTo((Object)7);
        Truth.assertThat((Integer)dist.getPercentile(50.0)).isEqualTo((Object)8);
        Truth.assertThat((Integer)dist.getPercentile(75.0)).isEqualTo((Object)15);
        Truth.assertThat((Integer)dist.getPercentile(100.0)).isEqualTo((Object)20);
        dist = this.of(3, 6, 7, 8, 8, 9, 10, 13, 15, 16, 20);
        Truth.assertThat((Integer)dist.getPercentile(25.0)).isEqualTo((Object)7);
        Truth.assertThat((Integer)dist.getPercentile(50.0)).isEqualTo((Object)9);
        Truth.assertThat((Integer)dist.getPercentile(75.0)).isEqualTo((Object)15);
        Truth.assertThat((Integer)dist.getPercentile(100.0)).isEqualTo((Object)20);
    }

    @Test
    void testZeroMaxValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Distribution(0));
    }

    @Test
    void testNegativeMaxValue() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new Distribution(-1));
    }

    @Test
    void testOverflowMaxValue() {
        Distribution dist = new Distribution(10);
        dist.record(10);
        Truth.assertThat((Integer)dist.getPercentile(100.0)).isEqualTo((Object)9);
    }

    private Distribution of(Integer ... values) {
        int max = Collections.max(Arrays.asList(values));
        Distribution dist = new Distribution(max + 1);
        Integer[] integerArray = values;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int value = integerArray[i];
            dist.record(value);
        }
        return dist;
    }
}

