/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.api.generator.engine.ast.AstNodeVisitor;
import com.google.api.generator.engine.ast.AutoValue_ArithmeticOperationExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.OperationExpr;
import com.google.api.generator.engine.ast.OperatorKind;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;

@AutoValue
public abstract class ArithmeticOperationExpr
implements OperationExpr {
    public abstract Expr lhsExpr();

    public abstract Expr rhsExpr();

    @Override
    public abstract OperatorKind operatorKind();

    @Override
    public abstract TypeNode type();

    @Override
    public void accept(AstNodeVisitor visitor) {
        visitor.visit(this);
    }

    public static ArithmeticOperationExpr concatWithExprs(Expr lhsExpr, Expr rhsExpr) {
        return ArithmeticOperationExpr.builder().setLhsExpr(lhsExpr).setRhsExpr(rhsExpr).setOperatorKind(OperatorKind.ARITHMETIC_ADDITION).setType(TypeNode.STRING).build();
    }

    private static Builder builder() {
        return new AutoValue_ArithmeticOperationExpr.Builder();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setLhsExpr(Expr var1);

        abstract Builder setRhsExpr(Expr var1);

        abstract Builder setOperatorKind(OperatorKind var1);

        abstract Builder setType(TypeNode var1);

        abstract ArithmeticOperationExpr autoBuild();

        private ArithmeticOperationExpr build() {
            ArithmeticOperationExpr arithmeticOperationExpr = this.autoBuild();
            TypeNode lhsExprType = arithmeticOperationExpr.lhsExpr().type();
            TypeNode rhsExprType = arithmeticOperationExpr.rhsExpr().type();
            OperatorKind operator = arithmeticOperationExpr.operatorKind();
            String errorMsg = String.format("Arithmetic operator %s can not be applied to %s, %s.", new Object[]{operator, lhsExprType.toString(), rhsExprType.toString()});
            Preconditions.checkState(!lhsExprType.equals(TypeNode.VOID) && !rhsExprType.equals(TypeNode.VOID), errorMsg);
            if (operator.equals((Object)OperatorKind.ARITHMETIC_ADDITION)) {
                Preconditions.checkState(this.isValidConcatTypes(lhsExprType, rhsExprType), errorMsg);
            }
            return arithmeticOperationExpr;
        }

        private boolean isValidConcatTypes(TypeNode lhsType, TypeNode rhsType) {
            return lhsType.equals(TypeNode.STRING) || rhsType.equals(TypeNode.STRING);
        }
    }
}

