/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.engine.ast;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public class NodeValidator {
    public static void checkNoNullElements(Collection<?> collection, String fieldTypeName, String nodeContextInfo) {
        Preconditions.checkState(collection.stream().allMatch(e -> !Objects.isNull(e)), String.format("Found null expression in %s %s for %s", fieldTypeName, collection, nodeContextInfo));
    }

    public static void checkNoNullElements(Map<?, ?> map, String fieldTypeName, String nodeContextInfo) {
        NodeValidator.checkNoNullElements(map.keySet(), String.format("key of %s", fieldTypeName), nodeContextInfo);
        NodeValidator.checkNoNullElements(map.values(), String.format("values of %s", fieldTypeName), nodeContextInfo);
    }
}

