/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.grpc;

import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.testing.LocalChannelProvider;
import com.google.api.gax.grpc.testing.MockGrpcService;
import com.google.api.gax.grpc.testing.MockServiceHelper;
import com.google.api.gax.grpc.testing.MockStreamObserver;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.generator.engine.ast.AnnotationNode;
import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.CastExpr;
import com.google.api.generator.engine.ast.ConcreteReference;
import com.google.api.generator.engine.ast.EnumRefExpr;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.ExprStatement;
import com.google.api.generator.engine.ast.InstanceofExpr;
import com.google.api.generator.engine.ast.MethodDefinition;
import com.google.api.generator.engine.ast.MethodInvocationExpr;
import com.google.api.generator.engine.ast.NewObjectExpr;
import com.google.api.generator.engine.ast.PrimitiveValue;
import com.google.api.generator.engine.ast.ScopeNode;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.ast.StringObjectValue;
import com.google.api.generator.engine.ast.TryCatchStatement;
import com.google.api.generator.engine.ast.TypeNode;
import com.google.api.generator.engine.ast.ValueExpr;
import com.google.api.generator.engine.ast.Variable;
import com.google.api.generator.engine.ast.VariableExpr;
import com.google.api.generator.gapic.composer.common.AbstractServiceClientTestClassComposer;
import com.google.api.generator.gapic.composer.defaultvalue.DefaultValueComposer;
import com.google.api.generator.gapic.composer.grpc.GrpcContext;
import com.google.api.generator.gapic.composer.store.TypeStore;
import com.google.api.generator.gapic.composer.utils.ClassNames;
import com.google.api.generator.gapic.model.Field;
import com.google.api.generator.gapic.model.GapicContext;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.model.Method;
import com.google.api.generator.gapic.model.MethodArgument;
import com.google.api.generator.gapic.model.ResourceName;
import com.google.api.generator.gapic.model.Service;
import com.google.api.generator.gapic.utils.JavaStyle;
import com.google.common.base.Preconditions;
import com.google.protobuf.AbstractMessage;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ServiceClientTestClassComposer
extends AbstractServiceClientTestClassComposer {
    private static final String SERVICE_HELPER_VAR_NAME = "mockServiceHelper";
    private static final String CHANNEL_PROVIDER_VAR_NAME = "channelProvider";
    private static final ServiceClientTestClassComposer INSTANCE = new ServiceClientTestClassComposer();
    private static final TypeStore FIXED_GRPC_TYPESTORE = ServiceClientTestClassComposer.createStaticTypes();
    private static final TypeNode LIST_TYPE = TypeNode.withReference(ConcreteReference.withClazz(List.class));
    private static final TypeNode MAP_TYPE = TypeNode.withReference(ConcreteReference.withClazz(Map.class));
    private static final TypeNode RESOURCE_NAME_TYPE = TypeNode.withReference(ConcreteReference.withClazz(com.google.api.resourcenames.ResourceName.class));
    private static final TypeNode GRPC_STATUS_TYPE = TypeNode.withReference(ConcreteReference.builder().setClazz(Status.class).setUseFullName(true).build());

    protected ServiceClientTestClassComposer() {
        super(GrpcContext.instance());
    }

    public static AbstractServiceClientTestClassComposer instance() {
        return INSTANCE;
    }

    private static TypeStore createStaticTypes() {
        List<Class<?>> concreteClazzes = Arrays.asList(GaxGrpcProperties.class, LocalChannelProvider.class, MockGrpcService.class, MockServiceHelper.class, MockStreamObserver.class, StatusRuntimeException.class);
        return new TypeStore(concreteClazzes);
    }

    @Override
    protected Map<String, VariableExpr> createClassMemberVarExprs(Service service, GapicContext context, TypeStore typeStore) {
        BiFunction<String, TypeNode, VariableExpr> varExprFn = (name, type) -> VariableExpr.withVariable(Variable.builder().setName((String)name).setType((TypeNode)type).build());
        TreeMap<String, TypeNode> fields = new TreeMap<String, TypeNode>();
        fields.put(this.getMockServiceVarName(service), typeStore.get(ClassNames.getMockServiceClassName(service)));
        for (Service mixinService : context.mixinServices()) {
            fields.put(this.getMockServiceVarName(mixinService), typeStore.get(ClassNames.getMockServiceClassName(mixinService)));
        }
        fields.put(SERVICE_HELPER_VAR_NAME, FIXED_GRPC_TYPESTORE.get("MockServiceHelper"));
        fields.put("client", typeStore.get(ClassNames.getServiceClientClassName(service)));
        fields.put(CHANNEL_PROVIDER_VAR_NAME, FIXED_GRPC_TYPESTORE.get("LocalChannelProvider"));
        return fields.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> (VariableExpr)varExprFn.apply((String)e.getKey(), (TypeNode)e.getValue()), (u, v) -> {
            throw new IllegalStateException();
        }, TreeMap::new));
    }

    @Override
    protected MethodDefinition createStartStaticServerMethod(Service service, GapicContext context, Map<String, VariableExpr> classMemberVarExprs, TypeStore typeStore, String newBuilderMethod) {
        VariableExpr serviceHelperVarExpr = classMemberVarExprs.get(SERVICE_HELPER_VAR_NAME);
        Function<Service, VariableExpr> serviceToVarExprFn = s2 -> (VariableExpr)classMemberVarExprs.get(this.getMockServiceVarName((Service)s2));
        Function<Service, Expr> serviceToVarInitExprFn = s2 -> {
            VariableExpr mockServiceVarExpr = (VariableExpr)serviceToVarExprFn.apply((Service)s2);
            return AssignmentExpr.builder().setVariableExpr(mockServiceVarExpr).setValueExpr(NewObjectExpr.builder().setType(mockServiceVarExpr.type()).build()).build();
        };
        ArrayList<Expr> varInitExprs = new ArrayList<Expr>();
        ArrayList<Expr> mockServiceVarExprs = new ArrayList<Expr>();
        varInitExprs.add(serviceToVarInitExprFn.apply(service));
        mockServiceVarExprs.add(serviceToVarExprFn.apply(service));
        for (Service mixinService : context.mixinServices().stream().sorted((s1, s2) -> s2.name().compareTo(s1.name())).collect(Collectors.toList())) {
            varInitExprs.add(serviceToVarInitExprFn.apply(mixinService));
            mockServiceVarExprs.add(serviceToVarExprFn.apply(mixinService));
        }
        MethodInvocationExpr firstArg = MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("UUID")).setMethodName("randomUUID").build();
        firstArg = MethodInvocationExpr.builder().setExprReferenceExpr(firstArg).setMethodName("toString").build();
        MethodInvocationExpr secondArg = MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Arrays")).setGenerics(Arrays.asList(FIXED_GRPC_TYPESTORE.get("MockGrpcService").reference())).setMethodName("asList").setArguments(mockServiceVarExprs).build();
        AssignmentExpr initServiceHelperExpr = AssignmentExpr.builder().setVariableExpr(serviceHelperVarExpr).setValueExpr(NewObjectExpr.builder().setType(serviceHelperVarExpr.type()).setArguments(Arrays.asList(firstArg, secondArg)).build()).build();
        MethodInvocationExpr startServiceHelperExpr = MethodInvocationExpr.builder().setExprReferenceExpr(serviceHelperVarExpr).setMethodName("start").build();
        varInitExprs.add(initServiceHelperExpr);
        varInitExprs.add(startServiceHelperExpr);
        return MethodDefinition.builder().setAnnotations(Arrays.asList(AnnotationNode.withType(FIXED_TYPESTORE.get("BeforeClass")))).setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(TypeNode.VOID).setName("startStaticServer").setBody(varInitExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList())).build();
    }

    @Override
    protected MethodDefinition createStopServerMethod(Service service, Map<String, VariableExpr> classMemberVarExprs) {
        return MethodDefinition.builder().setAnnotations(Arrays.asList(AnnotationNode.withType(FIXED_TYPESTORE.get("AfterClass")))).setScope(ScopeNode.PUBLIC).setIsStatic(true).setReturnType(TypeNode.VOID).setName("stopServer").setBody(Arrays.asList(ExprStatement.withExpr(MethodInvocationExpr.builder().setExprReferenceExpr(classMemberVarExprs.get(SERVICE_HELPER_VAR_NAME)).setMethodName("stop").build()))).build();
    }

    @Override
    protected MethodDefinition createSetUpMethod(Service service, Map<String, VariableExpr> classMemberVarExprs, TypeStore typeStore) {
        VariableExpr clientVarExpr = classMemberVarExprs.get("client");
        VariableExpr serviceHelperVarExpr = classMemberVarExprs.get(SERVICE_HELPER_VAR_NAME);
        VariableExpr channelProviderVarExpr = classMemberVarExprs.get(CHANNEL_PROVIDER_VAR_NAME);
        MethodInvocationExpr resetServiceHelperExpr = MethodInvocationExpr.builder().setExprReferenceExpr(serviceHelperVarExpr).setMethodName("reset").build();
        AssignmentExpr channelProviderInitExpr = AssignmentExpr.builder().setVariableExpr(channelProviderVarExpr).setValueExpr(MethodInvocationExpr.builder().setExprReferenceExpr(serviceHelperVarExpr).setMethodName("createChannelProvider").setReturnType(channelProviderVarExpr.type()).build()).build();
        TypeNode settingsType = typeStore.get(ClassNames.getServiceSettingsClassName(service));
        VariableExpr localSettingsVarExpr = VariableExpr.withVariable(Variable.builder().setName("settings").setType(settingsType).build());
        Expr settingsBuilderExpr = MethodInvocationExpr.builder().setStaticReferenceType(settingsType).setMethodName("newBuilder").build();
        Function<Expr, BiFunction> methodBuilderFn = methodExpr -> (mName, argExpr) -> MethodInvocationExpr.builder().setExprReferenceExpr((Expr)methodExpr).setMethodName((String)mName).setArguments(Arrays.asList(argExpr)).build();
        settingsBuilderExpr = (Expr)methodBuilderFn.apply(settingsBuilderExpr).apply("setTransportChannelProvider", (Expr)classMemberVarExprs.get(CHANNEL_PROVIDER_VAR_NAME));
        settingsBuilderExpr = (Expr)methodBuilderFn.apply(settingsBuilderExpr).apply("setCredentialsProvider", MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("NoCredentialsProvider")).setMethodName("create").build());
        settingsBuilderExpr = MethodInvocationExpr.builder().setExprReferenceExpr(settingsBuilderExpr).setMethodName("build").setReturnType(localSettingsVarExpr.type()).build();
        AssignmentExpr initLocalSettingsExpr = AssignmentExpr.builder().setVariableExpr(localSettingsVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(settingsBuilderExpr).build();
        AssignmentExpr initClientExpr = AssignmentExpr.builder().setVariableExpr(clientVarExpr).setValueExpr(MethodInvocationExpr.builder().setStaticReferenceType(typeStore.get(ClassNames.getServiceClientClassName(service))).setMethodName("create").setArguments(Arrays.asList(localSettingsVarExpr)).setReturnType(clientVarExpr.type()).build()).build();
        return MethodDefinition.builder().setAnnotations(Arrays.asList(AnnotationNode.withType(FIXED_TYPESTORE.get("Before")))).setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.VOID).setName("setUp").setThrowsExceptions(Arrays.asList(FIXED_TYPESTORE.get("IOException"))).setBody(Arrays.asList(resetServiceHelperExpr, channelProviderInitExpr, initLocalSettingsExpr, initClientExpr).stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList())).build();
    }

    @Override
    protected MethodDefinition createTearDownMethod(Service service, Map<String, VariableExpr> classMemberVarExprs) {
        return MethodDefinition.builder().setAnnotations(Arrays.asList(AnnotationNode.withType(FIXED_TYPESTORE.get("After")))).setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.VOID).setName("tearDown").setThrowsExceptions(Arrays.asList(TypeNode.withReference(ConcreteReference.withClazz(Exception.class)))).setBody(Arrays.asList(ExprStatement.withExpr(MethodInvocationExpr.builder().setExprReferenceExpr(classMemberVarExprs.get("client")).setMethodName("close").build()))).build();
    }

    @Override
    protected List<Statement> constructRpcTestCheckerLogic(Method method, List<MethodArgument> methodSignature, Service service, boolean isRequestArg, Map<String, VariableExpr> classMemberVarExprs, VariableExpr requestVarExpr, Message requestMessage) {
        ArrayList<Expr> methodExprs = new ArrayList<Expr>();
        ArrayList<Statement> methodStatements = new ArrayList<Statement>();
        VariableExpr actualRequestsVarExpr = VariableExpr.withVariable(Variable.builder().setType(TypeNode.withReference(ConcreteReference.builder().setClazz(List.class).setGenerics(Arrays.asList(ConcreteReference.withClazz(AbstractMessage.class))).build())).setName("actualRequests").build());
        methodExprs.add(AssignmentExpr.builder().setVariableExpr(actualRequestsVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(MethodInvocationExpr.builder().setExprReferenceExpr(classMemberVarExprs.get(this.getMockServiceVarName(service))).setMethodName("getRequests").setReturnType(actualRequestsVarExpr.type()).build()).build());
        methodExprs.add(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Assert")).setMethodName("assertEquals").setArguments(ValueExpr.withValue(PrimitiveValue.builder().setType(TypeNode.INT).setValue("1").build()), MethodInvocationExpr.builder().setExprReferenceExpr(actualRequestsVarExpr).setMethodName("size").build()).build());
        VariableExpr actualRequestVarExpr = VariableExpr.withVariable(Variable.builder().setType(method.inputType()).setName("actualRequest").build());
        Expr getFirstRequestExpr = MethodInvocationExpr.builder().setExprReferenceExpr(actualRequestsVarExpr).setMethodName("get").setArguments(ValueExpr.withValue(PrimitiveValue.builder().setType(TypeNode.INT).setValue("0").build())).setReturnType(FIXED_TYPESTORE.get("AbstractMessage")).build();
        getFirstRequestExpr = CastExpr.builder().setType(method.inputType()).setExpr(getFirstRequestExpr).build();
        methodExprs.add(AssignmentExpr.builder().setVariableExpr(actualRequestVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(getFirstRequestExpr).build());
        methodStatements.addAll(methodExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList()));
        methodExprs.clear();
        methodStatements.add(EMPTY_LINE_STATEMENT);
        if (isRequestArg) {
            Preconditions.checkNotNull(requestVarExpr);
            Preconditions.checkNotNull(requestMessage);
            for (Field field : requestMessage.fields()) {
                MethodInvocationExpr expectedFieldExpr = ServiceClientTestClassComposer.createGetter(requestVarExpr, field);
                MethodInvocationExpr actualFieldExpr = ServiceClientTestClassComposer.createGetter(actualRequestVarExpr, field);
                methodExprs.add(ServiceClientTestClassComposer.createAssertEquals(expectedFieldExpr, actualFieldExpr, field.type()));
            }
        } else {
            for (MethodArgument arg : methodSignature) {
                Expr root = actualRequestVarExpr;
                for (Field field : arg.nestedFields()) {
                    root = ServiceClientTestClassComposer.createGetter(root, field);
                }
                MethodInvocationExpr actual = ServiceClientTestClassComposer.createGetter(root, arg.field());
                Expr expectedFieldExpr = VariableExpr.withVariable(Variable.builder().setName(JavaStyle.toLowerCamelCase(arg.name())).setType(arg.type()).build());
                if (RESOURCE_NAME_TYPE.isSupertypeOrEquals(arg.type())) {
                    expectedFieldExpr = MethodInvocationExpr.builder().setExprReferenceExpr(expectedFieldExpr).setMethodName("toString").build();
                }
                methodExprs.add(ServiceClientTestClassComposer.createAssertEquals(expectedFieldExpr, actual, arg.type()));
            }
        }
        MethodInvocationExpr headerKeyExpr = MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("ApiClientHeaderProvider")).setMethodName("getDefaultApiClientHeaderKey").build();
        MethodInvocationExpr headerPatternExpr = MethodInvocationExpr.builder().setStaticReferenceType(FIXED_GRPC_TYPESTORE.get("GaxGrpcProperties")).setMethodName("getDefaultApiClientHeaderPattern").build();
        MethodInvocationExpr headerSentExpr = MethodInvocationExpr.builder().setExprReferenceExpr(classMemberVarExprs.get(CHANNEL_PROVIDER_VAR_NAME)).setMethodName("isHeaderSent").setArguments(headerKeyExpr, headerPatternExpr).build();
        methodExprs.add(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Assert")).setMethodName("assertTrue").setArguments(headerSentExpr).build());
        methodStatements.addAll(methodExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList()));
        methodExprs.clear();
        return methodStatements;
    }

    private static MethodInvocationExpr createAssertEquals(Expr expected, Expr actual, TypeNode type) {
        ArrayList<Expr> assertionArgs = new ArrayList<Expr>();
        assertionArgs.add(expected);
        assertionArgs.add(actual);
        if (TypeNode.isFloatingPointType(type)) {
            boolean isFloat = type.equals(TypeNode.FLOAT);
            assertionArgs.add(ValueExpr.withValue(PrimitiveValue.builder().setType(isFloat ? TypeNode.FLOAT : TypeNode.DOUBLE).setValue(String.format("0.0001%s", isFloat ? "f" : "")).build()));
        }
        return MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Assert")).setMethodName("assertEquals").setArguments(assertionArgs).build();
    }

    private static MethodInvocationExpr createGetter(Expr exprReference, Field field) {
        return MethodInvocationExpr.builder().setExprReferenceExpr(exprReference).setMethodName(String.format(ServiceClientTestClassComposer.createGetterNamePattern(field.type()), JavaStyle.toUpperCamelCase(field.name()))).build();
    }

    private static String createGetterNamePattern(TypeNode type) {
        String fieldGetterMethodNamePattern = "get%s";
        if (LIST_TYPE.isSupertypeOrEquals(type)) {
            fieldGetterMethodNamePattern = "get%sList";
        } else if (MAP_TYPE.isSupertypeOrEquals(type)) {
            fieldGetterMethodNamePattern = "get%sMap";
        }
        return fieldGetterMethodNamePattern;
    }

    @Override
    protected MethodDefinition createStreamingRpcTestMethod(Service service, Method method, Map<String, VariableExpr> classMemberVarExprs, Map<String, ResourceName> resourceNames, Map<String, Message> messageTypes) {
        TypeNode methodOutputType = method.hasLro() ? method.lro().responseType() : method.outputType();
        ArrayList<Expr> methodExprs = new ArrayList<Expr>();
        VariableExpr expectedResponseVarExpr = VariableExpr.withVariable(Variable.builder().setType(methodOutputType).setName("expectedResponse").build());
        Expr expectedResponseValExpr = null;
        expectedResponseValExpr = messageTypes.containsKey(methodOutputType.reference().fullName()) ? DefaultValueComposer.createSimpleMessageBuilderValue(messageTypes.get(methodOutputType.reference().fullName()), resourceNames, messageTypes, method.httpBindings()) : DefaultValueComposer.createValue(Field.builder().setType(methodOutputType).setIsMessage(true).setName("expectedResponse").build());
        methodExprs.add(AssignmentExpr.builder().setVariableExpr(expectedResponseVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(expectedResponseValExpr).build());
        String mockServiceVarName = this.getMockServiceVarName(service);
        if (method.hasLro()) {
            VariableExpr resultOperationVarExpr = VariableExpr.withVariable(Variable.builder().setType(FIXED_GRPC_TYPESTORE.get("Operation")).setName("resultOperation").build());
            methodExprs.add(AssignmentExpr.builder().setVariableExpr(resultOperationVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(DefaultValueComposer.createSimpleOperationBuilderValue(String.format("%sTest", JavaStyle.toLowerCamelCase(method.name())), expectedResponseVarExpr)).build());
            methodExprs.add(MethodInvocationExpr.builder().setExprReferenceExpr(classMemberVarExprs.get(mockServiceVarName)).setMethodName("addResponse").setArguments(resultOperationVarExpr).build());
        } else {
            methodExprs.add(MethodInvocationExpr.builder().setExprReferenceExpr(classMemberVarExprs.get(mockServiceVarName)).setMethodName("addResponse").setArguments(expectedResponseVarExpr).build());
        }
        VariableExpr requestVarExpr = VariableExpr.withVariable(Variable.builder().setType(method.inputType()).setName("request").build());
        Message requestMessage = messageTypes.get(method.inputType().reference().fullName());
        Preconditions.checkNotNull(requestMessage);
        Expr valExpr = DefaultValueComposer.createSimpleMessageBuilderValue(requestMessage, resourceNames, messageTypes, method.httpBindings());
        methodExprs.add(AssignmentExpr.builder().setVariableExpr(requestVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(valExpr).build());
        ArrayList<Statement> methodStatements = new ArrayList<Statement>();
        methodStatements.addAll(methodExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList()));
        methodExprs.clear();
        methodStatements.add(EMPTY_LINE_STATEMENT);
        VariableExpr responseObserverVarExpr = VariableExpr.withVariable(Variable.builder().setType(TypeNode.withReference(FIXED_GRPC_TYPESTORE.get("MockStreamObserver").reference().copyAndSetGenerics(Arrays.asList(method.outputType().reference())))).setName("responseObserver").build());
        methodStatements.add(ExprStatement.withExpr(AssignmentExpr.builder().setVariableExpr(responseObserverVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(NewObjectExpr.builder().setType(FIXED_GRPC_TYPESTORE.get("MockStreamObserver")).setIsGeneric(true).build()).build()));
        methodStatements.add(EMPTY_LINE_STATEMENT);
        VariableExpr callableVarExpr = VariableExpr.withVariable(Variable.builder().setType(ServiceClientTestClassComposer.getCallableType(method)).setName("callable").build());
        MethodInvocationExpr streamingCallExpr = MethodInvocationExpr.builder().setExprReferenceExpr(classMemberVarExprs.get("client")).setMethodName(String.format("%sCallable", JavaStyle.toLowerCamelCase(method.name()))).setReturnType(callableVarExpr.type()).build();
        methodExprs.add(AssignmentExpr.builder().setVariableExpr(callableVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(streamingCallExpr).build());
        if (method.stream().equals((Object)Method.Stream.SERVER)) {
            methodExprs.add(MethodInvocationExpr.builder().setExprReferenceExpr(callableVarExpr).setMethodName("serverStreamingCall").setArguments(requestVarExpr, responseObserverVarExpr).build());
        } else {
            VariableExpr requestObserverVarExpr = VariableExpr.withVariable(Variable.builder().setType(TypeNode.withReference(FIXED_TYPESTORE.get("ApiStreamObserver").reference().copyAndSetGenerics(Arrays.asList(method.inputType().reference())))).setName("requestObserver").build());
            ArrayList<Expr> callableMethodArgs = new ArrayList<Expr>();
            if (!method.stream().equals((Object)Method.Stream.BIDI) && !method.stream().equals((Object)Method.Stream.CLIENT)) {
                callableMethodArgs.add(requestVarExpr);
            }
            callableMethodArgs.add(responseObserverVarExpr);
            methodExprs.add(AssignmentExpr.builder().setVariableExpr(requestObserverVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(MethodInvocationExpr.builder().setExprReferenceExpr(callableVarExpr).setMethodName(ServiceClientTestClassComposer.getCallableMethodName(method)).setArguments(callableMethodArgs).setReturnType(requestObserverVarExpr.type()).build()).build());
            methodStatements.addAll(methodExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList()));
            methodExprs.clear();
            methodStatements.add(EMPTY_LINE_STATEMENT);
            methodExprs.add(MethodInvocationExpr.builder().setExprReferenceExpr(requestObserverVarExpr).setMethodName("onNext").setArguments(requestVarExpr).build());
            methodExprs.add(MethodInvocationExpr.builder().setExprReferenceExpr(requestObserverVarExpr).setMethodName("onCompleted").build());
        }
        methodStatements.addAll(methodExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList()));
        methodExprs.clear();
        methodStatements.add(EMPTY_LINE_STATEMENT);
        VariableExpr actualResponsesVarExpr = VariableExpr.withVariable(Variable.builder().setType(TypeNode.withReference(ConcreteReference.builder().setClazz(List.class).setGenerics(Arrays.asList(method.outputType().reference())).build())).setName("actualResponses").build());
        MethodInvocationExpr getFutureResponseExpr = MethodInvocationExpr.builder().setExprReferenceExpr(responseObserverVarExpr).setMethodName("future").build();
        getFutureResponseExpr = MethodInvocationExpr.builder().setExprReferenceExpr(getFutureResponseExpr).setMethodName("get").setReturnType(actualResponsesVarExpr.type()).build();
        methodExprs.add(AssignmentExpr.builder().setVariableExpr(actualResponsesVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(getFutureResponseExpr).build());
        methodExprs.add(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Assert")).setMethodName("assertEquals").setArguments(ValueExpr.withValue(PrimitiveValue.builder().setType(TypeNode.INT).setValue("1").build()), MethodInvocationExpr.builder().setExprReferenceExpr(actualResponsesVarExpr).setMethodName("size").setReturnType(TypeNode.INT).build()).build());
        ValueExpr zeroExpr = ValueExpr.withValue(PrimitiveValue.builder().setType(TypeNode.INT).setValue("0").build());
        MethodInvocationExpr actualResponseExpr = MethodInvocationExpr.builder().setExprReferenceExpr(actualResponsesVarExpr).setMethodName("get").setArguments(zeroExpr).build();
        methodExprs.add(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Assert")).setMethodName("assertEquals").setArguments(expectedResponseVarExpr, actualResponseExpr).build());
        methodStatements.addAll(methodExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList()));
        methodExprs.clear();
        methodStatements.add(EMPTY_LINE_STATEMENT);
        String testMethodName = String.format("%sTest", JavaStyle.toLowerCamelCase(method.name()));
        return MethodDefinition.builder().setAnnotations(Arrays.asList(TEST_ANNOTATION)).setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.VOID).setName(testMethodName).setThrowsExceptions(Arrays.asList(TypeNode.withExceptionClazz(Exception.class))).setBody(methodStatements).build();
    }

    @Override
    protected MethodDefinition createRpcExceptionTestMethod(Method method, Service service, List<MethodArgument> methodSignature, int variantIndex, Map<String, VariableExpr> classMemberVarExprs, Map<String, ResourceName> resourceNames, Map<String, Message> messageTypes) {
        VariableExpr exceptionVarExpr = VariableExpr.withVariable(Variable.builder().setType(FIXED_GRPC_TYPESTORE.get("StatusRuntimeException")).setName("exception").build());
        AssignmentExpr exceptionAssignExpr = AssignmentExpr.builder().setVariableExpr(exceptionVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(NewObjectExpr.builder().setType(FIXED_GRPC_TYPESTORE.get("StatusRuntimeException")).setArguments(EnumRefExpr.builder().setType(GRPC_STATUS_TYPE).setName("INVALID_ARGUMENT").build()).build()).build();
        MethodInvocationExpr addExceptionExpr = MethodInvocationExpr.builder().setExprReferenceExpr(classMemberVarExprs.get(this.getMockServiceVarName(service))).setMethodName("addException").setArguments(exceptionVarExpr).build();
        String exceptionTestMethodName = String.format("%sExceptionTest%s", JavaStyle.toLowerCamelCase(method.name()), variantIndex > 0 ? Integer.valueOf(variantIndex + 1) : "");
        boolean isStreaming = !method.stream().equals((Object)Method.Stream.NONE);
        ArrayList<Statement> methodBody = new ArrayList<Statement>();
        methodBody.add(ExprStatement.withExpr(exceptionAssignExpr));
        methodBody.add(ExprStatement.withExpr(addExceptionExpr));
        if (isStreaming) {
            methodBody.addAll(this.createStreamingRpcExceptionTestStatements(method, classMemberVarExprs, resourceNames, messageTypes));
        } else {
            methodBody.addAll(this.createRpcExceptionTestStatements(method, methodSignature, classMemberVarExprs, resourceNames, messageTypes));
        }
        return MethodDefinition.builder().setAnnotations(Arrays.asList(TEST_ANNOTATION)).setScope(ScopeNode.PUBLIC).setReturnType(TypeNode.VOID).setName(exceptionTestMethodName).setThrowsExceptions(Arrays.asList(TypeNode.withExceptionClazz(Exception.class))).setBody(methodBody).build();
    }

    @Override
    protected List<Statement> createStreamingRpcExceptionTestStatements(Method method, Map<String, VariableExpr> classMemberVarExprs, Map<String, ResourceName> resourceNames, Map<String, Message> messageTypes) {
        VariableExpr requestVarExpr = VariableExpr.withVariable(Variable.builder().setType(method.inputType()).setName("request").build());
        Message requestMessage = messageTypes.get(method.inputType().reference().fullName());
        Preconditions.checkNotNull(requestMessage);
        Expr valExpr = DefaultValueComposer.createSimpleMessageBuilderValue(requestMessage, resourceNames, messageTypes, method.httpBindings());
        ArrayList<Statement> statements = new ArrayList<Statement>();
        statements.add(ExprStatement.withExpr(AssignmentExpr.builder().setVariableExpr(requestVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(valExpr).build()));
        statements.add(EMPTY_LINE_STATEMENT);
        VariableExpr responseObserverVarExpr = VariableExpr.withVariable(Variable.builder().setType(TypeNode.withReference(FIXED_GRPC_TYPESTORE.get("MockStreamObserver").reference().copyAndSetGenerics(Arrays.asList(method.outputType().reference())))).setName("responseObserver").build());
        statements.add(ExprStatement.withExpr(AssignmentExpr.builder().setVariableExpr(responseObserverVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(NewObjectExpr.builder().setType(FIXED_GRPC_TYPESTORE.get("MockStreamObserver")).setIsGeneric(true).build()).build()));
        statements.add(EMPTY_LINE_STATEMENT);
        VariableExpr callableVarExpr = VariableExpr.withVariable(Variable.builder().setType(ServiceClientTestClassComposer.getCallableType(method)).setName("callable").build());
        MethodInvocationExpr streamingCallExpr = MethodInvocationExpr.builder().setExprReferenceExpr(classMemberVarExprs.get("client")).setMethodName(String.format("%sCallable", JavaStyle.toLowerCamelCase(method.name()))).setReturnType(callableVarExpr.type()).build();
        ArrayList<Expr> exprs = new ArrayList<Expr>();
        exprs.add(AssignmentExpr.builder().setVariableExpr(callableVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(streamingCallExpr).build());
        if (method.stream().equals((Object)Method.Stream.SERVER)) {
            exprs.add(MethodInvocationExpr.builder().setExprReferenceExpr(callableVarExpr).setMethodName("serverStreamingCall").setArguments(requestVarExpr, responseObserverVarExpr).build());
        } else {
            VariableExpr requestObserverVarExpr = VariableExpr.withVariable(Variable.builder().setType(TypeNode.withReference(FIXED_TYPESTORE.get("ApiStreamObserver").reference().copyAndSetGenerics(Arrays.asList(method.inputType().reference())))).setName("requestObserver").build());
            ArrayList<Expr> callableMethodArgs = new ArrayList<Expr>();
            if (!method.stream().equals((Object)Method.Stream.BIDI) && !method.stream().equals((Object)Method.Stream.CLIENT)) {
                callableMethodArgs.add(requestVarExpr);
            }
            callableMethodArgs.add(responseObserverVarExpr);
            exprs.add(AssignmentExpr.builder().setVariableExpr(requestObserverVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(MethodInvocationExpr.builder().setExprReferenceExpr(callableVarExpr).setMethodName(ServiceClientTestClassComposer.getCallableMethodName(method)).setArguments(callableMethodArgs).setReturnType(requestObserverVarExpr.type()).build()).build());
            statements.addAll(exprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList()));
            exprs.clear();
            statements.add(EMPTY_LINE_STATEMENT);
            exprs.add(MethodInvocationExpr.builder().setExprReferenceExpr(requestObserverVarExpr).setMethodName("onNext").setArguments(requestVarExpr).build());
        }
        statements.addAll(exprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList()));
        exprs.clear();
        statements.add(EMPTY_LINE_STATEMENT);
        ArrayList<Expr> tryBodyExprs = new ArrayList<Expr>();
        VariableExpr actualResponsesVarExpr = VariableExpr.withVariable(Variable.builder().setType(TypeNode.withReference(ConcreteReference.builder().setClazz(List.class).setGenerics(Arrays.asList(method.outputType().reference())).build())).setName("actualResponses").build());
        MethodInvocationExpr getFutureResponseExpr = MethodInvocationExpr.builder().setExprReferenceExpr(responseObserverVarExpr).setMethodName("future").build();
        getFutureResponseExpr = MethodInvocationExpr.builder().setExprReferenceExpr(getFutureResponseExpr).setMethodName("get").setReturnType(actualResponsesVarExpr.type()).build();
        tryBodyExprs.add(AssignmentExpr.builder().setVariableExpr(actualResponsesVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(getFutureResponseExpr).build());
        tryBodyExprs.add(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Assert")).setMethodName("fail").setArguments(ValueExpr.withValue(StringObjectValue.withValue("No exception thrown"))).build());
        VariableExpr catchExceptionVarExpr = VariableExpr.builder().setVariable(Variable.builder().setType(TypeNode.withExceptionClazz(ExecutionException.class)).setName("e").build()).build();
        TryCatchStatement tryCatchBlock = TryCatchStatement.builder().setTryBody(tryBodyExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList())).addCatch(catchExceptionVarExpr.toBuilder().setIsDecl(true).build(), this.createRpcLroExceptionTestCatchBody(catchExceptionVarExpr, true)).build();
        statements.add(tryCatchBlock);
        return statements;
    }

    @Override
    protected List<Statement> createRpcLroExceptionTestCatchBody(VariableExpr exceptionExpr, boolean isStreaming) {
        ArrayList<Expr> catchBodyExprs = new ArrayList<Expr>();
        Expr testExpectedValueExpr = VariableExpr.builder().setVariable(Variable.builder().setType(TypeNode.CLASS_OBJECT).setName("class").build()).setStaticReferenceType(FIXED_TYPESTORE.get("InvalidArgumentException")).build();
        MethodInvocationExpr getCauseExpr = MethodInvocationExpr.builder().setExprReferenceExpr(exceptionExpr).setMethodName("getCause").setReturnType(TypeNode.withReference(ConcreteReference.withClazz(Throwable.class))).build();
        MethodInvocationExpr testActualValueExpr = MethodInvocationExpr.builder().setExprReferenceExpr(getCauseExpr).setMethodName("getClass").build();
        if (isStreaming) {
            InstanceofExpr checkInstanceExpr = InstanceofExpr.builder().setExpr(getCauseExpr).setCheckType(FIXED_TYPESTORE.get("InvalidArgumentException")).build();
            catchBodyExprs.add(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Assert")).setMethodName("assertTrue").setArguments(checkInstanceExpr).build());
        } else {
            catchBodyExprs.add(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Assert")).setMethodName("assertEquals").setArguments(testExpectedValueExpr, testActualValueExpr).build());
        }
        VariableExpr apiExceptionVarExpr = VariableExpr.withVariable(Variable.builder().setType(FIXED_TYPESTORE.get("InvalidArgumentException")).setName("apiException").build());
        CastExpr castedCauseExpr = CastExpr.builder().setType(FIXED_TYPESTORE.get("InvalidArgumentException")).setExpr(getCauseExpr).build();
        catchBodyExprs.add(AssignmentExpr.builder().setVariableExpr(apiExceptionVarExpr.toBuilder().setIsDecl(true).build()).setValueExpr(castedCauseExpr).build());
        testExpectedValueExpr = EnumRefExpr.builder().setType(TypeNode.withReference(ConcreteReference.builder().setClazz(StatusCode.Code.class).setIsStaticImport(false).build())).setName("INVALID_ARGUMENT").build();
        testActualValueExpr = MethodInvocationExpr.builder().setExprReferenceExpr(apiExceptionVarExpr).setMethodName("getStatusCode").build();
        testActualValueExpr = MethodInvocationExpr.builder().setExprReferenceExpr(testActualValueExpr).setMethodName("getCode").build();
        catchBodyExprs.add(MethodInvocationExpr.builder().setStaticReferenceType(FIXED_TYPESTORE.get("Assert")).setMethodName("assertEquals").setArguments(testExpectedValueExpr, testActualValueExpr).build());
        return catchBodyExprs.stream().map(e -> ExprStatement.withExpr(e)).collect(Collectors.toList());
    }
}

