/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.composer.samplecode;

import com.google.api.generator.engine.ast.ClassDefinition;
import com.google.api.generator.engine.ast.Expr;
import com.google.api.generator.engine.ast.ExprStatement;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.engine.writer.JavaWriterVisitor;
import com.google.api.generator.gapic.composer.samplecode.SampleBodyJavaFormatter;
import com.google.api.generator.gapic.composer.samplecode.SampleComposer;
import com.google.api.generator.gapic.model.Sample;
import com.google.common.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.List;

public final class SampleCodeWriter {
    public static String writeInlineSample(List<Statement> statements) {
        return SampleCodeWriter.write(SampleComposer.composeInlineSample(statements));
    }

    public static String writeExecutableSample(Sample sample, String packkage) {
        return SampleCodeWriter.write(SampleComposer.composeExecutableSample(sample, packkage));
    }

    @VisibleForTesting
    public static String write(Statement ... statement) {
        return SampleCodeWriter.write(Arrays.asList(statement));
    }

    @VisibleForTesting
    public static String write(List<Statement> statements) {
        JavaWriterVisitor visitor = new JavaWriterVisitor();
        for (Statement statement : statements) {
            statement.accept(visitor);
        }
        String formattedSampleCode = SampleBodyJavaFormatter.format(visitor.write());
        return formattedSampleCode.replaceAll("@", "{@literal @}");
    }

    @VisibleForTesting
    public static String write(ClassDefinition classDefinition) {
        JavaWriterVisitor visitor = new JavaWriterVisitor();
        classDefinition.accept(visitor);
        return visitor.write();
    }

    @VisibleForTesting
    public static String write(Expr expr) {
        return SampleCodeWriter.write(ExprStatement.withExpr(expr));
    }
}

