/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.gapic.model.GapicContext;
import com.google.api.generator.gapic.model.GapicServiceConfig;
import com.google.api.generator.gapic.model.Message;
import com.google.api.generator.gapic.model.ResourceName;
import com.google.api.generator.gapic.model.Service;
import com.google.api.generator.gapic.model.Transport;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

final class AutoValue_GapicContext
extends GapicContext {
    private final ImmutableMap<String, Message> messages;
    private final ImmutableMap<String, ResourceName> resourceNames;
    private final ImmutableList<Service> services;
    private final ImmutableList<Service> mixinServices;
    private final ImmutableMap<String, ResourceName> helperResourceNames;
    private final boolean gapicMetadataEnabled;
    private final boolean restNumericEnumsEnabled;
    @Nullable
    private final GapicServiceConfig serviceConfig;
    @Nullable
    private final com.google.api.Service serviceYamlProto;
    private final Transport transport;

    private AutoValue_GapicContext(ImmutableMap<String, Message> messages, ImmutableMap<String, ResourceName> resourceNames, ImmutableList<Service> services, ImmutableList<Service> mixinServices, ImmutableMap<String, ResourceName> helperResourceNames, boolean gapicMetadataEnabled, boolean restNumericEnumsEnabled, @Nullable GapicServiceConfig serviceConfig, @Nullable com.google.api.Service serviceYamlProto, Transport transport) {
        this.messages = messages;
        this.resourceNames = resourceNames;
        this.services = services;
        this.mixinServices = mixinServices;
        this.helperResourceNames = helperResourceNames;
        this.gapicMetadataEnabled = gapicMetadataEnabled;
        this.restNumericEnumsEnabled = restNumericEnumsEnabled;
        this.serviceConfig = serviceConfig;
        this.serviceYamlProto = serviceYamlProto;
        this.transport = transport;
    }

    @Override
    public ImmutableMap<String, Message> messages() {
        return this.messages;
    }

    @Override
    public ImmutableMap<String, ResourceName> resourceNames() {
        return this.resourceNames;
    }

    @Override
    public ImmutableList<Service> services() {
        return this.services;
    }

    @Override
    public ImmutableList<Service> mixinServices() {
        return this.mixinServices;
    }

    @Override
    public ImmutableMap<String, ResourceName> helperResourceNames() {
        return this.helperResourceNames;
    }

    @Override
    public boolean gapicMetadataEnabled() {
        return this.gapicMetadataEnabled;
    }

    @Override
    public boolean restNumericEnumsEnabled() {
        return this.restNumericEnumsEnabled;
    }

    @Override
    @Nullable
    public GapicServiceConfig serviceConfig() {
        return this.serviceConfig;
    }

    @Override
    @Nullable
    public com.google.api.Service serviceYamlProto() {
        return this.serviceYamlProto;
    }

    @Override
    public Transport transport() {
        return this.transport;
    }

    public String toString() {
        return "GapicContext{messages=" + this.messages + ", resourceNames=" + this.resourceNames + ", services=" + this.services + ", mixinServices=" + this.mixinServices + ", helperResourceNames=" + this.helperResourceNames + ", gapicMetadataEnabled=" + this.gapicMetadataEnabled + ", restNumericEnumsEnabled=" + this.restNumericEnumsEnabled + ", serviceConfig=" + this.serviceConfig + ", serviceYamlProto=" + this.serviceYamlProto + ", transport=" + (Object)((Object)this.transport) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof GapicContext) {
            GapicContext that = (GapicContext)o;
            return this.messages.equals(that.messages()) && this.resourceNames.equals(that.resourceNames()) && this.services.equals(that.services()) && this.mixinServices.equals(that.mixinServices()) && this.helperResourceNames.equals(that.helperResourceNames()) && this.gapicMetadataEnabled == that.gapicMetadataEnabled() && this.restNumericEnumsEnabled == that.restNumericEnumsEnabled() && (this.serviceConfig == null ? that.serviceConfig() == null : this.serviceConfig.equals(that.serviceConfig())) && (this.serviceYamlProto == null ? that.serviceYamlProto() == null : this.serviceYamlProto.equals(that.serviceYamlProto())) && this.transport.equals((Object)that.transport());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.messages.hashCode();
        h$ *= 1000003;
        h$ ^= this.resourceNames.hashCode();
        h$ *= 1000003;
        h$ ^= this.services.hashCode();
        h$ *= 1000003;
        h$ ^= this.mixinServices.hashCode();
        h$ *= 1000003;
        h$ ^= this.helperResourceNames.hashCode();
        h$ *= 1000003;
        h$ ^= this.gapicMetadataEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.restNumericEnumsEnabled ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.serviceConfig == null ? 0 : this.serviceConfig.hashCode();
        h$ *= 1000003;
        h$ ^= this.serviceYamlProto == null ? 0 : this.serviceYamlProto.hashCode();
        h$ *= 1000003;
        return h$ ^= this.transport.hashCode();
    }

    @Override
    public GapicContext.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends GapicContext.Builder {
        private ImmutableMap<String, Message> messages;
        private ImmutableMap<String, ResourceName> resourceNames;
        private ImmutableList<Service> services;
        private ImmutableList<Service> mixinServices;
        private ImmutableMap<String, ResourceName> helperResourceNames;
        private boolean gapicMetadataEnabled;
        private boolean restNumericEnumsEnabled;
        private GapicServiceConfig serviceConfig;
        private com.google.api.Service serviceYamlProto;
        private Transport transport;
        private byte set$0;

        Builder() {
        }

        private Builder(GapicContext source) {
            this.messages = source.messages();
            this.resourceNames = source.resourceNames();
            this.services = source.services();
            this.mixinServices = source.mixinServices();
            this.helperResourceNames = source.helperResourceNames();
            this.gapicMetadataEnabled = source.gapicMetadataEnabled();
            this.restNumericEnumsEnabled = source.restNumericEnumsEnabled();
            this.serviceConfig = source.serviceConfig();
            this.serviceYamlProto = source.serviceYamlProto();
            this.transport = source.transport();
            this.set$0 = (byte)3;
        }

        @Override
        public GapicContext.Builder setMessages(Map<String, Message> messages) {
            this.messages = ImmutableMap.copyOf(messages);
            return this;
        }

        @Override
        public GapicContext.Builder setResourceNames(Map<String, ResourceName> resourceNames) {
            this.resourceNames = ImmutableMap.copyOf(resourceNames);
            return this;
        }

        @Override
        ImmutableMap<String, ResourceName> resourceNames() {
            if (this.resourceNames == null) {
                throw new IllegalStateException("Property \"resourceNames\" has not been set");
            }
            return this.resourceNames;
        }

        @Override
        public GapicContext.Builder setServices(List<Service> services) {
            this.services = ImmutableList.copyOf(services);
            return this;
        }

        @Override
        public GapicContext.Builder setMixinServices(List<Service> mixinServices) {
            this.mixinServices = ImmutableList.copyOf(mixinServices);
            return this;
        }

        @Override
        GapicContext.Builder setHelperResourceNames(Map<String, ResourceName> helperResourceNames) {
            this.helperResourceNames = ImmutableMap.copyOf(helperResourceNames);
            return this;
        }

        @Override
        ImmutableMap<String, ResourceName> helperResourceNames() {
            if (this.helperResourceNames == null) {
                throw new IllegalStateException("Property \"helperResourceNames\" has not been set");
            }
            return this.helperResourceNames;
        }

        @Override
        public GapicContext.Builder setGapicMetadataEnabled(boolean gapicMetadataEnabled) {
            this.gapicMetadataEnabled = gapicMetadataEnabled;
            this.set$0 = (byte)(this.set$0 | 1);
            return this;
        }

        @Override
        public GapicContext.Builder setRestNumericEnumsEnabled(boolean restNumericEnumsEnabled) {
            this.restNumericEnumsEnabled = restNumericEnumsEnabled;
            this.set$0 = (byte)(this.set$0 | 2);
            return this;
        }

        @Override
        public GapicContext.Builder setServiceConfig(GapicServiceConfig serviceConfig) {
            this.serviceConfig = serviceConfig;
            return this;
        }

        @Override
        public GapicContext.Builder setServiceYamlProto(com.google.api.Service serviceYamlProto) {
            this.serviceYamlProto = serviceYamlProto;
            return this;
        }

        @Override
        public GapicContext.Builder setTransport(Transport transport) {
            if (transport == null) {
                throw new NullPointerException("Null transport");
            }
            this.transport = transport;
            return this;
        }

        @Override
        GapicContext autoBuild() {
            if (this.set$0 != 3 || this.messages == null || this.resourceNames == null || this.services == null || this.mixinServices == null || this.helperResourceNames == null || this.transport == null) {
                StringBuilder missing = new StringBuilder();
                if (this.messages == null) {
                    missing.append(" messages");
                }
                if (this.resourceNames == null) {
                    missing.append(" resourceNames");
                }
                if (this.services == null) {
                    missing.append(" services");
                }
                if (this.mixinServices == null) {
                    missing.append(" mixinServices");
                }
                if (this.helperResourceNames == null) {
                    missing.append(" helperResourceNames");
                }
                if ((this.set$0 & 1) == 0) {
                    missing.append(" gapicMetadataEnabled");
                }
                if ((this.set$0 & 2) == 0) {
                    missing.append(" restNumericEnumsEnabled");
                }
                if (this.transport == null) {
                    missing.append(" transport");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_GapicContext(this.messages, this.resourceNames, this.services, this.mixinServices, this.helperResourceNames, this.gapicMetadataEnabled, this.restNumericEnumsEnabled, this.serviceConfig, this.serviceYamlProto, this.transport);
        }
    }
}

