/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.generator.gapic.model;

import com.google.api.generator.engine.ast.AssignmentExpr;
import com.google.api.generator.engine.ast.CommentStatement;
import com.google.api.generator.engine.ast.Statement;
import com.google.api.generator.gapic.model.AutoValue_Sample;
import com.google.api.generator.gapic.model.RegionTag;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import java.util.List;

@AutoValue
public abstract class Sample {
    public abstract List<Statement> body();

    public abstract List<AssignmentExpr> variableAssignments();

    public abstract List<CommentStatement> fileHeader();

    public abstract RegionTag regionTag();

    public abstract String name();

    public abstract boolean isCanonical();

    public static Builder builder() {
        return new AutoValue_Sample.Builder().setBody(ImmutableList.of()).setVariableAssignments(ImmutableList.of()).setFileHeader(ImmutableList.of()).setIsCanonical(false);
    }

    public abstract Builder toBuilder();

    public final Sample withHeader(List<CommentStatement> header) {
        return this.toBuilder().setFileHeader(header).build();
    }

    public final Sample withRegionTag(RegionTag regionTag) {
        if (this.isCanonical() && !regionTag.overloadDisambiguation().isEmpty()) {
            this.withRegionTag(regionTag.withOverloadDisambiguation(""));
        }
        return this.toBuilder().setName(Sample.generateSampleClassName(this.regionTag())).setRegionTag(regionTag).build();
    }

    private static String generateSampleClassName(RegionTag regionTag) {
        return (regionTag.isAsynchronous() != false ? "Async" : "Sync") + regionTag.rpcName() + regionTag.overloadDisambiguation();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        public abstract Builder setBody(List<Statement> var1);

        public abstract Builder setVariableAssignments(List<AssignmentExpr> var1);

        public abstract Builder setFileHeader(List<CommentStatement> var1);

        public abstract Builder setRegionTag(RegionTag var1);

        public abstract Builder setIsCanonical(boolean var1);

        abstract Builder setName(String var1);

        abstract Sample autoBuild();

        abstract RegionTag regionTag();

        abstract boolean isCanonical();

        public final Sample build() {
            if (this.isCanonical() && !this.regionTag().overloadDisambiguation().isEmpty()) {
                this.setRegionTag(this.regionTag().withOverloadDisambiguation(""));
            }
            this.setName(Sample.generateSampleClassName(this.regionTag()));
            return this.autoBuild();
        }
    }
}

