/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.googlejavaformat.Newlines;
import com.google.googlejavaformat.java.FormatterException;
import com.google.googlejavaformat.java.JavaInput;
import java.util.ArrayList;
import java.util.Optional;
import org.openjdk.tools.javac.parser.Tokens;

public class ImportOrderer {
    private static final ImmutableSet<Tokens.TokenKind> CLASS_START = ImmutableSet.of(Tokens.TokenKind.CLASS, Tokens.TokenKind.INTERFACE, Tokens.TokenKind.ENUM);
    private static final ImmutableSet<String> IMPORT_OR_CLASS_START = ImmutableSet.of("import", "class", "interface", "enum");
    private final String text;
    private final ImmutableList<JavaInput.Tok> toks;
    private final String lineSeparator;

    public static String reorderImports(String text) throws FormatterException {
        ImmutableList<JavaInput.Tok> toks = JavaInput.buildToks(text, CLASS_START);
        return new ImportOrderer(text, toks).reorderImports();
    }

    private ImportOrderer(String text, ImmutableList<JavaInput.Tok> toks) throws FormatterException {
        this.text = text;
        this.toks = toks;
        this.lineSeparator = Newlines.guessLineSeparator(text);
    }

    private String reorderImports() throws FormatterException {
        Optional<Integer> maybeFirstImport = this.findIdentifier(0, IMPORT_OR_CLASS_START);
        if (!maybeFirstImport.isPresent() || !this.tokenAt(maybeFirstImport.get()).equals("import")) {
            return this.text;
        }
        int firstImportStart = maybeFirstImport.get();
        int unindentedFirstImportStart = this.unindent(firstImportStart);
        ImportsAndIndex imports = this.scanImports(firstImportStart);
        int afterLastImport = imports.index;
        Optional<Integer> maybeLaterImport = this.findIdentifier(afterLastImport, IMPORT_OR_CLASS_START);
        if (maybeLaterImport.isPresent() && this.tokenAt(maybeLaterImport.get()).equals("import")) {
            throw new FormatterException("Imports not contiguous (perhaps a comment separates them?)");
        }
        StringBuilder result = new StringBuilder();
        String prefix = this.tokString(0, unindentedFirstImportStart);
        result.append(prefix);
        if (!prefix.isEmpty() && Newlines.getLineEnding(prefix) == null) {
            result.append(this.lineSeparator).append(this.lineSeparator);
        }
        result.append(this.reorderedImportsString(imports.imports));
        ArrayList<String> tail = new ArrayList<String>();
        tail.add(CharMatcher.whitespace().trimLeadingFrom(this.tokString(afterLastImport, this.toks.size())));
        if (!this.toks.isEmpty()) {
            JavaInput.Tok lastTok = Iterables.getLast(this.toks);
            int tailStart = lastTok.getPosition() + lastTok.length();
            tail.add(this.text.substring(tailStart));
        }
        if (tail.stream().anyMatch(s2 -> !s2.isEmpty())) {
            result.append(this.lineSeparator);
            tail.forEach(result::append);
        }
        return result.toString();
    }

    private String tokString(int start, int end) {
        StringBuilder sb = new StringBuilder();
        for (int i = start; i < end; ++i) {
            sb.append(((JavaInput.Tok)this.toks.get(i)).getOriginalText());
        }
        return sb.toString();
    }

    private ImportsAndIndex scanImports(int i) throws FormatterException {
        int afterLastImport = i;
        ImmutableSortedSet.Builder imports = ImmutableSortedSet.naturalOrder();
        while (i < this.toks.size() && this.tokenAt(i).equals("import")) {
            boolean isStatic;
            if (this.isSpaceToken(++i)) {
                ++i;
            }
            if ((isStatic = this.tokenAt(i).equals("static")) && this.isSpaceToken(++i)) {
                ++i;
            }
            if (!this.isIdentifierToken(i)) {
                throw new FormatterException("Unexpected token after import: " + this.tokenAt(i));
            }
            StringAndIndex imported = this.scanImported(i);
            String importedName = imported.string;
            i = imported.index;
            if (this.isSpaceToken(i)) {
                ++i;
            }
            if (!this.tokenAt(i).equals(";")) {
                throw new FormatterException("Expected ; after import");
            }
            while (this.tokenAt(i).equals(";")) {
                ++i;
            }
            StringBuilder trailing = new StringBuilder();
            if (this.isSpaceToken(i)) {
                trailing.append(this.tokenAt(i));
                ++i;
            }
            if (this.isSlashSlashCommentToken(i)) {
                trailing.append(this.tokenAt(i));
                ++i;
            }
            if (this.isNewlineToken(i)) {
                trailing.append(this.tokenAt(i));
            }
            imports.add(new Import(importedName, trailing.toString(), isStatic));
            afterLastImport = ++i;
            while (this.isNewlineToken(i) || this.isSpaceToken(i)) {
                ++i;
            }
        }
        return new ImportsAndIndex((ImmutableSortedSet<Import>)imports.build(), afterLastImport);
    }

    private String reorderedImportsString(ImmutableSortedSet<Import> imports) {
        Preconditions.checkArgument(!imports.isEmpty(), "imports");
        Import firstImport = (Import)imports.iterator().next();
        boolean lastWasStatic = firstImport.isStatic;
        StringBuilder sb = new StringBuilder();
        for (Import thisImport : imports) {
            if (lastWasStatic && !thisImport.isStatic) {
                sb.append(this.lineSeparator);
            }
            lastWasStatic = thisImport.isStatic;
            sb.append(thisImport);
        }
        return sb.toString();
    }

    private StringAndIndex scanImported(int start) throws FormatterException {
        int i = start;
        StringBuilder imported = new StringBuilder();
        do {
            Preconditions.checkState(this.isIdentifierToken(i));
            imported.append(this.tokenAt(i));
            if (!this.tokenAt(++i).equals(".")) {
                return new StringAndIndex(imported.toString(), i);
            }
            imported.append('.');
            if (!this.tokenAt(++i).equals("*")) continue;
            imported.append('*');
            return new StringAndIndex(imported.toString(), i + 1);
        } while (this.isIdentifierToken(i));
        throw new FormatterException("Could not parse imported name, at: " + this.tokenAt(i));
    }

    private Optional<Integer> findIdentifier(int start, ImmutableSet<String> identifiers) {
        for (int i = start; i < this.toks.size(); ++i) {
            String id;
            if (!this.isIdentifierToken(i) || !identifiers.contains(id = this.tokenAt(i))) continue;
            return Optional.of(i);
        }
        return Optional.empty();
    }

    private int unindent(int i) {
        if (i > 0 && this.isSpaceToken(i - 1)) {
            return i - 1;
        }
        return i;
    }

    private String tokenAt(int i) {
        return ((JavaInput.Tok)this.toks.get(i)).getOriginalText();
    }

    private boolean isIdentifierToken(int i) {
        String s2 = this.tokenAt(i);
        return !s2.isEmpty() && Character.isJavaIdentifierStart(s2.codePointAt(0));
    }

    private boolean isSpaceToken(int i) {
        String s2 = this.tokenAt(i);
        if (s2.isEmpty()) {
            return false;
        }
        return " \t\f".indexOf(s2.codePointAt(0)) >= 0;
    }

    private boolean isSlashSlashCommentToken(int i) {
        return ((JavaInput.Tok)this.toks.get(i)).isSlashSlashComment();
    }

    private boolean isNewlineToken(int i) {
        return ((JavaInput.Tok)this.toks.get(i)).isNewline();
    }

    private static class StringAndIndex {
        private final String string;
        private final int index;

        StringAndIndex(String string, int index) {
            this.string = string;
            this.index = index;
        }
    }

    private static class ImportsAndIndex {
        final ImmutableSortedSet<Import> imports;
        final int index;

        ImportsAndIndex(ImmutableSortedSet<Import> imports, int index) {
            this.imports = imports;
            this.index = index;
        }
    }

    private class Import
    implements Comparable<Import> {
        final String imported;
        final String trailing;
        final boolean isStatic;

        Import(String imported, String trailing, boolean isStatic) {
            this.imported = imported;
            this.trailing = trailing.trim();
            this.isStatic = isStatic;
        }

        @Override
        public int compareTo(Import that) {
            if (this.isStatic != that.isStatic) {
                return this.isStatic ? -1 : 1;
            }
            return this.imported.compareTo(that.imported);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("import ");
            if (this.isStatic) {
                sb.append("static ");
            }
            sb.append(this.imported).append(';');
            if (!this.trailing.isEmpty()) {
                sb.append(' ').append(this.trailing);
            }
            sb.append(ImportOrderer.this.lineSeparator);
            return sb.toString();
        }
    }
}

