/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.xds.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.base.Supplier;
import com.google.protobuf.Any;
import io.grpc.InternalLogId;
import io.grpc.MethodDescriptor;
import io.grpc.Status;
import io.grpc.SynchronizationContext;
import io.grpc.internal.BackoffPolicy;
import io.grpc.xds.client.Bootstrapper;
import io.grpc.xds.client.EnvoyProtoData;
import io.grpc.xds.client.MessagePrettyPrinter;
import io.grpc.xds.client.XdsClient;
import io.grpc.xds.client.XdsLogger;
import io.grpc.xds.client.XdsResourceType;
import io.grpc.xds.client.XdsTransportFactory;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.AggregatedDiscoveryServiceGrpc;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryRequest;
import io.grpc.xds.shaded.io.envoyproxy.envoy.service.discovery.v3.DiscoveryResponse;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

final class ControlPlaneClient {
    public static final String CLOSED_BY_SERVER = "Closed by server";
    private final SynchronizationContext syncContext;
    private final InternalLogId logId;
    private final XdsLogger logger;
    private final Bootstrapper.ServerInfo serverInfo;
    private final XdsTransportFactory.XdsTransport xdsTransport;
    private final XdsClient.XdsResponseHandler xdsResponseHandler;
    private final XdsClient.ResourceStore resourceStore;
    private final ScheduledExecutorService timeService;
    private final BackoffPolicy.Provider backoffPolicyProvider;
    private final Stopwatch stopwatch;
    private final EnvoyProtoData.Node bootstrapNode;
    private final XdsClient xdsClient;
    private final Map<XdsResourceType<?>, String> versions = new HashMap();
    private boolean shutdown;
    @Nullable
    private AdsStream adsStream;
    @Nullable
    private BackoffPolicy retryBackoffPolicy;
    @Nullable
    private SynchronizationContext.ScheduledHandle rpcRetryTimer;
    private MessagePrettyPrinter messagePrinter;

    ControlPlaneClient(XdsTransportFactory.XdsTransport xdsTransport, Bootstrapper.ServerInfo serverInfo, EnvoyProtoData.Node bootstrapNode, XdsClient.XdsResponseHandler xdsResponseHandler, XdsClient.ResourceStore resourceStore, ScheduledExecutorService timeService, SynchronizationContext syncContext, BackoffPolicy.Provider backoffPolicyProvider, Supplier<Stopwatch> stopwatchSupplier, XdsClient xdsClient, MessagePrettyPrinter messagePrinter) {
        this.serverInfo = Preconditions.checkNotNull(serverInfo, "serverInfo");
        this.xdsTransport = Preconditions.checkNotNull(xdsTransport, "xdsTransport");
        this.xdsResponseHandler = Preconditions.checkNotNull(xdsResponseHandler, "xdsResponseHandler");
        this.resourceStore = Preconditions.checkNotNull(resourceStore, "resourcesSubscriber");
        this.bootstrapNode = Preconditions.checkNotNull(bootstrapNode, "bootstrapNode");
        this.timeService = Preconditions.checkNotNull(timeService, "timeService");
        this.syncContext = Preconditions.checkNotNull(syncContext, "syncContext");
        this.backoffPolicyProvider = Preconditions.checkNotNull(backoffPolicyProvider, "backoffPolicyProvider");
        this.xdsClient = Preconditions.checkNotNull(xdsClient, "xdsClient");
        this.messagePrinter = Preconditions.checkNotNull(messagePrinter, "messagePrinter");
        this.stopwatch = Preconditions.checkNotNull(stopwatchSupplier, "stopwatchSupplier").get();
        this.logId = InternalLogId.allocate("xds-client", serverInfo.target());
        this.logger = XdsLogger.withLogId(this.logId);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Created");
    }

    void shutdown() {
        this.syncContext.execute(new Runnable(){

            @Override
            public void run() {
                ControlPlaneClient.this.shutdown = true;
                ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Shutting down");
                if (ControlPlaneClient.this.adsStream != null) {
                    ControlPlaneClient.this.adsStream.close(Status.CANCELLED.withDescription("shutdown").asException());
                }
                if (ControlPlaneClient.this.rpcRetryTimer != null && ControlPlaneClient.this.rpcRetryTimer.isPending()) {
                    ControlPlaneClient.this.rpcRetryTimer.cancel();
                }
                ControlPlaneClient.this.xdsTransport.shutdown();
            }
        });
    }

    public String toString() {
        return this.logId.toString();
    }

    void adjustResourceSubscription(XdsResourceType<?> resourceType) {
        Collection<String> resources;
        if (this.isInBackoff()) {
            return;
        }
        if (this.adsStream == null) {
            this.startRpcStream();
        }
        if ((resources = this.resourceStore.getSubscribedResources(this.serverInfo, resourceType)) != null) {
            this.adsStream.sendDiscoveryRequest(resourceType, resources);
        }
    }

    void ackResponse(XdsResourceType<?> type, String versionInfo, String nonce) {
        this.versions.put(type, versionInfo);
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending ACK for {0} update, nonce: {1}, current version: {2}", type.typeName(), nonce, versionInfo);
        Collection<String> resources = this.resourceStore.getSubscribedResources(this.serverInfo, type);
        if (resources == null) {
            resources = Collections.emptyList();
        }
        this.adsStream.sendDiscoveryRequest(type, versionInfo, resources, nonce, null);
    }

    void nackResponse(XdsResourceType<?> type, String nonce, String errorDetail) {
        String versionInfo = this.versions.getOrDefault(type, "");
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending NACK for {0} update, nonce: {1}, current version: {2}", type.typeName(), nonce, versionInfo);
        Collection<String> resources = this.resourceStore.getSubscribedResources(this.serverInfo, type);
        if (resources == null) {
            resources = Collections.emptyList();
        }
        this.adsStream.sendDiscoveryRequest(type, versionInfo, resources, nonce, errorDetail);
    }

    boolean isInBackoff() {
        return this.rpcRetryTimer != null && this.rpcRetryTimer.isPending();
    }

    boolean isReady() {
        return this.adsStream != null && this.adsStream.call != null && this.adsStream.call.isReady();
    }

    void readyHandler() {
        if (!this.isReady()) {
            return;
        }
        if (this.isInBackoff()) {
            this.rpcRetryTimer.cancel();
            this.rpcRetryTimer = null;
        }
        this.xdsClient.startSubscriberTimersIfNeeded(this.serverInfo);
    }

    private void startRpcStream() {
        Preconditions.checkState(this.adsStream == null, "Previous adsStream has not been cleared yet");
        this.adsStream = new AdsStream();
        this.logger.log(XdsLogger.XdsLogLevel.INFO, "ADS stream started");
        this.stopwatch.reset().start();
    }

    @Nullable
    @VisibleForTesting
    XdsResourceType<?> fromTypeUrl(String typeUrl) {
        return this.resourceStore.getSubscribedResourceTypesWithTypeUrl().get(typeUrl);
    }

    private class AdsStream
    implements XdsTransportFactory.EventHandler<DiscoveryResponse> {
        private boolean responseReceived;
        private boolean closed;
        private final Map<XdsResourceType<?>, String> respNonces = new HashMap();
        private final XdsTransportFactory.StreamingCall<DiscoveryRequest, DiscoveryResponse> call;
        private final MethodDescriptor<DiscoveryRequest, DiscoveryResponse> methodDescriptor = AggregatedDiscoveryServiceGrpc.getStreamAggregatedResourcesMethod();

        private AdsStream() {
            this.call = ControlPlaneClient.this.xdsTransport.createStreamingCall(this.methodDescriptor.getFullMethodName(), this.methodDescriptor.getRequestMarshaller(), this.methodDescriptor.getResponseMarshaller());
            this.call.start(this);
        }

        void sendDiscoveryRequest(XdsResourceType<?> type, String versionInfo, Collection<String> resources, String nonce, @Nullable String errorDetail) {
            DiscoveryRequest.Builder builder = DiscoveryRequest.newBuilder().setVersionInfo(versionInfo).setNode(ControlPlaneClient.this.bootstrapNode.toEnvoyProtoNode()).addAllResourceNames(resources).setTypeUrl(type.typeUrl()).setResponseNonce(nonce);
            if (errorDetail != null) {
                com.google.rpc.Status error = com.google.rpc.Status.newBuilder().setCode(3).setMessage(errorDetail).build();
                builder.setErrorDetail(error);
            }
            DiscoveryRequest request = builder.build();
            this.call.sendMessage(request);
            if (ControlPlaneClient.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Sent DiscoveryRequest\n{0}", ControlPlaneClient.this.messagePrinter.print(request));
            }
        }

        final void sendDiscoveryRequest(XdsResourceType<?> type, Collection<String> resources) {
            ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Sending {0} request for resources: {1}", type, resources);
            this.sendDiscoveryRequest(type, ControlPlaneClient.this.versions.getOrDefault(type, ""), resources, this.respNonces.getOrDefault(type, ""), null);
        }

        @Override
        public void onReady() {
            ControlPlaneClient.this.syncContext.execute(ControlPlaneClient.this::readyHandler);
        }

        @Override
        public void onRecvMessage(final DiscoveryResponse response) {
            ControlPlaneClient.this.syncContext.execute(new Runnable(){

                @Override
                public void run() {
                    XdsResourceType<?> type = ControlPlaneClient.this.fromTypeUrl(response.getTypeUrl());
                    if (ControlPlaneClient.this.logger.isLoggable(XdsLogger.XdsLogLevel.DEBUG)) {
                        ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.DEBUG, "Received {0} response:\n{1}", type, ControlPlaneClient.this.messagePrinter.print(response));
                    }
                    if (type == null) {
                        ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.WARNING, "Ignore an unknown type of DiscoveryResponse: {0}", response.getTypeUrl());
                        AdsStream.this.call.startRecvMessage();
                        return;
                    }
                    AdsStream.this.handleRpcResponse(type, response.getVersionInfo(), response.getResourcesList(), response.getNonce());
                }
            });
        }

        @Override
        public void onStatusReceived(Status status) {
            ControlPlaneClient.this.syncContext.execute(() -> {
                if (status.isOk()) {
                    this.handleRpcStreamClosed(Status.UNAVAILABLE.withDescription(ControlPlaneClient.CLOSED_BY_SERVER));
                } else {
                    this.handleRpcStreamClosed(status);
                }
            });
        }

        final void handleRpcResponse(XdsResourceType<?> type, String versionInfo, List<Any> resources, String nonce) {
            Preconditions.checkNotNull(type, "type");
            if (this.closed) {
                return;
            }
            this.responseReceived = true;
            this.respNonces.put(type, nonce);
            XdsClient.ProcessingTracker processingTracker = new XdsClient.ProcessingTracker(() -> this.call.startRecvMessage(), ControlPlaneClient.this.syncContext);
            ControlPlaneClient.this.xdsResponseHandler.handleResourceResponse(type, ControlPlaneClient.this.serverInfo, versionInfo, resources, nonce, processingTracker);
            processingTracker.onComplete();
        }

        private void handleRpcStreamClosed(Status error) {
            if (this.closed) {
                return;
            }
            if (this.responseReceived || ControlPlaneClient.this.retryBackoffPolicy == null) {
                ControlPlaneClient.this.retryBackoffPolicy = ControlPlaneClient.this.backoffPolicyProvider.get();
            }
            long elapsed = ControlPlaneClient.this.stopwatch.elapsed(TimeUnit.NANOSECONDS);
            long delayNanos = Math.max(0L, ControlPlaneClient.this.retryBackoffPolicy.nextBackoffNanos() - elapsed);
            ControlPlaneClient.this.rpcRetryTimer = ControlPlaneClient.this.syncContext.schedule(new RpcRetryTask(), delayNanos, TimeUnit.NANOSECONDS, ControlPlaneClient.this.timeService);
            Preconditions.checkArgument(!error.isOk(), "unexpected OK status");
            String errorMsg = error.getDescription() != null && error.getDescription().equals(ControlPlaneClient.CLOSED_BY_SERVER) ? "ADS stream closed with status {0}: {1}. Cause: {2}" : "ADS stream failed with status {0}: {1}. Cause: {2}";
            ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.ERROR, errorMsg, new Object[]{error.getCode(), error.getDescription(), error.getCause()});
            this.closed = true;
            ControlPlaneClient.this.xdsResponseHandler.handleStreamClosed(error);
            this.cleanUp();
            ControlPlaneClient.this.logger.log(XdsLogger.XdsLogLevel.INFO, "Retry ADS stream in {0} ns", delayNanos);
        }

        private void close(Exception error) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.cleanUp();
            this.call.sendError(error);
        }

        private void cleanUp() {
            if (ControlPlaneClient.this.adsStream == this) {
                ControlPlaneClient.this.adsStream = null;
            }
        }
    }

    @VisibleForTesting
    public final class RpcRetryTask
    implements Runnable {
        @Override
        public void run() {
            if (ControlPlaneClient.this.shutdown) {
                return;
            }
            ControlPlaneClient.this.startRpcStream();
            HashSet subscribedResourceTypes = new HashSet(ControlPlaneClient.this.resourceStore.getSubscribedResourceTypesWithTypeUrl().values());
            for (XdsResourceType xdsResourceType : subscribedResourceTypes) {
                Collection<String> resources = ControlPlaneClient.this.resourceStore.getSubscribedResources(ControlPlaneClient.this.serverInfo, xdsResourceType);
                if (resources == null) continue;
                ControlPlaneClient.this.adsStream.sendDiscoveryRequest(xdsResourceType, resources);
            }
            ControlPlaneClient.this.xdsResponseHandler.handleStreamRestarted(ControlPlaneClient.this.serverInfo);
        }
    }
}

