/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.BetaApi;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.SimpleStreamResumptionStrategy;
import com.google.api.gax.retrying.StreamResumptionStrategy;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamingCallSettings;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi(value="The surface for streaming is not stable yet and may change in the future.")
public final class ServerStreamingCallSettings<RequestT, ResponseT>
extends StreamingCallSettings<RequestT, ResponseT> {
    private final Set<StatusCode.Code> retryableCodes;
    private final RetrySettings retrySettings;
    private final StreamResumptionStrategy<RequestT, ResponseT> resumptionStrategy;
    private final Duration timeoutCheckInterval;
    private final Duration idleTimeout;

    private ServerStreamingCallSettings(Builder<RequestT, ResponseT> builder) {
        this.retryableCodes = ImmutableSet.copyOf((Collection)((Builder)builder).retryableCodes);
        this.retrySettings = ((Builder)builder).retrySettings;
        this.resumptionStrategy = ((Builder)builder).resumptionStrategy;
        this.timeoutCheckInterval = ((Builder)builder).timeoutCheckInterval;
        this.idleTimeout = ((Builder)builder).idleTimeout;
    }

    public Set<StatusCode.Code> getRetryableCodes() {
        return this.retryableCodes;
    }

    public RetrySettings getRetrySettings() {
        return this.retrySettings;
    }

    public StreamResumptionStrategy<RequestT, ResponseT> getResumptionStrategy() {
        return this.resumptionStrategy;
    }

    public Duration getTimeoutCheckInterval() {
        return this.timeoutCheckInterval;
    }

    public Duration getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public Builder<RequestT, ResponseT> toBuilder() {
        return new Builder(this);
    }

    public static <RequestT, ResponseT> Builder<RequestT, ResponseT> newBuilder() {
        return new Builder();
    }

    public static class Builder<RequestT, ResponseT>
    extends StreamingCallSettings.Builder<RequestT, ResponseT> {
        private Set<StatusCode.Code> retryableCodes;
        private RetrySettings retrySettings;
        private StreamResumptionStrategy<RequestT, ResponseT> resumptionStrategy;
        private Duration timeoutCheckInterval;
        private Duration idleTimeout;

        private Builder() {
            this.retryableCodes = ImmutableSet.of();
            this.retrySettings = RetrySettings.newBuilder().build();
            this.resumptionStrategy = new SimpleStreamResumptionStrategy();
            this.timeoutCheckInterval = Duration.ZERO;
            this.idleTimeout = Duration.ZERO;
        }

        private Builder(ServerStreamingCallSettings<RequestT, ResponseT> settings) {
            super(settings);
            this.retryableCodes = ((ServerStreamingCallSettings)settings).retryableCodes;
            this.retrySettings = ((ServerStreamingCallSettings)settings).retrySettings;
            this.resumptionStrategy = ((ServerStreamingCallSettings)settings).resumptionStrategy;
            this.timeoutCheckInterval = ((ServerStreamingCallSettings)settings).timeoutCheckInterval;
            this.idleTimeout = ((ServerStreamingCallSettings)settings).idleTimeout;
        }

        public Builder<RequestT, ResponseT> setRetryableCodes(StatusCode.Code ... codes) {
            this.setRetryableCodes(Sets.newHashSet((Object[])codes));
            return this;
        }

        public Builder<RequestT, ResponseT> setRetryableCodes(Set<StatusCode.Code> retryableCodes) {
            this.retryableCodes = Sets.newHashSet(retryableCodes);
            return this;
        }

        public Set<StatusCode.Code> getRetryableCodes() {
            return this.retryableCodes;
        }

        public Builder<RequestT, ResponseT> setRetrySettings(RetrySettings retrySettings) {
            this.retrySettings = retrySettings;
            return this;
        }

        public RetrySettings getRetrySettings() {
            return this.retrySettings;
        }

        public Builder<RequestT, ResponseT> setSimpleTimeoutNoRetries(Duration timeout) {
            this.setRetryableCodes(new StatusCode.Code[0]);
            this.setRetrySettings(RetrySettings.newBuilder().setTotalTimeout(timeout).setInitialRetryDelay(Duration.ZERO).setRetryDelayMultiplier(1.0).setMaxRetryDelay(Duration.ZERO).setInitialRpcTimeout(timeout).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(timeout).setMaxAttempts(1).build());
            Duration checkInterval = (Duration)Ordering.natural().max((Object)timeout.dividedBy(2L), (Object)Duration.ofSeconds((long)10L));
            this.setTimeoutCheckInterval(checkInterval);
            return this;
        }

        public Builder<RequestT, ResponseT> setResumptionStrategy(StreamResumptionStrategy<RequestT, ResponseT> resumptionStrategy) {
            this.resumptionStrategy = (StreamResumptionStrategy)Preconditions.checkNotNull(resumptionStrategy);
            return this;
        }

        public StreamResumptionStrategy<RequestT, ResponseT> getResumptionStrategy() {
            return this.resumptionStrategy;
        }

        public Duration getTimeoutCheckInterval() {
            return this.timeoutCheckInterval;
        }

        public Builder<RequestT, ResponseT> setTimeoutCheckInterval(Duration timeoutCheckInterval) {
            this.timeoutCheckInterval = (Duration)Preconditions.checkNotNull((Object)timeoutCheckInterval);
            return this;
        }

        public Duration getIdleTimeout() {
            return this.idleTimeout;
        }

        public Builder<RequestT, ResponseT> setIdleTimeout(Duration idleTimeout) {
            this.idleTimeout = (Duration)Preconditions.checkNotNull((Object)idleTimeout);
            return this;
        }

        @Override
        public ServerStreamingCallSettings<RequestT, ResponseT> build() {
            return new ServerStreamingCallSettings(this);
        }
    }
}

