/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc;

import com.google.api.core.ApiClock;
import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.ApiException;
import com.google.api.gax.rpc.ResponseObserver;
import com.google.api.gax.rpc.StateCheckingResponseObserver;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StreamController;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.threeten.bp.Duration;

@InternalApi
public class Watchdog<ResponseT> {
    private static Object VALUE_MARKER = new Object();
    private final ConcurrentHashMap<WatchdogStream, Object> openStreams = new ConcurrentHashMap();
    private final ScheduledExecutorService executor;
    private final ApiClock clock;
    private final Duration checkInterval;
    private final Duration idleTimeout;
    public static final StatusCode LOCAL_ABORTED_STATUS_CODE = new StatusCode(){

        @Override
        public StatusCode.Code getCode() {
            return StatusCode.Code.ABORTED;
        }

        @Override
        public Object getTransportCode() {
            return null;
        }
    };

    public Watchdog(ScheduledExecutorService executor, ApiClock clock, Duration checkInterval, Duration idleTimeout) {
        Preconditions.checkNotNull((Object)executor, (Object)"executor can't be null");
        Preconditions.checkNotNull((Object)clock, (Object)"clock can't be null");
        Preconditions.checkNotNull((Object)checkInterval, (Object)"checkInterval can't be null");
        Preconditions.checkNotNull((Object)idleTimeout, (Object)"checkInterval can't be null");
        Preconditions.checkArgument((Duration.ZERO.compareTo(checkInterval) < 0 ? 1 : 0) != 0, (Object)"checkInterval must be > 0");
        Preconditions.checkArgument((Duration.ZERO.compareTo(idleTimeout) <= 0 ? 1 : 0) != 0, (Object)"idleTimeout must be >= 0");
        this.executor = executor;
        this.clock = clock;
        this.checkInterval = checkInterval;
        this.idleTimeout = idleTimeout;
    }

    public void start() {
        this.executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Watchdog.this.checkAll();
            }
        }, this.checkInterval.toMillis(), this.checkInterval.toMillis(), TimeUnit.MILLISECONDS);
    }

    public ResponseObserver<ResponseT> watch(ResponseObserver<ResponseT> innerObserver, Duration waitTimeout) {
        Preconditions.checkNotNull(innerObserver, (Object)"innerObserver can't be null");
        Preconditions.checkArgument((Duration.ZERO.compareTo(waitTimeout) <= 0 ? 1 : 0) != 0, (Object)"waitTimeout must >= 0");
        WatchdogStream stream = new WatchdogStream(innerObserver, waitTimeout);
        this.openStreams.put(stream, VALUE_MARKER);
        return stream;
    }

    @VisibleForTesting
    void checkAll() {
        Iterator<Map.Entry<WatchdogStream, Object>> it = this.openStreams.entrySet().iterator();
        while (it.hasNext()) {
            WatchdogStream stream = it.next().getKey();
            if (!stream.cancelIfStale()) continue;
            it.remove();
        }
    }

    public static class IdleConnectionException
    extends ApiException {
        private static final long serialVersionUID = -777463630112442085L;

        IdleConnectionException(String message, boolean retry) {
            super(message, null, LOCAL_ABORTED_STATUS_CODE, retry);
        }
    }

    class WatchdogStream
    extends StateCheckingResponseObserver<ResponseT> {
        private final Object lock = new Object();
        private final Duration waitTimeout;
        private boolean hasStarted;
        private boolean autoAutoFlowControl = true;
        private final ResponseObserver<ResponseT> outerResponseObserver;
        private StreamController innerController;
        @GuardedBy(value="lock")
        private State state = State.IDLE;
        @GuardedBy(value="lock")
        private int pendingCount = 0;
        @GuardedBy(value="lock")
        private long lastActivityAt = Watchdog.access$000(Watchdog.this).millisTime();
        private volatile Throwable error;

        WatchdogStream(ResponseObserver<ResponseT> responseObserver, Duration waitTimeout) {
            this.waitTimeout = waitTimeout;
            this.outerResponseObserver = responseObserver;
        }

        @Override
        public void onStartImpl(StreamController controller) {
            this.innerController = controller;
            this.outerResponseObserver.onStart(new StreamController(){

                @Override
                public void disableAutoInboundFlowControl() {
                    Preconditions.checkState((!WatchdogStream.this.hasStarted ? 1 : 0) != 0, (Object)"Can't disable automatic flow control after the stream has started");
                    WatchdogStream.this.autoAutoFlowControl = false;
                    WatchdogStream.this.innerController.disableAutoInboundFlowControl();
                }

                @Override
                public void request(int count) {
                    WatchdogStream.this.onRequest(count);
                }

                @Override
                public void cancel() {
                    WatchdogStream.this.onCancel();
                }
            });
            this.hasStarted = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void onRequest(int count) {
            Preconditions.checkArgument((count > 0 ? 1 : 0) != 0, (Object)"count must be > 0");
            Preconditions.checkState((!this.autoAutoFlowControl ? 1 : 0) != 0, (Object)"Auto flow control is enabled");
            Object object = this.lock;
            synchronized (object) {
                if (this.state == State.IDLE) {
                    this.state = State.WAITING;
                    this.lastActivityAt = Watchdog.this.clock.millisTime();
                }
                int maxIncrement = Integer.MAX_VALUE - this.pendingCount;
                count = Math.min(maxIncrement, count);
                this.pendingCount += count;
            }
            this.innerController.request(count);
        }

        private void onCancel() {
            this.error = new CancellationException("User cancelled stream");
            this.innerController.cancel();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResponseImpl(ResponseT response) {
            Object object = this.lock;
            synchronized (object) {
                this.state = State.DELIVERING;
            }
            this.outerResponseObserver.onResponse(response);
            object = this.lock;
            synchronized (object) {
                --this.pendingCount;
                this.lastActivityAt = Watchdog.this.clock.millisTime();
                this.state = this.autoAutoFlowControl || this.pendingCount > 0 ? State.WAITING : State.IDLE;
            }
        }

        @Override
        public void onErrorImpl(Throwable t) {
            if (this.error != null) {
                t = this.error;
            }
            Watchdog.this.openStreams.remove(this);
            this.outerResponseObserver.onError(t);
        }

        @Override
        public void onCompleteImpl() {
            Watchdog.this.openStreams.remove(this);
            this.outerResponseObserver.onComplete();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean cancelIfStale() {
            IdleConnectionException myError = null;
            Object object = this.lock;
            synchronized (object) {
                long waitTime = Watchdog.this.clock.millisTime() - this.lastActivityAt;
                switch (this.state) {
                    case IDLE: {
                        if (Watchdog.this.idleTimeout.isZero() || waitTime < Watchdog.this.idleTimeout.toMillis()) break;
                        myError = new IdleConnectionException("Canceled due to idle connection", false);
                        break;
                    }
                    case WAITING: {
                        if (this.waitTimeout.isZero() || waitTime < this.waitTimeout.toMillis()) break;
                        myError = new IdleConnectionException("Canceled due to timeout waiting for next response", true);
                    }
                }
            }
            if (myError != null) {
                this.error = myError;
                this.innerController.cancel();
                return true;
            }
            return false;
        }
    }

    static enum State {
        IDLE,
        WAITING,
        DELIVERING;

    }
}

