/*
 * Decompiled with CFR 0.152.
 */
package com.google.area120.tables.v1alpha1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class WorkspaceName
implements ResourceName {
    private static final PathTemplate WORKSPACE = PathTemplate.createWithoutUrlEncoding((String)"workspaces/{workspace}");
    private volatile Map<String, String> fieldValuesMap;
    private final String workspace;

    @Deprecated
    protected WorkspaceName() {
        this.workspace = null;
    }

    private WorkspaceName(Builder builder) {
        this.workspace = (String)Preconditions.checkNotNull((Object)builder.getWorkspace());
    }

    public String getWorkspace() {
        return this.workspace;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static WorkspaceName of(String workspace) {
        return WorkspaceName.newBuilder().setWorkspace(workspace).build();
    }

    public static String format(String workspace) {
        return WorkspaceName.newBuilder().setWorkspace(workspace).build().toString();
    }

    public static WorkspaceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = WORKSPACE.validatedMatch(formattedString, "WorkspaceName.parse: formattedString not in valid format");
        return WorkspaceName.of((String)matchMap.get("workspace"));
    }

    public static List<WorkspaceName> parseList(List<String> formattedStrings) {
        ArrayList<WorkspaceName> list = new ArrayList<WorkspaceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WorkspaceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WorkspaceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WorkspaceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return WORKSPACE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WorkspaceName workspaceName = this;
            synchronized (workspaceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.workspace != null) {
                        fieldMapBuilder.put((Object)"workspace", (Object)this.workspace);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return WORKSPACE.instantiate(new String[]{"workspace", this.workspace});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            WorkspaceName that = (WorkspaceName)o;
            return Objects.equals(this.workspace, that.workspace);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.workspace);
    }

    public static class Builder {
        private String workspace;

        protected Builder() {
        }

        public String getWorkspace() {
            return this.workspace;
        }

        public Builder setWorkspace(String workspace) {
            this.workspace = workspace;
            return this;
        }

        private Builder(WorkspaceName workspaceName) {
            this.workspace = workspaceName.workspace;
        }

        public WorkspaceName build() {
            return new WorkspaceName(this);
        }
    }
}

