/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/study.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Represents specification of a Study.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec}
 */
public final class StudySpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.StudySpec)
    StudySpecOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use StudySpec.newBuilder() to construct.
  private StudySpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private StudySpec() {
    metrics_ = java.util.Collections.emptyList();
    parameters_ = java.util.Collections.emptyList();
    algorithm_ = 0;
    observationNoise_ = 0;
    measurementSelectionType_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new StudySpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.StudyProto
        .internal_static_google_cloud_aiplatform_v1_StudySpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.StudyProto
        .internal_static_google_cloud_aiplatform_v1_StudySpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.StudySpec.class,
            com.google.cloud.aiplatform.v1.StudySpec.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * The available search algorithms for the Study.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.StudySpec.Algorithm}
   */
  public enum Algorithm implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default algorithm used by Vertex AI for [hyperparameter
     * tuning](https://cloud.google.com/vertex-ai/docs/training/hyperparameter-tuning-overview)
     * and [Vertex AI Vizier](https://cloud.google.com/vertex-ai/docs/vizier).
     * </pre>
     *
     * <code>ALGORITHM_UNSPECIFIED = 0;</code>
     */
    ALGORITHM_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Simple grid search within the feasible space. To use grid search,
     * all parameters must be `INTEGER`, `CATEGORICAL`, or `DISCRETE`.
     * </pre>
     *
     * <code>GRID_SEARCH = 2;</code>
     */
    GRID_SEARCH(2),
    /**
     *
     *
     * <pre>
     * Simple random search within the feasible space.
     * </pre>
     *
     * <code>RANDOM_SEARCH = 3;</code>
     */
    RANDOM_SEARCH(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default algorithm used by Vertex AI for [hyperparameter
     * tuning](https://cloud.google.com/vertex-ai/docs/training/hyperparameter-tuning-overview)
     * and [Vertex AI Vizier](https://cloud.google.com/vertex-ai/docs/vizier).
     * </pre>
     *
     * <code>ALGORITHM_UNSPECIFIED = 0;</code>
     */
    public static final int ALGORITHM_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Simple grid search within the feasible space. To use grid search,
     * all parameters must be `INTEGER`, `CATEGORICAL`, or `DISCRETE`.
     * </pre>
     *
     * <code>GRID_SEARCH = 2;</code>
     */
    public static final int GRID_SEARCH_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Simple random search within the feasible space.
     * </pre>
     *
     * <code>RANDOM_SEARCH = 3;</code>
     */
    public static final int RANDOM_SEARCH_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Algorithm valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Algorithm forNumber(int value) {
      switch (value) {
        case 0:
          return ALGORITHM_UNSPECIFIED;
        case 2:
          return GRID_SEARCH;
        case 3:
          return RANDOM_SEARCH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Algorithm> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Algorithm> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Algorithm>() {
          public Algorithm findValueByNumber(int number) {
            return Algorithm.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.StudySpec.getDescriptor().getEnumTypes().get(0);
    }

    private static final Algorithm[] VALUES = values();

    public static Algorithm valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Algorithm(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.StudySpec.Algorithm)
  }

  /**
   *
   *
   * <pre>
   * Describes the noise level of the repeated observations.
   *
   * "Noisy" means that the repeated observations with the same Trial parameters
   * may lead to different metric evaluations.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.StudySpec.ObservationNoise}
   */
  public enum ObservationNoise implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * The default noise level chosen by Vertex AI.
     * </pre>
     *
     * <code>OBSERVATION_NOISE_UNSPECIFIED = 0;</code>
     */
    OBSERVATION_NOISE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Vertex AI assumes that the objective function is (nearly)
     * perfectly reproducible, and will never repeat the same Trial
     * parameters.
     * </pre>
     *
     * <code>LOW = 1;</code>
     */
    LOW(1),
    /**
     *
     *
     * <pre>
     * Vertex AI will estimate the amount of noise in metric
     * evaluations, it may repeat the same Trial parameters more than once.
     * </pre>
     *
     * <code>HIGH = 2;</code>
     */
    HIGH(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * The default noise level chosen by Vertex AI.
     * </pre>
     *
     * <code>OBSERVATION_NOISE_UNSPECIFIED = 0;</code>
     */
    public static final int OBSERVATION_NOISE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Vertex AI assumes that the objective function is (nearly)
     * perfectly reproducible, and will never repeat the same Trial
     * parameters.
     * </pre>
     *
     * <code>LOW = 1;</code>
     */
    public static final int LOW_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Vertex AI will estimate the amount of noise in metric
     * evaluations, it may repeat the same Trial parameters more than once.
     * </pre>
     *
     * <code>HIGH = 2;</code>
     */
    public static final int HIGH_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ObservationNoise valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static ObservationNoise forNumber(int value) {
      switch (value) {
        case 0:
          return OBSERVATION_NOISE_UNSPECIFIED;
        case 1:
          return LOW;
        case 2:
          return HIGH;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<ObservationNoise> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<ObservationNoise>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<ObservationNoise>() {
              public ObservationNoise findValueByNumber(int number) {
                return ObservationNoise.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.StudySpec.getDescriptor().getEnumTypes().get(1);
    }

    private static final ObservationNoise[] VALUES = values();

    public static ObservationNoise valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private ObservationNoise(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.StudySpec.ObservationNoise)
  }

  /**
   *
   *
   * <pre>
   * This indicates which measurement to use if/when the service automatically
   * selects the final measurement from previously reported intermediate
   * measurements. Choose this based on two considerations:
   *  A) Do you expect your measurements to monotonically improve?
   *     If so, choose LAST_MEASUREMENT. On the other hand, if you're in a
   *     situation where your system can "over-train" and you expect the
   *     performance to get better for a while but then start declining,
   *     choose BEST_MEASUREMENT.
   *  B) Are your measurements significantly noisy and/or irreproducible?
   *     If so, BEST_MEASUREMENT will tend to be over-optimistic, and it
   *     may be better to choose LAST_MEASUREMENT.
   *  If both or neither of (A) and (B) apply, it doesn't matter which
   *  selection type is chosen.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType}
   */
  public enum MeasurementSelectionType implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Will be treated as LAST_MEASUREMENT.
     * </pre>
     *
     * <code>MEASUREMENT_SELECTION_TYPE_UNSPECIFIED = 0;</code>
     */
    MEASUREMENT_SELECTION_TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * Use the last measurement reported.
     * </pre>
     *
     * <code>LAST_MEASUREMENT = 1;</code>
     */
    LAST_MEASUREMENT(1),
    /**
     *
     *
     * <pre>
     * Use the best measurement reported.
     * </pre>
     *
     * <code>BEST_MEASUREMENT = 2;</code>
     */
    BEST_MEASUREMENT(2),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Will be treated as LAST_MEASUREMENT.
     * </pre>
     *
     * <code>MEASUREMENT_SELECTION_TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int MEASUREMENT_SELECTION_TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * Use the last measurement reported.
     * </pre>
     *
     * <code>LAST_MEASUREMENT = 1;</code>
     */
    public static final int LAST_MEASUREMENT_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Use the best measurement reported.
     * </pre>
     *
     * <code>BEST_MEASUREMENT = 2;</code>
     */
    public static final int BEST_MEASUREMENT_VALUE = 2;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static MeasurementSelectionType valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static MeasurementSelectionType forNumber(int value) {
      switch (value) {
        case 0:
          return MEASUREMENT_SELECTION_TYPE_UNSPECIFIED;
        case 1:
          return LAST_MEASUREMENT;
        case 2:
          return BEST_MEASUREMENT;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<MeasurementSelectionType>
        internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<MeasurementSelectionType>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<MeasurementSelectionType>() {
              public MeasurementSelectionType findValueByNumber(int number) {
                return MeasurementSelectionType.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.StudySpec.getDescriptor().getEnumTypes().get(2);
    }

    private static final MeasurementSelectionType[] VALUES = values();

    public static MeasurementSelectionType valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private MeasurementSelectionType(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType)
  }

  public interface MetricSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.StudySpec.MetricSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The ID of the metric. Must not contain whitespaces and must be
     * unique amongst all MetricSpecs.
     * </pre>
     *
     * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The metricId.
     */
    java.lang.String getMetricId();
    /**
     *
     *
     * <pre>
     * Required. The ID of the metric. Must not contain whitespaces and must be
     * unique amongst all MetricSpecs.
     * </pre>
     *
     * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for metricId.
     */
    com.google.protobuf.ByteString getMetricIdBytes();

    /**
     *
     *
     * <pre>
     * Required. The optimization goal of the metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for goal.
     */
    int getGoalValue();
    /**
     *
     *
     * <pre>
     * Required. The optimization goal of the metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The goal.
     */
    com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType getGoal();

    /**
     *
     *
     * <pre>
     * Used for safe search. In the case, the metric will be a safety
     * metric. You must provide a separate metric for objective metric.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safety_config = 3;
     * </code>
     *
     * @return Whether the safetyConfig field is set.
     */
    boolean hasSafetyConfig();
    /**
     *
     *
     * <pre>
     * Used for safe search. In the case, the metric will be a safety
     * metric. You must provide a separate metric for objective metric.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safety_config = 3;
     * </code>
     *
     * @return The safetyConfig.
     */
    com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig getSafetyConfig();
    /**
     *
     *
     * <pre>
     * Used for safe search. In the case, the metric will be a safety
     * metric. You must provide a separate metric for objective metric.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safety_config = 3;
     * </code>
     */
    com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfigOrBuilder
        getSafetyConfigOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * Represents a metric to optimize.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.MetricSpec}
   */
  public static final class MetricSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.StudySpec.MetricSpec)
      MetricSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MetricSpec.newBuilder() to construct.
    private MetricSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MetricSpec() {
      metricId_ = "";
      goal_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MetricSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_StudySpec_MetricSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_StudySpec_MetricSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.class,
              com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The available types of optimization goals.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType}
     */
    public enum GoalType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Goal Type will default to maximize.
       * </pre>
       *
       * <code>GOAL_TYPE_UNSPECIFIED = 0;</code>
       */
      GOAL_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Maximize the goal metric.
       * </pre>
       *
       * <code>MAXIMIZE = 1;</code>
       */
      MAXIMIZE(1),
      /**
       *
       *
       * <pre>
       * Minimize the goal metric.
       * </pre>
       *
       * <code>MINIMIZE = 2;</code>
       */
      MINIMIZE(2),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Goal Type will default to maximize.
       * </pre>
       *
       * <code>GOAL_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int GOAL_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Maximize the goal metric.
       * </pre>
       *
       * <code>MAXIMIZE = 1;</code>
       */
      public static final int MAXIMIZE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Minimize the goal metric.
       * </pre>
       *
       * <code>MINIMIZE = 2;</code>
       */
      public static final int MINIMIZE_VALUE = 2;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static GoalType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static GoalType forNumber(int value) {
        switch (value) {
          case 0:
            return GOAL_TYPE_UNSPECIFIED;
          case 1:
            return MAXIMIZE;
          case 2:
            return MINIMIZE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<GoalType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<GoalType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<GoalType>() {
            public GoalType findValueByNumber(int number) {
              return GoalType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final GoalType[] VALUES = values();

      public static GoalType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private GoalType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType)
    }

    public interface SafetyMetricConfigOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Safety threshold (boundary value between safe and unsafe). NOTE that if
       * you leave SafetyMetricConfig unset, a default value of 0 will be used.
       * </pre>
       *
       * <code>double safety_threshold = 1;</code>
       *
       * @return The safetyThreshold.
       */
      double getSafetyThreshold();

      /**
       *
       *
       * <pre>
       * Desired minimum fraction of safe trials (over total number of trials)
       * that should be targeted by the algorithm at any time during the
       * study (best effort). This should be between 0.0 and 1.0 and a value of
       * 0.0 means that there is no minimum and an algorithm proceeds without
       * targeting any specific fraction. A value of 1.0 means that the
       * algorithm attempts to only Suggest safe Trials.
       * </pre>
       *
       * <code>optional double desired_min_safe_trials_fraction = 2;</code>
       *
       * @return Whether the desiredMinSafeTrialsFraction field is set.
       */
      boolean hasDesiredMinSafeTrialsFraction();
      /**
       *
       *
       * <pre>
       * Desired minimum fraction of safe trials (over total number of trials)
       * that should be targeted by the algorithm at any time during the
       * study (best effort). This should be between 0.0 and 1.0 and a value of
       * 0.0 means that there is no minimum and an algorithm proceeds without
       * targeting any specific fraction. A value of 1.0 means that the
       * algorithm attempts to only Suggest safe Trials.
       * </pre>
       *
       * <code>optional double desired_min_safe_trials_fraction = 2;</code>
       *
       * @return The desiredMinSafeTrialsFraction.
       */
      double getDesiredMinSafeTrialsFraction();
    }
    /**
     *
     *
     * <pre>
     * Used in safe optimization to specify threshold levels and risk tolerance.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig}
     */
    public static final class SafetyMetricConfig extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig)
        SafetyMetricConfigOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use SafetyMetricConfig.newBuilder() to construct.
      private SafetyMetricConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private SafetyMetricConfig() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new SafetyMetricConfig();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_MetricSpec_SafetyMetricConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_MetricSpec_SafetyMetricConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig.class,
                com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig.Builder
                    .class);
      }

      private int bitField0_;
      public static final int SAFETY_THRESHOLD_FIELD_NUMBER = 1;
      private double safetyThreshold_ = 0D;
      /**
       *
       *
       * <pre>
       * Safety threshold (boundary value between safe and unsafe). NOTE that if
       * you leave SafetyMetricConfig unset, a default value of 0 will be used.
       * </pre>
       *
       * <code>double safety_threshold = 1;</code>
       *
       * @return The safetyThreshold.
       */
      @java.lang.Override
      public double getSafetyThreshold() {
        return safetyThreshold_;
      }

      public static final int DESIRED_MIN_SAFE_TRIALS_FRACTION_FIELD_NUMBER = 2;
      private double desiredMinSafeTrialsFraction_ = 0D;
      /**
       *
       *
       * <pre>
       * Desired minimum fraction of safe trials (over total number of trials)
       * that should be targeted by the algorithm at any time during the
       * study (best effort). This should be between 0.0 and 1.0 and a value of
       * 0.0 means that there is no minimum and an algorithm proceeds without
       * targeting any specific fraction. A value of 1.0 means that the
       * algorithm attempts to only Suggest safe Trials.
       * </pre>
       *
       * <code>optional double desired_min_safe_trials_fraction = 2;</code>
       *
       * @return Whether the desiredMinSafeTrialsFraction field is set.
       */
      @java.lang.Override
      public boolean hasDesiredMinSafeTrialsFraction() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * Desired minimum fraction of safe trials (over total number of trials)
       * that should be targeted by the algorithm at any time during the
       * study (best effort). This should be between 0.0 and 1.0 and a value of
       * 0.0 means that there is no minimum and an algorithm proceeds without
       * targeting any specific fraction. A value of 1.0 means that the
       * algorithm attempts to only Suggest safe Trials.
       * </pre>
       *
       * <code>optional double desired_min_safe_trials_fraction = 2;</code>
       *
       * @return The desiredMinSafeTrialsFraction.
       */
      @java.lang.Override
      public double getDesiredMinSafeTrialsFraction() {
        return desiredMinSafeTrialsFraction_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (java.lang.Double.doubleToRawLongBits(safetyThreshold_) != 0) {
          output.writeDouble(1, safetyThreshold_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeDouble(2, desiredMinSafeTrialsFraction_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (java.lang.Double.doubleToRawLongBits(safetyThreshold_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, safetyThreshold_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size +=
              com.google.protobuf.CodedOutputStream.computeDoubleSize(
                  2, desiredMinSafeTrialsFraction_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig other =
            (com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig) obj;

        if (java.lang.Double.doubleToLongBits(getSafetyThreshold())
            != java.lang.Double.doubleToLongBits(other.getSafetyThreshold())) return false;
        if (hasDesiredMinSafeTrialsFraction() != other.hasDesiredMinSafeTrialsFraction())
          return false;
        if (hasDesiredMinSafeTrialsFraction()) {
          if (java.lang.Double.doubleToLongBits(getDesiredMinSafeTrialsFraction())
              != java.lang.Double.doubleToLongBits(other.getDesiredMinSafeTrialsFraction()))
            return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + SAFETY_THRESHOLD_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getSafetyThreshold()));
        if (hasDesiredMinSafeTrialsFraction()) {
          hash = (37 * hash) + DESIRED_MIN_SAFE_TRIALS_FRACTION_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getDesiredMinSafeTrialsFraction()));
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Used in safe optimization to specify threshold levels and risk tolerance.
       * </pre>
       *
       * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig)
          com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfigOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_MetricSpec_SafetyMetricConfig_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_MetricSpec_SafetyMetricConfig_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig.class,
                  com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          safetyThreshold_ = 0D;
          desiredMinSafeTrialsFraction_ = 0D;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_MetricSpec_SafetyMetricConfig_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig build() {
          com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
            buildPartial() {
          com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig result =
              new com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.safetyThreshold_ = safetyThreshold_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.desiredMinSafeTrialsFraction_ = desiredMinSafeTrialsFraction_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig other) {
          if (other
              == com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
                  .getDefaultInstance()) return this;
          if (other.getSafetyThreshold() != 0D) {
            setSafetyThreshold(other.getSafetyThreshold());
          }
          if (other.hasDesiredMinSafeTrialsFraction()) {
            setDesiredMinSafeTrialsFraction(other.getDesiredMinSafeTrialsFraction());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 9:
                  {
                    safetyThreshold_ = input.readDouble();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 9
                case 17:
                  {
                    desiredMinSafeTrialsFraction_ = input.readDouble();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 17
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private double safetyThreshold_;
        /**
         *
         *
         * <pre>
         * Safety threshold (boundary value between safe and unsafe). NOTE that if
         * you leave SafetyMetricConfig unset, a default value of 0 will be used.
         * </pre>
         *
         * <code>double safety_threshold = 1;</code>
         *
         * @return The safetyThreshold.
         */
        @java.lang.Override
        public double getSafetyThreshold() {
          return safetyThreshold_;
        }
        /**
         *
         *
         * <pre>
         * Safety threshold (boundary value between safe and unsafe). NOTE that if
         * you leave SafetyMetricConfig unset, a default value of 0 will be used.
         * </pre>
         *
         * <code>double safety_threshold = 1;</code>
         *
         * @param value The safetyThreshold to set.
         * @return This builder for chaining.
         */
        public Builder setSafetyThreshold(double value) {

          safetyThreshold_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Safety threshold (boundary value between safe and unsafe). NOTE that if
         * you leave SafetyMetricConfig unset, a default value of 0 will be used.
         * </pre>
         *
         * <code>double safety_threshold = 1;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSafetyThreshold() {
          bitField0_ = (bitField0_ & ~0x00000001);
          safetyThreshold_ = 0D;
          onChanged();
          return this;
        }

        private double desiredMinSafeTrialsFraction_;
        /**
         *
         *
         * <pre>
         * Desired minimum fraction of safe trials (over total number of trials)
         * that should be targeted by the algorithm at any time during the
         * study (best effort). This should be between 0.0 and 1.0 and a value of
         * 0.0 means that there is no minimum and an algorithm proceeds without
         * targeting any specific fraction. A value of 1.0 means that the
         * algorithm attempts to only Suggest safe Trials.
         * </pre>
         *
         * <code>optional double desired_min_safe_trials_fraction = 2;</code>
         *
         * @return Whether the desiredMinSafeTrialsFraction field is set.
         */
        @java.lang.Override
        public boolean hasDesiredMinSafeTrialsFraction() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * Desired minimum fraction of safe trials (over total number of trials)
         * that should be targeted by the algorithm at any time during the
         * study (best effort). This should be between 0.0 and 1.0 and a value of
         * 0.0 means that there is no minimum and an algorithm proceeds without
         * targeting any specific fraction. A value of 1.0 means that the
         * algorithm attempts to only Suggest safe Trials.
         * </pre>
         *
         * <code>optional double desired_min_safe_trials_fraction = 2;</code>
         *
         * @return The desiredMinSafeTrialsFraction.
         */
        @java.lang.Override
        public double getDesiredMinSafeTrialsFraction() {
          return desiredMinSafeTrialsFraction_;
        }
        /**
         *
         *
         * <pre>
         * Desired minimum fraction of safe trials (over total number of trials)
         * that should be targeted by the algorithm at any time during the
         * study (best effort). This should be between 0.0 and 1.0 and a value of
         * 0.0 means that there is no minimum and an algorithm proceeds without
         * targeting any specific fraction. A value of 1.0 means that the
         * algorithm attempts to only Suggest safe Trials.
         * </pre>
         *
         * <code>optional double desired_min_safe_trials_fraction = 2;</code>
         *
         * @param value The desiredMinSafeTrialsFraction to set.
         * @return This builder for chaining.
         */
        public Builder setDesiredMinSafeTrialsFraction(double value) {

          desiredMinSafeTrialsFraction_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Desired minimum fraction of safe trials (over total number of trials)
         * that should be targeted by the algorithm at any time during the
         * study (best effort). This should be between 0.0 and 1.0 and a value of
         * 0.0 means that there is no minimum and an algorithm proceeds without
         * targeting any specific fraction. A value of 1.0 means that the
         * algorithm attempts to only Suggest safe Trials.
         * </pre>
         *
         * <code>optional double desired_min_safe_trials_fraction = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDesiredMinSafeTrialsFraction() {
          bitField0_ = (bitField0_ & ~0x00000002);
          desiredMinSafeTrialsFraction_ = 0D;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig)
      private static final com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig();
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<SafetyMetricConfig> PARSER =
          new com.google.protobuf.AbstractParser<SafetyMetricConfig>() {
            @java.lang.Override
            public SafetyMetricConfig parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<SafetyMetricConfig> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<SafetyMetricConfig> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int bitField0_;
    public static final int METRIC_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object metricId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of the metric. Must not contain whitespaces and must be
     * unique amongst all MetricSpecs.
     * </pre>
     *
     * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The metricId.
     */
    @java.lang.Override
    public java.lang.String getMetricId() {
      java.lang.Object ref = metricId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metricId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the metric. Must not contain whitespaces and must be
     * unique amongst all MetricSpecs.
     * </pre>
     *
     * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for metricId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getMetricIdBytes() {
      java.lang.Object ref = metricId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metricId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int GOAL_FIELD_NUMBER = 2;
    private int goal_ = 0;
    /**
     *
     *
     * <pre>
     * Required. The optimization goal of the metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for goal.
     */
    @java.lang.Override
    public int getGoalValue() {
      return goal_;
    }
    /**
     *
     *
     * <pre>
     * Required. The optimization goal of the metric.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The goal.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType getGoal() {
      com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType result =
          com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType.forNumber(goal_);
      return result == null
          ? com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType.UNRECOGNIZED
          : result;
    }

    public static final int SAFETY_CONFIG_FIELD_NUMBER = 3;
    private com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safetyConfig_;
    /**
     *
     *
     * <pre>
     * Used for safe search. In the case, the metric will be a safety
     * metric. You must provide a separate metric for objective metric.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safety_config = 3;
     * </code>
     *
     * @return Whether the safetyConfig field is set.
     */
    @java.lang.Override
    public boolean hasSafetyConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Used for safe search. In the case, the metric will be a safety
     * metric. You must provide a separate metric for objective metric.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safety_config = 3;
     * </code>
     *
     * @return The safetyConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
        getSafetyConfig() {
      return safetyConfig_ == null
          ? com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
              .getDefaultInstance()
          : safetyConfig_;
    }
    /**
     *
     *
     * <pre>
     * Used for safe search. In the case, the metric will be a safety
     * metric. You must provide a separate metric for objective metric.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safety_config = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfigOrBuilder
        getSafetyConfigOrBuilder() {
      return safetyConfig_ == null
          ? com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
              .getDefaultInstance()
          : safetyConfig_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, metricId_);
      }
      if (goal_
          != com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType.GOAL_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, goal_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(3, getSafetyConfig());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, metricId_);
      }
      if (goal_
          != com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType.GOAL_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, goal_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getSafetyConfig());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.StudySpec.MetricSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.StudySpec.MetricSpec other =
          (com.google.cloud.aiplatform.v1.StudySpec.MetricSpec) obj;

      if (!getMetricId().equals(other.getMetricId())) return false;
      if (goal_ != other.goal_) return false;
      if (hasSafetyConfig() != other.hasSafetyConfig()) return false;
      if (hasSafetyConfig()) {
        if (!getSafetyConfig().equals(other.getSafetyConfig())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + METRIC_ID_FIELD_NUMBER;
      hash = (53 * hash) + getMetricId().hashCode();
      hash = (37 * hash) + GOAL_FIELD_NUMBER;
      hash = (53 * hash) + goal_;
      if (hasSafetyConfig()) {
        hash = (37 * hash) + SAFETY_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getSafetyConfig().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.StudySpec.MetricSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents a metric to optimize.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.MetricSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.StudySpec.MetricSpec)
        com.google.cloud.aiplatform.v1.StudySpec.MetricSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_MetricSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_MetricSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.class,
                com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getSafetyConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        metricId_ = "";
        goal_ = 0;
        safetyConfig_ = null;
        if (safetyConfigBuilder_ != null) {
          safetyConfigBuilder_.dispose();
          safetyConfigBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_MetricSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec build() {
        com.google.cloud.aiplatform.v1.StudySpec.MetricSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec buildPartial() {
        com.google.cloud.aiplatform.v1.StudySpec.MetricSpec result =
            new com.google.cloud.aiplatform.v1.StudySpec.MetricSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.StudySpec.MetricSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.metricId_ = metricId_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.goal_ = goal_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.safetyConfig_ =
              safetyConfigBuilder_ == null ? safetyConfig_ : safetyConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.StudySpec.MetricSpec) {
          return mergeFrom((com.google.cloud.aiplatform.v1.StudySpec.MetricSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.StudySpec.MetricSpec other) {
        if (other == com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.getDefaultInstance())
          return this;
        if (!other.getMetricId().isEmpty()) {
          metricId_ = other.metricId_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.goal_ != 0) {
          setGoalValue(other.getGoalValue());
        }
        if (other.hasSafetyConfig()) {
          mergeSafetyConfig(other.getSafetyConfig());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  metricId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  goal_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 26:
                {
                  input.readMessage(getSafetyConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object metricId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of the metric. Must not contain whitespaces and must be
       * unique amongst all MetricSpecs.
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The metricId.
       */
      public java.lang.String getMetricId() {
        java.lang.Object ref = metricId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          metricId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the metric. Must not contain whitespaces and must be
       * unique amongst all MetricSpecs.
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for metricId.
       */
      public com.google.protobuf.ByteString getMetricIdBytes() {
        java.lang.Object ref = metricId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          metricId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the metric. Must not contain whitespaces and must be
       * unique amongst all MetricSpecs.
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The metricId to set.
       * @return This builder for chaining.
       */
      public Builder setMetricId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        metricId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the metric. Must not contain whitespaces and must be
       * unique amongst all MetricSpecs.
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMetricId() {
        metricId_ = getDefaultInstance().getMetricId();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the metric. Must not contain whitespaces and must be
       * unique amongst all MetricSpecs.
       * </pre>
       *
       * <code>string metric_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for metricId to set.
       * @return This builder for chaining.
       */
      public Builder setMetricIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        metricId_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int goal_ = 0;
      /**
       *
       *
       * <pre>
       * Required. The optimization goal of the metric.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for goal.
       */
      @java.lang.Override
      public int getGoalValue() {
        return goal_;
      }
      /**
       *
       *
       * <pre>
       * Required. The optimization goal of the metric.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for goal to set.
       * @return This builder for chaining.
       */
      public Builder setGoalValue(int value) {
        goal_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The optimization goal of the metric.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The goal.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType getGoal() {
        com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType result =
            com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType.forNumber(goal_);
        return result == null
            ? com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * Required. The optimization goal of the metric.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The goal to set.
       * @return This builder for chaining.
       */
      public Builder setGoal(com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        goal_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The optimization goal of the metric.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.MetricSpec.GoalType goal = 2 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearGoal() {
        bitField0_ = (bitField0_ & ~0x00000002);
        goal_ = 0;
        onChanged();
        return this;
      }

      private com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safetyConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig,
              com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig.Builder,
              com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfigOrBuilder>
          safetyConfigBuilder_;
      /**
       *
       *
       * <pre>
       * Used for safe search. In the case, the metric will be a safety
       * metric. You must provide a separate metric for objective metric.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safety_config = 3;
       * </code>
       *
       * @return Whether the safetyConfig field is set.
       */
      public boolean hasSafetyConfig() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * Used for safe search. In the case, the metric will be a safety
       * metric. You must provide a separate metric for objective metric.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safety_config = 3;
       * </code>
       *
       * @return The safetyConfig.
       */
      public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
          getSafetyConfig() {
        if (safetyConfigBuilder_ == null) {
          return safetyConfig_ == null
              ? com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
                  .getDefaultInstance()
              : safetyConfig_;
        } else {
          return safetyConfigBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Used for safe search. In the case, the metric will be a safety
       * metric. You must provide a separate metric for objective metric.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safety_config = 3;
       * </code>
       */
      public Builder setSafetyConfig(
          com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig value) {
        if (safetyConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          safetyConfig_ = value;
        } else {
          safetyConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Used for safe search. In the case, the metric will be a safety
       * metric. You must provide a separate metric for objective metric.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safety_config = 3;
       * </code>
       */
      public Builder setSafetyConfig(
          com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig.Builder
              builderForValue) {
        if (safetyConfigBuilder_ == null) {
          safetyConfig_ = builderForValue.build();
        } else {
          safetyConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Used for safe search. In the case, the metric will be a safety
       * metric. You must provide a separate metric for objective metric.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safety_config = 3;
       * </code>
       */
      public Builder mergeSafetyConfig(
          com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig value) {
        if (safetyConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && safetyConfig_ != null
              && safetyConfig_
                  != com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
                      .getDefaultInstance()) {
            getSafetyConfigBuilder().mergeFrom(value);
          } else {
            safetyConfig_ = value;
          }
        } else {
          safetyConfigBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Used for safe search. In the case, the metric will be a safety
       * metric. You must provide a separate metric for objective metric.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safety_config = 3;
       * </code>
       */
      public Builder clearSafetyConfig() {
        bitField0_ = (bitField0_ & ~0x00000004);
        safetyConfig_ = null;
        if (safetyConfigBuilder_ != null) {
          safetyConfigBuilder_.dispose();
          safetyConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Used for safe search. In the case, the metric will be a safety
       * metric. You must provide a separate metric for objective metric.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safety_config = 3;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig.Builder
          getSafetyConfigBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getSafetyConfigFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Used for safe search. In the case, the metric will be a safety
       * metric. You must provide a separate metric for objective metric.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safety_config = 3;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfigOrBuilder
          getSafetyConfigOrBuilder() {
        if (safetyConfigBuilder_ != null) {
          return safetyConfigBuilder_.getMessageOrBuilder();
        } else {
          return safetyConfig_ == null
              ? com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig
                  .getDefaultInstance()
              : safetyConfig_;
        }
      }
      /**
       *
       *
       * <pre>
       * Used for safe search. In the case, the metric will be a safety
       * metric. You must provide a separate metric for objective metric.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig safety_config = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig,
              com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig.Builder,
              com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfigOrBuilder>
          getSafetyConfigFieldBuilder() {
        if (safetyConfigBuilder_ == null) {
          safetyConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig,
                  com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfig.Builder,
                  com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.SafetyMetricConfigOrBuilder>(
                  getSafetyConfig(), getParentForChildren(), isClean());
          safetyConfig_ = null;
        }
        return safetyConfigBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.StudySpec.MetricSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.StudySpec.MetricSpec)
    private static final com.google.cloud.aiplatform.v1.StudySpec.MetricSpec DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.StudySpec.MetricSpec();
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MetricSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MetricSpec> PARSER =
        new com.google.protobuf.AbstractParser<MetricSpec>() {
          @java.lang.Override
          public MetricSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MetricSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MetricSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ParameterSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.StudySpec.ParameterSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The value spec for a 'DOUBLE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
     * </code>
     *
     * @return Whether the doubleValueSpec field is set.
     */
    boolean hasDoubleValueSpec();
    /**
     *
     *
     * <pre>
     * The value spec for a 'DOUBLE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
     * </code>
     *
     * @return The doubleValueSpec.
     */
    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec getDoubleValueSpec();
    /**
     *
     *
     * <pre>
     * The value spec for a 'DOUBLE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
     * </code>
     */
    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpecOrBuilder
        getDoubleValueSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * The value spec for an 'INTEGER' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
     * </code>
     *
     * @return Whether the integerValueSpec field is set.
     */
    boolean hasIntegerValueSpec();
    /**
     *
     *
     * <pre>
     * The value spec for an 'INTEGER' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
     * </code>
     *
     * @return The integerValueSpec.
     */
    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec getIntegerValueSpec();
    /**
     *
     *
     * <pre>
     * The value spec for an 'INTEGER' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
     * </code>
     */
    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpecOrBuilder
        getIntegerValueSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * The value spec for a 'CATEGORICAL' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
     * </code>
     *
     * @return Whether the categoricalValueSpec field is set.
     */
    boolean hasCategoricalValueSpec();
    /**
     *
     *
     * <pre>
     * The value spec for a 'CATEGORICAL' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
     * </code>
     *
     * @return The categoricalValueSpec.
     */
    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
        getCategoricalValueSpec();
    /**
     *
     *
     * <pre>
     * The value spec for a 'CATEGORICAL' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
     * </code>
     */
    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpecOrBuilder
        getCategoricalValueSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * The value spec for a 'DISCRETE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
     * </code>
     *
     * @return Whether the discreteValueSpec field is set.
     */
    boolean hasDiscreteValueSpec();
    /**
     *
     *
     * <pre>
     * The value spec for a 'DISCRETE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
     * </code>
     *
     * @return The discreteValueSpec.
     */
    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec getDiscreteValueSpec();
    /**
     *
     *
     * <pre>
     * The value spec for a 'DISCRETE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
     * </code>
     */
    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpecOrBuilder
        getDiscreteValueSpecOrBuilder();

    /**
     *
     *
     * <pre>
     * Required. The ID of the parameter. Must not contain whitespaces and must
     * be unique amongst all ParameterSpecs.
     * </pre>
     *
     * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parameterId.
     */
    java.lang.String getParameterId();
    /**
     *
     *
     * <pre>
     * Required. The ID of the parameter. Must not contain whitespaces and must
     * be unique amongst all ParameterSpecs.
     * </pre>
     *
     * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parameterId.
     */
    com.google.protobuf.ByteString getParameterIdBytes();

    /**
     *
     *
     * <pre>
     * How the parameter should be scaled.
     * Leave unset for `CATEGORICAL` parameters.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType scale_type = 6;</code>
     *
     * @return The enum numeric value on the wire for scaleType.
     */
    int getScaleTypeValue();
    /**
     *
     *
     * <pre>
     * How the parameter should be scaled.
     * Leave unset for `CATEGORICAL` parameters.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType scale_type = 6;</code>
     *
     * @return The scaleType.
     */
    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType getScaleType();

    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     *
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    java.util.List<com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec>
        getConditionalParameterSpecsList();
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     *
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
        getConditionalParameterSpecs(int index);
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     *
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    int getConditionalParameterSpecsCount();
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     *
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                    .ConditionalParameterSpecOrBuilder>
        getConditionalParameterSpecsOrBuilderList();
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     *
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpecOrBuilder
        getConditionalParameterSpecsOrBuilder(int index);

    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ParameterValueSpecCase
        getParameterValueSpecCase();
  }
  /**
   *
   *
   * <pre>
   * Represents a single parameter to optimize.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.ParameterSpec}
   */
  public static final class ParameterSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec)
      ParameterSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ParameterSpec.newBuilder() to construct.
    private ParameterSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ParameterSpec() {
      parameterId_ = "";
      scaleType_ = 0;
      conditionalParameterSpecs_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ParameterSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.class,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * The type of scaling that should be applied to this parameter.
     * </pre>
     *
     * Protobuf enum {@code google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType}
     */
    public enum ScaleType implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * By default, no scaling is applied.
       * </pre>
       *
       * <code>SCALE_TYPE_UNSPECIFIED = 0;</code>
       */
      SCALE_TYPE_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Scales the feasible space to (0, 1) linearly.
       * </pre>
       *
       * <code>UNIT_LINEAR_SCALE = 1;</code>
       */
      UNIT_LINEAR_SCALE(1),
      /**
       *
       *
       * <pre>
       * Scales the feasible space logarithmically to (0, 1). The entire
       * feasible space must be strictly positive.
       * </pre>
       *
       * <code>UNIT_LOG_SCALE = 2;</code>
       */
      UNIT_LOG_SCALE(2),
      /**
       *
       *
       * <pre>
       * Scales the feasible space "reverse" logarithmically to (0, 1). The
       * result is that values close to the top of the feasible space are spread
       * out more than points near the bottom. The entire feasible space must be
       * strictly positive.
       * </pre>
       *
       * <code>UNIT_REVERSE_LOG_SCALE = 3;</code>
       */
      UNIT_REVERSE_LOG_SCALE(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * By default, no scaling is applied.
       * </pre>
       *
       * <code>SCALE_TYPE_UNSPECIFIED = 0;</code>
       */
      public static final int SCALE_TYPE_UNSPECIFIED_VALUE = 0;
      /**
       *
       *
       * <pre>
       * Scales the feasible space to (0, 1) linearly.
       * </pre>
       *
       * <code>UNIT_LINEAR_SCALE = 1;</code>
       */
      public static final int UNIT_LINEAR_SCALE_VALUE = 1;
      /**
       *
       *
       * <pre>
       * Scales the feasible space logarithmically to (0, 1). The entire
       * feasible space must be strictly positive.
       * </pre>
       *
       * <code>UNIT_LOG_SCALE = 2;</code>
       */
      public static final int UNIT_LOG_SCALE_VALUE = 2;
      /**
       *
       *
       * <pre>
       * Scales the feasible space "reverse" logarithmically to (0, 1). The
       * result is that values close to the top of the feasible space are spread
       * out more than points near the bottom. The entire feasible space must be
       * strictly positive.
       * </pre>
       *
       * <code>UNIT_REVERSE_LOG_SCALE = 3;</code>
       */
      public static final int UNIT_REVERSE_LOG_SCALE_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ScaleType valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static ScaleType forNumber(int value) {
        switch (value) {
          case 0:
            return SCALE_TYPE_UNSPECIFIED;
          case 1:
            return UNIT_LINEAR_SCALE;
          case 2:
            return UNIT_LOG_SCALE;
          case 3:
            return UNIT_REVERSE_LOG_SCALE;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<ScaleType> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<ScaleType> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<ScaleType>() {
            public ScaleType findValueByNumber(int number) {
              return ScaleType.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final ScaleType[] VALUES = values();

      public static ScaleType valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private ScaleType(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType)
    }

    public interface DoubleValueSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Inclusive minimum value of the parameter.
       * </pre>
       *
       * <code>double min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The minValue.
       */
      double getMinValue();

      /**
       *
       *
       * <pre>
       * Required. Inclusive maximum value of the parameter.
       * </pre>
       *
       * <code>double max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxValue.
       */
      double getMaxValue();

      /**
       *
       *
       * <pre>
       * A default value for a `DOUBLE` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional double default_value = 4;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      boolean hasDefaultValue();
      /**
       *
       *
       * <pre>
       * A default value for a `DOUBLE` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional double default_value = 4;</code>
       *
       * @return The defaultValue.
       */
      double getDefaultValue();
    }
    /**
     *
     *
     * <pre>
     * Value specification for a parameter in `DOUBLE` type.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec}
     */
    public static final class DoubleValueSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec)
        DoubleValueSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use DoubleValueSpec.newBuilder() to construct.
      private DoubleValueSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DoubleValueSpec() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DoubleValueSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_DoubleValueSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_DoubleValueSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec.class,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec.Builder
                    .class);
      }

      private int bitField0_;
      public static final int MIN_VALUE_FIELD_NUMBER = 1;
      private double minValue_ = 0D;
      /**
       *
       *
       * <pre>
       * Required. Inclusive minimum value of the parameter.
       * </pre>
       *
       * <code>double min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The minValue.
       */
      @java.lang.Override
      public double getMinValue() {
        return minValue_;
      }

      public static final int MAX_VALUE_FIELD_NUMBER = 2;
      private double maxValue_ = 0D;
      /**
       *
       *
       * <pre>
       * Required. Inclusive maximum value of the parameter.
       * </pre>
       *
       * <code>double max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxValue.
       */
      @java.lang.Override
      public double getMaxValue() {
        return maxValue_;
      }

      public static final int DEFAULT_VALUE_FIELD_NUMBER = 4;
      private double defaultValue_ = 0D;
      /**
       *
       *
       * <pre>
       * A default value for a `DOUBLE` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional double default_value = 4;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      @java.lang.Override
      public boolean hasDefaultValue() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * A default value for a `DOUBLE` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional double default_value = 4;</code>
       *
       * @return The defaultValue.
       */
      @java.lang.Override
      public double getDefaultValue() {
        return defaultValue_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (java.lang.Double.doubleToRawLongBits(minValue_) != 0) {
          output.writeDouble(1, minValue_);
        }
        if (java.lang.Double.doubleToRawLongBits(maxValue_) != 0) {
          output.writeDouble(2, maxValue_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeDouble(4, defaultValue_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (java.lang.Double.doubleToRawLongBits(minValue_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(1, minValue_);
        }
        if (java.lang.Double.doubleToRawLongBits(maxValue_) != 0) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, maxValue_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(4, defaultValue_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec other =
            (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec) obj;

        if (java.lang.Double.doubleToLongBits(getMinValue())
            != java.lang.Double.doubleToLongBits(other.getMinValue())) return false;
        if (java.lang.Double.doubleToLongBits(getMaxValue())
            != java.lang.Double.doubleToLongBits(other.getMaxValue())) return false;
        if (hasDefaultValue() != other.hasDefaultValue()) return false;
        if (hasDefaultValue()) {
          if (java.lang.Double.doubleToLongBits(getDefaultValue())
              != java.lang.Double.doubleToLongBits(other.getDefaultValue())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MIN_VALUE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getMinValue()));
        hash = (37 * hash) + MAX_VALUE_FIELD_NUMBER;
        hash =
            (53 * hash)
                + com.google.protobuf.Internal.hashLong(
                    java.lang.Double.doubleToLongBits(getMaxValue()));
        if (hasDefaultValue()) {
          hash = (37 * hash) + DEFAULT_VALUE_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getDefaultValue()));
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Value specification for a parameter in `DOUBLE` type.
       * </pre>
       *
       * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec)
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_DoubleValueSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_DoubleValueSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec.class,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          minValue_ = 0D;
          maxValue_ = 0D;
          defaultValue_ = 0D;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_DoubleValueSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec build() {
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
            buildPartial() {
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec result =
              new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.minValue_ = minValue_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.maxValue_ = maxValue_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.defaultValue_ = defaultValue_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec other) {
          if (other
              == com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
                  .getDefaultInstance()) return this;
          if (other.getMinValue() != 0D) {
            setMinValue(other.getMinValue());
          }
          if (other.getMaxValue() != 0D) {
            setMaxValue(other.getMaxValue());
          }
          if (other.hasDefaultValue()) {
            setDefaultValue(other.getDefaultValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 9:
                  {
                    minValue_ = input.readDouble();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 9
                case 17:
                  {
                    maxValue_ = input.readDouble();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 17
                case 33:
                  {
                    defaultValue_ = input.readDouble();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 33
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private double minValue_;
        /**
         *
         *
         * <pre>
         * Required. Inclusive minimum value of the parameter.
         * </pre>
         *
         * <code>double min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The minValue.
         */
        @java.lang.Override
        public double getMinValue() {
          return minValue_;
        }
        /**
         *
         *
         * <pre>
         * Required. Inclusive minimum value of the parameter.
         * </pre>
         *
         * <code>double min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The minValue to set.
         * @return This builder for chaining.
         */
        public Builder setMinValue(double value) {

          minValue_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Inclusive minimum value of the parameter.
         * </pre>
         *
         * <code>double min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMinValue() {
          bitField0_ = (bitField0_ & ~0x00000001);
          minValue_ = 0D;
          onChanged();
          return this;
        }

        private double maxValue_;
        /**
         *
         *
         * <pre>
         * Required. Inclusive maximum value of the parameter.
         * </pre>
         *
         * <code>double max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The maxValue.
         */
        @java.lang.Override
        public double getMaxValue() {
          return maxValue_;
        }
        /**
         *
         *
         * <pre>
         * Required. Inclusive maximum value of the parameter.
         * </pre>
         *
         * <code>double max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The maxValue to set.
         * @return This builder for chaining.
         */
        public Builder setMaxValue(double value) {

          maxValue_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Inclusive maximum value of the parameter.
         * </pre>
         *
         * <code>double max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          maxValue_ = 0D;
          onChanged();
          return this;
        }

        private double defaultValue_;
        /**
         *
         *
         * <pre>
         * A default value for a `DOUBLE` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional double default_value = 4;</code>
         *
         * @return Whether the defaultValue field is set.
         */
        @java.lang.Override
        public boolean hasDefaultValue() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * A default value for a `DOUBLE` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional double default_value = 4;</code>
         *
         * @return The defaultValue.
         */
        @java.lang.Override
        public double getDefaultValue() {
          return defaultValue_;
        }
        /**
         *
         *
         * <pre>
         * A default value for a `DOUBLE` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional double default_value = 4;</code>
         *
         * @param value The defaultValue to set.
         * @return This builder for chaining.
         */
        public Builder setDefaultValue(double value) {

          defaultValue_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A default value for a `DOUBLE` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional double default_value = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDefaultValue() {
          bitField0_ = (bitField0_ & ~0x00000004);
          defaultValue_ = 0D;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec)
      private static final com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec();
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DoubleValueSpec> PARSER =
          new com.google.protobuf.AbstractParser<DoubleValueSpec>() {
            @java.lang.Override
            public DoubleValueSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DoubleValueSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DoubleValueSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface IntegerValueSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Inclusive minimum value of the parameter.
       * </pre>
       *
       * <code>int64 min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The minValue.
       */
      long getMinValue();

      /**
       *
       *
       * <pre>
       * Required. Inclusive maximum value of the parameter.
       * </pre>
       *
       * <code>int64 max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxValue.
       */
      long getMaxValue();

      /**
       *
       *
       * <pre>
       * A default value for an `INTEGER` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional int64 default_value = 4;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      boolean hasDefaultValue();
      /**
       *
       *
       * <pre>
       * A default value for an `INTEGER` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional int64 default_value = 4;</code>
       *
       * @return The defaultValue.
       */
      long getDefaultValue();
    }
    /**
     *
     *
     * <pre>
     * Value specification for a parameter in `INTEGER` type.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec}
     */
    public static final class IntegerValueSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec)
        IntegerValueSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use IntegerValueSpec.newBuilder() to construct.
      private IntegerValueSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private IntegerValueSpec() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new IntegerValueSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_IntegerValueSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_IntegerValueSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec.class,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec.Builder
                    .class);
      }

      private int bitField0_;
      public static final int MIN_VALUE_FIELD_NUMBER = 1;
      private long minValue_ = 0L;
      /**
       *
       *
       * <pre>
       * Required. Inclusive minimum value of the parameter.
       * </pre>
       *
       * <code>int64 min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The minValue.
       */
      @java.lang.Override
      public long getMinValue() {
        return minValue_;
      }

      public static final int MAX_VALUE_FIELD_NUMBER = 2;
      private long maxValue_ = 0L;
      /**
       *
       *
       * <pre>
       * Required. Inclusive maximum value of the parameter.
       * </pre>
       *
       * <code>int64 max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The maxValue.
       */
      @java.lang.Override
      public long getMaxValue() {
        return maxValue_;
      }

      public static final int DEFAULT_VALUE_FIELD_NUMBER = 4;
      private long defaultValue_ = 0L;
      /**
       *
       *
       * <pre>
       * A default value for an `INTEGER` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional int64 default_value = 4;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      @java.lang.Override
      public boolean hasDefaultValue() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * A default value for an `INTEGER` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional int64 default_value = 4;</code>
       *
       * @return The defaultValue.
       */
      @java.lang.Override
      public long getDefaultValue() {
        return defaultValue_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (minValue_ != 0L) {
          output.writeInt64(1, minValue_);
        }
        if (maxValue_ != 0L) {
          output.writeInt64(2, maxValue_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeInt64(4, defaultValue_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (minValue_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, minValue_);
        }
        if (maxValue_ != 0L) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, maxValue_);
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, defaultValue_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec other =
            (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec) obj;

        if (getMinValue() != other.getMinValue()) return false;
        if (getMaxValue() != other.getMaxValue()) return false;
        if (hasDefaultValue() != other.hasDefaultValue()) return false;
        if (hasDefaultValue()) {
          if (getDefaultValue() != other.getDefaultValue()) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MIN_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMinValue());
        hash = (37 * hash) + MAX_VALUE_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxValue());
        if (hasDefaultValue()) {
          hash = (37 * hash) + DEFAULT_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getDefaultValue());
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Value specification for a parameter in `INTEGER` type.
       * </pre>
       *
       * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec)
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_IntegerValueSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_IntegerValueSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec.class,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          minValue_ = 0L;
          maxValue_ = 0L;
          defaultValue_ = 0L;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_IntegerValueSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec build() {
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
            buildPartial() {
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec result =
              new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.minValue_ = minValue_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.maxValue_ = maxValue_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.defaultValue_ = defaultValue_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec other) {
          if (other
              == com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
                  .getDefaultInstance()) return this;
          if (other.getMinValue() != 0L) {
            setMinValue(other.getMinValue());
          }
          if (other.getMaxValue() != 0L) {
            setMaxValue(other.getMaxValue());
          }
          if (other.hasDefaultValue()) {
            setDefaultValue(other.getDefaultValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 8:
                  {
                    minValue_ = input.readInt64();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 8
                case 16:
                  {
                    maxValue_ = input.readInt64();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 16
                case 32:
                  {
                    defaultValue_ = input.readInt64();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 32
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private long minValue_;
        /**
         *
         *
         * <pre>
         * Required. Inclusive minimum value of the parameter.
         * </pre>
         *
         * <code>int64 min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The minValue.
         */
        @java.lang.Override
        public long getMinValue() {
          return minValue_;
        }
        /**
         *
         *
         * <pre>
         * Required. Inclusive minimum value of the parameter.
         * </pre>
         *
         * <code>int64 min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The minValue to set.
         * @return This builder for chaining.
         */
        public Builder setMinValue(long value) {

          minValue_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Inclusive minimum value of the parameter.
         * </pre>
         *
         * <code>int64 min_value = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMinValue() {
          bitField0_ = (bitField0_ & ~0x00000001);
          minValue_ = 0L;
          onChanged();
          return this;
        }

        private long maxValue_;
        /**
         *
         *
         * <pre>
         * Required. Inclusive maximum value of the parameter.
         * </pre>
         *
         * <code>int64 max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The maxValue.
         */
        @java.lang.Override
        public long getMaxValue() {
          return maxValue_;
        }
        /**
         *
         *
         * <pre>
         * Required. Inclusive maximum value of the parameter.
         * </pre>
         *
         * <code>int64 max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The maxValue to set.
         * @return This builder for chaining.
         */
        public Builder setMaxValue(long value) {

          maxValue_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. Inclusive maximum value of the parameter.
         * </pre>
         *
         * <code>int64 max_value = 2 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearMaxValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          maxValue_ = 0L;
          onChanged();
          return this;
        }

        private long defaultValue_;
        /**
         *
         *
         * <pre>
         * A default value for an `INTEGER` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional int64 default_value = 4;</code>
         *
         * @return Whether the defaultValue field is set.
         */
        @java.lang.Override
        public boolean hasDefaultValue() {
          return ((bitField0_ & 0x00000004) != 0);
        }
        /**
         *
         *
         * <pre>
         * A default value for an `INTEGER` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional int64 default_value = 4;</code>
         *
         * @return The defaultValue.
         */
        @java.lang.Override
        public long getDefaultValue() {
          return defaultValue_;
        }
        /**
         *
         *
         * <pre>
         * A default value for an `INTEGER` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional int64 default_value = 4;</code>
         *
         * @param value The defaultValue to set.
         * @return This builder for chaining.
         */
        public Builder setDefaultValue(long value) {

          defaultValue_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A default value for an `INTEGER` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional int64 default_value = 4;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDefaultValue() {
          bitField0_ = (bitField0_ & ~0x00000004);
          defaultValue_ = 0L;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec)
      private static final com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec();
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<IntegerValueSpec> PARSER =
          new com.google.protobuf.AbstractParser<IntegerValueSpec>() {
            @java.lang.Override
            public IntegerValueSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<IntegerValueSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<IntegerValueSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface CategoricalValueSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. The list of possible categories.
       * </pre>
       *
       * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the values.
       */
      java.util.List<java.lang.String> getValuesList();
      /**
       *
       *
       * <pre>
       * Required. The list of possible categories.
       * </pre>
       *
       * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of values.
       */
      int getValuesCount();
      /**
       *
       *
       * <pre>
       * Required. The list of possible categories.
       * </pre>
       *
       * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The values at the given index.
       */
      java.lang.String getValues(int index);
      /**
       *
       *
       * <pre>
       * Required. The list of possible categories.
       * </pre>
       *
       * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the values at the given index.
       */
      com.google.protobuf.ByteString getValuesBytes(int index);

      /**
       *
       *
       * <pre>
       * A default value for a `CATEGORICAL` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional string default_value = 3;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      boolean hasDefaultValue();
      /**
       *
       *
       * <pre>
       * A default value for a `CATEGORICAL` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional string default_value = 3;</code>
       *
       * @return The defaultValue.
       */
      java.lang.String getDefaultValue();
      /**
       *
       *
       * <pre>
       * A default value for a `CATEGORICAL` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional string default_value = 3;</code>
       *
       * @return The bytes for defaultValue.
       */
      com.google.protobuf.ByteString getDefaultValueBytes();
    }
    /**
     *
     *
     * <pre>
     * Value specification for a parameter in `CATEGORICAL` type.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec}
     */
    public static final class CategoricalValueSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec)
        CategoricalValueSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use CategoricalValueSpec.newBuilder() to construct.
      private CategoricalValueSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private CategoricalValueSpec() {
        values_ = com.google.protobuf.LazyStringArrayList.emptyList();
        defaultValue_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new CategoricalValueSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_CategoricalValueSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_CategoricalValueSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec.class,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec.Builder
                    .class);
      }

      private int bitField0_;
      public static final int VALUES_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.LazyStringArrayList values_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      /**
       *
       *
       * <pre>
       * Required. The list of possible categories.
       * </pre>
       *
       * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the values.
       */
      public com.google.protobuf.ProtocolStringList getValuesList() {
        return values_;
      }
      /**
       *
       *
       * <pre>
       * Required. The list of possible categories.
       * </pre>
       *
       * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of values.
       */
      public int getValuesCount() {
        return values_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. The list of possible categories.
       * </pre>
       *
       * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The values at the given index.
       */
      public java.lang.String getValues(int index) {
        return values_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Required. The list of possible categories.
       * </pre>
       *
       * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the values at the given index.
       */
      public com.google.protobuf.ByteString getValuesBytes(int index) {
        return values_.getByteString(index);
      }

      public static final int DEFAULT_VALUE_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object defaultValue_ = "";
      /**
       *
       *
       * <pre>
       * A default value for a `CATEGORICAL` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional string default_value = 3;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      @java.lang.Override
      public boolean hasDefaultValue() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * A default value for a `CATEGORICAL` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional string default_value = 3;</code>
       *
       * @return The defaultValue.
       */
      @java.lang.Override
      public java.lang.String getDefaultValue() {
        java.lang.Object ref = defaultValue_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          defaultValue_ = s;
          return s;
        }
      }
      /**
       *
       *
       * <pre>
       * A default value for a `CATEGORICAL` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional string default_value = 3;</code>
       *
       * @return The bytes for defaultValue.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getDefaultValueBytes() {
        java.lang.Object ref = defaultValue_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          defaultValue_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        for (int i = 0; i < values_.size(); i++) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, values_.getRaw(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, defaultValue_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          for (int i = 0; i < values_.size(); i++) {
            dataSize += computeStringSizeNoTag(values_.getRaw(i));
          }
          size += dataSize;
          size += 1 * getValuesList().size();
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, defaultValue_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec other =
            (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec) obj;

        if (!getValuesList().equals(other.getValuesList())) return false;
        if (hasDefaultValue() != other.hasDefaultValue()) return false;
        if (hasDefaultValue()) {
          if (!getDefaultValue().equals(other.getDefaultValue())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getValuesCount() > 0) {
          hash = (37 * hash) + VALUES_FIELD_NUMBER;
          hash = (53 * hash) + getValuesList().hashCode();
        }
        if (hasDefaultValue()) {
          hash = (37 * hash) + DEFAULT_VALUE_FIELD_NUMBER;
          hash = (53 * hash) + getDefaultValue().hashCode();
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Value specification for a parameter in `CATEGORICAL` type.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec)
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_CategoricalValueSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_CategoricalValueSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec.class,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          values_ = com.google.protobuf.LazyStringArrayList.emptyList();
          defaultValue_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_CategoricalValueSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec build() {
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
            buildPartial() {
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec result =
              new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            values_.makeImmutable();
            result.values_ = values_;
          }
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.defaultValue_ = defaultValue_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec other) {
          if (other
              == com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
                  .getDefaultInstance()) return this;
          if (!other.values_.isEmpty()) {
            if (values_.isEmpty()) {
              values_ = other.values_;
              bitField0_ |= 0x00000001;
            } else {
              ensureValuesIsMutable();
              values_.addAll(other.values_);
            }
            onChanged();
          }
          if (other.hasDefaultValue()) {
            defaultValue_ = other.defaultValue_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    java.lang.String s = input.readStringRequireUtf8();
                    ensureValuesIsMutable();
                    values_.add(s);
                    break;
                  } // case 10
                case 26:
                  {
                    defaultValue_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 26
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.LazyStringArrayList values_ =
            com.google.protobuf.LazyStringArrayList.emptyList();

        private void ensureValuesIsMutable() {
          if (!values_.isModifiable()) {
            values_ = new com.google.protobuf.LazyStringArrayList(values_);
          }
          bitField0_ |= 0x00000001;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the values.
         */
        public com.google.protobuf.ProtocolStringList getValuesList() {
          values_.makeImmutable();
          return values_;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of values.
         */
        public int getValuesCount() {
          return values_.size();
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        public java.lang.String getValues(int index) {
          return values_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the values at the given index.
         */
        public com.google.protobuf.ByteString getValuesBytes(int index) {
          return values_.getByteString(index);
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index to set the value at.
         * @param value The values to set.
         * @return This builder for chaining.
         */
        public Builder setValues(int index, java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.set(index, value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The values to add.
         * @return This builder for chaining.
         */
        public Builder addValues(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureValuesIsMutable();
          values_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param values The values to add.
         * @return This builder for chaining.
         */
        public Builder addAllValues(java.lang.Iterable<java.lang.String> values) {
          ensureValuesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearValues() {
          values_ = com.google.protobuf.LazyStringArrayList.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          ;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The list of possible categories.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The bytes of the values to add.
         * @return This builder for chaining.
         */
        public Builder addValuesBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          ensureValuesIsMutable();
          values_.add(value);
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object defaultValue_ = "";
        /**
         *
         *
         * <pre>
         * A default value for a `CATEGORICAL` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional string default_value = 3;</code>
         *
         * @return Whether the defaultValue field is set.
         */
        public boolean hasDefaultValue() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * A default value for a `CATEGORICAL` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional string default_value = 3;</code>
         *
         * @return The defaultValue.
         */
        public java.lang.String getDefaultValue() {
          java.lang.Object ref = defaultValue_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            defaultValue_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A default value for a `CATEGORICAL` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional string default_value = 3;</code>
         *
         * @return The bytes for defaultValue.
         */
        public com.google.protobuf.ByteString getDefaultValueBytes() {
          java.lang.Object ref = defaultValue_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            defaultValue_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }
        /**
         *
         *
         * <pre>
         * A default value for a `CATEGORICAL` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional string default_value = 3;</code>
         *
         * @param value The defaultValue to set.
         * @return This builder for chaining.
         */
        public Builder setDefaultValue(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          defaultValue_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A default value for a `CATEGORICAL` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional string default_value = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDefaultValue() {
          defaultValue_ = getDefaultInstance().getDefaultValue();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A default value for a `CATEGORICAL` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional string default_value = 3;</code>
         *
         * @param value The bytes for defaultValue to set.
         * @return This builder for chaining.
         */
        public Builder setDefaultValueBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          defaultValue_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec)
      private static final com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
              .CategoricalValueSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec();
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<CategoricalValueSpec> PARSER =
          new com.google.protobuf.AbstractParser<CategoricalValueSpec>() {
            @java.lang.Override
            public CategoricalValueSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<CategoricalValueSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<CategoricalValueSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface DiscreteValueSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. A list of possible values.
       * The list should be in increasing order and at least 1e-10 apart.
       * For instance, this parameter might have possible settings of 1.5, 2.5,
       * and 4.0. This list should not contain more than 1,000 values.
       * </pre>
       *
       * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the values.
       */
      java.util.List<java.lang.Double> getValuesList();
      /**
       *
       *
       * <pre>
       * Required. A list of possible values.
       * The list should be in increasing order and at least 1e-10 apart.
       * For instance, this parameter might have possible settings of 1.5, 2.5,
       * and 4.0. This list should not contain more than 1,000 values.
       * </pre>
       *
       * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of values.
       */
      int getValuesCount();
      /**
       *
       *
       * <pre>
       * Required. A list of possible values.
       * The list should be in increasing order and at least 1e-10 apart.
       * For instance, this parameter might have possible settings of 1.5, 2.5,
       * and 4.0. This list should not contain more than 1,000 values.
       * </pre>
       *
       * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The values at the given index.
       */
      double getValues(int index);

      /**
       *
       *
       * <pre>
       * A default value for a `DISCRETE` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.  It automatically rounds to the
       * nearest feasible discrete point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional double default_value = 3;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      boolean hasDefaultValue();
      /**
       *
       *
       * <pre>
       * A default value for a `DISCRETE` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.  It automatically rounds to the
       * nearest feasible discrete point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional double default_value = 3;</code>
       *
       * @return The defaultValue.
       */
      double getDefaultValue();
    }
    /**
     *
     *
     * <pre>
     * Value specification for a parameter in `DISCRETE` type.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec}
     */
    public static final class DiscreteValueSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec)
        DiscreteValueSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use DiscreteValueSpec.newBuilder() to construct.
      private DiscreteValueSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private DiscreteValueSpec() {
        values_ = emptyDoubleList();
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new DiscreteValueSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_DiscreteValueSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_DiscreteValueSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec.class,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec.Builder
                    .class);
      }

      private int bitField0_;
      public static final int VALUES_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private com.google.protobuf.Internal.DoubleList values_;
      /**
       *
       *
       * <pre>
       * Required. A list of possible values.
       * The list should be in increasing order and at least 1e-10 apart.
       * For instance, this parameter might have possible settings of 1.5, 2.5,
       * and 4.0. This list should not contain more than 1,000 values.
       * </pre>
       *
       * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return A list containing the values.
       */
      @java.lang.Override
      public java.util.List<java.lang.Double> getValuesList() {
        return values_;
      }
      /**
       *
       *
       * <pre>
       * Required. A list of possible values.
       * The list should be in increasing order and at least 1e-10 apart.
       * For instance, this parameter might have possible settings of 1.5, 2.5,
       * and 4.0. This list should not contain more than 1,000 values.
       * </pre>
       *
       * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The count of values.
       */
      public int getValuesCount() {
        return values_.size();
      }
      /**
       *
       *
       * <pre>
       * Required. A list of possible values.
       * The list should be in increasing order and at least 1e-10 apart.
       * For instance, this parameter might have possible settings of 1.5, 2.5,
       * and 4.0. This list should not contain more than 1,000 values.
       * </pre>
       *
       * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param index The index of the element to return.
       * @return The values at the given index.
       */
      public double getValues(int index) {
        return values_.getDouble(index);
      }

      private int valuesMemoizedSerializedSize = -1;

      public static final int DEFAULT_VALUE_FIELD_NUMBER = 3;
      private double defaultValue_ = 0D;
      /**
       *
       *
       * <pre>
       * A default value for a `DISCRETE` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.  It automatically rounds to the
       * nearest feasible discrete point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional double default_value = 3;</code>
       *
       * @return Whether the defaultValue field is set.
       */
      @java.lang.Override
      public boolean hasDefaultValue() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * A default value for a `DISCRETE` parameter that is assumed to be a
       * relatively good starting point.  Unset value signals that there is no
       * offered starting point.  It automatically rounds to the
       * nearest feasible discrete point.
       *
       * Currently only supported by the Vertex AI Vizier service. Not supported
       * by HyperparameterTuningJob or TrainingPipeline.
       * </pre>
       *
       * <code>optional double default_value = 3;</code>
       *
       * @return The defaultValue.
       */
      @java.lang.Override
      public double getDefaultValue() {
        return defaultValue_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        getSerializedSize();
        if (getValuesList().size() > 0) {
          output.writeUInt32NoTag(10);
          output.writeUInt32NoTag(valuesMemoizedSerializedSize);
        }
        for (int i = 0; i < values_.size(); i++) {
          output.writeDoubleNoTag(values_.getDouble(i));
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          output.writeDouble(3, defaultValue_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        {
          int dataSize = 0;
          dataSize = 8 * getValuesList().size();
          size += dataSize;
          if (!getValuesList().isEmpty()) {
            size += 1;
            size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
          }
          valuesMemoizedSerializedSize = dataSize;
        }
        if (((bitField0_ & 0x00000001) != 0)) {
          size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, defaultValue_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec other =
            (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec) obj;

        if (!getValuesList().equals(other.getValuesList())) return false;
        if (hasDefaultValue() != other.hasDefaultValue()) return false;
        if (hasDefaultValue()) {
          if (java.lang.Double.doubleToLongBits(getDefaultValue())
              != java.lang.Double.doubleToLongBits(other.getDefaultValue())) return false;
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (getValuesCount() > 0) {
          hash = (37 * hash) + VALUES_FIELD_NUMBER;
          hash = (53 * hash) + getValuesList().hashCode();
        }
        if (hasDefaultValue()) {
          hash = (37 * hash) + DEFAULT_VALUE_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getDefaultValue()));
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Value specification for a parameter in `DISCRETE` type.
       * </pre>
       *
       * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec)
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_DiscreteValueSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_DiscreteValueSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec.class,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec.Builder
                      .class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          values_ = emptyDoubleList();
          defaultValue_ = 0D;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_DiscreteValueSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec build() {
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
            buildPartial() {
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec result =
              new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec(this);
          buildPartialRepeatedFields(result);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartialRepeatedFields(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec result) {
          if (((bitField0_ & 0x00000001) != 0)) {
            values_.makeImmutable();
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.values_ = values_;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec result) {
          int from_bitField0_ = bitField0_;
          int to_bitField0_ = 0;
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.defaultValue_ = defaultValue_;
            to_bitField0_ |= 0x00000001;
          }
          result.bitField0_ |= to_bitField0_;
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec) other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec other) {
          if (other
              == com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
                  .getDefaultInstance()) return this;
          if (!other.values_.isEmpty()) {
            if (values_.isEmpty()) {
              values_ = other.values_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureValuesIsMutable();
              values_.addAll(other.values_);
            }
            onChanged();
          }
          if (other.hasDefaultValue()) {
            setDefaultValue(other.getDefaultValue());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 9:
                  {
                    double v = input.readDouble();
                    ensureValuesIsMutable();
                    values_.addDouble(v);
                    break;
                  } // case 9
                case 10:
                  {
                    int length = input.readRawVarint32();
                    int limit = input.pushLimit(length);
                    ensureValuesIsMutable();
                    while (input.getBytesUntilLimit() > 0) {
                      values_.addDouble(input.readDouble());
                    }
                    input.popLimit(limit);
                    break;
                  } // case 10
                case 25:
                  {
                    defaultValue_ = input.readDouble();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 25
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.Internal.DoubleList values_ = emptyDoubleList();

        private void ensureValuesIsMutable() {
          if (!((bitField0_ & 0x00000001) != 0)) {
            values_ = mutableCopy(values_);
            bitField0_ |= 0x00000001;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. A list of possible values.
         * The list should be in increasing order and at least 1e-10 apart.
         * For instance, this parameter might have possible settings of 1.5, 2.5,
         * and 4.0. This list should not contain more than 1,000 values.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the values.
         */
        public java.util.List<java.lang.Double> getValuesList() {
          return ((bitField0_ & 0x00000001) != 0)
              ? java.util.Collections.unmodifiableList(values_)
              : values_;
        }
        /**
         *
         *
         * <pre>
         * Required. A list of possible values.
         * The list should be in increasing order and at least 1e-10 apart.
         * For instance, this parameter might have possible settings of 1.5, 2.5,
         * and 4.0. This list should not contain more than 1,000 values.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of values.
         */
        public int getValuesCount() {
          return values_.size();
        }
        /**
         *
         *
         * <pre>
         * Required. A list of possible values.
         * The list should be in increasing order and at least 1e-10 apart.
         * For instance, this parameter might have possible settings of 1.5, 2.5,
         * and 4.0. This list should not contain more than 1,000 values.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        public double getValues(int index) {
          return values_.getDouble(index);
        }
        /**
         *
         *
         * <pre>
         * Required. A list of possible values.
         * The list should be in increasing order and at least 1e-10 apart.
         * For instance, this parameter might have possible settings of 1.5, 2.5,
         * and 4.0. This list should not contain more than 1,000 values.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index to set the value at.
         * @param value The values to set.
         * @return This builder for chaining.
         */
        public Builder setValues(int index, double value) {

          ensureValuesIsMutable();
          values_.setDouble(index, value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A list of possible values.
         * The list should be in increasing order and at least 1e-10 apart.
         * For instance, this parameter might have possible settings of 1.5, 2.5,
         * and 4.0. This list should not contain more than 1,000 values.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param value The values to add.
         * @return This builder for chaining.
         */
        public Builder addValues(double value) {

          ensureValuesIsMutable();
          values_.addDouble(value);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A list of possible values.
         * The list should be in increasing order and at least 1e-10 apart.
         * For instance, this parameter might have possible settings of 1.5, 2.5,
         * and 4.0. This list should not contain more than 1,000 values.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param values The values to add.
         * @return This builder for chaining.
         */
        public Builder addAllValues(java.lang.Iterable<? extends java.lang.Double> values) {
          ensureValuesIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. A list of possible values.
         * The list should be in increasing order and at least 1e-10 apart.
         * For instance, this parameter might have possible settings of 1.5, 2.5,
         * and 4.0. This list should not contain more than 1,000 values.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearValues() {
          values_ = emptyDoubleList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        private double defaultValue_;
        /**
         *
         *
         * <pre>
         * A default value for a `DISCRETE` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.  It automatically rounds to the
         * nearest feasible discrete point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional double default_value = 3;</code>
         *
         * @return Whether the defaultValue field is set.
         */
        @java.lang.Override
        public boolean hasDefaultValue() {
          return ((bitField0_ & 0x00000002) != 0);
        }
        /**
         *
         *
         * <pre>
         * A default value for a `DISCRETE` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.  It automatically rounds to the
         * nearest feasible discrete point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional double default_value = 3;</code>
         *
         * @return The defaultValue.
         */
        @java.lang.Override
        public double getDefaultValue() {
          return defaultValue_;
        }
        /**
         *
         *
         * <pre>
         * A default value for a `DISCRETE` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.  It automatically rounds to the
         * nearest feasible discrete point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional double default_value = 3;</code>
         *
         * @param value The defaultValue to set.
         * @return This builder for chaining.
         */
        public Builder setDefaultValue(double value) {

          defaultValue_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * A default value for a `DISCRETE` parameter that is assumed to be a
         * relatively good starting point.  Unset value signals that there is no
         * offered starting point.  It automatically rounds to the
         * nearest feasible discrete point.
         *
         * Currently only supported by the Vertex AI Vizier service. Not supported
         * by HyperparameterTuningJob or TrainingPipeline.
         * </pre>
         *
         * <code>optional double default_value = 3;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearDefaultValue() {
          bitField0_ = (bitField0_ & ~0x00000002);
          defaultValue_ = 0D;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec)
      private static final com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec();
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<DiscreteValueSpec> PARSER =
          new com.google.protobuf.AbstractParser<DiscreteValueSpec>() {
            @java.lang.Override
            public DiscreteValueSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<DiscreteValueSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<DiscreteValueSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface ConditionalParameterSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `DISCRETE` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
       * </code>
       *
       * @return Whether the parentDiscreteValues field is set.
       */
      boolean hasParentDiscreteValues();
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `DISCRETE` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
       * </code>
       *
       * @return The parentDiscreteValues.
       */
      com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .DiscreteValueCondition
          getParentDiscreteValues();
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `DISCRETE` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
       * </code>
       */
      com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .DiscreteValueConditionOrBuilder
          getParentDiscreteValuesOrBuilder();

      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of `INTEGER`
       * type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
       * </code>
       *
       * @return Whether the parentIntValues field is set.
       */
      boolean hasParentIntValues();
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of `INTEGER`
       * type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
       * </code>
       *
       * @return The parentIntValues.
       */
      com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .IntValueCondition
          getParentIntValues();
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of `INTEGER`
       * type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
       * </code>
       */
      com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .IntValueConditionOrBuilder
          getParentIntValuesOrBuilder();

      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `CATEGORICAL` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
       * </code>
       *
       * @return Whether the parentCategoricalValues field is set.
       */
      boolean hasParentCategoricalValues();
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `CATEGORICAL` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
       * </code>
       *
       * @return The parentCategoricalValues.
       */
      com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .CategoricalValueCondition
          getParentCategoricalValues();
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `CATEGORICAL` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
       * </code>
       */
      com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .CategoricalValueConditionOrBuilder
          getParentCategoricalValuesOrBuilder();

      /**
       *
       *
       * <pre>
       * Required. The spec for a conditional parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the parameterSpec field is set.
       */
      boolean hasParameterSpec();
      /**
       *
       *
       * <pre>
       * Required. The spec for a conditional parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The parameterSpec.
       */
      com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec getParameterSpec();
      /**
       *
       *
       * <pre>
       * Required. The spec for a conditional parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      com.google.cloud.aiplatform.v1.StudySpec.ParameterSpecOrBuilder getParameterSpecOrBuilder();

      com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .ParentValueConditionCase
          getParentValueConditionCase();
    }
    /**
     *
     *
     * <pre>
     * Represents a parameter spec with condition from its parent parameter.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec}
     */
    public static final class ConditionalParameterSpec
        extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec)
        ConditionalParameterSpecOrBuilder {
      private static final long serialVersionUID = 0L;
      // Use ConditionalParameterSpec.newBuilder() to construct.
      private ConditionalParameterSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private ConditionalParameterSpec() {}

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new ConditionalParameterSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .class,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .Builder.class);
      }

      public interface DiscreteValueConditionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'DISCRETE' type.
         * All values must exist in `discrete_value_spec` of parent parameter.
         *
         * The Epsilon of the value matching is 1e-10.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the values.
         */
        java.util.List<java.lang.Double> getValuesList();
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'DISCRETE' type.
         * All values must exist in `discrete_value_spec` of parent parameter.
         *
         * The Epsilon of the value matching is 1e-10.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of values.
         */
        int getValuesCount();
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'DISCRETE' type.
         * All values must exist in `discrete_value_spec` of parent parameter.
         *
         * The Epsilon of the value matching is 1e-10.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        double getValues(int index);
      }
      /**
       *
       *
       * <pre>
       * Represents the spec to match discrete values from parent parameter.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition}
       */
      public static final class DiscreteValueCondition
          extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition)
          DiscreteValueConditionOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use DiscreteValueCondition.newBuilder() to construct.
        private DiscreteValueCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private DiscreteValueCondition() {
          values_ = emptyDoubleList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new DiscreteValueCondition();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .DiscreteValueCondition.class,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .DiscreteValueCondition.Builder.class);
        }

        public static final int VALUES_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private com.google.protobuf.Internal.DoubleList values_;
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'DISCRETE' type.
         * All values must exist in `discrete_value_spec` of parent parameter.
         *
         * The Epsilon of the value matching is 1e-10.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the values.
         */
        @java.lang.Override
        public java.util.List<java.lang.Double> getValuesList() {
          return values_;
        }
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'DISCRETE' type.
         * All values must exist in `discrete_value_spec` of parent parameter.
         *
         * The Epsilon of the value matching is 1e-10.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of values.
         */
        public int getValuesCount() {
          return values_.size();
        }
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'DISCRETE' type.
         * All values must exist in `discrete_value_spec` of parent parameter.
         *
         * The Epsilon of the value matching is 1e-10.
         * </pre>
         *
         * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        public double getValues(int index) {
          return values_.getDouble(index);
        }

        private int valuesMemoizedSerializedSize = -1;

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          getSerializedSize();
          if (getValuesList().size() > 0) {
            output.writeUInt32NoTag(10);
            output.writeUInt32NoTag(valuesMemoizedSerializedSize);
          }
          for (int i = 0; i < values_.size(); i++) {
            output.writeDoubleNoTag(values_.getDouble(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          {
            int dataSize = 0;
            dataSize = 8 * getValuesList().size();
            size += dataSize;
            if (!getValuesList().isEmpty()) {
              size += 1;
              size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
            }
            valuesMemoizedSerializedSize = dataSize;
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .DiscreteValueCondition)) {
            return super.equals(obj);
          }
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .DiscreteValueCondition
              other =
                  (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                          .DiscreteValueCondition)
                      obj;

          if (!getValuesList().equals(other.getValuesList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (getValuesCount() > 0) {
            hash = (37 * hash) + VALUES_FIELD_NUMBER;
            hash = (53 * hash) + getValuesList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Represents the spec to match discrete values from parent parameter.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition)
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .DiscreteValueConditionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.aiplatform.v1.StudyProto
                .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.aiplatform.v1.StudyProto
                .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                        .DiscreteValueCondition.class,
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                        .DiscreteValueCondition.Builder.class);
          }

          // Construct using
          // com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            values_ = emptyDoubleList();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.aiplatform.v1.StudyProto
                .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_DiscreteValueCondition_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .DiscreteValueCondition
              getDefaultInstanceForType() {
            return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .DiscreteValueCondition.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .DiscreteValueCondition
              build() {
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .DiscreteValueCondition
              buildPartial() {
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition
                result =
                    new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.DiscreteValueCondition(this);
            buildPartialRepeatedFields(result);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartialRepeatedFields(
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .DiscreteValueCondition
                  result) {
            if (((bitField0_ & 0x00000001) != 0)) {
              values_.makeImmutable();
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.values_ = values_;
          }

          private void buildPartial0(
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .DiscreteValueCondition
                  result) {
            int from_bitField0_ = bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition) {
              return mergeFrom(
                  (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                          .DiscreteValueCondition)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .DiscreteValueCondition
                  other) {
            if (other
                == com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition.getDefaultInstance()) return this;
            if (!other.values_.isEmpty()) {
              if (values_.isEmpty()) {
                values_ = other.values_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureValuesIsMutable();
                values_.addAll(other.values_);
              }
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 9:
                    {
                      double v = input.readDouble();
                      ensureValuesIsMutable();
                      values_.addDouble(v);
                      break;
                    } // case 9
                  case 10:
                    {
                      int length = input.readRawVarint32();
                      int limit = input.pushLimit(length);
                      ensureValuesIsMutable();
                      while (input.getBytesUntilLimit() > 0) {
                        values_.addDouble(input.readDouble());
                      }
                      input.popLimit(limit);
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.Internal.DoubleList values_ = emptyDoubleList();

          private void ensureValuesIsMutable() {
            if (!((bitField0_ & 0x00000001) != 0)) {
              values_ = mutableCopy(values_);
              bitField0_ |= 0x00000001;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'DISCRETE' type.
           * All values must exist in `discrete_value_spec` of parent parameter.
           *
           * The Epsilon of the value matching is 1e-10.
           * </pre>
           *
           * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return A list containing the values.
           */
          public java.util.List<java.lang.Double> getValuesList() {
            return ((bitField0_ & 0x00000001) != 0)
                ? java.util.Collections.unmodifiableList(values_)
                : values_;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'DISCRETE' type.
           * All values must exist in `discrete_value_spec` of parent parameter.
           *
           * The Epsilon of the value matching is 1e-10.
           * </pre>
           *
           * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The count of values.
           */
          public int getValuesCount() {
            return values_.size();
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'DISCRETE' type.
           * All values must exist in `discrete_value_spec` of parent parameter.
           *
           * The Epsilon of the value matching is 1e-10.
           * </pre>
           *
           * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index of the element to return.
           * @return The values at the given index.
           */
          public double getValues(int index) {
            return values_.getDouble(index);
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'DISCRETE' type.
           * All values must exist in `discrete_value_spec` of parent parameter.
           *
           * The Epsilon of the value matching is 1e-10.
           * </pre>
           *
           * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index to set the value at.
           * @param value The values to set.
           * @return This builder for chaining.
           */
          public Builder setValues(int index, double value) {

            ensureValuesIsMutable();
            values_.setDouble(index, value);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'DISCRETE' type.
           * All values must exist in `discrete_value_spec` of parent parameter.
           *
           * The Epsilon of the value matching is 1e-10.
           * </pre>
           *
           * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The values to add.
           * @return This builder for chaining.
           */
          public Builder addValues(double value) {

            ensureValuesIsMutable();
            values_.addDouble(value);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'DISCRETE' type.
           * All values must exist in `discrete_value_spec` of parent parameter.
           *
           * The Epsilon of the value matching is 1e-10.
           * </pre>
           *
           * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param values The values to add.
           * @return This builder for chaining.
           */
          public Builder addAllValues(java.lang.Iterable<? extends java.lang.Double> values) {
            ensureValuesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'DISCRETE' type.
           * All values must exist in `discrete_value_spec` of parent parameter.
           *
           * The Epsilon of the value matching is 1e-10.
           * </pre>
           *
           * <code>repeated double values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearValues() {
            values_ = emptyDoubleList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition)
        private static final com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .DiscreteValueCondition();
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.DiscreteValueCondition
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<DiscreteValueCondition> PARSER =
            new com.google.protobuf.AbstractParser<DiscreteValueCondition>() {
              @java.lang.Override
              public DiscreteValueCondition parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<DiscreteValueCondition> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<DiscreteValueCondition> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .DiscreteValueCondition
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface IntValueConditionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'INTEGER' type.
         * All values must lie in `integer_value_spec` of parent parameter.
         * </pre>
         *
         * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the values.
         */
        java.util.List<java.lang.Long> getValuesList();
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'INTEGER' type.
         * All values must lie in `integer_value_spec` of parent parameter.
         * </pre>
         *
         * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of values.
         */
        int getValuesCount();
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'INTEGER' type.
         * All values must lie in `integer_value_spec` of parent parameter.
         * </pre>
         *
         * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        long getValues(int index);
      }
      /**
       *
       *
       * <pre>
       * Represents the spec to match integer values from parent parameter.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition}
       */
      public static final class IntValueCondition extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition)
          IntValueConditionOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use IntValueCondition.newBuilder() to construct.
        private IntValueCondition(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private IntValueCondition() {
          values_ = emptyLongList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new IntValueCondition();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .IntValueCondition.class,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .IntValueCondition.Builder.class);
        }

        public static final int VALUES_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private com.google.protobuf.Internal.LongList values_;
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'INTEGER' type.
         * All values must lie in `integer_value_spec` of parent parameter.
         * </pre>
         *
         * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the values.
         */
        @java.lang.Override
        public java.util.List<java.lang.Long> getValuesList() {
          return values_;
        }
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'INTEGER' type.
         * All values must lie in `integer_value_spec` of parent parameter.
         * </pre>
         *
         * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of values.
         */
        public int getValuesCount() {
          return values_.size();
        }
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'INTEGER' type.
         * All values must lie in `integer_value_spec` of parent parameter.
         * </pre>
         *
         * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        public long getValues(int index) {
          return values_.getLong(index);
        }

        private int valuesMemoizedSerializedSize = -1;

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          getSerializedSize();
          if (getValuesList().size() > 0) {
            output.writeUInt32NoTag(10);
            output.writeUInt32NoTag(valuesMemoizedSerializedSize);
          }
          for (int i = 0; i < values_.size(); i++) {
            output.writeInt64NoTag(values_.getLong(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          {
            int dataSize = 0;
            for (int i = 0; i < values_.size(); i++) {
              dataSize +=
                  com.google.protobuf.CodedOutputStream.computeInt64SizeNoTag(values_.getLong(i));
            }
            size += dataSize;
            if (!getValuesList().isEmpty()) {
              size += 1;
              size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
            }
            valuesMemoizedSerializedSize = dataSize;
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .IntValueCondition)) {
            return super.equals(obj);
          }
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .IntValueCondition
              other =
                  (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                          .IntValueCondition)
                      obj;

          if (!getValuesList().equals(other.getValuesList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (getValuesCount() > 0) {
            hash = (37 * hash) + VALUES_FIELD_NUMBER;
            hash = (53 * hash) + getValuesList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Represents the spec to match integer values from parent parameter.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition)
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .IntValueConditionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.aiplatform.v1.StudyProto
                .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.aiplatform.v1.StudyProto
                .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                        .IntValueCondition.class,
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                        .IntValueCondition.Builder.class);
          }

          // Construct using
          // com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            values_ = emptyLongList();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.aiplatform.v1.StudyProto
                .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_IntValueCondition_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .IntValueCondition
              getDefaultInstanceForType() {
            return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .IntValueCondition.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .IntValueCondition
              build() {
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .IntValueCondition
              buildPartial() {
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition
                result =
                    new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.IntValueCondition(this);
            buildPartialRepeatedFields(result);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartialRepeatedFields(
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .IntValueCondition
                  result) {
            if (((bitField0_ & 0x00000001) != 0)) {
              values_.makeImmutable();
              bitField0_ = (bitField0_ & ~0x00000001);
            }
            result.values_ = values_;
          }

          private void buildPartial0(
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .IntValueCondition
                  result) {
            int from_bitField0_ = bitField0_;
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition) {
              return mergeFrom(
                  (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                          .IntValueCondition)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .IntValueCondition
                  other) {
            if (other
                == com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition.getDefaultInstance()) return this;
            if (!other.values_.isEmpty()) {
              if (values_.isEmpty()) {
                values_ = other.values_;
                bitField0_ = (bitField0_ & ~0x00000001);
              } else {
                ensureValuesIsMutable();
                values_.addAll(other.values_);
              }
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 8:
                    {
                      long v = input.readInt64();
                      ensureValuesIsMutable();
                      values_.addLong(v);
                      break;
                    } // case 8
                  case 10:
                    {
                      int length = input.readRawVarint32();
                      int limit = input.pushLimit(length);
                      ensureValuesIsMutable();
                      while (input.getBytesUntilLimit() > 0) {
                        values_.addLong(input.readInt64());
                      }
                      input.popLimit(limit);
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.Internal.LongList values_ = emptyLongList();

          private void ensureValuesIsMutable() {
            if (!((bitField0_ & 0x00000001) != 0)) {
              values_ = mutableCopy(values_);
              bitField0_ |= 0x00000001;
            }
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'INTEGER' type.
           * All values must lie in `integer_value_spec` of parent parameter.
           * </pre>
           *
           * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return A list containing the values.
           */
          public java.util.List<java.lang.Long> getValuesList() {
            return ((bitField0_ & 0x00000001) != 0)
                ? java.util.Collections.unmodifiableList(values_)
                : values_;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'INTEGER' type.
           * All values must lie in `integer_value_spec` of parent parameter.
           * </pre>
           *
           * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The count of values.
           */
          public int getValuesCount() {
            return values_.size();
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'INTEGER' type.
           * All values must lie in `integer_value_spec` of parent parameter.
           * </pre>
           *
           * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index of the element to return.
           * @return The values at the given index.
           */
          public long getValues(int index) {
            return values_.getLong(index);
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'INTEGER' type.
           * All values must lie in `integer_value_spec` of parent parameter.
           * </pre>
           *
           * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index to set the value at.
           * @param value The values to set.
           * @return This builder for chaining.
           */
          public Builder setValues(int index, long value) {

            ensureValuesIsMutable();
            values_.setLong(index, value);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'INTEGER' type.
           * All values must lie in `integer_value_spec` of parent parameter.
           * </pre>
           *
           * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The values to add.
           * @return This builder for chaining.
           */
          public Builder addValues(long value) {

            ensureValuesIsMutable();
            values_.addLong(value);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'INTEGER' type.
           * All values must lie in `integer_value_spec` of parent parameter.
           * </pre>
           *
           * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param values The values to add.
           * @return This builder for chaining.
           */
          public Builder addAllValues(java.lang.Iterable<? extends java.lang.Long> values) {
            ensureValuesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'INTEGER' type.
           * All values must lie in `integer_value_spec` of parent parameter.
           * </pre>
           *
           * <code>repeated int64 values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearValues() {
            values_ = emptyLongList();
            bitField0_ = (bitField0_ & ~0x00000001);
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition)
        private static final com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .IntValueCondition();
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.IntValueCondition
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<IntValueCondition> PARSER =
            new com.google.protobuf.AbstractParser<IntValueCondition>() {
              @java.lang.Override
              public IntValueCondition parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<IntValueCondition> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<IntValueCondition> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .IntValueCondition
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      public interface CategoricalValueConditionOrBuilder
          extends
          // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition)
          com.google.protobuf.MessageOrBuilder {

        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'CATEGORICAL'
         * type. All values must exist in `categorical_value_spec` of parent
         * parameter.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the values.
         */
        java.util.List<java.lang.String> getValuesList();
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'CATEGORICAL'
         * type. All values must exist in `categorical_value_spec` of parent
         * parameter.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of values.
         */
        int getValuesCount();
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'CATEGORICAL'
         * type. All values must exist in `categorical_value_spec` of parent
         * parameter.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        java.lang.String getValues(int index);
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'CATEGORICAL'
         * type. All values must exist in `categorical_value_spec` of parent
         * parameter.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the values at the given index.
         */
        com.google.protobuf.ByteString getValuesBytes(int index);
      }
      /**
       *
       *
       * <pre>
       * Represents the spec to match categorical values from parent parameter.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition}
       */
      public static final class CategoricalValueCondition
          extends com.google.protobuf.GeneratedMessageV3
          implements
          // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition)
          CategoricalValueConditionOrBuilder {
        private static final long serialVersionUID = 0L;
        // Use CategoricalValueCondition.newBuilder() to construct.
        private CategoricalValueCondition(
            com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
          super(builder);
        }

        private CategoricalValueCondition() {
          values_ = com.google.protobuf.LazyStringArrayList.emptyList();
        }

        @java.lang.Override
        @SuppressWarnings({"unused"})
        protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
          return new CategoricalValueCondition();
        }

        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .CategoricalValueCondition.class,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .CategoricalValueCondition.Builder.class);
        }

        public static final int VALUES_FIELD_NUMBER = 1;

        @SuppressWarnings("serial")
        private com.google.protobuf.LazyStringArrayList values_ =
            com.google.protobuf.LazyStringArrayList.emptyList();
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'CATEGORICAL'
         * type. All values must exist in `categorical_value_spec` of parent
         * parameter.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return A list containing the values.
         */
        public com.google.protobuf.ProtocolStringList getValuesList() {
          return values_;
        }
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'CATEGORICAL'
         * type. All values must exist in `categorical_value_spec` of parent
         * parameter.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @return The count of values.
         */
        public int getValuesCount() {
          return values_.size();
        }
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'CATEGORICAL'
         * type. All values must exist in `categorical_value_spec` of parent
         * parameter.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the element to return.
         * @return The values at the given index.
         */
        public java.lang.String getValues(int index) {
          return values_.get(index);
        }
        /**
         *
         *
         * <pre>
         * Required. Matches values of the parent parameter of 'CATEGORICAL'
         * type. All values must exist in `categorical_value_spec` of parent
         * parameter.
         * </pre>
         *
         * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
         *
         * @param index The index of the value to return.
         * @return The bytes of the values at the given index.
         */
        public com.google.protobuf.ByteString getValuesBytes(int index) {
          return values_.getByteString(index);
        }

        private byte memoizedIsInitialized = -1;

        @java.lang.Override
        public final boolean isInitialized() {
          byte isInitialized = memoizedIsInitialized;
          if (isInitialized == 1) return true;
          if (isInitialized == 0) return false;

          memoizedIsInitialized = 1;
          return true;
        }

        @java.lang.Override
        public void writeTo(com.google.protobuf.CodedOutputStream output)
            throws java.io.IOException {
          for (int i = 0; i < values_.size(); i++) {
            com.google.protobuf.GeneratedMessageV3.writeString(output, 1, values_.getRaw(i));
          }
          getUnknownFields().writeTo(output);
        }

        @java.lang.Override
        public int getSerializedSize() {
          int size = memoizedSize;
          if (size != -1) return size;

          size = 0;
          {
            int dataSize = 0;
            for (int i = 0; i < values_.size(); i++) {
              dataSize += computeStringSizeNoTag(values_.getRaw(i));
            }
            size += dataSize;
            size += 1 * getValuesList().size();
          }
          size += getUnknownFields().getSerializedSize();
          memoizedSize = size;
          return size;
        }

        @java.lang.Override
        public boolean equals(final java.lang.Object obj) {
          if (obj == this) {
            return true;
          }
          if (!(obj
              instanceof
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .CategoricalValueCondition)) {
            return super.equals(obj);
          }
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .CategoricalValueCondition
              other =
                  (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                          .CategoricalValueCondition)
                      obj;

          if (!getValuesList().equals(other.getValuesList())) return false;
          if (!getUnknownFields().equals(other.getUnknownFields())) return false;
          return true;
        }

        @java.lang.Override
        public int hashCode() {
          if (memoizedHashCode != 0) {
            return memoizedHashCode;
          }
          int hash = 41;
          hash = (19 * hash) + getDescriptor().hashCode();
          if (getValuesCount() > 0) {
            hash = (37 * hash) + VALUES_FIELD_NUMBER;
            hash = (53 * hash) + getValuesList().hashCode();
          }
          hash = (29 * hash) + getUnknownFields().hashCode();
          memoizedHashCode = hash;
          return hash;
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(java.nio.ByteBuffer data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(
                java.nio.ByteBuffer data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(com.google.protobuf.ByteString data)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(
                com.google.protobuf.ByteString data,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
          return PARSER.parseFrom(data, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseDelimitedFrom(
                java.io.InputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
              PARSER, input, extensionRegistry);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            parseFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws java.io.IOException {
          return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
              PARSER, input, extensionRegistry);
        }

        @java.lang.Override
        public Builder newBuilderForType() {
          return newBuilder();
        }

        public static Builder newBuilder() {
          return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition
                prototype) {
          return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        @java.lang.Override
        public Builder toBuilder() {
          return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        @java.lang.Override
        protected Builder newBuilderForType(
            com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          Builder builder = new Builder(parent);
          return builder;
        }
        /**
         *
         *
         * <pre>
         * Represents the spec to match categorical values from parent parameter.
         * </pre>
         *
         * Protobuf type {@code
         * google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition}
         */
        public static final class Builder
            extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
            implements
            // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition)
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .CategoricalValueConditionOrBuilder {
          public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
            return com.google.cloud.aiplatform.v1.StudyProto
                .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition_descriptor;
          }

          @java.lang.Override
          protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
              internalGetFieldAccessorTable() {
            return com.google.cloud.aiplatform.v1.StudyProto
                .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition_fieldAccessorTable
                .ensureFieldAccessorsInitialized(
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                        .CategoricalValueCondition.class,
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                        .CategoricalValueCondition.Builder.class);
          }

          // Construct using
          // com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition.newBuilder()
          private Builder() {}

          private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
            super(parent);
          }

          @java.lang.Override
          public Builder clear() {
            super.clear();
            bitField0_ = 0;
            values_ = com.google.protobuf.LazyStringArrayList.emptyList();
            return this;
          }

          @java.lang.Override
          public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
            return com.google.cloud.aiplatform.v1.StudyProto
                .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_CategoricalValueCondition_descriptor;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .CategoricalValueCondition
              getDefaultInstanceForType() {
            return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .CategoricalValueCondition.getDefaultInstance();
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .CategoricalValueCondition
              build() {
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition
                result = buildPartial();
            if (!result.isInitialized()) {
              throw newUninitializedMessageException(result);
            }
            return result;
          }

          @java.lang.Override
          public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .CategoricalValueCondition
              buildPartial() {
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition
                result =
                    new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.CategoricalValueCondition(this);
            if (bitField0_ != 0) {
              buildPartial0(result);
            }
            onBuilt();
            return result;
          }

          private void buildPartial0(
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .CategoricalValueCondition
                  result) {
            int from_bitField0_ = bitField0_;
            if (((from_bitField0_ & 0x00000001) != 0)) {
              values_.makeImmutable();
              result.values_ = values_;
            }
          }

          @java.lang.Override
          public Builder clone() {
            return super.clone();
          }

          @java.lang.Override
          public Builder setField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.setField(field, value);
          }

          @java.lang.Override
          public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
            return super.clearField(field);
          }

          @java.lang.Override
          public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
            return super.clearOneof(oneof);
          }

          @java.lang.Override
          public Builder setRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field,
              int index,
              java.lang.Object value) {
            return super.setRepeatedField(field, index, value);
          }

          @java.lang.Override
          public Builder addRepeatedField(
              com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
            return super.addRepeatedField(field, value);
          }

          @java.lang.Override
          public Builder mergeFrom(com.google.protobuf.Message other) {
            if (other
                instanceof
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition) {
              return mergeFrom(
                  (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                          .CategoricalValueCondition)
                      other);
            } else {
              super.mergeFrom(other);
              return this;
            }
          }

          public Builder mergeFrom(
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .CategoricalValueCondition
                  other) {
            if (other
                == com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition.getDefaultInstance()) return this;
            if (!other.values_.isEmpty()) {
              if (values_.isEmpty()) {
                values_ = other.values_;
                bitField0_ |= 0x00000001;
              } else {
                ensureValuesIsMutable();
                values_.addAll(other.values_);
              }
              onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            onChanged();
            return this;
          }

          @java.lang.Override
          public final boolean isInitialized() {
            return true;
          }

          @java.lang.Override
          public Builder mergeFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
            if (extensionRegistry == null) {
              throw new java.lang.NullPointerException();
            }
            try {
              boolean done = false;
              while (!done) {
                int tag = input.readTag();
                switch (tag) {
                  case 0:
                    done = true;
                    break;
                  case 10:
                    {
                      java.lang.String s = input.readStringRequireUtf8();
                      ensureValuesIsMutable();
                      values_.add(s);
                      break;
                    } // case 10
                  default:
                    {
                      if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                        done = true; // was an endgroup tag
                      }
                      break;
                    } // default:
                } // switch (tag)
              } // while (!done)
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.unwrapIOException();
            } finally {
              onChanged();
            } // finally
            return this;
          }

          private int bitField0_;

          private com.google.protobuf.LazyStringArrayList values_ =
              com.google.protobuf.LazyStringArrayList.emptyList();

          private void ensureValuesIsMutable() {
            if (!values_.isModifiable()) {
              values_ = new com.google.protobuf.LazyStringArrayList(values_);
            }
            bitField0_ |= 0x00000001;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL'
           * type. All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return A list containing the values.
           */
          public com.google.protobuf.ProtocolStringList getValuesList() {
            values_.makeImmutable();
            return values_;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL'
           * type. All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return The count of values.
           */
          public int getValuesCount() {
            return values_.size();
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL'
           * type. All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index of the element to return.
           * @return The values at the given index.
           */
          public java.lang.String getValues(int index) {
            return values_.get(index);
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL'
           * type. All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index of the value to return.
           * @return The bytes of the values at the given index.
           */
          public com.google.protobuf.ByteString getValuesBytes(int index) {
            return values_.getByteString(index);
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL'
           * type. All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param index The index to set the value at.
           * @param value The values to set.
           * @return This builder for chaining.
           */
          public Builder setValues(int index, java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureValuesIsMutable();
            values_.set(index, value);
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL'
           * type. All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The values to add.
           * @return This builder for chaining.
           */
          public Builder addValues(java.lang.String value) {
            if (value == null) {
              throw new NullPointerException();
            }
            ensureValuesIsMutable();
            values_.add(value);
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL'
           * type. All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param values The values to add.
           * @return This builder for chaining.
           */
          public Builder addAllValues(java.lang.Iterable<java.lang.String> values) {
            ensureValuesIsMutable();
            com.google.protobuf.AbstractMessageLite.Builder.addAll(values, values_);
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL'
           * type. All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @return This builder for chaining.
           */
          public Builder clearValues() {
            values_ = com.google.protobuf.LazyStringArrayList.emptyList();
            bitField0_ = (bitField0_ & ~0x00000001);
            ;
            onChanged();
            return this;
          }
          /**
           *
           *
           * <pre>
           * Required. Matches values of the parent parameter of 'CATEGORICAL'
           * type. All values must exist in `categorical_value_spec` of parent
           * parameter.
           * </pre>
           *
           * <code>repeated string values = 1 [(.google.api.field_behavior) = REQUIRED];</code>
           *
           * @param value The bytes of the values to add.
           * @return This builder for chaining.
           */
          public Builder addValuesBytes(com.google.protobuf.ByteString value) {
            if (value == null) {
              throw new NullPointerException();
            }
            checkByteStringIsUtf8(value);
            ensureValuesIsMutable();
            values_.add(value);
            bitField0_ |= 0x00000001;
            onChanged();
            return this;
          }

          @java.lang.Override
          public final Builder setUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.setUnknownFields(unknownFields);
          }

          @java.lang.Override
          public final Builder mergeUnknownFields(
              final com.google.protobuf.UnknownFieldSet unknownFields) {
            return super.mergeUnknownFields(unknownFields);
          }

          // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition)
        }

        // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition)
        private static final com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            DEFAULT_INSTANCE;

        static {
          DEFAULT_INSTANCE =
              new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .CategoricalValueCondition();
        }

        public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                .ConditionalParameterSpec.CategoricalValueCondition
            getDefaultInstance() {
          return DEFAULT_INSTANCE;
        }

        private static final com.google.protobuf.Parser<CategoricalValueCondition> PARSER =
            new com.google.protobuf.AbstractParser<CategoricalValueCondition>() {
              @java.lang.Override
              public CategoricalValueCondition parsePartialFrom(
                  com.google.protobuf.CodedInputStream input,
                  com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                  throws com.google.protobuf.InvalidProtocolBufferException {
                Builder builder = newBuilder();
                try {
                  builder.mergeFrom(input, extensionRegistry);
                } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                  throw e.setUnfinishedMessage(builder.buildPartial());
                } catch (com.google.protobuf.UninitializedMessageException e) {
                  throw e.asInvalidProtocolBufferException()
                      .setUnfinishedMessage(builder.buildPartial());
                } catch (java.io.IOException e) {
                  throw new com.google.protobuf.InvalidProtocolBufferException(e)
                      .setUnfinishedMessage(builder.buildPartial());
                }
                return builder.buildPartial();
              }
            };

        public static com.google.protobuf.Parser<CategoricalValueCondition> parser() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.protobuf.Parser<CategoricalValueCondition> getParserForType() {
          return PARSER;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .CategoricalValueCondition
            getDefaultInstanceForType() {
          return DEFAULT_INSTANCE;
        }
      }

      private int parentValueConditionCase_ = 0;

      @SuppressWarnings("serial")
      private java.lang.Object parentValueCondition_;

      public enum ParentValueConditionCase
          implements
              com.google.protobuf.Internal.EnumLite,
              com.google.protobuf.AbstractMessage.InternalOneOfEnum {
        PARENT_DISCRETE_VALUES(2),
        PARENT_INT_VALUES(3),
        PARENT_CATEGORICAL_VALUES(4),
        PARENTVALUECONDITION_NOT_SET(0);
        private final int value;

        private ParentValueConditionCase(int value) {
          this.value = value;
        }
        /**
         * @param value The number of the enum to look for.
         * @return The enum associated with the given number.
         * @deprecated Use {@link #forNumber(int)} instead.
         */
        @java.lang.Deprecated
        public static ParentValueConditionCase valueOf(int value) {
          return forNumber(value);
        }

        public static ParentValueConditionCase forNumber(int value) {
          switch (value) {
            case 2:
              return PARENT_DISCRETE_VALUES;
            case 3:
              return PARENT_INT_VALUES;
            case 4:
              return PARENT_CATEGORICAL_VALUES;
            case 0:
              return PARENTVALUECONDITION_NOT_SET;
            default:
              return null;
          }
        }

        public int getNumber() {
          return this.value;
        }
      };

      public ParentValueConditionCase getParentValueConditionCase() {
        return ParentValueConditionCase.forNumber(parentValueConditionCase_);
      }

      public static final int PARENT_DISCRETE_VALUES_FIELD_NUMBER = 2;
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `DISCRETE` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
       * </code>
       *
       * @return Whether the parentDiscreteValues field is set.
       */
      @java.lang.Override
      public boolean hasParentDiscreteValues() {
        return parentValueConditionCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `DISCRETE` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
       * </code>
       *
       * @return The parentDiscreteValues.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .DiscreteValueCondition
          getParentDiscreteValues() {
        if (parentValueConditionCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .DiscreteValueCondition)
              parentValueCondition_;
        }
        return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
            .DiscreteValueCondition.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `DISCRETE` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .DiscreteValueConditionOrBuilder
          getParentDiscreteValuesOrBuilder() {
        if (parentValueConditionCase_ == 2) {
          return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .DiscreteValueCondition)
              parentValueCondition_;
        }
        return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
            .DiscreteValueCondition.getDefaultInstance();
      }

      public static final int PARENT_INT_VALUES_FIELD_NUMBER = 3;
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of `INTEGER`
       * type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
       * </code>
       *
       * @return Whether the parentIntValues field is set.
       */
      @java.lang.Override
      public boolean hasParentIntValues() {
        return parentValueConditionCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of `INTEGER`
       * type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
       * </code>
       *
       * @return The parentIntValues.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .IntValueCondition
          getParentIntValues() {
        if (parentValueConditionCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .IntValueCondition)
              parentValueCondition_;
        }
        return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
            .IntValueCondition.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of `INTEGER`
       * type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .IntValueConditionOrBuilder
          getParentIntValuesOrBuilder() {
        if (parentValueConditionCase_ == 3) {
          return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .IntValueCondition)
              parentValueCondition_;
        }
        return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
            .IntValueCondition.getDefaultInstance();
      }

      public static final int PARENT_CATEGORICAL_VALUES_FIELD_NUMBER = 4;
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `CATEGORICAL` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
       * </code>
       *
       * @return Whether the parentCategoricalValues field is set.
       */
      @java.lang.Override
      public boolean hasParentCategoricalValues() {
        return parentValueConditionCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `CATEGORICAL` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
       * </code>
       *
       * @return The parentCategoricalValues.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .CategoricalValueCondition
          getParentCategoricalValues() {
        if (parentValueConditionCase_ == 4) {
          return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .CategoricalValueCondition)
              parentValueCondition_;
        }
        return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
            .CategoricalValueCondition.getDefaultInstance();
      }
      /**
       *
       *
       * <pre>
       * The spec for matching values from a parent parameter of
       * `CATEGORICAL` type.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .CategoricalValueConditionOrBuilder
          getParentCategoricalValuesOrBuilder() {
        if (parentValueConditionCase_ == 4) {
          return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .CategoricalValueCondition)
              parentValueCondition_;
        }
        return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
            .CategoricalValueCondition.getDefaultInstance();
      }

      public static final int PARAMETER_SPEC_FIELD_NUMBER = 1;
      private com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameterSpec_;
      /**
       *
       *
       * <pre>
       * Required. The spec for a conditional parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return Whether the parameterSpec field is set.
       */
      @java.lang.Override
      public boolean hasParameterSpec() {
        return parameterSpec_ != null;
      }
      /**
       *
       *
       * <pre>
       * Required. The spec for a conditional parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The parameterSpec.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec getParameterSpec() {
        return parameterSpec_ == null
            ? com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.getDefaultInstance()
            : parameterSpec_;
      }
      /**
       *
       *
       * <pre>
       * Required. The spec for a conditional parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpecOrBuilder
          getParameterSpecOrBuilder() {
        return parameterSpec_ == null
            ? com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.getDefaultInstance()
            : parameterSpec_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (parameterSpec_ != null) {
          output.writeMessage(1, getParameterSpec());
        }
        if (parentValueConditionCase_ == 2) {
          output.writeMessage(
              2,
              (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .DiscreteValueCondition)
                  parentValueCondition_);
        }
        if (parentValueConditionCase_ == 3) {
          output.writeMessage(
              3,
              (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .IntValueCondition)
                  parentValueCondition_);
        }
        if (parentValueConditionCase_ == 4) {
          output.writeMessage(
              4,
              (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .CategoricalValueCondition)
                  parentValueCondition_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (parameterSpec_ != null) {
          size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getParameterSpec());
        }
        if (parentValueConditionCase_ == 2) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  2,
                  (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                          .DiscreteValueCondition)
                      parentValueCondition_);
        }
        if (parentValueConditionCase_ == 3) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  3,
                  (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                          .IntValueCondition)
                      parentValueCondition_);
        }
        if (parentValueConditionCase_ == 4) {
          size +=
              com.google.protobuf.CodedOutputStream.computeMessageSize(
                  4,
                  (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                          .CategoricalValueCondition)
                      parentValueCondition_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec other =
            (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec) obj;

        if (hasParameterSpec() != other.hasParameterSpec()) return false;
        if (hasParameterSpec()) {
          if (!getParameterSpec().equals(other.getParameterSpec())) return false;
        }
        if (!getParentValueConditionCase().equals(other.getParentValueConditionCase()))
          return false;
        switch (parentValueConditionCase_) {
          case 2:
            if (!getParentDiscreteValues().equals(other.getParentDiscreteValues())) return false;
            break;
          case 3:
            if (!getParentIntValues().equals(other.getParentIntValues())) return false;
            break;
          case 4:
            if (!getParentCategoricalValues().equals(other.getParentCategoricalValues()))
              return false;
            break;
          case 0:
          default:
        }
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        if (hasParameterSpec()) {
          hash = (37 * hash) + PARAMETER_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getParameterSpec().hashCode();
        }
        switch (parentValueConditionCase_) {
          case 2:
            hash = (37 * hash) + PARENT_DISCRETE_VALUES_FIELD_NUMBER;
            hash = (53 * hash) + getParentDiscreteValues().hashCode();
            break;
          case 3:
            hash = (37 * hash) + PARENT_INT_VALUES_FIELD_NUMBER;
            hash = (53 * hash) + getParentIntValues().hashCode();
            break;
          case 4:
            hash = (37 * hash) + PARENT_CATEGORICAL_VALUES_FIELD_NUMBER;
            hash = (53 * hash) + getParentCategoricalValues().hashCode();
            break;
          case 0:
          default:
        }
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }
      /**
       *
       *
       * <pre>
       * Represents a parameter spec with condition from its parent parameter.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec)
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .class,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          if (parentDiscreteValuesBuilder_ != null) {
            parentDiscreteValuesBuilder_.clear();
          }
          if (parentIntValuesBuilder_ != null) {
            parentIntValuesBuilder_.clear();
          }
          if (parentCategoricalValuesBuilder_ != null) {
            parentCategoricalValuesBuilder_.clear();
          }
          parameterSpec_ = null;
          if (parameterSpecBuilder_ != null) {
            parameterSpecBuilder_.dispose();
            parameterSpecBuilder_ = null;
          }
          parentValueConditionCase_ = 0;
          parentValueCondition_ = null;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.StudyProto
              .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_ConditionalParameterSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
            build() {
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
            buildPartial() {
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec result =
              new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          buildPartialOneofs(result);
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.parameterSpec_ =
                parameterSpecBuilder_ == null ? parameterSpec_ : parameterSpecBuilder_.build();
          }
        }

        private void buildPartialOneofs(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                result) {
          result.parentValueConditionCase_ = parentValueConditionCase_;
          result.parentValueCondition_ = this.parentValueCondition_;
          if (parentValueConditionCase_ == 2 && parentDiscreteValuesBuilder_ != null) {
            result.parentValueCondition_ = parentDiscreteValuesBuilder_.build();
          }
          if (parentValueConditionCase_ == 3 && parentIntValuesBuilder_ != null) {
            result.parentValueCondition_ = parentIntValuesBuilder_.build();
          }
          if (parentValueConditionCase_ == 4 && parentCategoricalValuesBuilder_ != null) {
            result.parentValueCondition_ = parentCategoricalValuesBuilder_.build();
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec other) {
          if (other
              == com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .getDefaultInstance()) return this;
          if (other.hasParameterSpec()) {
            mergeParameterSpec(other.getParameterSpec());
          }
          switch (other.getParentValueConditionCase()) {
            case PARENT_DISCRETE_VALUES:
              {
                mergeParentDiscreteValues(other.getParentDiscreteValues());
                break;
              }
            case PARENT_INT_VALUES:
              {
                mergeParentIntValues(other.getParentIntValues());
                break;
              }
            case PARENT_CATEGORICAL_VALUES:
              {
                mergeParentCategoricalValues(other.getParentCategoricalValues());
                break;
              }
            case PARENTVALUECONDITION_NOT_SET:
              {
                break;
              }
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    input.readMessage(
                        getParameterSpecFieldBuilder().getBuilder(), extensionRegistry);
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 10
                case 18:
                  {
                    input.readMessage(
                        getParentDiscreteValuesFieldBuilder().getBuilder(), extensionRegistry);
                    parentValueConditionCase_ = 2;
                    break;
                  } // case 18
                case 26:
                  {
                    input.readMessage(
                        getParentIntValuesFieldBuilder().getBuilder(), extensionRegistry);
                    parentValueConditionCase_ = 3;
                    break;
                  } // case 26
                case 34:
                  {
                    input.readMessage(
                        getParentCategoricalValuesFieldBuilder().getBuilder(), extensionRegistry);
                    parentValueConditionCase_ = 4;
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int parentValueConditionCase_ = 0;
        private java.lang.Object parentValueCondition_;

        public ParentValueConditionCase getParentValueConditionCase() {
          return ParentValueConditionCase.forNumber(parentValueConditionCase_);
        }

        public Builder clearParentValueCondition() {
          parentValueConditionCase_ = 0;
          parentValueCondition_ = null;
          onChanged();
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition.Builder,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueConditionOrBuilder>
            parentDiscreteValuesBuilder_;
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         *
         * @return Whether the parentDiscreteValues field is set.
         */
        @java.lang.Override
        public boolean hasParentDiscreteValues() {
          return parentValueConditionCase_ == 2;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         *
         * @return The parentDiscreteValues.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .DiscreteValueCondition
            getParentDiscreteValues() {
          if (parentDiscreteValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 2) {
              return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.DiscreteValueCondition)
                  parentValueCondition_;
            }
            return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .DiscreteValueCondition.getDefaultInstance();
          } else {
            if (parentValueConditionCase_ == 2) {
              return parentDiscreteValuesBuilder_.getMessage();
            }
            return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .DiscreteValueCondition.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         */
        public Builder setParentDiscreteValues(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition
                value) {
          if (parentDiscreteValuesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            parentValueCondition_ = value;
            onChanged();
          } else {
            parentDiscreteValuesBuilder_.setMessage(value);
          }
          parentValueConditionCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         */
        public Builder setParentDiscreteValues(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition.Builder
                builderForValue) {
          if (parentDiscreteValuesBuilder_ == null) {
            parentValueCondition_ = builderForValue.build();
            onChanged();
          } else {
            parentDiscreteValuesBuilder_.setMessage(builderForValue.build());
          }
          parentValueConditionCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         */
        public Builder mergeParentDiscreteValues(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition
                value) {
          if (parentDiscreteValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 2
                && parentValueCondition_
                    != com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.DiscreteValueCondition.getDefaultInstance()) {
              parentValueCondition_ =
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .DiscreteValueCondition.newBuilder(
                          (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                                  .ConditionalParameterSpec.DiscreteValueCondition)
                              parentValueCondition_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              parentValueCondition_ = value;
            }
            onChanged();
          } else {
            if (parentValueConditionCase_ == 2) {
              parentDiscreteValuesBuilder_.mergeFrom(value);
            } else {
              parentDiscreteValuesBuilder_.setMessage(value);
            }
          }
          parentValueConditionCase_ = 2;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         */
        public Builder clearParentDiscreteValues() {
          if (parentDiscreteValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 2) {
              parentValueConditionCase_ = 0;
              parentValueCondition_ = null;
              onChanged();
            }
          } else {
            if (parentValueConditionCase_ == 2) {
              parentValueConditionCase_ = 0;
              parentValueCondition_ = null;
            }
            parentDiscreteValuesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         */
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .DiscreteValueCondition.Builder
            getParentDiscreteValuesBuilder() {
          return getParentDiscreteValuesFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .DiscreteValueConditionOrBuilder
            getParentDiscreteValuesOrBuilder() {
          if ((parentValueConditionCase_ == 2) && (parentDiscreteValuesBuilder_ != null)) {
            return parentDiscreteValuesBuilder_.getMessageOrBuilder();
          } else {
            if (parentValueConditionCase_ == 2) {
              return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.DiscreteValueCondition)
                  parentValueCondition_;
            }
            return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .DiscreteValueCondition.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `DISCRETE` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.DiscreteValueCondition parent_discrete_values = 2;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueCondition.Builder,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .DiscreteValueConditionOrBuilder>
            getParentDiscreteValuesFieldBuilder() {
          if (parentDiscreteValuesBuilder_ == null) {
            if (!(parentValueConditionCase_ == 2)) {
              parentValueCondition_ =
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .DiscreteValueCondition.getDefaultInstance();
            }
            parentDiscreteValuesBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                        .DiscreteValueCondition,
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                        .DiscreteValueCondition.Builder,
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                        .DiscreteValueConditionOrBuilder>(
                    (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                            .DiscreteValueCondition)
                        parentValueCondition_,
                    getParentForChildren(),
                    isClean());
            parentValueCondition_ = null;
          }
          parentValueConditionCase_ = 2;
          onChanged();
          return parentDiscreteValuesBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition.Builder,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueConditionOrBuilder>
            parentIntValuesBuilder_;
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         *
         * @return Whether the parentIntValues field is set.
         */
        @java.lang.Override
        public boolean hasParentIntValues() {
          return parentValueConditionCase_ == 3;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         *
         * @return The parentIntValues.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .IntValueCondition
            getParentIntValues() {
          if (parentIntValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 3) {
              return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.IntValueCondition)
                  parentValueCondition_;
            }
            return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .IntValueCondition.getDefaultInstance();
          } else {
            if (parentValueConditionCase_ == 3) {
              return parentIntValuesBuilder_.getMessage();
            }
            return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .IntValueCondition.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         */
        public Builder setParentIntValues(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition
                value) {
          if (parentIntValuesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            parentValueCondition_ = value;
            onChanged();
          } else {
            parentIntValuesBuilder_.setMessage(value);
          }
          parentValueConditionCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         */
        public Builder setParentIntValues(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition.Builder
                builderForValue) {
          if (parentIntValuesBuilder_ == null) {
            parentValueCondition_ = builderForValue.build();
            onChanged();
          } else {
            parentIntValuesBuilder_.setMessage(builderForValue.build());
          }
          parentValueConditionCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         */
        public Builder mergeParentIntValues(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition
                value) {
          if (parentIntValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 3
                && parentValueCondition_
                    != com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.IntValueCondition.getDefaultInstance()) {
              parentValueCondition_ =
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .IntValueCondition.newBuilder(
                          (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                                  .ConditionalParameterSpec.IntValueCondition)
                              parentValueCondition_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              parentValueCondition_ = value;
            }
            onChanged();
          } else {
            if (parentValueConditionCase_ == 3) {
              parentIntValuesBuilder_.mergeFrom(value);
            } else {
              parentIntValuesBuilder_.setMessage(value);
            }
          }
          parentValueConditionCase_ = 3;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         */
        public Builder clearParentIntValues() {
          if (parentIntValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 3) {
              parentValueConditionCase_ = 0;
              parentValueCondition_ = null;
              onChanged();
            }
          } else {
            if (parentValueConditionCase_ == 3) {
              parentValueConditionCase_ = 0;
              parentValueCondition_ = null;
            }
            parentIntValuesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         */
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .IntValueCondition.Builder
            getParentIntValuesBuilder() {
          return getParentIntValuesFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .IntValueConditionOrBuilder
            getParentIntValuesOrBuilder() {
          if ((parentValueConditionCase_ == 3) && (parentIntValuesBuilder_ != null)) {
            return parentIntValuesBuilder_.getMessageOrBuilder();
          } else {
            if (parentValueConditionCase_ == 3) {
              return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.IntValueCondition)
                  parentValueCondition_;
            }
            return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .IntValueCondition.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of `INTEGER`
         * type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.IntValueCondition parent_int_values = 3;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueCondition.Builder,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .IntValueConditionOrBuilder>
            getParentIntValuesFieldBuilder() {
          if (parentIntValuesBuilder_ == null) {
            if (!(parentValueConditionCase_ == 3)) {
              parentValueCondition_ =
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .IntValueCondition.getDefaultInstance();
            }
            parentIntValuesBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                        .IntValueCondition,
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                        .IntValueCondition.Builder,
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                        .IntValueConditionOrBuilder>(
                    (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                            .IntValueCondition)
                        parentValueCondition_,
                    getParentForChildren(),
                    isClean());
            parentValueCondition_ = null;
          }
          parentValueConditionCase_ = 3;
          onChanged();
          return parentIntValuesBuilder_;
        }

        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition.Builder,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueConditionOrBuilder>
            parentCategoricalValuesBuilder_;
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         *
         * @return Whether the parentCategoricalValues field is set.
         */
        @java.lang.Override
        public boolean hasParentCategoricalValues() {
          return parentValueConditionCase_ == 4;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         *
         * @return The parentCategoricalValues.
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .CategoricalValueCondition
            getParentCategoricalValues() {
          if (parentCategoricalValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 4) {
              return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.CategoricalValueCondition)
                  parentValueCondition_;
            }
            return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .CategoricalValueCondition.getDefaultInstance();
          } else {
            if (parentValueConditionCase_ == 4) {
              return parentCategoricalValuesBuilder_.getMessage();
            }
            return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .CategoricalValueCondition.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         */
        public Builder setParentCategoricalValues(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition
                value) {
          if (parentCategoricalValuesBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            parentValueCondition_ = value;
            onChanged();
          } else {
            parentCategoricalValuesBuilder_.setMessage(value);
          }
          parentValueConditionCase_ = 4;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         */
        public Builder setParentCategoricalValues(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition.Builder
                builderForValue) {
          if (parentCategoricalValuesBuilder_ == null) {
            parentValueCondition_ = builderForValue.build();
            onChanged();
          } else {
            parentCategoricalValuesBuilder_.setMessage(builderForValue.build());
          }
          parentValueConditionCase_ = 4;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         */
        public Builder mergeParentCategoricalValues(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition
                value) {
          if (parentCategoricalValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 4
                && parentValueCondition_
                    != com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                        .ConditionalParameterSpec.CategoricalValueCondition.getDefaultInstance()) {
              parentValueCondition_ =
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .CategoricalValueCondition.newBuilder(
                          (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                                  .ConditionalParameterSpec.CategoricalValueCondition)
                              parentValueCondition_)
                      .mergeFrom(value)
                      .buildPartial();
            } else {
              parentValueCondition_ = value;
            }
            onChanged();
          } else {
            if (parentValueConditionCase_ == 4) {
              parentCategoricalValuesBuilder_.mergeFrom(value);
            } else {
              parentCategoricalValuesBuilder_.setMessage(value);
            }
          }
          parentValueConditionCase_ = 4;
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         */
        public Builder clearParentCategoricalValues() {
          if (parentCategoricalValuesBuilder_ == null) {
            if (parentValueConditionCase_ == 4) {
              parentValueConditionCase_ = 0;
              parentValueCondition_ = null;
              onChanged();
            }
          } else {
            if (parentValueConditionCase_ == 4) {
              parentValueConditionCase_ = 0;
              parentValueCondition_ = null;
            }
            parentCategoricalValuesBuilder_.clear();
          }
          return this;
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         */
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .CategoricalValueCondition.Builder
            getParentCategoricalValuesBuilder() {
          return getParentCategoricalValuesFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         */
        @java.lang.Override
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .CategoricalValueConditionOrBuilder
            getParentCategoricalValuesOrBuilder() {
          if ((parentValueConditionCase_ == 4) && (parentCategoricalValuesBuilder_ != null)) {
            return parentCategoricalValuesBuilder_.getMessageOrBuilder();
          } else {
            if (parentValueConditionCase_ == 4) {
              return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                      .ConditionalParameterSpec.CategoricalValueCondition)
                  parentValueCondition_;
            }
            return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                .CategoricalValueCondition.getDefaultInstance();
          }
        }
        /**
         *
         *
         * <pre>
         * The spec for matching values from a parent parameter of
         * `CATEGORICAL` type.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.CategoricalValueCondition parent_categorical_values = 4;
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueCondition.Builder,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .CategoricalValueConditionOrBuilder>
            getParentCategoricalValuesFieldBuilder() {
          if (parentCategoricalValuesBuilder_ == null) {
            if (!(parentValueConditionCase_ == 4)) {
              parentValueCondition_ =
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .CategoricalValueCondition.getDefaultInstance();
            }
            parentCategoricalValuesBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                        .CategoricalValueCondition,
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                        .CategoricalValueCondition.Builder,
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                        .CategoricalValueConditionOrBuilder>(
                    (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                            .CategoricalValueCondition)
                        parentValueCondition_,
                    getParentForChildren(),
                    isClean());
            parentValueCondition_ = null;
          }
          parentValueConditionCase_ = 4;
          onChanged();
          return parentCategoricalValuesBuilder_;
        }

        private com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameterSpec_;
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpecOrBuilder>
            parameterSpecBuilder_;
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return Whether the parameterSpec field is set.
         */
        public boolean hasParameterSpec() {
          return ((bitField0_ & 0x00000008) != 0);
        }
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         *
         * @return The parameterSpec.
         */
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec getParameterSpec() {
          if (parameterSpecBuilder_ == null) {
            return parameterSpec_ == null
                ? com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.getDefaultInstance()
                : parameterSpec_;
          } else {
            return parameterSpecBuilder_.getMessage();
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setParameterSpec(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec value) {
          if (parameterSpecBuilder_ == null) {
            if (value == null) {
              throw new NullPointerException();
            }
            parameterSpec_ = value;
          } else {
            parameterSpecBuilder_.setMessage(value);
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder setParameterSpec(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder builderForValue) {
          if (parameterSpecBuilder_ == null) {
            parameterSpec_ = builderForValue.build();
          } else {
            parameterSpecBuilder_.setMessage(builderForValue.build());
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder mergeParameterSpec(
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec value) {
          if (parameterSpecBuilder_ == null) {
            if (((bitField0_ & 0x00000008) != 0)
                && parameterSpec_ != null
                && parameterSpec_
                    != com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                        .getDefaultInstance()) {
              getParameterSpecBuilder().mergeFrom(value);
            } else {
              parameterSpec_ = value;
            }
          } else {
            parameterSpecBuilder_.mergeFrom(value);
          }
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public Builder clearParameterSpec() {
          bitField0_ = (bitField0_ & ~0x00000008);
          parameterSpec_ = null;
          if (parameterSpecBuilder_ != null) {
            parameterSpecBuilder_.dispose();
            parameterSpecBuilder_ = null;
          }
          onChanged();
          return this;
        }
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder
            getParameterSpecBuilder() {
          bitField0_ |= 0x00000008;
          onChanged();
          return getParameterSpecFieldBuilder().getBuilder();
        }
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpecOrBuilder
            getParameterSpecOrBuilder() {
          if (parameterSpecBuilder_ != null) {
            return parameterSpecBuilder_.getMessageOrBuilder();
          } else {
            return parameterSpec_ == null
                ? com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.getDefaultInstance()
                : parameterSpec_;
          }
        }
        /**
         *
         *
         * <pre>
         * Required. The spec for a conditional parameter.
         * </pre>
         *
         * <code>
         * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameter_spec = 1 [(.google.api.field_behavior) = REQUIRED];
         * </code>
         */
        private com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpecOrBuilder>
            getParameterSpecFieldBuilder() {
          if (parameterSpecBuilder_ == null) {
            parameterSpecBuilder_ =
                new com.google.protobuf.SingleFieldBuilderV3<
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec,
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder,
                    com.google.cloud.aiplatform.v1.StudySpec.ParameterSpecOrBuilder>(
                    getParameterSpec(), getParentForChildren(), isClean());
            parameterSpec_ = null;
          }
          return parameterSpecBuilder_;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec)
      private static final com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
              .ConditionalParameterSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec();
      }

      public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<ConditionalParameterSpec> PARSER =
          new com.google.protobuf.AbstractParser<ConditionalParameterSpec>() {
            @java.lang.Override
            public ConditionalParameterSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<ConditionalParameterSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<ConditionalParameterSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int parameterValueSpecCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object parameterValueSpec_;

    public enum ParameterValueSpecCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      DOUBLE_VALUE_SPEC(2),
      INTEGER_VALUE_SPEC(3),
      CATEGORICAL_VALUE_SPEC(4),
      DISCRETE_VALUE_SPEC(5),
      PARAMETERVALUESPEC_NOT_SET(0);
      private final int value;

      private ParameterValueSpecCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ParameterValueSpecCase valueOf(int value) {
        return forNumber(value);
      }

      public static ParameterValueSpecCase forNumber(int value) {
        switch (value) {
          case 2:
            return DOUBLE_VALUE_SPEC;
          case 3:
            return INTEGER_VALUE_SPEC;
          case 4:
            return CATEGORICAL_VALUE_SPEC;
          case 5:
            return DISCRETE_VALUE_SPEC;
          case 0:
            return PARAMETERVALUESPEC_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ParameterValueSpecCase getParameterValueSpecCase() {
      return ParameterValueSpecCase.forNumber(parameterValueSpecCase_);
    }

    public static final int DOUBLE_VALUE_SPEC_FIELD_NUMBER = 2;
    /**
     *
     *
     * <pre>
     * The value spec for a 'DOUBLE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
     * </code>
     *
     * @return Whether the doubleValueSpec field is set.
     */
    @java.lang.Override
    public boolean hasDoubleValueSpec() {
      return parameterValueSpecCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * The value spec for a 'DOUBLE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
     * </code>
     *
     * @return The doubleValueSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
        getDoubleValueSpec() {
      if (parameterValueSpecCase_ == 2) {
        return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec)
            parameterValueSpec_;
      }
      return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The value spec for a 'DOUBLE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpecOrBuilder
        getDoubleValueSpecOrBuilder() {
      if (parameterValueSpecCase_ == 2) {
        return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec)
            parameterValueSpec_;
      }
      return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          .getDefaultInstance();
    }

    public static final int INTEGER_VALUE_SPEC_FIELD_NUMBER = 3;
    /**
     *
     *
     * <pre>
     * The value spec for an 'INTEGER' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
     * </code>
     *
     * @return Whether the integerValueSpec field is set.
     */
    @java.lang.Override
    public boolean hasIntegerValueSpec() {
      return parameterValueSpecCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * The value spec for an 'INTEGER' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
     * </code>
     *
     * @return The integerValueSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
        getIntegerValueSpec() {
      if (parameterValueSpecCase_ == 3) {
        return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec)
            parameterValueSpec_;
      }
      return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The value spec for an 'INTEGER' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpecOrBuilder
        getIntegerValueSpecOrBuilder() {
      if (parameterValueSpecCase_ == 3) {
        return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec)
            parameterValueSpec_;
      }
      return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          .getDefaultInstance();
    }

    public static final int CATEGORICAL_VALUE_SPEC_FIELD_NUMBER = 4;
    /**
     *
     *
     * <pre>
     * The value spec for a 'CATEGORICAL' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
     * </code>
     *
     * @return Whether the categoricalValueSpec field is set.
     */
    @java.lang.Override
    public boolean hasCategoricalValueSpec() {
      return parameterValueSpecCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The value spec for a 'CATEGORICAL' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
     * </code>
     *
     * @return The categoricalValueSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
        getCategoricalValueSpec() {
      if (parameterValueSpecCase_ == 4) {
        return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec)
            parameterValueSpec_;
      }
      return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The value spec for a 'CATEGORICAL' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpecOrBuilder
        getCategoricalValueSpecOrBuilder() {
      if (parameterValueSpecCase_ == 4) {
        return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec)
            parameterValueSpec_;
      }
      return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          .getDefaultInstance();
    }

    public static final int DISCRETE_VALUE_SPEC_FIELD_NUMBER = 5;
    /**
     *
     *
     * <pre>
     * The value spec for a 'DISCRETE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
     * </code>
     *
     * @return Whether the discreteValueSpec field is set.
     */
    @java.lang.Override
    public boolean hasDiscreteValueSpec() {
      return parameterValueSpecCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The value spec for a 'DISCRETE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
     * </code>
     *
     * @return The discreteValueSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
        getDiscreteValueSpec() {
      if (parameterValueSpecCase_ == 5) {
        return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec)
            parameterValueSpec_;
      }
      return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          .getDefaultInstance();
    }
    /**
     *
     *
     * <pre>
     * The value spec for a 'DISCRETE' parameter.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpecOrBuilder
        getDiscreteValueSpecOrBuilder() {
      if (parameterValueSpecCase_ == 5) {
        return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec)
            parameterValueSpec_;
      }
      return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          .getDefaultInstance();
    }

    public static final int PARAMETER_ID_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object parameterId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of the parameter. Must not contain whitespaces and must
     * be unique amongst all ParameterSpecs.
     * </pre>
     *
     * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The parameterId.
     */
    @java.lang.Override
    public java.lang.String getParameterId() {
      java.lang.Object ref = parameterId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parameterId_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the parameter. Must not contain whitespaces and must
     * be unique amongst all ParameterSpecs.
     * </pre>
     *
     * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for parameterId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getParameterIdBytes() {
      java.lang.Object ref = parameterId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parameterId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int SCALE_TYPE_FIELD_NUMBER = 6;
    private int scaleType_ = 0;
    /**
     *
     *
     * <pre>
     * How the parameter should be scaled.
     * Leave unset for `CATEGORICAL` parameters.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType scale_type = 6;</code>
     *
     * @return The enum numeric value on the wire for scaleType.
     */
    @java.lang.Override
    public int getScaleTypeValue() {
      return scaleType_;
    }
    /**
     *
     *
     * <pre>
     * How the parameter should be scaled.
     * Leave unset for `CATEGORICAL` parameters.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType scale_type = 6;</code>
     *
     * @return The scaleType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType getScaleType() {
      com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType result =
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType.forNumber(scaleType_);
      return result == null
          ? com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType.UNRECOGNIZED
          : result;
    }

    public static final int CONDITIONAL_PARAMETER_SPECS_FIELD_NUMBER = 10;

    @SuppressWarnings("serial")
    private java.util.List<
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec>
        conditionalParameterSpecs_;
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     *
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec>
        getConditionalParameterSpecsList() {
      return conditionalParameterSpecs_;
    }
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     *
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    @java.lang.Override
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                    .ConditionalParameterSpecOrBuilder>
        getConditionalParameterSpecsOrBuilderList() {
      return conditionalParameterSpecs_;
    }
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     *
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    @java.lang.Override
    public int getConditionalParameterSpecsCount() {
      return conditionalParameterSpecs_.size();
    }
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     *
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
        getConditionalParameterSpecs(int index) {
      return conditionalParameterSpecs_.get(index);
    }
    /**
     *
     *
     * <pre>
     * A conditional parameter node is active if the parameter's value matches
     * the conditional node's parent_value_condition.
     *
     * If two items in conditional_parameter_specs have the same name, they
     * must have disjoint parent_value_condition.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpecOrBuilder
        getConditionalParameterSpecsOrBuilder(int index) {
      return conditionalParameterSpecs_.get(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parameterId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parameterId_);
      }
      if (parameterValueSpecCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec)
                parameterValueSpec_);
      }
      if (parameterValueSpecCase_ == 3) {
        output.writeMessage(
            3,
            (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec)
                parameterValueSpec_);
      }
      if (parameterValueSpecCase_ == 4) {
        output.writeMessage(
            4,
            (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec)
                parameterValueSpec_);
      }
      if (parameterValueSpecCase_ == 5) {
        output.writeMessage(
            5,
            (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec)
                parameterValueSpec_);
      }
      if (scaleType_
          != com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType.SCALE_TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(6, scaleType_);
      }
      for (int i = 0; i < conditionalParameterSpecs_.size(); i++) {
        output.writeMessage(10, conditionalParameterSpecs_.get(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parameterId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parameterId_);
      }
      if (parameterValueSpecCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec)
                    parameterValueSpec_);
      }
      if (parameterValueSpecCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3,
                (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec)
                    parameterValueSpec_);
      }
      if (parameterValueSpecCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                4,
                (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec)
                    parameterValueSpec_);
      }
      if (parameterValueSpecCase_ == 5) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                5,
                (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec)
                    parameterValueSpec_);
      }
      if (scaleType_
          != com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType.SCALE_TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, scaleType_);
      }
      for (int i = 0; i < conditionalParameterSpecs_.size(); i++) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                10, conditionalParameterSpecs_.get(i));
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec other =
          (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec) obj;

      if (!getParameterId().equals(other.getParameterId())) return false;
      if (scaleType_ != other.scaleType_) return false;
      if (!getConditionalParameterSpecsList().equals(other.getConditionalParameterSpecsList()))
        return false;
      if (!getParameterValueSpecCase().equals(other.getParameterValueSpecCase())) return false;
      switch (parameterValueSpecCase_) {
        case 2:
          if (!getDoubleValueSpec().equals(other.getDoubleValueSpec())) return false;
          break;
        case 3:
          if (!getIntegerValueSpec().equals(other.getIntegerValueSpec())) return false;
          break;
        case 4:
          if (!getCategoricalValueSpec().equals(other.getCategoricalValueSpec())) return false;
          break;
        case 5:
          if (!getDiscreteValueSpec().equals(other.getDiscreteValueSpec())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PARAMETER_ID_FIELD_NUMBER;
      hash = (53 * hash) + getParameterId().hashCode();
      hash = (37 * hash) + SCALE_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + scaleType_;
      if (getConditionalParameterSpecsCount() > 0) {
        hash = (37 * hash) + CONDITIONAL_PARAMETER_SPECS_FIELD_NUMBER;
        hash = (53 * hash) + getConditionalParameterSpecsList().hashCode();
      }
      switch (parameterValueSpecCase_) {
        case 2:
          hash = (37 * hash) + DOUBLE_VALUE_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getDoubleValueSpec().hashCode();
          break;
        case 3:
          hash = (37 * hash) + INTEGER_VALUE_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getIntegerValueSpec().hashCode();
          break;
        case 4:
          hash = (37 * hash) + CATEGORICAL_VALUE_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getCategoricalValueSpec().hashCode();
          break;
        case 5:
          hash = (37 * hash) + DISCRETE_VALUE_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getDiscreteValueSpec().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Represents a single parameter to optimize.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.ParameterSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.StudySpec.ParameterSpec)
        com.google.cloud.aiplatform.v1.StudySpec.ParameterSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.class,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (doubleValueSpecBuilder_ != null) {
          doubleValueSpecBuilder_.clear();
        }
        if (integerValueSpecBuilder_ != null) {
          integerValueSpecBuilder_.clear();
        }
        if (categoricalValueSpecBuilder_ != null) {
          categoricalValueSpecBuilder_.clear();
        }
        if (discreteValueSpecBuilder_ != null) {
          discreteValueSpecBuilder_.clear();
        }
        parameterId_ = "";
        scaleType_ = 0;
        if (conditionalParameterSpecsBuilder_ == null) {
          conditionalParameterSpecs_ = java.util.Collections.emptyList();
        } else {
          conditionalParameterSpecs_ = null;
          conditionalParameterSpecsBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000040);
        parameterValueSpecCase_ = 0;
        parameterValueSpec_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_ParameterSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec build() {
        com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec buildPartial() {
        com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec result =
            new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec result) {
        if (conditionalParameterSpecsBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)) {
            conditionalParameterSpecs_ =
                java.util.Collections.unmodifiableList(conditionalParameterSpecs_);
            bitField0_ = (bitField0_ & ~0x00000040);
          }
          result.conditionalParameterSpecs_ = conditionalParameterSpecs_;
        } else {
          result.conditionalParameterSpecs_ = conditionalParameterSpecsBuilder_.build();
        }
      }

      private void buildPartial0(com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.parameterId_ = parameterId_;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.scaleType_ = scaleType_;
        }
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec result) {
        result.parameterValueSpecCase_ = parameterValueSpecCase_;
        result.parameterValueSpec_ = this.parameterValueSpec_;
        if (parameterValueSpecCase_ == 2 && doubleValueSpecBuilder_ != null) {
          result.parameterValueSpec_ = doubleValueSpecBuilder_.build();
        }
        if (parameterValueSpecCase_ == 3 && integerValueSpecBuilder_ != null) {
          result.parameterValueSpec_ = integerValueSpecBuilder_.build();
        }
        if (parameterValueSpecCase_ == 4 && categoricalValueSpecBuilder_ != null) {
          result.parameterValueSpec_ = categoricalValueSpecBuilder_.build();
        }
        if (parameterValueSpecCase_ == 5 && discreteValueSpecBuilder_ != null) {
          result.parameterValueSpec_ = discreteValueSpecBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec) {
          return mergeFrom((com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec other) {
        if (other == com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.getDefaultInstance())
          return this;
        if (!other.getParameterId().isEmpty()) {
          parameterId_ = other.parameterId_;
          bitField0_ |= 0x00000010;
          onChanged();
        }
        if (other.scaleType_ != 0) {
          setScaleTypeValue(other.getScaleTypeValue());
        }
        if (conditionalParameterSpecsBuilder_ == null) {
          if (!other.conditionalParameterSpecs_.isEmpty()) {
            if (conditionalParameterSpecs_.isEmpty()) {
              conditionalParameterSpecs_ = other.conditionalParameterSpecs_;
              bitField0_ = (bitField0_ & ~0x00000040);
            } else {
              ensureConditionalParameterSpecsIsMutable();
              conditionalParameterSpecs_.addAll(other.conditionalParameterSpecs_);
            }
            onChanged();
          }
        } else {
          if (!other.conditionalParameterSpecs_.isEmpty()) {
            if (conditionalParameterSpecsBuilder_.isEmpty()) {
              conditionalParameterSpecsBuilder_.dispose();
              conditionalParameterSpecsBuilder_ = null;
              conditionalParameterSpecs_ = other.conditionalParameterSpecs_;
              bitField0_ = (bitField0_ & ~0x00000040);
              conditionalParameterSpecsBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getConditionalParameterSpecsFieldBuilder()
                      : null;
            } else {
              conditionalParameterSpecsBuilder_.addAllMessages(other.conditionalParameterSpecs_);
            }
          }
        }
        switch (other.getParameterValueSpecCase()) {
          case DOUBLE_VALUE_SPEC:
            {
              mergeDoubleValueSpec(other.getDoubleValueSpec());
              break;
            }
          case INTEGER_VALUE_SPEC:
            {
              mergeIntegerValueSpec(other.getIntegerValueSpec());
              break;
            }
          case CATEGORICAL_VALUE_SPEC:
            {
              mergeCategoricalValueSpec(other.getCategoricalValueSpec());
              break;
            }
          case DISCRETE_VALUE_SPEC:
            {
              mergeDiscreteValueSpec(other.getDiscreteValueSpec());
              break;
            }
          case PARAMETERVALUESPEC_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  parameterId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getDoubleValueSpecFieldBuilder().getBuilder(), extensionRegistry);
                  parameterValueSpecCase_ = 2;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getIntegerValueSpecFieldBuilder().getBuilder(), extensionRegistry);
                  parameterValueSpecCase_ = 3;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(
                      getCategoricalValueSpecFieldBuilder().getBuilder(), extensionRegistry);
                  parameterValueSpecCase_ = 4;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(
                      getDiscreteValueSpecFieldBuilder().getBuilder(), extensionRegistry);
                  parameterValueSpecCase_ = 5;
                  break;
                } // case 42
              case 48:
                {
                  scaleType_ = input.readEnum();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 48
              case 82:
                {
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      m =
                          input.readMessage(
                              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                                  .ConditionalParameterSpec.parser(),
                              extensionRegistry);
                  if (conditionalParameterSpecsBuilder_ == null) {
                    ensureConditionalParameterSpecsIsMutable();
                    conditionalParameterSpecs_.add(m);
                  } else {
                    conditionalParameterSpecsBuilder_.addMessage(m);
                  }
                  break;
                } // case 82
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int parameterValueSpecCase_ = 0;
      private java.lang.Object parameterValueSpec_;

      public ParameterValueSpecCase getParameterValueSpecCase() {
        return ParameterValueSpecCase.forNumber(parameterValueSpecCase_);
      }

      public Builder clearParameterValueSpec() {
        parameterValueSpecCase_ = 0;
        parameterValueSpec_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec.Builder,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpecOrBuilder>
          doubleValueSpecBuilder_;
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       *
       * @return Whether the doubleValueSpec field is set.
       */
      @java.lang.Override
      public boolean hasDoubleValueSpec() {
        return parameterValueSpecCase_ == 2;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       *
       * @return The doubleValueSpec.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
          getDoubleValueSpec() {
        if (doubleValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 2) {
            return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec)
                parameterValueSpec_;
          }
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
              .getDefaultInstance();
        } else {
          if (parameterValueSpecCase_ == 2) {
            return doubleValueSpecBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       */
      public Builder setDoubleValueSpec(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec value) {
        if (doubleValueSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          parameterValueSpec_ = value;
          onChanged();
        } else {
          doubleValueSpecBuilder_.setMessage(value);
        }
        parameterValueSpecCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       */
      public Builder setDoubleValueSpec(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec.Builder
              builderForValue) {
        if (doubleValueSpecBuilder_ == null) {
          parameterValueSpec_ = builderForValue.build();
          onChanged();
        } else {
          doubleValueSpecBuilder_.setMessage(builderForValue.build());
        }
        parameterValueSpecCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       */
      public Builder mergeDoubleValueSpec(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec value) {
        if (doubleValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 2
              && parameterValueSpec_
                  != com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
                      .getDefaultInstance()) {
            parameterValueSpec_ =
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec.newBuilder(
                        (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec)
                            parameterValueSpec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            parameterValueSpec_ = value;
          }
          onChanged();
        } else {
          if (parameterValueSpecCase_ == 2) {
            doubleValueSpecBuilder_.mergeFrom(value);
          } else {
            doubleValueSpecBuilder_.setMessage(value);
          }
        }
        parameterValueSpecCase_ = 2;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       */
      public Builder clearDoubleValueSpec() {
        if (doubleValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 2) {
            parameterValueSpecCase_ = 0;
            parameterValueSpec_ = null;
            onChanged();
          }
        } else {
          if (parameterValueSpecCase_ == 2) {
            parameterValueSpecCase_ = 0;
            parameterValueSpec_ = null;
          }
          doubleValueSpecBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec.Builder
          getDoubleValueSpecBuilder() {
        return getDoubleValueSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpecOrBuilder
          getDoubleValueSpecOrBuilder() {
        if ((parameterValueSpecCase_ == 2) && (doubleValueSpecBuilder_ != null)) {
          return doubleValueSpecBuilder_.getMessageOrBuilder();
        } else {
          if (parameterValueSpecCase_ == 2) {
            return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec)
                parameterValueSpec_;
          }
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DOUBLE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec double_value_spec = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec.Builder,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpecOrBuilder>
          getDoubleValueSpecFieldBuilder() {
        if (doubleValueSpecBuilder_ == null) {
          if (!(parameterValueSpecCase_ == 2)) {
            parameterValueSpec_ =
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec
                    .getDefaultInstance();
          }
          doubleValueSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec.Builder,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpecOrBuilder>(
                  (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DoubleValueSpec)
                      parameterValueSpec_,
                  getParentForChildren(),
                  isClean());
          parameterValueSpec_ = null;
        }
        parameterValueSpecCase_ = 2;
        onChanged();
        return doubleValueSpecBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec.Builder,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpecOrBuilder>
          integerValueSpecBuilder_;
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       *
       * @return Whether the integerValueSpec field is set.
       */
      @java.lang.Override
      public boolean hasIntegerValueSpec() {
        return parameterValueSpecCase_ == 3;
      }
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       *
       * @return The integerValueSpec.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
          getIntegerValueSpec() {
        if (integerValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 3) {
            return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec)
                parameterValueSpec_;
          }
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
              .getDefaultInstance();
        } else {
          if (parameterValueSpecCase_ == 3) {
            return integerValueSpecBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       */
      public Builder setIntegerValueSpec(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec value) {
        if (integerValueSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          parameterValueSpec_ = value;
          onChanged();
        } else {
          integerValueSpecBuilder_.setMessage(value);
        }
        parameterValueSpecCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       */
      public Builder setIntegerValueSpec(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec.Builder
              builderForValue) {
        if (integerValueSpecBuilder_ == null) {
          parameterValueSpec_ = builderForValue.build();
          onChanged();
        } else {
          integerValueSpecBuilder_.setMessage(builderForValue.build());
        }
        parameterValueSpecCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       */
      public Builder mergeIntegerValueSpec(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec value) {
        if (integerValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 3
              && parameterValueSpec_
                  != com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
                      .getDefaultInstance()) {
            parameterValueSpec_ =
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec.newBuilder(
                        (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec)
                            parameterValueSpec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            parameterValueSpec_ = value;
          }
          onChanged();
        } else {
          if (parameterValueSpecCase_ == 3) {
            integerValueSpecBuilder_.mergeFrom(value);
          } else {
            integerValueSpecBuilder_.setMessage(value);
          }
        }
        parameterValueSpecCase_ = 3;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       */
      public Builder clearIntegerValueSpec() {
        if (integerValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 3) {
            parameterValueSpecCase_ = 0;
            parameterValueSpec_ = null;
            onChanged();
          }
        } else {
          if (parameterValueSpecCase_ == 3) {
            parameterValueSpecCase_ = 0;
            parameterValueSpec_ = null;
          }
          integerValueSpecBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec.Builder
          getIntegerValueSpecBuilder() {
        return getIntegerValueSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpecOrBuilder
          getIntegerValueSpecOrBuilder() {
        if ((parameterValueSpecCase_ == 3) && (integerValueSpecBuilder_ != null)) {
          return integerValueSpecBuilder_.getMessageOrBuilder();
        } else {
          if (parameterValueSpecCase_ == 3) {
            return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec)
                parameterValueSpec_;
          }
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The value spec for an 'INTEGER' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec integer_value_spec = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec.Builder,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpecOrBuilder>
          getIntegerValueSpecFieldBuilder() {
        if (integerValueSpecBuilder_ == null) {
          if (!(parameterValueSpecCase_ == 3)) {
            parameterValueSpec_ =
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec
                    .getDefaultInstance();
          }
          integerValueSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec.Builder,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpecOrBuilder>(
                  (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.IntegerValueSpec)
                      parameterValueSpec_,
                  getParentForChildren(),
                  isClean());
          parameterValueSpec_ = null;
        }
        parameterValueSpecCase_ = 3;
        onChanged();
        return integerValueSpecBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec.Builder,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpecOrBuilder>
          categoricalValueSpecBuilder_;
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       *
       * @return Whether the categoricalValueSpec field is set.
       */
      @java.lang.Override
      public boolean hasCategoricalValueSpec() {
        return parameterValueSpecCase_ == 4;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       *
       * @return The categoricalValueSpec.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
          getCategoricalValueSpec() {
        if (categoricalValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 4) {
            return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec)
                parameterValueSpec_;
          }
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
              .getDefaultInstance();
        } else {
          if (parameterValueSpecCase_ == 4) {
            return categoricalValueSpecBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       */
      public Builder setCategoricalValueSpec(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec value) {
        if (categoricalValueSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          parameterValueSpec_ = value;
          onChanged();
        } else {
          categoricalValueSpecBuilder_.setMessage(value);
        }
        parameterValueSpecCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       */
      public Builder setCategoricalValueSpec(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec.Builder
              builderForValue) {
        if (categoricalValueSpecBuilder_ == null) {
          parameterValueSpec_ = builderForValue.build();
          onChanged();
        } else {
          categoricalValueSpecBuilder_.setMessage(builderForValue.build());
        }
        parameterValueSpecCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       */
      public Builder mergeCategoricalValueSpec(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec value) {
        if (categoricalValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 4
              && parameterValueSpec_
                  != com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
                      .getDefaultInstance()) {
            parameterValueSpec_ =
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
                    .newBuilder(
                        (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                                .CategoricalValueSpec)
                            parameterValueSpec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            parameterValueSpec_ = value;
          }
          onChanged();
        } else {
          if (parameterValueSpecCase_ == 4) {
            categoricalValueSpecBuilder_.mergeFrom(value);
          } else {
            categoricalValueSpecBuilder_.setMessage(value);
          }
        }
        parameterValueSpecCase_ = 4;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       */
      public Builder clearCategoricalValueSpec() {
        if (categoricalValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 4) {
            parameterValueSpecCase_ = 0;
            parameterValueSpec_ = null;
            onChanged();
          }
        } else {
          if (parameterValueSpecCase_ == 4) {
            parameterValueSpecCase_ = 0;
            parameterValueSpec_ = null;
          }
          categoricalValueSpecBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec.Builder
          getCategoricalValueSpecBuilder() {
        return getCategoricalValueSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpecOrBuilder
          getCategoricalValueSpecOrBuilder() {
        if ((parameterValueSpecCase_ == 4) && (categoricalValueSpecBuilder_ != null)) {
          return categoricalValueSpecBuilder_.getMessageOrBuilder();
        } else {
          if (parameterValueSpecCase_ == 4) {
            return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec)
                parameterValueSpec_;
          }
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'CATEGORICAL' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec categorical_value_spec = 4;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec.Builder,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpecOrBuilder>
          getCategoricalValueSpecFieldBuilder() {
        if (categoricalValueSpecBuilder_ == null) {
          if (!(parameterValueSpecCase_ == 4)) {
            parameterValueSpec_ =
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
                    .getDefaultInstance();
          }
          categoricalValueSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec
                      .Builder,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                      .CategoricalValueSpecOrBuilder>(
                  (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.CategoricalValueSpec)
                      parameterValueSpec_,
                  getParentForChildren(),
                  isClean());
          parameterValueSpec_ = null;
        }
        parameterValueSpecCase_ = 4;
        onChanged();
        return categoricalValueSpecBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec.Builder,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpecOrBuilder>
          discreteValueSpecBuilder_;
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       *
       * @return Whether the discreteValueSpec field is set.
       */
      @java.lang.Override
      public boolean hasDiscreteValueSpec() {
        return parameterValueSpecCase_ == 5;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       *
       * @return The discreteValueSpec.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
          getDiscreteValueSpec() {
        if (discreteValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 5) {
            return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec)
                parameterValueSpec_;
          }
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
              .getDefaultInstance();
        } else {
          if (parameterValueSpecCase_ == 5) {
            return discreteValueSpecBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       */
      public Builder setDiscreteValueSpec(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec value) {
        if (discreteValueSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          parameterValueSpec_ = value;
          onChanged();
        } else {
          discreteValueSpecBuilder_.setMessage(value);
        }
        parameterValueSpecCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       */
      public Builder setDiscreteValueSpec(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec.Builder
              builderForValue) {
        if (discreteValueSpecBuilder_ == null) {
          parameterValueSpec_ = builderForValue.build();
          onChanged();
        } else {
          discreteValueSpecBuilder_.setMessage(builderForValue.build());
        }
        parameterValueSpecCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       */
      public Builder mergeDiscreteValueSpec(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec value) {
        if (discreteValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 5
              && parameterValueSpec_
                  != com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
                      .getDefaultInstance()) {
            parameterValueSpec_ =
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec.newBuilder(
                        (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec)
                            parameterValueSpec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            parameterValueSpec_ = value;
          }
          onChanged();
        } else {
          if (parameterValueSpecCase_ == 5) {
            discreteValueSpecBuilder_.mergeFrom(value);
          } else {
            discreteValueSpecBuilder_.setMessage(value);
          }
        }
        parameterValueSpecCase_ = 5;
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       */
      public Builder clearDiscreteValueSpec() {
        if (discreteValueSpecBuilder_ == null) {
          if (parameterValueSpecCase_ == 5) {
            parameterValueSpecCase_ = 0;
            parameterValueSpec_ = null;
            onChanged();
          }
        } else {
          if (parameterValueSpecCase_ == 5) {
            parameterValueSpecCase_ = 0;
            parameterValueSpec_ = null;
          }
          discreteValueSpecBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec.Builder
          getDiscreteValueSpecBuilder() {
        return getDiscreteValueSpecFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpecOrBuilder
          getDiscreteValueSpecOrBuilder() {
        if ((parameterValueSpecCase_ == 5) && (discreteValueSpecBuilder_ != null)) {
          return discreteValueSpecBuilder_.getMessageOrBuilder();
        } else {
          if (parameterValueSpecCase_ == 5) {
            return (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec)
                parameterValueSpec_;
          }
          return com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
              .getDefaultInstance();
        }
      }
      /**
       *
       *
       * <pre>
       * The value spec for a 'DISCRETE' parameter.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec discrete_value_spec = 5;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec.Builder,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpecOrBuilder>
          getDiscreteValueSpecFieldBuilder() {
        if (discreteValueSpecBuilder_ == null) {
          if (!(parameterValueSpecCase_ == 5)) {
            parameterValueSpec_ =
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec
                    .getDefaultInstance();
          }
          discreteValueSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec.Builder,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                      .DiscreteValueSpecOrBuilder>(
                  (com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.DiscreteValueSpec)
                      parameterValueSpec_,
                  getParentForChildren(),
                  isClean());
          parameterValueSpec_ = null;
        }
        parameterValueSpecCase_ = 5;
        onChanged();
        return discreteValueSpecBuilder_;
      }

      private java.lang.Object parameterId_ = "";
      /**
       *
       *
       * <pre>
       * Required. The ID of the parameter. Must not contain whitespaces and must
       * be unique amongst all ParameterSpecs.
       * </pre>
       *
       * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The parameterId.
       */
      public java.lang.String getParameterId() {
        java.lang.Object ref = parameterId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          parameterId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the parameter. Must not contain whitespaces and must
       * be unique amongst all ParameterSpecs.
       * </pre>
       *
       * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for parameterId.
       */
      public com.google.protobuf.ByteString getParameterIdBytes() {
        java.lang.Object ref = parameterId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          parameterId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the parameter. Must not contain whitespaces and must
       * be unique amongst all ParameterSpecs.
       * </pre>
       *
       * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The parameterId to set.
       * @return This builder for chaining.
       */
      public Builder setParameterId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        parameterId_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the parameter. Must not contain whitespaces and must
       * be unique amongst all ParameterSpecs.
       * </pre>
       *
       * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearParameterId() {
        parameterId_ = getDefaultInstance().getParameterId();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Required. The ID of the parameter. Must not contain whitespaces and must
       * be unique amongst all ParameterSpecs.
       * </pre>
       *
       * <code>string parameter_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for parameterId to set.
       * @return This builder for chaining.
       */
      public Builder setParameterIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        parameterId_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      private int scaleType_ = 0;
      /**
       *
       *
       * <pre>
       * How the parameter should be scaled.
       * Leave unset for `CATEGORICAL` parameters.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType scale_type = 6;</code>
       *
       * @return The enum numeric value on the wire for scaleType.
       */
      @java.lang.Override
      public int getScaleTypeValue() {
        return scaleType_;
      }
      /**
       *
       *
       * <pre>
       * How the parameter should be scaled.
       * Leave unset for `CATEGORICAL` parameters.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType scale_type = 6;</code>
       *
       * @param value The enum numeric value on the wire for scaleType to set.
       * @return This builder for chaining.
       */
      public Builder setScaleTypeValue(int value) {
        scaleType_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * How the parameter should be scaled.
       * Leave unset for `CATEGORICAL` parameters.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType scale_type = 6;</code>
       *
       * @return The scaleType.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType getScaleType() {
        com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType result =
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType.forNumber(scaleType_);
        return result == null
            ? com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType.UNRECOGNIZED
            : result;
      }
      /**
       *
       *
       * <pre>
       * How the parameter should be scaled.
       * Leave unset for `CATEGORICAL` parameters.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType scale_type = 6;</code>
       *
       * @param value The scaleType to set.
       * @return This builder for chaining.
       */
      public Builder setScaleType(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000020;
        scaleType_ = value.getNumber();
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * How the parameter should be scaled.
       * Leave unset for `CATEGORICAL` parameters.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ScaleType scale_type = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearScaleType() {
        bitField0_ = (bitField0_ & ~0x00000020);
        scaleType_ = 0;
        onChanged();
        return this;
      }

      private java.util.List<
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec>
          conditionalParameterSpecs_ = java.util.Collections.emptyList();

      private void ensureConditionalParameterSpecsIsMutable() {
        if (!((bitField0_ & 0x00000040) != 0)) {
          conditionalParameterSpecs_ =
              new java.util.ArrayList<
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec>(
                  conditionalParameterSpecs_);
          bitField0_ |= 0x00000040;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .Builder,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                  .ConditionalParameterSpecOrBuilder>
          conditionalParameterSpecsBuilder_;

      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec>
          getConditionalParameterSpecsList() {
        if (conditionalParameterSpecsBuilder_ == null) {
          return java.util.Collections.unmodifiableList(conditionalParameterSpecs_);
        } else {
          return conditionalParameterSpecsBuilder_.getMessageList();
        }
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public int getConditionalParameterSpecsCount() {
        if (conditionalParameterSpecsBuilder_ == null) {
          return conditionalParameterSpecs_.size();
        } else {
          return conditionalParameterSpecsBuilder_.getCount();
        }
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
          getConditionalParameterSpecs(int index) {
        if (conditionalParameterSpecsBuilder_ == null) {
          return conditionalParameterSpecs_.get(index);
        } else {
          return conditionalParameterSpecsBuilder_.getMessage(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder setConditionalParameterSpecs(
          int index,
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec value) {
        if (conditionalParameterSpecsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionalParameterSpecsIsMutable();
          conditionalParameterSpecs_.set(index, value);
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.setMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder setConditionalParameterSpecs(
          int index,
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.Builder
              builderForValue) {
        if (conditionalParameterSpecsBuilder_ == null) {
          ensureConditionalParameterSpecsIsMutable();
          conditionalParameterSpecs_.set(index, builderForValue.build());
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder addConditionalParameterSpecs(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec value) {
        if (conditionalParameterSpecsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionalParameterSpecsIsMutable();
          conditionalParameterSpecs_.add(value);
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.addMessage(value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder addConditionalParameterSpecs(
          int index,
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec value) {
        if (conditionalParameterSpecsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureConditionalParameterSpecsIsMutable();
          conditionalParameterSpecs_.add(index, value);
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.addMessage(index, value);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder addConditionalParameterSpecs(
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.Builder
              builderForValue) {
        if (conditionalParameterSpecsBuilder_ == null) {
          ensureConditionalParameterSpecsIsMutable();
          conditionalParameterSpecs_.add(builderForValue.build());
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder addConditionalParameterSpecs(
          int index,
          com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.Builder
              builderForValue) {
        if (conditionalParameterSpecsBuilder_ == null) {
          ensureConditionalParameterSpecsIsMutable();
          conditionalParameterSpecs_.add(index, builderForValue.build());
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder addAllConditionalParameterSpecs(
          java.lang.Iterable<
                  ? extends
                      com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                          .ConditionalParameterSpec>
              values) {
        if (conditionalParameterSpecsBuilder_ == null) {
          ensureConditionalParameterSpecsIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(
              values, conditionalParameterSpecs_);
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.addAllMessages(values);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder clearConditionalParameterSpecs() {
        if (conditionalParameterSpecsBuilder_ == null) {
          conditionalParameterSpecs_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000040);
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.clear();
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public Builder removeConditionalParameterSpecs(int index) {
        if (conditionalParameterSpecsBuilder_ == null) {
          ensureConditionalParameterSpecsIsMutable();
          conditionalParameterSpecs_.remove(index);
          onChanged();
        } else {
          conditionalParameterSpecsBuilder_.remove(index);
        }
        return this;
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.Builder
          getConditionalParameterSpecsBuilder(int index) {
        return getConditionalParameterSpecsFieldBuilder().getBuilder(index);
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
              .ConditionalParameterSpecOrBuilder
          getConditionalParameterSpecsOrBuilder(int index) {
        if (conditionalParameterSpecsBuilder_ == null) {
          return conditionalParameterSpecs_.get(index);
        } else {
          return conditionalParameterSpecsBuilder_.getMessageOrBuilder(index);
        }
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public java.util.List<
              ? extends
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                      .ConditionalParameterSpecOrBuilder>
          getConditionalParameterSpecsOrBuilderList() {
        if (conditionalParameterSpecsBuilder_ != null) {
          return conditionalParameterSpecsBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(conditionalParameterSpecs_);
        }
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.Builder
          addConditionalParameterSpecsBuilder() {
        return getConditionalParameterSpecsFieldBuilder()
            .addBuilder(
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec.Builder
          addConditionalParameterSpecsBuilder(int index) {
        return getConditionalParameterSpecsFieldBuilder()
            .addBuilder(
                index,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                    .getDefaultInstance());
      }
      /**
       *
       *
       * <pre>
       * A conditional parameter node is active if the parameter's value matches
       * the conditional node's parent_value_condition.
       *
       * If two items in conditional_parameter_specs have the same name, they
       * must have disjoint parent_value_condition.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec conditional_parameter_specs = 10;
       * </code>
       */
      public java.util.List<
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .Builder>
          getConditionalParameterSpecsBuilderList() {
        return getConditionalParameterSpecsFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                  .Builder,
              com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                  .ConditionalParameterSpecOrBuilder>
          getConditionalParameterSpecsFieldBuilder() {
        if (conditionalParameterSpecsBuilder_ == null) {
          conditionalParameterSpecsBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.ConditionalParameterSpec
                      .Builder,
                  com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec
                      .ConditionalParameterSpecOrBuilder>(
                  conditionalParameterSpecs_,
                  ((bitField0_ & 0x00000040) != 0),
                  getParentForChildren(),
                  isClean());
          conditionalParameterSpecs_ = null;
        }
        return conditionalParameterSpecsBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.StudySpec.ParameterSpec)
    private static final com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec();
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ParameterSpec> PARSER =
        new com.google.protobuf.AbstractParser<ParameterSpec>() {
          @java.lang.Override
          public ParameterSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ParameterSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ParameterSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DecayCurveAutomatedStoppingSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * True if
     * [Measurement.elapsed_duration][google.cloud.aiplatform.v1.Measurement.elapsed_duration]
     * is used as the x-axis of each Trials Decay Curve. Otherwise,
     * [Measurement.step_count][google.cloud.aiplatform.v1.Measurement.step_count]
     * will be used as the x-axis.
     * </pre>
     *
     * <code>bool use_elapsed_duration = 1;</code>
     *
     * @return The useElapsedDuration.
     */
    boolean getUseElapsedDuration();
  }
  /**
   *
   *
   * <pre>
   * The decay curve automated stopping rule builds a Gaussian Process
   * Regressor to predict the final objective value of a Trial based on the
   * already completed Trials and the intermediate measurements of the current
   * Trial. Early stopping is requested for the current Trial if there is very
   * low probability to exceed the optimal value found so far.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec}
   */
  public static final class DecayCurveAutomatedStoppingSpec
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec)
      DecayCurveAutomatedStoppingSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use DecayCurveAutomatedStoppingSpec.newBuilder() to construct.
    private DecayCurveAutomatedStoppingSpec(
        com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DecayCurveAutomatedStoppingSpec() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DecayCurveAutomatedStoppingSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_StudySpec_DecayCurveAutomatedStoppingSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_StudySpec_DecayCurveAutomatedStoppingSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec.class,
              com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec.Builder
                  .class);
    }

    public static final int USE_ELAPSED_DURATION_FIELD_NUMBER = 1;
    private boolean useElapsedDuration_ = false;
    /**
     *
     *
     * <pre>
     * True if
     * [Measurement.elapsed_duration][google.cloud.aiplatform.v1.Measurement.elapsed_duration]
     * is used as the x-axis of each Trials Decay Curve. Otherwise,
     * [Measurement.step_count][google.cloud.aiplatform.v1.Measurement.step_count]
     * will be used as the x-axis.
     * </pre>
     *
     * <code>bool use_elapsed_duration = 1;</code>
     *
     * @return The useElapsedDuration.
     */
    @java.lang.Override
    public boolean getUseElapsedDuration() {
      return useElapsedDuration_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (useElapsedDuration_ != false) {
        output.writeBool(1, useElapsedDuration_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (useElapsedDuration_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, useElapsedDuration_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec other =
          (com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec) obj;

      if (getUseElapsedDuration() != other.getUseElapsedDuration()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + USE_ELAPSED_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseElapsedDuration());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The decay curve automated stopping rule builds a Gaussian Process
     * Regressor to predict the final objective value of a Trial based on the
     * already completed Trials and the intermediate measurements of the current
     * Trial. Early stopping is requested for the current Trial if there is very
     * low probability to exceed the optimal value found so far.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec)
        com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_DecayCurveAutomatedStoppingSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_DecayCurveAutomatedStoppingSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec.class,
                com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        useElapsedDuration_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_DecayCurveAutomatedStoppingSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec build() {
        com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
          buildPartial() {
        com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec result =
            new com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.useElapsedDuration_ = useElapsedDuration_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
                .getDefaultInstance()) return this;
        if (other.getUseElapsedDuration() != false) {
          setUseElapsedDuration(other.getUseElapsedDuration());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  useElapsedDuration_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean useElapsedDuration_;
      /**
       *
       *
       * <pre>
       * True if
       * [Measurement.elapsed_duration][google.cloud.aiplatform.v1.Measurement.elapsed_duration]
       * is used as the x-axis of each Trials Decay Curve. Otherwise,
       * [Measurement.step_count][google.cloud.aiplatform.v1.Measurement.step_count]
       * will be used as the x-axis.
       * </pre>
       *
       * <code>bool use_elapsed_duration = 1;</code>
       *
       * @return The useElapsedDuration.
       */
      @java.lang.Override
      public boolean getUseElapsedDuration() {
        return useElapsedDuration_;
      }
      /**
       *
       *
       * <pre>
       * True if
       * [Measurement.elapsed_duration][google.cloud.aiplatform.v1.Measurement.elapsed_duration]
       * is used as the x-axis of each Trials Decay Curve. Otherwise,
       * [Measurement.step_count][google.cloud.aiplatform.v1.Measurement.step_count]
       * will be used as the x-axis.
       * </pre>
       *
       * <code>bool use_elapsed_duration = 1;</code>
       *
       * @param value The useElapsedDuration to set.
       * @return This builder for chaining.
       */
      public Builder setUseElapsedDuration(boolean value) {

        useElapsedDuration_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * True if
       * [Measurement.elapsed_duration][google.cloud.aiplatform.v1.Measurement.elapsed_duration]
       * is used as the x-axis of each Trials Decay Curve. Otherwise,
       * [Measurement.step_count][google.cloud.aiplatform.v1.Measurement.step_count]
       * will be used as the x-axis.
       * </pre>
       *
       * <code>bool use_elapsed_duration = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUseElapsedDuration() {
        bitField0_ = (bitField0_ & ~0x00000001);
        useElapsedDuration_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec)
    private static final com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec();
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DecayCurveAutomatedStoppingSpec> PARSER =
        new com.google.protobuf.AbstractParser<DecayCurveAutomatedStoppingSpec>() {
          @java.lang.Override
          public DecayCurveAutomatedStoppingSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DecayCurveAutomatedStoppingSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DecayCurveAutomatedStoppingSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface MedianAutomatedStoppingSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * True if median automated stopping rule applies on
     * [Measurement.elapsed_duration][google.cloud.aiplatform.v1.Measurement.elapsed_duration].
     * It means that elapsed_duration field of latest measurement of current
     * Trial is used to compute median objective value for each completed
     * Trials.
     * </pre>
     *
     * <code>bool use_elapsed_duration = 1;</code>
     *
     * @return The useElapsedDuration.
     */
    boolean getUseElapsedDuration();
  }
  /**
   *
   *
   * <pre>
   * The median automated stopping rule stops a pending Trial if the Trial's
   * best objective_value is strictly below the median 'performance' of all
   * completed Trials reported up to the Trial's last measurement.
   * Currently, 'performance' refers to the running average of the objective
   * values reported by the Trial in each measurement.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec}
   */
  public static final class MedianAutomatedStoppingSpec
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec)
      MedianAutomatedStoppingSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use MedianAutomatedStoppingSpec.newBuilder() to construct.
    private MedianAutomatedStoppingSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private MedianAutomatedStoppingSpec() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new MedianAutomatedStoppingSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_StudySpec_MedianAutomatedStoppingSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_StudySpec_MedianAutomatedStoppingSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec.class,
              com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec.Builder.class);
    }

    public static final int USE_ELAPSED_DURATION_FIELD_NUMBER = 1;
    private boolean useElapsedDuration_ = false;
    /**
     *
     *
     * <pre>
     * True if median automated stopping rule applies on
     * [Measurement.elapsed_duration][google.cloud.aiplatform.v1.Measurement.elapsed_duration].
     * It means that elapsed_duration field of latest measurement of current
     * Trial is used to compute median objective value for each completed
     * Trials.
     * </pre>
     *
     * <code>bool use_elapsed_duration = 1;</code>
     *
     * @return The useElapsedDuration.
     */
    @java.lang.Override
    public boolean getUseElapsedDuration() {
      return useElapsedDuration_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (useElapsedDuration_ != false) {
        output.writeBool(1, useElapsedDuration_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (useElapsedDuration_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(1, useElapsedDuration_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec other =
          (com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec) obj;

      if (getUseElapsedDuration() != other.getUseElapsedDuration()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + USE_ELAPSED_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseElapsedDuration());
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The median automated stopping rule stops a pending Trial if the Trial's
     * best objective_value is strictly below the median 'performance' of all
     * completed Trials reported up to the Trial's last measurement.
     * Currently, 'performance' refers to the running average of the objective
     * values reported by the Trial in each measurement.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec)
        com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_MedianAutomatedStoppingSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_MedianAutomatedStoppingSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec.class,
                com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        useElapsedDuration_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_MedianAutomatedStoppingSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec build() {
        com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec buildPartial() {
        com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec result =
            new com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.useElapsedDuration_ = useElapsedDuration_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
                .getDefaultInstance()) return this;
        if (other.getUseElapsedDuration() != false) {
          setUseElapsedDuration(other.getUseElapsedDuration());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  useElapsedDuration_ = input.readBool();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private boolean useElapsedDuration_;
      /**
       *
       *
       * <pre>
       * True if median automated stopping rule applies on
       * [Measurement.elapsed_duration][google.cloud.aiplatform.v1.Measurement.elapsed_duration].
       * It means that elapsed_duration field of latest measurement of current
       * Trial is used to compute median objective value for each completed
       * Trials.
       * </pre>
       *
       * <code>bool use_elapsed_duration = 1;</code>
       *
       * @return The useElapsedDuration.
       */
      @java.lang.Override
      public boolean getUseElapsedDuration() {
        return useElapsedDuration_;
      }
      /**
       *
       *
       * <pre>
       * True if median automated stopping rule applies on
       * [Measurement.elapsed_duration][google.cloud.aiplatform.v1.Measurement.elapsed_duration].
       * It means that elapsed_duration field of latest measurement of current
       * Trial is used to compute median objective value for each completed
       * Trials.
       * </pre>
       *
       * <code>bool use_elapsed_duration = 1;</code>
       *
       * @param value The useElapsedDuration to set.
       * @return This builder for chaining.
       */
      public Builder setUseElapsedDuration(boolean value) {

        useElapsedDuration_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * True if median automated stopping rule applies on
       * [Measurement.elapsed_duration][google.cloud.aiplatform.v1.Measurement.elapsed_duration].
       * It means that elapsed_duration field of latest measurement of current
       * Trial is used to compute median objective value for each completed
       * Trials.
       * </pre>
       *
       * <code>bool use_elapsed_duration = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUseElapsedDuration() {
        bitField0_ = (bitField0_ & ~0x00000001);
        useElapsedDuration_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec)
    private static final com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec();
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<MedianAutomatedStoppingSpec> PARSER =
        new com.google.protobuf.AbstractParser<MedianAutomatedStoppingSpec>() {
          @java.lang.Override
          public MedianAutomatedStoppingSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<MedianAutomatedStoppingSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<MedianAutomatedStoppingSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ConvexAutomatedStoppingSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Steps used in predicting the final objective for early stopped trials. In
     * general, it's set to be the same as the defined steps in training /
     * tuning. If not defined, it will learn it from the completed trials. When
     * use_steps is false, this field is set to the maximum elapsed seconds.
     * </pre>
     *
     * <code>int64 max_step_count = 1;</code>
     *
     * @return The maxStepCount.
     */
    long getMaxStepCount();

    /**
     *
     *
     * <pre>
     * Minimum number of steps for a trial to complete. Trials which do not have
     * a measurement with step_count &gt; min_step_count won't be considered for
     * early stopping. It's ok to set it to 0, and a trial can be early stopped
     * at any stage. By default, min_step_count is set to be one-tenth of the
     * max_step_count.
     * When use_elapsed_duration is true, this field is set to the minimum
     * elapsed seconds.
     * </pre>
     *
     * <code>int64 min_step_count = 2;</code>
     *
     * @return The minStepCount.
     */
    long getMinStepCount();

    /**
     *
     *
     * <pre>
     * The minimal number of measurements in a Trial.  Early-stopping checks
     * will not trigger if less than min_measurement_count+1 completed trials or
     * pending trials with less than min_measurement_count measurements. If not
     * defined, the default value is 5.
     * </pre>
     *
     * <code>int64 min_measurement_count = 3;</code>
     *
     * @return The minMeasurementCount.
     */
    long getMinMeasurementCount();

    /**
     *
     *
     * <pre>
     * The hyper-parameter name used in the tuning job that stands for learning
     * rate. Leave it blank if learning rate is not in a parameter in tuning.
     * The learning_rate is used to estimate the objective value of the ongoing
     * trial.
     * </pre>
     *
     * <code>string learning_rate_parameter_name = 4;</code>
     *
     * @return The learningRateParameterName.
     */
    java.lang.String getLearningRateParameterName();
    /**
     *
     *
     * <pre>
     * The hyper-parameter name used in the tuning job that stands for learning
     * rate. Leave it blank if learning rate is not in a parameter in tuning.
     * The learning_rate is used to estimate the objective value of the ongoing
     * trial.
     * </pre>
     *
     * <code>string learning_rate_parameter_name = 4;</code>
     *
     * @return The bytes for learningRateParameterName.
     */
    com.google.protobuf.ByteString getLearningRateParameterNameBytes();

    /**
     *
     *
     * <pre>
     * This bool determines whether or not the rule is applied based on
     * elapsed_secs or steps. If use_elapsed_duration==false, the early stopping
     * decision is made according to the predicted objective values according to
     * the target steps. If use_elapsed_duration==true, elapsed_secs is used
     * instead of steps. Also, in this case, the parameters max_num_steps and
     * min_num_steps are overloaded to contain max_elapsed_seconds and
     * min_elapsed_seconds.
     * </pre>
     *
     * <code>bool use_elapsed_duration = 5;</code>
     *
     * @return The useElapsedDuration.
     */
    boolean getUseElapsedDuration();

    /**
     *
     *
     * <pre>
     * ConvexAutomatedStoppingSpec by default only updates the trials that needs
     * to be early stopped using a newly trained auto-regressive model. When
     * this flag is set to True, all stopped trials from the beginning are
     * potentially updated in terms of their `final_measurement`. Also, note
     * that the training logic of autoregressive models is different in this
     * case. Enabling this option has shown better results and this may be the
     * default option in the future.
     * </pre>
     *
     * <code>optional bool update_all_stopped_trials = 6;</code>
     *
     * @return Whether the updateAllStoppedTrials field is set.
     */
    boolean hasUpdateAllStoppedTrials();
    /**
     *
     *
     * <pre>
     * ConvexAutomatedStoppingSpec by default only updates the trials that needs
     * to be early stopped using a newly trained auto-regressive model. When
     * this flag is set to True, all stopped trials from the beginning are
     * potentially updated in terms of their `final_measurement`. Also, note
     * that the training logic of autoregressive models is different in this
     * case. Enabling this option has shown better results and this may be the
     * default option in the future.
     * </pre>
     *
     * <code>optional bool update_all_stopped_trials = 6;</code>
     *
     * @return The updateAllStoppedTrials.
     */
    boolean getUpdateAllStoppedTrials();
  }
  /**
   *
   *
   * <pre>
   * Configuration for ConvexAutomatedStoppingSpec.
   * When there are enough completed trials (configured by
   * min_measurement_count), for pending trials with enough measurements and
   * steps, the policy first computes an overestimate of the objective value at
   * max_num_steps according to the slope of the incomplete objective value
   * curve. No prediction can be made if the curve is completely flat. If the
   * overestimation is worse than the best objective value of the completed
   * trials, this pending trial will be early-stopped, but a last measurement
   * will be added to the pending trial with max_num_steps and predicted
   * objective value from the autoregression model.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec}
   */
  public static final class ConvexAutomatedStoppingSpec
      extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec)
      ConvexAutomatedStoppingSpecOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use ConvexAutomatedStoppingSpec.newBuilder() to construct.
    private ConvexAutomatedStoppingSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ConvexAutomatedStoppingSpec() {
      learningRateParameterName_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ConvexAutomatedStoppingSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_StudySpec_ConvexAutomatedStoppingSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_StudySpec_ConvexAutomatedStoppingSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec.class,
              com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec.Builder.class);
    }

    private int bitField0_;
    public static final int MAX_STEP_COUNT_FIELD_NUMBER = 1;
    private long maxStepCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Steps used in predicting the final objective for early stopped trials. In
     * general, it's set to be the same as the defined steps in training /
     * tuning. If not defined, it will learn it from the completed trials. When
     * use_steps is false, this field is set to the maximum elapsed seconds.
     * </pre>
     *
     * <code>int64 max_step_count = 1;</code>
     *
     * @return The maxStepCount.
     */
    @java.lang.Override
    public long getMaxStepCount() {
      return maxStepCount_;
    }

    public static final int MIN_STEP_COUNT_FIELD_NUMBER = 2;
    private long minStepCount_ = 0L;
    /**
     *
     *
     * <pre>
     * Minimum number of steps for a trial to complete. Trials which do not have
     * a measurement with step_count &gt; min_step_count won't be considered for
     * early stopping. It's ok to set it to 0, and a trial can be early stopped
     * at any stage. By default, min_step_count is set to be one-tenth of the
     * max_step_count.
     * When use_elapsed_duration is true, this field is set to the minimum
     * elapsed seconds.
     * </pre>
     *
     * <code>int64 min_step_count = 2;</code>
     *
     * @return The minStepCount.
     */
    @java.lang.Override
    public long getMinStepCount() {
      return minStepCount_;
    }

    public static final int MIN_MEASUREMENT_COUNT_FIELD_NUMBER = 3;
    private long minMeasurementCount_ = 0L;
    /**
     *
     *
     * <pre>
     * The minimal number of measurements in a Trial.  Early-stopping checks
     * will not trigger if less than min_measurement_count+1 completed trials or
     * pending trials with less than min_measurement_count measurements. If not
     * defined, the default value is 5.
     * </pre>
     *
     * <code>int64 min_measurement_count = 3;</code>
     *
     * @return The minMeasurementCount.
     */
    @java.lang.Override
    public long getMinMeasurementCount() {
      return minMeasurementCount_;
    }

    public static final int LEARNING_RATE_PARAMETER_NAME_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object learningRateParameterName_ = "";
    /**
     *
     *
     * <pre>
     * The hyper-parameter name used in the tuning job that stands for learning
     * rate. Leave it blank if learning rate is not in a parameter in tuning.
     * The learning_rate is used to estimate the objective value of the ongoing
     * trial.
     * </pre>
     *
     * <code>string learning_rate_parameter_name = 4;</code>
     *
     * @return The learningRateParameterName.
     */
    @java.lang.Override
    public java.lang.String getLearningRateParameterName() {
      java.lang.Object ref = learningRateParameterName_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        learningRateParameterName_ = s;
        return s;
      }
    }
    /**
     *
     *
     * <pre>
     * The hyper-parameter name used in the tuning job that stands for learning
     * rate. Leave it blank if learning rate is not in a parameter in tuning.
     * The learning_rate is used to estimate the objective value of the ongoing
     * trial.
     * </pre>
     *
     * <code>string learning_rate_parameter_name = 4;</code>
     *
     * @return The bytes for learningRateParameterName.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLearningRateParameterNameBytes() {
      java.lang.Object ref = learningRateParameterName_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        learningRateParameterName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int USE_ELAPSED_DURATION_FIELD_NUMBER = 5;
    private boolean useElapsedDuration_ = false;
    /**
     *
     *
     * <pre>
     * This bool determines whether or not the rule is applied based on
     * elapsed_secs or steps. If use_elapsed_duration==false, the early stopping
     * decision is made according to the predicted objective values according to
     * the target steps. If use_elapsed_duration==true, elapsed_secs is used
     * instead of steps. Also, in this case, the parameters max_num_steps and
     * min_num_steps are overloaded to contain max_elapsed_seconds and
     * min_elapsed_seconds.
     * </pre>
     *
     * <code>bool use_elapsed_duration = 5;</code>
     *
     * @return The useElapsedDuration.
     */
    @java.lang.Override
    public boolean getUseElapsedDuration() {
      return useElapsedDuration_;
    }

    public static final int UPDATE_ALL_STOPPED_TRIALS_FIELD_NUMBER = 6;
    private boolean updateAllStoppedTrials_ = false;
    /**
     *
     *
     * <pre>
     * ConvexAutomatedStoppingSpec by default only updates the trials that needs
     * to be early stopped using a newly trained auto-regressive model. When
     * this flag is set to True, all stopped trials from the beginning are
     * potentially updated in terms of their `final_measurement`. Also, note
     * that the training logic of autoregressive models is different in this
     * case. Enabling this option has shown better results and this may be the
     * default option in the future.
     * </pre>
     *
     * <code>optional bool update_all_stopped_trials = 6;</code>
     *
     * @return Whether the updateAllStoppedTrials field is set.
     */
    @java.lang.Override
    public boolean hasUpdateAllStoppedTrials() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * ConvexAutomatedStoppingSpec by default only updates the trials that needs
     * to be early stopped using a newly trained auto-regressive model. When
     * this flag is set to True, all stopped trials from the beginning are
     * potentially updated in terms of their `final_measurement`. Also, note
     * that the training logic of autoregressive models is different in this
     * case. Enabling this option has shown better results and this may be the
     * default option in the future.
     * </pre>
     *
     * <code>optional bool update_all_stopped_trials = 6;</code>
     *
     * @return The updateAllStoppedTrials.
     */
    @java.lang.Override
    public boolean getUpdateAllStoppedTrials() {
      return updateAllStoppedTrials_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (maxStepCount_ != 0L) {
        output.writeInt64(1, maxStepCount_);
      }
      if (minStepCount_ != 0L) {
        output.writeInt64(2, minStepCount_);
      }
      if (minMeasurementCount_ != 0L) {
        output.writeInt64(3, minMeasurementCount_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(learningRateParameterName_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, learningRateParameterName_);
      }
      if (useElapsedDuration_ != false) {
        output.writeBool(5, useElapsedDuration_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeBool(6, updateAllStoppedTrials_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (maxStepCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(1, maxStepCount_);
      }
      if (minStepCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(2, minStepCount_);
      }
      if (minMeasurementCount_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(3, minMeasurementCount_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(learningRateParameterName_)) {
        size +=
            com.google.protobuf.GeneratedMessageV3.computeStringSize(4, learningRateParameterName_);
      }
      if (useElapsedDuration_ != false) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, useElapsedDuration_);
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, updateAllStoppedTrials_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec other =
          (com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec) obj;

      if (getMaxStepCount() != other.getMaxStepCount()) return false;
      if (getMinStepCount() != other.getMinStepCount()) return false;
      if (getMinMeasurementCount() != other.getMinMeasurementCount()) return false;
      if (!getLearningRateParameterName().equals(other.getLearningRateParameterName()))
        return false;
      if (getUseElapsedDuration() != other.getUseElapsedDuration()) return false;
      if (hasUpdateAllStoppedTrials() != other.hasUpdateAllStoppedTrials()) return false;
      if (hasUpdateAllStoppedTrials()) {
        if (getUpdateAllStoppedTrials() != other.getUpdateAllStoppedTrials()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + MAX_STEP_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxStepCount());
      hash = (37 * hash) + MIN_STEP_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMinStepCount());
      hash = (37 * hash) + MIN_MEASUREMENT_COUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMinMeasurementCount());
      hash = (37 * hash) + LEARNING_RATE_PARAMETER_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getLearningRateParameterName().hashCode();
      hash = (37 * hash) + USE_ELAPSED_DURATION_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUseElapsedDuration());
      if (hasUpdateAllStoppedTrials()) {
        hash = (37 * hash) + UPDATE_ALL_STOPPED_TRIALS_FIELD_NUMBER;
        hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getUpdateAllStoppedTrials());
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Configuration for ConvexAutomatedStoppingSpec.
     * When there are enough completed trials (configured by
     * min_measurement_count), for pending trials with enough measurements and
     * steps, the policy first computes an overestimate of the objective value at
     * max_num_steps according to the slope of the incomplete objective value
     * curve. No prediction can be made if the curve is completely flat. If the
     * overestimation is worse than the best objective value of the completed
     * trials, this pending trial will be early-stopped, but a last measurement
     * will be added to the pending trial with max_num_steps and predicted
     * objective value from the autoregression model.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec)
        com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_ConvexAutomatedStoppingSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_ConvexAutomatedStoppingSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec.class,
                com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        maxStepCount_ = 0L;
        minStepCount_ = 0L;
        minMeasurementCount_ = 0L;
        learningRateParameterName_ = "";
        useElapsedDuration_ = false;
        updateAllStoppedTrials_ = false;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_ConvexAutomatedStoppingSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec build() {
        com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec buildPartial() {
        com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec result =
            new com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.maxStepCount_ = maxStepCount_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.minStepCount_ = minStepCount_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.minMeasurementCount_ = minMeasurementCount_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.learningRateParameterName_ = learningRateParameterName_;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.useElapsedDuration_ = useElapsedDuration_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.updateAllStoppedTrials_ = updateAllStoppedTrials_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
                .getDefaultInstance()) return this;
        if (other.getMaxStepCount() != 0L) {
          setMaxStepCount(other.getMaxStepCount());
        }
        if (other.getMinStepCount() != 0L) {
          setMinStepCount(other.getMinStepCount());
        }
        if (other.getMinMeasurementCount() != 0L) {
          setMinMeasurementCount(other.getMinMeasurementCount());
        }
        if (!other.getLearningRateParameterName().isEmpty()) {
          learningRateParameterName_ = other.learningRateParameterName_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (other.getUseElapsedDuration() != false) {
          setUseElapsedDuration(other.getUseElapsedDuration());
        }
        if (other.hasUpdateAllStoppedTrials()) {
          setUpdateAllStoppedTrials(other.getUpdateAllStoppedTrials());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  maxStepCount_ = input.readInt64();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 16:
                {
                  minStepCount_ = input.readInt64();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              case 24:
                {
                  minMeasurementCount_ = input.readInt64();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 24
              case 34:
                {
                  learningRateParameterName_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 40:
                {
                  useElapsedDuration_ = input.readBool();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              case 48:
                {
                  updateAllStoppedTrials_ = input.readBool();
                  bitField0_ |= 0x00000020;
                  break;
                } // case 48
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private long maxStepCount_;
      /**
       *
       *
       * <pre>
       * Steps used in predicting the final objective for early stopped trials. In
       * general, it's set to be the same as the defined steps in training /
       * tuning. If not defined, it will learn it from the completed trials. When
       * use_steps is false, this field is set to the maximum elapsed seconds.
       * </pre>
       *
       * <code>int64 max_step_count = 1;</code>
       *
       * @return The maxStepCount.
       */
      @java.lang.Override
      public long getMaxStepCount() {
        return maxStepCount_;
      }
      /**
       *
       *
       * <pre>
       * Steps used in predicting the final objective for early stopped trials. In
       * general, it's set to be the same as the defined steps in training /
       * tuning. If not defined, it will learn it from the completed trials. When
       * use_steps is false, this field is set to the maximum elapsed seconds.
       * </pre>
       *
       * <code>int64 max_step_count = 1;</code>
       *
       * @param value The maxStepCount to set.
       * @return This builder for chaining.
       */
      public Builder setMaxStepCount(long value) {

        maxStepCount_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Steps used in predicting the final objective for early stopped trials. In
       * general, it's set to be the same as the defined steps in training /
       * tuning. If not defined, it will learn it from the completed trials. When
       * use_steps is false, this field is set to the maximum elapsed seconds.
       * </pre>
       *
       * <code>int64 max_step_count = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxStepCount() {
        bitField0_ = (bitField0_ & ~0x00000001);
        maxStepCount_ = 0L;
        onChanged();
        return this;
      }

      private long minStepCount_;
      /**
       *
       *
       * <pre>
       * Minimum number of steps for a trial to complete. Trials which do not have
       * a measurement with step_count &gt; min_step_count won't be considered for
       * early stopping. It's ok to set it to 0, and a trial can be early stopped
       * at any stage. By default, min_step_count is set to be one-tenth of the
       * max_step_count.
       * When use_elapsed_duration is true, this field is set to the minimum
       * elapsed seconds.
       * </pre>
       *
       * <code>int64 min_step_count = 2;</code>
       *
       * @return The minStepCount.
       */
      @java.lang.Override
      public long getMinStepCount() {
        return minStepCount_;
      }
      /**
       *
       *
       * <pre>
       * Minimum number of steps for a trial to complete. Trials which do not have
       * a measurement with step_count &gt; min_step_count won't be considered for
       * early stopping. It's ok to set it to 0, and a trial can be early stopped
       * at any stage. By default, min_step_count is set to be one-tenth of the
       * max_step_count.
       * When use_elapsed_duration is true, this field is set to the minimum
       * elapsed seconds.
       * </pre>
       *
       * <code>int64 min_step_count = 2;</code>
       *
       * @param value The minStepCount to set.
       * @return This builder for chaining.
       */
      public Builder setMinStepCount(long value) {

        minStepCount_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Minimum number of steps for a trial to complete. Trials which do not have
       * a measurement with step_count &gt; min_step_count won't be considered for
       * early stopping. It's ok to set it to 0, and a trial can be early stopped
       * at any stage. By default, min_step_count is set to be one-tenth of the
       * max_step_count.
       * When use_elapsed_duration is true, this field is set to the minimum
       * elapsed seconds.
       * </pre>
       *
       * <code>int64 min_step_count = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinStepCount() {
        bitField0_ = (bitField0_ & ~0x00000002);
        minStepCount_ = 0L;
        onChanged();
        return this;
      }

      private long minMeasurementCount_;
      /**
       *
       *
       * <pre>
       * The minimal number of measurements in a Trial.  Early-stopping checks
       * will not trigger if less than min_measurement_count+1 completed trials or
       * pending trials with less than min_measurement_count measurements. If not
       * defined, the default value is 5.
       * </pre>
       *
       * <code>int64 min_measurement_count = 3;</code>
       *
       * @return The minMeasurementCount.
       */
      @java.lang.Override
      public long getMinMeasurementCount() {
        return minMeasurementCount_;
      }
      /**
       *
       *
       * <pre>
       * The minimal number of measurements in a Trial.  Early-stopping checks
       * will not trigger if less than min_measurement_count+1 completed trials or
       * pending trials with less than min_measurement_count measurements. If not
       * defined, the default value is 5.
       * </pre>
       *
       * <code>int64 min_measurement_count = 3;</code>
       *
       * @param value The minMeasurementCount to set.
       * @return This builder for chaining.
       */
      public Builder setMinMeasurementCount(long value) {

        minMeasurementCount_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The minimal number of measurements in a Trial.  Early-stopping checks
       * will not trigger if less than min_measurement_count+1 completed trials or
       * pending trials with less than min_measurement_count measurements. If not
       * defined, the default value is 5.
       * </pre>
       *
       * <code>int64 min_measurement_count = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinMeasurementCount() {
        bitField0_ = (bitField0_ & ~0x00000004);
        minMeasurementCount_ = 0L;
        onChanged();
        return this;
      }

      private java.lang.Object learningRateParameterName_ = "";
      /**
       *
       *
       * <pre>
       * The hyper-parameter name used in the tuning job that stands for learning
       * rate. Leave it blank if learning rate is not in a parameter in tuning.
       * The learning_rate is used to estimate the objective value of the ongoing
       * trial.
       * </pre>
       *
       * <code>string learning_rate_parameter_name = 4;</code>
       *
       * @return The learningRateParameterName.
       */
      public java.lang.String getLearningRateParameterName() {
        java.lang.Object ref = learningRateParameterName_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          learningRateParameterName_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The hyper-parameter name used in the tuning job that stands for learning
       * rate. Leave it blank if learning rate is not in a parameter in tuning.
       * The learning_rate is used to estimate the objective value of the ongoing
       * trial.
       * </pre>
       *
       * <code>string learning_rate_parameter_name = 4;</code>
       *
       * @return The bytes for learningRateParameterName.
       */
      public com.google.protobuf.ByteString getLearningRateParameterNameBytes() {
        java.lang.Object ref = learningRateParameterName_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          learningRateParameterName_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }
      /**
       *
       *
       * <pre>
       * The hyper-parameter name used in the tuning job that stands for learning
       * rate. Leave it blank if learning rate is not in a parameter in tuning.
       * The learning_rate is used to estimate the objective value of the ongoing
       * trial.
       * </pre>
       *
       * <code>string learning_rate_parameter_name = 4;</code>
       *
       * @param value The learningRateParameterName to set.
       * @return This builder for chaining.
       */
      public Builder setLearningRateParameterName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        learningRateParameterName_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The hyper-parameter name used in the tuning job that stands for learning
       * rate. Leave it blank if learning rate is not in a parameter in tuning.
       * The learning_rate is used to estimate the objective value of the ongoing
       * trial.
       * </pre>
       *
       * <code>string learning_rate_parameter_name = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLearningRateParameterName() {
        learningRateParameterName_ = getDefaultInstance().getLearningRateParameterName();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The hyper-parameter name used in the tuning job that stands for learning
       * rate. Leave it blank if learning rate is not in a parameter in tuning.
       * The learning_rate is used to estimate the objective value of the ongoing
       * trial.
       * </pre>
       *
       * <code>string learning_rate_parameter_name = 4;</code>
       *
       * @param value The bytes for learningRateParameterName to set.
       * @return This builder for chaining.
       */
      public Builder setLearningRateParameterNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        learningRateParameterName_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private boolean useElapsedDuration_;
      /**
       *
       *
       * <pre>
       * This bool determines whether or not the rule is applied based on
       * elapsed_secs or steps. If use_elapsed_duration==false, the early stopping
       * decision is made according to the predicted objective values according to
       * the target steps. If use_elapsed_duration==true, elapsed_secs is used
       * instead of steps. Also, in this case, the parameters max_num_steps and
       * min_num_steps are overloaded to contain max_elapsed_seconds and
       * min_elapsed_seconds.
       * </pre>
       *
       * <code>bool use_elapsed_duration = 5;</code>
       *
       * @return The useElapsedDuration.
       */
      @java.lang.Override
      public boolean getUseElapsedDuration() {
        return useElapsedDuration_;
      }
      /**
       *
       *
       * <pre>
       * This bool determines whether or not the rule is applied based on
       * elapsed_secs or steps. If use_elapsed_duration==false, the early stopping
       * decision is made according to the predicted objective values according to
       * the target steps. If use_elapsed_duration==true, elapsed_secs is used
       * instead of steps. Also, in this case, the parameters max_num_steps and
       * min_num_steps are overloaded to contain max_elapsed_seconds and
       * min_elapsed_seconds.
       * </pre>
       *
       * <code>bool use_elapsed_duration = 5;</code>
       *
       * @param value The useElapsedDuration to set.
       * @return This builder for chaining.
       */
      public Builder setUseElapsedDuration(boolean value) {

        useElapsedDuration_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * This bool determines whether or not the rule is applied based on
       * elapsed_secs or steps. If use_elapsed_duration==false, the early stopping
       * decision is made according to the predicted objective values according to
       * the target steps. If use_elapsed_duration==true, elapsed_secs is used
       * instead of steps. Also, in this case, the parameters max_num_steps and
       * min_num_steps are overloaded to contain max_elapsed_seconds and
       * min_elapsed_seconds.
       * </pre>
       *
       * <code>bool use_elapsed_duration = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUseElapsedDuration() {
        bitField0_ = (bitField0_ & ~0x00000010);
        useElapsedDuration_ = false;
        onChanged();
        return this;
      }

      private boolean updateAllStoppedTrials_;
      /**
       *
       *
       * <pre>
       * ConvexAutomatedStoppingSpec by default only updates the trials that needs
       * to be early stopped using a newly trained auto-regressive model. When
       * this flag is set to True, all stopped trials from the beginning are
       * potentially updated in terms of their `final_measurement`. Also, note
       * that the training logic of autoregressive models is different in this
       * case. Enabling this option has shown better results and this may be the
       * default option in the future.
       * </pre>
       *
       * <code>optional bool update_all_stopped_trials = 6;</code>
       *
       * @return Whether the updateAllStoppedTrials field is set.
       */
      @java.lang.Override
      public boolean hasUpdateAllStoppedTrials() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * ConvexAutomatedStoppingSpec by default only updates the trials that needs
       * to be early stopped using a newly trained auto-regressive model. When
       * this flag is set to True, all stopped trials from the beginning are
       * potentially updated in terms of their `final_measurement`. Also, note
       * that the training logic of autoregressive models is different in this
       * case. Enabling this option has shown better results and this may be the
       * default option in the future.
       * </pre>
       *
       * <code>optional bool update_all_stopped_trials = 6;</code>
       *
       * @return The updateAllStoppedTrials.
       */
      @java.lang.Override
      public boolean getUpdateAllStoppedTrials() {
        return updateAllStoppedTrials_;
      }
      /**
       *
       *
       * <pre>
       * ConvexAutomatedStoppingSpec by default only updates the trials that needs
       * to be early stopped using a newly trained auto-regressive model. When
       * this flag is set to True, all stopped trials from the beginning are
       * potentially updated in terms of their `final_measurement`. Also, note
       * that the training logic of autoregressive models is different in this
       * case. Enabling this option has shown better results and this may be the
       * default option in the future.
       * </pre>
       *
       * <code>optional bool update_all_stopped_trials = 6;</code>
       *
       * @param value The updateAllStoppedTrials to set.
       * @return This builder for chaining.
       */
      public Builder setUpdateAllStoppedTrials(boolean value) {

        updateAllStoppedTrials_ = value;
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * ConvexAutomatedStoppingSpec by default only updates the trials that needs
       * to be early stopped using a newly trained auto-regressive model. When
       * this flag is set to True, all stopped trials from the beginning are
       * potentially updated in terms of their `final_measurement`. Also, note
       * that the training logic of autoregressive models is different in this
       * case. Enabling this option has shown better results and this may be the
       * default option in the future.
       * </pre>
       *
       * <code>optional bool update_all_stopped_trials = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearUpdateAllStoppedTrials() {
        bitField0_ = (bitField0_ & ~0x00000020);
        updateAllStoppedTrials_ = false;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec)
    private static final com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec();
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ConvexAutomatedStoppingSpec> PARSER =
        new com.google.protobuf.AbstractParser<ConvexAutomatedStoppingSpec>() {
          @java.lang.Override
          public ConvexAutomatedStoppingSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ConvexAutomatedStoppingSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ConvexAutomatedStoppingSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StudyStoppingConfigOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * If true, a Study enters STOPPING_ASAP whenever it would normally enters
     * STOPPING state.
     *
     * The bottom line is: set to true if you want to interrupt on-going
     * evaluations of Trials as soon as the study stopping condition is met.
     * (Please see Study.State documentation for the source of truth).
     * </pre>
     *
     * <code>.google.protobuf.BoolValue should_stop_asap = 1;</code>
     *
     * @return Whether the shouldStopAsap field is set.
     */
    boolean hasShouldStopAsap();
    /**
     *
     *
     * <pre>
     * If true, a Study enters STOPPING_ASAP whenever it would normally enters
     * STOPPING state.
     *
     * The bottom line is: set to true if you want to interrupt on-going
     * evaluations of Trials as soon as the study stopping condition is met.
     * (Please see Study.State documentation for the source of truth).
     * </pre>
     *
     * <code>.google.protobuf.BoolValue should_stop_asap = 1;</code>
     *
     * @return The shouldStopAsap.
     */
    com.google.protobuf.BoolValue getShouldStopAsap();
    /**
     *
     *
     * <pre>
     * If true, a Study enters STOPPING_ASAP whenever it would normally enters
     * STOPPING state.
     *
     * The bottom line is: set to true if you want to interrupt on-going
     * evaluations of Trials as soon as the study stopping condition is met.
     * (Please see Study.State documentation for the source of truth).
     * </pre>
     *
     * <code>.google.protobuf.BoolValue should_stop_asap = 1;</code>
     */
    com.google.protobuf.BoolValueOrBuilder getShouldStopAsapOrBuilder();

    /**
     *
     *
     * <pre>
     * Each "stopping rule" in this proto specifies an "if" condition. Before
     * Vizier would generate a new suggestion, it first checks each specified
     * stopping rule, from top to bottom in this list.
     * Note that the first few rules (e.g. minimum_runtime_constraint,
     * min_num_trials) will prevent other stopping rules from being evaluated
     * until they are met. For example, setting `min_num_trials=5` and
     * `always_stop_after= 1 hour` means that the Study will ONLY stop after it
     * has 5 COMPLETED trials, even if more than an hour has passed since its
     * creation. It follows the first applicable rule (whose "if" condition is
     * satisfied) to make a stopping decision. If none of the specified rules
     * are applicable, then Vizier decides that the study should not stop.
     * If Vizier decides that the study should stop, the study enters
     * STOPPING state (or STOPPING_ASAP if should_stop_asap = true).
     * IMPORTANT: The automatic study state transition happens precisely as
     * described above; that is, deleting trials or updating StudyConfig NEVER
     * automatically moves the study state back to ACTIVE. If you want to
     * _resume_ a Study that was stopped, 1) change the stopping conditions if
     * necessary, 2) activate the study, and then 3) ask for suggestions.
     * If the specified time or duration has not passed, do not stop the
     * study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint minimum_runtime_constraint = 2;</code>
     *
     * @return Whether the minimumRuntimeConstraint field is set.
     */
    boolean hasMinimumRuntimeConstraint();
    /**
     *
     *
     * <pre>
     * Each "stopping rule" in this proto specifies an "if" condition. Before
     * Vizier would generate a new suggestion, it first checks each specified
     * stopping rule, from top to bottom in this list.
     * Note that the first few rules (e.g. minimum_runtime_constraint,
     * min_num_trials) will prevent other stopping rules from being evaluated
     * until they are met. For example, setting `min_num_trials=5` and
     * `always_stop_after= 1 hour` means that the Study will ONLY stop after it
     * has 5 COMPLETED trials, even if more than an hour has passed since its
     * creation. It follows the first applicable rule (whose "if" condition is
     * satisfied) to make a stopping decision. If none of the specified rules
     * are applicable, then Vizier decides that the study should not stop.
     * If Vizier decides that the study should stop, the study enters
     * STOPPING state (or STOPPING_ASAP if should_stop_asap = true).
     * IMPORTANT: The automatic study state transition happens precisely as
     * described above; that is, deleting trials or updating StudyConfig NEVER
     * automatically moves the study state back to ACTIVE. If you want to
     * _resume_ a Study that was stopped, 1) change the stopping conditions if
     * necessary, 2) activate the study, and then 3) ask for suggestions.
     * If the specified time or duration has not passed, do not stop the
     * study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint minimum_runtime_constraint = 2;</code>
     *
     * @return The minimumRuntimeConstraint.
     */
    com.google.cloud.aiplatform.v1.StudyTimeConstraint getMinimumRuntimeConstraint();
    /**
     *
     *
     * <pre>
     * Each "stopping rule" in this proto specifies an "if" condition. Before
     * Vizier would generate a new suggestion, it first checks each specified
     * stopping rule, from top to bottom in this list.
     * Note that the first few rules (e.g. minimum_runtime_constraint,
     * min_num_trials) will prevent other stopping rules from being evaluated
     * until they are met. For example, setting `min_num_trials=5` and
     * `always_stop_after= 1 hour` means that the Study will ONLY stop after it
     * has 5 COMPLETED trials, even if more than an hour has passed since its
     * creation. It follows the first applicable rule (whose "if" condition is
     * satisfied) to make a stopping decision. If none of the specified rules
     * are applicable, then Vizier decides that the study should not stop.
     * If Vizier decides that the study should stop, the study enters
     * STOPPING state (or STOPPING_ASAP if should_stop_asap = true).
     * IMPORTANT: The automatic study state transition happens precisely as
     * described above; that is, deleting trials or updating StudyConfig NEVER
     * automatically moves the study state back to ACTIVE. If you want to
     * _resume_ a Study that was stopped, 1) change the stopping conditions if
     * necessary, 2) activate the study, and then 3) ask for suggestions.
     * If the specified time or duration has not passed, do not stop the
     * study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint minimum_runtime_constraint = 2;</code>
     */
    com.google.cloud.aiplatform.v1.StudyTimeConstraintOrBuilder
        getMinimumRuntimeConstraintOrBuilder();

    /**
     *
     *
     * <pre>
     * If the specified time or duration has passed, stop the study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint maximum_runtime_constraint = 3;</code>
     *
     * @return Whether the maximumRuntimeConstraint field is set.
     */
    boolean hasMaximumRuntimeConstraint();
    /**
     *
     *
     * <pre>
     * If the specified time or duration has passed, stop the study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint maximum_runtime_constraint = 3;</code>
     *
     * @return The maximumRuntimeConstraint.
     */
    com.google.cloud.aiplatform.v1.StudyTimeConstraint getMaximumRuntimeConstraint();
    /**
     *
     *
     * <pre>
     * If the specified time or duration has passed, stop the study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint maximum_runtime_constraint = 3;</code>
     */
    com.google.cloud.aiplatform.v1.StudyTimeConstraintOrBuilder
        getMaximumRuntimeConstraintOrBuilder();

    /**
     *
     *
     * <pre>
     * If there are fewer than this many COMPLETED trials, do not stop the
     * study.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value min_num_trials = 4;</code>
     *
     * @return Whether the minNumTrials field is set.
     */
    boolean hasMinNumTrials();
    /**
     *
     *
     * <pre>
     * If there are fewer than this many COMPLETED trials, do not stop the
     * study.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value min_num_trials = 4;</code>
     *
     * @return The minNumTrials.
     */
    com.google.protobuf.Int32Value getMinNumTrials();
    /**
     *
     *
     * <pre>
     * If there are fewer than this many COMPLETED trials, do not stop the
     * study.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value min_num_trials = 4;</code>
     */
    com.google.protobuf.Int32ValueOrBuilder getMinNumTrialsOrBuilder();

    /**
     *
     *
     * <pre>
     * If there are more than this many trials, stop the study.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value max_num_trials = 5;</code>
     *
     * @return Whether the maxNumTrials field is set.
     */
    boolean hasMaxNumTrials();
    /**
     *
     *
     * <pre>
     * If there are more than this many trials, stop the study.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value max_num_trials = 5;</code>
     *
     * @return The maxNumTrials.
     */
    com.google.protobuf.Int32Value getMaxNumTrials();
    /**
     *
     *
     * <pre>
     * If there are more than this many trials, stop the study.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value max_num_trials = 5;</code>
     */
    com.google.protobuf.Int32ValueOrBuilder getMaxNumTrialsOrBuilder();

    /**
     *
     *
     * <pre>
     * If the objective value has not improved for this many consecutive
     * trials, stop the study.
     *
     * WARNING: Effective only for single-objective studies.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value max_num_trials_no_progress = 6;</code>
     *
     * @return Whether the maxNumTrialsNoProgress field is set.
     */
    boolean hasMaxNumTrialsNoProgress();
    /**
     *
     *
     * <pre>
     * If the objective value has not improved for this many consecutive
     * trials, stop the study.
     *
     * WARNING: Effective only for single-objective studies.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value max_num_trials_no_progress = 6;</code>
     *
     * @return The maxNumTrialsNoProgress.
     */
    com.google.protobuf.Int32Value getMaxNumTrialsNoProgress();
    /**
     *
     *
     * <pre>
     * If the objective value has not improved for this many consecutive
     * trials, stop the study.
     *
     * WARNING: Effective only for single-objective studies.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value max_num_trials_no_progress = 6;</code>
     */
    com.google.protobuf.Int32ValueOrBuilder getMaxNumTrialsNoProgressOrBuilder();

    /**
     *
     *
     * <pre>
     * If the objective value has not improved for this much time, stop the
     * study.
     *
     * WARNING: Effective only for single-objective studies.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration_no_progress = 7;</code>
     *
     * @return Whether the maxDurationNoProgress field is set.
     */
    boolean hasMaxDurationNoProgress();
    /**
     *
     *
     * <pre>
     * If the objective value has not improved for this much time, stop the
     * study.
     *
     * WARNING: Effective only for single-objective studies.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration_no_progress = 7;</code>
     *
     * @return The maxDurationNoProgress.
     */
    com.google.protobuf.Duration getMaxDurationNoProgress();
    /**
     *
     *
     * <pre>
     * If the objective value has not improved for this much time, stop the
     * study.
     *
     * WARNING: Effective only for single-objective studies.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration_no_progress = 7;</code>
     */
    com.google.protobuf.DurationOrBuilder getMaxDurationNoProgressOrBuilder();
  }
  /**
   *
   *
   * <pre>
   * The configuration (stopping conditions) for automated stopping of a Study.
   * Conditions include trial budgets, time budgets, and convergence detection.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig}
   */
  public static final class StudyStoppingConfig extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig)
      StudyStoppingConfigOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use StudyStoppingConfig.newBuilder() to construct.
    private StudyStoppingConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StudyStoppingConfig() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new StudyStoppingConfig();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_StudySpec_StudyStoppingConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_StudySpec_StudyStoppingConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig.class,
              com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig.Builder.class);
    }

    public static final int SHOULD_STOP_ASAP_FIELD_NUMBER = 1;
    private com.google.protobuf.BoolValue shouldStopAsap_;
    /**
     *
     *
     * <pre>
     * If true, a Study enters STOPPING_ASAP whenever it would normally enters
     * STOPPING state.
     *
     * The bottom line is: set to true if you want to interrupt on-going
     * evaluations of Trials as soon as the study stopping condition is met.
     * (Please see Study.State documentation for the source of truth).
     * </pre>
     *
     * <code>.google.protobuf.BoolValue should_stop_asap = 1;</code>
     *
     * @return Whether the shouldStopAsap field is set.
     */
    @java.lang.Override
    public boolean hasShouldStopAsap() {
      return shouldStopAsap_ != null;
    }
    /**
     *
     *
     * <pre>
     * If true, a Study enters STOPPING_ASAP whenever it would normally enters
     * STOPPING state.
     *
     * The bottom line is: set to true if you want to interrupt on-going
     * evaluations of Trials as soon as the study stopping condition is met.
     * (Please see Study.State documentation for the source of truth).
     * </pre>
     *
     * <code>.google.protobuf.BoolValue should_stop_asap = 1;</code>
     *
     * @return The shouldStopAsap.
     */
    @java.lang.Override
    public com.google.protobuf.BoolValue getShouldStopAsap() {
      return shouldStopAsap_ == null
          ? com.google.protobuf.BoolValue.getDefaultInstance()
          : shouldStopAsap_;
    }
    /**
     *
     *
     * <pre>
     * If true, a Study enters STOPPING_ASAP whenever it would normally enters
     * STOPPING state.
     *
     * The bottom line is: set to true if you want to interrupt on-going
     * evaluations of Trials as soon as the study stopping condition is met.
     * (Please see Study.State documentation for the source of truth).
     * </pre>
     *
     * <code>.google.protobuf.BoolValue should_stop_asap = 1;</code>
     */
    @java.lang.Override
    public com.google.protobuf.BoolValueOrBuilder getShouldStopAsapOrBuilder() {
      return shouldStopAsap_ == null
          ? com.google.protobuf.BoolValue.getDefaultInstance()
          : shouldStopAsap_;
    }

    public static final int MINIMUM_RUNTIME_CONSTRAINT_FIELD_NUMBER = 2;
    private com.google.cloud.aiplatform.v1.StudyTimeConstraint minimumRuntimeConstraint_;
    /**
     *
     *
     * <pre>
     * Each "stopping rule" in this proto specifies an "if" condition. Before
     * Vizier would generate a new suggestion, it first checks each specified
     * stopping rule, from top to bottom in this list.
     * Note that the first few rules (e.g. minimum_runtime_constraint,
     * min_num_trials) will prevent other stopping rules from being evaluated
     * until they are met. For example, setting `min_num_trials=5` and
     * `always_stop_after= 1 hour` means that the Study will ONLY stop after it
     * has 5 COMPLETED trials, even if more than an hour has passed since its
     * creation. It follows the first applicable rule (whose "if" condition is
     * satisfied) to make a stopping decision. If none of the specified rules
     * are applicable, then Vizier decides that the study should not stop.
     * If Vizier decides that the study should stop, the study enters
     * STOPPING state (or STOPPING_ASAP if should_stop_asap = true).
     * IMPORTANT: The automatic study state transition happens precisely as
     * described above; that is, deleting trials or updating StudyConfig NEVER
     * automatically moves the study state back to ACTIVE. If you want to
     * _resume_ a Study that was stopped, 1) change the stopping conditions if
     * necessary, 2) activate the study, and then 3) ask for suggestions.
     * If the specified time or duration has not passed, do not stop the
     * study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint minimum_runtime_constraint = 2;</code>
     *
     * @return Whether the minimumRuntimeConstraint field is set.
     */
    @java.lang.Override
    public boolean hasMinimumRuntimeConstraint() {
      return minimumRuntimeConstraint_ != null;
    }
    /**
     *
     *
     * <pre>
     * Each "stopping rule" in this proto specifies an "if" condition. Before
     * Vizier would generate a new suggestion, it first checks each specified
     * stopping rule, from top to bottom in this list.
     * Note that the first few rules (e.g. minimum_runtime_constraint,
     * min_num_trials) will prevent other stopping rules from being evaluated
     * until they are met. For example, setting `min_num_trials=5` and
     * `always_stop_after= 1 hour` means that the Study will ONLY stop after it
     * has 5 COMPLETED trials, even if more than an hour has passed since its
     * creation. It follows the first applicable rule (whose "if" condition is
     * satisfied) to make a stopping decision. If none of the specified rules
     * are applicable, then Vizier decides that the study should not stop.
     * If Vizier decides that the study should stop, the study enters
     * STOPPING state (or STOPPING_ASAP if should_stop_asap = true).
     * IMPORTANT: The automatic study state transition happens precisely as
     * described above; that is, deleting trials or updating StudyConfig NEVER
     * automatically moves the study state back to ACTIVE. If you want to
     * _resume_ a Study that was stopped, 1) change the stopping conditions if
     * necessary, 2) activate the study, and then 3) ask for suggestions.
     * If the specified time or duration has not passed, do not stop the
     * study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint minimum_runtime_constraint = 2;</code>
     *
     * @return The minimumRuntimeConstraint.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudyTimeConstraint getMinimumRuntimeConstraint() {
      return minimumRuntimeConstraint_ == null
          ? com.google.cloud.aiplatform.v1.StudyTimeConstraint.getDefaultInstance()
          : minimumRuntimeConstraint_;
    }
    /**
     *
     *
     * <pre>
     * Each "stopping rule" in this proto specifies an "if" condition. Before
     * Vizier would generate a new suggestion, it first checks each specified
     * stopping rule, from top to bottom in this list.
     * Note that the first few rules (e.g. minimum_runtime_constraint,
     * min_num_trials) will prevent other stopping rules from being evaluated
     * until they are met. For example, setting `min_num_trials=5` and
     * `always_stop_after= 1 hour` means that the Study will ONLY stop after it
     * has 5 COMPLETED trials, even if more than an hour has passed since its
     * creation. It follows the first applicable rule (whose "if" condition is
     * satisfied) to make a stopping decision. If none of the specified rules
     * are applicable, then Vizier decides that the study should not stop.
     * If Vizier decides that the study should stop, the study enters
     * STOPPING state (or STOPPING_ASAP if should_stop_asap = true).
     * IMPORTANT: The automatic study state transition happens precisely as
     * described above; that is, deleting trials or updating StudyConfig NEVER
     * automatically moves the study state back to ACTIVE. If you want to
     * _resume_ a Study that was stopped, 1) change the stopping conditions if
     * necessary, 2) activate the study, and then 3) ask for suggestions.
     * If the specified time or duration has not passed, do not stop the
     * study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint minimum_runtime_constraint = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudyTimeConstraintOrBuilder
        getMinimumRuntimeConstraintOrBuilder() {
      return minimumRuntimeConstraint_ == null
          ? com.google.cloud.aiplatform.v1.StudyTimeConstraint.getDefaultInstance()
          : minimumRuntimeConstraint_;
    }

    public static final int MAXIMUM_RUNTIME_CONSTRAINT_FIELD_NUMBER = 3;
    private com.google.cloud.aiplatform.v1.StudyTimeConstraint maximumRuntimeConstraint_;
    /**
     *
     *
     * <pre>
     * If the specified time or duration has passed, stop the study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint maximum_runtime_constraint = 3;</code>
     *
     * @return Whether the maximumRuntimeConstraint field is set.
     */
    @java.lang.Override
    public boolean hasMaximumRuntimeConstraint() {
      return maximumRuntimeConstraint_ != null;
    }
    /**
     *
     *
     * <pre>
     * If the specified time or duration has passed, stop the study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint maximum_runtime_constraint = 3;</code>
     *
     * @return The maximumRuntimeConstraint.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudyTimeConstraint getMaximumRuntimeConstraint() {
      return maximumRuntimeConstraint_ == null
          ? com.google.cloud.aiplatform.v1.StudyTimeConstraint.getDefaultInstance()
          : maximumRuntimeConstraint_;
    }
    /**
     *
     *
     * <pre>
     * If the specified time or duration has passed, stop the study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint maximum_runtime_constraint = 3;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudyTimeConstraintOrBuilder
        getMaximumRuntimeConstraintOrBuilder() {
      return maximumRuntimeConstraint_ == null
          ? com.google.cloud.aiplatform.v1.StudyTimeConstraint.getDefaultInstance()
          : maximumRuntimeConstraint_;
    }

    public static final int MIN_NUM_TRIALS_FIELD_NUMBER = 4;
    private com.google.protobuf.Int32Value minNumTrials_;
    /**
     *
     *
     * <pre>
     * If there are fewer than this many COMPLETED trials, do not stop the
     * study.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value min_num_trials = 4;</code>
     *
     * @return Whether the minNumTrials field is set.
     */
    @java.lang.Override
    public boolean hasMinNumTrials() {
      return minNumTrials_ != null;
    }
    /**
     *
     *
     * <pre>
     * If there are fewer than this many COMPLETED trials, do not stop the
     * study.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value min_num_trials = 4;</code>
     *
     * @return The minNumTrials.
     */
    @java.lang.Override
    public com.google.protobuf.Int32Value getMinNumTrials() {
      return minNumTrials_ == null
          ? com.google.protobuf.Int32Value.getDefaultInstance()
          : minNumTrials_;
    }
    /**
     *
     *
     * <pre>
     * If there are fewer than this many COMPLETED trials, do not stop the
     * study.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value min_num_trials = 4;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Int32ValueOrBuilder getMinNumTrialsOrBuilder() {
      return minNumTrials_ == null
          ? com.google.protobuf.Int32Value.getDefaultInstance()
          : minNumTrials_;
    }

    public static final int MAX_NUM_TRIALS_FIELD_NUMBER = 5;
    private com.google.protobuf.Int32Value maxNumTrials_;
    /**
     *
     *
     * <pre>
     * If there are more than this many trials, stop the study.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value max_num_trials = 5;</code>
     *
     * @return Whether the maxNumTrials field is set.
     */
    @java.lang.Override
    public boolean hasMaxNumTrials() {
      return maxNumTrials_ != null;
    }
    /**
     *
     *
     * <pre>
     * If there are more than this many trials, stop the study.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value max_num_trials = 5;</code>
     *
     * @return The maxNumTrials.
     */
    @java.lang.Override
    public com.google.protobuf.Int32Value getMaxNumTrials() {
      return maxNumTrials_ == null
          ? com.google.protobuf.Int32Value.getDefaultInstance()
          : maxNumTrials_;
    }
    /**
     *
     *
     * <pre>
     * If there are more than this many trials, stop the study.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value max_num_trials = 5;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Int32ValueOrBuilder getMaxNumTrialsOrBuilder() {
      return maxNumTrials_ == null
          ? com.google.protobuf.Int32Value.getDefaultInstance()
          : maxNumTrials_;
    }

    public static final int MAX_NUM_TRIALS_NO_PROGRESS_FIELD_NUMBER = 6;
    private com.google.protobuf.Int32Value maxNumTrialsNoProgress_;
    /**
     *
     *
     * <pre>
     * If the objective value has not improved for this many consecutive
     * trials, stop the study.
     *
     * WARNING: Effective only for single-objective studies.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value max_num_trials_no_progress = 6;</code>
     *
     * @return Whether the maxNumTrialsNoProgress field is set.
     */
    @java.lang.Override
    public boolean hasMaxNumTrialsNoProgress() {
      return maxNumTrialsNoProgress_ != null;
    }
    /**
     *
     *
     * <pre>
     * If the objective value has not improved for this many consecutive
     * trials, stop the study.
     *
     * WARNING: Effective only for single-objective studies.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value max_num_trials_no_progress = 6;</code>
     *
     * @return The maxNumTrialsNoProgress.
     */
    @java.lang.Override
    public com.google.protobuf.Int32Value getMaxNumTrialsNoProgress() {
      return maxNumTrialsNoProgress_ == null
          ? com.google.protobuf.Int32Value.getDefaultInstance()
          : maxNumTrialsNoProgress_;
    }
    /**
     *
     *
     * <pre>
     * If the objective value has not improved for this many consecutive
     * trials, stop the study.
     *
     * WARNING: Effective only for single-objective studies.
     * </pre>
     *
     * <code>.google.protobuf.Int32Value max_num_trials_no_progress = 6;</code>
     */
    @java.lang.Override
    public com.google.protobuf.Int32ValueOrBuilder getMaxNumTrialsNoProgressOrBuilder() {
      return maxNumTrialsNoProgress_ == null
          ? com.google.protobuf.Int32Value.getDefaultInstance()
          : maxNumTrialsNoProgress_;
    }

    public static final int MAX_DURATION_NO_PROGRESS_FIELD_NUMBER = 7;
    private com.google.protobuf.Duration maxDurationNoProgress_;
    /**
     *
     *
     * <pre>
     * If the objective value has not improved for this much time, stop the
     * study.
     *
     * WARNING: Effective only for single-objective studies.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration_no_progress = 7;</code>
     *
     * @return Whether the maxDurationNoProgress field is set.
     */
    @java.lang.Override
    public boolean hasMaxDurationNoProgress() {
      return maxDurationNoProgress_ != null;
    }
    /**
     *
     *
     * <pre>
     * If the objective value has not improved for this much time, stop the
     * study.
     *
     * WARNING: Effective only for single-objective studies.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration_no_progress = 7;</code>
     *
     * @return The maxDurationNoProgress.
     */
    @java.lang.Override
    public com.google.protobuf.Duration getMaxDurationNoProgress() {
      return maxDurationNoProgress_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : maxDurationNoProgress_;
    }
    /**
     *
     *
     * <pre>
     * If the objective value has not improved for this much time, stop the
     * study.
     *
     * WARNING: Effective only for single-objective studies.
     * </pre>
     *
     * <code>.google.protobuf.Duration max_duration_no_progress = 7;</code>
     */
    @java.lang.Override
    public com.google.protobuf.DurationOrBuilder getMaxDurationNoProgressOrBuilder() {
      return maxDurationNoProgress_ == null
          ? com.google.protobuf.Duration.getDefaultInstance()
          : maxDurationNoProgress_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (shouldStopAsap_ != null) {
        output.writeMessage(1, getShouldStopAsap());
      }
      if (minimumRuntimeConstraint_ != null) {
        output.writeMessage(2, getMinimumRuntimeConstraint());
      }
      if (maximumRuntimeConstraint_ != null) {
        output.writeMessage(3, getMaximumRuntimeConstraint());
      }
      if (minNumTrials_ != null) {
        output.writeMessage(4, getMinNumTrials());
      }
      if (maxNumTrials_ != null) {
        output.writeMessage(5, getMaxNumTrials());
      }
      if (maxNumTrialsNoProgress_ != null) {
        output.writeMessage(6, getMaxNumTrialsNoProgress());
      }
      if (maxDurationNoProgress_ != null) {
        output.writeMessage(7, getMaxDurationNoProgress());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (shouldStopAsap_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getShouldStopAsap());
      }
      if (minimumRuntimeConstraint_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2, getMinimumRuntimeConstraint());
      }
      if (maximumRuntimeConstraint_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                3, getMaximumRuntimeConstraint());
      }
      if (minNumTrials_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getMinNumTrials());
      }
      if (maxNumTrials_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getMaxNumTrials());
      }
      if (maxNumTrialsNoProgress_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                6, getMaxNumTrialsNoProgress());
      }
      if (maxDurationNoProgress_ != null) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(7, getMaxDurationNoProgress());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig other =
          (com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig) obj;

      if (hasShouldStopAsap() != other.hasShouldStopAsap()) return false;
      if (hasShouldStopAsap()) {
        if (!getShouldStopAsap().equals(other.getShouldStopAsap())) return false;
      }
      if (hasMinimumRuntimeConstraint() != other.hasMinimumRuntimeConstraint()) return false;
      if (hasMinimumRuntimeConstraint()) {
        if (!getMinimumRuntimeConstraint().equals(other.getMinimumRuntimeConstraint()))
          return false;
      }
      if (hasMaximumRuntimeConstraint() != other.hasMaximumRuntimeConstraint()) return false;
      if (hasMaximumRuntimeConstraint()) {
        if (!getMaximumRuntimeConstraint().equals(other.getMaximumRuntimeConstraint()))
          return false;
      }
      if (hasMinNumTrials() != other.hasMinNumTrials()) return false;
      if (hasMinNumTrials()) {
        if (!getMinNumTrials().equals(other.getMinNumTrials())) return false;
      }
      if (hasMaxNumTrials() != other.hasMaxNumTrials()) return false;
      if (hasMaxNumTrials()) {
        if (!getMaxNumTrials().equals(other.getMaxNumTrials())) return false;
      }
      if (hasMaxNumTrialsNoProgress() != other.hasMaxNumTrialsNoProgress()) return false;
      if (hasMaxNumTrialsNoProgress()) {
        if (!getMaxNumTrialsNoProgress().equals(other.getMaxNumTrialsNoProgress())) return false;
      }
      if (hasMaxDurationNoProgress() != other.hasMaxDurationNoProgress()) return false;
      if (hasMaxDurationNoProgress()) {
        if (!getMaxDurationNoProgress().equals(other.getMaxDurationNoProgress())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasShouldStopAsap()) {
        hash = (37 * hash) + SHOULD_STOP_ASAP_FIELD_NUMBER;
        hash = (53 * hash) + getShouldStopAsap().hashCode();
      }
      if (hasMinimumRuntimeConstraint()) {
        hash = (37 * hash) + MINIMUM_RUNTIME_CONSTRAINT_FIELD_NUMBER;
        hash = (53 * hash) + getMinimumRuntimeConstraint().hashCode();
      }
      if (hasMaximumRuntimeConstraint()) {
        hash = (37 * hash) + MAXIMUM_RUNTIME_CONSTRAINT_FIELD_NUMBER;
        hash = (53 * hash) + getMaximumRuntimeConstraint().hashCode();
      }
      if (hasMinNumTrials()) {
        hash = (37 * hash) + MIN_NUM_TRIALS_FIELD_NUMBER;
        hash = (53 * hash) + getMinNumTrials().hashCode();
      }
      if (hasMaxNumTrials()) {
        hash = (37 * hash) + MAX_NUM_TRIALS_FIELD_NUMBER;
        hash = (53 * hash) + getMaxNumTrials().hashCode();
      }
      if (hasMaxNumTrialsNoProgress()) {
        hash = (37 * hash) + MAX_NUM_TRIALS_NO_PROGRESS_FIELD_NUMBER;
        hash = (53 * hash) + getMaxNumTrialsNoProgress().hashCode();
      }
      if (hasMaxDurationNoProgress()) {
        hash = (37 * hash) + MAX_DURATION_NO_PROGRESS_FIELD_NUMBER;
        hash = (53 * hash) + getMaxDurationNoProgress().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * The configuration (stopping conditions) for automated stopping of a Study.
     * Conditions include trial budgets, time budgets, and convergence detection.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig)
        com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfigOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_StudyStoppingConfig_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_StudyStoppingConfig_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig.class,
                com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        shouldStopAsap_ = null;
        if (shouldStopAsapBuilder_ != null) {
          shouldStopAsapBuilder_.dispose();
          shouldStopAsapBuilder_ = null;
        }
        minimumRuntimeConstraint_ = null;
        if (minimumRuntimeConstraintBuilder_ != null) {
          minimumRuntimeConstraintBuilder_.dispose();
          minimumRuntimeConstraintBuilder_ = null;
        }
        maximumRuntimeConstraint_ = null;
        if (maximumRuntimeConstraintBuilder_ != null) {
          maximumRuntimeConstraintBuilder_.dispose();
          maximumRuntimeConstraintBuilder_ = null;
        }
        minNumTrials_ = null;
        if (minNumTrialsBuilder_ != null) {
          minNumTrialsBuilder_.dispose();
          minNumTrialsBuilder_ = null;
        }
        maxNumTrials_ = null;
        if (maxNumTrialsBuilder_ != null) {
          maxNumTrialsBuilder_.dispose();
          maxNumTrialsBuilder_ = null;
        }
        maxNumTrialsNoProgress_ = null;
        if (maxNumTrialsNoProgressBuilder_ != null) {
          maxNumTrialsNoProgressBuilder_.dispose();
          maxNumTrialsNoProgressBuilder_ = null;
        }
        maxDurationNoProgress_ = null;
        if (maxDurationNoProgressBuilder_ != null) {
          maxDurationNoProgressBuilder_.dispose();
          maxDurationNoProgressBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.StudyProto
            .internal_static_google_cloud_aiplatform_v1_StudySpec_StudyStoppingConfig_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig build() {
        com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig buildPartial() {
        com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig result =
            new com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.shouldStopAsap_ =
              shouldStopAsapBuilder_ == null ? shouldStopAsap_ : shouldStopAsapBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.minimumRuntimeConstraint_ =
              minimumRuntimeConstraintBuilder_ == null
                  ? minimumRuntimeConstraint_
                  : minimumRuntimeConstraintBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.maximumRuntimeConstraint_ =
              maximumRuntimeConstraintBuilder_ == null
                  ? maximumRuntimeConstraint_
                  : maximumRuntimeConstraintBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.minNumTrials_ =
              minNumTrialsBuilder_ == null ? minNumTrials_ : minNumTrialsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.maxNumTrials_ =
              maxNumTrialsBuilder_ == null ? maxNumTrials_ : maxNumTrialsBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.maxNumTrialsNoProgress_ =
              maxNumTrialsNoProgressBuilder_ == null
                  ? maxNumTrialsNoProgress_
                  : maxNumTrialsNoProgressBuilder_.build();
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.maxDurationNoProgress_ =
              maxDurationNoProgressBuilder_ == null
                  ? maxDurationNoProgress_
                  : maxDurationNoProgressBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig) {
          return mergeFrom((com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig other) {
        if (other
            == com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig.getDefaultInstance())
          return this;
        if (other.hasShouldStopAsap()) {
          mergeShouldStopAsap(other.getShouldStopAsap());
        }
        if (other.hasMinimumRuntimeConstraint()) {
          mergeMinimumRuntimeConstraint(other.getMinimumRuntimeConstraint());
        }
        if (other.hasMaximumRuntimeConstraint()) {
          mergeMaximumRuntimeConstraint(other.getMaximumRuntimeConstraint());
        }
        if (other.hasMinNumTrials()) {
          mergeMinNumTrials(other.getMinNumTrials());
        }
        if (other.hasMaxNumTrials()) {
          mergeMaxNumTrials(other.getMaxNumTrials());
        }
        if (other.hasMaxNumTrialsNoProgress()) {
          mergeMaxNumTrialsNoProgress(other.getMaxNumTrialsNoProgress());
        }
        if (other.hasMaxDurationNoProgress()) {
          mergeMaxDurationNoProgress(other.getMaxDurationNoProgress());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(
                      getShouldStopAsapFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getMinimumRuntimeConstraintFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  input.readMessage(
                      getMaximumRuntimeConstraintFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  input.readMessage(getMinNumTrialsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              case 42:
                {
                  input.readMessage(getMaxNumTrialsFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000010;
                  break;
                } // case 42
              case 50:
                {
                  input.readMessage(
                      getMaxNumTrialsNoProgressFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000020;
                  break;
                } // case 50
              case 58:
                {
                  input.readMessage(
                      getMaxDurationNoProgressFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000040;
                  break;
                } // case 58
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.BoolValue shouldStopAsap_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.BoolValue,
              com.google.protobuf.BoolValue.Builder,
              com.google.protobuf.BoolValueOrBuilder>
          shouldStopAsapBuilder_;
      /**
       *
       *
       * <pre>
       * If true, a Study enters STOPPING_ASAP whenever it would normally enters
       * STOPPING state.
       *
       * The bottom line is: set to true if you want to interrupt on-going
       * evaluations of Trials as soon as the study stopping condition is met.
       * (Please see Study.State documentation for the source of truth).
       * </pre>
       *
       * <code>.google.protobuf.BoolValue should_stop_asap = 1;</code>
       *
       * @return Whether the shouldStopAsap field is set.
       */
      public boolean hasShouldStopAsap() {
        return ((bitField0_ & 0x00000001) != 0);
      }
      /**
       *
       *
       * <pre>
       * If true, a Study enters STOPPING_ASAP whenever it would normally enters
       * STOPPING state.
       *
       * The bottom line is: set to true if you want to interrupt on-going
       * evaluations of Trials as soon as the study stopping condition is met.
       * (Please see Study.State documentation for the source of truth).
       * </pre>
       *
       * <code>.google.protobuf.BoolValue should_stop_asap = 1;</code>
       *
       * @return The shouldStopAsap.
       */
      public com.google.protobuf.BoolValue getShouldStopAsap() {
        if (shouldStopAsapBuilder_ == null) {
          return shouldStopAsap_ == null
              ? com.google.protobuf.BoolValue.getDefaultInstance()
              : shouldStopAsap_;
        } else {
          return shouldStopAsapBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * If true, a Study enters STOPPING_ASAP whenever it would normally enters
       * STOPPING state.
       *
       * The bottom line is: set to true if you want to interrupt on-going
       * evaluations of Trials as soon as the study stopping condition is met.
       * (Please see Study.State documentation for the source of truth).
       * </pre>
       *
       * <code>.google.protobuf.BoolValue should_stop_asap = 1;</code>
       */
      public Builder setShouldStopAsap(com.google.protobuf.BoolValue value) {
        if (shouldStopAsapBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          shouldStopAsap_ = value;
        } else {
          shouldStopAsapBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If true, a Study enters STOPPING_ASAP whenever it would normally enters
       * STOPPING state.
       *
       * The bottom line is: set to true if you want to interrupt on-going
       * evaluations of Trials as soon as the study stopping condition is met.
       * (Please see Study.State documentation for the source of truth).
       * </pre>
       *
       * <code>.google.protobuf.BoolValue should_stop_asap = 1;</code>
       */
      public Builder setShouldStopAsap(com.google.protobuf.BoolValue.Builder builderForValue) {
        if (shouldStopAsapBuilder_ == null) {
          shouldStopAsap_ = builderForValue.build();
        } else {
          shouldStopAsapBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If true, a Study enters STOPPING_ASAP whenever it would normally enters
       * STOPPING state.
       *
       * The bottom line is: set to true if you want to interrupt on-going
       * evaluations of Trials as soon as the study stopping condition is met.
       * (Please see Study.State documentation for the source of truth).
       * </pre>
       *
       * <code>.google.protobuf.BoolValue should_stop_asap = 1;</code>
       */
      public Builder mergeShouldStopAsap(com.google.protobuf.BoolValue value) {
        if (shouldStopAsapBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && shouldStopAsap_ != null
              && shouldStopAsap_ != com.google.protobuf.BoolValue.getDefaultInstance()) {
            getShouldStopAsapBuilder().mergeFrom(value);
          } else {
            shouldStopAsap_ = value;
          }
        } else {
          shouldStopAsapBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If true, a Study enters STOPPING_ASAP whenever it would normally enters
       * STOPPING state.
       *
       * The bottom line is: set to true if you want to interrupt on-going
       * evaluations of Trials as soon as the study stopping condition is met.
       * (Please see Study.State documentation for the source of truth).
       * </pre>
       *
       * <code>.google.protobuf.BoolValue should_stop_asap = 1;</code>
       */
      public Builder clearShouldStopAsap() {
        bitField0_ = (bitField0_ & ~0x00000001);
        shouldStopAsap_ = null;
        if (shouldStopAsapBuilder_ != null) {
          shouldStopAsapBuilder_.dispose();
          shouldStopAsapBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If true, a Study enters STOPPING_ASAP whenever it would normally enters
       * STOPPING state.
       *
       * The bottom line is: set to true if you want to interrupt on-going
       * evaluations of Trials as soon as the study stopping condition is met.
       * (Please see Study.State documentation for the source of truth).
       * </pre>
       *
       * <code>.google.protobuf.BoolValue should_stop_asap = 1;</code>
       */
      public com.google.protobuf.BoolValue.Builder getShouldStopAsapBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getShouldStopAsapFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If true, a Study enters STOPPING_ASAP whenever it would normally enters
       * STOPPING state.
       *
       * The bottom line is: set to true if you want to interrupt on-going
       * evaluations of Trials as soon as the study stopping condition is met.
       * (Please see Study.State documentation for the source of truth).
       * </pre>
       *
       * <code>.google.protobuf.BoolValue should_stop_asap = 1;</code>
       */
      public com.google.protobuf.BoolValueOrBuilder getShouldStopAsapOrBuilder() {
        if (shouldStopAsapBuilder_ != null) {
          return shouldStopAsapBuilder_.getMessageOrBuilder();
        } else {
          return shouldStopAsap_ == null
              ? com.google.protobuf.BoolValue.getDefaultInstance()
              : shouldStopAsap_;
        }
      }
      /**
       *
       *
       * <pre>
       * If true, a Study enters STOPPING_ASAP whenever it would normally enters
       * STOPPING state.
       *
       * The bottom line is: set to true if you want to interrupt on-going
       * evaluations of Trials as soon as the study stopping condition is met.
       * (Please see Study.State documentation for the source of truth).
       * </pre>
       *
       * <code>.google.protobuf.BoolValue should_stop_asap = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.BoolValue,
              com.google.protobuf.BoolValue.Builder,
              com.google.protobuf.BoolValueOrBuilder>
          getShouldStopAsapFieldBuilder() {
        if (shouldStopAsapBuilder_ == null) {
          shouldStopAsapBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.BoolValue,
                  com.google.protobuf.BoolValue.Builder,
                  com.google.protobuf.BoolValueOrBuilder>(
                  getShouldStopAsap(), getParentForChildren(), isClean());
          shouldStopAsap_ = null;
        }
        return shouldStopAsapBuilder_;
      }

      private com.google.cloud.aiplatform.v1.StudyTimeConstraint minimumRuntimeConstraint_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.StudyTimeConstraint,
              com.google.cloud.aiplatform.v1.StudyTimeConstraint.Builder,
              com.google.cloud.aiplatform.v1.StudyTimeConstraintOrBuilder>
          minimumRuntimeConstraintBuilder_;
      /**
       *
       *
       * <pre>
       * Each "stopping rule" in this proto specifies an "if" condition. Before
       * Vizier would generate a new suggestion, it first checks each specified
       * stopping rule, from top to bottom in this list.
       * Note that the first few rules (e.g. minimum_runtime_constraint,
       * min_num_trials) will prevent other stopping rules from being evaluated
       * until they are met. For example, setting `min_num_trials=5` and
       * `always_stop_after= 1 hour` means that the Study will ONLY stop after it
       * has 5 COMPLETED trials, even if more than an hour has passed since its
       * creation. It follows the first applicable rule (whose "if" condition is
       * satisfied) to make a stopping decision. If none of the specified rules
       * are applicable, then Vizier decides that the study should not stop.
       * If Vizier decides that the study should stop, the study enters
       * STOPPING state (or STOPPING_ASAP if should_stop_asap = true).
       * IMPORTANT: The automatic study state transition happens precisely as
       * described above; that is, deleting trials or updating StudyConfig NEVER
       * automatically moves the study state back to ACTIVE. If you want to
       * _resume_ a Study that was stopped, 1) change the stopping conditions if
       * necessary, 2) activate the study, and then 3) ask for suggestions.
       * If the specified time or duration has not passed, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint minimum_runtime_constraint = 2;
       * </code>
       *
       * @return Whether the minimumRuntimeConstraint field is set.
       */
      public boolean hasMinimumRuntimeConstraint() {
        return ((bitField0_ & 0x00000002) != 0);
      }
      /**
       *
       *
       * <pre>
       * Each "stopping rule" in this proto specifies an "if" condition. Before
       * Vizier would generate a new suggestion, it first checks each specified
       * stopping rule, from top to bottom in this list.
       * Note that the first few rules (e.g. minimum_runtime_constraint,
       * min_num_trials) will prevent other stopping rules from being evaluated
       * until they are met. For example, setting `min_num_trials=5` and
       * `always_stop_after= 1 hour` means that the Study will ONLY stop after it
       * has 5 COMPLETED trials, even if more than an hour has passed since its
       * creation. It follows the first applicable rule (whose "if" condition is
       * satisfied) to make a stopping decision. If none of the specified rules
       * are applicable, then Vizier decides that the study should not stop.
       * If Vizier decides that the study should stop, the study enters
       * STOPPING state (or STOPPING_ASAP if should_stop_asap = true).
       * IMPORTANT: The automatic study state transition happens precisely as
       * described above; that is, deleting trials or updating StudyConfig NEVER
       * automatically moves the study state back to ACTIVE. If you want to
       * _resume_ a Study that was stopped, 1) change the stopping conditions if
       * necessary, 2) activate the study, and then 3) ask for suggestions.
       * If the specified time or duration has not passed, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint minimum_runtime_constraint = 2;
       * </code>
       *
       * @return The minimumRuntimeConstraint.
       */
      public com.google.cloud.aiplatform.v1.StudyTimeConstraint getMinimumRuntimeConstraint() {
        if (minimumRuntimeConstraintBuilder_ == null) {
          return minimumRuntimeConstraint_ == null
              ? com.google.cloud.aiplatform.v1.StudyTimeConstraint.getDefaultInstance()
              : minimumRuntimeConstraint_;
        } else {
          return minimumRuntimeConstraintBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * Each "stopping rule" in this proto specifies an "if" condition. Before
       * Vizier would generate a new suggestion, it first checks each specified
       * stopping rule, from top to bottom in this list.
       * Note that the first few rules (e.g. minimum_runtime_constraint,
       * min_num_trials) will prevent other stopping rules from being evaluated
       * until they are met. For example, setting `min_num_trials=5` and
       * `always_stop_after= 1 hour` means that the Study will ONLY stop after it
       * has 5 COMPLETED trials, even if more than an hour has passed since its
       * creation. It follows the first applicable rule (whose "if" condition is
       * satisfied) to make a stopping decision. If none of the specified rules
       * are applicable, then Vizier decides that the study should not stop.
       * If Vizier decides that the study should stop, the study enters
       * STOPPING state (or STOPPING_ASAP if should_stop_asap = true).
       * IMPORTANT: The automatic study state transition happens precisely as
       * described above; that is, deleting trials or updating StudyConfig NEVER
       * automatically moves the study state back to ACTIVE. If you want to
       * _resume_ a Study that was stopped, 1) change the stopping conditions if
       * necessary, 2) activate the study, and then 3) ask for suggestions.
       * If the specified time or duration has not passed, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint minimum_runtime_constraint = 2;
       * </code>
       */
      public Builder setMinimumRuntimeConstraint(
          com.google.cloud.aiplatform.v1.StudyTimeConstraint value) {
        if (minimumRuntimeConstraintBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          minimumRuntimeConstraint_ = value;
        } else {
          minimumRuntimeConstraintBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each "stopping rule" in this proto specifies an "if" condition. Before
       * Vizier would generate a new suggestion, it first checks each specified
       * stopping rule, from top to bottom in this list.
       * Note that the first few rules (e.g. minimum_runtime_constraint,
       * min_num_trials) will prevent other stopping rules from being evaluated
       * until they are met. For example, setting `min_num_trials=5` and
       * `always_stop_after= 1 hour` means that the Study will ONLY stop after it
       * has 5 COMPLETED trials, even if more than an hour has passed since its
       * creation. It follows the first applicable rule (whose "if" condition is
       * satisfied) to make a stopping decision. If none of the specified rules
       * are applicable, then Vizier decides that the study should not stop.
       * If Vizier decides that the study should stop, the study enters
       * STOPPING state (or STOPPING_ASAP if should_stop_asap = true).
       * IMPORTANT: The automatic study state transition happens precisely as
       * described above; that is, deleting trials or updating StudyConfig NEVER
       * automatically moves the study state back to ACTIVE. If you want to
       * _resume_ a Study that was stopped, 1) change the stopping conditions if
       * necessary, 2) activate the study, and then 3) ask for suggestions.
       * If the specified time or duration has not passed, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint minimum_runtime_constraint = 2;
       * </code>
       */
      public Builder setMinimumRuntimeConstraint(
          com.google.cloud.aiplatform.v1.StudyTimeConstraint.Builder builderForValue) {
        if (minimumRuntimeConstraintBuilder_ == null) {
          minimumRuntimeConstraint_ = builderForValue.build();
        } else {
          minimumRuntimeConstraintBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each "stopping rule" in this proto specifies an "if" condition. Before
       * Vizier would generate a new suggestion, it first checks each specified
       * stopping rule, from top to bottom in this list.
       * Note that the first few rules (e.g. minimum_runtime_constraint,
       * min_num_trials) will prevent other stopping rules from being evaluated
       * until they are met. For example, setting `min_num_trials=5` and
       * `always_stop_after= 1 hour` means that the Study will ONLY stop after it
       * has 5 COMPLETED trials, even if more than an hour has passed since its
       * creation. It follows the first applicable rule (whose "if" condition is
       * satisfied) to make a stopping decision. If none of the specified rules
       * are applicable, then Vizier decides that the study should not stop.
       * If Vizier decides that the study should stop, the study enters
       * STOPPING state (or STOPPING_ASAP if should_stop_asap = true).
       * IMPORTANT: The automatic study state transition happens precisely as
       * described above; that is, deleting trials or updating StudyConfig NEVER
       * automatically moves the study state back to ACTIVE. If you want to
       * _resume_ a Study that was stopped, 1) change the stopping conditions if
       * necessary, 2) activate the study, and then 3) ask for suggestions.
       * If the specified time or duration has not passed, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint minimum_runtime_constraint = 2;
       * </code>
       */
      public Builder mergeMinimumRuntimeConstraint(
          com.google.cloud.aiplatform.v1.StudyTimeConstraint value) {
        if (minimumRuntimeConstraintBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && minimumRuntimeConstraint_ != null
              && minimumRuntimeConstraint_
                  != com.google.cloud.aiplatform.v1.StudyTimeConstraint.getDefaultInstance()) {
            getMinimumRuntimeConstraintBuilder().mergeFrom(value);
          } else {
            minimumRuntimeConstraint_ = value;
          }
        } else {
          minimumRuntimeConstraintBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each "stopping rule" in this proto specifies an "if" condition. Before
       * Vizier would generate a new suggestion, it first checks each specified
       * stopping rule, from top to bottom in this list.
       * Note that the first few rules (e.g. minimum_runtime_constraint,
       * min_num_trials) will prevent other stopping rules from being evaluated
       * until they are met. For example, setting `min_num_trials=5` and
       * `always_stop_after= 1 hour` means that the Study will ONLY stop after it
       * has 5 COMPLETED trials, even if more than an hour has passed since its
       * creation. It follows the first applicable rule (whose "if" condition is
       * satisfied) to make a stopping decision. If none of the specified rules
       * are applicable, then Vizier decides that the study should not stop.
       * If Vizier decides that the study should stop, the study enters
       * STOPPING state (or STOPPING_ASAP if should_stop_asap = true).
       * IMPORTANT: The automatic study state transition happens precisely as
       * described above; that is, deleting trials or updating StudyConfig NEVER
       * automatically moves the study state back to ACTIVE. If you want to
       * _resume_ a Study that was stopped, 1) change the stopping conditions if
       * necessary, 2) activate the study, and then 3) ask for suggestions.
       * If the specified time or duration has not passed, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint minimum_runtime_constraint = 2;
       * </code>
       */
      public Builder clearMinimumRuntimeConstraint() {
        bitField0_ = (bitField0_ & ~0x00000002);
        minimumRuntimeConstraint_ = null;
        if (minimumRuntimeConstraintBuilder_ != null) {
          minimumRuntimeConstraintBuilder_.dispose();
          minimumRuntimeConstraintBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Each "stopping rule" in this proto specifies an "if" condition. Before
       * Vizier would generate a new suggestion, it first checks each specified
       * stopping rule, from top to bottom in this list.
       * Note that the first few rules (e.g. minimum_runtime_constraint,
       * min_num_trials) will prevent other stopping rules from being evaluated
       * until they are met. For example, setting `min_num_trials=5` and
       * `always_stop_after= 1 hour` means that the Study will ONLY stop after it
       * has 5 COMPLETED trials, even if more than an hour has passed since its
       * creation. It follows the first applicable rule (whose "if" condition is
       * satisfied) to make a stopping decision. If none of the specified rules
       * are applicable, then Vizier decides that the study should not stop.
       * If Vizier decides that the study should stop, the study enters
       * STOPPING state (or STOPPING_ASAP if should_stop_asap = true).
       * IMPORTANT: The automatic study state transition happens precisely as
       * described above; that is, deleting trials or updating StudyConfig NEVER
       * automatically moves the study state back to ACTIVE. If you want to
       * _resume_ a Study that was stopped, 1) change the stopping conditions if
       * necessary, 2) activate the study, and then 3) ask for suggestions.
       * If the specified time or duration has not passed, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint minimum_runtime_constraint = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.StudyTimeConstraint.Builder
          getMinimumRuntimeConstraintBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getMinimumRuntimeConstraintFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * Each "stopping rule" in this proto specifies an "if" condition. Before
       * Vizier would generate a new suggestion, it first checks each specified
       * stopping rule, from top to bottom in this list.
       * Note that the first few rules (e.g. minimum_runtime_constraint,
       * min_num_trials) will prevent other stopping rules from being evaluated
       * until they are met. For example, setting `min_num_trials=5` and
       * `always_stop_after= 1 hour` means that the Study will ONLY stop after it
       * has 5 COMPLETED trials, even if more than an hour has passed since its
       * creation. It follows the first applicable rule (whose "if" condition is
       * satisfied) to make a stopping decision. If none of the specified rules
       * are applicable, then Vizier decides that the study should not stop.
       * If Vizier decides that the study should stop, the study enters
       * STOPPING state (or STOPPING_ASAP if should_stop_asap = true).
       * IMPORTANT: The automatic study state transition happens precisely as
       * described above; that is, deleting trials or updating StudyConfig NEVER
       * automatically moves the study state back to ACTIVE. If you want to
       * _resume_ a Study that was stopped, 1) change the stopping conditions if
       * necessary, 2) activate the study, and then 3) ask for suggestions.
       * If the specified time or duration has not passed, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint minimum_runtime_constraint = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.StudyTimeConstraintOrBuilder
          getMinimumRuntimeConstraintOrBuilder() {
        if (minimumRuntimeConstraintBuilder_ != null) {
          return minimumRuntimeConstraintBuilder_.getMessageOrBuilder();
        } else {
          return minimumRuntimeConstraint_ == null
              ? com.google.cloud.aiplatform.v1.StudyTimeConstraint.getDefaultInstance()
              : minimumRuntimeConstraint_;
        }
      }
      /**
       *
       *
       * <pre>
       * Each "stopping rule" in this proto specifies an "if" condition. Before
       * Vizier would generate a new suggestion, it first checks each specified
       * stopping rule, from top to bottom in this list.
       * Note that the first few rules (e.g. minimum_runtime_constraint,
       * min_num_trials) will prevent other stopping rules from being evaluated
       * until they are met. For example, setting `min_num_trials=5` and
       * `always_stop_after= 1 hour` means that the Study will ONLY stop after it
       * has 5 COMPLETED trials, even if more than an hour has passed since its
       * creation. It follows the first applicable rule (whose "if" condition is
       * satisfied) to make a stopping decision. If none of the specified rules
       * are applicable, then Vizier decides that the study should not stop.
       * If Vizier decides that the study should stop, the study enters
       * STOPPING state (or STOPPING_ASAP if should_stop_asap = true).
       * IMPORTANT: The automatic study state transition happens precisely as
       * described above; that is, deleting trials or updating StudyConfig NEVER
       * automatically moves the study state back to ACTIVE. If you want to
       * _resume_ a Study that was stopped, 1) change the stopping conditions if
       * necessary, 2) activate the study, and then 3) ask for suggestions.
       * If the specified time or duration has not passed, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint minimum_runtime_constraint = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.StudyTimeConstraint,
              com.google.cloud.aiplatform.v1.StudyTimeConstraint.Builder,
              com.google.cloud.aiplatform.v1.StudyTimeConstraintOrBuilder>
          getMinimumRuntimeConstraintFieldBuilder() {
        if (minimumRuntimeConstraintBuilder_ == null) {
          minimumRuntimeConstraintBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.StudyTimeConstraint,
                  com.google.cloud.aiplatform.v1.StudyTimeConstraint.Builder,
                  com.google.cloud.aiplatform.v1.StudyTimeConstraintOrBuilder>(
                  getMinimumRuntimeConstraint(), getParentForChildren(), isClean());
          minimumRuntimeConstraint_ = null;
        }
        return minimumRuntimeConstraintBuilder_;
      }

      private com.google.cloud.aiplatform.v1.StudyTimeConstraint maximumRuntimeConstraint_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.StudyTimeConstraint,
              com.google.cloud.aiplatform.v1.StudyTimeConstraint.Builder,
              com.google.cloud.aiplatform.v1.StudyTimeConstraintOrBuilder>
          maximumRuntimeConstraintBuilder_;
      /**
       *
       *
       * <pre>
       * If the specified time or duration has passed, stop the study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint maximum_runtime_constraint = 3;
       * </code>
       *
       * @return Whether the maximumRuntimeConstraint field is set.
       */
      public boolean hasMaximumRuntimeConstraint() {
        return ((bitField0_ & 0x00000004) != 0);
      }
      /**
       *
       *
       * <pre>
       * If the specified time or duration has passed, stop the study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint maximum_runtime_constraint = 3;
       * </code>
       *
       * @return The maximumRuntimeConstraint.
       */
      public com.google.cloud.aiplatform.v1.StudyTimeConstraint getMaximumRuntimeConstraint() {
        if (maximumRuntimeConstraintBuilder_ == null) {
          return maximumRuntimeConstraint_ == null
              ? com.google.cloud.aiplatform.v1.StudyTimeConstraint.getDefaultInstance()
              : maximumRuntimeConstraint_;
        } else {
          return maximumRuntimeConstraintBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * If the specified time or duration has passed, stop the study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint maximum_runtime_constraint = 3;
       * </code>
       */
      public Builder setMaximumRuntimeConstraint(
          com.google.cloud.aiplatform.v1.StudyTimeConstraint value) {
        if (maximumRuntimeConstraintBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          maximumRuntimeConstraint_ = value;
        } else {
          maximumRuntimeConstraintBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the specified time or duration has passed, stop the study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint maximum_runtime_constraint = 3;
       * </code>
       */
      public Builder setMaximumRuntimeConstraint(
          com.google.cloud.aiplatform.v1.StudyTimeConstraint.Builder builderForValue) {
        if (maximumRuntimeConstraintBuilder_ == null) {
          maximumRuntimeConstraint_ = builderForValue.build();
        } else {
          maximumRuntimeConstraintBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the specified time or duration has passed, stop the study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint maximum_runtime_constraint = 3;
       * </code>
       */
      public Builder mergeMaximumRuntimeConstraint(
          com.google.cloud.aiplatform.v1.StudyTimeConstraint value) {
        if (maximumRuntimeConstraintBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && maximumRuntimeConstraint_ != null
              && maximumRuntimeConstraint_
                  != com.google.cloud.aiplatform.v1.StudyTimeConstraint.getDefaultInstance()) {
            getMaximumRuntimeConstraintBuilder().mergeFrom(value);
          } else {
            maximumRuntimeConstraint_ = value;
          }
        } else {
          maximumRuntimeConstraintBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the specified time or duration has passed, stop the study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint maximum_runtime_constraint = 3;
       * </code>
       */
      public Builder clearMaximumRuntimeConstraint() {
        bitField0_ = (bitField0_ & ~0x00000004);
        maximumRuntimeConstraint_ = null;
        if (maximumRuntimeConstraintBuilder_ != null) {
          maximumRuntimeConstraintBuilder_.dispose();
          maximumRuntimeConstraintBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the specified time or duration has passed, stop the study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint maximum_runtime_constraint = 3;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.StudyTimeConstraint.Builder
          getMaximumRuntimeConstraintBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getMaximumRuntimeConstraintFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If the specified time or duration has passed, stop the study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint maximum_runtime_constraint = 3;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.StudyTimeConstraintOrBuilder
          getMaximumRuntimeConstraintOrBuilder() {
        if (maximumRuntimeConstraintBuilder_ != null) {
          return maximumRuntimeConstraintBuilder_.getMessageOrBuilder();
        } else {
          return maximumRuntimeConstraint_ == null
              ? com.google.cloud.aiplatform.v1.StudyTimeConstraint.getDefaultInstance()
              : maximumRuntimeConstraint_;
        }
      }
      /**
       *
       *
       * <pre>
       * If the specified time or duration has passed, stop the study.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.StudyTimeConstraint maximum_runtime_constraint = 3;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.StudyTimeConstraint,
              com.google.cloud.aiplatform.v1.StudyTimeConstraint.Builder,
              com.google.cloud.aiplatform.v1.StudyTimeConstraintOrBuilder>
          getMaximumRuntimeConstraintFieldBuilder() {
        if (maximumRuntimeConstraintBuilder_ == null) {
          maximumRuntimeConstraintBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.StudyTimeConstraint,
                  com.google.cloud.aiplatform.v1.StudyTimeConstraint.Builder,
                  com.google.cloud.aiplatform.v1.StudyTimeConstraintOrBuilder>(
                  getMaximumRuntimeConstraint(), getParentForChildren(), isClean());
          maximumRuntimeConstraint_ = null;
        }
        return maximumRuntimeConstraintBuilder_;
      }

      private com.google.protobuf.Int32Value minNumTrials_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Int32Value,
              com.google.protobuf.Int32Value.Builder,
              com.google.protobuf.Int32ValueOrBuilder>
          minNumTrialsBuilder_;
      /**
       *
       *
       * <pre>
       * If there are fewer than this many COMPLETED trials, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value min_num_trials = 4;</code>
       *
       * @return Whether the minNumTrials field is set.
       */
      public boolean hasMinNumTrials() {
        return ((bitField0_ & 0x00000008) != 0);
      }
      /**
       *
       *
       * <pre>
       * If there are fewer than this many COMPLETED trials, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value min_num_trials = 4;</code>
       *
       * @return The minNumTrials.
       */
      public com.google.protobuf.Int32Value getMinNumTrials() {
        if (minNumTrialsBuilder_ == null) {
          return minNumTrials_ == null
              ? com.google.protobuf.Int32Value.getDefaultInstance()
              : minNumTrials_;
        } else {
          return minNumTrialsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * If there are fewer than this many COMPLETED trials, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value min_num_trials = 4;</code>
       */
      public Builder setMinNumTrials(com.google.protobuf.Int32Value value) {
        if (minNumTrialsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          minNumTrials_ = value;
        } else {
          minNumTrialsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If there are fewer than this many COMPLETED trials, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value min_num_trials = 4;</code>
       */
      public Builder setMinNumTrials(com.google.protobuf.Int32Value.Builder builderForValue) {
        if (minNumTrialsBuilder_ == null) {
          minNumTrials_ = builderForValue.build();
        } else {
          minNumTrialsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If there are fewer than this many COMPLETED trials, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value min_num_trials = 4;</code>
       */
      public Builder mergeMinNumTrials(com.google.protobuf.Int32Value value) {
        if (minNumTrialsBuilder_ == null) {
          if (((bitField0_ & 0x00000008) != 0)
              && minNumTrials_ != null
              && minNumTrials_ != com.google.protobuf.Int32Value.getDefaultInstance()) {
            getMinNumTrialsBuilder().mergeFrom(value);
          } else {
            minNumTrials_ = value;
          }
        } else {
          minNumTrialsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If there are fewer than this many COMPLETED trials, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value min_num_trials = 4;</code>
       */
      public Builder clearMinNumTrials() {
        bitField0_ = (bitField0_ & ~0x00000008);
        minNumTrials_ = null;
        if (minNumTrialsBuilder_ != null) {
          minNumTrialsBuilder_.dispose();
          minNumTrialsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If there are fewer than this many COMPLETED trials, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value min_num_trials = 4;</code>
       */
      public com.google.protobuf.Int32Value.Builder getMinNumTrialsBuilder() {
        bitField0_ |= 0x00000008;
        onChanged();
        return getMinNumTrialsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If there are fewer than this many COMPLETED trials, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value min_num_trials = 4;</code>
       */
      public com.google.protobuf.Int32ValueOrBuilder getMinNumTrialsOrBuilder() {
        if (minNumTrialsBuilder_ != null) {
          return minNumTrialsBuilder_.getMessageOrBuilder();
        } else {
          return minNumTrials_ == null
              ? com.google.protobuf.Int32Value.getDefaultInstance()
              : minNumTrials_;
        }
      }
      /**
       *
       *
       * <pre>
       * If there are fewer than this many COMPLETED trials, do not stop the
       * study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value min_num_trials = 4;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Int32Value,
              com.google.protobuf.Int32Value.Builder,
              com.google.protobuf.Int32ValueOrBuilder>
          getMinNumTrialsFieldBuilder() {
        if (minNumTrialsBuilder_ == null) {
          minNumTrialsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Int32Value,
                  com.google.protobuf.Int32Value.Builder,
                  com.google.protobuf.Int32ValueOrBuilder>(
                  getMinNumTrials(), getParentForChildren(), isClean());
          minNumTrials_ = null;
        }
        return minNumTrialsBuilder_;
      }

      private com.google.protobuf.Int32Value maxNumTrials_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Int32Value,
              com.google.protobuf.Int32Value.Builder,
              com.google.protobuf.Int32ValueOrBuilder>
          maxNumTrialsBuilder_;
      /**
       *
       *
       * <pre>
       * If there are more than this many trials, stop the study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials = 5;</code>
       *
       * @return Whether the maxNumTrials field is set.
       */
      public boolean hasMaxNumTrials() {
        return ((bitField0_ & 0x00000010) != 0);
      }
      /**
       *
       *
       * <pre>
       * If there are more than this many trials, stop the study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials = 5;</code>
       *
       * @return The maxNumTrials.
       */
      public com.google.protobuf.Int32Value getMaxNumTrials() {
        if (maxNumTrialsBuilder_ == null) {
          return maxNumTrials_ == null
              ? com.google.protobuf.Int32Value.getDefaultInstance()
              : maxNumTrials_;
        } else {
          return maxNumTrialsBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * If there are more than this many trials, stop the study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials = 5;</code>
       */
      public Builder setMaxNumTrials(com.google.protobuf.Int32Value value) {
        if (maxNumTrialsBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          maxNumTrials_ = value;
        } else {
          maxNumTrialsBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If there are more than this many trials, stop the study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials = 5;</code>
       */
      public Builder setMaxNumTrials(com.google.protobuf.Int32Value.Builder builderForValue) {
        if (maxNumTrialsBuilder_ == null) {
          maxNumTrials_ = builderForValue.build();
        } else {
          maxNumTrialsBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If there are more than this many trials, stop the study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials = 5;</code>
       */
      public Builder mergeMaxNumTrials(com.google.protobuf.Int32Value value) {
        if (maxNumTrialsBuilder_ == null) {
          if (((bitField0_ & 0x00000010) != 0)
              && maxNumTrials_ != null
              && maxNumTrials_ != com.google.protobuf.Int32Value.getDefaultInstance()) {
            getMaxNumTrialsBuilder().mergeFrom(value);
          } else {
            maxNumTrials_ = value;
          }
        } else {
          maxNumTrialsBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If there are more than this many trials, stop the study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials = 5;</code>
       */
      public Builder clearMaxNumTrials() {
        bitField0_ = (bitField0_ & ~0x00000010);
        maxNumTrials_ = null;
        if (maxNumTrialsBuilder_ != null) {
          maxNumTrialsBuilder_.dispose();
          maxNumTrialsBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If there are more than this many trials, stop the study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials = 5;</code>
       */
      public com.google.protobuf.Int32Value.Builder getMaxNumTrialsBuilder() {
        bitField0_ |= 0x00000010;
        onChanged();
        return getMaxNumTrialsFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If there are more than this many trials, stop the study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials = 5;</code>
       */
      public com.google.protobuf.Int32ValueOrBuilder getMaxNumTrialsOrBuilder() {
        if (maxNumTrialsBuilder_ != null) {
          return maxNumTrialsBuilder_.getMessageOrBuilder();
        } else {
          return maxNumTrials_ == null
              ? com.google.protobuf.Int32Value.getDefaultInstance()
              : maxNumTrials_;
        }
      }
      /**
       *
       *
       * <pre>
       * If there are more than this many trials, stop the study.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials = 5;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Int32Value,
              com.google.protobuf.Int32Value.Builder,
              com.google.protobuf.Int32ValueOrBuilder>
          getMaxNumTrialsFieldBuilder() {
        if (maxNumTrialsBuilder_ == null) {
          maxNumTrialsBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Int32Value,
                  com.google.protobuf.Int32Value.Builder,
                  com.google.protobuf.Int32ValueOrBuilder>(
                  getMaxNumTrials(), getParentForChildren(), isClean());
          maxNumTrials_ = null;
        }
        return maxNumTrialsBuilder_;
      }

      private com.google.protobuf.Int32Value maxNumTrialsNoProgress_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Int32Value,
              com.google.protobuf.Int32Value.Builder,
              com.google.protobuf.Int32ValueOrBuilder>
          maxNumTrialsNoProgressBuilder_;
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this many consecutive
       * trials, stop the study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials_no_progress = 6;</code>
       *
       * @return Whether the maxNumTrialsNoProgress field is set.
       */
      public boolean hasMaxNumTrialsNoProgress() {
        return ((bitField0_ & 0x00000020) != 0);
      }
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this many consecutive
       * trials, stop the study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials_no_progress = 6;</code>
       *
       * @return The maxNumTrialsNoProgress.
       */
      public com.google.protobuf.Int32Value getMaxNumTrialsNoProgress() {
        if (maxNumTrialsNoProgressBuilder_ == null) {
          return maxNumTrialsNoProgress_ == null
              ? com.google.protobuf.Int32Value.getDefaultInstance()
              : maxNumTrialsNoProgress_;
        } else {
          return maxNumTrialsNoProgressBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this many consecutive
       * trials, stop the study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials_no_progress = 6;</code>
       */
      public Builder setMaxNumTrialsNoProgress(com.google.protobuf.Int32Value value) {
        if (maxNumTrialsNoProgressBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          maxNumTrialsNoProgress_ = value;
        } else {
          maxNumTrialsNoProgressBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this many consecutive
       * trials, stop the study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials_no_progress = 6;</code>
       */
      public Builder setMaxNumTrialsNoProgress(
          com.google.protobuf.Int32Value.Builder builderForValue) {
        if (maxNumTrialsNoProgressBuilder_ == null) {
          maxNumTrialsNoProgress_ = builderForValue.build();
        } else {
          maxNumTrialsNoProgressBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this many consecutive
       * trials, stop the study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials_no_progress = 6;</code>
       */
      public Builder mergeMaxNumTrialsNoProgress(com.google.protobuf.Int32Value value) {
        if (maxNumTrialsNoProgressBuilder_ == null) {
          if (((bitField0_ & 0x00000020) != 0)
              && maxNumTrialsNoProgress_ != null
              && maxNumTrialsNoProgress_ != com.google.protobuf.Int32Value.getDefaultInstance()) {
            getMaxNumTrialsNoProgressBuilder().mergeFrom(value);
          } else {
            maxNumTrialsNoProgress_ = value;
          }
        } else {
          maxNumTrialsNoProgressBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this many consecutive
       * trials, stop the study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials_no_progress = 6;</code>
       */
      public Builder clearMaxNumTrialsNoProgress() {
        bitField0_ = (bitField0_ & ~0x00000020);
        maxNumTrialsNoProgress_ = null;
        if (maxNumTrialsNoProgressBuilder_ != null) {
          maxNumTrialsNoProgressBuilder_.dispose();
          maxNumTrialsNoProgressBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this many consecutive
       * trials, stop the study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials_no_progress = 6;</code>
       */
      public com.google.protobuf.Int32Value.Builder getMaxNumTrialsNoProgressBuilder() {
        bitField0_ |= 0x00000020;
        onChanged();
        return getMaxNumTrialsNoProgressFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this many consecutive
       * trials, stop the study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials_no_progress = 6;</code>
       */
      public com.google.protobuf.Int32ValueOrBuilder getMaxNumTrialsNoProgressOrBuilder() {
        if (maxNumTrialsNoProgressBuilder_ != null) {
          return maxNumTrialsNoProgressBuilder_.getMessageOrBuilder();
        } else {
          return maxNumTrialsNoProgress_ == null
              ? com.google.protobuf.Int32Value.getDefaultInstance()
              : maxNumTrialsNoProgress_;
        }
      }
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this many consecutive
       * trials, stop the study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Int32Value max_num_trials_no_progress = 6;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Int32Value,
              com.google.protobuf.Int32Value.Builder,
              com.google.protobuf.Int32ValueOrBuilder>
          getMaxNumTrialsNoProgressFieldBuilder() {
        if (maxNumTrialsNoProgressBuilder_ == null) {
          maxNumTrialsNoProgressBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Int32Value,
                  com.google.protobuf.Int32Value.Builder,
                  com.google.protobuf.Int32ValueOrBuilder>(
                  getMaxNumTrialsNoProgress(), getParentForChildren(), isClean());
          maxNumTrialsNoProgress_ = null;
        }
        return maxNumTrialsNoProgressBuilder_;
      }

      private com.google.protobuf.Duration maxDurationNoProgress_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          maxDurationNoProgressBuilder_;
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this much time, stop the
       * study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration_no_progress = 7;</code>
       *
       * @return Whether the maxDurationNoProgress field is set.
       */
      public boolean hasMaxDurationNoProgress() {
        return ((bitField0_ & 0x00000040) != 0);
      }
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this much time, stop the
       * study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration_no_progress = 7;</code>
       *
       * @return The maxDurationNoProgress.
       */
      public com.google.protobuf.Duration getMaxDurationNoProgress() {
        if (maxDurationNoProgressBuilder_ == null) {
          return maxDurationNoProgress_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : maxDurationNoProgress_;
        } else {
          return maxDurationNoProgressBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this much time, stop the
       * study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration_no_progress = 7;</code>
       */
      public Builder setMaxDurationNoProgress(com.google.protobuf.Duration value) {
        if (maxDurationNoProgressBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          maxDurationNoProgress_ = value;
        } else {
          maxDurationNoProgressBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this much time, stop the
       * study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration_no_progress = 7;</code>
       */
      public Builder setMaxDurationNoProgress(
          com.google.protobuf.Duration.Builder builderForValue) {
        if (maxDurationNoProgressBuilder_ == null) {
          maxDurationNoProgress_ = builderForValue.build();
        } else {
          maxDurationNoProgressBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this much time, stop the
       * study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration_no_progress = 7;</code>
       */
      public Builder mergeMaxDurationNoProgress(com.google.protobuf.Duration value) {
        if (maxDurationNoProgressBuilder_ == null) {
          if (((bitField0_ & 0x00000040) != 0)
              && maxDurationNoProgress_ != null
              && maxDurationNoProgress_ != com.google.protobuf.Duration.getDefaultInstance()) {
            getMaxDurationNoProgressBuilder().mergeFrom(value);
          } else {
            maxDurationNoProgress_ = value;
          }
        } else {
          maxDurationNoProgressBuilder_.mergeFrom(value);
        }
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this much time, stop the
       * study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration_no_progress = 7;</code>
       */
      public Builder clearMaxDurationNoProgress() {
        bitField0_ = (bitField0_ & ~0x00000040);
        maxDurationNoProgress_ = null;
        if (maxDurationNoProgressBuilder_ != null) {
          maxDurationNoProgressBuilder_.dispose();
          maxDurationNoProgressBuilder_ = null;
        }
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this much time, stop the
       * study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration_no_progress = 7;</code>
       */
      public com.google.protobuf.Duration.Builder getMaxDurationNoProgressBuilder() {
        bitField0_ |= 0x00000040;
        onChanged();
        return getMaxDurationNoProgressFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this much time, stop the
       * study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration_no_progress = 7;</code>
       */
      public com.google.protobuf.DurationOrBuilder getMaxDurationNoProgressOrBuilder() {
        if (maxDurationNoProgressBuilder_ != null) {
          return maxDurationNoProgressBuilder_.getMessageOrBuilder();
        } else {
          return maxDurationNoProgress_ == null
              ? com.google.protobuf.Duration.getDefaultInstance()
              : maxDurationNoProgress_;
        }
      }
      /**
       *
       *
       * <pre>
       * If the objective value has not improved for this much time, stop the
       * study.
       *
       * WARNING: Effective only for single-objective studies.
       * </pre>
       *
       * <code>.google.protobuf.Duration max_duration_no_progress = 7;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Duration,
              com.google.protobuf.Duration.Builder,
              com.google.protobuf.DurationOrBuilder>
          getMaxDurationNoProgressFieldBuilder() {
        if (maxDurationNoProgressBuilder_ == null) {
          maxDurationNoProgressBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Duration,
                  com.google.protobuf.Duration.Builder,
                  com.google.protobuf.DurationOrBuilder>(
                  getMaxDurationNoProgress(), getParentForChildren(), isClean());
          maxDurationNoProgress_ = null;
        }
        return maxDurationNoProgressBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig)
    private static final com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig();
    }

    public static com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StudyStoppingConfig> PARSER =
        new com.google.protobuf.AbstractParser<StudyStoppingConfig>() {
          @java.lang.Override
          public StudyStoppingConfig parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<StudyStoppingConfig> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StudyStoppingConfig> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int automatedStoppingSpecCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object automatedStoppingSpec_;

  public enum AutomatedStoppingSpecCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    DECAY_CURVE_STOPPING_SPEC(4),
    MEDIAN_AUTOMATED_STOPPING_SPEC(5),
    CONVEX_AUTOMATED_STOPPING_SPEC(9),
    AUTOMATEDSTOPPINGSPEC_NOT_SET(0);
    private final int value;

    private AutomatedStoppingSpecCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static AutomatedStoppingSpecCase valueOf(int value) {
      return forNumber(value);
    }

    public static AutomatedStoppingSpecCase forNumber(int value) {
      switch (value) {
        case 4:
          return DECAY_CURVE_STOPPING_SPEC;
        case 5:
          return MEDIAN_AUTOMATED_STOPPING_SPEC;
        case 9:
          return CONVEX_AUTOMATED_STOPPING_SPEC;
        case 0:
          return AUTOMATEDSTOPPINGSPEC_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public AutomatedStoppingSpecCase getAutomatedStoppingSpecCase() {
    return AutomatedStoppingSpecCase.forNumber(automatedStoppingSpecCase_);
  }

  public static final int DECAY_CURVE_STOPPING_SPEC_FIELD_NUMBER = 4;
  /**
   *
   *
   * <pre>
   * The automated early stopping spec using decay curve rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
   * </code>
   *
   * @return Whether the decayCurveStoppingSpec field is set.
   */
  @java.lang.Override
  public boolean hasDecayCurveStoppingSpec() {
    return automatedStoppingSpecCase_ == 4;
  }
  /**
   *
   *
   * <pre>
   * The automated early stopping spec using decay curve rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
   * </code>
   *
   * @return The decayCurveStoppingSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
      getDecayCurveStoppingSpec() {
    if (automatedStoppingSpecCase_ == 4) {
      return (com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec)
          automatedStoppingSpec_;
    }
    return com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The automated early stopping spec using decay curve rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpecOrBuilder
      getDecayCurveStoppingSpecOrBuilder() {
    if (automatedStoppingSpecCase_ == 4) {
      return (com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec)
          automatedStoppingSpec_;
    }
    return com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        .getDefaultInstance();
  }

  public static final int MEDIAN_AUTOMATED_STOPPING_SPEC_FIELD_NUMBER = 5;
  /**
   *
   *
   * <pre>
   * The automated early stopping spec using median rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
   * </code>
   *
   * @return Whether the medianAutomatedStoppingSpec field is set.
   */
  @java.lang.Override
  public boolean hasMedianAutomatedStoppingSpec() {
    return automatedStoppingSpecCase_ == 5;
  }
  /**
   *
   *
   * <pre>
   * The automated early stopping spec using median rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
   * </code>
   *
   * @return The medianAutomatedStoppingSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
      getMedianAutomatedStoppingSpec() {
    if (automatedStoppingSpecCase_ == 5) {
      return (com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec)
          automatedStoppingSpec_;
    }
    return com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The automated early stopping spec using median rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpecOrBuilder
      getMedianAutomatedStoppingSpecOrBuilder() {
    if (automatedStoppingSpecCase_ == 5) {
      return (com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec)
          automatedStoppingSpec_;
    }
    return com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
        .getDefaultInstance();
  }

  public static final int CONVEX_AUTOMATED_STOPPING_SPEC_FIELD_NUMBER = 9;
  /**
   *
   *
   * <pre>
   * The automated early stopping spec using convex stopping rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec convex_automated_stopping_spec = 9;
   * </code>
   *
   * @return Whether the convexAutomatedStoppingSpec field is set.
   */
  @java.lang.Override
  public boolean hasConvexAutomatedStoppingSpec() {
    return automatedStoppingSpecCase_ == 9;
  }
  /**
   *
   *
   * <pre>
   * The automated early stopping spec using convex stopping rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec convex_automated_stopping_spec = 9;
   * </code>
   *
   * @return The convexAutomatedStoppingSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
      getConvexAutomatedStoppingSpec() {
    if (automatedStoppingSpecCase_ == 9) {
      return (com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec)
          automatedStoppingSpec_;
    }
    return com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
        .getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * The automated early stopping spec using convex stopping rule.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec convex_automated_stopping_spec = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpecOrBuilder
      getConvexAutomatedStoppingSpecOrBuilder() {
    if (automatedStoppingSpecCase_ == 9) {
      return (com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec)
          automatedStoppingSpec_;
    }
    return com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
        .getDefaultInstance();
  }

  public static final int METRICS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.StudySpec.MetricSpec> metrics_;
  /**
   *
   *
   * <pre>
   * Required. Metric specs for the Study.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.StudySpec.MetricSpec> getMetricsList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * Required. Metric specs for the Study.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.StudySpec.MetricSpecOrBuilder>
      getMetricsOrBuilderList() {
    return metrics_;
  }
  /**
   *
   *
   * <pre>
   * Required. Metric specs for the Study.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getMetricsCount() {
    return metrics_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. Metric specs for the Study.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec getMetrics(int index) {
    return metrics_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. Metric specs for the Study.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StudySpec.MetricSpecOrBuilder getMetricsOrBuilder(
      int index) {
    return metrics_.get(index);
  }

  public static final int PARAMETERS_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec> parameters_;
  /**
   *
   *
   * <pre>
   * Required. The set of parameters to tune.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec>
      getParametersList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Required. The set of parameters to tune.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.StudySpec.ParameterSpecOrBuilder>
      getParametersOrBuilderList() {
    return parameters_;
  }
  /**
   *
   *
   * <pre>
   * Required. The set of parameters to tune.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getParametersCount() {
    return parameters_.size();
  }
  /**
   *
   *
   * <pre>
   * Required. The set of parameters to tune.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec getParameters(int index) {
    return parameters_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Required. The set of parameters to tune.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpecOrBuilder getParametersOrBuilder(
      int index) {
    return parameters_.get(index);
  }

  public static final int ALGORITHM_FIELD_NUMBER = 3;
  private int algorithm_ = 0;
  /**
   *
   *
   * <pre>
   * The search algorithm specified for the Study.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.StudySpec.Algorithm algorithm = 3;</code>
   *
   * @return The enum numeric value on the wire for algorithm.
   */
  @java.lang.Override
  public int getAlgorithmValue() {
    return algorithm_;
  }
  /**
   *
   *
   * <pre>
   * The search algorithm specified for the Study.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.StudySpec.Algorithm algorithm = 3;</code>
   *
   * @return The algorithm.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StudySpec.Algorithm getAlgorithm() {
    com.google.cloud.aiplatform.v1.StudySpec.Algorithm result =
        com.google.cloud.aiplatform.v1.StudySpec.Algorithm.forNumber(algorithm_);
    return result == null
        ? com.google.cloud.aiplatform.v1.StudySpec.Algorithm.UNRECOGNIZED
        : result;
  }

  public static final int OBSERVATION_NOISE_FIELD_NUMBER = 6;
  private int observationNoise_ = 0;
  /**
   *
   *
   * <pre>
   * The observation noise level of the study.
   * Currently only supported by the Vertex AI Vizier service. Not supported by
   * HyperparameterTuningJob or TrainingPipeline.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.StudySpec.ObservationNoise observation_noise = 6;</code>
   *
   * @return The enum numeric value on the wire for observationNoise.
   */
  @java.lang.Override
  public int getObservationNoiseValue() {
    return observationNoise_;
  }
  /**
   *
   *
   * <pre>
   * The observation noise level of the study.
   * Currently only supported by the Vertex AI Vizier service. Not supported by
   * HyperparameterTuningJob or TrainingPipeline.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.StudySpec.ObservationNoise observation_noise = 6;</code>
   *
   * @return The observationNoise.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StudySpec.ObservationNoise getObservationNoise() {
    com.google.cloud.aiplatform.v1.StudySpec.ObservationNoise result =
        com.google.cloud.aiplatform.v1.StudySpec.ObservationNoise.forNumber(observationNoise_);
    return result == null
        ? com.google.cloud.aiplatform.v1.StudySpec.ObservationNoise.UNRECOGNIZED
        : result;
  }

  public static final int MEASUREMENT_SELECTION_TYPE_FIELD_NUMBER = 7;
  private int measurementSelectionType_ = 0;
  /**
   *
   *
   * <pre>
   * Describe which measurement selection type will be used
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType measurement_selection_type = 7;
   * </code>
   *
   * @return The enum numeric value on the wire for measurementSelectionType.
   */
  @java.lang.Override
  public int getMeasurementSelectionTypeValue() {
    return measurementSelectionType_;
  }
  /**
   *
   *
   * <pre>
   * Describe which measurement selection type will be used
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType measurement_selection_type = 7;
   * </code>
   *
   * @return The measurementSelectionType.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType
      getMeasurementSelectionType() {
    com.google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType result =
        com.google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType.forNumber(
            measurementSelectionType_);
    return result == null
        ? com.google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType.UNRECOGNIZED
        : result;
  }

  public static final int STUDY_STOPPING_CONFIG_FIELD_NUMBER = 11;
  private com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig studyStoppingConfig_;
  /**
   *
   *
   * <pre>
   * Conditions for automated stopping of a Study. Enable automated stopping by
   * configuring at least one condition.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig study_stopping_config = 11;
   * </code>
   *
   * @return Whether the studyStoppingConfig field is set.
   */
  @java.lang.Override
  public boolean hasStudyStoppingConfig() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Conditions for automated stopping of a Study. Enable automated stopping by
   * configuring at least one condition.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig study_stopping_config = 11;
   * </code>
   *
   * @return The studyStoppingConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig getStudyStoppingConfig() {
    return studyStoppingConfig_ == null
        ? com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig.getDefaultInstance()
        : studyStoppingConfig_;
  }
  /**
   *
   *
   * <pre>
   * Conditions for automated stopping of a Study. Enable automated stopping by
   * configuring at least one condition.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig study_stopping_config = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfigOrBuilder
      getStudyStoppingConfigOrBuilder() {
    return studyStoppingConfig_ == null
        ? com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig.getDefaultInstance()
        : studyStoppingConfig_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < metrics_.size(); i++) {
      output.writeMessage(1, metrics_.get(i));
    }
    for (int i = 0; i < parameters_.size(); i++) {
      output.writeMessage(2, parameters_.get(i));
    }
    if (algorithm_
        != com.google.cloud.aiplatform.v1.StudySpec.Algorithm.ALGORITHM_UNSPECIFIED.getNumber()) {
      output.writeEnum(3, algorithm_);
    }
    if (automatedStoppingSpecCase_ == 4) {
      output.writeMessage(
          4,
          (com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec)
              automatedStoppingSpec_);
    }
    if (automatedStoppingSpecCase_ == 5) {
      output.writeMessage(
          5,
          (com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec)
              automatedStoppingSpec_);
    }
    if (observationNoise_
        != com.google.cloud.aiplatform.v1.StudySpec.ObservationNoise.OBSERVATION_NOISE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(6, observationNoise_);
    }
    if (measurementSelectionType_
        != com.google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType
            .MEASUREMENT_SELECTION_TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(7, measurementSelectionType_);
    }
    if (automatedStoppingSpecCase_ == 9) {
      output.writeMessage(
          9,
          (com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec)
              automatedStoppingSpec_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(11, getStudyStoppingConfig());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < metrics_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, metrics_.get(i));
    }
    for (int i = 0; i < parameters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, parameters_.get(i));
    }
    if (algorithm_
        != com.google.cloud.aiplatform.v1.StudySpec.Algorithm.ALGORITHM_UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, algorithm_);
    }
    if (automatedStoppingSpecCase_ == 4) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              4,
              (com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec)
                  automatedStoppingSpec_);
    }
    if (automatedStoppingSpecCase_ == 5) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              5,
              (com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec)
                  automatedStoppingSpec_);
    }
    if (observationNoise_
        != com.google.cloud.aiplatform.v1.StudySpec.ObservationNoise.OBSERVATION_NOISE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(6, observationNoise_);
    }
    if (measurementSelectionType_
        != com.google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType
            .MEASUREMENT_SELECTION_TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(7, measurementSelectionType_);
    }
    if (automatedStoppingSpecCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9,
              (com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec)
                  automatedStoppingSpec_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(11, getStudyStoppingConfig());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.StudySpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.StudySpec other = (com.google.cloud.aiplatform.v1.StudySpec) obj;

    if (!getMetricsList().equals(other.getMetricsList())) return false;
    if (!getParametersList().equals(other.getParametersList())) return false;
    if (algorithm_ != other.algorithm_) return false;
    if (observationNoise_ != other.observationNoise_) return false;
    if (measurementSelectionType_ != other.measurementSelectionType_) return false;
    if (hasStudyStoppingConfig() != other.hasStudyStoppingConfig()) return false;
    if (hasStudyStoppingConfig()) {
      if (!getStudyStoppingConfig().equals(other.getStudyStoppingConfig())) return false;
    }
    if (!getAutomatedStoppingSpecCase().equals(other.getAutomatedStoppingSpecCase())) return false;
    switch (automatedStoppingSpecCase_) {
      case 4:
        if (!getDecayCurveStoppingSpec().equals(other.getDecayCurveStoppingSpec())) return false;
        break;
      case 5:
        if (!getMedianAutomatedStoppingSpec().equals(other.getMedianAutomatedStoppingSpec()))
          return false;
        break;
      case 9:
        if (!getConvexAutomatedStoppingSpec().equals(other.getConvexAutomatedStoppingSpec()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getMetricsCount() > 0) {
      hash = (37 * hash) + METRICS_FIELD_NUMBER;
      hash = (53 * hash) + getMetricsList().hashCode();
    }
    if (getParametersCount() > 0) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParametersList().hashCode();
    }
    hash = (37 * hash) + ALGORITHM_FIELD_NUMBER;
    hash = (53 * hash) + algorithm_;
    hash = (37 * hash) + OBSERVATION_NOISE_FIELD_NUMBER;
    hash = (53 * hash) + observationNoise_;
    hash = (37 * hash) + MEASUREMENT_SELECTION_TYPE_FIELD_NUMBER;
    hash = (53 * hash) + measurementSelectionType_;
    if (hasStudyStoppingConfig()) {
      hash = (37 * hash) + STUDY_STOPPING_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getStudyStoppingConfig().hashCode();
    }
    switch (automatedStoppingSpecCase_) {
      case 4:
        hash = (37 * hash) + DECAY_CURVE_STOPPING_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getDecayCurveStoppingSpec().hashCode();
        break;
      case 5:
        hash = (37 * hash) + MEDIAN_AUTOMATED_STOPPING_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getMedianAutomatedStoppingSpec().hashCode();
        break;
      case 9:
        hash = (37 * hash) + CONVEX_AUTOMATED_STOPPING_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getConvexAutomatedStoppingSpec().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.StudySpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.StudySpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.StudySpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.StudySpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.StudySpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.StudySpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.StudySpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.StudySpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.StudySpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.StudySpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.StudySpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.StudySpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.StudySpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Represents specification of a Study.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.StudySpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.StudySpec)
      com.google.cloud.aiplatform.v1.StudySpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_StudySpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_StudySpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.StudySpec.class,
              com.google.cloud.aiplatform.v1.StudySpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.StudySpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMetricsFieldBuilder();
        getParametersFieldBuilder();
        getStudyStoppingConfigFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (decayCurveStoppingSpecBuilder_ != null) {
        decayCurveStoppingSpecBuilder_.clear();
      }
      if (medianAutomatedStoppingSpecBuilder_ != null) {
        medianAutomatedStoppingSpecBuilder_.clear();
      }
      if (convexAutomatedStoppingSpecBuilder_ != null) {
        convexAutomatedStoppingSpecBuilder_.clear();
      }
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
      } else {
        metrics_ = null;
        metricsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
      } else {
        parameters_ = null;
        parametersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      algorithm_ = 0;
      observationNoise_ = 0;
      measurementSelectionType_ = 0;
      studyStoppingConfig_ = null;
      if (studyStoppingConfigBuilder_ != null) {
        studyStoppingConfigBuilder_.dispose();
        studyStoppingConfigBuilder_ = null;
      }
      automatedStoppingSpecCase_ = 0;
      automatedStoppingSpec_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.StudyProto
          .internal_static_google_cloud_aiplatform_v1_StudySpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.StudySpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec build() {
      com.google.cloud.aiplatform.v1.StudySpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec buildPartial() {
      com.google.cloud.aiplatform.v1.StudySpec result =
          new com.google.cloud.aiplatform.v1.StudySpec(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1.StudySpec result) {
      if (metricsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          metrics_ = java.util.Collections.unmodifiableList(metrics_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.metrics_ = metrics_;
      } else {
        result.metrics_ = metricsBuilder_.build();
      }
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          parameters_ = java.util.Collections.unmodifiableList(parameters_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.parameters_ = parameters_;
      } else {
        result.parameters_ = parametersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.StudySpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.algorithm_ = algorithm_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.observationNoise_ = observationNoise_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.measurementSelectionType_ = measurementSelectionType_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.studyStoppingConfig_ =
            studyStoppingConfigBuilder_ == null
                ? studyStoppingConfig_
                : studyStoppingConfigBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.StudySpec result) {
      result.automatedStoppingSpecCase_ = automatedStoppingSpecCase_;
      result.automatedStoppingSpec_ = this.automatedStoppingSpec_;
      if (automatedStoppingSpecCase_ == 4 && decayCurveStoppingSpecBuilder_ != null) {
        result.automatedStoppingSpec_ = decayCurveStoppingSpecBuilder_.build();
      }
      if (automatedStoppingSpecCase_ == 5 && medianAutomatedStoppingSpecBuilder_ != null) {
        result.automatedStoppingSpec_ = medianAutomatedStoppingSpecBuilder_.build();
      }
      if (automatedStoppingSpecCase_ == 9 && convexAutomatedStoppingSpecBuilder_ != null) {
        result.automatedStoppingSpec_ = convexAutomatedStoppingSpecBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.StudySpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1.StudySpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.StudySpec other) {
      if (other == com.google.cloud.aiplatform.v1.StudySpec.getDefaultInstance()) return this;
      if (metricsBuilder_ == null) {
        if (!other.metrics_.isEmpty()) {
          if (metrics_.isEmpty()) {
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureMetricsIsMutable();
            metrics_.addAll(other.metrics_);
          }
          onChanged();
        }
      } else {
        if (!other.metrics_.isEmpty()) {
          if (metricsBuilder_.isEmpty()) {
            metricsBuilder_.dispose();
            metricsBuilder_ = null;
            metrics_ = other.metrics_;
            bitField0_ = (bitField0_ & ~0x00000008);
            metricsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getMetricsFieldBuilder()
                    : null;
          } else {
            metricsBuilder_.addAllMessages(other.metrics_);
          }
        }
      }
      if (parametersBuilder_ == null) {
        if (!other.parameters_.isEmpty()) {
          if (parameters_.isEmpty()) {
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureParametersIsMutable();
            parameters_.addAll(other.parameters_);
          }
          onChanged();
        }
      } else {
        if (!other.parameters_.isEmpty()) {
          if (parametersBuilder_.isEmpty()) {
            parametersBuilder_.dispose();
            parametersBuilder_ = null;
            parameters_ = other.parameters_;
            bitField0_ = (bitField0_ & ~0x00000010);
            parametersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getParametersFieldBuilder()
                    : null;
          } else {
            parametersBuilder_.addAllMessages(other.parameters_);
          }
        }
      }
      if (other.algorithm_ != 0) {
        setAlgorithmValue(other.getAlgorithmValue());
      }
      if (other.observationNoise_ != 0) {
        setObservationNoiseValue(other.getObservationNoiseValue());
      }
      if (other.measurementSelectionType_ != 0) {
        setMeasurementSelectionTypeValue(other.getMeasurementSelectionTypeValue());
      }
      if (other.hasStudyStoppingConfig()) {
        mergeStudyStoppingConfig(other.getStudyStoppingConfig());
      }
      switch (other.getAutomatedStoppingSpecCase()) {
        case DECAY_CURVE_STOPPING_SPEC:
          {
            mergeDecayCurveStoppingSpec(other.getDecayCurveStoppingSpec());
            break;
          }
        case MEDIAN_AUTOMATED_STOPPING_SPEC:
          {
            mergeMedianAutomatedStoppingSpec(other.getMedianAutomatedStoppingSpec());
            break;
          }
        case CONVEX_AUTOMATED_STOPPING_SPEC:
          {
            mergeConvexAutomatedStoppingSpec(other.getConvexAutomatedStoppingSpec());
            break;
          }
        case AUTOMATEDSTOPPINGSPEC_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1.StudySpec.MetricSpec m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.parser(),
                        extensionRegistry);
                if (metricsBuilder_ == null) {
                  ensureMetricsIsMutable();
                  metrics_.add(m);
                } else {
                  metricsBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.parser(),
                        extensionRegistry);
                if (parametersBuilder_ == null) {
                  ensureParametersIsMutable();
                  parameters_.add(m);
                } else {
                  parametersBuilder_.addMessage(m);
                }
                break;
              } // case 18
            case 24:
              {
                algorithm_ = input.readEnum();
                bitField0_ |= 0x00000020;
                break;
              } // case 24
            case 34:
              {
                input.readMessage(
                    getDecayCurveStoppingSpecFieldBuilder().getBuilder(), extensionRegistry);
                automatedStoppingSpecCase_ = 4;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(
                    getMedianAutomatedStoppingSpecFieldBuilder().getBuilder(), extensionRegistry);
                automatedStoppingSpecCase_ = 5;
                break;
              } // case 42
            case 48:
              {
                observationNoise_ = input.readEnum();
                bitField0_ |= 0x00000040;
                break;
              } // case 48
            case 56:
              {
                measurementSelectionType_ = input.readEnum();
                bitField0_ |= 0x00000080;
                break;
              } // case 56
            case 74:
              {
                input.readMessage(
                    getConvexAutomatedStoppingSpecFieldBuilder().getBuilder(), extensionRegistry);
                automatedStoppingSpecCase_ = 9;
                break;
              } // case 74
            case 90:
              {
                input.readMessage(
                    getStudyStoppingConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int automatedStoppingSpecCase_ = 0;
    private java.lang.Object automatedStoppingSpec_;

    public AutomatedStoppingSpecCase getAutomatedStoppingSpecCase() {
      return AutomatedStoppingSpecCase.forNumber(automatedStoppingSpecCase_);
    }

    public Builder clearAutomatedStoppingSpec() {
      automatedStoppingSpecCase_ = 0;
      automatedStoppingSpec_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec,
            com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec.Builder,
            com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpecOrBuilder>
        decayCurveStoppingSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     *
     * @return Whether the decayCurveStoppingSpec field is set.
     */
    @java.lang.Override
    public boolean hasDecayCurveStoppingSpec() {
      return automatedStoppingSpecCase_ == 4;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     *
     * @return The decayCurveStoppingSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
        getDecayCurveStoppingSpec() {
      if (decayCurveStoppingSpecBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 4) {
          return (com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec)
              automatedStoppingSpec_;
        }
        return com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
            .getDefaultInstance();
      } else {
        if (automatedStoppingSpecCase_ == 4) {
          return decayCurveStoppingSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     */
    public Builder setDecayCurveStoppingSpec(
        com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec value) {
      if (decayCurveStoppingSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        automatedStoppingSpec_ = value;
        onChanged();
      } else {
        decayCurveStoppingSpecBuilder_.setMessage(value);
      }
      automatedStoppingSpecCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     */
    public Builder setDecayCurveStoppingSpec(
        com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec.Builder
            builderForValue) {
      if (decayCurveStoppingSpecBuilder_ == null) {
        automatedStoppingSpec_ = builderForValue.build();
        onChanged();
      } else {
        decayCurveStoppingSpecBuilder_.setMessage(builderForValue.build());
      }
      automatedStoppingSpecCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     */
    public Builder mergeDecayCurveStoppingSpec(
        com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec value) {
      if (decayCurveStoppingSpecBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 4
            && automatedStoppingSpec_
                != com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
                    .getDefaultInstance()) {
          automatedStoppingSpec_ =
              com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec)
                          automatedStoppingSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          automatedStoppingSpec_ = value;
        }
        onChanged();
      } else {
        if (automatedStoppingSpecCase_ == 4) {
          decayCurveStoppingSpecBuilder_.mergeFrom(value);
        } else {
          decayCurveStoppingSpecBuilder_.setMessage(value);
        }
      }
      automatedStoppingSpecCase_ = 4;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     */
    public Builder clearDecayCurveStoppingSpec() {
      if (decayCurveStoppingSpecBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 4) {
          automatedStoppingSpecCase_ = 0;
          automatedStoppingSpec_ = null;
          onChanged();
        }
      } else {
        if (automatedStoppingSpecCase_ == 4) {
          automatedStoppingSpecCase_ = 0;
          automatedStoppingSpec_ = null;
        }
        decayCurveStoppingSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec.Builder
        getDecayCurveStoppingSpecBuilder() {
      return getDecayCurveStoppingSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpecOrBuilder
        getDecayCurveStoppingSpecOrBuilder() {
      if ((automatedStoppingSpecCase_ == 4) && (decayCurveStoppingSpecBuilder_ != null)) {
        return decayCurveStoppingSpecBuilder_.getMessageOrBuilder();
      } else {
        if (automatedStoppingSpecCase_ == 4) {
          return (com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec)
              automatedStoppingSpec_;
        }
        return com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using decay curve rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec decay_curve_stopping_spec = 4;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec,
            com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec.Builder,
            com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpecOrBuilder>
        getDecayCurveStoppingSpecFieldBuilder() {
      if (decayCurveStoppingSpecBuilder_ == null) {
        if (!(automatedStoppingSpecCase_ == 4)) {
          automatedStoppingSpec_ =
              com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec
                  .getDefaultInstance();
        }
        decayCurveStoppingSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec,
                com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec.Builder,
                com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1.StudySpec.DecayCurveAutomatedStoppingSpec)
                    automatedStoppingSpec_,
                getParentForChildren(),
                isClean());
        automatedStoppingSpec_ = null;
      }
      automatedStoppingSpecCase_ = 4;
      onChanged();
      return decayCurveStoppingSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec,
            com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec.Builder,
            com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpecOrBuilder>
        medianAutomatedStoppingSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     *
     * @return Whether the medianAutomatedStoppingSpec field is set.
     */
    @java.lang.Override
    public boolean hasMedianAutomatedStoppingSpec() {
      return automatedStoppingSpecCase_ == 5;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     *
     * @return The medianAutomatedStoppingSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
        getMedianAutomatedStoppingSpec() {
      if (medianAutomatedStoppingSpecBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 5) {
          return (com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec)
              automatedStoppingSpec_;
        }
        return com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
            .getDefaultInstance();
      } else {
        if (automatedStoppingSpecCase_ == 5) {
          return medianAutomatedStoppingSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     */
    public Builder setMedianAutomatedStoppingSpec(
        com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec value) {
      if (medianAutomatedStoppingSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        automatedStoppingSpec_ = value;
        onChanged();
      } else {
        medianAutomatedStoppingSpecBuilder_.setMessage(value);
      }
      automatedStoppingSpecCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     */
    public Builder setMedianAutomatedStoppingSpec(
        com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec.Builder
            builderForValue) {
      if (medianAutomatedStoppingSpecBuilder_ == null) {
        automatedStoppingSpec_ = builderForValue.build();
        onChanged();
      } else {
        medianAutomatedStoppingSpecBuilder_.setMessage(builderForValue.build());
      }
      automatedStoppingSpecCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     */
    public Builder mergeMedianAutomatedStoppingSpec(
        com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec value) {
      if (medianAutomatedStoppingSpecBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 5
            && automatedStoppingSpec_
                != com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
                    .getDefaultInstance()) {
          automatedStoppingSpec_ =
              com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec)
                          automatedStoppingSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          automatedStoppingSpec_ = value;
        }
        onChanged();
      } else {
        if (automatedStoppingSpecCase_ == 5) {
          medianAutomatedStoppingSpecBuilder_.mergeFrom(value);
        } else {
          medianAutomatedStoppingSpecBuilder_.setMessage(value);
        }
      }
      automatedStoppingSpecCase_ = 5;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     */
    public Builder clearMedianAutomatedStoppingSpec() {
      if (medianAutomatedStoppingSpecBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 5) {
          automatedStoppingSpecCase_ = 0;
          automatedStoppingSpec_ = null;
          onChanged();
        }
      } else {
        if (automatedStoppingSpecCase_ == 5) {
          automatedStoppingSpecCase_ = 0;
          automatedStoppingSpec_ = null;
        }
        medianAutomatedStoppingSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec.Builder
        getMedianAutomatedStoppingSpecBuilder() {
      return getMedianAutomatedStoppingSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpecOrBuilder
        getMedianAutomatedStoppingSpecOrBuilder() {
      if ((automatedStoppingSpecCase_ == 5) && (medianAutomatedStoppingSpecBuilder_ != null)) {
        return medianAutomatedStoppingSpecBuilder_.getMessageOrBuilder();
      } else {
        if (automatedStoppingSpecCase_ == 5) {
          return (com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec)
              automatedStoppingSpec_;
        }
        return com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using median rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec median_automated_stopping_spec = 5;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec,
            com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec.Builder,
            com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpecOrBuilder>
        getMedianAutomatedStoppingSpecFieldBuilder() {
      if (medianAutomatedStoppingSpecBuilder_ == null) {
        if (!(automatedStoppingSpecCase_ == 5)) {
          automatedStoppingSpec_ =
              com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec
                  .getDefaultInstance();
        }
        medianAutomatedStoppingSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec,
                com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec.Builder,
                com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1.StudySpec.MedianAutomatedStoppingSpec)
                    automatedStoppingSpec_,
                getParentForChildren(),
                isClean());
        automatedStoppingSpec_ = null;
      }
      automatedStoppingSpecCase_ = 5;
      onChanged();
      return medianAutomatedStoppingSpecBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec,
            com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec.Builder,
            com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpecOrBuilder>
        convexAutomatedStoppingSpecBuilder_;
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec convex_automated_stopping_spec = 9;
     * </code>
     *
     * @return Whether the convexAutomatedStoppingSpec field is set.
     */
    @java.lang.Override
    public boolean hasConvexAutomatedStoppingSpec() {
      return automatedStoppingSpecCase_ == 9;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec convex_automated_stopping_spec = 9;
     * </code>
     *
     * @return The convexAutomatedStoppingSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
        getConvexAutomatedStoppingSpec() {
      if (convexAutomatedStoppingSpecBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 9) {
          return (com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec)
              automatedStoppingSpec_;
        }
        return com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
            .getDefaultInstance();
      } else {
        if (automatedStoppingSpecCase_ == 9) {
          return convexAutomatedStoppingSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec convex_automated_stopping_spec = 9;
     * </code>
     */
    public Builder setConvexAutomatedStoppingSpec(
        com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec value) {
      if (convexAutomatedStoppingSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        automatedStoppingSpec_ = value;
        onChanged();
      } else {
        convexAutomatedStoppingSpecBuilder_.setMessage(value);
      }
      automatedStoppingSpecCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec convex_automated_stopping_spec = 9;
     * </code>
     */
    public Builder setConvexAutomatedStoppingSpec(
        com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec.Builder
            builderForValue) {
      if (convexAutomatedStoppingSpecBuilder_ == null) {
        automatedStoppingSpec_ = builderForValue.build();
        onChanged();
      } else {
        convexAutomatedStoppingSpecBuilder_.setMessage(builderForValue.build());
      }
      automatedStoppingSpecCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec convex_automated_stopping_spec = 9;
     * </code>
     */
    public Builder mergeConvexAutomatedStoppingSpec(
        com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec value) {
      if (convexAutomatedStoppingSpecBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 9
            && automatedStoppingSpec_
                != com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
                    .getDefaultInstance()) {
          automatedStoppingSpec_ =
              com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec)
                          automatedStoppingSpec_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          automatedStoppingSpec_ = value;
        }
        onChanged();
      } else {
        if (automatedStoppingSpecCase_ == 9) {
          convexAutomatedStoppingSpecBuilder_.mergeFrom(value);
        } else {
          convexAutomatedStoppingSpecBuilder_.setMessage(value);
        }
      }
      automatedStoppingSpecCase_ = 9;
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec convex_automated_stopping_spec = 9;
     * </code>
     */
    public Builder clearConvexAutomatedStoppingSpec() {
      if (convexAutomatedStoppingSpecBuilder_ == null) {
        if (automatedStoppingSpecCase_ == 9) {
          automatedStoppingSpecCase_ = 0;
          automatedStoppingSpec_ = null;
          onChanged();
        }
      } else {
        if (automatedStoppingSpecCase_ == 9) {
          automatedStoppingSpecCase_ = 0;
          automatedStoppingSpec_ = null;
        }
        convexAutomatedStoppingSpecBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec convex_automated_stopping_spec = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec.Builder
        getConvexAutomatedStoppingSpecBuilder() {
      return getConvexAutomatedStoppingSpecFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec convex_automated_stopping_spec = 9;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpecOrBuilder
        getConvexAutomatedStoppingSpecOrBuilder() {
      if ((automatedStoppingSpecCase_ == 9) && (convexAutomatedStoppingSpecBuilder_ != null)) {
        return convexAutomatedStoppingSpecBuilder_.getMessageOrBuilder();
      } else {
        if (automatedStoppingSpecCase_ == 9) {
          return (com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec)
              automatedStoppingSpec_;
        }
        return com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
            .getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * The automated early stopping spec using convex stopping rule.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec convex_automated_stopping_spec = 9;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec,
            com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec.Builder,
            com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpecOrBuilder>
        getConvexAutomatedStoppingSpecFieldBuilder() {
      if (convexAutomatedStoppingSpecBuilder_ == null) {
        if (!(automatedStoppingSpecCase_ == 9)) {
          automatedStoppingSpec_ =
              com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec
                  .getDefaultInstance();
        }
        convexAutomatedStoppingSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec,
                com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec.Builder,
                com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1.StudySpec.ConvexAutomatedStoppingSpec)
                    automatedStoppingSpec_,
                getParentForChildren(),
                isClean());
        automatedStoppingSpec_ = null;
      }
      automatedStoppingSpecCase_ = 9;
      onChanged();
      return convexAutomatedStoppingSpecBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.StudySpec.MetricSpec> metrics_ =
        java.util.Collections.emptyList();

    private void ensureMetricsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        metrics_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.StudySpec.MetricSpec>(metrics_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.StudySpec.MetricSpec,
            com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.Builder,
            com.google.cloud.aiplatform.v1.StudySpec.MetricSpecOrBuilder>
        metricsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.StudySpec.MetricSpec> getMetricsList() {
      if (metricsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(metrics_);
      } else {
        return metricsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getMetricsCount() {
      if (metricsBuilder_ == null) {
        return metrics_.size();
      } else {
        return metricsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec getMetrics(int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMetrics(
        int index, com.google.cloud.aiplatform.v1.StudySpec.MetricSpec value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.set(index, value);
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setMetrics(
        int index, com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.set(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(com.google.cloud.aiplatform.v1.StudySpec.MetricSpec value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(
        int index, com.google.cloud.aiplatform.v1.StudySpec.MetricSpec value) {
      if (metricsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureMetricsIsMutable();
        metrics_.add(index, value);
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(
        com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addMetrics(
        int index, com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.Builder builderForValue) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.add(index, builderForValue.build());
        onChanged();
      } else {
        metricsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllMetrics(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.StudySpec.MetricSpec> values) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, metrics_);
        onChanged();
      } else {
        metricsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearMetrics() {
      if (metricsBuilder_ == null) {
        metrics_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        metricsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeMetrics(int index) {
      if (metricsBuilder_ == null) {
        ensureMetricsIsMutable();
        metrics_.remove(index);
        onChanged();
      } else {
        metricsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.Builder getMetricsBuilder(
        int index) {
      return getMetricsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.StudySpec.MetricSpecOrBuilder getMetricsOrBuilder(
        int index) {
      if (metricsBuilder_ == null) {
        return metrics_.get(index);
      } else {
        return metricsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.StudySpec.MetricSpecOrBuilder>
        getMetricsOrBuilderList() {
      if (metricsBuilder_ != null) {
        return metricsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(metrics_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.Builder addMetricsBuilder() {
      return getMetricsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.Builder addMetricsBuilder(
        int index) {
      return getMetricsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. Metric specs for the Study.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.MetricSpec metrics = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.Builder>
        getMetricsBuilderList() {
      return getMetricsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.StudySpec.MetricSpec,
            com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.Builder,
            com.google.cloud.aiplatform.v1.StudySpec.MetricSpecOrBuilder>
        getMetricsFieldBuilder() {
      if (metricsBuilder_ == null) {
        metricsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.StudySpec.MetricSpec,
                com.google.cloud.aiplatform.v1.StudySpec.MetricSpec.Builder,
                com.google.cloud.aiplatform.v1.StudySpec.MetricSpecOrBuilder>(
                metrics_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        metrics_ = null;
      }
      return metricsBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec> parameters_ =
        java.util.Collections.emptyList();

    private void ensureParametersIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        parameters_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec>(
                parameters_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec,
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder,
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpecOrBuilder>
        parametersBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec>
        getParametersList() {
      if (parametersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(parameters_);
      } else {
        return parametersBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getParametersCount() {
      if (parametersBuilder_ == null) {
        return parameters_.size();
      } else {
        return parametersBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec getParameters(int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setParameters(
        int index, com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.set(index, value);
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setParameters(
        int index, com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.set(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addParameters(com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addParameters(
        int index, com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureParametersIsMutable();
        parameters_.add(index, value);
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addParameters(
        com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addParameters(
        int index, com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder builderForValue) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.add(index, builderForValue.build());
        onChanged();
      } else {
        parametersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllParameters(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec>
            values) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, parameters_);
        onChanged();
      } else {
        parametersBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearParameters() {
      if (parametersBuilder_ == null) {
        parameters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        parametersBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeParameters(int index) {
      if (parametersBuilder_ == null) {
        ensureParametersIsMutable();
        parameters_.remove(index);
        onChanged();
      } else {
        parametersBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder getParametersBuilder(
        int index) {
      return getParametersFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpecOrBuilder getParametersOrBuilder(
        int index) {
      if (parametersBuilder_ == null) {
        return parameters_.get(index);
      } else {
        return parametersBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.StudySpec.ParameterSpecOrBuilder>
        getParametersOrBuilderList() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(parameters_);
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder addParametersBuilder() {
      return getParametersFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder addParametersBuilder(
        int index) {
      return getParametersFieldBuilder()
          .addBuilder(
              index, com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Required. The set of parameters to tune.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.StudySpec.ParameterSpec parameters = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder>
        getParametersBuilderList() {
      return getParametersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec,
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder,
            com.google.cloud.aiplatform.v1.StudySpec.ParameterSpecOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpec.Builder,
                com.google.cloud.aiplatform.v1.StudySpec.ParameterSpecOrBuilder>(
                parameters_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    private int algorithm_ = 0;
    /**
     *
     *
     * <pre>
     * The search algorithm specified for the Study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudySpec.Algorithm algorithm = 3;</code>
     *
     * @return The enum numeric value on the wire for algorithm.
     */
    @java.lang.Override
    public int getAlgorithmValue() {
      return algorithm_;
    }
    /**
     *
     *
     * <pre>
     * The search algorithm specified for the Study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudySpec.Algorithm algorithm = 3;</code>
     *
     * @param value The enum numeric value on the wire for algorithm to set.
     * @return This builder for chaining.
     */
    public Builder setAlgorithmValue(int value) {
      algorithm_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The search algorithm specified for the Study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudySpec.Algorithm algorithm = 3;</code>
     *
     * @return The algorithm.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.Algorithm getAlgorithm() {
      com.google.cloud.aiplatform.v1.StudySpec.Algorithm result =
          com.google.cloud.aiplatform.v1.StudySpec.Algorithm.forNumber(algorithm_);
      return result == null
          ? com.google.cloud.aiplatform.v1.StudySpec.Algorithm.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The search algorithm specified for the Study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudySpec.Algorithm algorithm = 3;</code>
     *
     * @param value The algorithm to set.
     * @return This builder for chaining.
     */
    public Builder setAlgorithm(com.google.cloud.aiplatform.v1.StudySpec.Algorithm value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      algorithm_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The search algorithm specified for the Study.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudySpec.Algorithm algorithm = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAlgorithm() {
      bitField0_ = (bitField0_ & ~0x00000020);
      algorithm_ = 0;
      onChanged();
      return this;
    }

    private int observationNoise_ = 0;
    /**
     *
     *
     * <pre>
     * The observation noise level of the study.
     * Currently only supported by the Vertex AI Vizier service. Not supported by
     * HyperparameterTuningJob or TrainingPipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudySpec.ObservationNoise observation_noise = 6;</code>
     *
     * @return The enum numeric value on the wire for observationNoise.
     */
    @java.lang.Override
    public int getObservationNoiseValue() {
      return observationNoise_;
    }
    /**
     *
     *
     * <pre>
     * The observation noise level of the study.
     * Currently only supported by the Vertex AI Vizier service. Not supported by
     * HyperparameterTuningJob or TrainingPipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudySpec.ObservationNoise observation_noise = 6;</code>
     *
     * @param value The enum numeric value on the wire for observationNoise to set.
     * @return This builder for chaining.
     */
    public Builder setObservationNoiseValue(int value) {
      observationNoise_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The observation noise level of the study.
     * Currently only supported by the Vertex AI Vizier service. Not supported by
     * HyperparameterTuningJob or TrainingPipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudySpec.ObservationNoise observation_noise = 6;</code>
     *
     * @return The observationNoise.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.ObservationNoise getObservationNoise() {
      com.google.cloud.aiplatform.v1.StudySpec.ObservationNoise result =
          com.google.cloud.aiplatform.v1.StudySpec.ObservationNoise.forNumber(observationNoise_);
      return result == null
          ? com.google.cloud.aiplatform.v1.StudySpec.ObservationNoise.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * The observation noise level of the study.
     * Currently only supported by the Vertex AI Vizier service. Not supported by
     * HyperparameterTuningJob or TrainingPipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudySpec.ObservationNoise observation_noise = 6;</code>
     *
     * @param value The observationNoise to set.
     * @return This builder for chaining.
     */
    public Builder setObservationNoise(
        com.google.cloud.aiplatform.v1.StudySpec.ObservationNoise value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000040;
      observationNoise_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * The observation noise level of the study.
     * Currently only supported by the Vertex AI Vizier service. Not supported by
     * HyperparameterTuningJob or TrainingPipeline.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.StudySpec.ObservationNoise observation_noise = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearObservationNoise() {
      bitField0_ = (bitField0_ & ~0x00000040);
      observationNoise_ = 0;
      onChanged();
      return this;
    }

    private int measurementSelectionType_ = 0;
    /**
     *
     *
     * <pre>
     * Describe which measurement selection type will be used
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType measurement_selection_type = 7;
     * </code>
     *
     * @return The enum numeric value on the wire for measurementSelectionType.
     */
    @java.lang.Override
    public int getMeasurementSelectionTypeValue() {
      return measurementSelectionType_;
    }
    /**
     *
     *
     * <pre>
     * Describe which measurement selection type will be used
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType measurement_selection_type = 7;
     * </code>
     *
     * @param value The enum numeric value on the wire for measurementSelectionType to set.
     * @return This builder for chaining.
     */
    public Builder setMeasurementSelectionTypeValue(int value) {
      measurementSelectionType_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describe which measurement selection type will be used
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType measurement_selection_type = 7;
     * </code>
     *
     * @return The measurementSelectionType.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType
        getMeasurementSelectionType() {
      com.google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType result =
          com.google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType.forNumber(
              measurementSelectionType_);
      return result == null
          ? com.google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Describe which measurement selection type will be used
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType measurement_selection_type = 7;
     * </code>
     *
     * @param value The measurementSelectionType to set.
     * @return This builder for chaining.
     */
    public Builder setMeasurementSelectionType(
        com.google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000080;
      measurementSelectionType_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Describe which measurement selection type will be used
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.StudySpec.MeasurementSelectionType measurement_selection_type = 7;
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMeasurementSelectionType() {
      bitField0_ = (bitField0_ & ~0x00000080);
      measurementSelectionType_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig studyStoppingConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig,
            com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig.Builder,
            com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfigOrBuilder>
        studyStoppingConfigBuilder_;
    /**
     *
     *
     * <pre>
     * Conditions for automated stopping of a Study. Enable automated stopping by
     * configuring at least one condition.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig study_stopping_config = 11;
     * </code>
     *
     * @return Whether the studyStoppingConfig field is set.
     */
    public boolean hasStudyStoppingConfig() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * Conditions for automated stopping of a Study. Enable automated stopping by
     * configuring at least one condition.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig study_stopping_config = 11;
     * </code>
     *
     * @return The studyStoppingConfig.
     */
    public com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig getStudyStoppingConfig() {
      if (studyStoppingConfigBuilder_ == null) {
        return studyStoppingConfig_ == null
            ? com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig.getDefaultInstance()
            : studyStoppingConfig_;
      } else {
        return studyStoppingConfigBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Conditions for automated stopping of a Study. Enable automated stopping by
     * configuring at least one condition.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig study_stopping_config = 11;
     * </code>
     */
    public Builder setStudyStoppingConfig(
        com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig value) {
      if (studyStoppingConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        studyStoppingConfig_ = value;
      } else {
        studyStoppingConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conditions for automated stopping of a Study. Enable automated stopping by
     * configuring at least one condition.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig study_stopping_config = 11;
     * </code>
     */
    public Builder setStudyStoppingConfig(
        com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig.Builder builderForValue) {
      if (studyStoppingConfigBuilder_ == null) {
        studyStoppingConfig_ = builderForValue.build();
      } else {
        studyStoppingConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conditions for automated stopping of a Study. Enable automated stopping by
     * configuring at least one condition.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig study_stopping_config = 11;
     * </code>
     */
    public Builder mergeStudyStoppingConfig(
        com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig value) {
      if (studyStoppingConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && studyStoppingConfig_ != null
            && studyStoppingConfig_
                != com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig
                    .getDefaultInstance()) {
          getStudyStoppingConfigBuilder().mergeFrom(value);
        } else {
          studyStoppingConfig_ = value;
        }
      } else {
        studyStoppingConfigBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conditions for automated stopping of a Study. Enable automated stopping by
     * configuring at least one condition.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig study_stopping_config = 11;
     * </code>
     */
    public Builder clearStudyStoppingConfig() {
      bitField0_ = (bitField0_ & ~0x00000100);
      studyStoppingConfig_ = null;
      if (studyStoppingConfigBuilder_ != null) {
        studyStoppingConfigBuilder_.dispose();
        studyStoppingConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Conditions for automated stopping of a Study. Enable automated stopping by
     * configuring at least one condition.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig study_stopping_config = 11;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig.Builder
        getStudyStoppingConfigBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getStudyStoppingConfigFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Conditions for automated stopping of a Study. Enable automated stopping by
     * configuring at least one condition.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig study_stopping_config = 11;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfigOrBuilder
        getStudyStoppingConfigOrBuilder() {
      if (studyStoppingConfigBuilder_ != null) {
        return studyStoppingConfigBuilder_.getMessageOrBuilder();
      } else {
        return studyStoppingConfig_ == null
            ? com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig.getDefaultInstance()
            : studyStoppingConfig_;
      }
    }
    /**
     *
     *
     * <pre>
     * Conditions for automated stopping of a Study. Enable automated stopping by
     * configuring at least one condition.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig study_stopping_config = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig,
            com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig.Builder,
            com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfigOrBuilder>
        getStudyStoppingConfigFieldBuilder() {
      if (studyStoppingConfigBuilder_ == null) {
        studyStoppingConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig,
                com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfig.Builder,
                com.google.cloud.aiplatform.v1.StudySpec.StudyStoppingConfigOrBuilder>(
                getStudyStoppingConfig(), getParentForChildren(), isClean());
        studyStoppingConfig_ = null;
      }
      return studyStoppingConfigBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.StudySpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.StudySpec)
  private static final com.google.cloud.aiplatform.v1.StudySpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.StudySpec();
  }

  public static com.google.cloud.aiplatform.v1.StudySpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<StudySpec> PARSER =
      new com.google.protobuf.AbstractParser<StudySpec>() {
        @java.lang.Override
        public StudySpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<StudySpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<StudySpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.StudySpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
