/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/endpoint_service.proto

package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Request message for
 * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.UndeployModelRequest}
 */
public final class UndeployModelRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.UndeployModelRequest)
    UndeployModelRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UndeployModelRequest.newBuilder() to construct.
  private UndeployModelRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UndeployModelRequest() {
    endpoint_ = "";
    deployedModelId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UndeployModelRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.EndpointServiceProto
        .internal_static_google_cloud_aiplatform_v1_UndeployModelRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapField internalGetMapField(int number) {
    switch (number) {
      case 3:
        return internalGetTrafficSplit();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.EndpointServiceProto
        .internal_static_google_cloud_aiplatform_v1_UndeployModelRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.UndeployModelRequest.class,
            com.google.cloud.aiplatform.v1.UndeployModelRequest.Builder.class);
  }

  public static final int ENDPOINT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object endpoint_ = "";
  /**
   *
   *
   * <pre>
   * Required. The name of the Endpoint resource from which to undeploy a Model.
   * Format:
   * `projects/{project}/locations/{location}/endpoints/{endpoint}`
   * </pre>
   *
   * <code>
   * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The endpoint.
   */
  @java.lang.Override
  public java.lang.String getEndpoint() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      endpoint_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The name of the Endpoint resource from which to undeploy a Model.
   * Format:
   * `projects/{project}/locations/{location}/endpoints/{endpoint}`
   * </pre>
   *
   * <code>
   * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for endpoint.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEndpointBytes() {
    java.lang.Object ref = endpoint_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      endpoint_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEPLOYED_MODEL_ID_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deployedModelId_ = "";
  /**
   *
   *
   * <pre>
   * Required. The ID of the DeployedModel to be undeployed from the Endpoint.
   * </pre>
   *
   * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The deployedModelId.
   */
  @java.lang.Override
  public java.lang.String getDeployedModelId() {
    java.lang.Object ref = deployedModelId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deployedModelId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Required. The ID of the DeployedModel to be undeployed from the Endpoint.
   * </pre>
   *
   * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for deployedModelId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeployedModelIdBytes() {
    java.lang.Object ref = deployedModelId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deployedModelId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TRAFFIC_SPLIT_FIELD_NUMBER = 3;

  private static final class TrafficSplitDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.Integer>newDefaultInstance(
            com.google.cloud.aiplatform.v1.EndpointServiceProto
                .internal_static_google_cloud_aiplatform_v1_UndeployModelRequest_TrafficSplitEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.INT32,
            0);
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> trafficSplit_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
      internalGetTrafficSplit() {
    if (trafficSplit_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          TrafficSplitDefaultEntryHolder.defaultEntry);
    }
    return trafficSplit_;
  }

  public int getTrafficSplitCount() {
    return internalGetTrafficSplit().getMap().size();
  }
  /**
   *
   *
   * <pre>
   * If this field is provided, then the Endpoint's
   * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
   * overwritten with it. If last DeployedModel is being undeployed from the
   * Endpoint, the [Endpoint.traffic_split] will always end up empty when this
   * call returns. A DeployedModel will be successfully undeployed only if it
   * doesn't have any traffic assigned to it when this method executes, or if
   * this field unassigns any traffic to it.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
   */
  @java.lang.Override
  public boolean containsTrafficSplit(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetTrafficSplit().getMap().containsKey(key);
  }
  /** Use {@link #getTrafficSplitMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.Integer> getTrafficSplit() {
    return getTrafficSplitMap();
  }
  /**
   *
   *
   * <pre>
   * If this field is provided, then the Endpoint's
   * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
   * overwritten with it. If last DeployedModel is being undeployed from the
   * Endpoint, the [Endpoint.traffic_split] will always end up empty when this
   * call returns. A DeployedModel will be successfully undeployed only if it
   * doesn't have any traffic assigned to it when this method executes, or if
   * this field unassigns any traffic to it.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.Integer> getTrafficSplitMap() {
    return internalGetTrafficSplit().getMap();
  }
  /**
   *
   *
   * <pre>
   * If this field is provided, then the Endpoint's
   * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
   * overwritten with it. If last DeployedModel is being undeployed from the
   * Endpoint, the [Endpoint.traffic_split] will always end up empty when this
   * call returns. A DeployedModel will be successfully undeployed only if it
   * doesn't have any traffic assigned to it when this method executes, or if
   * this field unassigns any traffic to it.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
   */
  @java.lang.Override
  public int getTrafficSplitOrDefault(java.lang.String key, int defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetTrafficSplit().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }
  /**
   *
   *
   * <pre>
   * If this field is provided, then the Endpoint's
   * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
   * overwritten with it. If last DeployedModel is being undeployed from the
   * Endpoint, the [Endpoint.traffic_split] will always end up empty when this
   * call returns. A DeployedModel will be successfully undeployed only if it
   * doesn't have any traffic assigned to it when this method executes, or if
   * this field unassigns any traffic to it.
   * </pre>
   *
   * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
   */
  @java.lang.Override
  public int getTrafficSplitOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.Integer> map = internalGetTrafficSplit().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, endpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployedModelId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, deployedModelId_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetTrafficSplit(), TrafficSplitDefaultEntryHolder.defaultEntry, 3);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, endpoint_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(deployedModelId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, deployedModelId_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.Integer> entry :
        internalGetTrafficSplit().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> trafficSplit__ =
          TrafficSplitDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, trafficSplit__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.UndeployModelRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.UndeployModelRequest other =
        (com.google.cloud.aiplatform.v1.UndeployModelRequest) obj;

    if (!getEndpoint().equals(other.getEndpoint())) return false;
    if (!getDeployedModelId().equals(other.getDeployedModelId())) return false;
    if (!internalGetTrafficSplit().equals(other.internalGetTrafficSplit())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
    hash = (53 * hash) + getEndpoint().hashCode();
    hash = (37 * hash) + DEPLOYED_MODEL_ID_FIELD_NUMBER;
    hash = (53 * hash) + getDeployedModelId().hashCode();
    if (!internalGetTrafficSplit().getMap().isEmpty()) {
      hash = (37 * hash) + TRAFFIC_SPLIT_FIELD_NUMBER;
      hash = (53 * hash) + internalGetTrafficSplit().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.UndeployModelRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.UndeployModelRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.UndeployModelRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.UndeployModelRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.UndeployModelRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.UndeployModelRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.UndeployModelRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.UndeployModelRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.UndeployModelRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.UndeployModelRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.UndeployModelRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.UndeployModelRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.UndeployModelRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Request message for
   * [EndpointService.UndeployModel][google.cloud.aiplatform.v1.EndpointService.UndeployModel].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.UndeployModelRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.UndeployModelRequest)
      com.google.cloud.aiplatform.v1.UndeployModelRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.EndpointServiceProto
          .internal_static_google_cloud_aiplatform_v1_UndeployModelRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMapField(int number) {
      switch (number) {
        case 3:
          return internalGetTrafficSplit();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapField internalGetMutableMapField(int number) {
      switch (number) {
        case 3:
          return internalGetMutableTrafficSplit();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.EndpointServiceProto
          .internal_static_google_cloud_aiplatform_v1_UndeployModelRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.UndeployModelRequest.class,
              com.google.cloud.aiplatform.v1.UndeployModelRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.UndeployModelRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      endpoint_ = "";
      deployedModelId_ = "";
      internalGetMutableTrafficSplit().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.EndpointServiceProto
          .internal_static_google_cloud_aiplatform_v1_UndeployModelRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.UndeployModelRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.UndeployModelRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.UndeployModelRequest build() {
      com.google.cloud.aiplatform.v1.UndeployModelRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.UndeployModelRequest buildPartial() {
      com.google.cloud.aiplatform.v1.UndeployModelRequest result =
          new com.google.cloud.aiplatform.v1.UndeployModelRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.UndeployModelRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.endpoint_ = endpoint_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.deployedModelId_ = deployedModelId_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.trafficSplit_ = internalGetTrafficSplit();
        result.trafficSplit_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.UndeployModelRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1.UndeployModelRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.UndeployModelRequest other) {
      if (other == com.google.cloud.aiplatform.v1.UndeployModelRequest.getDefaultInstance())
        return this;
      if (!other.getEndpoint().isEmpty()) {
        endpoint_ = other.endpoint_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDeployedModelId().isEmpty()) {
        deployedModelId_ = other.deployedModelId_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      internalGetMutableTrafficSplit().mergeFrom(other.internalGetTrafficSplit());
      bitField0_ |= 0x00000004;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                endpoint_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                deployedModelId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.Integer> trafficSplit__ =
                    input.readMessage(
                        TrafficSplitDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableTrafficSplit()
                    .getMutableMap()
                    .put(trafficSplit__.getKey(), trafficSplit__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object endpoint_ = "";
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint resource from which to undeploy a Model.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The endpoint.
     */
    public java.lang.String getEndpoint() {
      java.lang.Object ref = endpoint_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpoint_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint resource from which to undeploy a Model.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for endpoint.
     */
    public com.google.protobuf.ByteString getEndpointBytes() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint resource from which to undeploy a Model.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpoint(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      endpoint_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint resource from which to undeploy a Model.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEndpoint() {
      endpoint_ = getDefaultInstance().getEndpoint();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The name of the Endpoint resource from which to undeploy a Model.
     * Format:
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for endpoint to set.
     * @return This builder for chaining.
     */
    public Builder setEndpointBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      endpoint_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object deployedModelId_ = "";
    /**
     *
     *
     * <pre>
     * Required. The ID of the DeployedModel to be undeployed from the Endpoint.
     * </pre>
     *
     * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The deployedModelId.
     */
    public java.lang.String getDeployedModelId() {
      java.lang.Object ref = deployedModelId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deployedModelId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the DeployedModel to be undeployed from the Endpoint.
     * </pre>
     *
     * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for deployedModelId.
     */
    public com.google.protobuf.ByteString getDeployedModelIdBytes() {
      java.lang.Object ref = deployedModelId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deployedModelId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the DeployedModel to be undeployed from the Endpoint.
     * </pre>
     *
     * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The deployedModelId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployedModelId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deployedModelId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the DeployedModel to be undeployed from the Endpoint.
     * </pre>
     *
     * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeployedModelId() {
      deployedModelId_ = getDefaultInstance().getDeployedModelId();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The ID of the DeployedModel to be undeployed from the Endpoint.
     * </pre>
     *
     * <code>string deployed_model_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for deployedModelId to set.
     * @return This builder for chaining.
     */
    public Builder setDeployedModelIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deployedModelId_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer> trafficSplit_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetTrafficSplit() {
      if (trafficSplit_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            TrafficSplitDefaultEntryHolder.defaultEntry);
      }
      return trafficSplit_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.Integer>
        internalGetMutableTrafficSplit() {
      if (trafficSplit_ == null) {
        trafficSplit_ =
            com.google.protobuf.MapField.newMapField(TrafficSplitDefaultEntryHolder.defaultEntry);
      }
      if (!trafficSplit_.isMutable()) {
        trafficSplit_ = trafficSplit_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return trafficSplit_;
    }

    public int getTrafficSplitCount() {
      return internalGetTrafficSplit().getMap().size();
    }
    /**
     *
     *
     * <pre>
     * If this field is provided, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
     * overwritten with it. If last DeployedModel is being undeployed from the
     * Endpoint, the [Endpoint.traffic_split] will always end up empty when this
     * call returns. A DeployedModel will be successfully undeployed only if it
     * doesn't have any traffic assigned to it when this method executes, or if
     * this field unassigns any traffic to it.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
     */
    @java.lang.Override
    public boolean containsTrafficSplit(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetTrafficSplit().getMap().containsKey(key);
    }
    /** Use {@link #getTrafficSplitMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getTrafficSplit() {
      return getTrafficSplitMap();
    }
    /**
     *
     *
     * <pre>
     * If this field is provided, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
     * overwritten with it. If last DeployedModel is being undeployed from the
     * Endpoint, the [Endpoint.traffic_split] will always end up empty when this
     * call returns. A DeployedModel will be successfully undeployed only if it
     * doesn't have any traffic assigned to it when this method executes, or if
     * this field unassigns any traffic to it.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.Integer> getTrafficSplitMap() {
      return internalGetTrafficSplit().getMap();
    }
    /**
     *
     *
     * <pre>
     * If this field is provided, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
     * overwritten with it. If last DeployedModel is being undeployed from the
     * Endpoint, the [Endpoint.traffic_split] will always end up empty when this
     * call returns. A DeployedModel will be successfully undeployed only if it
     * doesn't have any traffic assigned to it when this method executes, or if
     * this field unassigns any traffic to it.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
     */
    @java.lang.Override
    public int getTrafficSplitOrDefault(java.lang.String key, int defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map = internalGetTrafficSplit().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }
    /**
     *
     *
     * <pre>
     * If this field is provided, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
     * overwritten with it. If last DeployedModel is being undeployed from the
     * Endpoint, the [Endpoint.traffic_split] will always end up empty when this
     * call returns. A DeployedModel will be successfully undeployed only if it
     * doesn't have any traffic assigned to it when this method executes, or if
     * this field unassigns any traffic to it.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
     */
    @java.lang.Override
    public int getTrafficSplitOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.Integer> map = internalGetTrafficSplit().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearTrafficSplit() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableTrafficSplit().getMutableMap().clear();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this field is provided, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
     * overwritten with it. If last DeployedModel is being undeployed from the
     * Endpoint, the [Endpoint.traffic_split] will always end up empty when this
     * call returns. A DeployedModel will be successfully undeployed only if it
     * doesn't have any traffic assigned to it when this method executes, or if
     * this field unassigns any traffic to it.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
     */
    public Builder removeTrafficSplit(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableTrafficSplit().getMutableMap().remove(key);
      return this;
    }
    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.Integer> getMutableTrafficSplit() {
      bitField0_ |= 0x00000004;
      return internalGetMutableTrafficSplit().getMutableMap();
    }
    /**
     *
     *
     * <pre>
     * If this field is provided, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
     * overwritten with it. If last DeployedModel is being undeployed from the
     * Endpoint, the [Endpoint.traffic_split] will always end up empty when this
     * call returns. A DeployedModel will be successfully undeployed only if it
     * doesn't have any traffic assigned to it when this method executes, or if
     * this field unassigns any traffic to it.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
     */
    public Builder putTrafficSplit(java.lang.String key, int value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }

      internalGetMutableTrafficSplit().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }
    /**
     *
     *
     * <pre>
     * If this field is provided, then the Endpoint's
     * [traffic_split][google.cloud.aiplatform.v1.Endpoint.traffic_split] will be
     * overwritten with it. If last DeployedModel is being undeployed from the
     * Endpoint, the [Endpoint.traffic_split] will always end up empty when this
     * call returns. A DeployedModel will be successfully undeployed only if it
     * doesn't have any traffic assigned to it when this method executes, or if
     * this field unassigns any traffic to it.
     * </pre>
     *
     * <code>map&lt;string, int32&gt; traffic_split = 3;</code>
     */
    public Builder putAllTrafficSplit(java.util.Map<java.lang.String, java.lang.Integer> values) {
      internalGetMutableTrafficSplit().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.UndeployModelRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.UndeployModelRequest)
  private static final com.google.cloud.aiplatform.v1.UndeployModelRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.UndeployModelRequest();
  }

  public static com.google.cloud.aiplatform.v1.UndeployModelRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UndeployModelRequest> PARSER =
      new com.google.protobuf.AbstractParser<UndeployModelRequest>() {
        @java.lang.Override
        public UndeployModelRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UndeployModelRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UndeployModelRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.UndeployModelRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
