/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/index_endpoint.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Used to set up the auth on the DeployedIndex's private endpoint.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.DeployedIndexAuthConfig}
 */
public final class DeployedIndexAuthConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.DeployedIndexAuthConfig)
    DeployedIndexAuthConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use DeployedIndexAuthConfig.newBuilder() to construct.
  private DeployedIndexAuthConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DeployedIndexAuthConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DeployedIndexAuthConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.IndexEndpointProto
        .internal_static_google_cloud_aiplatform_v1_DeployedIndexAuthConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.IndexEndpointProto
        .internal_static_google_cloud_aiplatform_v1_DeployedIndexAuthConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.class,
            com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.Builder.class);
  }

  public interface AuthProviderOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The list of JWT
     * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
     * that are allowed to access. A JWT containing any of these audiences will
     * be accepted.
     * </pre>
     *
     * <code>repeated string audiences = 1;</code>
     *
     * @return A list containing the audiences.
     */
    java.util.List<java.lang.String> getAudiencesList();

    /**
     *
     *
     * <pre>
     * The list of JWT
     * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
     * that are allowed to access. A JWT containing any of these audiences will
     * be accepted.
     * </pre>
     *
     * <code>repeated string audiences = 1;</code>
     *
     * @return The count of audiences.
     */
    int getAudiencesCount();

    /**
     *
     *
     * <pre>
     * The list of JWT
     * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
     * that are allowed to access. A JWT containing any of these audiences will
     * be accepted.
     * </pre>
     *
     * <code>repeated string audiences = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The audiences at the given index.
     */
    java.lang.String getAudiences(int index);

    /**
     *
     *
     * <pre>
     * The list of JWT
     * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
     * that are allowed to access. A JWT containing any of these audiences will
     * be accepted.
     * </pre>
     *
     * <code>repeated string audiences = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the audiences at the given index.
     */
    com.google.protobuf.ByteString getAudiencesBytes(int index);

    /**
     *
     *
     * <pre>
     * A list of allowed JWT issuers. Each entry must be a valid Google
     * service account, in the following format:
     *
     * `service-account-name&#64;project-id.iam.gserviceaccount.com`
     * </pre>
     *
     * <code>repeated string allowed_issuers = 2;</code>
     *
     * @return A list containing the allowedIssuers.
     */
    java.util.List<java.lang.String> getAllowedIssuersList();

    /**
     *
     *
     * <pre>
     * A list of allowed JWT issuers. Each entry must be a valid Google
     * service account, in the following format:
     *
     * `service-account-name&#64;project-id.iam.gserviceaccount.com`
     * </pre>
     *
     * <code>repeated string allowed_issuers = 2;</code>
     *
     * @return The count of allowedIssuers.
     */
    int getAllowedIssuersCount();

    /**
     *
     *
     * <pre>
     * A list of allowed JWT issuers. Each entry must be a valid Google
     * service account, in the following format:
     *
     * `service-account-name&#64;project-id.iam.gserviceaccount.com`
     * </pre>
     *
     * <code>repeated string allowed_issuers = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The allowedIssuers at the given index.
     */
    java.lang.String getAllowedIssuers(int index);

    /**
     *
     *
     * <pre>
     * A list of allowed JWT issuers. Each entry must be a valid Google
     * service account, in the following format:
     *
     * `service-account-name&#64;project-id.iam.gserviceaccount.com`
     * </pre>
     *
     * <code>repeated string allowed_issuers = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowedIssuers at the given index.
     */
    com.google.protobuf.ByteString getAllowedIssuersBytes(int index);
  }

  /**
   *
   *
   * <pre>
   * Configuration for an authentication provider, including support for
   * [JSON Web Token
   * (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider}
   */
  public static final class AuthProvider extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider)
      AuthProviderOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use AuthProvider.newBuilder() to construct.
    private AuthProvider(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private AuthProvider() {
      audiences_ = com.google.protobuf.LazyStringArrayList.emptyList();
      allowedIssuers_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new AuthProvider();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.IndexEndpointProto
          .internal_static_google_cloud_aiplatform_v1_DeployedIndexAuthConfig_AuthProvider_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.IndexEndpointProto
          .internal_static_google_cloud_aiplatform_v1_DeployedIndexAuthConfig_AuthProvider_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider.class,
              com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider.Builder.class);
    }

    public static final int AUDIENCES_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList audiences_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * The list of JWT
     * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
     * that are allowed to access. A JWT containing any of these audiences will
     * be accepted.
     * </pre>
     *
     * <code>repeated string audiences = 1;</code>
     *
     * @return A list containing the audiences.
     */
    public com.google.protobuf.ProtocolStringList getAudiencesList() {
      return audiences_;
    }

    /**
     *
     *
     * <pre>
     * The list of JWT
     * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
     * that are allowed to access. A JWT containing any of these audiences will
     * be accepted.
     * </pre>
     *
     * <code>repeated string audiences = 1;</code>
     *
     * @return The count of audiences.
     */
    public int getAudiencesCount() {
      return audiences_.size();
    }

    /**
     *
     *
     * <pre>
     * The list of JWT
     * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
     * that are allowed to access. A JWT containing any of these audiences will
     * be accepted.
     * </pre>
     *
     * <code>repeated string audiences = 1;</code>
     *
     * @param index The index of the element to return.
     * @return The audiences at the given index.
     */
    public java.lang.String getAudiences(int index) {
      return audiences_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The list of JWT
     * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
     * that are allowed to access. A JWT containing any of these audiences will
     * be accepted.
     * </pre>
     *
     * <code>repeated string audiences = 1;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the audiences at the given index.
     */
    public com.google.protobuf.ByteString getAudiencesBytes(int index) {
      return audiences_.getByteString(index);
    }

    public static final int ALLOWED_ISSUERS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList allowedIssuers_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * A list of allowed JWT issuers. Each entry must be a valid Google
     * service account, in the following format:
     *
     * `service-account-name&#64;project-id.iam.gserviceaccount.com`
     * </pre>
     *
     * <code>repeated string allowed_issuers = 2;</code>
     *
     * @return A list containing the allowedIssuers.
     */
    public com.google.protobuf.ProtocolStringList getAllowedIssuersList() {
      return allowedIssuers_;
    }

    /**
     *
     *
     * <pre>
     * A list of allowed JWT issuers. Each entry must be a valid Google
     * service account, in the following format:
     *
     * `service-account-name&#64;project-id.iam.gserviceaccount.com`
     * </pre>
     *
     * <code>repeated string allowed_issuers = 2;</code>
     *
     * @return The count of allowedIssuers.
     */
    public int getAllowedIssuersCount() {
      return allowedIssuers_.size();
    }

    /**
     *
     *
     * <pre>
     * A list of allowed JWT issuers. Each entry must be a valid Google
     * service account, in the following format:
     *
     * `service-account-name&#64;project-id.iam.gserviceaccount.com`
     * </pre>
     *
     * <code>repeated string allowed_issuers = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The allowedIssuers at the given index.
     */
    public java.lang.String getAllowedIssuers(int index) {
      return allowedIssuers_.get(index);
    }

    /**
     *
     *
     * <pre>
     * A list of allowed JWT issuers. Each entry must be a valid Google
     * service account, in the following format:
     *
     * `service-account-name&#64;project-id.iam.gserviceaccount.com`
     * </pre>
     *
     * <code>repeated string allowed_issuers = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowedIssuers at the given index.
     */
    public com.google.protobuf.ByteString getAllowedIssuersBytes(int index) {
      return allowedIssuers_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < audiences_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, audiences_.getRaw(i));
      }
      for (int i = 0; i < allowedIssuers_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, allowedIssuers_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        for (int i = 0; i < audiences_.size(); i++) {
          dataSize += computeStringSizeNoTag(audiences_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAudiencesList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < allowedIssuers_.size(); i++) {
          dataSize += computeStringSizeNoTag(allowedIssuers_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAllowedIssuersList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider other =
          (com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider) obj;

      if (!getAudiencesList().equals(other.getAudiencesList())) return false;
      if (!getAllowedIssuersList().equals(other.getAllowedIssuersList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getAudiencesCount() > 0) {
        hash = (37 * hash) + AUDIENCES_FIELD_NUMBER;
        hash = (53 * hash) + getAudiencesList().hashCode();
      }
      if (getAllowedIssuersCount() > 0) {
        hash = (37 * hash) + ALLOWED_ISSUERS_FIELD_NUMBER;
        hash = (53 * hash) + getAllowedIssuersList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Configuration for an authentication provider, including support for
     * [JSON Web Token
     * (JWT)](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32).
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider)
        com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProviderOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.IndexEndpointProto
            .internal_static_google_cloud_aiplatform_v1_DeployedIndexAuthConfig_AuthProvider_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.IndexEndpointProto
            .internal_static_google_cloud_aiplatform_v1_DeployedIndexAuthConfig_AuthProvider_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider.class,
                com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        audiences_ = com.google.protobuf.LazyStringArrayList.emptyList();
        allowedIssuers_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.IndexEndpointProto
            .internal_static_google_cloud_aiplatform_v1_DeployedIndexAuthConfig_AuthProvider_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider build() {
        com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider buildPartial() {
        com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider result =
            new com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          audiences_.makeImmutable();
          result.audiences_ = audiences_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          allowedIssuers_.makeImmutable();
          result.allowedIssuers_ = allowedIssuers_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider other) {
        if (other
            == com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider
                .getDefaultInstance()) return this;
        if (!other.audiences_.isEmpty()) {
          if (audiences_.isEmpty()) {
            audiences_ = other.audiences_;
            bitField0_ |= 0x00000001;
          } else {
            ensureAudiencesIsMutable();
            audiences_.addAll(other.audiences_);
          }
          onChanged();
        }
        if (!other.allowedIssuers_.isEmpty()) {
          if (allowedIssuers_.isEmpty()) {
            allowedIssuers_ = other.allowedIssuers_;
            bitField0_ |= 0x00000002;
          } else {
            ensureAllowedIssuersIsMutable();
            allowedIssuers_.addAll(other.allowedIssuers_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureAudiencesIsMutable();
                  audiences_.add(s);
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureAllowedIssuersIsMutable();
                  allowedIssuers_.add(s);
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.LazyStringArrayList audiences_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureAudiencesIsMutable() {
        if (!audiences_.isModifiable()) {
          audiences_ = new com.google.protobuf.LazyStringArrayList(audiences_);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * The list of JWT
       * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
       * that are allowed to access. A JWT containing any of these audiences will
       * be accepted.
       * </pre>
       *
       * <code>repeated string audiences = 1;</code>
       *
       * @return A list containing the audiences.
       */
      public com.google.protobuf.ProtocolStringList getAudiencesList() {
        audiences_.makeImmutable();
        return audiences_;
      }

      /**
       *
       *
       * <pre>
       * The list of JWT
       * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
       * that are allowed to access. A JWT containing any of these audiences will
       * be accepted.
       * </pre>
       *
       * <code>repeated string audiences = 1;</code>
       *
       * @return The count of audiences.
       */
      public int getAudiencesCount() {
        return audiences_.size();
      }

      /**
       *
       *
       * <pre>
       * The list of JWT
       * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
       * that are allowed to access. A JWT containing any of these audiences will
       * be accepted.
       * </pre>
       *
       * <code>repeated string audiences = 1;</code>
       *
       * @param index The index of the element to return.
       * @return The audiences at the given index.
       */
      public java.lang.String getAudiences(int index) {
        return audiences_.get(index);
      }

      /**
       *
       *
       * <pre>
       * The list of JWT
       * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
       * that are allowed to access. A JWT containing any of these audiences will
       * be accepted.
       * </pre>
       *
       * <code>repeated string audiences = 1;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the audiences at the given index.
       */
      public com.google.protobuf.ByteString getAudiencesBytes(int index) {
        return audiences_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * The list of JWT
       * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
       * that are allowed to access. A JWT containing any of these audiences will
       * be accepted.
       * </pre>
       *
       * <code>repeated string audiences = 1;</code>
       *
       * @param index The index to set the value at.
       * @param value The audiences to set.
       * @return This builder for chaining.
       */
      public Builder setAudiences(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAudiencesIsMutable();
        audiences_.set(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The list of JWT
       * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
       * that are allowed to access. A JWT containing any of these audiences will
       * be accepted.
       * </pre>
       *
       * <code>repeated string audiences = 1;</code>
       *
       * @param value The audiences to add.
       * @return This builder for chaining.
       */
      public Builder addAudiences(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAudiencesIsMutable();
        audiences_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The list of JWT
       * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
       * that are allowed to access. A JWT containing any of these audiences will
       * be accepted.
       * </pre>
       *
       * <code>repeated string audiences = 1;</code>
       *
       * @param values The audiences to add.
       * @return This builder for chaining.
       */
      public Builder addAllAudiences(java.lang.Iterable<java.lang.String> values) {
        ensureAudiencesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, audiences_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The list of JWT
       * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
       * that are allowed to access. A JWT containing any of these audiences will
       * be accepted.
       * </pre>
       *
       * <code>repeated string audiences = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAudiences() {
        audiences_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The list of JWT
       * [audiences](https://tools.ietf.org/html/draft-ietf-oauth-json-web-token-32#section-4.1.3).
       * that are allowed to access. A JWT containing any of these audiences will
       * be accepted.
       * </pre>
       *
       * <code>repeated string audiences = 1;</code>
       *
       * @param value The bytes of the audiences to add.
       * @return This builder for chaining.
       */
      public Builder addAudiencesBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAudiencesIsMutable();
        audiences_.add(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList allowedIssuers_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureAllowedIssuersIsMutable() {
        if (!allowedIssuers_.isModifiable()) {
          allowedIssuers_ = new com.google.protobuf.LazyStringArrayList(allowedIssuers_);
        }
        bitField0_ |= 0x00000002;
      }

      /**
       *
       *
       * <pre>
       * A list of allowed JWT issuers. Each entry must be a valid Google
       * service account, in the following format:
       *
       * `service-account-name&#64;project-id.iam.gserviceaccount.com`
       * </pre>
       *
       * <code>repeated string allowed_issuers = 2;</code>
       *
       * @return A list containing the allowedIssuers.
       */
      public com.google.protobuf.ProtocolStringList getAllowedIssuersList() {
        allowedIssuers_.makeImmutable();
        return allowedIssuers_;
      }

      /**
       *
       *
       * <pre>
       * A list of allowed JWT issuers. Each entry must be a valid Google
       * service account, in the following format:
       *
       * `service-account-name&#64;project-id.iam.gserviceaccount.com`
       * </pre>
       *
       * <code>repeated string allowed_issuers = 2;</code>
       *
       * @return The count of allowedIssuers.
       */
      public int getAllowedIssuersCount() {
        return allowedIssuers_.size();
      }

      /**
       *
       *
       * <pre>
       * A list of allowed JWT issuers. Each entry must be a valid Google
       * service account, in the following format:
       *
       * `service-account-name&#64;project-id.iam.gserviceaccount.com`
       * </pre>
       *
       * <code>repeated string allowed_issuers = 2;</code>
       *
       * @param index The index of the element to return.
       * @return The allowedIssuers at the given index.
       */
      public java.lang.String getAllowedIssuers(int index) {
        return allowedIssuers_.get(index);
      }

      /**
       *
       *
       * <pre>
       * A list of allowed JWT issuers. Each entry must be a valid Google
       * service account, in the following format:
       *
       * `service-account-name&#64;project-id.iam.gserviceaccount.com`
       * </pre>
       *
       * <code>repeated string allowed_issuers = 2;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the allowedIssuers at the given index.
       */
      public com.google.protobuf.ByteString getAllowedIssuersBytes(int index) {
        return allowedIssuers_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * A list of allowed JWT issuers. Each entry must be a valid Google
       * service account, in the following format:
       *
       * `service-account-name&#64;project-id.iam.gserviceaccount.com`
       * </pre>
       *
       * <code>repeated string allowed_issuers = 2;</code>
       *
       * @param index The index to set the value at.
       * @param value The allowedIssuers to set.
       * @return This builder for chaining.
       */
      public Builder setAllowedIssuers(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedIssuersIsMutable();
        allowedIssuers_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of allowed JWT issuers. Each entry must be a valid Google
       * service account, in the following format:
       *
       * `service-account-name&#64;project-id.iam.gserviceaccount.com`
       * </pre>
       *
       * <code>repeated string allowed_issuers = 2;</code>
       *
       * @param value The allowedIssuers to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedIssuers(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowedIssuersIsMutable();
        allowedIssuers_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of allowed JWT issuers. Each entry must be a valid Google
       * service account, in the following format:
       *
       * `service-account-name&#64;project-id.iam.gserviceaccount.com`
       * </pre>
       *
       * <code>repeated string allowed_issuers = 2;</code>
       *
       * @param values The allowedIssuers to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllowedIssuers(java.lang.Iterable<java.lang.String> values) {
        ensureAllowedIssuersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedIssuers_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of allowed JWT issuers. Each entry must be a valid Google
       * service account, in the following format:
       *
       * `service-account-name&#64;project-id.iam.gserviceaccount.com`
       * </pre>
       *
       * <code>repeated string allowed_issuers = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowedIssuers() {
        allowedIssuers_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * A list of allowed JWT issuers. Each entry must be a valid Google
       * service account, in the following format:
       *
       * `service-account-name&#64;project-id.iam.gserviceaccount.com`
       * </pre>
       *
       * <code>repeated string allowed_issuers = 2;</code>
       *
       * @param value The bytes of the allowedIssuers to add.
       * @return This builder for chaining.
       */
      public Builder addAllowedIssuersBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAllowedIssuersIsMutable();
        allowedIssuers_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider)
    private static final com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider();
    }

    public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<AuthProvider> PARSER =
        new com.google.protobuf.AbstractParser<AuthProvider>() {
          @java.lang.Override
          public AuthProvider parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<AuthProvider> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<AuthProvider> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int AUTH_PROVIDER_FIELD_NUMBER = 1;
  private com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider authProvider_;

  /**
   *
   *
   * <pre>
   * Defines the authentication provider that the DeployedIndex uses.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider auth_provider = 1;
   * </code>
   *
   * @return Whether the authProvider field is set.
   */
  @java.lang.Override
  public boolean hasAuthProvider() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Defines the authentication provider that the DeployedIndex uses.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider auth_provider = 1;
   * </code>
   *
   * @return The authProvider.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider getAuthProvider() {
    return authProvider_ == null
        ? com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider.getDefaultInstance()
        : authProvider_;
  }

  /**
   *
   *
   * <pre>
   * Defines the authentication provider that the DeployedIndex uses.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider auth_provider = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProviderOrBuilder
      getAuthProviderOrBuilder() {
    return authProvider_ == null
        ? com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider.getDefaultInstance()
        : authProvider_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getAuthProvider());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getAuthProvider());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig other =
        (com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig) obj;

    if (hasAuthProvider() != other.hasAuthProvider()) return false;
    if (hasAuthProvider()) {
      if (!getAuthProvider().equals(other.getAuthProvider())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAuthProvider()) {
      hash = (37 * hash) + AUTH_PROVIDER_FIELD_NUMBER;
      hash = (53 * hash) + getAuthProvider().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Used to set up the auth on the DeployedIndex's private endpoint.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.DeployedIndexAuthConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.DeployedIndexAuthConfig)
      com.google.cloud.aiplatform.v1.DeployedIndexAuthConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.IndexEndpointProto
          .internal_static_google_cloud_aiplatform_v1_DeployedIndexAuthConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.IndexEndpointProto
          .internal_static_google_cloud_aiplatform_v1_DeployedIndexAuthConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.class,
              com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getAuthProviderFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      authProvider_ = null;
      if (authProviderBuilder_ != null) {
        authProviderBuilder_.dispose();
        authProviderBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.IndexEndpointProto
          .internal_static_google_cloud_aiplatform_v1_DeployedIndexAuthConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig build() {
      com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig buildPartial() {
      com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig result =
          new com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.authProvider_ =
            authProviderBuilder_ == null ? authProvider_ : authProviderBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig other) {
      if (other == com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.getDefaultInstance())
        return this;
      if (other.hasAuthProvider()) {
        mergeAuthProvider(other.getAuthProvider());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getAuthProviderFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider authProvider_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider,
            com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider.Builder,
            com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProviderOrBuilder>
        authProviderBuilder_;

    /**
     *
     *
     * <pre>
     * Defines the authentication provider that the DeployedIndex uses.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider auth_provider = 1;
     * </code>
     *
     * @return Whether the authProvider field is set.
     */
    public boolean hasAuthProvider() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Defines the authentication provider that the DeployedIndex uses.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider auth_provider = 1;
     * </code>
     *
     * @return The authProvider.
     */
    public com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider getAuthProvider() {
      if (authProviderBuilder_ == null) {
        return authProvider_ == null
            ? com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider
                .getDefaultInstance()
            : authProvider_;
      } else {
        return authProviderBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Defines the authentication provider that the DeployedIndex uses.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider auth_provider = 1;
     * </code>
     */
    public Builder setAuthProvider(
        com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider value) {
      if (authProviderBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        authProvider_ = value;
      } else {
        authProviderBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines the authentication provider that the DeployedIndex uses.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider auth_provider = 1;
     * </code>
     */
    public Builder setAuthProvider(
        com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider.Builder
            builderForValue) {
      if (authProviderBuilder_ == null) {
        authProvider_ = builderForValue.build();
      } else {
        authProviderBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines the authentication provider that the DeployedIndex uses.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider auth_provider = 1;
     * </code>
     */
    public Builder mergeAuthProvider(
        com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider value) {
      if (authProviderBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && authProvider_ != null
            && authProvider_
                != com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider
                    .getDefaultInstance()) {
          getAuthProviderBuilder().mergeFrom(value);
        } else {
          authProvider_ = value;
        }
      } else {
        authProviderBuilder_.mergeFrom(value);
      }
      if (authProvider_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines the authentication provider that the DeployedIndex uses.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider auth_provider = 1;
     * </code>
     */
    public Builder clearAuthProvider() {
      bitField0_ = (bitField0_ & ~0x00000001);
      authProvider_ = null;
      if (authProviderBuilder_ != null) {
        authProviderBuilder_.dispose();
        authProviderBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Defines the authentication provider that the DeployedIndex uses.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider auth_provider = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider.Builder
        getAuthProviderBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getAuthProviderFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Defines the authentication provider that the DeployedIndex uses.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider auth_provider = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProviderOrBuilder
        getAuthProviderOrBuilder() {
      if (authProviderBuilder_ != null) {
        return authProviderBuilder_.getMessageOrBuilder();
      } else {
        return authProvider_ == null
            ? com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider
                .getDefaultInstance()
            : authProvider_;
      }
    }

    /**
     *
     *
     * <pre>
     * Defines the authentication provider that the DeployedIndex uses.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider auth_provider = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider,
            com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider.Builder,
            com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProviderOrBuilder>
        getAuthProviderFieldBuilder() {
      if (authProviderBuilder_ == null) {
        authProviderBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider,
                com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProvider.Builder,
                com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig.AuthProviderOrBuilder>(
                getAuthProvider(), getParentForChildren(), isClean());
        authProvider_ = null;
      }
      return authProviderBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.DeployedIndexAuthConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.DeployedIndexAuthConfig)
  private static final com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig();
  }

  public static com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DeployedIndexAuthConfig> PARSER =
      new com.google.protobuf.AbstractParser<DeployedIndexAuthConfig>() {
        @java.lang.Override
        public DeployedIndexAuthConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DeployedIndexAuthConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DeployedIndexAuthConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.DeployedIndexAuthConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
