/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/tool.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Tool to search public web data, powered by Vertex AI Search and Sec4
 * compliance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.EnterpriseWebSearch}
 */
public final class EnterpriseWebSearch extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.EnterpriseWebSearch)
    EnterpriseWebSearchOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use EnterpriseWebSearch.newBuilder() to construct.
  private EnterpriseWebSearch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private EnterpriseWebSearch() {
    excludeDomains_ = com.google.protobuf.LazyStringArrayList.emptyList();
    blockingConfidence_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new EnterpriseWebSearch();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ToolProto
        .internal_static_google_cloud_aiplatform_v1_EnterpriseWebSearch_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ToolProto
        .internal_static_google_cloud_aiplatform_v1_EnterpriseWebSearch_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.EnterpriseWebSearch.class,
            com.google.cloud.aiplatform.v1.EnterpriseWebSearch.Builder.class);
  }

  private int bitField0_;
  public static final int EXCLUDE_DOMAINS_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList excludeDomains_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Optional. List of domains to be excluded from the search results.
   * The default limit is 2000 domains.
   * </pre>
   *
   * <code>repeated string exclude_domains = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the excludeDomains.
   */
  public com.google.protobuf.ProtocolStringList getExcludeDomainsList() {
    return excludeDomains_;
  }

  /**
   *
   *
   * <pre>
   * Optional. List of domains to be excluded from the search results.
   * The default limit is 2000 domains.
   * </pre>
   *
   * <code>repeated string exclude_domains = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of excludeDomains.
   */
  public int getExcludeDomainsCount() {
    return excludeDomains_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. List of domains to be excluded from the search results.
   * The default limit is 2000 domains.
   * </pre>
   *
   * <code>repeated string exclude_domains = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The excludeDomains at the given index.
   */
  public java.lang.String getExcludeDomains(int index) {
    return excludeDomains_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. List of domains to be excluded from the search results.
   * The default limit is 2000 domains.
   * </pre>
   *
   * <code>repeated string exclude_domains = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the excludeDomains at the given index.
   */
  public com.google.protobuf.ByteString getExcludeDomainsBytes(int index) {
    return excludeDomains_.getByteString(index);
  }

  public static final int BLOCKING_CONFIDENCE_FIELD_NUMBER = 2;
  private int blockingConfidence_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Sites with confidence level chosen &amp; above this value will be
   * blocked from the search results.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the blockingConfidence field is set.
   */
  @java.lang.Override
  public boolean hasBlockingConfidence() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Sites with confidence level chosen &amp; above this value will be
   * blocked from the search results.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for blockingConfidence.
   */
  @java.lang.Override
  public int getBlockingConfidenceValue() {
    return blockingConfidence_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Sites with confidence level chosen &amp; above this value will be
   * blocked from the search results.
   * </pre>
   *
   * <code>
   * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The blockingConfidence.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold getBlockingConfidence() {
    com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold result =
        com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold.forNumber(blockingConfidence_);
    return result == null
        ? com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold.UNRECOGNIZED
        : result;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < excludeDomains_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, excludeDomains_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeEnum(2, blockingConfidence_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    {
      int dataSize = 0;
      for (int i = 0; i < excludeDomains_.size(); i++) {
        dataSize += computeStringSizeNoTag(excludeDomains_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getExcludeDomainsList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, blockingConfidence_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.EnterpriseWebSearch)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.EnterpriseWebSearch other =
        (com.google.cloud.aiplatform.v1.EnterpriseWebSearch) obj;

    if (!getExcludeDomainsList().equals(other.getExcludeDomainsList())) return false;
    if (hasBlockingConfidence() != other.hasBlockingConfidence()) return false;
    if (hasBlockingConfidence()) {
      if (blockingConfidence_ != other.blockingConfidence_) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getExcludeDomainsCount() > 0) {
      hash = (37 * hash) + EXCLUDE_DOMAINS_FIELD_NUMBER;
      hash = (53 * hash) + getExcludeDomainsList().hashCode();
    }
    if (hasBlockingConfidence()) {
      hash = (37 * hash) + BLOCKING_CONFIDENCE_FIELD_NUMBER;
      hash = (53 * hash) + blockingConfidence_;
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.EnterpriseWebSearch parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.EnterpriseWebSearch parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EnterpriseWebSearch parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.EnterpriseWebSearch parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EnterpriseWebSearch parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.EnterpriseWebSearch parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EnterpriseWebSearch parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.EnterpriseWebSearch parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EnterpriseWebSearch parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.EnterpriseWebSearch parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.EnterpriseWebSearch parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.EnterpriseWebSearch parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.EnterpriseWebSearch prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Tool to search public web data, powered by Vertex AI Search and Sec4
   * compliance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.EnterpriseWebSearch}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.EnterpriseWebSearch)
      com.google.cloud.aiplatform.v1.EnterpriseWebSearchOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_EnterpriseWebSearch_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_EnterpriseWebSearch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.EnterpriseWebSearch.class,
              com.google.cloud.aiplatform.v1.EnterpriseWebSearch.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.EnterpriseWebSearch.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      excludeDomains_ = com.google.protobuf.LazyStringArrayList.emptyList();
      blockingConfidence_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_EnterpriseWebSearch_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EnterpriseWebSearch getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.EnterpriseWebSearch.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EnterpriseWebSearch build() {
      com.google.cloud.aiplatform.v1.EnterpriseWebSearch result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EnterpriseWebSearch buildPartial() {
      com.google.cloud.aiplatform.v1.EnterpriseWebSearch result =
          new com.google.cloud.aiplatform.v1.EnterpriseWebSearch(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.EnterpriseWebSearch result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        excludeDomains_.makeImmutable();
        result.excludeDomains_ = excludeDomains_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.blockingConfidence_ = blockingConfidence_;
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.EnterpriseWebSearch) {
        return mergeFrom((com.google.cloud.aiplatform.v1.EnterpriseWebSearch) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.EnterpriseWebSearch other) {
      if (other == com.google.cloud.aiplatform.v1.EnterpriseWebSearch.getDefaultInstance())
        return this;
      if (!other.excludeDomains_.isEmpty()) {
        if (excludeDomains_.isEmpty()) {
          excludeDomains_ = other.excludeDomains_;
          bitField0_ |= 0x00000001;
        } else {
          ensureExcludeDomainsIsMutable();
          excludeDomains_.addAll(other.excludeDomains_);
        }
        onChanged();
      }
      if (other.hasBlockingConfidence()) {
        setBlockingConfidence(other.getBlockingConfidence());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureExcludeDomainsIsMutable();
                excludeDomains_.add(s);
                break;
              } // case 10
            case 16:
              {
                blockingConfidence_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.LazyStringArrayList excludeDomains_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureExcludeDomainsIsMutable() {
      if (!excludeDomains_.isModifiable()) {
        excludeDomains_ = new com.google.protobuf.LazyStringArrayList(excludeDomains_);
      }
      bitField0_ |= 0x00000001;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * </pre>
     *
     * <code>repeated string exclude_domains = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the excludeDomains.
     */
    public com.google.protobuf.ProtocolStringList getExcludeDomainsList() {
      excludeDomains_.makeImmutable();
      return excludeDomains_;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * </pre>
     *
     * <code>repeated string exclude_domains = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of excludeDomains.
     */
    public int getExcludeDomainsCount() {
      return excludeDomains_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * </pre>
     *
     * <code>repeated string exclude_domains = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The excludeDomains at the given index.
     */
    public java.lang.String getExcludeDomains(int index) {
      return excludeDomains_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * </pre>
     *
     * <code>repeated string exclude_domains = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the excludeDomains at the given index.
     */
    public com.google.protobuf.ByteString getExcludeDomainsBytes(int index) {
      return excludeDomains_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * </pre>
     *
     * <code>repeated string exclude_domains = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index to set the value at.
     * @param value The excludeDomains to set.
     * @return This builder for chaining.
     */
    public Builder setExcludeDomains(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExcludeDomainsIsMutable();
      excludeDomains_.set(index, value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * </pre>
     *
     * <code>repeated string exclude_domains = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The excludeDomains to add.
     * @return This builder for chaining.
     */
    public Builder addExcludeDomains(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureExcludeDomainsIsMutable();
      excludeDomains_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * </pre>
     *
     * <code>repeated string exclude_domains = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param values The excludeDomains to add.
     * @return This builder for chaining.
     */
    public Builder addAllExcludeDomains(java.lang.Iterable<java.lang.String> values) {
      ensureExcludeDomainsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, excludeDomains_);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * </pre>
     *
     * <code>repeated string exclude_domains = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearExcludeDomains() {
      excludeDomains_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000001);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. List of domains to be excluded from the search results.
     * The default limit is 2000 domains.
     * </pre>
     *
     * <code>repeated string exclude_domains = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes of the excludeDomains to add.
     * @return This builder for chaining.
     */
    public Builder addExcludeDomainsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureExcludeDomainsIsMutable();
      excludeDomains_.add(value);
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int blockingConfidence_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. Sites with confidence level chosen &amp; above this value will be
     * blocked from the search results.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the blockingConfidence field is set.
     */
    @java.lang.Override
    public boolean hasBlockingConfidence() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Sites with confidence level chosen &amp; above this value will be
     * blocked from the search results.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for blockingConfidence.
     */
    @java.lang.Override
    public int getBlockingConfidenceValue() {
      return blockingConfidence_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Sites with confidence level chosen &amp; above this value will be
     * blocked from the search results.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for blockingConfidence to set.
     * @return This builder for chaining.
     */
    public Builder setBlockingConfidenceValue(int value) {
      blockingConfidence_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Sites with confidence level chosen &amp; above this value will be
     * blocked from the search results.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The blockingConfidence.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold getBlockingConfidence() {
      com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold result =
          com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold.forNumber(blockingConfidence_);
      return result == null
          ? com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. Sites with confidence level chosen &amp; above this value will be
     * blocked from the search results.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The blockingConfidence to set.
     * @return This builder for chaining.
     */
    public Builder setBlockingConfidence(
        com.google.cloud.aiplatform.v1.Tool.PhishBlockThreshold value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      blockingConfidence_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Sites with confidence level chosen &amp; above this value will be
     * blocked from the search results.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1.Tool.PhishBlockThreshold blocking_confidence = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearBlockingConfidence() {
      bitField0_ = (bitField0_ & ~0x00000002);
      blockingConfidence_ = 0;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.EnterpriseWebSearch)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.EnterpriseWebSearch)
  private static final com.google.cloud.aiplatform.v1.EnterpriseWebSearch DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.EnterpriseWebSearch();
  }

  public static com.google.cloud.aiplatform.v1.EnterpriseWebSearch getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<EnterpriseWebSearch> PARSER =
      new com.google.protobuf.AbstractParser<EnterpriseWebSearch>() {
        @java.lang.Override
        public EnterpriseWebSearch parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<EnterpriseWebSearch> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<EnterpriseWebSearch> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EnterpriseWebSearch getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
