/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/feature_online_store_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Response message for
 * [FeatureOnlineStoreService.FeatureViewDirectWrite][google.cloud.aiplatform.v1.FeatureOnlineStoreService.FeatureViewDirectWrite].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse}
 */
public final class FeatureViewDirectWriteResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse)
    FeatureViewDirectWriteResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use FeatureViewDirectWriteResponse.newBuilder() to construct.
  private FeatureViewDirectWriteResponse(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FeatureViewDirectWriteResponse() {
    writeResponses_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FeatureViewDirectWriteResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.class,
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.Builder.class);
  }

  public interface WriteResponseOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * What key is this write response associated with.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
     *
     * @return Whether the dataKey field is set.
     */
    boolean hasDataKey();

    /**
     *
     *
     * <pre>
     * What key is this write response associated with.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
     *
     * @return The dataKey.
     */
    com.google.cloud.aiplatform.v1.FeatureViewDataKey getDataKey();

    /**
     *
     *
     * <pre>
     * What key is this write response associated with.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
     */
    com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder getDataKeyOrBuilder();

    /**
     *
     *
     * <pre>
     * When the feature values were written to the online store.
     * If
     * [FeatureViewDirectWriteResponse.status][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.status]
     * is not OK, this field is not populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp online_store_write_time = 2;</code>
     *
     * @return Whether the onlineStoreWriteTime field is set.
     */
    boolean hasOnlineStoreWriteTime();

    /**
     *
     *
     * <pre>
     * When the feature values were written to the online store.
     * If
     * [FeatureViewDirectWriteResponse.status][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.status]
     * is not OK, this field is not populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp online_store_write_time = 2;</code>
     *
     * @return The onlineStoreWriteTime.
     */
    com.google.protobuf.Timestamp getOnlineStoreWriteTime();

    /**
     *
     *
     * <pre>
     * When the feature values were written to the online store.
     * If
     * [FeatureViewDirectWriteResponse.status][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.status]
     * is not OK, this field is not populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp online_store_write_time = 2;</code>
     */
    com.google.protobuf.TimestampOrBuilder getOnlineStoreWriteTimeOrBuilder();
  }

  /**
   *
   *
   * <pre>
   * Details about the write for each key.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse}
   */
  public static final class WriteResponse extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse)
      WriteResponseOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use WriteResponse.newBuilder() to construct.
    private WriteResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private WriteResponse() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new WriteResponse();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteResponse_WriteResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteResponse_WriteResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.class,
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.Builder
                  .class);
    }

    private int bitField0_;
    public static final int DATA_KEY_FIELD_NUMBER = 1;
    private com.google.cloud.aiplatform.v1.FeatureViewDataKey dataKey_;

    /**
     *
     *
     * <pre>
     * What key is this write response associated with.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
     *
     * @return Whether the dataKey field is set.
     */
    @java.lang.Override
    public boolean hasDataKey() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * What key is this write response associated with.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
     *
     * @return The dataKey.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewDataKey getDataKey() {
      return dataKey_ == null
          ? com.google.cloud.aiplatform.v1.FeatureViewDataKey.getDefaultInstance()
          : dataKey_;
    }

    /**
     *
     *
     * <pre>
     * What key is this write response associated with.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder getDataKeyOrBuilder() {
      return dataKey_ == null
          ? com.google.cloud.aiplatform.v1.FeatureViewDataKey.getDefaultInstance()
          : dataKey_;
    }

    public static final int ONLINE_STORE_WRITE_TIME_FIELD_NUMBER = 2;
    private com.google.protobuf.Timestamp onlineStoreWriteTime_;

    /**
     *
     *
     * <pre>
     * When the feature values were written to the online store.
     * If
     * [FeatureViewDirectWriteResponse.status][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.status]
     * is not OK, this field is not populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp online_store_write_time = 2;</code>
     *
     * @return Whether the onlineStoreWriteTime field is set.
     */
    @java.lang.Override
    public boolean hasOnlineStoreWriteTime() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * When the feature values were written to the online store.
     * If
     * [FeatureViewDirectWriteResponse.status][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.status]
     * is not OK, this field is not populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp online_store_write_time = 2;</code>
     *
     * @return The onlineStoreWriteTime.
     */
    @java.lang.Override
    public com.google.protobuf.Timestamp getOnlineStoreWriteTime() {
      return onlineStoreWriteTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : onlineStoreWriteTime_;
    }

    /**
     *
     *
     * <pre>
     * When the feature values were written to the online store.
     * If
     * [FeatureViewDirectWriteResponse.status][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.status]
     * is not OK, this field is not populated.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp online_store_write_time = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.TimestampOrBuilder getOnlineStoreWriteTimeOrBuilder() {
      return onlineStoreWriteTime_ == null
          ? com.google.protobuf.Timestamp.getDefaultInstance()
          : onlineStoreWriteTime_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getDataKey());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeMessage(2, getOnlineStoreWriteTime());
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getDataKey());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(2, getOnlineStoreWriteTime());
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse other =
          (com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse) obj;

      if (hasDataKey() != other.hasDataKey()) return false;
      if (hasDataKey()) {
        if (!getDataKey().equals(other.getDataKey())) return false;
      }
      if (hasOnlineStoreWriteTime() != other.hasOnlineStoreWriteTime()) return false;
      if (hasOnlineStoreWriteTime()) {
        if (!getOnlineStoreWriteTime().equals(other.getOnlineStoreWriteTime())) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasDataKey()) {
        hash = (37 * hash) + DATA_KEY_FIELD_NUMBER;
        hash = (53 * hash) + getDataKey().hashCode();
      }
      if (hasOnlineStoreWriteTime()) {
        hash = (37 * hash) + ONLINE_STORE_WRITE_TIME_FIELD_NUMBER;
        hash = (53 * hash) + getOnlineStoreWriteTime().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Details about the write for each key.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse)
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponseOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteResponse_WriteResponse_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteResponse_WriteResponse_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.class,
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getDataKeyFieldBuilder();
          getOnlineStoreWriteTimeFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dataKey_ = null;
        if (dataKeyBuilder_ != null) {
          dataKeyBuilder_.dispose();
          dataKeyBuilder_ = null;
        }
        onlineStoreWriteTime_ = null;
        if (onlineStoreWriteTimeBuilder_ != null) {
          onlineStoreWriteTimeBuilder_.dispose();
          onlineStoreWriteTimeBuilder_ = null;
        }
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteResponse_WriteResponse_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse build() {
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
          buildPartial() {
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse result =
            new com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.dataKey_ = dataKeyBuilder_ == null ? dataKey_ : dataKeyBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.onlineStoreWriteTime_ =
              onlineStoreWriteTimeBuilder_ == null
                  ? onlineStoreWriteTime_
                  : onlineStoreWriteTimeBuilder_.build();
          to_bitField0_ |= 0x00000002;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse other) {
        if (other
            == com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
                .getDefaultInstance()) return this;
        if (other.hasDataKey()) {
          mergeDataKey(other.getDataKey());
        }
        if (other.hasOnlineStoreWriteTime()) {
          mergeOnlineStoreWriteTime(other.getOnlineStoreWriteTime());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getDataKeyFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(
                      getOnlineStoreWriteTimeFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.aiplatform.v1.FeatureViewDataKey dataKey_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.FeatureViewDataKey,
              com.google.cloud.aiplatform.v1.FeatureViewDataKey.Builder,
              com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder>
          dataKeyBuilder_;

      /**
       *
       *
       * <pre>
       * What key is this write response associated with.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       *
       * @return Whether the dataKey field is set.
       */
      public boolean hasDataKey() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * What key is this write response associated with.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       *
       * @return The dataKey.
       */
      public com.google.cloud.aiplatform.v1.FeatureViewDataKey getDataKey() {
        if (dataKeyBuilder_ == null) {
          return dataKey_ == null
              ? com.google.cloud.aiplatform.v1.FeatureViewDataKey.getDefaultInstance()
              : dataKey_;
        } else {
          return dataKeyBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * What key is this write response associated with.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       */
      public Builder setDataKey(com.google.cloud.aiplatform.v1.FeatureViewDataKey value) {
        if (dataKeyBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          dataKey_ = value;
        } else {
          dataKeyBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * What key is this write response associated with.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       */
      public Builder setDataKey(
          com.google.cloud.aiplatform.v1.FeatureViewDataKey.Builder builderForValue) {
        if (dataKeyBuilder_ == null) {
          dataKey_ = builderForValue.build();
        } else {
          dataKeyBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * What key is this write response associated with.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       */
      public Builder mergeDataKey(com.google.cloud.aiplatform.v1.FeatureViewDataKey value) {
        if (dataKeyBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && dataKey_ != null
              && dataKey_
                  != com.google.cloud.aiplatform.v1.FeatureViewDataKey.getDefaultInstance()) {
            getDataKeyBuilder().mergeFrom(value);
          } else {
            dataKey_ = value;
          }
        } else {
          dataKeyBuilder_.mergeFrom(value);
        }
        if (dataKey_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * What key is this write response associated with.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       */
      public Builder clearDataKey() {
        bitField0_ = (bitField0_ & ~0x00000001);
        dataKey_ = null;
        if (dataKeyBuilder_ != null) {
          dataKeyBuilder_.dispose();
          dataKeyBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * What key is this write response associated with.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       */
      public com.google.cloud.aiplatform.v1.FeatureViewDataKey.Builder getDataKeyBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getDataKeyFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * What key is this write response associated with.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       */
      public com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder getDataKeyOrBuilder() {
        if (dataKeyBuilder_ != null) {
          return dataKeyBuilder_.getMessageOrBuilder();
        } else {
          return dataKey_ == null
              ? com.google.cloud.aiplatform.v1.FeatureViewDataKey.getDefaultInstance()
              : dataKey_;
        }
      }

      /**
       *
       *
       * <pre>
       * What key is this write response associated with.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1.FeatureViewDataKey data_key = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.FeatureViewDataKey,
              com.google.cloud.aiplatform.v1.FeatureViewDataKey.Builder,
              com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder>
          getDataKeyFieldBuilder() {
        if (dataKeyBuilder_ == null) {
          dataKeyBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.FeatureViewDataKey,
                  com.google.cloud.aiplatform.v1.FeatureViewDataKey.Builder,
                  com.google.cloud.aiplatform.v1.FeatureViewDataKeyOrBuilder>(
                  getDataKey(), getParentForChildren(), isClean());
          dataKey_ = null;
        }
        return dataKeyBuilder_;
      }

      private com.google.protobuf.Timestamp onlineStoreWriteTime_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          onlineStoreWriteTimeBuilder_;

      /**
       *
       *
       * <pre>
       * When the feature values were written to the online store.
       * If
       * [FeatureViewDirectWriteResponse.status][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.status]
       * is not OK, this field is not populated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp online_store_write_time = 2;</code>
       *
       * @return Whether the onlineStoreWriteTime field is set.
       */
      public boolean hasOnlineStoreWriteTime() {
        return ((bitField0_ & 0x00000002) != 0);
      }

      /**
       *
       *
       * <pre>
       * When the feature values were written to the online store.
       * If
       * [FeatureViewDirectWriteResponse.status][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.status]
       * is not OK, this field is not populated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp online_store_write_time = 2;</code>
       *
       * @return The onlineStoreWriteTime.
       */
      public com.google.protobuf.Timestamp getOnlineStoreWriteTime() {
        if (onlineStoreWriteTimeBuilder_ == null) {
          return onlineStoreWriteTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : onlineStoreWriteTime_;
        } else {
          return onlineStoreWriteTimeBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * When the feature values were written to the online store.
       * If
       * [FeatureViewDirectWriteResponse.status][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.status]
       * is not OK, this field is not populated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp online_store_write_time = 2;</code>
       */
      public Builder setOnlineStoreWriteTime(com.google.protobuf.Timestamp value) {
        if (onlineStoreWriteTimeBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          onlineStoreWriteTime_ = value;
        } else {
          onlineStoreWriteTimeBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * When the feature values were written to the online store.
       * If
       * [FeatureViewDirectWriteResponse.status][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.status]
       * is not OK, this field is not populated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp online_store_write_time = 2;</code>
       */
      public Builder setOnlineStoreWriteTime(
          com.google.protobuf.Timestamp.Builder builderForValue) {
        if (onlineStoreWriteTimeBuilder_ == null) {
          onlineStoreWriteTime_ = builderForValue.build();
        } else {
          onlineStoreWriteTimeBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * When the feature values were written to the online store.
       * If
       * [FeatureViewDirectWriteResponse.status][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.status]
       * is not OK, this field is not populated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp online_store_write_time = 2;</code>
       */
      public Builder mergeOnlineStoreWriteTime(com.google.protobuf.Timestamp value) {
        if (onlineStoreWriteTimeBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)
              && onlineStoreWriteTime_ != null
              && onlineStoreWriteTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
            getOnlineStoreWriteTimeBuilder().mergeFrom(value);
          } else {
            onlineStoreWriteTime_ = value;
          }
        } else {
          onlineStoreWriteTimeBuilder_.mergeFrom(value);
        }
        if (onlineStoreWriteTime_ != null) {
          bitField0_ |= 0x00000002;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * When the feature values were written to the online store.
       * If
       * [FeatureViewDirectWriteResponse.status][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.status]
       * is not OK, this field is not populated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp online_store_write_time = 2;</code>
       */
      public Builder clearOnlineStoreWriteTime() {
        bitField0_ = (bitField0_ & ~0x00000002);
        onlineStoreWriteTime_ = null;
        if (onlineStoreWriteTimeBuilder_ != null) {
          onlineStoreWriteTimeBuilder_.dispose();
          onlineStoreWriteTimeBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * When the feature values were written to the online store.
       * If
       * [FeatureViewDirectWriteResponse.status][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.status]
       * is not OK, this field is not populated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp online_store_write_time = 2;</code>
       */
      public com.google.protobuf.Timestamp.Builder getOnlineStoreWriteTimeBuilder() {
        bitField0_ |= 0x00000002;
        onChanged();
        return getOnlineStoreWriteTimeFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * When the feature values were written to the online store.
       * If
       * [FeatureViewDirectWriteResponse.status][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.status]
       * is not OK, this field is not populated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp online_store_write_time = 2;</code>
       */
      public com.google.protobuf.TimestampOrBuilder getOnlineStoreWriteTimeOrBuilder() {
        if (onlineStoreWriteTimeBuilder_ != null) {
          return onlineStoreWriteTimeBuilder_.getMessageOrBuilder();
        } else {
          return onlineStoreWriteTime_ == null
              ? com.google.protobuf.Timestamp.getDefaultInstance()
              : onlineStoreWriteTime_;
        }
      }

      /**
       *
       *
       * <pre>
       * When the feature values were written to the online store.
       * If
       * [FeatureViewDirectWriteResponse.status][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.status]
       * is not OK, this field is not populated.
       * </pre>
       *
       * <code>.google.protobuf.Timestamp online_store_write_time = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.Timestamp,
              com.google.protobuf.Timestamp.Builder,
              com.google.protobuf.TimestampOrBuilder>
          getOnlineStoreWriteTimeFieldBuilder() {
        if (onlineStoreWriteTimeBuilder_ == null) {
          onlineStoreWriteTimeBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.Timestamp,
                  com.google.protobuf.Timestamp.Builder,
                  com.google.protobuf.TimestampOrBuilder>(
                  getOnlineStoreWriteTime(), getParentForChildren(), isClean());
          onlineStoreWriteTime_ = null;
        }
        return onlineStoreWriteTimeBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse)
    private static final com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse();
    }

    public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<WriteResponse> PARSER =
        new com.google.protobuf.AbstractParser<WriteResponse>() {
          @java.lang.Override
          public WriteResponse parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<WriteResponse> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<WriteResponse> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int STATUS_FIELD_NUMBER = 1;
  private com.google.rpc.Status status_;

  /**
   *
   *
   * <pre>
   * Response status for the keys listed in
   * [FeatureViewDirectWriteResponse.write_responses][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.write_responses].
   *
   * The error only applies to the
   * listed data keys - the stream will remain open for further
   * [FeatureOnlineStoreService.FeatureViewDirectWriteRequest][] requests.
   *
   * Partial failures (e.g. if the first 10 keys of a request fail, but the
   * rest succeed) from a single request may result in multiple responses -
   * there will be one response for the successful request keys and one response
   * for the failing request keys.
   * </pre>
   *
   * <code>.google.rpc.Status status = 1;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Response status for the keys listed in
   * [FeatureViewDirectWriteResponse.write_responses][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.write_responses].
   *
   * The error only applies to the
   * listed data keys - the stream will remain open for further
   * [FeatureOnlineStoreService.FeatureViewDirectWriteRequest][] requests.
   *
   * Partial failures (e.g. if the first 10 keys of a request fail, but the
   * rest succeed) from a single request may result in multiple responses -
   * there will be one response for the successful request keys and one response
   * for the failing request keys.
   * </pre>
   *
   * <code>.google.rpc.Status status = 1;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public com.google.rpc.Status getStatus() {
    return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
  }

  /**
   *
   *
   * <pre>
   * Response status for the keys listed in
   * [FeatureViewDirectWriteResponse.write_responses][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.write_responses].
   *
   * The error only applies to the
   * listed data keys - the stream will remain open for further
   * [FeatureOnlineStoreService.FeatureViewDirectWriteRequest][] requests.
   *
   * Partial failures (e.g. if the first 10 keys of a request fail, but the
   * rest succeed) from a single request may result in multiple responses -
   * there will be one response for the successful request keys and one response
   * for the failing request keys.
   * </pre>
   *
   * <code>.google.rpc.Status status = 1;</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
    return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
  }

  public static final int WRITE_RESPONSES_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse>
      writeResponses_;

  /**
   *
   *
   * <pre>
   * Details about write for each key. If status is not OK,
   * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
   * will have the key with error, but
   * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
   * will not be present.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse>
      getWriteResponsesList() {
    return writeResponses_;
  }

  /**
   *
   *
   * <pre>
   * Details about write for each key. If status is not OK,
   * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
   * will have the key with error, but
   * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
   * will not be present.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponseOrBuilder>
      getWriteResponsesOrBuilderList() {
    return writeResponses_;
  }

  /**
   *
   *
   * <pre>
   * Details about write for each key. If status is not OK,
   * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
   * will have the key with error, but
   * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
   * will not be present.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
   * </code>
   */
  @java.lang.Override
  public int getWriteResponsesCount() {
    return writeResponses_.size();
  }

  /**
   *
   *
   * <pre>
   * Details about write for each key. If status is not OK,
   * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
   * will have the key with error, but
   * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
   * will not be present.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
      getWriteResponses(int index) {
    return writeResponses_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Details about write for each key. If status is not OK,
   * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
   * will have the key with error, but
   * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
   * will not be present.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponseOrBuilder
      getWriteResponsesOrBuilder(int index) {
    return writeResponses_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getStatus());
    }
    for (int i = 0; i < writeResponses_.size(); i++) {
      output.writeMessage(2, writeResponses_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getStatus());
    }
    for (int i = 0; i < writeResponses_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, writeResponses_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse other =
        (com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse) obj;

    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getWriteResponsesList().equals(other.getWriteResponsesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    if (getWriteResponsesCount() > 0) {
      hash = (37 * hash) + WRITE_RESPONSES_FIELD_NUMBER;
      hash = (53 * hash) + getWriteResponsesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Response message for
   * [FeatureOnlineStoreService.FeatureViewDirectWrite][google.cloud.aiplatform.v1.FeatureOnlineStoreService.FeatureViewDirectWrite].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse)
      com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.class,
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStatusFieldBuilder();
        getWriteResponsesFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      if (writeResponsesBuilder_ == null) {
        writeResponses_ = java.util.Collections.emptyList();
      } else {
        writeResponses_ = null;
        writeResponsesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000002);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1_FeatureViewDirectWriteResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse build() {
      com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse buildPartial() {
      com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse result =
          new com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse result) {
      if (writeResponsesBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)) {
          writeResponses_ = java.util.Collections.unmodifiableList(writeResponses_);
          bitField0_ = (bitField0_ & ~0x00000002);
        }
        result.writeResponses_ = writeResponses_;
      } else {
        result.writeResponses_ = writeResponsesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.status_ = statusBuilder_ == null ? status_ : statusBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse) {
        return mergeFrom((com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse other) {
      if (other
          == com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.getDefaultInstance())
        return this;
      if (other.hasStatus()) {
        mergeStatus(other.getStatus());
      }
      if (writeResponsesBuilder_ == null) {
        if (!other.writeResponses_.isEmpty()) {
          if (writeResponses_.isEmpty()) {
            writeResponses_ = other.writeResponses_;
            bitField0_ = (bitField0_ & ~0x00000002);
          } else {
            ensureWriteResponsesIsMutable();
            writeResponses_.addAll(other.writeResponses_);
          }
          onChanged();
        }
      } else {
        if (!other.writeResponses_.isEmpty()) {
          if (writeResponsesBuilder_.isEmpty()) {
            writeResponsesBuilder_.dispose();
            writeResponsesBuilder_ = null;
            writeResponses_ = other.writeResponses_;
            bitField0_ = (bitField0_ & ~0x00000002);
            writeResponsesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getWriteResponsesFieldBuilder()
                    : null;
          } else {
            writeResponsesBuilder_.addAllMessages(other.writeResponses_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
                            .parser(),
                        extensionRegistry);
                if (writeResponsesBuilder_ == null) {
                  ensureWriteResponsesIsMutable();
                  writeResponses_.add(m);
                } else {
                  writeResponsesBuilder_.addMessage(m);
                }
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.rpc.Status status_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        statusBuilder_;

    /**
     *
     *
     * <pre>
     * Response status for the keys listed in
     * [FeatureViewDirectWriteResponse.write_responses][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.write_responses].
     *
     * The error only applies to the
     * listed data keys - the stream will remain open for further
     * [FeatureOnlineStoreService.FeatureViewDirectWriteRequest][] requests.
     *
     * Partial failures (e.g. if the first 10 keys of a request fail, but the
     * rest succeed) from a single request may result in multiple responses -
     * there will be one response for the successful request keys and one response
     * for the failing request keys.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Response status for the keys listed in
     * [FeatureViewDirectWriteResponse.write_responses][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.write_responses].
     *
     * The error only applies to the
     * listed data keys - the stream will remain open for further
     * [FeatureOnlineStoreService.FeatureViewDirectWriteRequest][] requests.
     *
     * Partial failures (e.g. if the first 10 keys of a request fail, but the
     * rest succeed) from a single request may result in multiple responses -
     * there will be one response for the successful request keys and one response
     * for the failing request keys.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     *
     * @return The status.
     */
    public com.google.rpc.Status getStatus() {
      if (statusBuilder_ == null) {
        return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
      } else {
        return statusBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Response status for the keys listed in
     * [FeatureViewDirectWriteResponse.write_responses][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.write_responses].
     *
     * The error only applies to the
     * listed data keys - the stream will remain open for further
     * [FeatureOnlineStoreService.FeatureViewDirectWriteRequest][] requests.
     *
     * Partial failures (e.g. if the first 10 keys of a request fail, but the
     * rest succeed) from a single request may result in multiple responses -
     * there will be one response for the successful request keys and one response
     * for the failing request keys.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     */
    public Builder setStatus(com.google.rpc.Status value) {
      if (statusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        status_ = value;
      } else {
        statusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Response status for the keys listed in
     * [FeatureViewDirectWriteResponse.write_responses][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.write_responses].
     *
     * The error only applies to the
     * listed data keys - the stream will remain open for further
     * [FeatureOnlineStoreService.FeatureViewDirectWriteRequest][] requests.
     *
     * Partial failures (e.g. if the first 10 keys of a request fail, but the
     * rest succeed) from a single request may result in multiple responses -
     * there will be one response for the successful request keys and one response
     * for the failing request keys.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     */
    public Builder setStatus(com.google.rpc.Status.Builder builderForValue) {
      if (statusBuilder_ == null) {
        status_ = builderForValue.build();
      } else {
        statusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Response status for the keys listed in
     * [FeatureViewDirectWriteResponse.write_responses][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.write_responses].
     *
     * The error only applies to the
     * listed data keys - the stream will remain open for further
     * [FeatureOnlineStoreService.FeatureViewDirectWriteRequest][] requests.
     *
     * Partial failures (e.g. if the first 10 keys of a request fail, but the
     * rest succeed) from a single request may result in multiple responses -
     * there will be one response for the successful request keys and one response
     * for the failing request keys.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     */
    public Builder mergeStatus(com.google.rpc.Status value) {
      if (statusBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && status_ != null
            && status_ != com.google.rpc.Status.getDefaultInstance()) {
          getStatusBuilder().mergeFrom(value);
        } else {
          status_ = value;
        }
      } else {
        statusBuilder_.mergeFrom(value);
      }
      if (status_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Response status for the keys listed in
     * [FeatureViewDirectWriteResponse.write_responses][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.write_responses].
     *
     * The error only applies to the
     * listed data keys - the stream will remain open for further
     * [FeatureOnlineStoreService.FeatureViewDirectWriteRequest][] requests.
     *
     * Partial failures (e.g. if the first 10 keys of a request fail, but the
     * rest succeed) from a single request may result in multiple responses -
     * there will be one response for the successful request keys and one response
     * for the failing request keys.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000001);
      status_ = null;
      if (statusBuilder_ != null) {
        statusBuilder_.dispose();
        statusBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Response status for the keys listed in
     * [FeatureViewDirectWriteResponse.write_responses][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.write_responses].
     *
     * The error only applies to the
     * listed data keys - the stream will remain open for further
     * [FeatureOnlineStoreService.FeatureViewDirectWriteRequest][] requests.
     *
     * Partial failures (e.g. if the first 10 keys of a request fail, but the
     * rest succeed) from a single request may result in multiple responses -
     * there will be one response for the successful request keys and one response
     * for the failing request keys.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     */
    public com.google.rpc.Status.Builder getStatusBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getStatusFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Response status for the keys listed in
     * [FeatureViewDirectWriteResponse.write_responses][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.write_responses].
     *
     * The error only applies to the
     * listed data keys - the stream will remain open for further
     * [FeatureOnlineStoreService.FeatureViewDirectWriteRequest][] requests.
     *
     * Partial failures (e.g. if the first 10 keys of a request fail, but the
     * rest succeed) from a single request may result in multiple responses -
     * there will be one response for the successful request keys and one response
     * for the failing request keys.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     */
    public com.google.rpc.StatusOrBuilder getStatusOrBuilder() {
      if (statusBuilder_ != null) {
        return statusBuilder_.getMessageOrBuilder();
      } else {
        return status_ == null ? com.google.rpc.Status.getDefaultInstance() : status_;
      }
    }

    /**
     *
     *
     * <pre>
     * Response status for the keys listed in
     * [FeatureViewDirectWriteResponse.write_responses][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.write_responses].
     *
     * The error only applies to the
     * listed data keys - the stream will remain open for further
     * [FeatureOnlineStoreService.FeatureViewDirectWriteRequest][] requests.
     *
     * Partial failures (e.g. if the first 10 keys of a request fail, but the
     * rest succeed) from a single request may result in multiple responses -
     * there will be one response for the successful request keys and one response
     * for the failing request keys.
     * </pre>
     *
     * <code>.google.rpc.Status status = 1;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getStatusFieldBuilder() {
      if (statusBuilder_ == null) {
        statusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getStatus(), getParentForChildren(), isClean());
        status_ = null;
      }
      return statusBuilder_;
    }

    private java.util.List<
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse>
        writeResponses_ = java.util.Collections.emptyList();

    private void ensureWriteResponsesIsMutable() {
      if (!((bitField0_ & 0x00000002) != 0)) {
        writeResponses_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse>(
                writeResponses_);
        bitField0_ |= 0x00000002;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse,
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.Builder,
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponseOrBuilder>
        writeResponsesBuilder_;

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse>
        getWriteResponsesList() {
      if (writeResponsesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(writeResponses_);
      } else {
        return writeResponsesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public int getWriteResponsesCount() {
      if (writeResponsesBuilder_ == null) {
        return writeResponses_.size();
      } else {
        return writeResponsesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
        getWriteResponses(int index) {
      if (writeResponsesBuilder_ == null) {
        return writeResponses_.get(index);
      } else {
        return writeResponsesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public Builder setWriteResponses(
        int index,
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse value) {
      if (writeResponsesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWriteResponsesIsMutable();
        writeResponses_.set(index, value);
        onChanged();
      } else {
        writeResponsesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public Builder setWriteResponses(
        int index,
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.Builder
            builderForValue) {
      if (writeResponsesBuilder_ == null) {
        ensureWriteResponsesIsMutable();
        writeResponses_.set(index, builderForValue.build());
        onChanged();
      } else {
        writeResponsesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public Builder addWriteResponses(
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse value) {
      if (writeResponsesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWriteResponsesIsMutable();
        writeResponses_.add(value);
        onChanged();
      } else {
        writeResponsesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public Builder addWriteResponses(
        int index,
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse value) {
      if (writeResponsesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureWriteResponsesIsMutable();
        writeResponses_.add(index, value);
        onChanged();
      } else {
        writeResponsesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public Builder addWriteResponses(
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.Builder
            builderForValue) {
      if (writeResponsesBuilder_ == null) {
        ensureWriteResponsesIsMutable();
        writeResponses_.add(builderForValue.build());
        onChanged();
      } else {
        writeResponsesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public Builder addWriteResponses(
        int index,
        com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.Builder
            builderForValue) {
      if (writeResponsesBuilder_ == null) {
        ensureWriteResponsesIsMutable();
        writeResponses_.add(index, builderForValue.build());
        onChanged();
      } else {
        writeResponsesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public Builder addAllWriteResponses(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse>
            values) {
      if (writeResponsesBuilder_ == null) {
        ensureWriteResponsesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, writeResponses_);
        onChanged();
      } else {
        writeResponsesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public Builder clearWriteResponses() {
      if (writeResponsesBuilder_ == null) {
        writeResponses_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
      } else {
        writeResponsesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public Builder removeWriteResponses(int index) {
      if (writeResponsesBuilder_ == null) {
        ensureWriteResponsesIsMutable();
        writeResponses_.remove(index);
        onChanged();
      } else {
        writeResponsesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.Builder
        getWriteResponsesBuilder(int index) {
      return getWriteResponsesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponseOrBuilder
        getWriteResponsesOrBuilder(int index) {
      if (writeResponsesBuilder_ == null) {
        return writeResponses_.get(index);
      } else {
        return writeResponsesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse
                    .WriteResponseOrBuilder>
        getWriteResponsesOrBuilderList() {
      if (writeResponsesBuilder_ != null) {
        return writeResponsesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(writeResponses_);
      }
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.Builder
        addWriteResponsesBuilder() {
      return getWriteResponsesFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.Builder
        addWriteResponsesBuilder(int index) {
      return getWriteResponsesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Details about write for each key. If status is not OK,
     * [WriteResponse.data_key][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.data_key]
     * will have the key with error, but
     * [WriteResponse.online_store_write_time][google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.online_store_write_time]
     * will not be present.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse write_responses = 2;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.Builder>
        getWriteResponsesBuilderList() {
      return getWriteResponsesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse,
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.Builder,
            com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponseOrBuilder>
        getWriteResponsesFieldBuilder() {
      if (writeResponsesBuilder_ == null) {
        writeResponsesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse,
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse.WriteResponse.Builder,
                com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse
                    .WriteResponseOrBuilder>(
                writeResponses_,
                ((bitField0_ & 0x00000002) != 0),
                getParentForChildren(),
                isClean());
        writeResponses_ = null;
      }
      return writeResponsesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse)
  private static final com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse();
  }

  public static com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeatureViewDirectWriteResponse> PARSER =
      new com.google.protobuf.AbstractParser<FeatureViewDirectWriteResponse>() {
        @java.lang.Override
        public FeatureViewDirectWriteResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FeatureViewDirectWriteResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeatureViewDirectWriteResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.FeatureViewDirectWriteResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
