/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/model.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

public interface ModelOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.Model)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * The resource name of the Model.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * The resource name of the Model.
   * </pre>
   *
   * <code>string name = 1;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * Output only. Immutable. The version ID of the model.
   * A new version is committed when a new model version is uploaded or
   * trained under an existing model id. It is an auto-incrementing decimal
   * number in string representation.
   * </pre>
   *
   * <code>
   * string version_id = 28 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The versionId.
   */
  java.lang.String getVersionId();

  /**
   *
   *
   * <pre>
   * Output only. Immutable. The version ID of the model.
   * A new version is committed when a new model version is uploaded or
   * trained under an existing model id. It is an auto-incrementing decimal
   * number in string representation.
   * </pre>
   *
   * <code>
   * string version_id = 28 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The bytes for versionId.
   */
  com.google.protobuf.ByteString getVersionIdBytes();

  /**
   *
   *
   * <pre>
   * User provided version aliases so that a model version can be referenced via
   * alias (i.e.
   * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
   * instead of auto-generated version id (i.e.
   * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
   * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
   * version_id. A default version alias will be created for the first version
   * of the model, and there must be exactly one default version alias for a
   * model.
   * </pre>
   *
   * <code>repeated string version_aliases = 29;</code>
   *
   * @return A list containing the versionAliases.
   */
  java.util.List<java.lang.String> getVersionAliasesList();

  /**
   *
   *
   * <pre>
   * User provided version aliases so that a model version can be referenced via
   * alias (i.e.
   * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
   * instead of auto-generated version id (i.e.
   * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
   * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
   * version_id. A default version alias will be created for the first version
   * of the model, and there must be exactly one default version alias for a
   * model.
   * </pre>
   *
   * <code>repeated string version_aliases = 29;</code>
   *
   * @return The count of versionAliases.
   */
  int getVersionAliasesCount();

  /**
   *
   *
   * <pre>
   * User provided version aliases so that a model version can be referenced via
   * alias (i.e.
   * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
   * instead of auto-generated version id (i.e.
   * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
   * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
   * version_id. A default version alias will be created for the first version
   * of the model, and there must be exactly one default version alias for a
   * model.
   * </pre>
   *
   * <code>repeated string version_aliases = 29;</code>
   *
   * @param index The index of the element to return.
   * @return The versionAliases at the given index.
   */
  java.lang.String getVersionAliases(int index);

  /**
   *
   *
   * <pre>
   * User provided version aliases so that a model version can be referenced via
   * alias (i.e.
   * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_alias}`
   * instead of auto-generated version id (i.e.
   * `projects/{project}/locations/{location}/models/{model_id}&#64;{version_id})`.
   * The format is [a-z][a-zA-Z0-9-]{0,126}[a-z0-9] to distinguish from
   * version_id. A default version alias will be created for the first version
   * of the model, and there must be exactly one default version alias for a
   * model.
   * </pre>
   *
   * <code>repeated string version_aliases = 29;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the versionAliases at the given index.
   */
  com.google.protobuf.ByteString getVersionAliasesBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this version was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp version_create_time = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the versionCreateTime field is set.
   */
  boolean hasVersionCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this version was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp version_create_time = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The versionCreateTime.
   */
  com.google.protobuf.Timestamp getVersionCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this version was created.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp version_create_time = 31 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getVersionCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this version was most recently updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp version_update_time = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the versionUpdateTime field is set.
   */
  boolean hasVersionUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this version was most recently updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp version_update_time = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The versionUpdateTime.
   */
  com.google.protobuf.Timestamp getVersionUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this version was most recently updated.
   * </pre>
   *
   * <code>
   * .google.protobuf.Timestamp version_update_time = 32 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getVersionUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Required. The display name of the Model.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  java.lang.String getDisplayName();

  /**
   *
   *
   * <pre>
   * Required. The display name of the Model.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  com.google.protobuf.ByteString getDisplayNameBytes();

  /**
   *
   *
   * <pre>
   * The description of the Model.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();

  /**
   *
   *
   * <pre>
   * The description of the Model.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * The description of this version.
   * </pre>
   *
   * <code>string version_description = 30;</code>
   *
   * @return The versionDescription.
   */
  java.lang.String getVersionDescription();

  /**
   *
   *
   * <pre>
   * The description of this version.
   * </pre>
   *
   * <code>string version_description = 30;</code>
   *
   * @return The bytes for versionDescription.
   */
  com.google.protobuf.ByteString getVersionDescriptionBytes();

  /**
   *
   *
   * <pre>
   * The default checkpoint id of a model version.
   * </pre>
   *
   * <code>string default_checkpoint_id = 53;</code>
   *
   * @return The defaultCheckpointId.
   */
  java.lang.String getDefaultCheckpointId();

  /**
   *
   *
   * <pre>
   * The default checkpoint id of a model version.
   * </pre>
   *
   * <code>string default_checkpoint_id = 53;</code>
   *
   * @return The bytes for defaultCheckpointId.
   */
  com.google.protobuf.ByteString getDefaultCheckpointIdBytes();

  /**
   *
   *
   * <pre>
   * The schemata that describe formats of the Model's predictions and
   * explanations as given and returned via
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * and
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 4;</code>
   *
   * @return Whether the predictSchemata field is set.
   */
  boolean hasPredictSchemata();

  /**
   *
   *
   * <pre>
   * The schemata that describe formats of the Model's predictions and
   * explanations as given and returned via
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * and
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 4;</code>
   *
   * @return The predictSchemata.
   */
  com.google.cloud.aiplatform.v1.PredictSchemata getPredictSchemata();

  /**
   *
   *
   * <pre>
   * The schemata that describe formats of the Model's predictions and
   * explanations as given and returned via
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * and
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.PredictSchemata predict_schemata = 4;</code>
   */
  com.google.cloud.aiplatform.v1.PredictSchemataOrBuilder getPredictSchemataOrBuilder();

  /**
   *
   *
   * <pre>
   * Immutable. Points to a YAML file stored on Google Cloud Storage describing
   * additional information about the Model, that is specific to it. Unset if
   * the Model does not have any additional information. The schema is defined
   * as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * AutoML Models always have this field populated by Vertex AI, if no
   * additional metadata is needed, this field is set to an empty string.
   * Note: The URI given on output will be immutable and probably different,
   * including the URI scheme, than the one given on input. The output URI will
   * point to a location where the user only has a read access.
   * </pre>
   *
   * <code>string metadata_schema_uri = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The metadataSchemaUri.
   */
  java.lang.String getMetadataSchemaUri();

  /**
   *
   *
   * <pre>
   * Immutable. Points to a YAML file stored on Google Cloud Storage describing
   * additional information about the Model, that is specific to it. Unset if
   * the Model does not have any additional information. The schema is defined
   * as an OpenAPI 3.0.2 [Schema
   * Object](https://github.com/OAI/OpenAPI-Specification/blob/main/versions/3.0.2.md#schemaObject).
   * AutoML Models always have this field populated by Vertex AI, if no
   * additional metadata is needed, this field is set to an empty string.
   * Note: The URI given on output will be immutable and probably different,
   * including the URI scheme, than the one given on input. The output URI will
   * point to a location where the user only has a read access.
   * </pre>
   *
   * <code>string metadata_schema_uri = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for metadataSchemaUri.
   */
  com.google.protobuf.ByteString getMetadataSchemaUriBytes();

  /**
   *
   *
   * <pre>
   * Immutable. An additional information about the Model; the schema of the
   * metadata can be found in
   * [metadata_schema][google.cloud.aiplatform.v1.Model.metadata_schema_uri].
   * Unset if the Model does not have any additional information.
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return Whether the metadata field is set.
   */
  boolean hasMetadata();

  /**
   *
   *
   * <pre>
   * Immutable. An additional information about the Model; the schema of the
   * metadata can be found in
   * [metadata_schema][google.cloud.aiplatform.v1.Model.metadata_schema_uri].
   * Unset if the Model does not have any additional information.
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The metadata.
   */
  com.google.protobuf.Value getMetadata();

  /**
   *
   *
   * <pre>
   * Immutable. An additional information about the Model; the schema of the
   * metadata can be found in
   * [metadata_schema][google.cloud.aiplatform.v1.Model.metadata_schema_uri].
   * Unset if the Model does not have any additional information.
   * </pre>
   *
   * <code>.google.protobuf.Value metadata = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
   */
  com.google.protobuf.ValueOrBuilder getMetadataOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The formats in which this Model may be exported. If empty,
   * this Model is not available for export.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.aiplatform.v1.Model.ExportFormat> getSupportedExportFormatsList();

  /**
   *
   *
   * <pre>
   * Output only. The formats in which this Model may be exported. If empty,
   * this Model is not available for export.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1.Model.ExportFormat getSupportedExportFormats(int index);

  /**
   *
   *
   * <pre>
   * Output only. The formats in which this Model may be exported. If empty,
   * this Model is not available for export.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getSupportedExportFormatsCount();

  /**
   *
   *
   * <pre>
   * Output only. The formats in which this Model may be exported. If empty,
   * this Model is not available for export.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.aiplatform.v1.Model.ExportFormatOrBuilder>
      getSupportedExportFormatsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Output only. The formats in which this Model may be exported. If empty,
   * this Model is not available for export.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.ExportFormat supported_export_formats = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1.Model.ExportFormatOrBuilder getSupportedExportFormatsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the TrainingPipeline that uploaded this
   * Model, if any.
   * </pre>
   *
   * <code>
   * string training_pipeline = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The trainingPipeline.
   */
  java.lang.String getTrainingPipeline();

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the TrainingPipeline that uploaded this
   * Model, if any.
   * </pre>
   *
   * <code>
   * string training_pipeline = 7 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for trainingPipeline.
   */
  com.google.protobuf.ByteString getTrainingPipelineBytes();

  /**
   *
   *
   * <pre>
   * Optional. This field is populated if the model is produced by a pipeline
   * job.
   * </pre>
   *
   * <code>
   * string pipeline_job = 47 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The pipelineJob.
   */
  java.lang.String getPipelineJob();

  /**
   *
   *
   * <pre>
   * Optional. This field is populated if the model is produced by a pipeline
   * job.
   * </pre>
   *
   * <code>
   * string pipeline_job = 47 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for pipelineJob.
   */
  com.google.protobuf.ByteString getPipelineJobBytes();

  /**
   *
   *
   * <pre>
   * Input only. The specification of the container that is to be used when
   * deploying this Model. The specification is ingested upon
   * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
   * and all binaries it contains are copied and stored internally by Vertex AI.
   * Not required for AutoML Models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 9 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return Whether the containerSpec field is set.
   */
  boolean hasContainerSpec();

  /**
   *
   *
   * <pre>
   * Input only. The specification of the container that is to be used when
   * deploying this Model. The specification is ingested upon
   * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
   * and all binaries it contains are copied and stored internally by Vertex AI.
   * Not required for AutoML Models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 9 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   *
   * @return The containerSpec.
   */
  com.google.cloud.aiplatform.v1.ModelContainerSpec getContainerSpec();

  /**
   *
   *
   * <pre>
   * Input only. The specification of the container that is to be used when
   * deploying this Model. The specification is ingested upon
   * [ModelService.UploadModel][google.cloud.aiplatform.v1.ModelService.UploadModel],
   * and all binaries it contains are copied and stored internally by Vertex AI.
   * Not required for AutoML Models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelContainerSpec container_spec = 9 [(.google.api.field_behavior) = INPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1.ModelContainerSpecOrBuilder getContainerSpecOrBuilder();

  /**
   *
   *
   * <pre>
   * Immutable. The path to the directory containing the Model artifact and any
   * of its supporting files. Not required for AutoML Models.
   * </pre>
   *
   * <code>string artifact_uri = 26 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The artifactUri.
   */
  java.lang.String getArtifactUri();

  /**
   *
   *
   * <pre>
   * Immutable. The path to the directory containing the Model artifact and any
   * of its supporting files. Not required for AutoML Models.
   * </pre>
   *
   * <code>string artifact_uri = 26 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for artifactUri.
   */
  com.google.protobuf.ByteString getArtifactUriBytes();

  /**
   *
   *
   * <pre>
   * Output only. When this Model is deployed, its prediction resources are
   * described by the `prediction_resources` field of the
   * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
   * object. Because not all Models support all resource configuration types,
   * the configuration types this Model supports are listed here. If no
   * configuration types are listed, the Model cannot be deployed to an
   * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
   * online predictions
   * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
   * Such a Model can serve predictions by using a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
   * has at least one entry each in
   * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
   * and
   * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the supportedDeploymentResourcesTypes.
   */
  java.util.List<com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType>
      getSupportedDeploymentResourcesTypesList();

  /**
   *
   *
   * <pre>
   * Output only. When this Model is deployed, its prediction resources are
   * described by the `prediction_resources` field of the
   * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
   * object. Because not all Models support all resource configuration types,
   * the configuration types this Model supports are listed here. If no
   * configuration types are listed, the Model cannot be deployed to an
   * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
   * online predictions
   * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
   * Such a Model can serve predictions by using a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
   * has at least one entry each in
   * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
   * and
   * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of supportedDeploymentResourcesTypes.
   */
  int getSupportedDeploymentResourcesTypesCount();

  /**
   *
   *
   * <pre>
   * Output only. When this Model is deployed, its prediction resources are
   * described by the `prediction_resources` field of the
   * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
   * object. Because not all Models support all resource configuration types,
   * the configuration types this Model supports are listed here. If no
   * configuration types are listed, the Model cannot be deployed to an
   * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
   * online predictions
   * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
   * Such a Model can serve predictions by using a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
   * has at least one entry each in
   * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
   * and
   * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The supportedDeploymentResourcesTypes at the given index.
   */
  com.google.cloud.aiplatform.v1.Model.DeploymentResourcesType getSupportedDeploymentResourcesTypes(
      int index);

  /**
   *
   *
   * <pre>
   * Output only. When this Model is deployed, its prediction resources are
   * described by the `prediction_resources` field of the
   * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
   * object. Because not all Models support all resource configuration types,
   * the configuration types this Model supports are listed here. If no
   * configuration types are listed, the Model cannot be deployed to an
   * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
   * online predictions
   * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
   * Such a Model can serve predictions by using a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
   * has at least one entry each in
   * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
   * and
   * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for
   *     supportedDeploymentResourcesTypes.
   */
  java.util.List<java.lang.Integer> getSupportedDeploymentResourcesTypesValueList();

  /**
   *
   *
   * <pre>
   * Output only. When this Model is deployed, its prediction resources are
   * described by the `prediction_resources` field of the
   * [Endpoint.deployed_models][google.cloud.aiplatform.v1.Endpoint.deployed_models]
   * object. Because not all Models support all resource configuration types,
   * the configuration types this Model supports are listed here. If no
   * configuration types are listed, the Model cannot be deployed to an
   * [Endpoint][google.cloud.aiplatform.v1.Endpoint] and does not support
   * online predictions
   * ([PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain]).
   * Such a Model can serve predictions by using a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob], if it
   * has at least one entry each in
   * [supported_input_storage_formats][google.cloud.aiplatform.v1.Model.supported_input_storage_formats]
   * and
   * [supported_output_storage_formats][google.cloud.aiplatform.v1.Model.supported_output_storage_formats].
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Model.DeploymentResourcesType supported_deployment_resources_types = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of supportedDeploymentResourcesTypes at the given
   *     index.
   */
  int getSupportedDeploymentResourcesTypesValue(int index);

  /**
   *
   *
   * <pre>
   * Output only. The formats this Model supports in
   * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
   * If
   * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
   * exists, the instances should be given as per that schema.
   *
   * The possible formats are:
   *
   * * `jsonl`
   * The JSON Lines format, where each instance is a single line. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `csv`
   * The CSV format, where each instance is a single comma-separated line.
   * The first line in the file is the header, containing comma-separated field
   * names. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `tf-record`
   * The TFRecord format, where each instance is a single record in tfrecord
   * syntax. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `tf-record-gzip`
   * Similar to `tf-record`, but the file is gzipped. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `bigquery`
   * Each instance is a single row in BigQuery. Uses
   * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
   *
   * * `file-list`
   * Each line of the file is the location of an instance to process, uses
   * `gcs_source` field of the
   * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
   * object.
   *
   *
   * If this Model doesn't support any of these formats it means it cannot be
   * used with a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * However, if it has
   * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
   * it could serve online predictions by using
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>
   * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the supportedInputStorageFormats.
   */
  java.util.List<java.lang.String> getSupportedInputStorageFormatsList();

  /**
   *
   *
   * <pre>
   * Output only. The formats this Model supports in
   * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
   * If
   * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
   * exists, the instances should be given as per that schema.
   *
   * The possible formats are:
   *
   * * `jsonl`
   * The JSON Lines format, where each instance is a single line. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `csv`
   * The CSV format, where each instance is a single comma-separated line.
   * The first line in the file is the header, containing comma-separated field
   * names. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `tf-record`
   * The TFRecord format, where each instance is a single record in tfrecord
   * syntax. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `tf-record-gzip`
   * Similar to `tf-record`, but the file is gzipped. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `bigquery`
   * Each instance is a single row in BigQuery. Uses
   * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
   *
   * * `file-list`
   * Each line of the file is the location of an instance to process, uses
   * `gcs_source` field of the
   * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
   * object.
   *
   *
   * If this Model doesn't support any of these formats it means it cannot be
   * used with a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * However, if it has
   * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
   * it could serve online predictions by using
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>
   * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of supportedInputStorageFormats.
   */
  int getSupportedInputStorageFormatsCount();

  /**
   *
   *
   * <pre>
   * Output only. The formats this Model supports in
   * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
   * If
   * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
   * exists, the instances should be given as per that schema.
   *
   * The possible formats are:
   *
   * * `jsonl`
   * The JSON Lines format, where each instance is a single line. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `csv`
   * The CSV format, where each instance is a single comma-separated line.
   * The first line in the file is the header, containing comma-separated field
   * names. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `tf-record`
   * The TFRecord format, where each instance is a single record in tfrecord
   * syntax. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `tf-record-gzip`
   * Similar to `tf-record`, but the file is gzipped. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `bigquery`
   * Each instance is a single row in BigQuery. Uses
   * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
   *
   * * `file-list`
   * Each line of the file is the location of an instance to process, uses
   * `gcs_source` field of the
   * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
   * object.
   *
   *
   * If this Model doesn't support any of these formats it means it cannot be
   * used with a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * However, if it has
   * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
   * it could serve online predictions by using
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>
   * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The supportedInputStorageFormats at the given index.
   */
  java.lang.String getSupportedInputStorageFormats(int index);

  /**
   *
   *
   * <pre>
   * Output only. The formats this Model supports in
   * [BatchPredictionJob.input_config][google.cloud.aiplatform.v1.BatchPredictionJob.input_config].
   * If
   * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
   * exists, the instances should be given as per that schema.
   *
   * The possible formats are:
   *
   * * `jsonl`
   * The JSON Lines format, where each instance is a single line. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `csv`
   * The CSV format, where each instance is a single comma-separated line.
   * The first line in the file is the header, containing comma-separated field
   * names. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `tf-record`
   * The TFRecord format, where each instance is a single record in tfrecord
   * syntax. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `tf-record-gzip`
   * Similar to `tf-record`, but the file is gzipped. Uses
   * [GcsSource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.gcs_source].
   *
   * * `bigquery`
   * Each instance is a single row in BigQuery. Uses
   * [BigQuerySource][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig.bigquery_source].
   *
   * * `file-list`
   * Each line of the file is the location of an instance to process, uses
   * `gcs_source` field of the
   * [InputConfig][google.cloud.aiplatform.v1.BatchPredictionJob.InputConfig]
   * object.
   *
   *
   * If this Model doesn't support any of these formats it means it cannot be
   * used with a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * However, if it has
   * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
   * it could serve online predictions by using
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>
   * repeated string supported_input_storage_formats = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the supportedInputStorageFormats at the given index.
   */
  com.google.protobuf.ByteString getSupportedInputStorageFormatsBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. The formats this Model supports in
   * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
   * If both
   * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
   * and
   * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
   * exist, the predictions are returned together with their instances. In other
   * words, the prediction has the original instance data first, followed by the
   * actual prediction content (as per the schema).
   *
   * The possible formats are:
   *
   * * `jsonl`
   * The JSON Lines format, where each prediction is a single line. Uses
   * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
   *
   * * `csv`
   * The CSV format, where each prediction is a single comma-separated line.
   * The first line in the file is the header, containing comma-separated field
   * names. Uses
   * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
   *
   * * `bigquery`
   * Each prediction is a single row in a BigQuery table, uses
   * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
   * .
   *
   *
   * If this Model doesn't support any of these formats it means it cannot be
   * used with a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * However, if it has
   * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
   * it could serve online predictions by using
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>
   * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return A list containing the supportedOutputStorageFormats.
   */
  java.util.List<java.lang.String> getSupportedOutputStorageFormatsList();

  /**
   *
   *
   * <pre>
   * Output only. The formats this Model supports in
   * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
   * If both
   * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
   * and
   * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
   * exist, the predictions are returned together with their instances. In other
   * words, the prediction has the original instance data first, followed by the
   * actual prediction content (as per the schema).
   *
   * The possible formats are:
   *
   * * `jsonl`
   * The JSON Lines format, where each prediction is a single line. Uses
   * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
   *
   * * `csv`
   * The CSV format, where each prediction is a single comma-separated line.
   * The first line in the file is the header, containing comma-separated field
   * names. Uses
   * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
   *
   * * `bigquery`
   * Each prediction is a single row in a BigQuery table, uses
   * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
   * .
   *
   *
   * If this Model doesn't support any of these formats it means it cannot be
   * used with a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * However, if it has
   * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
   * it could serve online predictions by using
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>
   * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The count of supportedOutputStorageFormats.
   */
  int getSupportedOutputStorageFormatsCount();

  /**
   *
   *
   * <pre>
   * Output only. The formats this Model supports in
   * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
   * If both
   * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
   * and
   * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
   * exist, the predictions are returned together with their instances. In other
   * words, the prediction has the original instance data first, followed by the
   * actual prediction content (as per the schema).
   *
   * The possible formats are:
   *
   * * `jsonl`
   * The JSON Lines format, where each prediction is a single line. Uses
   * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
   *
   * * `csv`
   * The CSV format, where each prediction is a single comma-separated line.
   * The first line in the file is the header, containing comma-separated field
   * names. Uses
   * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
   *
   * * `bigquery`
   * Each prediction is a single row in a BigQuery table, uses
   * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
   * .
   *
   *
   * If this Model doesn't support any of these formats it means it cannot be
   * used with a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * However, if it has
   * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
   * it could serve online predictions by using
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>
   * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the element to return.
   * @return The supportedOutputStorageFormats at the given index.
   */
  java.lang.String getSupportedOutputStorageFormats(int index);

  /**
   *
   *
   * <pre>
   * Output only. The formats this Model supports in
   * [BatchPredictionJob.output_config][google.cloud.aiplatform.v1.BatchPredictionJob.output_config].
   * If both
   * [PredictSchemata.instance_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.instance_schema_uri]
   * and
   * [PredictSchemata.prediction_schema_uri][google.cloud.aiplatform.v1.PredictSchemata.prediction_schema_uri]
   * exist, the predictions are returned together with their instances. In other
   * words, the prediction has the original instance data first, followed by the
   * actual prediction content (as per the schema).
   *
   * The possible formats are:
   *
   * * `jsonl`
   * The JSON Lines format, where each prediction is a single line. Uses
   * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
   *
   * * `csv`
   * The CSV format, where each prediction is a single comma-separated line.
   * The first line in the file is the header, containing comma-separated field
   * names. Uses
   * [GcsDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.gcs_destination].
   *
   * * `bigquery`
   * Each prediction is a single row in a BigQuery table, uses
   * [BigQueryDestination][google.cloud.aiplatform.v1.BatchPredictionJob.OutputConfig.bigquery_destination]
   * .
   *
   *
   * If this Model doesn't support any of these formats it means it cannot be
   * used with a
   * [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * However, if it has
   * [supported_deployment_resources_types][google.cloud.aiplatform.v1.Model.supported_deployment_resources_types],
   * it could serve online predictions by using
   * [PredictionService.Predict][google.cloud.aiplatform.v1.PredictionService.Predict]
   * or
   * [PredictionService.Explain][google.cloud.aiplatform.v1.PredictionService.Explain].
   * </pre>
   *
   * <code>
   * repeated string supported_output_storage_formats = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the supportedOutputStorageFormats at the given index.
   */
  com.google.protobuf.ByteString getSupportedOutputStorageFormatsBytes(int index);

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Model was uploaded into Vertex AI.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  boolean hasCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Model was uploaded into Vertex AI.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  com.google.protobuf.Timestamp getCreateTime();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Model was uploaded into Vertex AI.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Model was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  boolean hasUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Model was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  com.google.protobuf.Timestamp getUpdateTime();

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this Model was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The pointers to DeployedModels created from this Model. Note
   * that Model could have been deployed to Endpoints in different Locations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<com.google.cloud.aiplatform.v1.DeployedModelRef> getDeployedModelsList();

  /**
   *
   *
   * <pre>
   * Output only. The pointers to DeployedModels created from this Model. Note
   * that Model could have been deployed to Endpoints in different Locations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1.DeployedModelRef getDeployedModels(int index);

  /**
   *
   *
   * <pre>
   * Output only. The pointers to DeployedModels created from this Model. Note
   * that Model could have been deployed to Endpoints in different Locations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  int getDeployedModelsCount();

  /**
   *
   *
   * <pre>
   * Output only. The pointers to DeployedModels created from this Model. Note
   * that Model could have been deployed to Endpoints in different Locations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  java.util.List<? extends com.google.cloud.aiplatform.v1.DeployedModelRefOrBuilder>
      getDeployedModelsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Output only. The pointers to DeployedModels created from this Model. Note
   * that Model could have been deployed to Endpoints in different Locations.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.DeployedModelRef deployed_models = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1.DeployedModelRefOrBuilder getDeployedModelsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * The default explanation specification for this Model.
   *
   * The Model can be used for
   * [requesting
   * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] after
   * being [deployed][google.cloud.aiplatform.v1.EndpointService.DeployModel] if
   * it is populated. The Model can be used for [batch
   * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
   * if it is populated.
   *
   * All fields of the explanation_spec can be overridden by
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * of
   * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model],
   * or
   * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
   * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   *
   * If the default explanation specification is not set for this Model, this
   * Model can still be used for
   * [requesting
   * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] by
   * setting
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * of
   * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model]
   * and for [batch
   * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
   * by setting
   * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
   * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 23;</code>
   *
   * @return Whether the explanationSpec field is set.
   */
  boolean hasExplanationSpec();

  /**
   *
   *
   * <pre>
   * The default explanation specification for this Model.
   *
   * The Model can be used for
   * [requesting
   * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] after
   * being [deployed][google.cloud.aiplatform.v1.EndpointService.DeployModel] if
   * it is populated. The Model can be used for [batch
   * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
   * if it is populated.
   *
   * All fields of the explanation_spec can be overridden by
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * of
   * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model],
   * or
   * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
   * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   *
   * If the default explanation specification is not set for this Model, this
   * Model can still be used for
   * [requesting
   * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] by
   * setting
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * of
   * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model]
   * and for [batch
   * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
   * by setting
   * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
   * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 23;</code>
   *
   * @return The explanationSpec.
   */
  com.google.cloud.aiplatform.v1.ExplanationSpec getExplanationSpec();

  /**
   *
   *
   * <pre>
   * The default explanation specification for this Model.
   *
   * The Model can be used for
   * [requesting
   * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] after
   * being [deployed][google.cloud.aiplatform.v1.EndpointService.DeployModel] if
   * it is populated. The Model can be used for [batch
   * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
   * if it is populated.
   *
   * All fields of the explanation_spec can be overridden by
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * of
   * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model],
   * or
   * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
   * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   *
   * If the default explanation specification is not set for this Model, this
   * Model can still be used for
   * [requesting
   * explanation][google.cloud.aiplatform.v1.PredictionService.Explain] by
   * setting
   * [explanation_spec][google.cloud.aiplatform.v1.DeployedModel.explanation_spec]
   * of
   * [DeployModelRequest.deployed_model][google.cloud.aiplatform.v1.DeployModelRequest.deployed_model]
   * and for [batch
   * explanation][google.cloud.aiplatform.v1.BatchPredictionJob.generate_explanation]
   * by setting
   * [explanation_spec][google.cloud.aiplatform.v1.BatchPredictionJob.explanation_spec]
   * of [BatchPredictionJob][google.cloud.aiplatform.v1.BatchPredictionJob].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ExplanationSpec explanation_spec = 23;</code>
   */
  com.google.cloud.aiplatform.v1.ExplanationSpecOrBuilder getExplanationSpecOrBuilder();

  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 16;</code>
   *
   * @return The etag.
   */
  java.lang.String getEtag();

  /**
   *
   *
   * <pre>
   * Used to perform consistent read-modify-write updates. If not set, a blind
   * "overwrite" update happens.
   * </pre>
   *
   * <code>string etag = 16;</code>
   *
   * @return The bytes for etag.
   */
  com.google.protobuf.ByteString getEtagBytes();

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Models.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  int getLabelsCount();

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Models.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  boolean containsLabels(java.lang.String key);

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getLabels();

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Models.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getLabelsMap();

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Models.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  /* nullable */
  java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);

  /**
   *
   *
   * <pre>
   * The labels with user-defined metadata to organize your Models.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 17;</code>
   */
  java.lang.String getLabelsOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Stats of data used for training or evaluating the Model.
   *
   * Only populated when the Model is trained by a TrainingPipeline with
   * [data_input_config][google.cloud.aiplatform.v1.TrainingPipeline.input_data_config].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Model.DataStats data_stats = 21;</code>
   *
   * @return Whether the dataStats field is set.
   */
  boolean hasDataStats();

  /**
   *
   *
   * <pre>
   * Stats of data used for training or evaluating the Model.
   *
   * Only populated when the Model is trained by a TrainingPipeline with
   * [data_input_config][google.cloud.aiplatform.v1.TrainingPipeline.input_data_config].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Model.DataStats data_stats = 21;</code>
   *
   * @return The dataStats.
   */
  com.google.cloud.aiplatform.v1.Model.DataStats getDataStats();

  /**
   *
   *
   * <pre>
   * Stats of data used for training or evaluating the Model.
   *
   * Only populated when the Model is trained by a TrainingPipeline with
   * [data_input_config][google.cloud.aiplatform.v1.TrainingPipeline.input_data_config].
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.Model.DataStats data_stats = 21;</code>
   */
  com.google.cloud.aiplatform.v1.Model.DataStatsOrBuilder getDataStatsOrBuilder();

  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a Model. If set, this
   * Model and all sub-resources of this Model will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  boolean hasEncryptionSpec();

  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a Model. If set, this
   * Model and all sub-resources of this Model will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
   *
   * @return The encryptionSpec.
   */
  com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec();

  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a Model. If set, this
   * Model and all sub-resources of this Model will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 24;</code>
   */
  com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Source of a model. It can either be automl training pipeline,
   * custom training pipeline, BigQuery ML, or saved and tuned from Genie or
   * Model Garden.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelSourceInfo model_source_info = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the modelSourceInfo field is set.
   */
  boolean hasModelSourceInfo();

  /**
   *
   *
   * <pre>
   * Output only. Source of a model. It can either be automl training pipeline,
   * custom training pipeline, BigQuery ML, or saved and tuned from Genie or
   * Model Garden.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelSourceInfo model_source_info = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The modelSourceInfo.
   */
  com.google.cloud.aiplatform.v1.ModelSourceInfo getModelSourceInfo();

  /**
   *
   *
   * <pre>
   * Output only. Source of a model. It can either be automl training pipeline,
   * custom training pipeline, BigQuery ML, or saved and tuned from Genie or
   * Model Garden.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ModelSourceInfo model_source_info = 38 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1.ModelSourceInfoOrBuilder getModelSourceInfoOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. If this Model is a copy of another Model, this contains info
   * about the original.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Model.OriginalModelInfo original_model_info = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the originalModelInfo field is set.
   */
  boolean hasOriginalModelInfo();

  /**
   *
   *
   * <pre>
   * Output only. If this Model is a copy of another Model, this contains info
   * about the original.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Model.OriginalModelInfo original_model_info = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The originalModelInfo.
   */
  com.google.cloud.aiplatform.v1.Model.OriginalModelInfo getOriginalModelInfo();

  /**
   *
   *
   * <pre>
   * Output only. If this Model is a copy of another Model, this contains info
   * about the original.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Model.OriginalModelInfo original_model_info = 34 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  com.google.cloud.aiplatform.v1.Model.OriginalModelInfoOrBuilder getOriginalModelInfoOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Artifact that was created in
   * MetadataStore when creating the Model. The Artifact resource name pattern
   * is
   * `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
   * </pre>
   *
   * <code>string metadata_artifact = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The metadataArtifact.
   */
  java.lang.String getMetadataArtifact();

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the Artifact that was created in
   * MetadataStore when creating the Model. The Artifact resource name pattern
   * is
   * `projects/{project}/locations/{location}/metadataStores/{metadata_store}/artifacts/{artifact}`.
   * </pre>
   *
   * <code>string metadata_artifact = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for metadataArtifact.
   */
  com.google.protobuf.ByteString getMetadataArtifactBytes();

  /**
   *
   *
   * <pre>
   * Optional. User input field to specify the base model source. Currently it
   * only supports specifing the Model Garden models and Genie models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Model.BaseModelSource base_model_source = 50 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the baseModelSource field is set.
   */
  boolean hasBaseModelSource();

  /**
   *
   *
   * <pre>
   * Optional. User input field to specify the base model source. Currently it
   * only supports specifing the Model Garden models and Genie models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Model.BaseModelSource base_model_source = 50 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The baseModelSource.
   */
  com.google.cloud.aiplatform.v1.Model.BaseModelSource getBaseModelSource();

  /**
   *
   *
   * <pre>
   * Optional. User input field to specify the base model source. Currently it
   * only supports specifing the Model Garden models and Genie models.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.Model.BaseModelSource base_model_source = 50 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.aiplatform.v1.Model.BaseModelSourceOrBuilder getBaseModelSourceOrBuilder();

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 51 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  boolean getSatisfiesPzs();

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzi = 52 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzi.
   */
  boolean getSatisfiesPzi();

  /**
   *
   *
   * <pre>
   * Optional. Output only. The checkpoints of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Checkpoint checkpoints = 57 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<com.google.cloud.aiplatform.v1.Checkpoint> getCheckpointsList();

  /**
   *
   *
   * <pre>
   * Optional. Output only. The checkpoints of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Checkpoint checkpoints = 57 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.aiplatform.v1.Checkpoint getCheckpoints(int index);

  /**
   *
   *
   * <pre>
   * Optional. Output only. The checkpoints of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Checkpoint checkpoints = 57 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  int getCheckpointsCount();

  /**
   *
   *
   * <pre>
   * Optional. Output only. The checkpoints of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Checkpoint checkpoints = 57 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  java.util.List<? extends com.google.cloud.aiplatform.v1.CheckpointOrBuilder>
      getCheckpointsOrBuilderList();

  /**
   *
   *
   * <pre>
   * Optional. Output only. The checkpoints of the model.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1.Checkpoint checkpoints = 57 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  com.google.cloud.aiplatform.v1.CheckpointOrBuilder getCheckpointsOrBuilder(int index);
}
