/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/vertex_rag_data.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * A RagCorpus is a RagFile container and a project can have multiple
 * RagCorpora.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.RagCorpus}
 */
public final class RagCorpus extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RagCorpus)
    RagCorpusOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RagCorpus.newBuilder() to construct.
  private RagCorpus(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RagCorpus() {
    name_ = "";
    displayName_ = "";
    description_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RagCorpus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1_RagCorpus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1_RagCorpus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.RagCorpus.class,
            com.google.cloud.aiplatform.v1.RagCorpus.Builder.class);
  }

  private int bitField0_;
  private int backendConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object backendConfig_;

  public enum BackendConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VECTOR_DB_CONFIG(9),
    VERTEX_AI_SEARCH_CONFIG(10),
    BACKENDCONFIG_NOT_SET(0);
    private final int value;

    private BackendConfigCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static BackendConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static BackendConfigCase forNumber(int value) {
      switch (value) {
        case 9:
          return VECTOR_DB_CONFIG;
        case 10:
          return VERTEX_AI_SEARCH_CONFIG;
        case 0:
          return BACKENDCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public BackendConfigCase getBackendConfigCase() {
    return BackendConfigCase.forNumber(backendConfigCase_);
  }

  public static final int VECTOR_DB_CONFIG_FIELD_NUMBER = 9;

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The config for the Vector DBs.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagVectorDbConfig vector_db_config = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the vectorDbConfig field is set.
   */
  @java.lang.Override
  public boolean hasVectorDbConfig() {
    return backendConfigCase_ == 9;
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The config for the Vector DBs.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagVectorDbConfig vector_db_config = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The vectorDbConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagVectorDbConfig getVectorDbConfig() {
    if (backendConfigCase_ == 9) {
      return (com.google.cloud.aiplatform.v1.RagVectorDbConfig) backendConfig_;
    }
    return com.google.cloud.aiplatform.v1.RagVectorDbConfig.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The config for the Vector DBs.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagVectorDbConfig vector_db_config = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagVectorDbConfigOrBuilder getVectorDbConfigOrBuilder() {
    if (backendConfigCase_ == 9) {
      return (com.google.cloud.aiplatform.v1.RagVectorDbConfig) backendConfig_;
    }
    return com.google.cloud.aiplatform.v1.RagVectorDbConfig.getDefaultInstance();
  }

  public static final int VERTEX_AI_SEARCH_CONFIG_FIELD_NUMBER = 10;

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The config for the Vertex AI Search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.VertexAiSearchConfig vertex_ai_search_config = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return Whether the vertexAiSearchConfig field is set.
   */
  @java.lang.Override
  public boolean hasVertexAiSearchConfig() {
    return backendConfigCase_ == 10;
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The config for the Vertex AI Search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.VertexAiSearchConfig vertex_ai_search_config = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   *
   * @return The vertexAiSearchConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.VertexAiSearchConfig getVertexAiSearchConfig() {
    if (backendConfigCase_ == 10) {
      return (com.google.cloud.aiplatform.v1.VertexAiSearchConfig) backendConfig_;
    }
    return com.google.cloud.aiplatform.v1.VertexAiSearchConfig.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The config for the Vertex AI Search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.VertexAiSearchConfig vertex_ai_search_config = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.VertexAiSearchConfigOrBuilder
      getVertexAiSearchConfigOrBuilder() {
    if (backendConfigCase_ == 10) {
      return (com.google.cloud.aiplatform.v1.VertexAiSearchConfig) backendConfig_;
    }
    return com.google.cloud.aiplatform.v1.VertexAiSearchConfig.getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the RagCorpus.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Output only. The resource name of the RagCorpus.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Required. The display name of the RagCorpus.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The display name of the RagCorpus.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The description of the RagCorpus.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The description of the RagCorpus.
   * </pre>
   *
   * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 4;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this RagCorpus was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this RagCorpus was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this RagCorpus was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 5;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this RagCorpus was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this RagCorpus was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this RagCorpus was last updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int CORPUS_STATUS_FIELD_NUMBER = 8;
  private com.google.cloud.aiplatform.v1.CorpusStatus corpusStatus_;

  /**
   *
   *
   * <pre>
   * Output only. RagCorpus state.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.CorpusStatus corpus_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the corpusStatus field is set.
   */
  @java.lang.Override
  public boolean hasCorpusStatus() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. RagCorpus state.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.CorpusStatus corpus_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The corpusStatus.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.CorpusStatus getCorpusStatus() {
    return corpusStatus_ == null
        ? com.google.cloud.aiplatform.v1.CorpusStatus.getDefaultInstance()
        : corpusStatus_;
  }

  /**
   *
   *
   * <pre>
   * Output only. RagCorpus state.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.CorpusStatus corpus_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.CorpusStatusOrBuilder getCorpusStatusOrBuilder() {
    return corpusStatus_ == null
        ? com.google.cloud.aiplatform.v1.CorpusStatus.getDefaultInstance()
        : corpusStatus_;
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 12;
  private com.google.cloud.aiplatform.v1.EncryptionSpec encryptionSpec_;

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The CMEK key name used to encrypt at-rest data related
   * to this Corpus. Only applicable to RagManagedDb option for Vector DB. This
   * field can only be set at corpus creation time, and cannot be updated or
   * deleted.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The CMEK key name used to encrypt at-rest data related
   * to this Corpus. Only applicable to RagManagedDb option for Vector DB. This
   * field can only be set at corpus creation time, and cannot be updated or
   * deleted.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Immutable. The CMEK key name used to encrypt at-rest data related
   * to this Corpus. Only applicable to RagManagedDb option for Vector DB. This
   * field can only be set at corpus creation time, and cannot be updated or
   * deleted.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(4, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(5, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getCorpusStatus());
    }
    if (backendConfigCase_ == 9) {
      output.writeMessage(9, (com.google.cloud.aiplatform.v1.RagVectorDbConfig) backendConfig_);
    }
    if (backendConfigCase_ == 10) {
      output.writeMessage(10, (com.google.cloud.aiplatform.v1.VertexAiSearchConfig) backendConfig_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(12, getEncryptionSpec());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getCreateTime());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getUpdateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getCorpusStatus());
    }
    if (backendConfigCase_ == 9) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              9, (com.google.cloud.aiplatform.v1.RagVectorDbConfig) backendConfig_);
    }
    if (backendConfigCase_ == 10) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              10, (com.google.cloud.aiplatform.v1.VertexAiSearchConfig) backendConfig_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getEncryptionSpec());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.RagCorpus)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.RagCorpus other = (com.google.cloud.aiplatform.v1.RagCorpus) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (hasCorpusStatus() != other.hasCorpusStatus()) return false;
    if (hasCorpusStatus()) {
      if (!getCorpusStatus().equals(other.getCorpusStatus())) return false;
    }
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (!getBackendConfigCase().equals(other.getBackendConfigCase())) return false;
    switch (backendConfigCase_) {
      case 9:
        if (!getVectorDbConfig().equals(other.getVectorDbConfig())) return false;
        break;
      case 10:
        if (!getVertexAiSearchConfig().equals(other.getVertexAiSearchConfig())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (hasCorpusStatus()) {
      hash = (37 * hash) + CORPUS_STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getCorpusStatus().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    switch (backendConfigCase_) {
      case 9:
        hash = (37 * hash) + VECTOR_DB_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getVectorDbConfig().hashCode();
        break;
      case 10:
        hash = (37 * hash) + VERTEX_AI_SEARCH_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getVertexAiSearchConfig().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.RagCorpus parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagCorpus parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagCorpus parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagCorpus parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagCorpus parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagCorpus parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagCorpus parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagCorpus parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagCorpus parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagCorpus parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagCorpus parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagCorpus parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.RagCorpus prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A RagCorpus is a RagFile container and a project can have multiple
   * RagCorpora.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.RagCorpus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RagCorpus)
      com.google.cloud.aiplatform.v1.RagCorpusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagCorpus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagCorpus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.RagCorpus.class,
              com.google.cloud.aiplatform.v1.RagCorpus.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.RagCorpus.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getCorpusStatusFieldBuilder();
        getEncryptionSpecFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (vectorDbConfigBuilder_ != null) {
        vectorDbConfigBuilder_.clear();
      }
      if (vertexAiSearchConfigBuilder_ != null) {
        vertexAiSearchConfigBuilder_.clear();
      }
      name_ = "";
      displayName_ = "";
      description_ = "";
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      corpusStatus_ = null;
      if (corpusStatusBuilder_ != null) {
        corpusStatusBuilder_.dispose();
        corpusStatusBuilder_ = null;
      }
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      backendConfigCase_ = 0;
      backendConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagCorpus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagCorpus getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.RagCorpus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagCorpus build() {
      com.google.cloud.aiplatform.v1.RagCorpus result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagCorpus buildPartial() {
      com.google.cloud.aiplatform.v1.RagCorpus result =
          new com.google.cloud.aiplatform.v1.RagCorpus(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.RagCorpus result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.corpusStatus_ =
            corpusStatusBuilder_ == null ? corpusStatus_ : corpusStatusBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.RagCorpus result) {
      result.backendConfigCase_ = backendConfigCase_;
      result.backendConfig_ = this.backendConfig_;
      if (backendConfigCase_ == 9 && vectorDbConfigBuilder_ != null) {
        result.backendConfig_ = vectorDbConfigBuilder_.build();
      }
      if (backendConfigCase_ == 10 && vertexAiSearchConfigBuilder_ != null) {
        result.backendConfig_ = vertexAiSearchConfigBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.RagCorpus) {
        return mergeFrom((com.google.cloud.aiplatform.v1.RagCorpus) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.RagCorpus other) {
      if (other == com.google.cloud.aiplatform.v1.RagCorpus.getDefaultInstance()) return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.hasCorpusStatus()) {
        mergeCorpusStatus(other.getCorpusStatus());
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      switch (other.getBackendConfigCase()) {
        case VECTOR_DB_CONFIG:
          {
            mergeVectorDbConfig(other.getVectorDbConfig());
            break;
          }
        case VERTEX_AI_SEARCH_CONFIG:
          {
            mergeVertexAiSearchConfig(other.getVertexAiSearchConfig());
            break;
          }
        case BACKENDCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 34
            case 42:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 42
            case 66:
              {
                input.readMessage(getCorpusStatusFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getVectorDbConfigFieldBuilder().getBuilder(), extensionRegistry);
                backendConfigCase_ = 9;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(
                    getVertexAiSearchConfigFieldBuilder().getBuilder(), extensionRegistry);
                backendConfigCase_ = 10;
                break;
              } // case 82
            case 98:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 98
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int backendConfigCase_ = 0;
    private java.lang.Object backendConfig_;

    public BackendConfigCase getBackendConfigCase() {
      return BackendConfigCase.forNumber(backendConfigCase_);
    }

    public Builder clearBackendConfig() {
      backendConfigCase_ = 0;
      backendConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagVectorDbConfig,
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.Builder,
            com.google.cloud.aiplatform.v1.RagVectorDbConfigOrBuilder>
        vectorDbConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vector DBs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig vector_db_config = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the vectorDbConfig field is set.
     */
    @java.lang.Override
    public boolean hasVectorDbConfig() {
      return backendConfigCase_ == 9;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vector DBs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig vector_db_config = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The vectorDbConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig getVectorDbConfig() {
      if (vectorDbConfigBuilder_ == null) {
        if (backendConfigCase_ == 9) {
          return (com.google.cloud.aiplatform.v1.RagVectorDbConfig) backendConfig_;
        }
        return com.google.cloud.aiplatform.v1.RagVectorDbConfig.getDefaultInstance();
      } else {
        if (backendConfigCase_ == 9) {
          return vectorDbConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.RagVectorDbConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vector DBs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig vector_db_config = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setVectorDbConfig(com.google.cloud.aiplatform.v1.RagVectorDbConfig value) {
      if (vectorDbConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        backendConfig_ = value;
        onChanged();
      } else {
        vectorDbConfigBuilder_.setMessage(value);
      }
      backendConfigCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vector DBs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig vector_db_config = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setVectorDbConfig(
        com.google.cloud.aiplatform.v1.RagVectorDbConfig.Builder builderForValue) {
      if (vectorDbConfigBuilder_ == null) {
        backendConfig_ = builderForValue.build();
        onChanged();
      } else {
        vectorDbConfigBuilder_.setMessage(builderForValue.build());
      }
      backendConfigCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vector DBs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig vector_db_config = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeVectorDbConfig(com.google.cloud.aiplatform.v1.RagVectorDbConfig value) {
      if (vectorDbConfigBuilder_ == null) {
        if (backendConfigCase_ == 9
            && backendConfig_
                != com.google.cloud.aiplatform.v1.RagVectorDbConfig.getDefaultInstance()) {
          backendConfig_ =
              com.google.cloud.aiplatform.v1.RagVectorDbConfig.newBuilder(
                      (com.google.cloud.aiplatform.v1.RagVectorDbConfig) backendConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          backendConfig_ = value;
        }
        onChanged();
      } else {
        if (backendConfigCase_ == 9) {
          vectorDbConfigBuilder_.mergeFrom(value);
        } else {
          vectorDbConfigBuilder_.setMessage(value);
        }
      }
      backendConfigCase_ = 9;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vector DBs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig vector_db_config = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearVectorDbConfig() {
      if (vectorDbConfigBuilder_ == null) {
        if (backendConfigCase_ == 9) {
          backendConfigCase_ = 0;
          backendConfig_ = null;
          onChanged();
        }
      } else {
        if (backendConfigCase_ == 9) {
          backendConfigCase_ = 0;
          backendConfig_ = null;
        }
        vectorDbConfigBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vector DBs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig vector_db_config = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.RagVectorDbConfig.Builder getVectorDbConfigBuilder() {
      return getVectorDbConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vector DBs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig vector_db_config = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagVectorDbConfigOrBuilder getVectorDbConfigOrBuilder() {
      if ((backendConfigCase_ == 9) && (vectorDbConfigBuilder_ != null)) {
        return vectorDbConfigBuilder_.getMessageOrBuilder();
      } else {
        if (backendConfigCase_ == 9) {
          return (com.google.cloud.aiplatform.v1.RagVectorDbConfig) backendConfig_;
        }
        return com.google.cloud.aiplatform.v1.RagVectorDbConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vector DBs.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagVectorDbConfig vector_db_config = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagVectorDbConfig,
            com.google.cloud.aiplatform.v1.RagVectorDbConfig.Builder,
            com.google.cloud.aiplatform.v1.RagVectorDbConfigOrBuilder>
        getVectorDbConfigFieldBuilder() {
      if (vectorDbConfigBuilder_ == null) {
        if (!(backendConfigCase_ == 9)) {
          backendConfig_ = com.google.cloud.aiplatform.v1.RagVectorDbConfig.getDefaultInstance();
        }
        vectorDbConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.RagVectorDbConfig,
                com.google.cloud.aiplatform.v1.RagVectorDbConfig.Builder,
                com.google.cloud.aiplatform.v1.RagVectorDbConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1.RagVectorDbConfig) backendConfig_,
                getParentForChildren(),
                isClean());
        backendConfig_ = null;
      }
      backendConfigCase_ = 9;
      onChanged();
      return vectorDbConfigBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.VertexAiSearchConfig,
            com.google.cloud.aiplatform.v1.VertexAiSearchConfig.Builder,
            com.google.cloud.aiplatform.v1.VertexAiSearchConfigOrBuilder>
        vertexAiSearchConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vertex AI Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VertexAiSearchConfig vertex_ai_search_config = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return Whether the vertexAiSearchConfig field is set.
     */
    @java.lang.Override
    public boolean hasVertexAiSearchConfig() {
      return backendConfigCase_ == 10;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vertex AI Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VertexAiSearchConfig vertex_ai_search_config = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     *
     * @return The vertexAiSearchConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.VertexAiSearchConfig getVertexAiSearchConfig() {
      if (vertexAiSearchConfigBuilder_ == null) {
        if (backendConfigCase_ == 10) {
          return (com.google.cloud.aiplatform.v1.VertexAiSearchConfig) backendConfig_;
        }
        return com.google.cloud.aiplatform.v1.VertexAiSearchConfig.getDefaultInstance();
      } else {
        if (backendConfigCase_ == 10) {
          return vertexAiSearchConfigBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.VertexAiSearchConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vertex AI Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VertexAiSearchConfig vertex_ai_search_config = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setVertexAiSearchConfig(
        com.google.cloud.aiplatform.v1.VertexAiSearchConfig value) {
      if (vertexAiSearchConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        backendConfig_ = value;
        onChanged();
      } else {
        vertexAiSearchConfigBuilder_.setMessage(value);
      }
      backendConfigCase_ = 10;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vertex AI Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VertexAiSearchConfig vertex_ai_search_config = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder setVertexAiSearchConfig(
        com.google.cloud.aiplatform.v1.VertexAiSearchConfig.Builder builderForValue) {
      if (vertexAiSearchConfigBuilder_ == null) {
        backendConfig_ = builderForValue.build();
        onChanged();
      } else {
        vertexAiSearchConfigBuilder_.setMessage(builderForValue.build());
      }
      backendConfigCase_ = 10;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vertex AI Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VertexAiSearchConfig vertex_ai_search_config = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder mergeVertexAiSearchConfig(
        com.google.cloud.aiplatform.v1.VertexAiSearchConfig value) {
      if (vertexAiSearchConfigBuilder_ == null) {
        if (backendConfigCase_ == 10
            && backendConfig_
                != com.google.cloud.aiplatform.v1.VertexAiSearchConfig.getDefaultInstance()) {
          backendConfig_ =
              com.google.cloud.aiplatform.v1.VertexAiSearchConfig.newBuilder(
                      (com.google.cloud.aiplatform.v1.VertexAiSearchConfig) backendConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          backendConfig_ = value;
        }
        onChanged();
      } else {
        if (backendConfigCase_ == 10) {
          vertexAiSearchConfigBuilder_.mergeFrom(value);
        } else {
          vertexAiSearchConfigBuilder_.setMessage(value);
        }
      }
      backendConfigCase_ = 10;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vertex AI Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VertexAiSearchConfig vertex_ai_search_config = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public Builder clearVertexAiSearchConfig() {
      if (vertexAiSearchConfigBuilder_ == null) {
        if (backendConfigCase_ == 10) {
          backendConfigCase_ = 0;
          backendConfig_ = null;
          onChanged();
        }
      } else {
        if (backendConfigCase_ == 10) {
          backendConfigCase_ = 0;
          backendConfig_ = null;
        }
        vertexAiSearchConfigBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vertex AI Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VertexAiSearchConfig vertex_ai_search_config = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.VertexAiSearchConfig.Builder
        getVertexAiSearchConfigBuilder() {
      return getVertexAiSearchConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vertex AI Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VertexAiSearchConfig vertex_ai_search_config = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.VertexAiSearchConfigOrBuilder
        getVertexAiSearchConfigOrBuilder() {
      if ((backendConfigCase_ == 10) && (vertexAiSearchConfigBuilder_ != null)) {
        return vertexAiSearchConfigBuilder_.getMessageOrBuilder();
      } else {
        if (backendConfigCase_ == 10) {
          return (com.google.cloud.aiplatform.v1.VertexAiSearchConfig) backendConfig_;
        }
        return com.google.cloud.aiplatform.v1.VertexAiSearchConfig.getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The config for the Vertex AI Search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.VertexAiSearchConfig vertex_ai_search_config = 10 [(.google.api.field_behavior) = OPTIONAL, (.google.api.field_behavior) = IMMUTABLE];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.VertexAiSearchConfig,
            com.google.cloud.aiplatform.v1.VertexAiSearchConfig.Builder,
            com.google.cloud.aiplatform.v1.VertexAiSearchConfigOrBuilder>
        getVertexAiSearchConfigFieldBuilder() {
      if (vertexAiSearchConfigBuilder_ == null) {
        if (!(backendConfigCase_ == 10)) {
          backendConfig_ = com.google.cloud.aiplatform.v1.VertexAiSearchConfig.getDefaultInstance();
        }
        vertexAiSearchConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.VertexAiSearchConfig,
                com.google.cloud.aiplatform.v1.VertexAiSearchConfig.Builder,
                com.google.cloud.aiplatform.v1.VertexAiSearchConfigOrBuilder>(
                (com.google.cloud.aiplatform.v1.VertexAiSearchConfig) backendConfig_,
                getParentForChildren(),
                isClean());
        backendConfig_ = null;
      }
      backendConfigCase_ = 10;
      onChanged();
      return vertexAiSearchConfigBuilder_;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the RagCorpus.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the RagCorpus.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the RagCorpus.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the RagCorpus.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the RagCorpus.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Required. The display name of the RagCorpus.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The display name of the RagCorpus.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The display name of the RagCorpus.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The display name of the RagCorpus.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The display name of the RagCorpus.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The description of the RagCorpus.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The description of the RagCorpus.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The description of the RagCorpus.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The description of the RagCorpus.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The description of the RagCorpus.
     * </pre>
     *
     * <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this RagCorpus was last updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.cloud.aiplatform.v1.CorpusStatus corpusStatus_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.CorpusStatus,
            com.google.cloud.aiplatform.v1.CorpusStatus.Builder,
            com.google.cloud.aiplatform.v1.CorpusStatusOrBuilder>
        corpusStatusBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. RagCorpus state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorpusStatus corpus_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the corpusStatus field is set.
     */
    public boolean hasCorpusStatus() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. RagCorpus state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorpusStatus corpus_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The corpusStatus.
     */
    public com.google.cloud.aiplatform.v1.CorpusStatus getCorpusStatus() {
      if (corpusStatusBuilder_ == null) {
        return corpusStatus_ == null
            ? com.google.cloud.aiplatform.v1.CorpusStatus.getDefaultInstance()
            : corpusStatus_;
      } else {
        return corpusStatusBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. RagCorpus state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorpusStatus corpus_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCorpusStatus(com.google.cloud.aiplatform.v1.CorpusStatus value) {
      if (corpusStatusBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        corpusStatus_ = value;
      } else {
        corpusStatusBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. RagCorpus state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorpusStatus corpus_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCorpusStatus(
        com.google.cloud.aiplatform.v1.CorpusStatus.Builder builderForValue) {
      if (corpusStatusBuilder_ == null) {
        corpusStatus_ = builderForValue.build();
      } else {
        corpusStatusBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. RagCorpus state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorpusStatus corpus_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCorpusStatus(com.google.cloud.aiplatform.v1.CorpusStatus value) {
      if (corpusStatusBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && corpusStatus_ != null
            && corpusStatus_ != com.google.cloud.aiplatform.v1.CorpusStatus.getDefaultInstance()) {
          getCorpusStatusBuilder().mergeFrom(value);
        } else {
          corpusStatus_ = value;
        }
      } else {
        corpusStatusBuilder_.mergeFrom(value);
      }
      if (corpusStatus_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. RagCorpus state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorpusStatus corpus_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCorpusStatus() {
      bitField0_ = (bitField0_ & ~0x00000080);
      corpusStatus_ = null;
      if (corpusStatusBuilder_ != null) {
        corpusStatusBuilder_.dispose();
        corpusStatusBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. RagCorpus state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorpusStatus corpus_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.CorpusStatus.Builder getCorpusStatusBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getCorpusStatusFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. RagCorpus state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorpusStatus corpus_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.CorpusStatusOrBuilder getCorpusStatusOrBuilder() {
      if (corpusStatusBuilder_ != null) {
        return corpusStatusBuilder_.getMessageOrBuilder();
      } else {
        return corpusStatus_ == null
            ? com.google.cloud.aiplatform.v1.CorpusStatus.getDefaultInstance()
            : corpusStatus_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. RagCorpus state.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.CorpusStatus corpus_status = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.CorpusStatus,
            com.google.cloud.aiplatform.v1.CorpusStatus.Builder,
            com.google.cloud.aiplatform.v1.CorpusStatusOrBuilder>
        getCorpusStatusFieldBuilder() {
      if (corpusStatusBuilder_ == null) {
        corpusStatusBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.CorpusStatus,
                com.google.cloud.aiplatform.v1.CorpusStatus.Builder,
                com.google.cloud.aiplatform.v1.CorpusStatusOrBuilder>(
                getCorpusStatus(), getParentForChildren(), isClean());
        corpusStatus_ = null;
      }
      return corpusStatusBuilder_;
    }

    private com.google.cloud.aiplatform.v1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EncryptionSpec,
            com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The CMEK key name used to encrypt at-rest data related
     * to this Corpus. Only applicable to RagManagedDb option for Vector DB. This
     * field can only be set at corpus creation time, and cannot be updated or
     * deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The CMEK key name used to encrypt at-rest data related
     * to this Corpus. Only applicable to RagManagedDb option for Vector DB. This
     * field can only be set at corpus creation time, and cannot be updated or
     * deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The CMEK key name used to encrypt at-rest data related
     * to this Corpus. Only applicable to RagManagedDb option for Vector DB. This
     * field can only be set at corpus creation time, and cannot be updated or
     * deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The CMEK key name used to encrypt at-rest data related
     * to this Corpus. Only applicable to RagManagedDb option for Vector DB. This
     * field can only be set at corpus creation time, and cannot be updated or
     * deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The CMEK key name used to encrypt at-rest data related
     * to this Corpus. Only applicable to RagManagedDb option for Vector DB. This
     * field can only be set at corpus creation time, and cannot be updated or
     * deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      if (encryptionSpec_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The CMEK key name used to encrypt at-rest data related
     * to this Corpus. Only applicable to RagManagedDb option for Vector DB. This
     * field can only be set at corpus creation time, and cannot be updated or
     * deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x00000100);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The CMEK key name used to encrypt at-rest data related
     * to this Corpus. Only applicable to RagManagedDb option for Vector DB. This
     * field can only be set at corpus creation time, and cannot be updated or
     * deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The CMEK key name used to encrypt at-rest data related
     * to this Corpus. Only applicable to RagManagedDb option for Vector DB. This
     * field can only be set at corpus creation time, and cannot be updated or
     * deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Immutable. The CMEK key name used to encrypt at-rest data related
     * to this Corpus. Only applicable to RagManagedDb option for Vector DB. This
     * field can only be set at corpus creation time, and cannot be updated or
     * deleted.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EncryptionSpec,
            com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.EncryptionSpec,
                com.google.cloud.aiplatform.v1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RagCorpus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RagCorpus)
  private static final com.google.cloud.aiplatform.v1.RagCorpus DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.RagCorpus();
  }

  public static com.google.cloud.aiplatform.v1.RagCorpus getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RagCorpus> PARSER =
      new com.google.protobuf.AbstractParser<RagCorpus>() {
        @java.lang.Override
        public RagCorpus parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RagCorpus> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RagCorpus> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagCorpus getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
