/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/vertex_rag_data.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Config for the embedding model to use for RAG.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.RagEmbeddingModelConfig}
 */
public final class RagEmbeddingModelConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RagEmbeddingModelConfig)
    RagEmbeddingModelConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RagEmbeddingModelConfig.newBuilder() to construct.
  private RagEmbeddingModelConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RagEmbeddingModelConfig() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RagEmbeddingModelConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1_RagEmbeddingModelConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.VertexRagDataProto
        .internal_static_google_cloud_aiplatform_v1_RagEmbeddingModelConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.class,
            com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.Builder.class);
  }

  public interface VertexPredictionEndpointOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The endpoint resource name.
     * Format:
     * `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
     * or
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The endpoint.
     */
    java.lang.String getEndpoint();

    /**
     *
     *
     * <pre>
     * Required. The endpoint resource name.
     * Format:
     * `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
     * or
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for endpoint.
     */
    com.google.protobuf.ByteString getEndpointBytes();

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the model that is deployed on the
     * endpoint. Present only when the endpoint is not a publisher model.
     * Pattern:
     * `projects/{project}/locations/{location}/models/{model}`
     * </pre>
     *
     * <code>
     * string model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The model.
     */
    java.lang.String getModel();

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the model that is deployed on the
     * endpoint. Present only when the endpoint is not a publisher model.
     * Pattern:
     * `projects/{project}/locations/{location}/models/{model}`
     * </pre>
     *
     * <code>
     * string model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for model.
     */
    com.google.protobuf.ByteString getModelBytes();

    /**
     *
     *
     * <pre>
     * Output only. Version ID of the model that is deployed on the endpoint.
     * Present only when the endpoint is not a publisher model.
     * </pre>
     *
     * <code>string model_version_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The modelVersionId.
     */
    java.lang.String getModelVersionId();

    /**
     *
     *
     * <pre>
     * Output only. Version ID of the model that is deployed on the endpoint.
     * Present only when the endpoint is not a publisher model.
     * </pre>
     *
     * <code>string model_version_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for modelVersionId.
     */
    com.google.protobuf.ByteString getModelVersionIdBytes();
  }

  /**
   *
   *
   * <pre>
   * Config representing a model hosted on Vertex Prediction Endpoint.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint}
   */
  public static final class VertexPredictionEndpoint extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint)
      VertexPredictionEndpointOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use VertexPredictionEndpoint.newBuilder() to construct.
    private VertexPredictionEndpoint(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private VertexPredictionEndpoint() {
      endpoint_ = "";
      model_ = "";
      modelVersionId_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new VertexPredictionEndpoint();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagEmbeddingModelConfig_VertexPredictionEndpoint_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagEmbeddingModelConfig_VertexPredictionEndpoint_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint.class,
              com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
                  .Builder.class);
    }

    public static final int ENDPOINT_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object endpoint_ = "";

    /**
     *
     *
     * <pre>
     * Required. The endpoint resource name.
     * Format:
     * `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
     * or
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The endpoint.
     */
    @java.lang.Override
    public java.lang.String getEndpoint() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        endpoint_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The endpoint resource name.
     * Format:
     * `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
     * or
     * `projects/{project}/locations/{location}/endpoints/{endpoint}`
     * </pre>
     *
     * <code>
     * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for endpoint.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEndpointBytes() {
      java.lang.Object ref = endpoint_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        endpoint_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MODEL_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object model_ = "";

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the model that is deployed on the
     * endpoint. Present only when the endpoint is not a publisher model.
     * Pattern:
     * `projects/{project}/locations/{location}/models/{model}`
     * </pre>
     *
     * <code>
     * string model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The model.
     */
    @java.lang.Override
    public java.lang.String getModel() {
      java.lang.Object ref = model_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        model_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. The resource name of the model that is deployed on the
     * endpoint. Present only when the endpoint is not a publisher model.
     * Pattern:
     * `projects/{project}/locations/{location}/models/{model}`
     * </pre>
     *
     * <code>
     * string model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for model.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelBytes() {
      java.lang.Object ref = model_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        model_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int MODEL_VERSION_ID_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object modelVersionId_ = "";

    /**
     *
     *
     * <pre>
     * Output only. Version ID of the model that is deployed on the endpoint.
     * Present only when the endpoint is not a publisher model.
     * </pre>
     *
     * <code>string model_version_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The modelVersionId.
     */
    @java.lang.Override
    public java.lang.String getModelVersionId() {
      java.lang.Object ref = modelVersionId_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        modelVersionId_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Version ID of the model that is deployed on the endpoint.
     * Present only when the endpoint is not a publisher model.
     * </pre>
     *
     * <code>string model_version_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The bytes for modelVersionId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getModelVersionIdBytes() {
      java.lang.Object ref = modelVersionId_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        modelVersionId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, endpoint_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, model_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersionId_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, modelVersionId_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(endpoint_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, endpoint_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, model_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersionId_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, modelVersionId_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint other =
          (com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint) obj;

      if (!getEndpoint().equals(other.getEndpoint())) return false;
      if (!getModel().equals(other.getModel())) return false;
      if (!getModelVersionId().equals(other.getModelVersionId())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ENDPOINT_FIELD_NUMBER;
      hash = (53 * hash) + getEndpoint().hashCode();
      hash = (37 * hash) + MODEL_FIELD_NUMBER;
      hash = (53 * hash) + getModel().hashCode();
      hash = (37 * hash) + MODEL_VERSION_ID_FIELD_NUMBER;
      hash = (53 * hash) + getModelVersionId().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Config representing a model hosted on Vertex Prediction Endpoint.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint)
        com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpointOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagEmbeddingModelConfig_VertexPredictionEndpoint_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagEmbeddingModelConfig_VertexPredictionEndpoint_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
                    .class,
                com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        endpoint_ = "";
        model_ = "";
        modelVersionId_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.VertexRagDataProto
            .internal_static_google_cloud_aiplatform_v1_RagEmbeddingModelConfig_VertexPredictionEndpoint_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
          build() {
        com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
          buildPartial() {
        com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint result =
            new com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.endpoint_ = endpoint_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.model_ = model_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.modelVersionId_ = modelVersionId_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint other) {
        if (other
            == com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
                .getDefaultInstance()) return this;
        if (!other.getEndpoint().isEmpty()) {
          endpoint_ = other.endpoint_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getModel().isEmpty()) {
          model_ = other.model_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getModelVersionId().isEmpty()) {
          modelVersionId_ = other.modelVersionId_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  endpoint_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  model_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  modelVersionId_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object endpoint_ = "";

      /**
       *
       *
       * <pre>
       * Required. The endpoint resource name.
       * Format:
       * `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
       * or
       * `projects/{project}/locations/{location}/endpoints/{endpoint}`
       * </pre>
       *
       * <code>
       * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The endpoint.
       */
      public java.lang.String getEndpoint() {
        java.lang.Object ref = endpoint_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          endpoint_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The endpoint resource name.
       * Format:
       * `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
       * or
       * `projects/{project}/locations/{location}/endpoints/{endpoint}`
       * </pre>
       *
       * <code>
       * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for endpoint.
       */
      public com.google.protobuf.ByteString getEndpointBytes() {
        java.lang.Object ref = endpoint_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          endpoint_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. The endpoint resource name.
       * Format:
       * `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
       * or
       * `projects/{project}/locations/{location}/endpoints/{endpoint}`
       * </pre>
       *
       * <code>
       * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The endpoint to set.
       * @return This builder for chaining.
       */
      public Builder setEndpoint(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        endpoint_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The endpoint resource name.
       * Format:
       * `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
       * or
       * `projects/{project}/locations/{location}/endpoints/{endpoint}`
       * </pre>
       *
       * <code>
       * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearEndpoint() {
        endpoint_ = getDefaultInstance().getEndpoint();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The endpoint resource name.
       * Format:
       * `projects/{project}/locations/{location}/publishers/{publisher}/models/{model}`
       * or
       * `projects/{project}/locations/{location}/endpoints/{endpoint}`
       * </pre>
       *
       * <code>
       * string endpoint = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for endpoint to set.
       * @return This builder for chaining.
       */
      public Builder setEndpointBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        endpoint_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object model_ = "";

      /**
       *
       *
       * <pre>
       * Output only. The resource name of the model that is deployed on the
       * endpoint. Present only when the endpoint is not a publisher model.
       * Pattern:
       * `projects/{project}/locations/{location}/models/{model}`
       * </pre>
       *
       * <code>
       * string model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The model.
       */
      public java.lang.String getModel() {
        java.lang.Object ref = model_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          model_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The resource name of the model that is deployed on the
       * endpoint. Present only when the endpoint is not a publisher model.
       * Pattern:
       * `projects/{project}/locations/{location}/models/{model}`
       * </pre>
       *
       * <code>
       * string model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return The bytes for model.
       */
      public com.google.protobuf.ByteString getModelBytes() {
        java.lang.Object ref = model_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          model_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. The resource name of the model that is deployed on the
       * endpoint. Present only when the endpoint is not a publisher model.
       * Pattern:
       * `projects/{project}/locations/{location}/models/{model}`
       * </pre>
       *
       * <code>
       * string model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The model to set.
       * @return This builder for chaining.
       */
      public Builder setModel(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        model_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The resource name of the model that is deployed on the
       * endpoint. Present only when the endpoint is not a publisher model.
       * Pattern:
       * `projects/{project}/locations/{location}/models/{model}`
       * </pre>
       *
       * <code>
       * string model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModel() {
        model_ = getDefaultInstance().getModel();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. The resource name of the model that is deployed on the
       * endpoint. Present only when the endpoint is not a publisher model.
       * Pattern:
       * `projects/{project}/locations/{location}/models/{model}`
       * </pre>
       *
       * <code>
       * string model = 2 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }
       * </code>
       *
       * @param value The bytes for model to set.
       * @return This builder for chaining.
       */
      public Builder setModelBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        model_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object modelVersionId_ = "";

      /**
       *
       *
       * <pre>
       * Output only. Version ID of the model that is deployed on the endpoint.
       * Present only when the endpoint is not a publisher model.
       * </pre>
       *
       * <code>string model_version_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The modelVersionId.
       */
      public java.lang.String getModelVersionId() {
        java.lang.Object ref = modelVersionId_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelVersionId_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Version ID of the model that is deployed on the endpoint.
       * Present only when the endpoint is not a publisher model.
       * </pre>
       *
       * <code>string model_version_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return The bytes for modelVersionId.
       */
      public com.google.protobuf.ByteString getModelVersionIdBytes() {
        java.lang.Object ref = modelVersionId_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelVersionId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Output only. Version ID of the model that is deployed on the endpoint.
       * Present only when the endpoint is not a publisher model.
       * </pre>
       *
       * <code>string model_version_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The modelVersionId to set.
       * @return This builder for chaining.
       */
      public Builder setModelVersionId(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelVersionId_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Version ID of the model that is deployed on the endpoint.
       * Present only when the endpoint is not a publisher model.
       * </pre>
       *
       * <code>string model_version_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearModelVersionId() {
        modelVersionId_ = getDefaultInstance().getModelVersionId();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Output only. Version ID of the model that is deployed on the endpoint.
       * Present only when the endpoint is not a publisher model.
       * </pre>
       *
       * <code>string model_version_id = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
       *
       * @param value The bytes for modelVersionId to set.
       * @return This builder for chaining.
       */
      public Builder setModelVersionIdBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        modelVersionId_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint)
    private static final com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig
            .VertexPredictionEndpoint
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint();
    }

    public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<VertexPredictionEndpoint> PARSER =
        new com.google.protobuf.AbstractParser<VertexPredictionEndpoint>() {
          @java.lang.Override
          public VertexPredictionEndpoint parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<VertexPredictionEndpoint> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<VertexPredictionEndpoint> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int modelConfigCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object modelConfig_;

  public enum ModelConfigCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    VERTEX_PREDICTION_ENDPOINT(1),
    MODELCONFIG_NOT_SET(0);
    private final int value;

    private ModelConfigCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ModelConfigCase valueOf(int value) {
      return forNumber(value);
    }

    public static ModelConfigCase forNumber(int value) {
      switch (value) {
        case 1:
          return VERTEX_PREDICTION_ENDPOINT;
        case 0:
          return MODELCONFIG_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ModelConfigCase getModelConfigCase() {
    return ModelConfigCase.forNumber(modelConfigCase_);
  }

  public static final int VERTEX_PREDICTION_ENDPOINT_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * The Vertex AI Prediction Endpoint that either refers to a publisher model
   * or an endpoint that is hosting a 1P fine-tuned text embedding model.
   * Endpoints hosting non-1P fine-tuned text embedding models are
   * currently not supported.
   * This is used for dense vector search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint vertex_prediction_endpoint = 1;
   * </code>
   *
   * @return Whether the vertexPredictionEndpoint field is set.
   */
  @java.lang.Override
  public boolean hasVertexPredictionEndpoint() {
    return modelConfigCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * The Vertex AI Prediction Endpoint that either refers to a publisher model
   * or an endpoint that is hosting a 1P fine-tuned text embedding model.
   * Endpoints hosting non-1P fine-tuned text embedding models are
   * currently not supported.
   * This is used for dense vector search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint vertex_prediction_endpoint = 1;
   * </code>
   *
   * @return The vertexPredictionEndpoint.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
      getVertexPredictionEndpoint() {
    if (modelConfigCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint)
          modelConfig_;
    }
    return com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * The Vertex AI Prediction Endpoint that either refers to a publisher model
   * or an endpoint that is hosting a 1P fine-tuned text embedding model.
   * Endpoints hosting non-1P fine-tuned text embedding models are
   * currently not supported.
   * This is used for dense vector search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint vertex_prediction_endpoint = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpointOrBuilder
      getVertexPredictionEndpointOrBuilder() {
    if (modelConfigCase_ == 1) {
      return (com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint)
          modelConfig_;
    }
    return com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        .getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (modelConfigCase_ == 1) {
      output.writeMessage(
          1,
          (com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint)
              modelConfig_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (modelConfigCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1,
              (com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint)
                  modelConfig_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig other =
        (com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig) obj;

    if (!getModelConfigCase().equals(other.getModelConfigCase())) return false;
    switch (modelConfigCase_) {
      case 1:
        if (!getVertexPredictionEndpoint().equals(other.getVertexPredictionEndpoint()))
          return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (modelConfigCase_) {
      case 1:
        hash = (37 * hash) + VERTEX_PREDICTION_ENDPOINT_FIELD_NUMBER;
        hash = (53 * hash) + getVertexPredictionEndpoint().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Config for the embedding model to use for RAG.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.RagEmbeddingModelConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.RagEmbeddingModelConfig)
      com.google.cloud.aiplatform.v1.RagEmbeddingModelConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagEmbeddingModelConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagEmbeddingModelConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.class,
              com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (vertexPredictionEndpointBuilder_ != null) {
        vertexPredictionEndpointBuilder_.clear();
      }
      modelConfigCase_ = 0;
      modelConfig_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.VertexRagDataProto
          .internal_static_google_cloud_aiplatform_v1_RagEmbeddingModelConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig build() {
      com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig buildPartial() {
      com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig result =
          new com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig result) {
      result.modelConfigCase_ = modelConfigCase_;
      result.modelConfig_ = this.modelConfig_;
      if (modelConfigCase_ == 1 && vertexPredictionEndpointBuilder_ != null) {
        result.modelConfig_ = vertexPredictionEndpointBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig) {
        return mergeFrom((com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig other) {
      if (other == com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.getDefaultInstance())
        return this;
      switch (other.getModelConfigCase()) {
        case VERTEX_PREDICTION_ENDPOINT:
          {
            mergeVertexPredictionEndpoint(other.getVertexPredictionEndpoint());
            break;
          }
        case MODELCONFIG_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getVertexPredictionEndpointFieldBuilder().getBuilder(), extensionRegistry);
                modelConfigCase_ = 1;
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int modelConfigCase_ = 0;
    private java.lang.Object modelConfig_;

    public ModelConfigCase getModelConfigCase() {
      return ModelConfigCase.forNumber(modelConfigCase_);
    }

    public Builder clearModelConfig() {
      modelConfigCase_ = 0;
      modelConfig_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint,
            com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint.Builder,
            com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig
                .VertexPredictionEndpointOrBuilder>
        vertexPredictionEndpointBuilder_;

    /**
     *
     *
     * <pre>
     * The Vertex AI Prediction Endpoint that either refers to a publisher model
     * or an endpoint that is hosting a 1P fine-tuned text embedding model.
     * Endpoints hosting non-1P fine-tuned text embedding models are
     * currently not supported.
     * This is used for dense vector search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint vertex_prediction_endpoint = 1;
     * </code>
     *
     * @return Whether the vertexPredictionEndpoint field is set.
     */
    @java.lang.Override
    public boolean hasVertexPredictionEndpoint() {
      return modelConfigCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * The Vertex AI Prediction Endpoint that either refers to a publisher model
     * or an endpoint that is hosting a 1P fine-tuned text embedding model.
     * Endpoints hosting non-1P fine-tuned text embedding models are
     * currently not supported.
     * This is used for dense vector search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint vertex_prediction_endpoint = 1;
     * </code>
     *
     * @return The vertexPredictionEndpoint.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
        getVertexPredictionEndpoint() {
      if (vertexPredictionEndpointBuilder_ == null) {
        if (modelConfigCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint)
              modelConfig_;
        }
        return com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
            .getDefaultInstance();
      } else {
        if (modelConfigCase_ == 1) {
          return vertexPredictionEndpointBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The Vertex AI Prediction Endpoint that either refers to a publisher model
     * or an endpoint that is hosting a 1P fine-tuned text embedding model.
     * Endpoints hosting non-1P fine-tuned text embedding models are
     * currently not supported.
     * This is used for dense vector search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint vertex_prediction_endpoint = 1;
     * </code>
     */
    public Builder setVertexPredictionEndpoint(
        com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint value) {
      if (vertexPredictionEndpointBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelConfig_ = value;
        onChanged();
      } else {
        vertexPredictionEndpointBuilder_.setMessage(value);
      }
      modelConfigCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Vertex AI Prediction Endpoint that either refers to a publisher model
     * or an endpoint that is hosting a 1P fine-tuned text embedding model.
     * Endpoints hosting non-1P fine-tuned text embedding models are
     * currently not supported.
     * This is used for dense vector search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint vertex_prediction_endpoint = 1;
     * </code>
     */
    public Builder setVertexPredictionEndpoint(
        com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint.Builder
            builderForValue) {
      if (vertexPredictionEndpointBuilder_ == null) {
        modelConfig_ = builderForValue.build();
        onChanged();
      } else {
        vertexPredictionEndpointBuilder_.setMessage(builderForValue.build());
      }
      modelConfigCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Vertex AI Prediction Endpoint that either refers to a publisher model
     * or an endpoint that is hosting a 1P fine-tuned text embedding model.
     * Endpoints hosting non-1P fine-tuned text embedding models are
     * currently not supported.
     * This is used for dense vector search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint vertex_prediction_endpoint = 1;
     * </code>
     */
    public Builder mergeVertexPredictionEndpoint(
        com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint value) {
      if (vertexPredictionEndpointBuilder_ == null) {
        if (modelConfigCase_ == 1
            && modelConfig_
                != com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
                    .getDefaultInstance()) {
          modelConfig_ =
              com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig
                              .VertexPredictionEndpoint)
                          modelConfig_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          modelConfig_ = value;
        }
        onChanged();
      } else {
        if (modelConfigCase_ == 1) {
          vertexPredictionEndpointBuilder_.mergeFrom(value);
        } else {
          vertexPredictionEndpointBuilder_.setMessage(value);
        }
      }
      modelConfigCase_ = 1;
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Vertex AI Prediction Endpoint that either refers to a publisher model
     * or an endpoint that is hosting a 1P fine-tuned text embedding model.
     * Endpoints hosting non-1P fine-tuned text embedding models are
     * currently not supported.
     * This is used for dense vector search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint vertex_prediction_endpoint = 1;
     * </code>
     */
    public Builder clearVertexPredictionEndpoint() {
      if (vertexPredictionEndpointBuilder_ == null) {
        if (modelConfigCase_ == 1) {
          modelConfigCase_ = 0;
          modelConfig_ = null;
          onChanged();
        }
      } else {
        if (modelConfigCase_ == 1) {
          modelConfigCase_ = 0;
          modelConfig_ = null;
        }
        vertexPredictionEndpointBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The Vertex AI Prediction Endpoint that either refers to a publisher model
     * or an endpoint that is hosting a 1P fine-tuned text embedding model.
     * Endpoints hosting non-1P fine-tuned text embedding models are
     * currently not supported.
     * This is used for dense vector search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint vertex_prediction_endpoint = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint.Builder
        getVertexPredictionEndpointBuilder() {
      return getVertexPredictionEndpointFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The Vertex AI Prediction Endpoint that either refers to a publisher model
     * or an endpoint that is hosting a 1P fine-tuned text embedding model.
     * Endpoints hosting non-1P fine-tuned text embedding models are
     * currently not supported.
     * This is used for dense vector search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint vertex_prediction_endpoint = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpointOrBuilder
        getVertexPredictionEndpointOrBuilder() {
      if ((modelConfigCase_ == 1) && (vertexPredictionEndpointBuilder_ != null)) {
        return vertexPredictionEndpointBuilder_.getMessageOrBuilder();
      } else {
        if (modelConfigCase_ == 1) {
          return (com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint)
              modelConfig_;
        }
        return com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * The Vertex AI Prediction Endpoint that either refers to a publisher model
     * or an endpoint that is hosting a 1P fine-tuned text embedding model.
     * Endpoints hosting non-1P fine-tuned text embedding models are
     * currently not supported.
     * This is used for dense vector search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint vertex_prediction_endpoint = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint,
            com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint.Builder,
            com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig
                .VertexPredictionEndpointOrBuilder>
        getVertexPredictionEndpointFieldBuilder() {
      if (vertexPredictionEndpointBuilder_ == null) {
        if (!(modelConfigCase_ == 1)) {
          modelConfig_ =
              com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
                  .getDefaultInstance();
        }
        vertexPredictionEndpointBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint,
                com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint
                    .Builder,
                com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig
                    .VertexPredictionEndpointOrBuilder>(
                (com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig.VertexPredictionEndpoint)
                    modelConfig_,
                getParentForChildren(),
                isClean());
        modelConfig_ = null;
      }
      modelConfigCase_ = 1;
      onChanged();
      return vertexPredictionEndpointBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.RagEmbeddingModelConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.RagEmbeddingModelConfig)
  private static final com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig();
  }

  public static com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RagEmbeddingModelConfig> PARSER =
      new com.google.protobuf.AbstractParser<RagEmbeddingModelConfig>() {
        @java.lang.Override
        public RagEmbeddingModelConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RagEmbeddingModelConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RagEmbeddingModelConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.RagEmbeddingModelConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
