/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/reasoning_engine.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * ReasoningEngine configurations
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.ReasoningEngineSpec}
 */
public final class ReasoningEngineSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ReasoningEngineSpec)
    ReasoningEngineSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ReasoningEngineSpec.newBuilder() to construct.
  private ReasoningEngineSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReasoningEngineSpec() {
    serviceAccount_ = "";
    classMethods_ = java.util.Collections.emptyList();
    agentFramework_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReasoningEngineSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ReasoningEngineProto
        .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ReasoningEngineProto
        .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.class,
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.Builder.class);
  }

  public interface PackageSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the pickled python object.
     * </pre>
     *
     * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pickleObjectGcsUri.
     */
    java.lang.String getPickleObjectGcsUri();

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the pickled python object.
     * </pre>
     *
     * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pickleObjectGcsUri.
     */
    com.google.protobuf.ByteString getPickleObjectGcsUriBytes();

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
     * </pre>
     *
     * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The dependencyFilesGcsUri.
     */
    java.lang.String getDependencyFilesGcsUri();

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
     * </pre>
     *
     * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for dependencyFilesGcsUri.
     */
    com.google.protobuf.ByteString getDependencyFilesGcsUriBytes();

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the `requirements.txt` file
     * </pre>
     *
     * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requirementsGcsUri.
     */
    java.lang.String getRequirementsGcsUri();

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the `requirements.txt` file
     * </pre>
     *
     * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requirementsGcsUri.
     */
    com.google.protobuf.ByteString getRequirementsGcsUriBytes();

    /**
     *
     *
     * <pre>
     * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
     * If not specified, default value is 3.10.
     * </pre>
     *
     * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pythonVersion.
     */
    java.lang.String getPythonVersion();

    /**
     *
     *
     * <pre>
     * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
     * If not specified, default value is 3.10.
     * </pre>
     *
     * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pythonVersion.
     */
    com.google.protobuf.ByteString getPythonVersionBytes();
  }

  /**
   *
   *
   * <pre>
   * User-provided package specification, containing pickled object and package
   * requirements.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec}
   */
  public static final class PackageSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec)
      PackageSpecOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use PackageSpec.newBuilder() to construct.
    private PackageSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private PackageSpec() {
      pickleObjectGcsUri_ = "";
      dependencyFilesGcsUri_ = "";
      requirementsGcsUri_ = "";
      pythonVersion_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new PackageSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_PackageSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_PackageSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec.class,
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec.Builder.class);
    }

    public static final int PICKLE_OBJECT_GCS_URI_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object pickleObjectGcsUri_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the pickled python object.
     * </pre>
     *
     * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pickleObjectGcsUri.
     */
    @java.lang.Override
    public java.lang.String getPickleObjectGcsUri() {
      java.lang.Object ref = pickleObjectGcsUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pickleObjectGcsUri_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the pickled python object.
     * </pre>
     *
     * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pickleObjectGcsUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPickleObjectGcsUriBytes() {
      java.lang.Object ref = pickleObjectGcsUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pickleObjectGcsUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int DEPENDENCY_FILES_GCS_URI_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dependencyFilesGcsUri_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
     * </pre>
     *
     * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The dependencyFilesGcsUri.
     */
    @java.lang.Override
    public java.lang.String getDependencyFilesGcsUri() {
      java.lang.Object ref = dependencyFilesGcsUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dependencyFilesGcsUri_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
     * </pre>
     *
     * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for dependencyFilesGcsUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDependencyFilesGcsUriBytes() {
      java.lang.Object ref = dependencyFilesGcsUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dependencyFilesGcsUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int REQUIREMENTS_GCS_URI_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private volatile java.lang.Object requirementsGcsUri_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the `requirements.txt` file
     * </pre>
     *
     * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The requirementsGcsUri.
     */
    @java.lang.Override
    public java.lang.String getRequirementsGcsUri() {
      java.lang.Object ref = requirementsGcsUri_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        requirementsGcsUri_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Storage URI of the `requirements.txt` file
     * </pre>
     *
     * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for requirementsGcsUri.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRequirementsGcsUriBytes() {
      java.lang.Object ref = requirementsGcsUri_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        requirementsGcsUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int PYTHON_VERSION_FIELD_NUMBER = 4;

    @SuppressWarnings("serial")
    private volatile java.lang.Object pythonVersion_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
     * If not specified, default value is 3.10.
     * </pre>
     *
     * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pythonVersion.
     */
    @java.lang.Override
    public java.lang.String getPythonVersion() {
      java.lang.Object ref = pythonVersion_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pythonVersion_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
     * If not specified, default value is 3.10.
     * </pre>
     *
     * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pythonVersion.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPythonVersionBytes() {
      java.lang.Object ref = pythonVersion_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pythonVersion_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pickleObjectGcsUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, pickleObjectGcsUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dependencyFilesGcsUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, dependencyFilesGcsUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requirementsGcsUri_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, requirementsGcsUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pythonVersion_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 4, pythonVersion_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pickleObjectGcsUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, pickleObjectGcsUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dependencyFilesGcsUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, dependencyFilesGcsUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requirementsGcsUri_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, requirementsGcsUri_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pythonVersion_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, pythonVersion_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec other =
          (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec) obj;

      if (!getPickleObjectGcsUri().equals(other.getPickleObjectGcsUri())) return false;
      if (!getDependencyFilesGcsUri().equals(other.getDependencyFilesGcsUri())) return false;
      if (!getRequirementsGcsUri().equals(other.getRequirementsGcsUri())) return false;
      if (!getPythonVersion().equals(other.getPythonVersion())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PICKLE_OBJECT_GCS_URI_FIELD_NUMBER;
      hash = (53 * hash) + getPickleObjectGcsUri().hashCode();
      hash = (37 * hash) + DEPENDENCY_FILES_GCS_URI_FIELD_NUMBER;
      hash = (53 * hash) + getDependencyFilesGcsUri().hashCode();
      hash = (37 * hash) + REQUIREMENTS_GCS_URI_FIELD_NUMBER;
      hash = (53 * hash) + getRequirementsGcsUri().hashCode();
      hash = (37 * hash) + PYTHON_VERSION_FIELD_NUMBER;
      hash = (53 * hash) + getPythonVersion().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * User-provided package specification, containing pickled object and package
     * requirements.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec)
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_PackageSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_PackageSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec.class,
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        pickleObjectGcsUri_ = "";
        dependencyFilesGcsUri_ = "";
        requirementsGcsUri_ = "";
        pythonVersion_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_PackageSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec build() {
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec buildPartial() {
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec result =
            new com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.pickleObjectGcsUri_ = pickleObjectGcsUri_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.dependencyFilesGcsUri_ = dependencyFilesGcsUri_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.requirementsGcsUri_ = requirementsGcsUri_;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.pythonVersion_ = pythonVersion_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec) {
          return mergeFrom((com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec.getDefaultInstance())
          return this;
        if (!other.getPickleObjectGcsUri().isEmpty()) {
          pickleObjectGcsUri_ = other.pickleObjectGcsUri_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getDependencyFilesGcsUri().isEmpty()) {
          dependencyFilesGcsUri_ = other.dependencyFilesGcsUri_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        if (!other.getRequirementsGcsUri().isEmpty()) {
          requirementsGcsUri_ = other.requirementsGcsUri_;
          bitField0_ |= 0x00000004;
          onChanged();
        }
        if (!other.getPythonVersion().isEmpty()) {
          pythonVersion_ = other.pythonVersion_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  pickleObjectGcsUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  dependencyFilesGcsUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              case 26:
                {
                  requirementsGcsUri_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000004;
                  break;
                } // case 26
              case 34:
                {
                  pythonVersion_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 34
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object pickleObjectGcsUri_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the pickled python object.
       * </pre>
       *
       * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The pickleObjectGcsUri.
       */
      public java.lang.String getPickleObjectGcsUri() {
        java.lang.Object ref = pickleObjectGcsUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pickleObjectGcsUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the pickled python object.
       * </pre>
       *
       * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for pickleObjectGcsUri.
       */
      public com.google.protobuf.ByteString getPickleObjectGcsUriBytes() {
        java.lang.Object ref = pickleObjectGcsUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pickleObjectGcsUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the pickled python object.
       * </pre>
       *
       * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The pickleObjectGcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setPickleObjectGcsUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        pickleObjectGcsUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the pickled python object.
       * </pre>
       *
       * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPickleObjectGcsUri() {
        pickleObjectGcsUri_ = getDefaultInstance().getPickleObjectGcsUri();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the pickled python object.
       * </pre>
       *
       * <code>string pickle_object_gcs_uri = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for pickleObjectGcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setPickleObjectGcsUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        pickleObjectGcsUri_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object dependencyFilesGcsUri_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
       * </pre>
       *
       * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The dependencyFilesGcsUri.
       */
      public java.lang.String getDependencyFilesGcsUri() {
        java.lang.Object ref = dependencyFilesGcsUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dependencyFilesGcsUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
       * </pre>
       *
       * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for dependencyFilesGcsUri.
       */
      public com.google.protobuf.ByteString getDependencyFilesGcsUriBytes() {
        java.lang.Object ref = dependencyFilesGcsUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dependencyFilesGcsUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
       * </pre>
       *
       * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The dependencyFilesGcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setDependencyFilesGcsUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dependencyFilesGcsUri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
       * </pre>
       *
       * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDependencyFilesGcsUri() {
        dependencyFilesGcsUri_ = getDefaultInstance().getDependencyFilesGcsUri();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the dependency files in tar.gz format.
       * </pre>
       *
       * <code>string dependency_files_gcs_uri = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for dependencyFilesGcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setDependencyFilesGcsUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dependencyFilesGcsUri_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private java.lang.Object requirementsGcsUri_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the `requirements.txt` file
       * </pre>
       *
       * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The requirementsGcsUri.
       */
      public java.lang.String getRequirementsGcsUri() {
        java.lang.Object ref = requirementsGcsUri_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          requirementsGcsUri_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the `requirements.txt` file
       * </pre>
       *
       * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for requirementsGcsUri.
       */
      public com.google.protobuf.ByteString getRequirementsGcsUriBytes() {
        java.lang.Object ref = requirementsGcsUri_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          requirementsGcsUri_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the `requirements.txt` file
       * </pre>
       *
       * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The requirementsGcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setRequirementsGcsUri(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        requirementsGcsUri_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the `requirements.txt` file
       * </pre>
       *
       * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRequirementsGcsUri() {
        requirementsGcsUri_ = getDefaultInstance().getRequirementsGcsUri();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Cloud Storage URI of the `requirements.txt` file
       * </pre>
       *
       * <code>string requirements_gcs_uri = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for requirementsGcsUri to set.
       * @return This builder for chaining.
       */
      public Builder setRequirementsGcsUriBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        requirementsGcsUri_ = value;
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      private java.lang.Object pythonVersion_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
       * If not specified, default value is 3.10.
       * </pre>
       *
       * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The pythonVersion.
       */
      public java.lang.String getPythonVersion() {
        java.lang.Object ref = pythonVersion_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pythonVersion_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
       * If not specified, default value is 3.10.
       * </pre>
       *
       * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for pythonVersion.
       */
      public com.google.protobuf.ByteString getPythonVersionBytes() {
        java.lang.Object ref = pythonVersion_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pythonVersion_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
       * If not specified, default value is 3.10.
       * </pre>
       *
       * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The pythonVersion to set.
       * @return This builder for chaining.
       */
      public Builder setPythonVersion(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        pythonVersion_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
       * If not specified, default value is 3.10.
       * </pre>
       *
       * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPythonVersion() {
        pythonVersion_ = getDefaultInstance().getPythonVersion();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The Python version. Currently support 3.8, 3.9, 3.10, 3.11.
       * If not specified, default value is 3.10.
       * </pre>
       *
       * <code>string python_version = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for pythonVersion to set.
       * @return This builder for chaining.
       */
      public Builder setPythonVersionBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        pythonVersion_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec)
    private static final com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec();
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<PackageSpec> PARSER =
        new com.google.protobuf.AbstractParser<PackageSpec>() {
          @java.lang.Override
          public PackageSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<PackageSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<PackageSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface DeploymentSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.cloud.aiplatform.v1.EnvVar> getEnvList();

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1.EnvVar getEnv(int index);

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getEnvCount();

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<? extends com.google.cloud.aiplatform.v1.EnvVarOrBuilder> getEnvOrBuilderList();

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1.EnvVarOrBuilder getEnvOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<com.google.cloud.aiplatform.v1.SecretEnvVar> getSecretEnvList();

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1.SecretEnvVar getSecretEnv(int index);

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getSecretEnvCount();

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.List<? extends com.google.cloud.aiplatform.v1.SecretEnvVarOrBuilder>
        getSecretEnvOrBuilderList();

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1.SecretEnvVarOrBuilder getSecretEnvOrBuilder(int index);

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PscInterfaceConfig psc_interface_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the pscInterfaceConfig field is set.
     */
    boolean hasPscInterfaceConfig();

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PscInterfaceConfig psc_interface_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The pscInterfaceConfig.
     */
    com.google.cloud.aiplatform.v1.PscInterfaceConfig getPscInterfaceConfig();

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PscInterfaceConfig psc_interface_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    com.google.cloud.aiplatform.v1.PscInterfaceConfigOrBuilder getPscInterfaceConfigOrBuilder();

    /**
     *
     *
     * <pre>
     * Optional. The minimum number of application instances that will be kept
     * running at all times. Defaults to 1. Range: [0, 10].
     * </pre>
     *
     * <code>optional int32 min_instances = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the minInstances field is set.
     */
    boolean hasMinInstances();

    /**
     *
     *
     * <pre>
     * Optional. The minimum number of application instances that will be kept
     * running at all times. Defaults to 1. Range: [0, 10].
     * </pre>
     *
     * <code>optional int32 min_instances = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minInstances.
     */
    int getMinInstances();

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of application instances that can be
     * launched to handle increased traffic. Defaults to 100. Range: [1, 1000].
     *
     * If VPC-SC or PSC-I is enabled, the acceptable range is [1, 100].
     * </pre>
     *
     * <code>optional int32 max_instances = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the maxInstances field is set.
     */
    boolean hasMaxInstances();

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of application instances that can be
     * launched to handle increased traffic. Defaults to 100. Range: [1, 1000].
     *
     * If VPC-SC or PSC-I is enabled, the acceptable range is [1, 100].
     * </pre>
     *
     * <code>optional int32 max_instances = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxInstances.
     */
    int getMaxInstances();

    /**
     *
     *
     * <pre>
     * Optional. Resource limits for each container. Only 'cpu' and 'memory'
     * keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
     *
     *   * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
     *   more information, go to
     *   https://cloud.google.com/run/docs/configuring/cpu.
     *   * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
     *   * For required cpu on different memory values, go to
     *   https://cloud.google.com/run/docs/configuring/memory-limits
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; resource_limits = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    int getResourceLimitsCount();

    /**
     *
     *
     * <pre>
     * Optional. Resource limits for each container. Only 'cpu' and 'memory'
     * keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
     *
     *   * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
     *   more information, go to
     *   https://cloud.google.com/run/docs/configuring/cpu.
     *   * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
     *   * For required cpu on different memory values, go to
     *   https://cloud.google.com/run/docs/configuring/memory-limits
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; resource_limits = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    boolean containsResourceLimits(java.lang.String key);

    /** Use {@link #getResourceLimitsMap()} instead. */
    @java.lang.Deprecated
    java.util.Map<java.lang.String, java.lang.String> getResourceLimits();

    /**
     *
     *
     * <pre>
     * Optional. Resource limits for each container. Only 'cpu' and 'memory'
     * keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
     *
     *   * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
     *   more information, go to
     *   https://cloud.google.com/run/docs/configuring/cpu.
     *   * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
     *   * For required cpu on different memory values, go to
     *   https://cloud.google.com/run/docs/configuring/memory-limits
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; resource_limits = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.util.Map<java.lang.String, java.lang.String> getResourceLimitsMap();

    /**
     *
     *
     * <pre>
     * Optional. Resource limits for each container. Only 'cpu' and 'memory'
     * keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
     *
     *   * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
     *   more information, go to
     *   https://cloud.google.com/run/docs/configuring/cpu.
     *   * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
     *   * For required cpu on different memory values, go to
     *   https://cloud.google.com/run/docs/configuring/memory-limits
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; resource_limits = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    /* nullable */
    java.lang.String getResourceLimitsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue);

    /**
     *
     *
     * <pre>
     * Optional. Resource limits for each container. Only 'cpu' and 'memory'
     * keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
     *
     *   * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
     *   more information, go to
     *   https://cloud.google.com/run/docs/configuring/cpu.
     *   * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
     *   * For required cpu on different memory values, go to
     *   https://cloud.google.com/run/docs/configuring/memory-limits
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; resource_limits = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    java.lang.String getResourceLimitsOrThrow(java.lang.String key);

    /**
     *
     *
     * <pre>
     * Optional. Concurrency for each container and agent server. Recommended
     * value: 2 * cpu + 1. Defaults to 9.
     * </pre>
     *
     * <code>optional int32 container_concurrency = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the containerConcurrency field is set.
     */
    boolean hasContainerConcurrency();

    /**
     *
     *
     * <pre>
     * Optional. Concurrency for each container and agent server. Recommended
     * value: 2 * cpu + 1. Defaults to 9.
     * </pre>
     *
     * <code>optional int32 container_concurrency = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The containerConcurrency.
     */
    int getContainerConcurrency();
  }

  /**
   *
   *
   * <pre>
   * The specification of a Reasoning Engine deployment.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec}
   */
  public static final class DeploymentSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec)
      DeploymentSpecOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use DeploymentSpec.newBuilder() to construct.
    private DeploymentSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DeploymentSpec() {
      env_ = java.util.Collections.emptyList();
      secretEnv_ = java.util.Collections.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DeploymentSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_DeploymentSpec_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    @java.lang.Override
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 7:
          return internalGetResourceLimits();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_DeploymentSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.class,
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.Builder.class);
    }

    private int bitField0_;
    public static final int ENV_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.aiplatform.v1.EnvVar> env_;

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.aiplatform.v1.EnvVar> getEnvList() {
      return env_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.aiplatform.v1.EnvVarOrBuilder>
        getEnvOrBuilderList() {
      return env_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getEnvCount() {
      return env_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EnvVar getEnv(int index) {
      return env_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables to be set with the Reasoning Engine
     * deployment. The environment variables can be updated through the
     * UpdateReasoningEngine API.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.EnvVarOrBuilder getEnvOrBuilder(int index) {
      return env_.get(index);
    }

    public static final int SECRET_ENV_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private java.util.List<com.google.cloud.aiplatform.v1.SecretEnvVar> secretEnv_;

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<com.google.cloud.aiplatform.v1.SecretEnvVar> getSecretEnvList() {
      return secretEnv_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.List<? extends com.google.cloud.aiplatform.v1.SecretEnvVarOrBuilder>
        getSecretEnvOrBuilderList() {
      return secretEnv_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public int getSecretEnvCount() {
      return secretEnv_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SecretEnvVar getSecretEnv(int index) {
      return secretEnv_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Environment variables where the value is a secret in Cloud
     * Secret Manager.
     * To use this feature, add 'Secret Manager Secret Accessor' role
     * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
     * Service Agent.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.SecretEnvVarOrBuilder getSecretEnvOrBuilder(int index) {
      return secretEnv_.get(index);
    }

    public static final int PSC_INTERFACE_CONFIG_FIELD_NUMBER = 4;
    private com.google.cloud.aiplatform.v1.PscInterfaceConfig pscInterfaceConfig_;

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PscInterfaceConfig psc_interface_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the pscInterfaceConfig field is set.
     */
    @java.lang.Override
    public boolean hasPscInterfaceConfig() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PscInterfaceConfig psc_interface_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The pscInterfaceConfig.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PscInterfaceConfig getPscInterfaceConfig() {
      return pscInterfaceConfig_ == null
          ? com.google.cloud.aiplatform.v1.PscInterfaceConfig.getDefaultInstance()
          : pscInterfaceConfig_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.PscInterfaceConfig psc_interface_config = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.PscInterfaceConfigOrBuilder
        getPscInterfaceConfigOrBuilder() {
      return pscInterfaceConfig_ == null
          ? com.google.cloud.aiplatform.v1.PscInterfaceConfig.getDefaultInstance()
          : pscInterfaceConfig_;
    }

    public static final int MIN_INSTANCES_FIELD_NUMBER = 5;
    private int minInstances_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The minimum number of application instances that will be kept
     * running at all times. Defaults to 1. Range: [0, 10].
     * </pre>
     *
     * <code>optional int32 min_instances = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the minInstances field is set.
     */
    @java.lang.Override
    public boolean hasMinInstances() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The minimum number of application instances that will be kept
     * running at all times. Defaults to 1. Range: [0, 10].
     * </pre>
     *
     * <code>optional int32 min_instances = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The minInstances.
     */
    @java.lang.Override
    public int getMinInstances() {
      return minInstances_;
    }

    public static final int MAX_INSTANCES_FIELD_NUMBER = 6;
    private int maxInstances_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of application instances that can be
     * launched to handle increased traffic. Defaults to 100. Range: [1, 1000].
     *
     * If VPC-SC or PSC-I is enabled, the acceptable range is [1, 100].
     * </pre>
     *
     * <code>optional int32 max_instances = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the maxInstances field is set.
     */
    @java.lang.Override
    public boolean hasMaxInstances() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of application instances that can be
     * launched to handle increased traffic. Defaults to 100. Range: [1, 1000].
     *
     * If VPC-SC or PSC-I is enabled, the acceptable range is [1, 100].
     * </pre>
     *
     * <code>optional int32 max_instances = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxInstances.
     */
    @java.lang.Override
    public int getMaxInstances() {
      return maxInstances_;
    }

    public static final int RESOURCE_LIMITS_FIELD_NUMBER = 7;

    private static final class ResourceLimitsDefaultEntryHolder {
      static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
          com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
              com.google.cloud.aiplatform.v1.ReasoningEngineProto
                  .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_DeploymentSpec_ResourceLimitsEntry_descriptor,
              com.google.protobuf.WireFormat.FieldType.STRING,
              "",
              com.google.protobuf.WireFormat.FieldType.STRING,
              "");
    }

    @SuppressWarnings("serial")
    private com.google.protobuf.MapField<java.lang.String, java.lang.String> resourceLimits_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetResourceLimits() {
      if (resourceLimits_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            ResourceLimitsDefaultEntryHolder.defaultEntry);
      }
      return resourceLimits_;
    }

    public int getResourceLimitsCount() {
      return internalGetResourceLimits().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Resource limits for each container. Only 'cpu' and 'memory'
     * keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
     *
     *   * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
     *   more information, go to
     *   https://cloud.google.com/run/docs/configuring/cpu.
     *   * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
     *   * For required cpu on different memory values, go to
     *   https://cloud.google.com/run/docs/configuring/memory-limits
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; resource_limits = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsResourceLimits(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetResourceLimits().getMap().containsKey(key);
    }

    /** Use {@link #getResourceLimitsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getResourceLimits() {
      return getResourceLimitsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Resource limits for each container. Only 'cpu' and 'memory'
     * keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
     *
     *   * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
     *   more information, go to
     *   https://cloud.google.com/run/docs/configuring/cpu.
     *   * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
     *   * For required cpu on different memory values, go to
     *   https://cloud.google.com/run/docs/configuring/memory-limits
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; resource_limits = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getResourceLimitsMap() {
      return internalGetResourceLimits().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. Resource limits for each container. Only 'cpu' and 'memory'
     * keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
     *
     *   * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
     *   more information, go to
     *   https://cloud.google.com/run/docs/configuring/cpu.
     *   * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
     *   * For required cpu on different memory values, go to
     *   https://cloud.google.com/run/docs/configuring/memory-limits
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; resource_limits = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getResourceLimitsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetResourceLimits().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. Resource limits for each container. Only 'cpu' and 'memory'
     * keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
     *
     *   * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
     *   more information, go to
     *   https://cloud.google.com/run/docs/configuring/cpu.
     *   * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
     *   * For required cpu on different memory values, go to
     *   https://cloud.google.com/run/docs/configuring/memory-limits
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; resource_limits = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getResourceLimitsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetResourceLimits().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public static final int CONTAINER_CONCURRENCY_FIELD_NUMBER = 8;
    private int containerConcurrency_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. Concurrency for each container and agent server. Recommended
     * value: 2 * cpu + 1. Defaults to 9.
     * </pre>
     *
     * <code>optional int32 container_concurrency = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the containerConcurrency field is set.
     */
    @java.lang.Override
    public boolean hasContainerConcurrency() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Concurrency for each container and agent server. Recommended
     * value: 2 * cpu + 1. Defaults to 9.
     * </pre>
     *
     * <code>optional int32 container_concurrency = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The containerConcurrency.
     */
    @java.lang.Override
    public int getContainerConcurrency() {
      return containerConcurrency_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      for (int i = 0; i < env_.size(); i++) {
        output.writeMessage(1, env_.get(i));
      }
      for (int i = 0; i < secretEnv_.size(); i++) {
        output.writeMessage(2, secretEnv_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(4, getPscInterfaceConfig());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        output.writeInt32(5, minInstances_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        output.writeInt32(6, maxInstances_);
      }
      com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
          output, internalGetResourceLimits(), ResourceLimitsDefaultEntryHolder.defaultEntry, 7);
      if (((bitField0_ & 0x00000008) != 0)) {
        output.writeInt32(8, containerConcurrency_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      for (int i = 0; i < env_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, env_.get(i));
      }
      for (int i = 0; i < secretEnv_.size(); i++) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, secretEnv_.get(i));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(4, getPscInterfaceConfig());
      }
      if (((bitField0_ & 0x00000002) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(5, minInstances_);
      }
      if (((bitField0_ & 0x00000004) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(6, maxInstances_);
      }
      for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
          internalGetResourceLimits().getMap().entrySet()) {
        com.google.protobuf.MapEntry<java.lang.String, java.lang.String> resourceLimits__ =
            ResourceLimitsDefaultEntryHolder.defaultEntry
                .newBuilderForType()
                .setKey(entry.getKey())
                .setValue(entry.getValue())
                .build();
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, resourceLimits__);
      }
      if (((bitField0_ & 0x00000008) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(8, containerConcurrency_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec other =
          (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec) obj;

      if (!getEnvList().equals(other.getEnvList())) return false;
      if (!getSecretEnvList().equals(other.getSecretEnvList())) return false;
      if (hasPscInterfaceConfig() != other.hasPscInterfaceConfig()) return false;
      if (hasPscInterfaceConfig()) {
        if (!getPscInterfaceConfig().equals(other.getPscInterfaceConfig())) return false;
      }
      if (hasMinInstances() != other.hasMinInstances()) return false;
      if (hasMinInstances()) {
        if (getMinInstances() != other.getMinInstances()) return false;
      }
      if (hasMaxInstances() != other.hasMaxInstances()) return false;
      if (hasMaxInstances()) {
        if (getMaxInstances() != other.getMaxInstances()) return false;
      }
      if (!internalGetResourceLimits().equals(other.internalGetResourceLimits())) return false;
      if (hasContainerConcurrency() != other.hasContainerConcurrency()) return false;
      if (hasContainerConcurrency()) {
        if (getContainerConcurrency() != other.getContainerConcurrency()) return false;
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getEnvCount() > 0) {
        hash = (37 * hash) + ENV_FIELD_NUMBER;
        hash = (53 * hash) + getEnvList().hashCode();
      }
      if (getSecretEnvCount() > 0) {
        hash = (37 * hash) + SECRET_ENV_FIELD_NUMBER;
        hash = (53 * hash) + getSecretEnvList().hashCode();
      }
      if (hasPscInterfaceConfig()) {
        hash = (37 * hash) + PSC_INTERFACE_CONFIG_FIELD_NUMBER;
        hash = (53 * hash) + getPscInterfaceConfig().hashCode();
      }
      if (hasMinInstances()) {
        hash = (37 * hash) + MIN_INSTANCES_FIELD_NUMBER;
        hash = (53 * hash) + getMinInstances();
      }
      if (hasMaxInstances()) {
        hash = (37 * hash) + MAX_INSTANCES_FIELD_NUMBER;
        hash = (53 * hash) + getMaxInstances();
      }
      if (!internalGetResourceLimits().getMap().isEmpty()) {
        hash = (37 * hash) + RESOURCE_LIMITS_FIELD_NUMBER;
        hash = (53 * hash) + internalGetResourceLimits().hashCode();
      }
      if (hasContainerConcurrency()) {
        hash = (37 * hash) + CONTAINER_CONCURRENCY_FIELD_NUMBER;
        hash = (53 * hash) + getContainerConcurrency();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec)
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_DeploymentSpec_descriptor;
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
          int number) {
        switch (number) {
          case 7:
            return internalGetResourceLimits();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @SuppressWarnings({"rawtypes"})
      protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
          int number) {
        switch (number) {
          case 7:
            return internalGetMutableResourceLimits();
          default:
            throw new RuntimeException("Invalid map field number: " + number);
        }
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_DeploymentSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.class,
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getEnvFieldBuilder();
          getSecretEnvFieldBuilder();
          getPscInterfaceConfigFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (envBuilder_ == null) {
          env_ = java.util.Collections.emptyList();
        } else {
          env_ = null;
          envBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000001);
        if (secretEnvBuilder_ == null) {
          secretEnv_ = java.util.Collections.emptyList();
        } else {
          secretEnv_ = null;
          secretEnvBuilder_.clear();
        }
        bitField0_ = (bitField0_ & ~0x00000002);
        pscInterfaceConfig_ = null;
        if (pscInterfaceConfigBuilder_ != null) {
          pscInterfaceConfigBuilder_.dispose();
          pscInterfaceConfigBuilder_ = null;
        }
        minInstances_ = 0;
        maxInstances_ = 0;
        internalGetMutableResourceLimits().clear();
        containerConcurrency_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_DeploymentSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec build() {
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec buildPartial() {
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec result =
            new com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec(this);
        buildPartialRepeatedFields(result);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartialRepeatedFields(
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec result) {
        if (envBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)) {
            env_ = java.util.Collections.unmodifiableList(env_);
            bitField0_ = (bitField0_ & ~0x00000001);
          }
          result.env_ = env_;
        } else {
          result.env_ = envBuilder_.build();
        }
        if (secretEnvBuilder_ == null) {
          if (((bitField0_ & 0x00000002) != 0)) {
            secretEnv_ = java.util.Collections.unmodifiableList(secretEnv_);
            bitField0_ = (bitField0_ & ~0x00000002);
          }
          result.secretEnv_ = secretEnv_;
        } else {
          result.secretEnv_ = secretEnvBuilder_.build();
        }
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000004) != 0)) {
          result.pscInterfaceConfig_ =
              pscInterfaceConfigBuilder_ == null
                  ? pscInterfaceConfig_
                  : pscInterfaceConfigBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.minInstances_ = minInstances_;
          to_bitField0_ |= 0x00000002;
        }
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.maxInstances_ = maxInstances_;
          to_bitField0_ |= 0x00000004;
        }
        if (((from_bitField0_ & 0x00000020) != 0)) {
          result.resourceLimits_ = internalGetResourceLimits();
          result.resourceLimits_.makeImmutable();
        }
        if (((from_bitField0_ & 0x00000040) != 0)) {
          result.containerConcurrency_ = containerConcurrency_;
          to_bitField0_ |= 0x00000008;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec
                .getDefaultInstance()) return this;
        if (envBuilder_ == null) {
          if (!other.env_.isEmpty()) {
            if (env_.isEmpty()) {
              env_ = other.env_;
              bitField0_ = (bitField0_ & ~0x00000001);
            } else {
              ensureEnvIsMutable();
              env_.addAll(other.env_);
            }
            onChanged();
          }
        } else {
          if (!other.env_.isEmpty()) {
            if (envBuilder_.isEmpty()) {
              envBuilder_.dispose();
              envBuilder_ = null;
              env_ = other.env_;
              bitField0_ = (bitField0_ & ~0x00000001);
              envBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getEnvFieldBuilder()
                      : null;
            } else {
              envBuilder_.addAllMessages(other.env_);
            }
          }
        }
        if (secretEnvBuilder_ == null) {
          if (!other.secretEnv_.isEmpty()) {
            if (secretEnv_.isEmpty()) {
              secretEnv_ = other.secretEnv_;
              bitField0_ = (bitField0_ & ~0x00000002);
            } else {
              ensureSecretEnvIsMutable();
              secretEnv_.addAll(other.secretEnv_);
            }
            onChanged();
          }
        } else {
          if (!other.secretEnv_.isEmpty()) {
            if (secretEnvBuilder_.isEmpty()) {
              secretEnvBuilder_.dispose();
              secretEnvBuilder_ = null;
              secretEnv_ = other.secretEnv_;
              bitField0_ = (bitField0_ & ~0x00000002);
              secretEnvBuilder_ =
                  com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                      ? getSecretEnvFieldBuilder()
                      : null;
            } else {
              secretEnvBuilder_.addAllMessages(other.secretEnv_);
            }
          }
        }
        if (other.hasPscInterfaceConfig()) {
          mergePscInterfaceConfig(other.getPscInterfaceConfig());
        }
        if (other.hasMinInstances()) {
          setMinInstances(other.getMinInstances());
        }
        if (other.hasMaxInstances()) {
          setMaxInstances(other.getMaxInstances());
        }
        internalGetMutableResourceLimits().mergeFrom(other.internalGetResourceLimits());
        bitField0_ |= 0x00000020;
        if (other.hasContainerConcurrency()) {
          setContainerConcurrency(other.getContainerConcurrency());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  com.google.cloud.aiplatform.v1.EnvVar m =
                      input.readMessage(
                          com.google.cloud.aiplatform.v1.EnvVar.parser(), extensionRegistry);
                  if (envBuilder_ == null) {
                    ensureEnvIsMutable();
                    env_.add(m);
                  } else {
                    envBuilder_.addMessage(m);
                  }
                  break;
                } // case 10
              case 18:
                {
                  com.google.cloud.aiplatform.v1.SecretEnvVar m =
                      input.readMessage(
                          com.google.cloud.aiplatform.v1.SecretEnvVar.parser(), extensionRegistry);
                  if (secretEnvBuilder_ == null) {
                    ensureSecretEnvIsMutable();
                    secretEnv_.add(m);
                  } else {
                    secretEnvBuilder_.addMessage(m);
                  }
                  break;
                } // case 18
              case 34:
                {
                  input.readMessage(
                      getPscInterfaceConfigFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000004;
                  break;
                } // case 34
              case 40:
                {
                  minInstances_ = input.readInt32();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 40
              case 48:
                {
                  maxInstances_ = input.readInt32();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 48
              case 58:
                {
                  com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                      resourceLimits__ =
                          input.readMessage(
                              ResourceLimitsDefaultEntryHolder.defaultEntry.getParserForType(),
                              extensionRegistry);
                  internalGetMutableResourceLimits()
                      .getMutableMap()
                      .put(resourceLimits__.getKey(), resourceLimits__.getValue());
                  bitField0_ |= 0x00000020;
                  break;
                } // case 58
              case 64:
                {
                  containerConcurrency_ = input.readInt32();
                  bitField0_ |= 0x00000040;
                  break;
                } // case 64
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.util.List<com.google.cloud.aiplatform.v1.EnvVar> env_ =
          java.util.Collections.emptyList();

      private void ensureEnvIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          env_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1.EnvVar>(env_);
          bitField0_ |= 0x00000001;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1.EnvVar,
              com.google.cloud.aiplatform.v1.EnvVar.Builder,
              com.google.cloud.aiplatform.v1.EnvVarOrBuilder>
          envBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1.EnvVar> getEnvList() {
        if (envBuilder_ == null) {
          return java.util.Collections.unmodifiableList(env_);
        } else {
          return envBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getEnvCount() {
        if (envBuilder_ == null) {
          return env_.size();
        } else {
          return envBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.EnvVar getEnv(int index) {
        if (envBuilder_ == null) {
          return env_.get(index);
        } else {
          return envBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setEnv(int index, com.google.cloud.aiplatform.v1.EnvVar value) {
        if (envBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEnvIsMutable();
          env_.set(index, value);
          onChanged();
        } else {
          envBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setEnv(
          int index, com.google.cloud.aiplatform.v1.EnvVar.Builder builderForValue) {
        if (envBuilder_ == null) {
          ensureEnvIsMutable();
          env_.set(index, builderForValue.build());
          onChanged();
        } else {
          envBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addEnv(com.google.cloud.aiplatform.v1.EnvVar value) {
        if (envBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEnvIsMutable();
          env_.add(value);
          onChanged();
        } else {
          envBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addEnv(int index, com.google.cloud.aiplatform.v1.EnvVar value) {
        if (envBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureEnvIsMutable();
          env_.add(index, value);
          onChanged();
        } else {
          envBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addEnv(com.google.cloud.aiplatform.v1.EnvVar.Builder builderForValue) {
        if (envBuilder_ == null) {
          ensureEnvIsMutable();
          env_.add(builderForValue.build());
          onChanged();
        } else {
          envBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addEnv(
          int index, com.google.cloud.aiplatform.v1.EnvVar.Builder builderForValue) {
        if (envBuilder_ == null) {
          ensureEnvIsMutable();
          env_.add(index, builderForValue.build());
          onChanged();
        } else {
          envBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllEnv(
          java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.EnvVar> values) {
        if (envBuilder_ == null) {
          ensureEnvIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, env_);
          onChanged();
        } else {
          envBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearEnv() {
        if (envBuilder_ == null) {
          env_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
        } else {
          envBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeEnv(int index) {
        if (envBuilder_ == null) {
          ensureEnvIsMutable();
          env_.remove(index);
          onChanged();
        } else {
          envBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.EnvVar.Builder getEnvBuilder(int index) {
        return getEnvFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.EnvVarOrBuilder getEnvOrBuilder(int index) {
        if (envBuilder_ == null) {
          return env_.get(index);
        } else {
          return envBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.aiplatform.v1.EnvVarOrBuilder>
          getEnvOrBuilderList() {
        if (envBuilder_ != null) {
          return envBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(env_);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.EnvVar.Builder addEnvBuilder() {
        return getEnvFieldBuilder()
            .addBuilder(com.google.cloud.aiplatform.v1.EnvVar.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.EnvVar.Builder addEnvBuilder(int index) {
        return getEnvFieldBuilder()
            .addBuilder(index, com.google.cloud.aiplatform.v1.EnvVar.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables to be set with the Reasoning Engine
       * deployment. The environment variables can be updated through the
       * UpdateReasoningEngine API.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.EnvVar env = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1.EnvVar.Builder> getEnvBuilderList() {
        return getEnvFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1.EnvVar,
              com.google.cloud.aiplatform.v1.EnvVar.Builder,
              com.google.cloud.aiplatform.v1.EnvVarOrBuilder>
          getEnvFieldBuilder() {
        if (envBuilder_ == null) {
          envBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.EnvVar,
                  com.google.cloud.aiplatform.v1.EnvVar.Builder,
                  com.google.cloud.aiplatform.v1.EnvVarOrBuilder>(
                  env_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
          env_ = null;
        }
        return envBuilder_;
      }

      private java.util.List<com.google.cloud.aiplatform.v1.SecretEnvVar> secretEnv_ =
          java.util.Collections.emptyList();

      private void ensureSecretEnvIsMutable() {
        if (!((bitField0_ & 0x00000002) != 0)) {
          secretEnv_ =
              new java.util.ArrayList<com.google.cloud.aiplatform.v1.SecretEnvVar>(secretEnv_);
          bitField0_ |= 0x00000002;
        }
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1.SecretEnvVar,
              com.google.cloud.aiplatform.v1.SecretEnvVar.Builder,
              com.google.cloud.aiplatform.v1.SecretEnvVarOrBuilder>
          secretEnvBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1.SecretEnvVar> getSecretEnvList() {
        if (secretEnvBuilder_ == null) {
          return java.util.Collections.unmodifiableList(secretEnv_);
        } else {
          return secretEnvBuilder_.getMessageList();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public int getSecretEnvCount() {
        if (secretEnvBuilder_ == null) {
          return secretEnv_.size();
        } else {
          return secretEnvBuilder_.getCount();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.SecretEnvVar getSecretEnv(int index) {
        if (secretEnvBuilder_ == null) {
          return secretEnv_.get(index);
        } else {
          return secretEnvBuilder_.getMessage(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSecretEnv(int index, com.google.cloud.aiplatform.v1.SecretEnvVar value) {
        if (secretEnvBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSecretEnvIsMutable();
          secretEnv_.set(index, value);
          onChanged();
        } else {
          secretEnvBuilder_.setMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setSecretEnv(
          int index, com.google.cloud.aiplatform.v1.SecretEnvVar.Builder builderForValue) {
        if (secretEnvBuilder_ == null) {
          ensureSecretEnvIsMutable();
          secretEnv_.set(index, builderForValue.build());
          onChanged();
        } else {
          secretEnvBuilder_.setMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSecretEnv(com.google.cloud.aiplatform.v1.SecretEnvVar value) {
        if (secretEnvBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSecretEnvIsMutable();
          secretEnv_.add(value);
          onChanged();
        } else {
          secretEnvBuilder_.addMessage(value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSecretEnv(int index, com.google.cloud.aiplatform.v1.SecretEnvVar value) {
        if (secretEnvBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          ensureSecretEnvIsMutable();
          secretEnv_.add(index, value);
          onChanged();
        } else {
          secretEnvBuilder_.addMessage(index, value);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSecretEnv(
          com.google.cloud.aiplatform.v1.SecretEnvVar.Builder builderForValue) {
        if (secretEnvBuilder_ == null) {
          ensureSecretEnvIsMutable();
          secretEnv_.add(builderForValue.build());
          onChanged();
        } else {
          secretEnvBuilder_.addMessage(builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addSecretEnv(
          int index, com.google.cloud.aiplatform.v1.SecretEnvVar.Builder builderForValue) {
        if (secretEnvBuilder_ == null) {
          ensureSecretEnvIsMutable();
          secretEnv_.add(index, builderForValue.build());
          onChanged();
        } else {
          secretEnvBuilder_.addMessage(index, builderForValue.build());
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder addAllSecretEnv(
          java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.SecretEnvVar> values) {
        if (secretEnvBuilder_ == null) {
          ensureSecretEnvIsMutable();
          com.google.protobuf.AbstractMessageLite.Builder.addAll(values, secretEnv_);
          onChanged();
        } else {
          secretEnvBuilder_.addAllMessages(values);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearSecretEnv() {
        if (secretEnvBuilder_ == null) {
          secretEnv_ = java.util.Collections.emptyList();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
        } else {
          secretEnvBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeSecretEnv(int index) {
        if (secretEnvBuilder_ == null) {
          ensureSecretEnvIsMutable();
          secretEnv_.remove(index);
          onChanged();
        } else {
          secretEnvBuilder_.remove(index);
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.SecretEnvVar.Builder getSecretEnvBuilder(int index) {
        return getSecretEnvFieldBuilder().getBuilder(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.SecretEnvVarOrBuilder getSecretEnvOrBuilder(int index) {
        if (secretEnvBuilder_ == null) {
          return secretEnv_.get(index);
        } else {
          return secretEnvBuilder_.getMessageOrBuilder(index);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<? extends com.google.cloud.aiplatform.v1.SecretEnvVarOrBuilder>
          getSecretEnvOrBuilderList() {
        if (secretEnvBuilder_ != null) {
          return secretEnvBuilder_.getMessageOrBuilderList();
        } else {
          return java.util.Collections.unmodifiableList(secretEnv_);
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.SecretEnvVar.Builder addSecretEnvBuilder() {
        return getSecretEnvFieldBuilder()
            .addBuilder(com.google.cloud.aiplatform.v1.SecretEnvVar.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.SecretEnvVar.Builder addSecretEnvBuilder(int index) {
        return getSecretEnvFieldBuilder()
            .addBuilder(index, com.google.cloud.aiplatform.v1.SecretEnvVar.getDefaultInstance());
      }

      /**
       *
       *
       * <pre>
       * Optional. Environment variables where the value is a secret in Cloud
       * Secret Manager.
       * To use this feature, add 'Secret Manager Secret Accessor' role
       * (roles/secretmanager.secretAccessor) to AI Platform Reasoning Engine
       * Service Agent.
       * </pre>
       *
       * <code>
       * repeated .google.cloud.aiplatform.v1.SecretEnvVar secret_env = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public java.util.List<com.google.cloud.aiplatform.v1.SecretEnvVar.Builder>
          getSecretEnvBuilderList() {
        return getSecretEnvFieldBuilder().getBuilderList();
      }

      private com.google.protobuf.RepeatedFieldBuilderV3<
              com.google.cloud.aiplatform.v1.SecretEnvVar,
              com.google.cloud.aiplatform.v1.SecretEnvVar.Builder,
              com.google.cloud.aiplatform.v1.SecretEnvVarOrBuilder>
          getSecretEnvFieldBuilder() {
        if (secretEnvBuilder_ == null) {
          secretEnvBuilder_ =
              new com.google.protobuf.RepeatedFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.SecretEnvVar,
                  com.google.cloud.aiplatform.v1.SecretEnvVar.Builder,
                  com.google.cloud.aiplatform.v1.SecretEnvVarOrBuilder>(
                  secretEnv_, ((bitField0_ & 0x00000002) != 0), getParentForChildren(), isClean());
          secretEnv_ = null;
        }
        return secretEnvBuilder_;
      }

      private com.google.cloud.aiplatform.v1.PscInterfaceConfig pscInterfaceConfig_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PscInterfaceConfig,
              com.google.cloud.aiplatform.v1.PscInterfaceConfig.Builder,
              com.google.cloud.aiplatform.v1.PscInterfaceConfigOrBuilder>
          pscInterfaceConfigBuilder_;

      /**
       *
       *
       * <pre>
       * Optional. Configuration for PSC-I.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PscInterfaceConfig psc_interface_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the pscInterfaceConfig field is set.
       */
      public boolean hasPscInterfaceConfig() {
        return ((bitField0_ & 0x00000004) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for PSC-I.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PscInterfaceConfig psc_interface_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The pscInterfaceConfig.
       */
      public com.google.cloud.aiplatform.v1.PscInterfaceConfig getPscInterfaceConfig() {
        if (pscInterfaceConfigBuilder_ == null) {
          return pscInterfaceConfig_ == null
              ? com.google.cloud.aiplatform.v1.PscInterfaceConfig.getDefaultInstance()
              : pscInterfaceConfig_;
        } else {
          return pscInterfaceConfigBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for PSC-I.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PscInterfaceConfig psc_interface_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setPscInterfaceConfig(
          com.google.cloud.aiplatform.v1.PscInterfaceConfig value) {
        if (pscInterfaceConfigBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          pscInterfaceConfig_ = value;
        } else {
          pscInterfaceConfigBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for PSC-I.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PscInterfaceConfig psc_interface_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder setPscInterfaceConfig(
          com.google.cloud.aiplatform.v1.PscInterfaceConfig.Builder builderForValue) {
        if (pscInterfaceConfigBuilder_ == null) {
          pscInterfaceConfig_ = builderForValue.build();
        } else {
          pscInterfaceConfigBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for PSC-I.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PscInterfaceConfig psc_interface_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder mergePscInterfaceConfig(
          com.google.cloud.aiplatform.v1.PscInterfaceConfig value) {
        if (pscInterfaceConfigBuilder_ == null) {
          if (((bitField0_ & 0x00000004) != 0)
              && pscInterfaceConfig_ != null
              && pscInterfaceConfig_
                  != com.google.cloud.aiplatform.v1.PscInterfaceConfig.getDefaultInstance()) {
            getPscInterfaceConfigBuilder().mergeFrom(value);
          } else {
            pscInterfaceConfig_ = value;
          }
        } else {
          pscInterfaceConfigBuilder_.mergeFrom(value);
        }
        if (pscInterfaceConfig_ != null) {
          bitField0_ |= 0x00000004;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for PSC-I.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PscInterfaceConfig psc_interface_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder clearPscInterfaceConfig() {
        bitField0_ = (bitField0_ & ~0x00000004);
        pscInterfaceConfig_ = null;
        if (pscInterfaceConfigBuilder_ != null) {
          pscInterfaceConfigBuilder_.dispose();
          pscInterfaceConfigBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for PSC-I.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PscInterfaceConfig psc_interface_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PscInterfaceConfig.Builder
          getPscInterfaceConfigBuilder() {
        bitField0_ |= 0x00000004;
        onChanged();
        return getPscInterfaceConfigFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for PSC-I.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PscInterfaceConfig psc_interface_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public com.google.cloud.aiplatform.v1.PscInterfaceConfigOrBuilder
          getPscInterfaceConfigOrBuilder() {
        if (pscInterfaceConfigBuilder_ != null) {
          return pscInterfaceConfigBuilder_.getMessageOrBuilder();
        } else {
          return pscInterfaceConfig_ == null
              ? com.google.cloud.aiplatform.v1.PscInterfaceConfig.getDefaultInstance()
              : pscInterfaceConfig_;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Configuration for PSC-I.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.PscInterfaceConfig psc_interface_config = 4 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.PscInterfaceConfig,
              com.google.cloud.aiplatform.v1.PscInterfaceConfig.Builder,
              com.google.cloud.aiplatform.v1.PscInterfaceConfigOrBuilder>
          getPscInterfaceConfigFieldBuilder() {
        if (pscInterfaceConfigBuilder_ == null) {
          pscInterfaceConfigBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.PscInterfaceConfig,
                  com.google.cloud.aiplatform.v1.PscInterfaceConfig.Builder,
                  com.google.cloud.aiplatform.v1.PscInterfaceConfigOrBuilder>(
                  getPscInterfaceConfig(), getParentForChildren(), isClean());
          pscInterfaceConfig_ = null;
        }
        return pscInterfaceConfigBuilder_;
      }

      private int minInstances_;

      /**
       *
       *
       * <pre>
       * Optional. The minimum number of application instances that will be kept
       * running at all times. Defaults to 1. Range: [0, 10].
       * </pre>
       *
       * <code>optional int32 min_instances = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return Whether the minInstances field is set.
       */
      @java.lang.Override
      public boolean hasMinInstances() {
        return ((bitField0_ & 0x00000008) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. The minimum number of application instances that will be kept
       * running at all times. Defaults to 1. Range: [0, 10].
       * </pre>
       *
       * <code>optional int32 min_instances = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The minInstances.
       */
      @java.lang.Override
      public int getMinInstances() {
        return minInstances_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The minimum number of application instances that will be kept
       * running at all times. Defaults to 1. Range: [0, 10].
       * </pre>
       *
       * <code>optional int32 min_instances = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The minInstances to set.
       * @return This builder for chaining.
       */
      public Builder setMinInstances(int value) {

        minInstances_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The minimum number of application instances that will be kept
       * running at all times. Defaults to 1. Range: [0, 10].
       * </pre>
       *
       * <code>optional int32 min_instances = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMinInstances() {
        bitField0_ = (bitField0_ & ~0x00000008);
        minInstances_ = 0;
        onChanged();
        return this;
      }

      private int maxInstances_;

      /**
       *
       *
       * <pre>
       * Optional. The maximum number of application instances that can be
       * launched to handle increased traffic. Defaults to 100. Range: [1, 1000].
       *
       * If VPC-SC or PSC-I is enabled, the acceptable range is [1, 100].
       * </pre>
       *
       * <code>optional int32 max_instances = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return Whether the maxInstances field is set.
       */
      @java.lang.Override
      public boolean hasMaxInstances() {
        return ((bitField0_ & 0x00000010) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. The maximum number of application instances that can be
       * launched to handle increased traffic. Defaults to 100. Range: [1, 1000].
       *
       * If VPC-SC or PSC-I is enabled, the acceptable range is [1, 100].
       * </pre>
       *
       * <code>optional int32 max_instances = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The maxInstances.
       */
      @java.lang.Override
      public int getMaxInstances() {
        return maxInstances_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The maximum number of application instances that can be
       * launched to handle increased traffic. Defaults to 100. Range: [1, 1000].
       *
       * If VPC-SC or PSC-I is enabled, the acceptable range is [1, 100].
       * </pre>
       *
       * <code>optional int32 max_instances = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The maxInstances to set.
       * @return This builder for chaining.
       */
      public Builder setMaxInstances(int value) {

        maxInstances_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The maximum number of application instances that can be
       * launched to handle increased traffic. Defaults to 100. Range: [1, 1000].
       *
       * If VPC-SC or PSC-I is enabled, the acceptable range is [1, 100].
       * </pre>
       *
       * <code>optional int32 max_instances = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearMaxInstances() {
        bitField0_ = (bitField0_ & ~0x00000010);
        maxInstances_ = 0;
        onChanged();
        return this;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String> resourceLimits_;

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetResourceLimits() {
        if (resourceLimits_ == null) {
          return com.google.protobuf.MapField.emptyMapField(
              ResourceLimitsDefaultEntryHolder.defaultEntry);
        }
        return resourceLimits_;
      }

      private com.google.protobuf.MapField<java.lang.String, java.lang.String>
          internalGetMutableResourceLimits() {
        if (resourceLimits_ == null) {
          resourceLimits_ =
              com.google.protobuf.MapField.newMapField(
                  ResourceLimitsDefaultEntryHolder.defaultEntry);
        }
        if (!resourceLimits_.isMutable()) {
          resourceLimits_ = resourceLimits_.copy();
        }
        bitField0_ |= 0x00000020;
        onChanged();
        return resourceLimits_;
      }

      public int getResourceLimitsCount() {
        return internalGetResourceLimits().getMap().size();
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource limits for each container. Only 'cpu' and 'memory'
       * keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
       *
       *   * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
       *   more information, go to
       *   https://cloud.google.com/run/docs/configuring/cpu.
       *   * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
       *   * For required cpu on different memory values, go to
       *   https://cloud.google.com/run/docs/configuring/memory-limits
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; resource_limits = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public boolean containsResourceLimits(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        return internalGetResourceLimits().getMap().containsKey(key);
      }

      /** Use {@link #getResourceLimitsMap()} instead. */
      @java.lang.Override
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getResourceLimits() {
        return getResourceLimitsMap();
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource limits for each container. Only 'cpu' and 'memory'
       * keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
       *
       *   * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
       *   more information, go to
       *   https://cloud.google.com/run/docs/configuring/cpu.
       *   * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
       *   * For required cpu on different memory values, go to
       *   https://cloud.google.com/run/docs/configuring/memory-limits
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; resource_limits = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.util.Map<java.lang.String, java.lang.String> getResourceLimitsMap() {
        return internalGetResourceLimits().getMap();
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource limits for each container. Only 'cpu' and 'memory'
       * keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
       *
       *   * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
       *   more information, go to
       *   https://cloud.google.com/run/docs/configuring/cpu.
       *   * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
       *   * For required cpu on different memory values, go to
       *   https://cloud.google.com/run/docs/configuring/memory-limits
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; resource_limits = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public /* nullable */ java.lang.String getResourceLimitsOrDefault(
          java.lang.String key,
          /* nullable */
          java.lang.String defaultValue) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetResourceLimits().getMap();
        return map.containsKey(key) ? map.get(key) : defaultValue;
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource limits for each container. Only 'cpu' and 'memory'
       * keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
       *
       *   * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
       *   more information, go to
       *   https://cloud.google.com/run/docs/configuring/cpu.
       *   * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
       *   * For required cpu on different memory values, go to
       *   https://cloud.google.com/run/docs/configuring/memory-limits
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; resource_limits = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      @java.lang.Override
      public java.lang.String getResourceLimitsOrThrow(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        java.util.Map<java.lang.String, java.lang.String> map =
            internalGetResourceLimits().getMap();
        if (!map.containsKey(key)) {
          throw new java.lang.IllegalArgumentException();
        }
        return map.get(key);
      }

      public Builder clearResourceLimits() {
        bitField0_ = (bitField0_ & ~0x00000020);
        internalGetMutableResourceLimits().getMutableMap().clear();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource limits for each container. Only 'cpu' and 'memory'
       * keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
       *
       *   * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
       *   more information, go to
       *   https://cloud.google.com/run/docs/configuring/cpu.
       *   * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
       *   * For required cpu on different memory values, go to
       *   https://cloud.google.com/run/docs/configuring/memory-limits
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; resource_limits = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder removeResourceLimits(java.lang.String key) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        internalGetMutableResourceLimits().getMutableMap().remove(key);
        return this;
      }

      /** Use alternate mutation accessors instead. */
      @java.lang.Deprecated
      public java.util.Map<java.lang.String, java.lang.String> getMutableResourceLimits() {
        bitField0_ |= 0x00000020;
        return internalGetMutableResourceLimits().getMutableMap();
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource limits for each container. Only 'cpu' and 'memory'
       * keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
       *
       *   * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
       *   more information, go to
       *   https://cloud.google.com/run/docs/configuring/cpu.
       *   * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
       *   * For required cpu on different memory values, go to
       *   https://cloud.google.com/run/docs/configuring/memory-limits
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; resource_limits = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putResourceLimits(java.lang.String key, java.lang.String value) {
        if (key == null) {
          throw new NullPointerException("map key");
        }
        if (value == null) {
          throw new NullPointerException("map value");
        }
        internalGetMutableResourceLimits().getMutableMap().put(key, value);
        bitField0_ |= 0x00000020;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Resource limits for each container. Only 'cpu' and 'memory'
       * keys are supported. Defaults to {"cpu": "4", "memory": "4Gi"}.
       *
       *   * The only supported values for CPU are '1', '2', '4', '6' and '8'. For
       *   more information, go to
       *   https://cloud.google.com/run/docs/configuring/cpu.
       *   * The only supported values for memory are '1Gi', '2Gi', ... '32 Gi'.
       *   * For required cpu on different memory values, go to
       *   https://cloud.google.com/run/docs/configuring/memory-limits
       * </pre>
       *
       * <code>
       * map&lt;string, string&gt; resource_limits = 7 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       */
      public Builder putAllResourceLimits(
          java.util.Map<java.lang.String, java.lang.String> values) {
        internalGetMutableResourceLimits().getMutableMap().putAll(values);
        bitField0_ |= 0x00000020;
        return this;
      }

      private int containerConcurrency_;

      /**
       *
       *
       * <pre>
       * Optional. Concurrency for each container and agent server. Recommended
       * value: 2 * cpu + 1. Defaults to 9.
       * </pre>
       *
       * <code>optional int32 container_concurrency = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the containerConcurrency field is set.
       */
      @java.lang.Override
      public boolean hasContainerConcurrency() {
        return ((bitField0_ & 0x00000040) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. Concurrency for each container and agent server. Recommended
       * value: 2 * cpu + 1. Defaults to 9.
       * </pre>
       *
       * <code>optional int32 container_concurrency = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The containerConcurrency.
       */
      @java.lang.Override
      public int getContainerConcurrency() {
        return containerConcurrency_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Concurrency for each container and agent server. Recommended
       * value: 2 * cpu + 1. Defaults to 9.
       * </pre>
       *
       * <code>optional int32 container_concurrency = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The containerConcurrency to set.
       * @return This builder for chaining.
       */
      public Builder setContainerConcurrency(int value) {

        containerConcurrency_ = value;
        bitField0_ |= 0x00000040;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Concurrency for each container and agent server. Recommended
       * value: 2 * cpu + 1. Defaults to 9.
       * </pre>
       *
       * <code>optional int32 container_concurrency = 8 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearContainerConcurrency() {
        bitField0_ = (bitField0_ & ~0x00000040);
        containerConcurrency_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec)
    private static final com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec();
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DeploymentSpec> PARSER =
        new com.google.protobuf.AbstractParser<DeploymentSpec>() {
          @java.lang.Override
          public DeploymentSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DeploymentSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DeploymentSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SourceCodeSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Source code is provided directly in the request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource inline_source = 1;
     * </code>
     *
     * @return Whether the inlineSource field is set.
     */
    boolean hasInlineSource();

    /**
     *
     *
     * <pre>
     * Source code is provided directly in the request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource inline_source = 1;
     * </code>
     *
     * @return The inlineSource.
     */
    com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
        getInlineSource();

    /**
     *
     *
     * <pre>
     * Source code is provided directly in the request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource inline_source = 1;
     * </code>
     */
    com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSourceOrBuilder
        getInlineSourceOrBuilder();

    /**
     *
     *
     * <pre>
     * Configuration for a Python application.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec python_spec = 2;
     * </code>
     *
     * @return Whether the pythonSpec field is set.
     */
    boolean hasPythonSpec();

    /**
     *
     *
     * <pre>
     * Configuration for a Python application.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec python_spec = 2;
     * </code>
     *
     * @return The pythonSpec.
     */
    com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec getPythonSpec();

    /**
     *
     *
     * <pre>
     * Configuration for a Python application.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec python_spec = 2;
     * </code>
     */
    com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpecOrBuilder
        getPythonSpecOrBuilder();

    com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.SourceCase getSourceCase();

    com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.LanguageSpecCase
        getLanguageSpecCase();
  }

  /**
   *
   *
   * <pre>
   * Specification for deploying from source code.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec}
   */
  public static final class SourceCodeSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec)
      SourceCodeSpecOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use SourceCodeSpec.newBuilder() to construct.
    private SourceCodeSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SourceCodeSpec() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SourceCodeSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_SourceCodeSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_SourceCodeSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.class,
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.Builder.class);
    }

    public interface InlineSourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Required. Input only. The application source code archive, provided as
       * a compressed tarball
       * (.tar.gz) file.
       * </pre>
       *
       * <code>
       * bytes source_archive = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return The sourceArchive.
       */
      com.google.protobuf.ByteString getSourceArchive();
    }

    /**
     *
     *
     * <pre>
     * Specifies source code provided as a byte stream.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource}
     */
    public static final class InlineSource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource)
        InlineSourceOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use InlineSource.newBuilder() to construct.
      private InlineSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private InlineSource() {
        sourceArchive_ = com.google.protobuf.ByteString.EMPTY;
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new InlineSource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_SourceCodeSpec_InlineSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_SourceCodeSpec_InlineSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
                    .class,
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
                    .Builder.class);
      }

      public static final int SOURCE_ARCHIVE_FIELD_NUMBER = 1;
      private com.google.protobuf.ByteString sourceArchive_ = com.google.protobuf.ByteString.EMPTY;

      /**
       *
       *
       * <pre>
       * Required. Input only. The application source code archive, provided as
       * a compressed tarball
       * (.tar.gz) file.
       * </pre>
       *
       * <code>
       * bytes source_archive = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
       * </code>
       *
       * @return The sourceArchive.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getSourceArchive() {
        return sourceArchive_;
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!sourceArchive_.isEmpty()) {
          output.writeBytes(1, sourceArchive_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!sourceArchive_.isEmpty()) {
          size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, sourceArchive_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource other =
            (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource) obj;

        if (!getSourceArchive().equals(other.getSourceArchive())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + SOURCE_ARCHIVE_FIELD_NUMBER;
        hash = (53 * hash) + getSourceArchive().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Specifies source code provided as a byte stream.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource)
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.ReasoningEngineProto
              .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_SourceCodeSpec_InlineSource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.ReasoningEngineProto
              .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_SourceCodeSpec_InlineSource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
                      .class,
                  com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          sourceArchive_ = com.google.protobuf.ByteString.EMPTY;
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.ReasoningEngineProto
              .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_SourceCodeSpec_InlineSource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
            build() {
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
            buildPartial() {
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource result =
              new com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.sourceArchive_ = sourceArchive_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource other) {
          if (other
              == com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
                  .getDefaultInstance()) return this;
          if (other.getSourceArchive() != com.google.protobuf.ByteString.EMPTY) {
            setSourceArchive(other.getSourceArchive());
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    sourceArchive_ = input.readBytes();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private com.google.protobuf.ByteString sourceArchive_ =
            com.google.protobuf.ByteString.EMPTY;

        /**
         *
         *
         * <pre>
         * Required. Input only. The application source code archive, provided as
         * a compressed tarball
         * (.tar.gz) file.
         * </pre>
         *
         * <code>
         * bytes source_archive = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
         * </code>
         *
         * @return The sourceArchive.
         */
        @java.lang.Override
        public com.google.protobuf.ByteString getSourceArchive() {
          return sourceArchive_;
        }

        /**
         *
         *
         * <pre>
         * Required. Input only. The application source code archive, provided as
         * a compressed tarball
         * (.tar.gz) file.
         * </pre>
         *
         * <code>
         * bytes source_archive = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
         * </code>
         *
         * @param value The sourceArchive to set.
         * @return This builder for chaining.
         */
        public Builder setSourceArchive(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          sourceArchive_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Required. Input only. The application source code archive, provided as
         * a compressed tarball
         * (.tar.gz) file.
         * </pre>
         *
         * <code>
         * bytes source_archive = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];
         * </code>
         *
         * @return This builder for chaining.
         */
        public Builder clearSourceArchive() {
          bitField0_ = (bitField0_ & ~0x00000001);
          sourceArchive_ = getDefaultInstance().getSourceArchive();
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource)
      private static final com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
              .InlineSource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource();
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<InlineSource> PARSER =
          new com.google.protobuf.AbstractParser<InlineSource>() {
            @java.lang.Override
            public InlineSource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<InlineSource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<InlineSource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    public interface PythonSpecOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Optional. The version of Python to use. Support version
       * includes 3.9, 3.10, 3.11, 3.12, 3.13.
       * If not specified, default value is 3.10.
       * </pre>
       *
       * <code>string version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The version.
       */
      java.lang.String getVersion();

      /**
       *
       *
       * <pre>
       * Optional. The version of Python to use. Support version
       * includes 3.9, 3.10, 3.11, 3.12, 3.13.
       * If not specified, default value is 3.10.
       * </pre>
       *
       * <code>string version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for version.
       */
      com.google.protobuf.ByteString getVersionBytes();

      /**
       *
       *
       * <pre>
       * Optional. The Python module to load as the entrypoint, specified as a
       * fully qualified module name. For example: path.to.agent.
       * If not specified, defaults to "agent".
       *
       * The project root will be added to Python sys.path, allowing imports
       * to be specified relative to the root.
       * </pre>
       *
       * <code>string entrypoint_module = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The entrypointModule.
       */
      java.lang.String getEntrypointModule();

      /**
       *
       *
       * <pre>
       * Optional. The Python module to load as the entrypoint, specified as a
       * fully qualified module name. For example: path.to.agent.
       * If not specified, defaults to "agent".
       *
       * The project root will be added to Python sys.path, allowing imports
       * to be specified relative to the root.
       * </pre>
       *
       * <code>string entrypoint_module = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for entrypointModule.
       */
      com.google.protobuf.ByteString getEntrypointModuleBytes();

      /**
       *
       *
       * <pre>
       * Optional. The name of the callable object within the
       * `entrypoint_module` to use as the application If not specified,
       * defaults to "root_agent".
       * </pre>
       *
       * <code>string entrypoint_object = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The entrypointObject.
       */
      java.lang.String getEntrypointObject();

      /**
       *
       *
       * <pre>
       * Optional. The name of the callable object within the
       * `entrypoint_module` to use as the application If not specified,
       * defaults to "root_agent".
       * </pre>
       *
       * <code>string entrypoint_object = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for entrypointObject.
       */
      com.google.protobuf.ByteString getEntrypointObjectBytes();

      /**
       *
       *
       * <pre>
       * Optional. The path to the requirements file, relative to the source
       * root. If not specified, defaults to "requirements.txt".
       * </pre>
       *
       * <code>string requirements_file = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The requirementsFile.
       */
      java.lang.String getRequirementsFile();

      /**
       *
       *
       * <pre>
       * Optional. The path to the requirements file, relative to the source
       * root. If not specified, defaults to "requirements.txt".
       * </pre>
       *
       * <code>string requirements_file = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for requirementsFile.
       */
      com.google.protobuf.ByteString getRequirementsFileBytes();
    }

    /**
     *
     *
     * <pre>
     * Specification for running a Python application from source.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec}
     */
    public static final class PythonSpec extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec)
        PythonSpecOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use PythonSpec.newBuilder() to construct.
      private PythonSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private PythonSpec() {
        version_ = "";
        entrypointModule_ = "";
        entrypointObject_ = "";
        requirementsFile_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new PythonSpec();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_SourceCodeSpec_PythonSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_SourceCodeSpec_PythonSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec.class,
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec.Builder
                    .class);
      }

      public static final int VERSION_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object version_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The version of Python to use. Support version
       * includes 3.9, 3.10, 3.11, 3.12, 3.13.
       * If not specified, default value is 3.10.
       * </pre>
       *
       * <code>string version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The version.
       */
      @java.lang.Override
      public java.lang.String getVersion() {
        java.lang.Object ref = version_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          version_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The version of Python to use. Support version
       * includes 3.9, 3.10, 3.11, 3.12, 3.13.
       * If not specified, default value is 3.10.
       * </pre>
       *
       * <code>string version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for version.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getVersionBytes() {
        java.lang.Object ref = version_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          version_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ENTRYPOINT_MODULE_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object entrypointModule_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The Python module to load as the entrypoint, specified as a
       * fully qualified module name. For example: path.to.agent.
       * If not specified, defaults to "agent".
       *
       * The project root will be added to Python sys.path, allowing imports
       * to be specified relative to the root.
       * </pre>
       *
       * <code>string entrypoint_module = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The entrypointModule.
       */
      @java.lang.Override
      public java.lang.String getEntrypointModule() {
        java.lang.Object ref = entrypointModule_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          entrypointModule_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The Python module to load as the entrypoint, specified as a
       * fully qualified module name. For example: path.to.agent.
       * If not specified, defaults to "agent".
       *
       * The project root will be added to Python sys.path, allowing imports
       * to be specified relative to the root.
       * </pre>
       *
       * <code>string entrypoint_module = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for entrypointModule.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getEntrypointModuleBytes() {
        java.lang.Object ref = entrypointModule_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          entrypointModule_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int ENTRYPOINT_OBJECT_FIELD_NUMBER = 3;

      @SuppressWarnings("serial")
      private volatile java.lang.Object entrypointObject_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The name of the callable object within the
       * `entrypoint_module` to use as the application If not specified,
       * defaults to "root_agent".
       * </pre>
       *
       * <code>string entrypoint_object = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The entrypointObject.
       */
      @java.lang.Override
      public java.lang.String getEntrypointObject() {
        java.lang.Object ref = entrypointObject_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          entrypointObject_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The name of the callable object within the
       * `entrypoint_module` to use as the application If not specified,
       * defaults to "root_agent".
       * </pre>
       *
       * <code>string entrypoint_object = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for entrypointObject.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getEntrypointObjectBytes() {
        java.lang.Object ref = entrypointObject_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          entrypointObject_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int REQUIREMENTS_FILE_FIELD_NUMBER = 4;

      @SuppressWarnings("serial")
      private volatile java.lang.Object requirementsFile_ = "";

      /**
       *
       *
       * <pre>
       * Optional. The path to the requirements file, relative to the source
       * root. If not specified, defaults to "requirements.txt".
       * </pre>
       *
       * <code>string requirements_file = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The requirementsFile.
       */
      @java.lang.Override
      public java.lang.String getRequirementsFile() {
        java.lang.Object ref = requirementsFile_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          requirementsFile_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. The path to the requirements file, relative to the source
       * root. If not specified, defaults to "requirements.txt".
       * </pre>
       *
       * <code>string requirements_file = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for requirementsFile.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getRequirementsFileBytes() {
        java.lang.Object ref = requirementsFile_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          requirementsFile_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, version_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entrypointModule_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, entrypointModule_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entrypointObject_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 3, entrypointObject_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requirementsFile_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 4, requirementsFile_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(version_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, version_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entrypointModule_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, entrypointModule_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(entrypointObject_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, entrypointObject_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(requirementsFile_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, requirementsFile_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec other =
            (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec) obj;

        if (!getVersion().equals(other.getVersion())) return false;
        if (!getEntrypointModule().equals(other.getEntrypointModule())) return false;
        if (!getEntrypointObject().equals(other.getEntrypointObject())) return false;
        if (!getRequirementsFile().equals(other.getRequirementsFile())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + VERSION_FIELD_NUMBER;
        hash = (53 * hash) + getVersion().hashCode();
        hash = (37 * hash) + ENTRYPOINT_MODULE_FIELD_NUMBER;
        hash = (53 * hash) + getEntrypointModule().hashCode();
        hash = (37 * hash) + ENTRYPOINT_OBJECT_FIELD_NUMBER;
        hash = (53 * hash) + getEntrypointObject().hashCode();
        hash = (37 * hash) + REQUIREMENTS_FILE_FIELD_NUMBER;
        hash = (53 * hash) + getRequirementsFile().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Specification for running a Python application from source.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec)
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpecOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1.ReasoningEngineProto
              .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_SourceCodeSpec_PythonSpec_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1.ReasoningEngineProto
              .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_SourceCodeSpec_PythonSpec_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
                      .class,
                  com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
                      .Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          version_ = "";
          entrypointModule_ = "";
          entrypointObject_ = "";
          requirementsFile_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1.ReasoningEngineProto
              .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_SourceCodeSpec_PythonSpec_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
              .getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
            build() {
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec result =
              buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
            buildPartial() {
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec result =
              new com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec(
                  this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.version_ = version_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.entrypointModule_ = entrypointModule_;
          }
          if (((from_bitField0_ & 0x00000004) != 0)) {
            result.entrypointObject_ = entrypointObject_;
          }
          if (((from_bitField0_ & 0x00000008) != 0)) {
            result.requirementsFile_ = requirementsFile_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec other) {
          if (other
              == com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
                  .getDefaultInstance()) return this;
          if (!other.getVersion().isEmpty()) {
            version_ = other.version_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getEntrypointModule().isEmpty()) {
            entrypointModule_ = other.entrypointModule_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          if (!other.getEntrypointObject().isEmpty()) {
            entrypointObject_ = other.entrypointObject_;
            bitField0_ |= 0x00000004;
            onChanged();
          }
          if (!other.getRequirementsFile().isEmpty()) {
            requirementsFile_ = other.requirementsFile_;
            bitField0_ |= 0x00000008;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    version_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    entrypointModule_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                case 26:
                  {
                    entrypointObject_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000004;
                    break;
                  } // case 26
                case 34:
                  {
                    requirementsFile_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000008;
                    break;
                  } // case 34
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object version_ = "";

        /**
         *
         *
         * <pre>
         * Optional. The version of Python to use. Support version
         * includes 3.9, 3.10, 3.11, 3.12, 3.13.
         * If not specified, default value is 3.10.
         * </pre>
         *
         * <code>string version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The version.
         */
        public java.lang.String getVersion() {
          java.lang.Object ref = version_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            version_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The version of Python to use. Support version
         * includes 3.9, 3.10, 3.11, 3.12, 3.13.
         * If not specified, default value is 3.10.
         * </pre>
         *
         * <code>string version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for version.
         */
        public com.google.protobuf.ByteString getVersionBytes() {
          java.lang.Object ref = version_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            version_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The version of Python to use. Support version
         * includes 3.9, 3.10, 3.11, 3.12, 3.13.
         * If not specified, default value is 3.10.
         * </pre>
         *
         * <code>string version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The version to set.
         * @return This builder for chaining.
         */
        public Builder setVersion(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          version_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The version of Python to use. Support version
         * includes 3.9, 3.10, 3.11, 3.12, 3.13.
         * If not specified, default value is 3.10.
         * </pre>
         *
         * <code>string version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearVersion() {
          version_ = getDefaultInstance().getVersion();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The version of Python to use. Support version
         * includes 3.9, 3.10, 3.11, 3.12, 3.13.
         * If not specified, default value is 3.10.
         * </pre>
         *
         * <code>string version = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for version to set.
         * @return This builder for chaining.
         */
        public Builder setVersionBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          version_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object entrypointModule_ = "";

        /**
         *
         *
         * <pre>
         * Optional. The Python module to load as the entrypoint, specified as a
         * fully qualified module name. For example: path.to.agent.
         * If not specified, defaults to "agent".
         *
         * The project root will be added to Python sys.path, allowing imports
         * to be specified relative to the root.
         * </pre>
         *
         * <code>string entrypoint_module = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The entrypointModule.
         */
        public java.lang.String getEntrypointModule() {
          java.lang.Object ref = entrypointModule_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            entrypointModule_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The Python module to load as the entrypoint, specified as a
         * fully qualified module name. For example: path.to.agent.
         * If not specified, defaults to "agent".
         *
         * The project root will be added to Python sys.path, allowing imports
         * to be specified relative to the root.
         * </pre>
         *
         * <code>string entrypoint_module = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for entrypointModule.
         */
        public com.google.protobuf.ByteString getEntrypointModuleBytes() {
          java.lang.Object ref = entrypointModule_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            entrypointModule_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The Python module to load as the entrypoint, specified as a
         * fully qualified module name. For example: path.to.agent.
         * If not specified, defaults to "agent".
         *
         * The project root will be added to Python sys.path, allowing imports
         * to be specified relative to the root.
         * </pre>
         *
         * <code>string entrypoint_module = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The entrypointModule to set.
         * @return This builder for chaining.
         */
        public Builder setEntrypointModule(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          entrypointModule_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The Python module to load as the entrypoint, specified as a
         * fully qualified module name. For example: path.to.agent.
         * If not specified, defaults to "agent".
         *
         * The project root will be added to Python sys.path, allowing imports
         * to be specified relative to the root.
         * </pre>
         *
         * <code>string entrypoint_module = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEntrypointModule() {
          entrypointModule_ = getDefaultInstance().getEntrypointModule();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The Python module to load as the entrypoint, specified as a
         * fully qualified module name. For example: path.to.agent.
         * If not specified, defaults to "agent".
         *
         * The project root will be added to Python sys.path, allowing imports
         * to be specified relative to the root.
         * </pre>
         *
         * <code>string entrypoint_module = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for entrypointModule to set.
         * @return This builder for chaining.
         */
        public Builder setEntrypointModuleBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          entrypointModule_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        private java.lang.Object entrypointObject_ = "";

        /**
         *
         *
         * <pre>
         * Optional. The name of the callable object within the
         * `entrypoint_module` to use as the application If not specified,
         * defaults to "root_agent".
         * </pre>
         *
         * <code>string entrypoint_object = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The entrypointObject.
         */
        public java.lang.String getEntrypointObject() {
          java.lang.Object ref = entrypointObject_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            entrypointObject_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The name of the callable object within the
         * `entrypoint_module` to use as the application If not specified,
         * defaults to "root_agent".
         * </pre>
         *
         * <code>string entrypoint_object = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for entrypointObject.
         */
        public com.google.protobuf.ByteString getEntrypointObjectBytes() {
          java.lang.Object ref = entrypointObject_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            entrypointObject_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The name of the callable object within the
         * `entrypoint_module` to use as the application If not specified,
         * defaults to "root_agent".
         * </pre>
         *
         * <code>string entrypoint_object = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The entrypointObject to set.
         * @return This builder for chaining.
         */
        public Builder setEntrypointObject(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          entrypointObject_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The name of the callable object within the
         * `entrypoint_module` to use as the application If not specified,
         * defaults to "root_agent".
         * </pre>
         *
         * <code>string entrypoint_object = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearEntrypointObject() {
          entrypointObject_ = getDefaultInstance().getEntrypointObject();
          bitField0_ = (bitField0_ & ~0x00000004);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The name of the callable object within the
         * `entrypoint_module` to use as the application If not specified,
         * defaults to "root_agent".
         * </pre>
         *
         * <code>string entrypoint_object = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for entrypointObject to set.
         * @return This builder for chaining.
         */
        public Builder setEntrypointObjectBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          entrypointObject_ = value;
          bitField0_ |= 0x00000004;
          onChanged();
          return this;
        }

        private java.lang.Object requirementsFile_ = "";

        /**
         *
         *
         * <pre>
         * Optional. The path to the requirements file, relative to the source
         * root. If not specified, defaults to "requirements.txt".
         * </pre>
         *
         * <code>string requirements_file = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The requirementsFile.
         */
        public java.lang.String getRequirementsFile() {
          java.lang.Object ref = requirementsFile_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            requirementsFile_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The path to the requirements file, relative to the source
         * root. If not specified, defaults to "requirements.txt".
         * </pre>
         *
         * <code>string requirements_file = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return The bytes for requirementsFile.
         */
        public com.google.protobuf.ByteString getRequirementsFileBytes() {
          java.lang.Object ref = requirementsFile_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            requirementsFile_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Optional. The path to the requirements file, relative to the source
         * root. If not specified, defaults to "requirements.txt".
         * </pre>
         *
         * <code>string requirements_file = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The requirementsFile to set.
         * @return This builder for chaining.
         */
        public Builder setRequirementsFile(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          requirementsFile_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The path to the requirements file, relative to the source
         * root. If not specified, defaults to "requirements.txt".
         * </pre>
         *
         * <code>string requirements_file = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearRequirementsFile() {
          requirementsFile_ = getDefaultInstance().getRequirementsFile();
          bitField0_ = (bitField0_ & ~0x00000008);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Optional. The path to the requirements file, relative to the source
         * root. If not specified, defaults to "requirements.txt".
         * </pre>
         *
         * <code>string requirements_file = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
         *
         * @param value The bytes for requirementsFile to set.
         * @return This builder for chaining.
         */
        public Builder setRequirementsFileBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          requirementsFile_ = value;
          bitField0_ |= 0x00000008;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec)
      private static final com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
              .PythonSpec
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec();
      }

      public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<PythonSpec> PARSER =
          new com.google.protobuf.AbstractParser<PythonSpec>() {
            @java.lang.Override
            public PythonSpec parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<PythonSpec> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<PythonSpec> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int sourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object source_;

    public enum SourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      INLINE_SOURCE(1),
      SOURCE_NOT_SET(0);
      private final int value;

      private SourceCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static SourceCase forNumber(int value) {
        switch (value) {
          case 1:
            return INLINE_SOURCE;
          case 0:
            return SOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    private int languageSpecCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object languageSpec_;

    public enum LanguageSpecCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      PYTHON_SPEC(2),
      LANGUAGESPEC_NOT_SET(0);
      private final int value;

      private LanguageSpecCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static LanguageSpecCase valueOf(int value) {
        return forNumber(value);
      }

      public static LanguageSpecCase forNumber(int value) {
        switch (value) {
          case 2:
            return PYTHON_SPEC;
          case 0:
            return LANGUAGESPEC_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public LanguageSpecCase getLanguageSpecCase() {
      return LanguageSpecCase.forNumber(languageSpecCase_);
    }

    public static final int INLINE_SOURCE_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * Source code is provided directly in the request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource inline_source = 1;
     * </code>
     *
     * @return Whether the inlineSource field is set.
     */
    @java.lang.Override
    public boolean hasInlineSource() {
      return sourceCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Source code is provided directly in the request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource inline_source = 1;
     * </code>
     *
     * @return The inlineSource.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
        getInlineSource() {
      if (sourceCase_ == 1) {
        return (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource)
            source_;
      }
      return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Source code is provided directly in the request.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource inline_source = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSourceOrBuilder
        getInlineSourceOrBuilder() {
      if (sourceCase_ == 1) {
        return (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource)
            source_;
      }
      return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          .getDefaultInstance();
    }

    public static final int PYTHON_SPEC_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * Configuration for a Python application.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec python_spec = 2;
     * </code>
     *
     * @return Whether the pythonSpec field is set.
     */
    @java.lang.Override
    public boolean hasPythonSpec() {
      return languageSpecCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Configuration for a Python application.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec python_spec = 2;
     * </code>
     *
     * @return The pythonSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
        getPythonSpec() {
      if (languageSpecCase_ == 2) {
        return (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec)
            languageSpec_;
      }
      return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          .getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Configuration for a Python application.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec python_spec = 2;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpecOrBuilder
        getPythonSpecOrBuilder() {
      if (languageSpecCase_ == 2) {
        return (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec)
            languageSpec_;
      }
      return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          .getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (sourceCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource)
                source_);
      }
      if (languageSpecCase_ == 2) {
        output.writeMessage(
            2,
            (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec)
                languageSpec_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (sourceCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource)
                    source_);
      }
      if (languageSpecCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                2,
                (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec)
                    languageSpec_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec other =
          (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec) obj;

      if (!getSourceCase().equals(other.getSourceCase())) return false;
      switch (sourceCase_) {
        case 1:
          if (!getInlineSource().equals(other.getInlineSource())) return false;
          break;
        case 0:
        default:
      }
      if (!getLanguageSpecCase().equals(other.getLanguageSpecCase())) return false;
      switch (languageSpecCase_) {
        case 2:
          if (!getPythonSpec().equals(other.getPythonSpec())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (sourceCase_) {
        case 1:
          hash = (37 * hash) + INLINE_SOURCE_FIELD_NUMBER;
          hash = (53 * hash) + getInlineSource().hashCode();
          break;
        case 0:
        default:
      }
      switch (languageSpecCase_) {
        case 2:
          hash = (37 * hash) + PYTHON_SPEC_FIELD_NUMBER;
          hash = (53 * hash) + getPythonSpec().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Specification for deploying from source code.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec)
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_SourceCodeSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_SourceCodeSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.class,
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (inlineSourceBuilder_ != null) {
          inlineSourceBuilder_.clear();
        }
        if (pythonSpecBuilder_ != null) {
          pythonSpecBuilder_.clear();
        }
        sourceCase_ = 0;
        source_ = null;
        languageSpecCase_ = 0;
        languageSpec_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ReasoningEngineProto
            .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_SourceCodeSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec build() {
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec buildPartial() {
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec result =
            new com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec result) {
        result.sourceCase_ = sourceCase_;
        result.source_ = this.source_;
        if (sourceCase_ == 1 && inlineSourceBuilder_ != null) {
          result.source_ = inlineSourceBuilder_.build();
        }
        result.languageSpecCase_ = languageSpecCase_;
        result.languageSpec_ = this.languageSpec_;
        if (languageSpecCase_ == 2 && pythonSpecBuilder_ != null) {
          result.languageSpec_ = pythonSpecBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
                .getDefaultInstance()) return this;
        switch (other.getSourceCase()) {
          case INLINE_SOURCE:
            {
              mergeInlineSource(other.getInlineSource());
              break;
            }
          case SOURCE_NOT_SET:
            {
              break;
            }
        }
        switch (other.getLanguageSpecCase()) {
          case PYTHON_SPEC:
            {
              mergePythonSpec(other.getPythonSpec());
              break;
            }
          case LANGUAGESPEC_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getInlineSourceFieldBuilder().getBuilder(), extensionRegistry);
                  sourceCase_ = 1;
                  break;
                } // case 10
              case 18:
                {
                  input.readMessage(getPythonSpecFieldBuilder().getBuilder(), extensionRegistry);
                  languageSpecCase_ = 2;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int sourceCase_ = 0;
      private java.lang.Object source_;

      public SourceCase getSourceCase() {
        return SourceCase.forNumber(sourceCase_);
      }

      public Builder clearSource() {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
        return this;
      }

      private int languageSpecCase_ = 0;
      private java.lang.Object languageSpec_;

      public LanguageSpecCase getLanguageSpecCase() {
        return LanguageSpecCase.forNumber(languageSpecCase_);
      }

      public Builder clearLanguageSpec() {
        languageSpecCase_ = 0;
        languageSpec_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource,
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
                  .Builder,
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
                  .InlineSourceOrBuilder>
          inlineSourceBuilder_;

      /**
       *
       *
       * <pre>
       * Source code is provided directly in the request.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource inline_source = 1;
       * </code>
       *
       * @return Whether the inlineSource field is set.
       */
      @java.lang.Override
      public boolean hasInlineSource() {
        return sourceCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Source code is provided directly in the request.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource inline_source = 1;
       * </code>
       *
       * @return The inlineSource.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
          getInlineSource() {
        if (inlineSourceBuilder_ == null) {
          if (sourceCase_ == 1) {
            return (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource)
                source_;
          }
          return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
              .getDefaultInstance();
        } else {
          if (sourceCase_ == 1) {
            return inlineSourceBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Source code is provided directly in the request.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource inline_source = 1;
       * </code>
       */
      public Builder setInlineSource(
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource value) {
        if (inlineSourceBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          inlineSourceBuilder_.setMessage(value);
        }
        sourceCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Source code is provided directly in the request.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource inline_source = 1;
       * </code>
       */
      public Builder setInlineSource(
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource.Builder
              builderForValue) {
        if (inlineSourceBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          inlineSourceBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Source code is provided directly in the request.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource inline_source = 1;
       * </code>
       */
      public Builder mergeInlineSource(
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource value) {
        if (inlineSourceBuilder_ == null) {
          if (sourceCase_ == 1
              && source_
                  != com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
                      .getDefaultInstance()) {
            source_ =
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
                    .newBuilder(
                        (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
                                .InlineSource)
                            source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 1) {
            inlineSourceBuilder_.mergeFrom(value);
          } else {
            inlineSourceBuilder_.setMessage(value);
          }
        }
        sourceCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Source code is provided directly in the request.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource inline_source = 1;
       * </code>
       */
      public Builder clearInlineSource() {
        if (inlineSourceBuilder_ == null) {
          if (sourceCase_ == 1) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 1) {
            sourceCase_ = 0;
            source_ = null;
          }
          inlineSourceBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Source code is provided directly in the request.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource inline_source = 1;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource.Builder
          getInlineSourceBuilder() {
        return getInlineSourceFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Source code is provided directly in the request.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource inline_source = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSourceOrBuilder
          getInlineSourceOrBuilder() {
        if ((sourceCase_ == 1) && (inlineSourceBuilder_ != null)) {
          return inlineSourceBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 1) {
            return (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource)
                source_;
          }
          return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Source code is provided directly in the request.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource inline_source = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource,
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
                  .Builder,
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
                  .InlineSourceOrBuilder>
          getInlineSourceFieldBuilder() {
        if (inlineSourceBuilder_ == null) {
          if (!(sourceCase_ == 1)) {
            source_ =
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
                    .getDefaultInstance();
          }
          inlineSourceBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource,
                  com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource
                      .Builder,
                  com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
                      .InlineSourceOrBuilder>(
                  (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.InlineSource)
                      source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 1;
        onChanged();
        return inlineSourceBuilder_;
      }

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec,
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec.Builder,
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpecOrBuilder>
          pythonSpecBuilder_;

      /**
       *
       *
       * <pre>
       * Configuration for a Python application.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec python_spec = 2;
       * </code>
       *
       * @return Whether the pythonSpec field is set.
       */
      @java.lang.Override
      public boolean hasPythonSpec() {
        return languageSpecCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * Configuration for a Python application.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec python_spec = 2;
       * </code>
       *
       * @return The pythonSpec.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
          getPythonSpec() {
        if (pythonSpecBuilder_ == null) {
          if (languageSpecCase_ == 2) {
            return (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec)
                languageSpec_;
          }
          return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
              .getDefaultInstance();
        } else {
          if (languageSpecCase_ == 2) {
            return pythonSpecBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Configuration for a Python application.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec python_spec = 2;
       * </code>
       */
      public Builder setPythonSpec(
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec value) {
        if (pythonSpecBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          languageSpec_ = value;
          onChanged();
        } else {
          pythonSpecBuilder_.setMessage(value);
        }
        languageSpecCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Configuration for a Python application.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec python_spec = 2;
       * </code>
       */
      public Builder setPythonSpec(
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec.Builder
              builderForValue) {
        if (pythonSpecBuilder_ == null) {
          languageSpec_ = builderForValue.build();
          onChanged();
        } else {
          pythonSpecBuilder_.setMessage(builderForValue.build());
        }
        languageSpecCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Configuration for a Python application.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec python_spec = 2;
       * </code>
       */
      public Builder mergePythonSpec(
          com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec value) {
        if (pythonSpecBuilder_ == null) {
          if (languageSpecCase_ == 2
              && languageSpec_
                  != com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
                      .getDefaultInstance()) {
            languageSpec_ =
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
                    .newBuilder(
                        (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
                                .PythonSpec)
                            languageSpec_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            languageSpec_ = value;
          }
          onChanged();
        } else {
          if (languageSpecCase_ == 2) {
            pythonSpecBuilder_.mergeFrom(value);
          } else {
            pythonSpecBuilder_.setMessage(value);
          }
        }
        languageSpecCase_ = 2;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Configuration for a Python application.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec python_spec = 2;
       * </code>
       */
      public Builder clearPythonSpec() {
        if (pythonSpecBuilder_ == null) {
          if (languageSpecCase_ == 2) {
            languageSpecCase_ = 0;
            languageSpec_ = null;
            onChanged();
          }
        } else {
          if (languageSpecCase_ == 2) {
            languageSpecCase_ = 0;
            languageSpec_ = null;
          }
          pythonSpecBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Configuration for a Python application.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec python_spec = 2;
       * </code>
       */
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec.Builder
          getPythonSpecBuilder() {
        return getPythonSpecFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Configuration for a Python application.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec python_spec = 2;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpecOrBuilder
          getPythonSpecOrBuilder() {
        if ((languageSpecCase_ == 2) && (pythonSpecBuilder_ != null)) {
          return pythonSpecBuilder_.getMessageOrBuilder();
        } else {
          if (languageSpecCase_ == 2) {
            return (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec)
                languageSpec_;
          }
          return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
              .getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Configuration for a Python application.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec python_spec = 2;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec,
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec.Builder,
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpecOrBuilder>
          getPythonSpecFieldBuilder() {
        if (pythonSpecBuilder_ == null) {
          if (!(languageSpecCase_ == 2)) {
            languageSpec_ =
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
                    .getDefaultInstance();
          }
          pythonSpecBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec,
                  com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec
                      .Builder,
                  com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
                      .PythonSpecOrBuilder>(
                  (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.PythonSpec)
                      languageSpec_,
                  getParentForChildren(),
                  isClean());
          languageSpec_ = null;
        }
        languageSpecCase_ = 2;
        onChanged();
        return pythonSpecBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec)
    private static final com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec();
    }

    public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SourceCodeSpec> PARSER =
        new com.google.protobuf.AbstractParser<SourceCodeSpec>() {
          @java.lang.Override
          public SourceCodeSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SourceCodeSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SourceCodeSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int deploymentSourceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object deploymentSource_;

  public enum DeploymentSourceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SOURCE_CODE_SPEC(11),
    DEPLOYMENTSOURCE_NOT_SET(0);
    private final int value;

    private DeploymentSourceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DeploymentSourceCase valueOf(int value) {
      return forNumber(value);
    }

    public static DeploymentSourceCase forNumber(int value) {
      switch (value) {
        case 11:
          return SOURCE_CODE_SPEC;
        case 0:
          return DEPLOYMENTSOURCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DeploymentSourceCase getDeploymentSourceCase() {
    return DeploymentSourceCase.forNumber(deploymentSourceCase_);
  }

  public static final int SOURCE_CODE_SPEC_FIELD_NUMBER = 11;

  /**
   *
   *
   * <pre>
   * Deploy from source code files with a defined entrypoint.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec source_code_spec = 11;
   * </code>
   *
   * @return Whether the sourceCodeSpec field is set.
   */
  @java.lang.Override
  public boolean hasSourceCodeSpec() {
    return deploymentSourceCase_ == 11;
  }

  /**
   *
   *
   * <pre>
   * Deploy from source code files with a defined entrypoint.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec source_code_spec = 11;
   * </code>
   *
   * @return The sourceCodeSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec getSourceCodeSpec() {
    if (deploymentSourceCase_ == 11) {
      return (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec) deploymentSource_;
    }
    return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Deploy from source code files with a defined entrypoint.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec source_code_spec = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpecOrBuilder
      getSourceCodeSpecOrBuilder() {
    if (deploymentSourceCase_ == 11) {
      return (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec) deploymentSource_;
    }
    return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.getDefaultInstance();
  }

  public static final int SERVICE_ACCOUNT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object serviceAccount_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The service account that the Reasoning Engine artifact runs as.
   * It should have "roles/storage.objectViewer" for reading the user project's
   * Cloud Storage and "roles/aiplatform.user" for using Vertex extensions. If
   * not specified, the Vertex AI Reasoning Engine Service Agent in the project
   * will be used.
   * </pre>
   *
   * <code>optional string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the serviceAccount field is set.
   */
  @java.lang.Override
  public boolean hasServiceAccount() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The service account that the Reasoning Engine artifact runs as.
   * It should have "roles/storage.objectViewer" for reading the user project's
   * Cloud Storage and "roles/aiplatform.user" for using Vertex extensions. If
   * not specified, the Vertex AI Reasoning Engine Service Agent in the project
   * will be used.
   * </pre>
   *
   * <code>optional string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The serviceAccount.
   */
  @java.lang.Override
  public java.lang.String getServiceAccount() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      serviceAccount_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The service account that the Reasoning Engine artifact runs as.
   * It should have "roles/storage.objectViewer" for reading the user project's
   * Cloud Storage and "roles/aiplatform.user" for using Vertex extensions. If
   * not specified, the Vertex AI Reasoning Engine Service Agent in the project
   * will be used.
   * </pre>
   *
   * <code>optional string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for serviceAccount.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getServiceAccountBytes() {
    java.lang.Object ref = serviceAccount_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      serviceAccount_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PACKAGE_SPEC_FIELD_NUMBER = 2;
  private com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec packageSpec_;

  /**
   *
   *
   * <pre>
   * Optional. User provided package spec of the ReasoningEngine.
   * Ignored when users directly specify a deployment image through
   * `deployment_spec.first_party_image_override`, but keeping the
   * field_behavior to avoid introducing breaking changes.
   * The `deployment_source` field should not be set if `package_spec` is
   * specified.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the packageSpec field is set.
   */
  @java.lang.Override
  public boolean hasPackageSpec() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. User provided package spec of the ReasoningEngine.
   * Ignored when users directly specify a deployment image through
   * `deployment_spec.first_party_image_override`, but keeping the
   * field_behavior to avoid introducing breaking changes.
   * The `deployment_source` field should not be set if `package_spec` is
   * specified.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The packageSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec getPackageSpec() {
    return packageSpec_ == null
        ? com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec.getDefaultInstance()
        : packageSpec_;
  }

  /**
   *
   *
   * <pre>
   * Optional. User provided package spec of the ReasoningEngine.
   * Ignored when users directly specify a deployment image through
   * `deployment_spec.first_party_image_override`, but keeping the
   * field_behavior to avoid introducing breaking changes.
   * The `deployment_source` field should not be set if `package_spec` is
   * specified.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpecOrBuilder
      getPackageSpecOrBuilder() {
    return packageSpec_ == null
        ? com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec.getDefaultInstance()
        : packageSpec_;
  }

  public static final int DEPLOYMENT_SPEC_FIELD_NUMBER = 4;
  private com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec deploymentSpec_;

  /**
   *
   *
   * <pre>
   * Optional. The specification of a Reasoning Engine deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the deploymentSpec field is set.
   */
  @java.lang.Override
  public boolean hasDeploymentSpec() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The specification of a Reasoning Engine deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The deploymentSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec getDeploymentSpec() {
    return deploymentSpec_ == null
        ? com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.getDefaultInstance()
        : deploymentSpec_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The specification of a Reasoning Engine deployment.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpecOrBuilder
      getDeploymentSpecOrBuilder() {
    return deploymentSpec_ == null
        ? com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.getDefaultInstance()
        : deploymentSpec_;
  }

  public static final int CLASS_METHODS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private java.util.List<com.google.protobuf.Struct> classMethods_;

  /**
   *
   *
   * <pre>
   * Optional. Declarations for object class methods in OpenAPI specification
   * format.
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.protobuf.Struct> getClassMethodsList() {
    return classMethods_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Declarations for object class methods in OpenAPI specification
   * format.
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.protobuf.StructOrBuilder>
      getClassMethodsOrBuilderList() {
    return classMethods_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Declarations for object class methods in OpenAPI specification
   * format.
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getClassMethodsCount() {
    return classMethods_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Declarations for object class methods in OpenAPI specification
   * format.
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Struct getClassMethods(int index) {
    return classMethods_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Declarations for object class methods in OpenAPI specification
   * format.
   * </pre>
   *
   * <code>
   * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.StructOrBuilder getClassMethodsOrBuilder(int index) {
    return classMethods_.get(index);
  }

  public static final int AGENT_FRAMEWORK_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private volatile java.lang.Object agentFramework_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The OSS agent framework used to develop the agent.
   * Currently supported values: "google-adk", "langchain", "langgraph", "ag2",
   * "llama-index", "custom".
   * </pre>
   *
   * <code>string agent_framework = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The agentFramework.
   */
  @java.lang.Override
  public java.lang.String getAgentFramework() {
    java.lang.Object ref = agentFramework_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      agentFramework_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The OSS agent framework used to develop the agent.
   * Currently supported values: "google-adk", "langchain", "langgraph", "ag2",
   * "llama-index", "custom".
   * </pre>
   *
   * <code>string agent_framework = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for agentFramework.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAgentFrameworkBytes() {
    java.lang.Object ref = agentFramework_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      agentFramework_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, serviceAccount_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getPackageSpec());
    }
    for (int i = 0; i < classMethods_.size(); i++) {
      output.writeMessage(3, classMethods_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(4, getDeploymentSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentFramework_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 5, agentFramework_);
    }
    if (deploymentSourceCase_ == 11) {
      output.writeMessage(
          11,
          (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec) deploymentSource_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, serviceAccount_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getPackageSpec());
    }
    for (int i = 0; i < classMethods_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, classMethods_.get(i));
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, getDeploymentSpec());
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(agentFramework_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(5, agentFramework_);
    }
    if (deploymentSourceCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11,
              (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec)
                  deploymentSource_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.ReasoningEngineSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.ReasoningEngineSpec other =
        (com.google.cloud.aiplatform.v1.ReasoningEngineSpec) obj;

    if (hasServiceAccount() != other.hasServiceAccount()) return false;
    if (hasServiceAccount()) {
      if (!getServiceAccount().equals(other.getServiceAccount())) return false;
    }
    if (hasPackageSpec() != other.hasPackageSpec()) return false;
    if (hasPackageSpec()) {
      if (!getPackageSpec().equals(other.getPackageSpec())) return false;
    }
    if (hasDeploymentSpec() != other.hasDeploymentSpec()) return false;
    if (hasDeploymentSpec()) {
      if (!getDeploymentSpec().equals(other.getDeploymentSpec())) return false;
    }
    if (!getClassMethodsList().equals(other.getClassMethodsList())) return false;
    if (!getAgentFramework().equals(other.getAgentFramework())) return false;
    if (!getDeploymentSourceCase().equals(other.getDeploymentSourceCase())) return false;
    switch (deploymentSourceCase_) {
      case 11:
        if (!getSourceCodeSpec().equals(other.getSourceCodeSpec())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasServiceAccount()) {
      hash = (37 * hash) + SERVICE_ACCOUNT_FIELD_NUMBER;
      hash = (53 * hash) + getServiceAccount().hashCode();
    }
    if (hasPackageSpec()) {
      hash = (37 * hash) + PACKAGE_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getPackageSpec().hashCode();
    }
    if (hasDeploymentSpec()) {
      hash = (37 * hash) + DEPLOYMENT_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getDeploymentSpec().hashCode();
    }
    if (getClassMethodsCount() > 0) {
      hash = (37 * hash) + CLASS_METHODS_FIELD_NUMBER;
      hash = (53 * hash) + getClassMethodsList().hashCode();
    }
    hash = (37 * hash) + AGENT_FRAMEWORK_FIELD_NUMBER;
    hash = (53 * hash) + getAgentFramework().hashCode();
    switch (deploymentSourceCase_) {
      case 11:
        hash = (37 * hash) + SOURCE_CODE_SPEC_FIELD_NUMBER;
        hash = (53 * hash) + getSourceCodeSpec().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.ReasoningEngineSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * ReasoningEngine configurations
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ReasoningEngineSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ReasoningEngineSpec)
      com.google.cloud.aiplatform.v1.ReasoningEngineSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.class,
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.ReasoningEngineSpec.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getPackageSpecFieldBuilder();
        getDeploymentSpecFieldBuilder();
        getClassMethodsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (sourceCodeSpecBuilder_ != null) {
        sourceCodeSpecBuilder_.clear();
      }
      serviceAccount_ = "";
      packageSpec_ = null;
      if (packageSpecBuilder_ != null) {
        packageSpecBuilder_.dispose();
        packageSpecBuilder_ = null;
      }
      deploymentSpec_ = null;
      if (deploymentSpecBuilder_ != null) {
        deploymentSpecBuilder_.dispose();
        deploymentSpecBuilder_ = null;
      }
      if (classMethodsBuilder_ == null) {
        classMethods_ = java.util.Collections.emptyList();
      } else {
        classMethods_ = null;
        classMethodsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      agentFramework_ = "";
      deploymentSourceCase_ = 0;
      deploymentSource_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ReasoningEngineProto
          .internal_static_google_cloud_aiplatform_v1_ReasoningEngineSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec build() {
      com.google.cloud.aiplatform.v1.ReasoningEngineSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec buildPartial() {
      com.google.cloud.aiplatform.v1.ReasoningEngineSpec result =
          new com.google.cloud.aiplatform.v1.ReasoningEngineSpec(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec result) {
      if (classMethodsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          classMethods_ = java.util.Collections.unmodifiableList(classMethods_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.classMethods_ = classMethods_;
      } else {
        result.classMethods_ = classMethodsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.ReasoningEngineSpec result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.serviceAccount_ = serviceAccount_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.packageSpec_ =
            packageSpecBuilder_ == null ? packageSpec_ : packageSpecBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.deploymentSpec_ =
            deploymentSpecBuilder_ == null ? deploymentSpec_ : deploymentSpecBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.agentFramework_ = agentFramework_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1.ReasoningEngineSpec result) {
      result.deploymentSourceCase_ = deploymentSourceCase_;
      result.deploymentSource_ = this.deploymentSource_;
      if (deploymentSourceCase_ == 11 && sourceCodeSpecBuilder_ != null) {
        result.deploymentSource_ = sourceCodeSpecBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.ReasoningEngineSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1.ReasoningEngineSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.ReasoningEngineSpec other) {
      if (other == com.google.cloud.aiplatform.v1.ReasoningEngineSpec.getDefaultInstance())
        return this;
      if (other.hasServiceAccount()) {
        serviceAccount_ = other.serviceAccount_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasPackageSpec()) {
        mergePackageSpec(other.getPackageSpec());
      }
      if (other.hasDeploymentSpec()) {
        mergeDeploymentSpec(other.getDeploymentSpec());
      }
      if (classMethodsBuilder_ == null) {
        if (!other.classMethods_.isEmpty()) {
          if (classMethods_.isEmpty()) {
            classMethods_ = other.classMethods_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureClassMethodsIsMutable();
            classMethods_.addAll(other.classMethods_);
          }
          onChanged();
        }
      } else {
        if (!other.classMethods_.isEmpty()) {
          if (classMethodsBuilder_.isEmpty()) {
            classMethodsBuilder_.dispose();
            classMethodsBuilder_ = null;
            classMethods_ = other.classMethods_;
            bitField0_ = (bitField0_ & ~0x00000010);
            classMethodsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getClassMethodsFieldBuilder()
                    : null;
          } else {
            classMethodsBuilder_.addAllMessages(other.classMethods_);
          }
        }
      }
      if (!other.getAgentFramework().isEmpty()) {
        agentFramework_ = other.agentFramework_;
        bitField0_ |= 0x00000020;
        onChanged();
      }
      switch (other.getDeploymentSourceCase()) {
        case SOURCE_CODE_SPEC:
          {
            mergeSourceCodeSpec(other.getSourceCodeSpec());
            break;
          }
        case DEPLOYMENTSOURCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                serviceAccount_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getPackageSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                com.google.protobuf.Struct m =
                    input.readMessage(com.google.protobuf.Struct.parser(), extensionRegistry);
                if (classMethodsBuilder_ == null) {
                  ensureClassMethodsIsMutable();
                  classMethods_.add(m);
                } else {
                  classMethodsBuilder_.addMessage(m);
                }
                break;
              } // case 26
            case 34:
              {
                input.readMessage(getDeploymentSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                agentFramework_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000020;
                break;
              } // case 42
            case 90:
              {
                input.readMessage(getSourceCodeSpecFieldBuilder().getBuilder(), extensionRegistry);
                deploymentSourceCase_ = 11;
                break;
              } // case 90
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int deploymentSourceCase_ = 0;
    private java.lang.Object deploymentSource_;

    public DeploymentSourceCase getDeploymentSourceCase() {
      return DeploymentSourceCase.forNumber(deploymentSourceCase_);
    }

    public Builder clearDeploymentSource() {
      deploymentSourceCase_ = 0;
      deploymentSource_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec,
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.Builder,
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpecOrBuilder>
        sourceCodeSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Deploy from source code files with a defined entrypoint.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec source_code_spec = 11;
     * </code>
     *
     * @return Whether the sourceCodeSpec field is set.
     */
    @java.lang.Override
    public boolean hasSourceCodeSpec() {
      return deploymentSourceCase_ == 11;
    }

    /**
     *
     *
     * <pre>
     * Deploy from source code files with a defined entrypoint.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec source_code_spec = 11;
     * </code>
     *
     * @return The sourceCodeSpec.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec getSourceCodeSpec() {
      if (sourceCodeSpecBuilder_ == null) {
        if (deploymentSourceCase_ == 11) {
          return (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec)
              deploymentSource_;
        }
        return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
            .getDefaultInstance();
      } else {
        if (deploymentSourceCase_ == 11) {
          return sourceCodeSpecBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Deploy from source code files with a defined entrypoint.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec source_code_spec = 11;
     * </code>
     */
    public Builder setSourceCodeSpec(
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec value) {
      if (sourceCodeSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deploymentSource_ = value;
        onChanged();
      } else {
        sourceCodeSpecBuilder_.setMessage(value);
      }
      deploymentSourceCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deploy from source code files with a defined entrypoint.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec source_code_spec = 11;
     * </code>
     */
    public Builder setSourceCodeSpec(
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.Builder builderForValue) {
      if (sourceCodeSpecBuilder_ == null) {
        deploymentSource_ = builderForValue.build();
        onChanged();
      } else {
        sourceCodeSpecBuilder_.setMessage(builderForValue.build());
      }
      deploymentSourceCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deploy from source code files with a defined entrypoint.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec source_code_spec = 11;
     * </code>
     */
    public Builder mergeSourceCodeSpec(
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec value) {
      if (sourceCodeSpecBuilder_ == null) {
        if (deploymentSourceCase_ == 11
            && deploymentSource_
                != com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
                    .getDefaultInstance()) {
          deploymentSource_ =
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.newBuilder(
                      (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec)
                          deploymentSource_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          deploymentSource_ = value;
        }
        onChanged();
      } else {
        if (deploymentSourceCase_ == 11) {
          sourceCodeSpecBuilder_.mergeFrom(value);
        } else {
          sourceCodeSpecBuilder_.setMessage(value);
        }
      }
      deploymentSourceCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deploy from source code files with a defined entrypoint.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec source_code_spec = 11;
     * </code>
     */
    public Builder clearSourceCodeSpec() {
      if (sourceCodeSpecBuilder_ == null) {
        if (deploymentSourceCase_ == 11) {
          deploymentSourceCase_ = 0;
          deploymentSource_ = null;
          onChanged();
        }
      } else {
        if (deploymentSourceCase_ == 11) {
          deploymentSourceCase_ = 0;
          deploymentSource_ = null;
        }
        sourceCodeSpecBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deploy from source code files with a defined entrypoint.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec source_code_spec = 11;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.Builder
        getSourceCodeSpecBuilder() {
      return getSourceCodeSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Deploy from source code files with a defined entrypoint.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec source_code_spec = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpecOrBuilder
        getSourceCodeSpecOrBuilder() {
      if ((deploymentSourceCase_ == 11) && (sourceCodeSpecBuilder_ != null)) {
        return sourceCodeSpecBuilder_.getMessageOrBuilder();
      } else {
        if (deploymentSourceCase_ == 11) {
          return (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec)
              deploymentSource_;
        }
        return com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Deploy from source code files with a defined entrypoint.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec source_code_spec = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec,
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.Builder,
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpecOrBuilder>
        getSourceCodeSpecFieldBuilder() {
      if (sourceCodeSpecBuilder_ == null) {
        if (!(deploymentSourceCase_ == 11)) {
          deploymentSource_ =
              com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec
                  .getDefaultInstance();
        }
        sourceCodeSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec,
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec.Builder,
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpecOrBuilder>(
                (com.google.cloud.aiplatform.v1.ReasoningEngineSpec.SourceCodeSpec)
                    deploymentSource_,
                getParentForChildren(),
                isClean());
        deploymentSource_ = null;
      }
      deploymentSourceCase_ = 11;
      onChanged();
      return sourceCodeSpecBuilder_;
    }

    private java.lang.Object serviceAccount_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The service account that the Reasoning Engine artifact runs as.
     * It should have "roles/storage.objectViewer" for reading the user project's
     * Cloud Storage and "roles/aiplatform.user" for using Vertex extensions. If
     * not specified, the Vertex AI Reasoning Engine Service Agent in the project
     * will be used.
     * </pre>
     *
     * <code>optional string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the serviceAccount field is set.
     */
    public boolean hasServiceAccount() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The service account that the Reasoning Engine artifact runs as.
     * It should have "roles/storage.objectViewer" for reading the user project's
     * Cloud Storage and "roles/aiplatform.user" for using Vertex extensions. If
     * not specified, the Vertex AI Reasoning Engine Service Agent in the project
     * will be used.
     * </pre>
     *
     * <code>optional string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The serviceAccount.
     */
    public java.lang.String getServiceAccount() {
      java.lang.Object ref = serviceAccount_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        serviceAccount_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The service account that the Reasoning Engine artifact runs as.
     * It should have "roles/storage.objectViewer" for reading the user project's
     * Cloud Storage and "roles/aiplatform.user" for using Vertex extensions. If
     * not specified, the Vertex AI Reasoning Engine Service Agent in the project
     * will be used.
     * </pre>
     *
     * <code>optional string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for serviceAccount.
     */
    public com.google.protobuf.ByteString getServiceAccountBytes() {
      java.lang.Object ref = serviceAccount_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        serviceAccount_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The service account that the Reasoning Engine artifact runs as.
     * It should have "roles/storage.objectViewer" for reading the user project's
     * Cloud Storage and "roles/aiplatform.user" for using Vertex extensions. If
     * not specified, the Vertex AI Reasoning Engine Service Agent in the project
     * will be used.
     * </pre>
     *
     * <code>optional string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccount(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      serviceAccount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The service account that the Reasoning Engine artifact runs as.
     * It should have "roles/storage.objectViewer" for reading the user project's
     * Cloud Storage and "roles/aiplatform.user" for using Vertex extensions. If
     * not specified, the Vertex AI Reasoning Engine Service Agent in the project
     * will be used.
     * </pre>
     *
     * <code>optional string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearServiceAccount() {
      serviceAccount_ = getDefaultInstance().getServiceAccount();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The service account that the Reasoning Engine artifact runs as.
     * It should have "roles/storage.objectViewer" for reading the user project's
     * Cloud Storage and "roles/aiplatform.user" for using Vertex extensions. If
     * not specified, the Vertex AI Reasoning Engine Service Agent in the project
     * will be used.
     * </pre>
     *
     * <code>optional string service_account = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for serviceAccount to set.
     * @return This builder for chaining.
     */
    public Builder setServiceAccountBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      serviceAccount_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec packageSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec,
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec.Builder,
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpecOrBuilder>
        packageSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * The `deployment_source` field should not be set if `package_spec` is
     * specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the packageSpec field is set.
     */
    public boolean hasPackageSpec() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * The `deployment_source` field should not be set if `package_spec` is
     * specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The packageSpec.
     */
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec getPackageSpec() {
      if (packageSpecBuilder_ == null) {
        return packageSpec_ == null
            ? com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec.getDefaultInstance()
            : packageSpec_;
      } else {
        return packageSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * The `deployment_source` field should not be set if `package_spec` is
     * specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPackageSpec(
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec value) {
      if (packageSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        packageSpec_ = value;
      } else {
        packageSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * The `deployment_source` field should not be set if `package_spec` is
     * specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPackageSpec(
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec.Builder builderForValue) {
      if (packageSpecBuilder_ == null) {
        packageSpec_ = builderForValue.build();
      } else {
        packageSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * The `deployment_source` field should not be set if `package_spec` is
     * specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePackageSpec(
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec value) {
      if (packageSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)
            && packageSpec_ != null
            && packageSpec_
                != com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec
                    .getDefaultInstance()) {
          getPackageSpecBuilder().mergeFrom(value);
        } else {
          packageSpec_ = value;
        }
      } else {
        packageSpecBuilder_.mergeFrom(value);
      }
      if (packageSpec_ != null) {
        bitField0_ |= 0x00000004;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * The `deployment_source` field should not be set if `package_spec` is
     * specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPackageSpec() {
      bitField0_ = (bitField0_ & ~0x00000004);
      packageSpec_ = null;
      if (packageSpecBuilder_ != null) {
        packageSpecBuilder_.dispose();
        packageSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * The `deployment_source` field should not be set if `package_spec` is
     * specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec.Builder
        getPackageSpecBuilder() {
      bitField0_ |= 0x00000004;
      onChanged();
      return getPackageSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * The `deployment_source` field should not be set if `package_spec` is
     * specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpecOrBuilder
        getPackageSpecOrBuilder() {
      if (packageSpecBuilder_ != null) {
        return packageSpecBuilder_.getMessageOrBuilder();
      } else {
        return packageSpec_ == null
            ? com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec.getDefaultInstance()
            : packageSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. User provided package spec of the ReasoningEngine.
     * Ignored when users directly specify a deployment image through
     * `deployment_spec.first_party_image_override`, but keeping the
     * field_behavior to avoid introducing breaking changes.
     * The `deployment_source` field should not be set if `package_spec` is
     * specified.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec package_spec = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec,
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec.Builder,
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpecOrBuilder>
        getPackageSpecFieldBuilder() {
      if (packageSpecBuilder_ == null) {
        packageSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec,
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpec.Builder,
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.PackageSpecOrBuilder>(
                getPackageSpec(), getParentForChildren(), isClean());
        packageSpec_ = null;
      }
      return packageSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec deploymentSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec,
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.Builder,
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpecOrBuilder>
        deploymentSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the deploymentSpec field is set.
     */
    public boolean hasDeploymentSpec() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The deploymentSpec.
     */
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec getDeploymentSpec() {
      if (deploymentSpecBuilder_ == null) {
        return deploymentSpec_ == null
            ? com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.getDefaultInstance()
            : deploymentSpec_;
      } else {
        return deploymentSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDeploymentSpec(
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec value) {
      if (deploymentSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        deploymentSpec_ = value;
      } else {
        deploymentSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setDeploymentSpec(
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.Builder builderForValue) {
      if (deploymentSpecBuilder_ == null) {
        deploymentSpec_ = builderForValue.build();
      } else {
        deploymentSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeDeploymentSpec(
        com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec value) {
      if (deploymentSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && deploymentSpec_ != null
            && deploymentSpec_
                != com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec
                    .getDefaultInstance()) {
          getDeploymentSpecBuilder().mergeFrom(value);
        } else {
          deploymentSpec_ = value;
        }
      } else {
        deploymentSpecBuilder_.mergeFrom(value);
      }
      if (deploymentSpec_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearDeploymentSpec() {
      bitField0_ = (bitField0_ & ~0x00000008);
      deploymentSpec_ = null;
      if (deploymentSpecBuilder_ != null) {
        deploymentSpecBuilder_.dispose();
        deploymentSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.Builder
        getDeploymentSpecBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getDeploymentSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpecOrBuilder
        getDeploymentSpecOrBuilder() {
      if (deploymentSpecBuilder_ != null) {
        return deploymentSpecBuilder_.getMessageOrBuilder();
      } else {
        return deploymentSpec_ == null
            ? com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.getDefaultInstance()
            : deploymentSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The specification of a Reasoning Engine deployment.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec deployment_spec = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec,
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.Builder,
            com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpecOrBuilder>
        getDeploymentSpecFieldBuilder() {
      if (deploymentSpecBuilder_ == null) {
        deploymentSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec,
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpec.Builder,
                com.google.cloud.aiplatform.v1.ReasoningEngineSpec.DeploymentSpecOrBuilder>(
                getDeploymentSpec(), getParentForChildren(), isClean());
        deploymentSpec_ = null;
      }
      return deploymentSpecBuilder_;
    }

    private java.util.List<com.google.protobuf.Struct> classMethods_ =
        java.util.Collections.emptyList();

    private void ensureClassMethodsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        classMethods_ = new java.util.ArrayList<com.google.protobuf.Struct>(classMethods_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        classMethodsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.protobuf.Struct> getClassMethodsList() {
      if (classMethodsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(classMethods_);
      } else {
        return classMethodsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getClassMethodsCount() {
      if (classMethodsBuilder_ == null) {
        return classMethods_.size();
      } else {
        return classMethodsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct getClassMethods(int index) {
      if (classMethodsBuilder_ == null) {
        return classMethods_.get(index);
      } else {
        return classMethodsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setClassMethods(int index, com.google.protobuf.Struct value) {
      if (classMethodsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClassMethodsIsMutable();
        classMethods_.set(index, value);
        onChanged();
      } else {
        classMethodsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setClassMethods(int index, com.google.protobuf.Struct.Builder builderForValue) {
      if (classMethodsBuilder_ == null) {
        ensureClassMethodsIsMutable();
        classMethods_.set(index, builderForValue.build());
        onChanged();
      } else {
        classMethodsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addClassMethods(com.google.protobuf.Struct value) {
      if (classMethodsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClassMethodsIsMutable();
        classMethods_.add(value);
        onChanged();
      } else {
        classMethodsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addClassMethods(int index, com.google.protobuf.Struct value) {
      if (classMethodsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureClassMethodsIsMutable();
        classMethods_.add(index, value);
        onChanged();
      } else {
        classMethodsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addClassMethods(com.google.protobuf.Struct.Builder builderForValue) {
      if (classMethodsBuilder_ == null) {
        ensureClassMethodsIsMutable();
        classMethods_.add(builderForValue.build());
        onChanged();
      } else {
        classMethodsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addClassMethods(int index, com.google.protobuf.Struct.Builder builderForValue) {
      if (classMethodsBuilder_ == null) {
        ensureClassMethodsIsMutable();
        classMethods_.add(index, builderForValue.build());
        onChanged();
      } else {
        classMethodsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllClassMethods(
        java.lang.Iterable<? extends com.google.protobuf.Struct> values) {
      if (classMethodsBuilder_ == null) {
        ensureClassMethodsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, classMethods_);
        onChanged();
      } else {
        classMethodsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearClassMethods() {
      if (classMethodsBuilder_ == null) {
        classMethods_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        classMethodsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeClassMethods(int index) {
      if (classMethodsBuilder_ == null) {
        ensureClassMethodsIsMutable();
        classMethods_.remove(index);
        onChanged();
      } else {
        classMethodsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct.Builder getClassMethodsBuilder(int index) {
      return getClassMethodsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.StructOrBuilder getClassMethodsOrBuilder(int index) {
      if (classMethodsBuilder_ == null) {
        return classMethods_.get(index);
      } else {
        return classMethodsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.protobuf.StructOrBuilder>
        getClassMethodsOrBuilderList() {
      if (classMethodsBuilder_ != null) {
        return classMethodsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(classMethods_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct.Builder addClassMethodsBuilder() {
      return getClassMethodsFieldBuilder()
          .addBuilder(com.google.protobuf.Struct.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Struct.Builder addClassMethodsBuilder(int index) {
      return getClassMethodsFieldBuilder()
          .addBuilder(index, com.google.protobuf.Struct.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Declarations for object class methods in OpenAPI specification
     * format.
     * </pre>
     *
     * <code>
     * repeated .google.protobuf.Struct class_methods = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.protobuf.Struct.Builder> getClassMethodsBuilderList() {
      return getClassMethodsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.protobuf.Struct,
            com.google.protobuf.Struct.Builder,
            com.google.protobuf.StructOrBuilder>
        getClassMethodsFieldBuilder() {
      if (classMethodsBuilder_ == null) {
        classMethodsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.protobuf.Struct,
                com.google.protobuf.Struct.Builder,
                com.google.protobuf.StructOrBuilder>(
                classMethods_, ((bitField0_ & 0x00000010) != 0), getParentForChildren(), isClean());
        classMethods_ = null;
      }
      return classMethodsBuilder_;
    }

    private java.lang.Object agentFramework_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The OSS agent framework used to develop the agent.
     * Currently supported values: "google-adk", "langchain", "langgraph", "ag2",
     * "llama-index", "custom".
     * </pre>
     *
     * <code>string agent_framework = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The agentFramework.
     */
    public java.lang.String getAgentFramework() {
      java.lang.Object ref = agentFramework_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        agentFramework_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The OSS agent framework used to develop the agent.
     * Currently supported values: "google-adk", "langchain", "langgraph", "ag2",
     * "llama-index", "custom".
     * </pre>
     *
     * <code>string agent_framework = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for agentFramework.
     */
    public com.google.protobuf.ByteString getAgentFrameworkBytes() {
      java.lang.Object ref = agentFramework_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        agentFramework_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The OSS agent framework used to develop the agent.
     * Currently supported values: "google-adk", "langchain", "langgraph", "ag2",
     * "llama-index", "custom".
     * </pre>
     *
     * <code>string agent_framework = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The agentFramework to set.
     * @return This builder for chaining.
     */
    public Builder setAgentFramework(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      agentFramework_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The OSS agent framework used to develop the agent.
     * Currently supported values: "google-adk", "langchain", "langgraph", "ag2",
     * "llama-index", "custom".
     * </pre>
     *
     * <code>string agent_framework = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAgentFramework() {
      agentFramework_ = getDefaultInstance().getAgentFramework();
      bitField0_ = (bitField0_ & ~0x00000020);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The OSS agent framework used to develop the agent.
     * Currently supported values: "google-adk", "langchain", "langgraph", "ag2",
     * "llama-index", "custom".
     * </pre>
     *
     * <code>string agent_framework = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for agentFramework to set.
     * @return This builder for chaining.
     */
    public Builder setAgentFrameworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      agentFramework_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ReasoningEngineSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ReasoningEngineSpec)
  private static final com.google.cloud.aiplatform.v1.ReasoningEngineSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ReasoningEngineSpec();
  }

  public static com.google.cloud.aiplatform.v1.ReasoningEngineSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReasoningEngineSpec> PARSER =
      new com.google.protobuf.AbstractParser<ReasoningEngineSpec>() {
        @java.lang.Override
        public ReasoningEngineSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ReasoningEngineSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReasoningEngineSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ReasoningEngineSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
