/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/tool.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * Retrieve from Vertex AI Search datastore or engine for grounding.
 * datastore and engine are mutually exclusive.
 * See https://cloud.google.com/products/agent-builder
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.VertexAISearch}
 */
public final class VertexAISearch extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.VertexAISearch)
    VertexAISearchOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use VertexAISearch.newBuilder() to construct.
  private VertexAISearch(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private VertexAISearch() {
    datastore_ = "";
    engine_ = "";
    filter_ = "";
    dataStoreSpecs_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new VertexAISearch();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.ToolProto
        .internal_static_google_cloud_aiplatform_v1_VertexAISearch_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.ToolProto
        .internal_static_google_cloud_aiplatform_v1_VertexAISearch_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.VertexAISearch.class,
            com.google.cloud.aiplatform.v1.VertexAISearch.Builder.class);
  }

  public interface DataStoreSpecOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Full resource name of DataStore, such as
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
     * </pre>
     *
     * <code>string data_store = 1;</code>
     *
     * @return The dataStore.
     */
    java.lang.String getDataStore();

    /**
     *
     *
     * <pre>
     * Full resource name of DataStore, such as
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
     * </pre>
     *
     * <code>string data_store = 1;</code>
     *
     * @return The bytes for dataStore.
     */
    com.google.protobuf.ByteString getDataStoreBytes();

    /**
     *
     *
     * <pre>
     * Optional. Filter specification to filter documents in the data store
     * specified by data_store field. For more information on filtering, see
     * [Filtering](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The filter.
     */
    java.lang.String getFilter();

    /**
     *
     *
     * <pre>
     * Optional. Filter specification to filter documents in the data store
     * specified by data_store field. For more information on filtering, see
     * [Filtering](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for filter.
     */
    com.google.protobuf.ByteString getFilterBytes();
  }

  /**
   *
   *
   * <pre>
   * Define data stores within engine to filter on in a search call and
   * configurations for those data stores. For more information, see
   * https://cloud.google.com/generative-ai-app-builder/docs/reference/rpc/google.cloud.discoveryengine.v1#datastorespec
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec}
   */
  public static final class DataStoreSpec extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec)
      DataStoreSpecOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use DataStoreSpec.newBuilder() to construct.
    private DataStoreSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private DataStoreSpec() {
      dataStore_ = "";
      filter_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new DataStoreSpec();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_VertexAISearch_DataStoreSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_VertexAISearch_DataStoreSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.class,
              com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.Builder.class);
    }

    public static final int DATA_STORE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object dataStore_ = "";

    /**
     *
     *
     * <pre>
     * Full resource name of DataStore, such as
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
     * </pre>
     *
     * <code>string data_store = 1;</code>
     *
     * @return The dataStore.
     */
    @java.lang.Override
    public java.lang.String getDataStore() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        dataStore_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Full resource name of DataStore, such as
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
     * </pre>
     *
     * <code>string data_store = 1;</code>
     *
     * @return The bytes for dataStore.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getDataStoreBytes() {
      java.lang.Object ref = dataStore_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        dataStore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int FILTER_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object filter_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Filter specification to filter documents in the data store
     * specified by data_store field. For more information on filtering, see
     * [Filtering](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The filter.
     */
    @java.lang.Override
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Filter specification to filter documents in the data store
     * specified by data_store field. For more information on filtering, see
     * [Filtering](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
     * </pre>
     *
     * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for filter.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, dataStore_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, filter_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(dataStore_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, dataStore_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, filter_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec other =
          (com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec) obj;

      if (!getDataStore().equals(other.getDataStore())) return false;
      if (!getFilter().equals(other.getFilter())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + DATA_STORE_FIELD_NUMBER;
      hash = (53 * hash) + getDataStore().hashCode();
      hash = (37 * hash) + FILTER_FIELD_NUMBER;
      hash = (53 * hash) + getFilter().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Define data stores within engine to filter on in a search call and
     * configurations for those data stores. For more information, see
     * https://cloud.google.com/generative-ai-app-builder/docs/reference/rpc/google.cloud.discoveryengine.v1#datastorespec
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec)
        com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpecOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_VertexAISearch_DataStoreSpec_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_VertexAISearch_DataStoreSpec_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.class,
                com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.Builder.class);
      }

      // Construct using com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        dataStore_ = "";
        filter_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1.ToolProto
            .internal_static_google_cloud_aiplatform_v1_VertexAISearch_DataStoreSpec_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec build() {
        com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec buildPartial() {
        com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec result =
            new com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.dataStore_ = dataStore_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.filter_ = filter_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec) {
          return mergeFrom((com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec other) {
        if (other
            == com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.getDefaultInstance())
          return this;
        if (!other.getDataStore().isEmpty()) {
          dataStore_ = other.dataStore_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.getFilter().isEmpty()) {
          filter_ = other.filter_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  dataStore_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  filter_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object dataStore_ = "";

      /**
       *
       *
       * <pre>
       * Full resource name of DataStore, such as
       * Format:
       * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
       * </pre>
       *
       * <code>string data_store = 1;</code>
       *
       * @return The dataStore.
       */
      public java.lang.String getDataStore() {
        java.lang.Object ref = dataStore_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          dataStore_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Full resource name of DataStore, such as
       * Format:
       * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
       * </pre>
       *
       * <code>string data_store = 1;</code>
       *
       * @return The bytes for dataStore.
       */
      public com.google.protobuf.ByteString getDataStoreBytes() {
        java.lang.Object ref = dataStore_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          dataStore_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Full resource name of DataStore, such as
       * Format:
       * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
       * </pre>
       *
       * <code>string data_store = 1;</code>
       *
       * @param value The dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStore(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        dataStore_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Full resource name of DataStore, such as
       * Format:
       * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
       * </pre>
       *
       * <code>string data_store = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDataStore() {
        dataStore_ = getDefaultInstance().getDataStore();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Full resource name of DataStore, such as
       * Format:
       * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
       * </pre>
       *
       * <code>string data_store = 1;</code>
       *
       * @param value The bytes for dataStore to set.
       * @return This builder for chaining.
       */
      public Builder setDataStoreBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        dataStore_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private java.lang.Object filter_ = "";

      /**
       *
       *
       * <pre>
       * Optional. Filter specification to filter documents in the data store
       * specified by data_store field. For more information on filtering, see
       * [Filtering](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The filter.
       */
      public java.lang.String getFilter() {
        java.lang.Object ref = filter_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          filter_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Filter specification to filter documents in the data store
       * specified by data_store field. For more information on filtering, see
       * [Filtering](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for filter.
       */
      public com.google.protobuf.ByteString getFilterBytes() {
        java.lang.Object ref = filter_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          filter_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. Filter specification to filter documents in the data store
       * specified by data_store field. For more information on filtering, see
       * [Filtering](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilter(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        filter_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Filter specification to filter documents in the data store
       * specified by data_store field. For more information on filtering, see
       * [Filtering](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearFilter() {
        filter_ = getDefaultInstance().getFilter();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Filter specification to filter documents in the data store
       * specified by data_store field. For more information on filtering, see
       * [Filtering](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata)
       * </pre>
       *
       * <code>string filter = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for filter to set.
       * @return This builder for chaining.
       */
      public Builder setFilterBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        filter_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec)
    private static final com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec();
    }

    public static com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<DataStoreSpec> PARSER =
        new com.google.protobuf.AbstractParser<DataStoreSpec>() {
          @java.lang.Override
          public DataStoreSpec parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<DataStoreSpec> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<DataStoreSpec> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int DATASTORE_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object datastore_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Fully-qualified Vertex AI Search data store resource ID.
   * Format:
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
   * </pre>
   *
   * <code>string datastore = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The datastore.
   */
  @java.lang.Override
  public java.lang.String getDatastore() {
    java.lang.Object ref = datastore_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      datastore_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Fully-qualified Vertex AI Search data store resource ID.
   * Format:
   * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
   * </pre>
   *
   * <code>string datastore = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for datastore.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDatastoreBytes() {
    java.lang.Object ref = datastore_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      datastore_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ENGINE_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object engine_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Fully-qualified Vertex AI Search engine resource ID.
   * Format:
   * `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
   * </pre>
   *
   * <code>string engine = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The engine.
   */
  @java.lang.Override
  public java.lang.String getEngine() {
    java.lang.Object ref = engine_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      engine_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Fully-qualified Vertex AI Search engine resource ID.
   * Format:
   * `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
   * </pre>
   *
   * <code>string engine = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for engine.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEngineBytes() {
    java.lang.Object ref = engine_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      engine_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_RESULTS_FIELD_NUMBER = 3;
  private int maxResults_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Number of search results to return per query.
   * The default value is 10.
   * The maximumm allowed value is 10.
   * </pre>
   *
   * <code>int32 max_results = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxResults.
   */
  @java.lang.Override
  public int getMaxResults() {
    return maxResults_;
  }

  public static final int FILTER_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private volatile java.lang.Object filter_ = "";

  /**
   *
   *
   * <pre>
   * Optional. Filter strings to be passed to the search API.
   * </pre>
   *
   * <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filter.
   */
  @java.lang.Override
  public java.lang.String getFilter() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      filter_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. Filter strings to be passed to the search API.
   * </pre>
   *
   * <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filter.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFilterBytes() {
    java.lang.Object ref = filter_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      filter_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DATA_STORE_SPECS_FIELD_NUMBER = 5;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec>
      dataStoreSpecs_;

  /**
   *
   *
   * <pre>
   * Specifications that define the specific DataStores to be searched, along
   * with configurations for those data stores. This is only considered for
   * Engines with multiple data stores.
   * It should only be set if engine is used.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec>
      getDataStoreSpecsList() {
    return dataStoreSpecs_;
  }

  /**
   *
   *
   * <pre>
   * Specifications that define the specific DataStores to be searched, along
   * with configurations for those data stores. This is only considered for
   * Engines with multiple data stores.
   * It should only be set if engine is used.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpecOrBuilder>
      getDataStoreSpecsOrBuilderList() {
    return dataStoreSpecs_;
  }

  /**
   *
   *
   * <pre>
   * Specifications that define the specific DataStores to be searched, along
   * with configurations for those data stores. This is only considered for
   * Engines with multiple data stores.
   * It should only be set if engine is used.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
   * </code>
   */
  @java.lang.Override
  public int getDataStoreSpecsCount() {
    return dataStoreSpecs_.size();
  }

  /**
   *
   *
   * <pre>
   * Specifications that define the specific DataStores to be searched, along
   * with configurations for those data stores. This is only considered for
   * Engines with multiple data stores.
   * It should only be set if engine is used.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec getDataStoreSpecs(int index) {
    return dataStoreSpecs_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Specifications that define the specific DataStores to be searched, along
   * with configurations for those data stores. This is only considered for
   * Engines with multiple data stores.
   * It should only be set if engine is used.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpecOrBuilder
      getDataStoreSpecsOrBuilder(int index) {
    return dataStoreSpecs_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datastore_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, datastore_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(engine_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, engine_);
    }
    if (maxResults_ != 0) {
      output.writeInt32(3, maxResults_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 4, filter_);
    }
    for (int i = 0; i < dataStoreSpecs_.size(); i++) {
      output.writeMessage(5, dataStoreSpecs_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(datastore_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, datastore_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(engine_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, engine_);
    }
    if (maxResults_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, maxResults_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(filter_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(4, filter_);
    }
    for (int i = 0; i < dataStoreSpecs_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, dataStoreSpecs_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.VertexAISearch)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.VertexAISearch other =
        (com.google.cloud.aiplatform.v1.VertexAISearch) obj;

    if (!getDatastore().equals(other.getDatastore())) return false;
    if (!getEngine().equals(other.getEngine())) return false;
    if (getMaxResults() != other.getMaxResults()) return false;
    if (!getFilter().equals(other.getFilter())) return false;
    if (!getDataStoreSpecsList().equals(other.getDataStoreSpecsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + DATASTORE_FIELD_NUMBER;
    hash = (53 * hash) + getDatastore().hashCode();
    hash = (37 * hash) + ENGINE_FIELD_NUMBER;
    hash = (53 * hash) + getEngine().hashCode();
    hash = (37 * hash) + MAX_RESULTS_FIELD_NUMBER;
    hash = (53 * hash) + getMaxResults();
    hash = (37 * hash) + FILTER_FIELD_NUMBER;
    hash = (53 * hash) + getFilter().hashCode();
    if (getDataStoreSpecsCount() > 0) {
      hash = (37 * hash) + DATA_STORE_SPECS_FIELD_NUMBER;
      hash = (53 * hash) + getDataStoreSpecsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.VertexAISearch parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.VertexAISearch parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.VertexAISearch parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.VertexAISearch parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.VertexAISearch parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.VertexAISearch parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.VertexAISearch parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.VertexAISearch parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.VertexAISearch parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.VertexAISearch parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.VertexAISearch parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.VertexAISearch parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.VertexAISearch prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Retrieve from Vertex AI Search datastore or engine for grounding.
   * datastore and engine are mutually exclusive.
   * See https://cloud.google.com/products/agent-builder
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.VertexAISearch}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.VertexAISearch)
      com.google.cloud.aiplatform.v1.VertexAISearchOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_VertexAISearch_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_VertexAISearch_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.VertexAISearch.class,
              com.google.cloud.aiplatform.v1.VertexAISearch.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.VertexAISearch.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      datastore_ = "";
      engine_ = "";
      maxResults_ = 0;
      filter_ = "";
      if (dataStoreSpecsBuilder_ == null) {
        dataStoreSpecs_ = java.util.Collections.emptyList();
      } else {
        dataStoreSpecs_ = null;
        dataStoreSpecsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.ToolProto
          .internal_static_google_cloud_aiplatform_v1_VertexAISearch_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.VertexAISearch getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.VertexAISearch.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.VertexAISearch build() {
      com.google.cloud.aiplatform.v1.VertexAISearch result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.VertexAISearch buildPartial() {
      com.google.cloud.aiplatform.v1.VertexAISearch result =
          new com.google.cloud.aiplatform.v1.VertexAISearch(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1.VertexAISearch result) {
      if (dataStoreSpecsBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          dataStoreSpecs_ = java.util.Collections.unmodifiableList(dataStoreSpecs_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.dataStoreSpecs_ = dataStoreSpecs_;
      } else {
        result.dataStoreSpecs_ = dataStoreSpecsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.VertexAISearch result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.datastore_ = datastore_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.engine_ = engine_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.maxResults_ = maxResults_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.filter_ = filter_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.VertexAISearch) {
        return mergeFrom((com.google.cloud.aiplatform.v1.VertexAISearch) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.VertexAISearch other) {
      if (other == com.google.cloud.aiplatform.v1.VertexAISearch.getDefaultInstance()) return this;
      if (!other.getDatastore().isEmpty()) {
        datastore_ = other.datastore_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getEngine().isEmpty()) {
        engine_ = other.engine_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.getMaxResults() != 0) {
        setMaxResults(other.getMaxResults());
      }
      if (!other.getFilter().isEmpty()) {
        filter_ = other.filter_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (dataStoreSpecsBuilder_ == null) {
        if (!other.dataStoreSpecs_.isEmpty()) {
          if (dataStoreSpecs_.isEmpty()) {
            dataStoreSpecs_ = other.dataStoreSpecs_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureDataStoreSpecsIsMutable();
            dataStoreSpecs_.addAll(other.dataStoreSpecs_);
          }
          onChanged();
        }
      } else {
        if (!other.dataStoreSpecs_.isEmpty()) {
          if (dataStoreSpecsBuilder_.isEmpty()) {
            dataStoreSpecsBuilder_.dispose();
            dataStoreSpecsBuilder_ = null;
            dataStoreSpecs_ = other.dataStoreSpecs_;
            bitField0_ = (bitField0_ & ~0x00000010);
            dataStoreSpecsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getDataStoreSpecsFieldBuilder()
                    : null;
          } else {
            dataStoreSpecsBuilder_.addAllMessages(other.dataStoreSpecs_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                datastore_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                engine_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 24:
              {
                maxResults_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                filter_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 34
            case 42:
              {
                com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.parser(),
                        extensionRegistry);
                if (dataStoreSpecsBuilder_ == null) {
                  ensureDataStoreSpecsIsMutable();
                  dataStoreSpecs_.add(m);
                } else {
                  dataStoreSpecsBuilder_.addMessage(m);
                }
                break;
              } // case 42
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object datastore_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Fully-qualified Vertex AI Search data store resource ID.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
     * </pre>
     *
     * <code>string datastore = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The datastore.
     */
    public java.lang.String getDatastore() {
      java.lang.Object ref = datastore_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        datastore_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Fully-qualified Vertex AI Search data store resource ID.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
     * </pre>
     *
     * <code>string datastore = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for datastore.
     */
    public com.google.protobuf.ByteString getDatastoreBytes() {
      java.lang.Object ref = datastore_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        datastore_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Fully-qualified Vertex AI Search data store resource ID.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
     * </pre>
     *
     * <code>string datastore = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The datastore to set.
     * @return This builder for chaining.
     */
    public Builder setDatastore(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      datastore_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Fully-qualified Vertex AI Search data store resource ID.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
     * </pre>
     *
     * <code>string datastore = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDatastore() {
      datastore_ = getDefaultInstance().getDatastore();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Fully-qualified Vertex AI Search data store resource ID.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/dataStores/{dataStore}`
     * </pre>
     *
     * <code>string datastore = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for datastore to set.
     * @return This builder for chaining.
     */
    public Builder setDatastoreBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      datastore_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object engine_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Fully-qualified Vertex AI Search engine resource ID.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
     * </pre>
     *
     * <code>string engine = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The engine.
     */
    public java.lang.String getEngine() {
      java.lang.Object ref = engine_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        engine_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Fully-qualified Vertex AI Search engine resource ID.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
     * </pre>
     *
     * <code>string engine = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for engine.
     */
    public com.google.protobuf.ByteString getEngineBytes() {
      java.lang.Object ref = engine_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        engine_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Fully-qualified Vertex AI Search engine resource ID.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
     * </pre>
     *
     * <code>string engine = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The engine to set.
     * @return This builder for chaining.
     */
    public Builder setEngine(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      engine_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Fully-qualified Vertex AI Search engine resource ID.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
     * </pre>
     *
     * <code>string engine = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEngine() {
      engine_ = getDefaultInstance().getEngine();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Fully-qualified Vertex AI Search engine resource ID.
     * Format:
     * `projects/{project}/locations/{location}/collections/{collection}/engines/{engine}`
     * </pre>
     *
     * <code>string engine = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for engine to set.
     * @return This builder for chaining.
     */
    public Builder setEngineBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      engine_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private int maxResults_;

    /**
     *
     *
     * <pre>
     * Optional. Number of search results to return per query.
     * The default value is 10.
     * The maximumm allowed value is 10.
     * </pre>
     *
     * <code>int32 max_results = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxResults.
     */
    @java.lang.Override
    public int getMaxResults() {
      return maxResults_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of search results to return per query.
     * The default value is 10.
     * The maximumm allowed value is 10.
     * </pre>
     *
     * <code>int32 max_results = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maxResults to set.
     * @return This builder for chaining.
     */
    public Builder setMaxResults(int value) {

      maxResults_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Number of search results to return per query.
     * The default value is 10.
     * The maximumm allowed value is 10.
     * </pre>
     *
     * <code>int32 max_results = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxResults() {
      bitField0_ = (bitField0_ & ~0x00000004);
      maxResults_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object filter_ = "";

    /**
     *
     *
     * <pre>
     * Optional. Filter strings to be passed to the search API.
     * </pre>
     *
     * <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The filter.
     */
    public java.lang.String getFilter() {
      java.lang.Object ref = filter_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        filter_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Filter strings to be passed to the search API.
     * </pre>
     *
     * <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for filter.
     */
    public com.google.protobuf.ByteString getFilterBytes() {
      java.lang.Object ref = filter_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        filter_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Filter strings to be passed to the search API.
     * </pre>
     *
     * <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilter(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      filter_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Filter strings to be passed to the search API.
     * </pre>
     *
     * <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFilter() {
      filter_ = getDefaultInstance().getFilter();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Filter strings to be passed to the search API.
     * </pre>
     *
     * <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for filter to set.
     * @return This builder for chaining.
     */
    public Builder setFilterBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      filter_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec>
        dataStoreSpecs_ = java.util.Collections.emptyList();

    private void ensureDataStoreSpecsIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        dataStoreSpecs_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec>(
                dataStoreSpecs_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec,
            com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.Builder,
            com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpecOrBuilder>
        dataStoreSpecsBuilder_;

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec>
        getDataStoreSpecsList() {
      if (dataStoreSpecsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(dataStoreSpecs_);
      } else {
        return dataStoreSpecsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public int getDataStoreSpecsCount() {
      if (dataStoreSpecsBuilder_ == null) {
        return dataStoreSpecs_.size();
      } else {
        return dataStoreSpecsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec getDataStoreSpecs(
        int index) {
      if (dataStoreSpecsBuilder_ == null) {
        return dataStoreSpecs_.get(index);
      } else {
        return dataStoreSpecsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public Builder setDataStoreSpecs(
        int index, com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec value) {
      if (dataStoreSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataStoreSpecsIsMutable();
        dataStoreSpecs_.set(index, value);
        onChanged();
      } else {
        dataStoreSpecsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public Builder setDataStoreSpecs(
        int index,
        com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.Builder builderForValue) {
      if (dataStoreSpecsBuilder_ == null) {
        ensureDataStoreSpecsIsMutable();
        dataStoreSpecs_.set(index, builderForValue.build());
        onChanged();
      } else {
        dataStoreSpecsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public Builder addDataStoreSpecs(
        com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec value) {
      if (dataStoreSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataStoreSpecsIsMutable();
        dataStoreSpecs_.add(value);
        onChanged();
      } else {
        dataStoreSpecsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public Builder addDataStoreSpecs(
        int index, com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec value) {
      if (dataStoreSpecsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDataStoreSpecsIsMutable();
        dataStoreSpecs_.add(index, value);
        onChanged();
      } else {
        dataStoreSpecsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public Builder addDataStoreSpecs(
        com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.Builder builderForValue) {
      if (dataStoreSpecsBuilder_ == null) {
        ensureDataStoreSpecsIsMutable();
        dataStoreSpecs_.add(builderForValue.build());
        onChanged();
      } else {
        dataStoreSpecsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public Builder addDataStoreSpecs(
        int index,
        com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.Builder builderForValue) {
      if (dataStoreSpecsBuilder_ == null) {
        ensureDataStoreSpecsIsMutable();
        dataStoreSpecs_.add(index, builderForValue.build());
        onChanged();
      } else {
        dataStoreSpecsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public Builder addAllDataStoreSpecs(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec>
            values) {
      if (dataStoreSpecsBuilder_ == null) {
        ensureDataStoreSpecsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, dataStoreSpecs_);
        onChanged();
      } else {
        dataStoreSpecsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public Builder clearDataStoreSpecs() {
      if (dataStoreSpecsBuilder_ == null) {
        dataStoreSpecs_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        dataStoreSpecsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public Builder removeDataStoreSpecs(int index) {
      if (dataStoreSpecsBuilder_ == null) {
        ensureDataStoreSpecsIsMutable();
        dataStoreSpecs_.remove(index);
        onChanged();
      } else {
        dataStoreSpecsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.Builder
        getDataStoreSpecsBuilder(int index) {
      return getDataStoreSpecsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpecOrBuilder
        getDataStoreSpecsOrBuilder(int index) {
      if (dataStoreSpecsBuilder_ == null) {
        return dataStoreSpecs_.get(index);
      } else {
        return dataStoreSpecsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public java.util.List<
            ? extends com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpecOrBuilder>
        getDataStoreSpecsOrBuilderList() {
      if (dataStoreSpecsBuilder_ != null) {
        return dataStoreSpecsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(dataStoreSpecs_);
      }
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.Builder
        addDataStoreSpecsBuilder() {
      return getDataStoreSpecsFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.Builder
        addDataStoreSpecsBuilder(int index) {
      return getDataStoreSpecsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Specifications that define the specific DataStores to be searched, along
     * with configurations for those data stores. This is only considered for
     * Engines with multiple data stores.
     * It should only be set if engine is used.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec data_store_specs = 5;
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.Builder>
        getDataStoreSpecsBuilderList() {
      return getDataStoreSpecsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec,
            com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.Builder,
            com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpecOrBuilder>
        getDataStoreSpecsFieldBuilder() {
      if (dataStoreSpecsBuilder_ == null) {
        dataStoreSpecsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec,
                com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpec.Builder,
                com.google.cloud.aiplatform.v1.VertexAISearch.DataStoreSpecOrBuilder>(
                dataStoreSpecs_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        dataStoreSpecs_ = null;
      }
      return dataStoreSpecsBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.VertexAISearch)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.VertexAISearch)
  private static final com.google.cloud.aiplatform.v1.VertexAISearch DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.VertexAISearch();
  }

  public static com.google.cloud.aiplatform.v1.VertexAISearch getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<VertexAISearch> PARSER =
      new com.google.protobuf.AbstractParser<VertexAISearch>() {
        @java.lang.Override
        public VertexAISearch parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<VertexAISearch> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<VertexAISearch> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.VertexAISearch getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
