/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class RagCorpusName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RAG_CORPUS = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/ragCorpora/{rag_corpus}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String ragCorpus;

    @Deprecated
    protected RagCorpusName() {
        this.project = null;
        this.location = null;
        this.ragCorpus = null;
    }

    private RagCorpusName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.ragCorpus = (String)Preconditions.checkNotNull((Object)builder.getRagCorpus());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRagCorpus() {
        return this.ragCorpus;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RagCorpusName of(String project, String location, String ragCorpus) {
        return RagCorpusName.newBuilder().setProject(project).setLocation(location).setRagCorpus(ragCorpus).build();
    }

    public static String format(String project, String location, String ragCorpus) {
        return RagCorpusName.newBuilder().setProject(project).setLocation(location).setRagCorpus(ragCorpus).build().toString();
    }

    public static RagCorpusName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RAG_CORPUS.validatedMatch(formattedString, "RagCorpusName.parse: formattedString not in valid format");
        return RagCorpusName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("rag_corpus"));
    }

    public static List<RagCorpusName> parseList(List<String> formattedStrings) {
        ArrayList<RagCorpusName> list = new ArrayList<RagCorpusName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(RagCorpusName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<RagCorpusName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (RagCorpusName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RAG_CORPUS.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RagCorpusName ragCorpusName = this;
            synchronized (ragCorpusName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.ragCorpus != null) {
                        fieldMapBuilder.put((Object)"rag_corpus", (Object)this.ragCorpus);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RAG_CORPUS.instantiate(new String[]{"project", this.project, "location", this.location, "rag_corpus", this.ragCorpus});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RagCorpusName that = (RagCorpusName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.ragCorpus, that.ragCorpus);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.ragCorpus);
    }

    public static class Builder {
        private String project;
        private String location;
        private String ragCorpus;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRagCorpus() {
            return this.ragCorpus;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRagCorpus(String ragCorpus) {
            this.ragCorpus = ragCorpus;
            return this;
        }

        private Builder(RagCorpusName ragCorpusName) {
            this.project = ragCorpusName.project;
            this.location = ragCorpusName.location;
            this.ragCorpus = ragCorpusName.ragCorpus;
        }

        public RagCorpusName build() {
            return new RagCorpusName(this);
        }
    }
}

