/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ModelName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_MODEL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/models/{model}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String model;

    @Deprecated
    protected ModelName() {
        this.project = null;
        this.location = null;
        this.model = null;
    }

    private ModelName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.model = (String)Preconditions.checkNotNull((Object)builder.getModel());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getModel() {
        return this.model;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ModelName of(String project, String location, String model) {
        return ModelName.newBuilder().setProject(project).setLocation(location).setModel(model).build();
    }

    public static String format(String project, String location, String model) {
        return ModelName.newBuilder().setProject(project).setLocation(location).setModel(model).build().toString();
    }

    public static ModelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_MODEL.validatedMatch(formattedString, "ModelName.parse: formattedString not in valid format");
        return ModelName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("model"));
    }

    public static List<ModelName> parseList(List<String> formattedStrings) {
        ArrayList<ModelName> list = new ArrayList<ModelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ModelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ModelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ModelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_MODEL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ModelName modelName = this;
            synchronized (modelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.model != null) {
                        fieldMapBuilder.put((Object)"model", (Object)this.model);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_MODEL.instantiate(new String[]{"project", this.project, "location", this.location, "model", this.model});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ModelName that = (ModelName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.model, that.model);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.model);
    }

    public static class Builder {
        private String project;
        private String location;
        private String model;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getModel() {
            return this.model;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setModel(String model) {
            this.model = model;
            return this;
        }

        private Builder(ModelName modelName) {
            this.project = modelName.project;
            this.location = modelName.location;
            this.model = modelName.model;
        }

        public ModelName build() {
            return new ModelName(this);
        }
    }
}

