/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/feature_monitor.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Stats and Anomaly generated by FeatureMonitorJobs. Anomaly only includes
 * Drift.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly}
 */
public final class FeatureStatsAndAnomaly extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly)
    FeatureStatsAndAnomalyOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use FeatureStatsAndAnomaly.newBuilder() to construct.
  private FeatureStatsAndAnomaly(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private FeatureStatsAndAnomaly() {
    featureId_ = "";
    featureMonitorId_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new FeatureStatsAndAnomaly();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.FeatureMonitorProto
        .internal_static_google_cloud_aiplatform_v1beta1_FeatureStatsAndAnomaly_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.FeatureMonitorProto
        .internal_static_google_cloud_aiplatform_v1beta1_FeatureStatsAndAnomaly_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.class,
            com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.Builder.class);
  }

  private int bitField0_;
  public static final int FEATURE_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object featureId_ = "";

  /**
   *
   *
   * <pre>
   * Feature Id.
   * </pre>
   *
   * <code>string feature_id = 1;</code>
   *
   * @return The featureId.
   */
  @java.lang.Override
  public java.lang.String getFeatureId() {
    java.lang.Object ref = featureId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      featureId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Feature Id.
   * </pre>
   *
   * <code>string feature_id = 1;</code>
   *
   * @return The bytes for featureId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFeatureIdBytes() {
    java.lang.Object ref = featureId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      featureId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int FEATURE_STATS_FIELD_NUMBER = 2;
  private com.google.protobuf.Value featureStats_;

  /**
   *
   *
   * <pre>
   * Feature stats. e.g. histogram buckets.
   * In the format of tensorflow.metadata.v0.DatasetFeatureStatistics.
   * </pre>
   *
   * <code>.google.protobuf.Value feature_stats = 2;</code>
   *
   * @return Whether the featureStats field is set.
   */
  @java.lang.Override
  public boolean hasFeatureStats() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Feature stats. e.g. histogram buckets.
   * In the format of tensorflow.metadata.v0.DatasetFeatureStatistics.
   * </pre>
   *
   * <code>.google.protobuf.Value feature_stats = 2;</code>
   *
   * @return The featureStats.
   */
  @java.lang.Override
  public com.google.protobuf.Value getFeatureStats() {
    return featureStats_ == null ? com.google.protobuf.Value.getDefaultInstance() : featureStats_;
  }

  /**
   *
   *
   * <pre>
   * Feature stats. e.g. histogram buckets.
   * In the format of tensorflow.metadata.v0.DatasetFeatureStatistics.
   * </pre>
   *
   * <code>.google.protobuf.Value feature_stats = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.ValueOrBuilder getFeatureStatsOrBuilder() {
    return featureStats_ == null ? com.google.protobuf.Value.getDefaultInstance() : featureStats_;
  }

  public static final int DISTRIBUTION_DEVIATION_FIELD_NUMBER = 3;
  private double distributionDeviation_ = 0D;

  /**
   *
   *
   * <pre>
   * Deviation from the current stats to baseline stats.
   *   1. For categorical feature, the distribution distance is calculated by
   *      L-inifinity norm.
   *   2. For numerical feature, the distribution distance is calculated by
   *      Jensen–Shannon divergence.
   * </pre>
   *
   * <code>double distribution_deviation = 3;</code>
   *
   * @return The distributionDeviation.
   */
  @java.lang.Override
  public double getDistributionDeviation() {
    return distributionDeviation_;
  }

  public static final int DRIFT_DETECTION_THRESHOLD_FIELD_NUMBER = 4;
  private double driftDetectionThreshold_ = 0D;

  /**
   *
   *
   * <pre>
   * This is the threshold used when detecting drifts, which is set in
   * FeatureMonitor.FeatureSelectionConfig.FeatureConfig.drift_threshold
   * </pre>
   *
   * <code>double drift_detection_threshold = 4;</code>
   *
   * @return The driftDetectionThreshold.
   */
  @java.lang.Override
  public double getDriftDetectionThreshold() {
    return driftDetectionThreshold_;
  }

  public static final int DRIFT_DETECTED_FIELD_NUMBER = 5;
  private boolean driftDetected_ = false;

  /**
   *
   *
   * <pre>
   * If set to true, indicates current stats is detected as and comparing
   * with baseline stats.
   * </pre>
   *
   * <code>bool drift_detected = 5;</code>
   *
   * @return The driftDetected.
   */
  @java.lang.Override
  public boolean getDriftDetected() {
    return driftDetected_;
  }

  public static final int STATS_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp statsTime_;

  /**
   *
   *
   * <pre>
   * The timestamp we take snapshot for feature values to generate stats.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp stats_time = 6;</code>
   *
   * @return Whether the statsTime field is set.
   */
  @java.lang.Override
  public boolean hasStatsTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The timestamp we take snapshot for feature values to generate stats.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp stats_time = 6;</code>
   *
   * @return The statsTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStatsTime() {
    return statsTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : statsTime_;
  }

  /**
   *
   *
   * <pre>
   * The timestamp we take snapshot for feature values to generate stats.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp stats_time = 6;</code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStatsTimeOrBuilder() {
    return statsTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : statsTime_;
  }

  public static final int FEATURE_MONITOR_JOB_ID_FIELD_NUMBER = 7;
  private long featureMonitorJobId_ = 0L;

  /**
   *
   *
   * <pre>
   * The ID of the FeatureMonitorJob that generated this FeatureStatsAndAnomaly.
   * </pre>
   *
   * <code>int64 feature_monitor_job_id = 7;</code>
   *
   * @return The featureMonitorJobId.
   */
  @java.lang.Override
  public long getFeatureMonitorJobId() {
    return featureMonitorJobId_;
  }

  public static final int FEATURE_MONITOR_ID_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private volatile java.lang.Object featureMonitorId_ = "";

  /**
   *
   *
   * <pre>
   * The ID of the FeatureMonitor that this FeatureStatsAndAnomaly generated
   * according to.
   * </pre>
   *
   * <code>string feature_monitor_id = 8;</code>
   *
   * @return The featureMonitorId.
   */
  @java.lang.Override
  public java.lang.String getFeatureMonitorId() {
    java.lang.Object ref = featureMonitorId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      featureMonitorId_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The ID of the FeatureMonitor that this FeatureStatsAndAnomaly generated
   * according to.
   * </pre>
   *
   * <code>string feature_monitor_id = 8;</code>
   *
   * @return The bytes for featureMonitorId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getFeatureMonitorIdBytes() {
    java.lang.Object ref = featureMonitorId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      featureMonitorId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, featureId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(2, getFeatureStats());
    }
    if (java.lang.Double.doubleToRawLongBits(distributionDeviation_) != 0) {
      output.writeDouble(3, distributionDeviation_);
    }
    if (java.lang.Double.doubleToRawLongBits(driftDetectionThreshold_) != 0) {
      output.writeDouble(4, driftDetectionThreshold_);
    }
    if (driftDetected_ != false) {
      output.writeBool(5, driftDetected_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(6, getStatsTime());
    }
    if (featureMonitorJobId_ != 0L) {
      output.writeInt64(7, featureMonitorJobId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureMonitorId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, featureMonitorId_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, featureId_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getFeatureStats());
    }
    if (java.lang.Double.doubleToRawLongBits(distributionDeviation_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(3, distributionDeviation_);
    }
    if (java.lang.Double.doubleToRawLongBits(driftDetectionThreshold_) != 0) {
      size += com.google.protobuf.CodedOutputStream.computeDoubleSize(4, driftDetectionThreshold_);
    }
    if (driftDetected_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, driftDetected_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getStatsTime());
    }
    if (featureMonitorJobId_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, featureMonitorJobId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(featureMonitorId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(8, featureMonitorId_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly other =
        (com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly) obj;

    if (!getFeatureId().equals(other.getFeatureId())) return false;
    if (hasFeatureStats() != other.hasFeatureStats()) return false;
    if (hasFeatureStats()) {
      if (!getFeatureStats().equals(other.getFeatureStats())) return false;
    }
    if (java.lang.Double.doubleToLongBits(getDistributionDeviation())
        != java.lang.Double.doubleToLongBits(other.getDistributionDeviation())) return false;
    if (java.lang.Double.doubleToLongBits(getDriftDetectionThreshold())
        != java.lang.Double.doubleToLongBits(other.getDriftDetectionThreshold())) return false;
    if (getDriftDetected() != other.getDriftDetected()) return false;
    if (hasStatsTime() != other.hasStatsTime()) return false;
    if (hasStatsTime()) {
      if (!getStatsTime().equals(other.getStatsTime())) return false;
    }
    if (getFeatureMonitorJobId() != other.getFeatureMonitorJobId()) return false;
    if (!getFeatureMonitorId().equals(other.getFeatureMonitorId())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + FEATURE_ID_FIELD_NUMBER;
    hash = (53 * hash) + getFeatureId().hashCode();
    if (hasFeatureStats()) {
      hash = (37 * hash) + FEATURE_STATS_FIELD_NUMBER;
      hash = (53 * hash) + getFeatureStats().hashCode();
    }
    hash = (37 * hash) + DISTRIBUTION_DEVIATION_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getDistributionDeviation()));
    hash = (37 * hash) + DRIFT_DETECTION_THRESHOLD_FIELD_NUMBER;
    hash =
        (53 * hash)
            + com.google.protobuf.Internal.hashLong(
                java.lang.Double.doubleToLongBits(getDriftDetectionThreshold()));
    hash = (37 * hash) + DRIFT_DETECTED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDriftDetected());
    if (hasStatsTime()) {
      hash = (37 * hash) + STATS_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStatsTime().hashCode();
    }
    hash = (37 * hash) + FEATURE_MONITOR_JOB_ID_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getFeatureMonitorJobId());
    hash = (37 * hash) + FEATURE_MONITOR_ID_FIELD_NUMBER;
    hash = (53 * hash) + getFeatureMonitorId().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Stats and Anomaly generated by FeatureMonitorJobs. Anomaly only includes
   * Drift.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly)
      com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomalyOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureMonitorProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureStatsAndAnomaly_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureMonitorProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureStatsAndAnomaly_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.class,
              com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFeatureStatsFieldBuilder();
        getStatsTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      featureId_ = "";
      featureStats_ = null;
      if (featureStatsBuilder_ != null) {
        featureStatsBuilder_.dispose();
        featureStatsBuilder_ = null;
      }
      distributionDeviation_ = 0D;
      driftDetectionThreshold_ = 0D;
      driftDetected_ = false;
      statsTime_ = null;
      if (statsTimeBuilder_ != null) {
        statsTimeBuilder_.dispose();
        statsTimeBuilder_ = null;
      }
      featureMonitorJobId_ = 0L;
      featureMonitorId_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureMonitorProto
          .internal_static_google_cloud_aiplatform_v1beta1_FeatureStatsAndAnomaly_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly build() {
      com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly buildPartial() {
      com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly result =
          new com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.featureId_ = featureId_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.featureStats_ =
            featureStatsBuilder_ == null ? featureStats_ : featureStatsBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.distributionDeviation_ = distributionDeviation_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.driftDetectionThreshold_ = driftDetectionThreshold_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.driftDetected_ = driftDetected_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.statsTime_ = statsTimeBuilder_ == null ? statsTime_ : statsTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.featureMonitorJobId_ = featureMonitorJobId_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.featureMonitorId_ = featureMonitorId_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly other) {
      if (other == com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly.getDefaultInstance())
        return this;
      if (!other.getFeatureId().isEmpty()) {
        featureId_ = other.featureId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasFeatureStats()) {
        mergeFeatureStats(other.getFeatureStats());
      }
      if (other.getDistributionDeviation() != 0D) {
        setDistributionDeviation(other.getDistributionDeviation());
      }
      if (other.getDriftDetectionThreshold() != 0D) {
        setDriftDetectionThreshold(other.getDriftDetectionThreshold());
      }
      if (other.getDriftDetected() != false) {
        setDriftDetected(other.getDriftDetected());
      }
      if (other.hasStatsTime()) {
        mergeStatsTime(other.getStatsTime());
      }
      if (other.getFeatureMonitorJobId() != 0L) {
        setFeatureMonitorJobId(other.getFeatureMonitorJobId());
      }
      if (!other.getFeatureMonitorId().isEmpty()) {
        featureMonitorId_ = other.featureMonitorId_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                featureId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getFeatureStatsFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 25:
              {
                distributionDeviation_ = input.readDouble();
                bitField0_ |= 0x00000004;
                break;
              } // case 25
            case 33:
              {
                driftDetectionThreshold_ = input.readDouble();
                bitField0_ |= 0x00000008;
                break;
              } // case 33
            case 40:
              {
                driftDetected_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getStatsTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 50
            case 56:
              {
                featureMonitorJobId_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 56
            case 66:
              {
                featureMonitorId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object featureId_ = "";

    /**
     *
     *
     * <pre>
     * Feature Id.
     * </pre>
     *
     * <code>string feature_id = 1;</code>
     *
     * @return The featureId.
     */
    public java.lang.String getFeatureId() {
      java.lang.Object ref = featureId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        featureId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Feature Id.
     * </pre>
     *
     * <code>string feature_id = 1;</code>
     *
     * @return The bytes for featureId.
     */
    public com.google.protobuf.ByteString getFeatureIdBytes() {
      java.lang.Object ref = featureId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        featureId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Feature Id.
     * </pre>
     *
     * <code>string feature_id = 1;</code>
     *
     * @param value The featureId to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      featureId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Feature Id.
     * </pre>
     *
     * <code>string feature_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFeatureId() {
      featureId_ = getDefaultInstance().getFeatureId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Feature Id.
     * </pre>
     *
     * <code>string feature_id = 1;</code>
     *
     * @param value The bytes for featureId to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      featureId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.Value featureStats_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        featureStatsBuilder_;

    /**
     *
     *
     * <pre>
     * Feature stats. e.g. histogram buckets.
     * In the format of tensorflow.metadata.v0.DatasetFeatureStatistics.
     * </pre>
     *
     * <code>.google.protobuf.Value feature_stats = 2;</code>
     *
     * @return Whether the featureStats field is set.
     */
    public boolean hasFeatureStats() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * Feature stats. e.g. histogram buckets.
     * In the format of tensorflow.metadata.v0.DatasetFeatureStatistics.
     * </pre>
     *
     * <code>.google.protobuf.Value feature_stats = 2;</code>
     *
     * @return The featureStats.
     */
    public com.google.protobuf.Value getFeatureStats() {
      if (featureStatsBuilder_ == null) {
        return featureStats_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : featureStats_;
      } else {
        return featureStatsBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Feature stats. e.g. histogram buckets.
     * In the format of tensorflow.metadata.v0.DatasetFeatureStatistics.
     * </pre>
     *
     * <code>.google.protobuf.Value feature_stats = 2;</code>
     */
    public Builder setFeatureStats(com.google.protobuf.Value value) {
      if (featureStatsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        featureStats_ = value;
      } else {
        featureStatsBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Feature stats. e.g. histogram buckets.
     * In the format of tensorflow.metadata.v0.DatasetFeatureStatistics.
     * </pre>
     *
     * <code>.google.protobuf.Value feature_stats = 2;</code>
     */
    public Builder setFeatureStats(com.google.protobuf.Value.Builder builderForValue) {
      if (featureStatsBuilder_ == null) {
        featureStats_ = builderForValue.build();
      } else {
        featureStatsBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Feature stats. e.g. histogram buckets.
     * In the format of tensorflow.metadata.v0.DatasetFeatureStatistics.
     * </pre>
     *
     * <code>.google.protobuf.Value feature_stats = 2;</code>
     */
    public Builder mergeFeatureStats(com.google.protobuf.Value value) {
      if (featureStatsBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && featureStats_ != null
            && featureStats_ != com.google.protobuf.Value.getDefaultInstance()) {
          getFeatureStatsBuilder().mergeFrom(value);
        } else {
          featureStats_ = value;
        }
      } else {
        featureStatsBuilder_.mergeFrom(value);
      }
      if (featureStats_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Feature stats. e.g. histogram buckets.
     * In the format of tensorflow.metadata.v0.DatasetFeatureStatistics.
     * </pre>
     *
     * <code>.google.protobuf.Value feature_stats = 2;</code>
     */
    public Builder clearFeatureStats() {
      bitField0_ = (bitField0_ & ~0x00000002);
      featureStats_ = null;
      if (featureStatsBuilder_ != null) {
        featureStatsBuilder_.dispose();
        featureStatsBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Feature stats. e.g. histogram buckets.
     * In the format of tensorflow.metadata.v0.DatasetFeatureStatistics.
     * </pre>
     *
     * <code>.google.protobuf.Value feature_stats = 2;</code>
     */
    public com.google.protobuf.Value.Builder getFeatureStatsBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getFeatureStatsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Feature stats. e.g. histogram buckets.
     * In the format of tensorflow.metadata.v0.DatasetFeatureStatistics.
     * </pre>
     *
     * <code>.google.protobuf.Value feature_stats = 2;</code>
     */
    public com.google.protobuf.ValueOrBuilder getFeatureStatsOrBuilder() {
      if (featureStatsBuilder_ != null) {
        return featureStatsBuilder_.getMessageOrBuilder();
      } else {
        return featureStats_ == null
            ? com.google.protobuf.Value.getDefaultInstance()
            : featureStats_;
      }
    }

    /**
     *
     *
     * <pre>
     * Feature stats. e.g. histogram buckets.
     * In the format of tensorflow.metadata.v0.DatasetFeatureStatistics.
     * </pre>
     *
     * <code>.google.protobuf.Value feature_stats = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Value,
            com.google.protobuf.Value.Builder,
            com.google.protobuf.ValueOrBuilder>
        getFeatureStatsFieldBuilder() {
      if (featureStatsBuilder_ == null) {
        featureStatsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Value,
                com.google.protobuf.Value.Builder,
                com.google.protobuf.ValueOrBuilder>(
                getFeatureStats(), getParentForChildren(), isClean());
        featureStats_ = null;
      }
      return featureStatsBuilder_;
    }

    private double distributionDeviation_;

    /**
     *
     *
     * <pre>
     * Deviation from the current stats to baseline stats.
     *   1. For categorical feature, the distribution distance is calculated by
     *      L-inifinity norm.
     *   2. For numerical feature, the distribution distance is calculated by
     *      Jensen–Shannon divergence.
     * </pre>
     *
     * <code>double distribution_deviation = 3;</code>
     *
     * @return The distributionDeviation.
     */
    @java.lang.Override
    public double getDistributionDeviation() {
      return distributionDeviation_;
    }

    /**
     *
     *
     * <pre>
     * Deviation from the current stats to baseline stats.
     *   1. For categorical feature, the distribution distance is calculated by
     *      L-inifinity norm.
     *   2. For numerical feature, the distribution distance is calculated by
     *      Jensen–Shannon divergence.
     * </pre>
     *
     * <code>double distribution_deviation = 3;</code>
     *
     * @param value The distributionDeviation to set.
     * @return This builder for chaining.
     */
    public Builder setDistributionDeviation(double value) {

      distributionDeviation_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Deviation from the current stats to baseline stats.
     *   1. For categorical feature, the distribution distance is calculated by
     *      L-inifinity norm.
     *   2. For numerical feature, the distribution distance is calculated by
     *      Jensen–Shannon divergence.
     * </pre>
     *
     * <code>double distribution_deviation = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDistributionDeviation() {
      bitField0_ = (bitField0_ & ~0x00000004);
      distributionDeviation_ = 0D;
      onChanged();
      return this;
    }

    private double driftDetectionThreshold_;

    /**
     *
     *
     * <pre>
     * This is the threshold used when detecting drifts, which is set in
     * FeatureMonitor.FeatureSelectionConfig.FeatureConfig.drift_threshold
     * </pre>
     *
     * <code>double drift_detection_threshold = 4;</code>
     *
     * @return The driftDetectionThreshold.
     */
    @java.lang.Override
    public double getDriftDetectionThreshold() {
      return driftDetectionThreshold_;
    }

    /**
     *
     *
     * <pre>
     * This is the threshold used when detecting drifts, which is set in
     * FeatureMonitor.FeatureSelectionConfig.FeatureConfig.drift_threshold
     * </pre>
     *
     * <code>double drift_detection_threshold = 4;</code>
     *
     * @param value The driftDetectionThreshold to set.
     * @return This builder for chaining.
     */
    public Builder setDriftDetectionThreshold(double value) {

      driftDetectionThreshold_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * This is the threshold used when detecting drifts, which is set in
     * FeatureMonitor.FeatureSelectionConfig.FeatureConfig.drift_threshold
     * </pre>
     *
     * <code>double drift_detection_threshold = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDriftDetectionThreshold() {
      bitField0_ = (bitField0_ & ~0x00000008);
      driftDetectionThreshold_ = 0D;
      onChanged();
      return this;
    }

    private boolean driftDetected_;

    /**
     *
     *
     * <pre>
     * If set to true, indicates current stats is detected as and comparing
     * with baseline stats.
     * </pre>
     *
     * <code>bool drift_detected = 5;</code>
     *
     * @return The driftDetected.
     */
    @java.lang.Override
    public boolean getDriftDetected() {
      return driftDetected_;
    }

    /**
     *
     *
     * <pre>
     * If set to true, indicates current stats is detected as and comparing
     * with baseline stats.
     * </pre>
     *
     * <code>bool drift_detected = 5;</code>
     *
     * @param value The driftDetected to set.
     * @return This builder for chaining.
     */
    public Builder setDriftDetected(boolean value) {

      driftDetected_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * If set to true, indicates current stats is detected as and comparing
     * with baseline stats.
     * </pre>
     *
     * <code>bool drift_detected = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDriftDetected() {
      bitField0_ = (bitField0_ & ~0x00000010);
      driftDetected_ = false;
      onChanged();
      return this;
    }

    private com.google.protobuf.Timestamp statsTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        statsTimeBuilder_;

    /**
     *
     *
     * <pre>
     * The timestamp we take snapshot for feature values to generate stats.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_time = 6;</code>
     *
     * @return Whether the statsTime field is set.
     */
    public boolean hasStatsTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * The timestamp we take snapshot for feature values to generate stats.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_time = 6;</code>
     *
     * @return The statsTime.
     */
    public com.google.protobuf.Timestamp getStatsTime() {
      if (statsTimeBuilder_ == null) {
        return statsTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : statsTime_;
      } else {
        return statsTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The timestamp we take snapshot for feature values to generate stats.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_time = 6;</code>
     */
    public Builder setStatsTime(com.google.protobuf.Timestamp value) {
      if (statsTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        statsTime_ = value;
      } else {
        statsTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The timestamp we take snapshot for feature values to generate stats.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_time = 6;</code>
     */
    public Builder setStatsTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (statsTimeBuilder_ == null) {
        statsTime_ = builderForValue.build();
      } else {
        statsTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The timestamp we take snapshot for feature values to generate stats.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_time = 6;</code>
     */
    public Builder mergeStatsTime(com.google.protobuf.Timestamp value) {
      if (statsTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && statsTime_ != null
            && statsTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStatsTimeBuilder().mergeFrom(value);
        } else {
          statsTime_ = value;
        }
      } else {
        statsTimeBuilder_.mergeFrom(value);
      }
      if (statsTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The timestamp we take snapshot for feature values to generate stats.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_time = 6;</code>
     */
    public Builder clearStatsTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      statsTime_ = null;
      if (statsTimeBuilder_ != null) {
        statsTimeBuilder_.dispose();
        statsTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The timestamp we take snapshot for feature values to generate stats.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_time = 6;</code>
     */
    public com.google.protobuf.Timestamp.Builder getStatsTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getStatsTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The timestamp we take snapshot for feature values to generate stats.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_time = 6;</code>
     */
    public com.google.protobuf.TimestampOrBuilder getStatsTimeOrBuilder() {
      if (statsTimeBuilder_ != null) {
        return statsTimeBuilder_.getMessageOrBuilder();
      } else {
        return statsTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : statsTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * The timestamp we take snapshot for feature values to generate stats.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp stats_time = 6;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStatsTimeFieldBuilder() {
      if (statsTimeBuilder_ == null) {
        statsTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStatsTime(), getParentForChildren(), isClean());
        statsTime_ = null;
      }
      return statsTimeBuilder_;
    }

    private long featureMonitorJobId_;

    /**
     *
     *
     * <pre>
     * The ID of the FeatureMonitorJob that generated this FeatureStatsAndAnomaly.
     * </pre>
     *
     * <code>int64 feature_monitor_job_id = 7;</code>
     *
     * @return The featureMonitorJobId.
     */
    @java.lang.Override
    public long getFeatureMonitorJobId() {
      return featureMonitorJobId_;
    }

    /**
     *
     *
     * <pre>
     * The ID of the FeatureMonitorJob that generated this FeatureStatsAndAnomaly.
     * </pre>
     *
     * <code>int64 feature_monitor_job_id = 7;</code>
     *
     * @param value The featureMonitorJobId to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureMonitorJobId(long value) {

      featureMonitorJobId_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The ID of the FeatureMonitorJob that generated this FeatureStatsAndAnomaly.
     * </pre>
     *
     * <code>int64 feature_monitor_job_id = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFeatureMonitorJobId() {
      bitField0_ = (bitField0_ & ~0x00000040);
      featureMonitorJobId_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object featureMonitorId_ = "";

    /**
     *
     *
     * <pre>
     * The ID of the FeatureMonitor that this FeatureStatsAndAnomaly generated
     * according to.
     * </pre>
     *
     * <code>string feature_monitor_id = 8;</code>
     *
     * @return The featureMonitorId.
     */
    public java.lang.String getFeatureMonitorId() {
      java.lang.Object ref = featureMonitorId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        featureMonitorId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The ID of the FeatureMonitor that this FeatureStatsAndAnomaly generated
     * according to.
     * </pre>
     *
     * <code>string feature_monitor_id = 8;</code>
     *
     * @return The bytes for featureMonitorId.
     */
    public com.google.protobuf.ByteString getFeatureMonitorIdBytes() {
      java.lang.Object ref = featureMonitorId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        featureMonitorId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The ID of the FeatureMonitor that this FeatureStatsAndAnomaly generated
     * according to.
     * </pre>
     *
     * <code>string feature_monitor_id = 8;</code>
     *
     * @param value The featureMonitorId to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureMonitorId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      featureMonitorId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The ID of the FeatureMonitor that this FeatureStatsAndAnomaly generated
     * according to.
     * </pre>
     *
     * <code>string feature_monitor_id = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearFeatureMonitorId() {
      featureMonitorId_ = getDefaultInstance().getFeatureMonitorId();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The ID of the FeatureMonitor that this FeatureStatsAndAnomaly generated
     * according to.
     * </pre>
     *
     * <code>string feature_monitor_id = 8;</code>
     *
     * @param value The bytes for featureMonitorId to set.
     * @return This builder for chaining.
     */
    public Builder setFeatureMonitorIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      featureMonitorId_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly)
  private static final com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly();
  }

  public static com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<FeatureStatsAndAnomaly> PARSER =
      new com.google.protobuf.AbstractParser<FeatureStatsAndAnomaly>() {
        @java.lang.Override
        public FeatureStatsAndAnomaly parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<FeatureStatsAndAnomaly> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<FeatureStatsAndAnomaly> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.FeatureStatsAndAnomaly getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
