/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/session_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

public interface ListEventsRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ListEventsRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The resource name of the session to list events from.
   * Format:
   * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();

  /**
   *
   *
   * <pre>
   * Required. The resource name of the session to list events from.
   * Format:
   * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}/sessions/{session}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Optional. The maximum number of events to return. The service may return
   * fewer than this value. If unspecified, at most 100 events will be returned.
   * These events are ordered by timestamp in ascending order.
   * </pre>
   *
   * <code>int32 page_size = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageSize.
   */
  int getPageSize();

  /**
   *
   *
   * <pre>
   * Optional. The
   * [next_page_token][google.cloud.aiplatform.v1beta1.ListEventsResponse.next_page_token]
   * value returned from a previous list
   * [SessionService.ListEvents][google.cloud.aiplatform.v1beta1.SessionService.ListEvents]
   * call.
   * </pre>
   *
   * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The pageToken.
   */
  java.lang.String getPageToken();

  /**
   *
   *
   * <pre>
   * Optional. The
   * [next_page_token][google.cloud.aiplatform.v1beta1.ListEventsResponse.next_page_token]
   * value returned from a previous list
   * [SessionService.ListEvents][google.cloud.aiplatform.v1beta1.SessionService.ListEvents]
   * call.
   * </pre>
   *
   * <code>string page_token = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for pageToken.
   */
  com.google.protobuf.ByteString getPageTokenBytes();

  /**
   *
   *
   * <pre>
   * Optional. The standard list filter.
   * Supported fields:
   *    * `timestamp` range (i.e. `timestamp&gt;="2025-01-31T11:30:00-04:00"` where
   *    the timestamp is in RFC 3339 format)
   *
   * More detail in [AIP-160](https://google.aip.dev/160).
   * </pre>
   *
   * <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The filter.
   */
  java.lang.String getFilter();

  /**
   *
   *
   * <pre>
   * Optional. The standard list filter.
   * Supported fields:
   *    * `timestamp` range (i.e. `timestamp&gt;="2025-01-31T11:30:00-04:00"` where
   *    the timestamp is in RFC 3339 format)
   *
   * More detail in [AIP-160](https://google.aip.dev/160).
   * </pre>
   *
   * <code>string filter = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for filter.
   */
  com.google.protobuf.ByteString getFilterBytes();
}
