/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/model_monitor.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Vertex AI Model Monitoring Service serves as a central hub for the analysis
 * and visualization of data quality and performance related to models.
 * ModelMonitor stands as a top level resource for overseeing your model
 * monitoring tasks.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitor}
 */
public final class ModelMonitor extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitor)
    ModelMonitorOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ModelMonitor.newBuilder() to construct.
  private ModelMonitor(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ModelMonitor() {
    name_ = "";
    displayName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ModelMonitor();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitorProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitor_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.ModelMonitorProto
        .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitor_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.ModelMonitor.class,
            com.google.cloud.aiplatform.v1beta1.ModelMonitor.Builder.class);
  }

  public interface ModelMonitoringTargetOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Model in Vertex AI Model Registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource vertex_model = 1;
     * </code>
     *
     * @return Whether the vertexModel field is set.
     */
    boolean hasVertexModel();

    /**
     *
     *
     * <pre>
     * Model in Vertex AI Model Registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource vertex_model = 1;
     * </code>
     *
     * @return The vertexModel.
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource
        getVertexModel();

    /**
     *
     *
     * <pre>
     * Model in Vertex AI Model Registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource vertex_model = 1;
     * </code>
     */
    com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
            .VertexModelSourceOrBuilder
        getVertexModelOrBuilder();

    com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.SourceCase
        getSourceCase();
  }

  /**
   *
   *
   * <pre>
   * The monitoring target refers to the entity that is subject to analysis.
   * e.g. Vertex AI Model version.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget}
   */
  public static final class ModelMonitoringTarget extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget)
      ModelMonitoringTargetOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use ModelMonitoringTarget.newBuilder() to construct.
    private ModelMonitoringTarget(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private ModelMonitoringTarget() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new ModelMonitoringTarget();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitorProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitor_ModelMonitoringTarget_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitorProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitor_ModelMonitoringTarget_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.Builder.class);
    }

    public interface VertexModelSourceOrBuilder
        extends
        // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource)
        com.google.protobuf.MessageOrBuilder {

      /**
       *
       *
       * <pre>
       * Model resource name. Format:
       * projects/{project}/locations/{location}/models/{model}.
       * </pre>
       *
       * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The model.
       */
      java.lang.String getModel();

      /**
       *
       *
       * <pre>
       * Model resource name. Format:
       * projects/{project}/locations/{location}/models/{model}.
       * </pre>
       *
       * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for model.
       */
      com.google.protobuf.ByteString getModelBytes();

      /**
       *
       *
       * <pre>
       * Model version id.
       * </pre>
       *
       * <code>string model_version_id = 2;</code>
       *
       * @return The modelVersionId.
       */
      java.lang.String getModelVersionId();

      /**
       *
       *
       * <pre>
       * Model version id.
       * </pre>
       *
       * <code>string model_version_id = 2;</code>
       *
       * @return The bytes for modelVersionId.
       */
      com.google.protobuf.ByteString getModelVersionIdBytes();
    }

    /**
     *
     *
     * <pre>
     * Model in Vertex AI Model Registry.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource}
     */
    public static final class VertexModelSource extends com.google.protobuf.GeneratedMessageV3
        implements
        // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource)
        VertexModelSourceOrBuilder {
      private static final long serialVersionUID = 0L;

      // Use VertexModelSource.newBuilder() to construct.
      private VertexModelSource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
        super(builder);
      }

      private VertexModelSource() {
        model_ = "";
        modelVersionId_ = "";
      }

      @java.lang.Override
      @SuppressWarnings({"unused"})
      protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
        return new VertexModelSource();
      }

      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitorProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitor_ModelMonitoringTarget_VertexModelSource_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitorProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitor_ModelMonitoringTarget_VertexModelSource_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                    .VertexModelSource.class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                    .VertexModelSource.Builder.class);
      }

      public static final int MODEL_FIELD_NUMBER = 1;

      @SuppressWarnings("serial")
      private volatile java.lang.Object model_ = "";

      /**
       *
       *
       * <pre>
       * Model resource name. Format:
       * projects/{project}/locations/{location}/models/{model}.
       * </pre>
       *
       * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The model.
       */
      @java.lang.Override
      public java.lang.String getModel() {
        java.lang.Object ref = model_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          model_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Model resource name. Format:
       * projects/{project}/locations/{location}/models/{model}.
       * </pre>
       *
       * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
       *
       * @return The bytes for model.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getModelBytes() {
        java.lang.Object ref = model_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          model_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      public static final int MODEL_VERSION_ID_FIELD_NUMBER = 2;

      @SuppressWarnings("serial")
      private volatile java.lang.Object modelVersionId_ = "";

      /**
       *
       *
       * <pre>
       * Model version id.
       * </pre>
       *
       * <code>string model_version_id = 2;</code>
       *
       * @return The modelVersionId.
       */
      @java.lang.Override
      public java.lang.String getModelVersionId() {
        java.lang.Object ref = modelVersionId_;
        if (ref instanceof java.lang.String) {
          return (java.lang.String) ref;
        } else {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          modelVersionId_ = s;
          return s;
        }
      }

      /**
       *
       *
       * <pre>
       * Model version id.
       * </pre>
       *
       * <code>string model_version_id = 2;</code>
       *
       * @return The bytes for modelVersionId.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getModelVersionIdBytes() {
        java.lang.Object ref = modelVersionId_;
        if (ref instanceof java.lang.String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          modelVersionId_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      private byte memoizedIsInitialized = -1;

      @java.lang.Override
      public final boolean isInitialized() {
        byte isInitialized = memoizedIsInitialized;
        if (isInitialized == 1) return true;
        if (isInitialized == 0) return false;

        memoizedIsInitialized = 1;
        return true;
      }

      @java.lang.Override
      public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 1, model_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersionId_)) {
          com.google.protobuf.GeneratedMessageV3.writeString(output, 2, modelVersionId_);
        }
        getUnknownFields().writeTo(output);
      }

      @java.lang.Override
      public int getSerializedSize() {
        int size = memoizedSize;
        if (size != -1) return size;

        size = 0;
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(model_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, model_);
        }
        if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(modelVersionId_)) {
          size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, modelVersionId_);
        }
        size += getUnknownFields().getSerializedSize();
        memoizedSize = size;
        return size;
      }

      @java.lang.Override
      public boolean equals(final java.lang.Object obj) {
        if (obj == this) {
          return true;
        }
        if (!(obj
            instanceof
            com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                .VertexModelSource)) {
          return super.equals(obj);
        }
        com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource
            other =
                (com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                        .VertexModelSource)
                    obj;

        if (!getModel().equals(other.getModel())) return false;
        if (!getModelVersionId().equals(other.getModelVersionId())) return false;
        if (!getUnknownFields().equals(other.getUnknownFields())) return false;
        return true;
      }

      @java.lang.Override
      public int hashCode() {
        if (memoizedHashCode != 0) {
          return memoizedHashCode;
        }
        int hash = 41;
        hash = (19 * hash) + getDescriptor().hashCode();
        hash = (37 * hash) + MODEL_FIELD_NUMBER;
        hash = (53 * hash) + getModel().hashCode();
        hash = (37 * hash) + MODEL_VERSION_ID_FIELD_NUMBER;
        hash = (53 * hash) + getModelVersionId().hashCode();
        hash = (29 * hash) + getUnknownFields().hashCode();
        memoizedHashCode = hash;
        return hash;
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource
          parseFrom(java.nio.ByteBuffer data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource
          parseFrom(
              java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource
          parseFrom(com.google.protobuf.ByteString data)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource
          parseFrom(
              com.google.protobuf.ByteString data,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource
          parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource
          parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
        return PARSER.parseFrom(data, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource
          parseFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource
          parseFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource
          parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource
          parseDelimitedFrom(
              java.io.InputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
            PARSER, input, extensionRegistry);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource
          parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource
          parseFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws java.io.IOException {
        return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
            PARSER, input, extensionRegistry);
      }

      @java.lang.Override
      public Builder newBuilderForType() {
        return newBuilder();
      }

      public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
      }

      public static Builder newBuilder(
          com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource
              prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
      }

      @java.lang.Override
      public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
      }

      @java.lang.Override
      protected Builder newBuilderForType(
          com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
      }

      /**
       *
       *
       * <pre>
       * Model in Vertex AI Model Registry.
       * </pre>
       *
       * Protobuf type {@code
       * google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource}
       */
      public static final class Builder
          extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
          implements
          // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource)
          com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSourceOrBuilder {
        public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitorProto
              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitor_ModelMonitoringTarget_VertexModelSource_descriptor;
        }

        @java.lang.Override
        protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
            internalGetFieldAccessorTable() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitorProto
              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitor_ModelMonitoringTarget_VertexModelSource_fieldAccessorTable
              .ensureFieldAccessorsInitialized(
                  com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                      .VertexModelSource.class,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                      .VertexModelSource.Builder.class);
        }

        // Construct using
        // com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource.newBuilder()
        private Builder() {}

        private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
          super(parent);
        }

        @java.lang.Override
        public Builder clear() {
          super.clear();
          bitField0_ = 0;
          model_ = "";
          modelVersionId_ = "";
          return this;
        }

        @java.lang.Override
        public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitorProto
              .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitor_ModelMonitoringTarget_VertexModelSource_descriptor;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                .VertexModelSource
            getDefaultInstanceForType() {
          return com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource.getDefaultInstance();
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                .VertexModelSource
            build() {
          com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource
              result = buildPartial();
          if (!result.isInitialized()) {
            throw newUninitializedMessageException(result);
          }
          return result;
        }

        @java.lang.Override
        public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                .VertexModelSource
            buildPartial() {
          com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource
              result =
                  new com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                      .VertexModelSource(this);
          if (bitField0_ != 0) {
            buildPartial0(result);
          }
          onBuilt();
          return result;
        }

        private void buildPartial0(
            com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource
                result) {
          int from_bitField0_ = bitField0_;
          if (((from_bitField0_ & 0x00000001) != 0)) {
            result.model_ = model_;
          }
          if (((from_bitField0_ & 0x00000002) != 0)) {
            result.modelVersionId_ = modelVersionId_;
          }
        }

        @java.lang.Override
        public Builder clone() {
          return super.clone();
        }

        @java.lang.Override
        public Builder setField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.setField(field, value);
        }

        @java.lang.Override
        public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
          return super.clearField(field);
        }

        @java.lang.Override
        public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
          return super.clearOneof(oneof);
        }

        @java.lang.Override
        public Builder setRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field,
            int index,
            java.lang.Object value) {
          return super.setRepeatedField(field, index, value);
        }

        @java.lang.Override
        public Builder addRepeatedField(
            com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
          return super.addRepeatedField(field, value);
        }

        @java.lang.Override
        public Builder mergeFrom(com.google.protobuf.Message other) {
          if (other
              instanceof
              com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                  .VertexModelSource) {
            return mergeFrom(
                (com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                        .VertexModelSource)
                    other);
          } else {
            super.mergeFrom(other);
            return this;
          }
        }

        public Builder mergeFrom(
            com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource
                other) {
          if (other
              == com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                  .VertexModelSource.getDefaultInstance()) return this;
          if (!other.getModel().isEmpty()) {
            model_ = other.model_;
            bitField0_ |= 0x00000001;
            onChanged();
          }
          if (!other.getModelVersionId().isEmpty()) {
            modelVersionId_ = other.modelVersionId_;
            bitField0_ |= 0x00000002;
            onChanged();
          }
          this.mergeUnknownFields(other.getUnknownFields());
          onChanged();
          return this;
        }

        @java.lang.Override
        public final boolean isInitialized() {
          return true;
        }

        @java.lang.Override
        public Builder mergeFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
          if (extensionRegistry == null) {
            throw new java.lang.NullPointerException();
          }
          try {
            boolean done = false;
            while (!done) {
              int tag = input.readTag();
              switch (tag) {
                case 0:
                  done = true;
                  break;
                case 10:
                  {
                    model_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000001;
                    break;
                  } // case 10
                case 18:
                  {
                    modelVersionId_ = input.readStringRequireUtf8();
                    bitField0_ |= 0x00000002;
                    break;
                  } // case 18
                default:
                  {
                    if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                      done = true; // was an endgroup tag
                    }
                    break;
                  } // default:
              } // switch (tag)
            } // while (!done)
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.unwrapIOException();
          } finally {
            onChanged();
          } // finally
          return this;
        }

        private int bitField0_;

        private java.lang.Object model_ = "";

        /**
         *
         *
         * <pre>
         * Model resource name. Format:
         * projects/{project}/locations/{location}/models/{model}.
         * </pre>
         *
         * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The model.
         */
        public java.lang.String getModel() {
          java.lang.Object ref = model_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            model_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Model resource name. Format:
         * projects/{project}/locations/{location}/models/{model}.
         * </pre>
         *
         * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return The bytes for model.
         */
        public com.google.protobuf.ByteString getModelBytes() {
          java.lang.Object ref = model_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            model_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Model resource name. Format:
         * projects/{project}/locations/{location}/models/{model}.
         * </pre>
         *
         * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The model to set.
         * @return This builder for chaining.
         */
        public Builder setModel(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          model_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Model resource name. Format:
         * projects/{project}/locations/{location}/models/{model}.
         * </pre>
         *
         * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearModel() {
          model_ = getDefaultInstance().getModel();
          bitField0_ = (bitField0_ & ~0x00000001);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Model resource name. Format:
         * projects/{project}/locations/{location}/models/{model}.
         * </pre>
         *
         * <code>string model = 1 [(.google.api.resource_reference) = { ... }</code>
         *
         * @param value The bytes for model to set.
         * @return This builder for chaining.
         */
        public Builder setModelBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          model_ = value;
          bitField0_ |= 0x00000001;
          onChanged();
          return this;
        }

        private java.lang.Object modelVersionId_ = "";

        /**
         *
         *
         * <pre>
         * Model version id.
         * </pre>
         *
         * <code>string model_version_id = 2;</code>
         *
         * @return The modelVersionId.
         */
        public java.lang.String getModelVersionId() {
          java.lang.Object ref = modelVersionId_;
          if (!(ref instanceof java.lang.String)) {
            com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
            java.lang.String s = bs.toStringUtf8();
            modelVersionId_ = s;
            return s;
          } else {
            return (java.lang.String) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Model version id.
         * </pre>
         *
         * <code>string model_version_id = 2;</code>
         *
         * @return The bytes for modelVersionId.
         */
        public com.google.protobuf.ByteString getModelVersionIdBytes() {
          java.lang.Object ref = modelVersionId_;
          if (ref instanceof String) {
            com.google.protobuf.ByteString b =
                com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
            modelVersionId_ = b;
            return b;
          } else {
            return (com.google.protobuf.ByteString) ref;
          }
        }

        /**
         *
         *
         * <pre>
         * Model version id.
         * </pre>
         *
         * <code>string model_version_id = 2;</code>
         *
         * @param value The modelVersionId to set.
         * @return This builder for chaining.
         */
        public Builder setModelVersionId(java.lang.String value) {
          if (value == null) {
            throw new NullPointerException();
          }
          modelVersionId_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Model version id.
         * </pre>
         *
         * <code>string model_version_id = 2;</code>
         *
         * @return This builder for chaining.
         */
        public Builder clearModelVersionId() {
          modelVersionId_ = getDefaultInstance().getModelVersionId();
          bitField0_ = (bitField0_ & ~0x00000002);
          onChanged();
          return this;
        }

        /**
         *
         *
         * <pre>
         * Model version id.
         * </pre>
         *
         * <code>string model_version_id = 2;</code>
         *
         * @param value The bytes for modelVersionId to set.
         * @return This builder for chaining.
         */
        public Builder setModelVersionIdBytes(com.google.protobuf.ByteString value) {
          if (value == null) {
            throw new NullPointerException();
          }
          checkByteStringIsUtf8(value);
          modelVersionId_ = value;
          bitField0_ |= 0x00000002;
          onChanged();
          return this;
        }

        @java.lang.Override
        public final Builder setUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.setUnknownFields(unknownFields);
        }

        @java.lang.Override
        public final Builder mergeUnknownFields(
            final com.google.protobuf.UnknownFieldSet unknownFields) {
          return super.mergeUnknownFields(unknownFields);
        }

        // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource)
      }

      // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource)
      private static final com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource
          DEFAULT_INSTANCE;

      static {
        DEFAULT_INSTANCE =
            new com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                .VertexModelSource();
      }

      public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource
          getDefaultInstance() {
        return DEFAULT_INSTANCE;
      }

      private static final com.google.protobuf.Parser<VertexModelSource> PARSER =
          new com.google.protobuf.AbstractParser<VertexModelSource>() {
            @java.lang.Override
            public VertexModelSource parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

      public static com.google.protobuf.Parser<VertexModelSource> parser() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.protobuf.Parser<VertexModelSource> getParserForType() {
        return PARSER;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource
          getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
      }
    }

    private int sourceCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object source_;

    public enum SourceCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      VERTEX_MODEL(1),
      SOURCE_NOT_SET(0);
      private final int value;

      private SourceCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static SourceCase valueOf(int value) {
        return forNumber(value);
      }

      public static SourceCase forNumber(int value) {
        switch (value) {
          case 1:
            return VERTEX_MODEL;
          case 0:
            return SOURCE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public SourceCase getSourceCase() {
      return SourceCase.forNumber(sourceCase_);
    }

    public static final int VERTEX_MODEL_FIELD_NUMBER = 1;

    /**
     *
     *
     * <pre>
     * Model in Vertex AI Model Registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource vertex_model = 1;
     * </code>
     *
     * @return Whether the vertexModel field is set.
     */
    @java.lang.Override
    public boolean hasVertexModel() {
      return sourceCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Model in Vertex AI Model Registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource vertex_model = 1;
     * </code>
     *
     * @return The vertexModel.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource
        getVertexModel() {
      if (sourceCase_ == 1) {
        return (com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                .VertexModelSource)
            source_;
      }
      return com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
          .VertexModelSource.getDefaultInstance();
    }

    /**
     *
     *
     * <pre>
     * Model in Vertex AI Model Registry.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource vertex_model = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
            .VertexModelSourceOrBuilder
        getVertexModelOrBuilder() {
      if (sourceCase_ == 1) {
        return (com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                .VertexModelSource)
            source_;
      }
      return com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
          .VertexModelSource.getDefaultInstance();
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (sourceCase_ == 1) {
        output.writeMessage(
            1,
            (com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                    .VertexModelSource)
                source_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (sourceCase_ == 1) {
        size +=
            com.google.protobuf.CodedOutputStream.computeMessageSize(
                1,
                (com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                        .VertexModelSource)
                    source_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget other =
          (com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget) obj;

      if (!getSourceCase().equals(other.getSourceCase())) return false;
      switch (sourceCase_) {
        case 1:
          if (!getVertexModel().equals(other.getVertexModel())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      switch (sourceCase_) {
        case 1:
          hash = (37 * hash) + VERTEX_MODEL_FIELD_NUMBER;
          hash = (53 * hash) + getVertexModel().hashCode();
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The monitoring target refers to the entity that is subject to analysis.
     * e.g. Vertex AI Model version.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget)
        com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTargetOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitorProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitor_ModelMonitoringTarget_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitorProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitor_ModelMonitoringTarget_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.class,
                com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        if (vertexModelBuilder_ != null) {
          vertexModelBuilder_.clear();
        }
        sourceCase_ = 0;
        source_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitorProto
            .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitor_ModelMonitoringTarget_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget build() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget buildPartial() {
        com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget result =
            new com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget result) {
        int from_bitField0_ = bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget result) {
        result.sourceCase_ = sourceCase_;
        result.source_ = this.source_;
        if (sourceCase_ == 1 && vertexModelBuilder_ != null) {
          result.source_ = vertexModelBuilder_.build();
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                .getDefaultInstance()) return this;
        switch (other.getSourceCase()) {
          case VERTEX_MODEL:
            {
              mergeVertexModel(other.getVertexModel());
              break;
            }
          case SOURCE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getVertexModelFieldBuilder().getBuilder(), extensionRegistry);
                  sourceCase_ = 1;
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int sourceCase_ = 0;
      private java.lang.Object source_;

      public SourceCase getSourceCase() {
        return SourceCase.forNumber(sourceCase_);
      }

      public Builder clearSource() {
        sourceCase_ = 0;
        source_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                  .VertexModelSource,
              com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                  .VertexModelSource.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                  .VertexModelSourceOrBuilder>
          vertexModelBuilder_;

      /**
       *
       *
       * <pre>
       * Model in Vertex AI Model Registry.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource vertex_model = 1;
       * </code>
       *
       * @return Whether the vertexModel field is set.
       */
      @java.lang.Override
      public boolean hasVertexModel() {
        return sourceCase_ == 1;
      }

      /**
       *
       *
       * <pre>
       * Model in Vertex AI Model Registry.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource vertex_model = 1;
       * </code>
       *
       * @return The vertexModel.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource
          getVertexModel() {
        if (vertexModelBuilder_ == null) {
          if (sourceCase_ == 1) {
            return (com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                    .VertexModelSource)
                source_;
          }
          return com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource.getDefaultInstance();
        } else {
          if (sourceCase_ == 1) {
            return vertexModelBuilder_.getMessage();
          }
          return com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Model in Vertex AI Model Registry.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource vertex_model = 1;
       * </code>
       */
      public Builder setVertexModel(
          com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource
              value) {
        if (vertexModelBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          source_ = value;
          onChanged();
        } else {
          vertexModelBuilder_.setMessage(value);
        }
        sourceCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Model in Vertex AI Model Registry.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource vertex_model = 1;
       * </code>
       */
      public Builder setVertexModel(
          com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource
                  .Builder
              builderForValue) {
        if (vertexModelBuilder_ == null) {
          source_ = builderForValue.build();
          onChanged();
        } else {
          vertexModelBuilder_.setMessage(builderForValue.build());
        }
        sourceCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Model in Vertex AI Model Registry.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource vertex_model = 1;
       * </code>
       */
      public Builder mergeVertexModel(
          com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource
              value) {
        if (vertexModelBuilder_ == null) {
          if (sourceCase_ == 1
              && source_
                  != com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                      .VertexModelSource.getDefaultInstance()) {
            source_ =
                com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                    .VertexModelSource.newBuilder(
                        (com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                                .VertexModelSource)
                            source_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            source_ = value;
          }
          onChanged();
        } else {
          if (sourceCase_ == 1) {
            vertexModelBuilder_.mergeFrom(value);
          } else {
            vertexModelBuilder_.setMessage(value);
          }
        }
        sourceCase_ = 1;
        return this;
      }

      /**
       *
       *
       * <pre>
       * Model in Vertex AI Model Registry.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource vertex_model = 1;
       * </code>
       */
      public Builder clearVertexModel() {
        if (vertexModelBuilder_ == null) {
          if (sourceCase_ == 1) {
            sourceCase_ = 0;
            source_ = null;
            onChanged();
          }
        } else {
          if (sourceCase_ == 1) {
            sourceCase_ = 0;
            source_ = null;
          }
          vertexModelBuilder_.clear();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Model in Vertex AI Model Registry.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource vertex_model = 1;
       * </code>
       */
      public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource.Builder
          getVertexModelBuilder() {
        return getVertexModelFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * Model in Vertex AI Model Registry.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource vertex_model = 1;
       * </code>
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSourceOrBuilder
          getVertexModelOrBuilder() {
        if ((sourceCase_ == 1) && (vertexModelBuilder_ != null)) {
          return vertexModelBuilder_.getMessageOrBuilder();
        } else {
          if (sourceCase_ == 1) {
            return (com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                    .VertexModelSource)
                source_;
          }
          return com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
              .VertexModelSource.getDefaultInstance();
        }
      }

      /**
       *
       *
       * <pre>
       * Model in Vertex AI Model Registry.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.VertexModelSource vertex_model = 1;
       * </code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                  .VertexModelSource,
              com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                  .VertexModelSource.Builder,
              com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                  .VertexModelSourceOrBuilder>
          getVertexModelFieldBuilder() {
        if (vertexModelBuilder_ == null) {
          if (!(sourceCase_ == 1)) {
            source_ =
                com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                    .VertexModelSource.getDefaultInstance();
          }
          vertexModelBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                      .VertexModelSource,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                      .VertexModelSource.Builder,
                  com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                      .VertexModelSourceOrBuilder>(
                  (com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                          .VertexModelSource)
                      source_,
                  getParentForChildren(),
                  isClean());
          source_ = null;
        }
        sourceCase_ = 1;
        onChanged();
        return vertexModelBuilder_;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget)
    private static final com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget();
    }

    public static com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<ModelMonitoringTarget> PARSER =
        new com.google.protobuf.AbstractParser<ModelMonitoringTarget>() {
          @java.lang.Override
          public ModelMonitoringTarget parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<ModelMonitoringTarget> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<ModelMonitoringTarget> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int defaultObjectiveCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object defaultObjective_;

  public enum DefaultObjectiveCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TABULAR_OBJECTIVE(11),
    DEFAULTOBJECTIVE_NOT_SET(0);
    private final int value;

    private DefaultObjectiveCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static DefaultObjectiveCase valueOf(int value) {
      return forNumber(value);
    }

    public static DefaultObjectiveCase forNumber(int value) {
      switch (value) {
        case 11:
          return TABULAR_OBJECTIVE;
        case 0:
          return DEFAULTOBJECTIVE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public DefaultObjectiveCase getDefaultObjectiveCase() {
    return DefaultObjectiveCase.forNumber(defaultObjectiveCase_);
  }

  public static final int TABULAR_OBJECTIVE_FIELD_NUMBER = 11;

  /**
   *
   *
   * <pre>
   * Optional default tabular model monitoring objective.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 11;
   * </code>
   *
   * @return Whether the tabularObjective field is set.
   */
  @java.lang.Override
  public boolean hasTabularObjective() {
    return defaultObjectiveCase_ == 11;
  }

  /**
   *
   *
   * <pre>
   * Optional default tabular model monitoring objective.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 11;
   * </code>
   *
   * @return The tabularObjective.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
      getTabularObjective() {
    if (defaultObjectiveCase_ == 11) {
      return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
          defaultObjective_;
    }
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional default tabular model monitoring objective.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 11;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjectiveOrBuilder
      getTabularObjectiveOrBuilder() {
    if (defaultObjectiveCase_ == 11) {
      return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
          defaultObjective_;
    }
    return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        .getDefaultInstance();
  }

  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. Resource name of the ModelMonitor. Format:
   * `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. Resource name of the ModelMonitor. Format:
   * `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * The display name of the ModelMonitor.
   * The name can be up to 128 characters long and can consist of any UTF-8.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The display name of the ModelMonitor.
   * The name can be up to 128 characters long and can consist of any UTF-8.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MODEL_MONITORING_TARGET_FIELD_NUMBER = 3;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
      modelMonitoringTarget_;

  /**
   *
   *
   * <pre>
   * The entity that is subject to analysis.
   * Currently only models in Vertex AI Model Registry are supported. If you
   * want to analyze the model which is outside the Vertex AI, you could
   * register a model in Vertex AI Model Registry using just a display name.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget model_monitoring_target = 3;
   * </code>
   *
   * @return Whether the modelMonitoringTarget field is set.
   */
  @java.lang.Override
  public boolean hasModelMonitoringTarget() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * The entity that is subject to analysis.
   * Currently only models in Vertex AI Model Registry are supported. If you
   * want to analyze the model which is outside the Vertex AI, you could
   * register a model in Vertex AI Model Registry using just a display name.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget model_monitoring_target = 3;
   * </code>
   *
   * @return The modelMonitoringTarget.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
      getModelMonitoringTarget() {
    return modelMonitoringTarget_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
            .getDefaultInstance()
        : modelMonitoringTarget_;
  }

  /**
   *
   *
   * <pre>
   * The entity that is subject to analysis.
   * Currently only models in Vertex AI Model Registry are supported. If you
   * want to analyze the model which is outside the Vertex AI, you could
   * register a model in Vertex AI Model Registry using just a display name.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget model_monitoring_target = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTargetOrBuilder
      getModelMonitoringTargetOrBuilder() {
    return modelMonitoringTarget_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
            .getDefaultInstance()
        : modelMonitoringTarget_;
  }

  public static final int TRAINING_DATASET_FIELD_NUMBER = 10;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput trainingDataset_;

  /**
   *
   *
   * <pre>
   * Optional training dataset used to train the model.
   * It can serve as a reference dataset to identify changes in production.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput training_dataset = 10;</code>
   *
   * @return Whether the trainingDataset field is set.
   */
  @java.lang.Override
  public boolean hasTrainingDataset() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional training dataset used to train the model.
   * It can serve as a reference dataset to identify changes in production.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput training_dataset = 10;</code>
   *
   * @return The trainingDataset.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput getTrainingDataset() {
    return trainingDataset_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance()
        : trainingDataset_;
  }

  /**
   *
   *
   * <pre>
   * Optional training dataset used to train the model.
   * It can serve as a reference dataset to identify changes in production.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput training_dataset = 10;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInputOrBuilder
      getTrainingDatasetOrBuilder() {
    return trainingDataset_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance()
        : trainingDataset_;
  }

  public static final int NOTIFICATION_SPEC_FIELD_NUMBER = 12;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec notificationSpec_;

  /**
   *
   *
   * <pre>
   * Optional default notification spec, it can be overridden in the
   * ModelMonitoringJob notification spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec notification_spec = 12;
   * </code>
   *
   * @return Whether the notificationSpec field is set.
   */
  @java.lang.Override
  public boolean hasNotificationSpec() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional default notification spec, it can be overridden in the
   * ModelMonitoringJob notification spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec notification_spec = 12;
   * </code>
   *
   * @return The notificationSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec getNotificationSpec() {
    return notificationSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec.getDefaultInstance()
        : notificationSpec_;
  }

  /**
   *
   *
   * <pre>
   * Optional default notification spec, it can be overridden in the
   * ModelMonitoringJob notification spec.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec notification_spec = 12;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpecOrBuilder
      getNotificationSpecOrBuilder() {
    return notificationSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec.getDefaultInstance()
        : notificationSpec_;
  }

  public static final int OUTPUT_SPEC_FIELD_NUMBER = 13;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec outputSpec_;

  /**
   *
   *
   * <pre>
   * Optional default monitoring metrics/logs export spec, it can be overridden
   * in the ModelMonitoringJob output spec.
   * If not specified, a default Google Cloud Storage bucket will be created
   * under your project.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec output_spec = 13;</code>
   *
   * @return Whether the outputSpec field is set.
   */
  @java.lang.Override
  public boolean hasOutputSpec() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional default monitoring metrics/logs export spec, it can be overridden
   * in the ModelMonitoringJob output spec.
   * If not specified, a default Google Cloud Storage bucket will be created
   * under your project.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec output_spec = 13;</code>
   *
   * @return The outputSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec getOutputSpec() {
    return outputSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec.getDefaultInstance()
        : outputSpec_;
  }

  /**
   *
   *
   * <pre>
   * Optional default monitoring metrics/logs export spec, it can be overridden
   * in the ModelMonitoringJob output spec.
   * If not specified, a default Google Cloud Storage bucket will be created
   * under your project.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec output_spec = 13;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpecOrBuilder
      getOutputSpecOrBuilder() {
    return outputSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec.getDefaultInstance()
        : outputSpec_;
  }

  public static final int EXPLANATION_SPEC_FIELD_NUMBER = 16;
  private com.google.cloud.aiplatform.v1beta1.ExplanationSpec explanationSpec_;

  /**
   *
   *
   * <pre>
   * Optional model explanation spec. It is used for feature attribution
   * monitoring.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 16;</code>
   *
   * @return Whether the explanationSpec field is set.
   */
  @java.lang.Override
  public boolean hasExplanationSpec() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional model explanation spec. It is used for feature attribution
   * monitoring.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 16;</code>
   *
   * @return The explanationSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExplanationSpec getExplanationSpec() {
    return explanationSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
        : explanationSpec_;
  }

  /**
   *
   *
   * <pre>
   * Optional model explanation spec. It is used for feature attribution
   * monitoring.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 16;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder
      getExplanationSpecOrBuilder() {
    return explanationSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
        : explanationSpec_;
  }

  public static final int MODEL_MONITORING_SCHEMA_FIELD_NUMBER = 9;
  private com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema modelMonitoringSchema_;

  /**
   *
   *
   * <pre>
   * Monitoring Schema is to specify the model's features, prediction outputs
   * and ground truth properties. It is used to extract pertinent data from the
   * dataset and to process features based on their properties.
   * Make sure that the schema aligns with your dataset, if it does not, we will
   * be unable to extract data from the dataset.
   * It is required for most models, but optional for Vertex AI AutoML Tables
   * unless the schem information is not available.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema model_monitoring_schema = 9;
   * </code>
   *
   * @return Whether the modelMonitoringSchema field is set.
   */
  @java.lang.Override
  public boolean hasModelMonitoringSchema() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Monitoring Schema is to specify the model's features, prediction outputs
   * and ground truth properties. It is used to extract pertinent data from the
   * dataset and to process features based on their properties.
   * Make sure that the schema aligns with your dataset, if it does not, we will
   * be unable to extract data from the dataset.
   * It is required for most models, but optional for Vertex AI AutoML Tables
   * unless the schem information is not available.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema model_monitoring_schema = 9;
   * </code>
   *
   * @return The modelMonitoringSchema.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema getModelMonitoringSchema() {
    return modelMonitoringSchema_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.getDefaultInstance()
        : modelMonitoringSchema_;
  }

  /**
   *
   *
   * <pre>
   * Monitoring Schema is to specify the model's features, prediction outputs
   * and ground truth properties. It is used to extract pertinent data from the
   * dataset and to process features based on their properties.
   * Make sure that the schema aligns with your dataset, if it does not, we will
   * be unable to extract data from the dataset.
   * It is required for most models, but optional for Vertex AI AutoML Tables
   * unless the schem information is not available.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema model_monitoring_schema = 9;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchemaOrBuilder
      getModelMonitoringSchemaOrBuilder() {
    return modelMonitoringSchema_ == null
        ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.getDefaultInstance()
        : modelMonitoringSchema_;
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 5;
  private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;

  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a ModelMonitor. If
   * set, this ModelMonitor and all sub-resources of this
   * ModelMonitor will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 5;</code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a ModelMonitor. If
   * set, this ModelMonitor and all sub-resources of this
   * ModelMonitor will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 5;</code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  /**
   *
   *
   * <pre>
   * Customer-managed encryption key spec for a ModelMonitor. If
   * set, this ModelMonitor and all sub-resources of this
   * ModelMonitor will be secured by this key.
   * </pre>
   *
   * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 5;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 6;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelMonitor was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelMonitor was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelMonitor was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelMonitor was updated most recently.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelMonitor was updated most recently.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Timestamp when this ModelMonitor was updated most recently.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 17;
  private boolean satisfiesPzs_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 18;
  private boolean satisfiesPzi_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzi = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(3, getModelMonitoringTarget());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(5, getEncryptionSpec());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(7, getUpdateTime());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(9, getModelMonitoringSchema());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(10, getTrainingDataset());
    }
    if (defaultObjectiveCase_ == 11) {
      output.writeMessage(
          11,
          (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
              defaultObjective_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(12, getNotificationSpec());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(13, getOutputSpec());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(16, getExplanationSpec());
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(17, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      output.writeBool(18, satisfiesPzi_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, getModelMonitoringTarget());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(5, getEncryptionSpec());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getCreateTime());
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getUpdateTime());
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(9, getModelMonitoringSchema());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getTrainingDataset());
    }
    if (defaultObjectiveCase_ == 11) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              11,
              (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
                  defaultObjective_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getNotificationSpec());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(13, getOutputSpec());
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(16, getExplanationSpec());
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(17, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(18, satisfiesPzi_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitor)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.ModelMonitor other =
        (com.google.cloud.aiplatform.v1beta1.ModelMonitor) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (hasModelMonitoringTarget() != other.hasModelMonitoringTarget()) return false;
    if (hasModelMonitoringTarget()) {
      if (!getModelMonitoringTarget().equals(other.getModelMonitoringTarget())) return false;
    }
    if (hasTrainingDataset() != other.hasTrainingDataset()) return false;
    if (hasTrainingDataset()) {
      if (!getTrainingDataset().equals(other.getTrainingDataset())) return false;
    }
    if (hasNotificationSpec() != other.hasNotificationSpec()) return false;
    if (hasNotificationSpec()) {
      if (!getNotificationSpec().equals(other.getNotificationSpec())) return false;
    }
    if (hasOutputSpec() != other.hasOutputSpec()) return false;
    if (hasOutputSpec()) {
      if (!getOutputSpec().equals(other.getOutputSpec())) return false;
    }
    if (hasExplanationSpec() != other.hasExplanationSpec()) return false;
    if (hasExplanationSpec()) {
      if (!getExplanationSpec().equals(other.getExplanationSpec())) return false;
    }
    if (hasModelMonitoringSchema() != other.hasModelMonitoringSchema()) return false;
    if (hasModelMonitoringSchema()) {
      if (!getModelMonitoringSchema().equals(other.getModelMonitoringSchema())) return false;
    }
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    if (!getDefaultObjectiveCase().equals(other.getDefaultObjectiveCase())) return false;
    switch (defaultObjectiveCase_) {
      case 11:
        if (!getTabularObjective().equals(other.getTabularObjective())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (hasModelMonitoringTarget()) {
      hash = (37 * hash) + MODEL_MONITORING_TARGET_FIELD_NUMBER;
      hash = (53 * hash) + getModelMonitoringTarget().hashCode();
    }
    if (hasTrainingDataset()) {
      hash = (37 * hash) + TRAINING_DATASET_FIELD_NUMBER;
      hash = (53 * hash) + getTrainingDataset().hashCode();
    }
    if (hasNotificationSpec()) {
      hash = (37 * hash) + NOTIFICATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getNotificationSpec().hashCode();
    }
    if (hasOutputSpec()) {
      hash = (37 * hash) + OUTPUT_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getOutputSpec().hashCode();
    }
    if (hasExplanationSpec()) {
      hash = (37 * hash) + EXPLANATION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getExplanationSpec().hashCode();
    }
    if (hasModelMonitoringSchema()) {
      hash = (37 * hash) + MODEL_MONITORING_SCHEMA_FIELD_NUMBER;
      hash = (53 * hash) + getModelMonitoringSchema().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    switch (defaultObjectiveCase_) {
      case 11:
        hash = (37 * hash) + TABULAR_OBJECTIVE_FIELD_NUMBER;
        hash = (53 * hash) + getTabularObjective().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitor parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitor parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitor parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitor parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitor parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitor parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitor parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitor parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitor parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitor parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitor parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitor parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1beta1.ModelMonitor prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Vertex AI Model Monitoring Service serves as a central hub for the analysis
   * and visualization of data quality and performance related to models.
   * ModelMonitor stands as a top level resource for overseeing your model
   * monitoring tasks.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.ModelMonitor}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.ModelMonitor)
      com.google.cloud.aiplatform.v1beta1.ModelMonitorOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitorProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitor_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitorProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitor_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.ModelMonitor.class,
              com.google.cloud.aiplatform.v1beta1.ModelMonitor.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.ModelMonitor.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getModelMonitoringTargetFieldBuilder();
        getTrainingDatasetFieldBuilder();
        getNotificationSpecFieldBuilder();
        getOutputSpecFieldBuilder();
        getExplanationSpecFieldBuilder();
        getModelMonitoringSchemaFieldBuilder();
        getEncryptionSpecFieldBuilder();
        getCreateTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (tabularObjectiveBuilder_ != null) {
        tabularObjectiveBuilder_.clear();
      }
      name_ = "";
      displayName_ = "";
      modelMonitoringTarget_ = null;
      if (modelMonitoringTargetBuilder_ != null) {
        modelMonitoringTargetBuilder_.dispose();
        modelMonitoringTargetBuilder_ = null;
      }
      trainingDataset_ = null;
      if (trainingDatasetBuilder_ != null) {
        trainingDatasetBuilder_.dispose();
        trainingDatasetBuilder_ = null;
      }
      notificationSpec_ = null;
      if (notificationSpecBuilder_ != null) {
        notificationSpecBuilder_.dispose();
        notificationSpecBuilder_ = null;
      }
      outputSpec_ = null;
      if (outputSpecBuilder_ != null) {
        outputSpecBuilder_.dispose();
        outputSpecBuilder_ = null;
      }
      explanationSpec_ = null;
      if (explanationSpecBuilder_ != null) {
        explanationSpecBuilder_.dispose();
        explanationSpecBuilder_ = null;
      }
      modelMonitoringSchema_ = null;
      if (modelMonitoringSchemaBuilder_ != null) {
        modelMonitoringSchemaBuilder_.dispose();
        modelMonitoringSchemaBuilder_ = null;
      }
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      satisfiesPzs_ = false;
      satisfiesPzi_ = false;
      defaultObjectiveCase_ = 0;
      defaultObjective_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitorProto
          .internal_static_google_cloud_aiplatform_v1beta1_ModelMonitor_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitor getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.ModelMonitor.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitor build() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitor result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitor buildPartial() {
      com.google.cloud.aiplatform.v1beta1.ModelMonitor result =
          new com.google.cloud.aiplatform.v1beta1.ModelMonitor(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.ModelMonitor result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.displayName_ = displayName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.modelMonitoringTarget_ =
            modelMonitoringTargetBuilder_ == null
                ? modelMonitoringTarget_
                : modelMonitoringTargetBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.trainingDataset_ =
            trainingDatasetBuilder_ == null ? trainingDataset_ : trainingDatasetBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.notificationSpec_ =
            notificationSpecBuilder_ == null ? notificationSpec_ : notificationSpecBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.outputSpec_ = outputSpecBuilder_ == null ? outputSpec_ : outputSpecBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.explanationSpec_ =
            explanationSpecBuilder_ == null ? explanationSpec_ : explanationSpecBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.modelMonitoringSchema_ =
            modelMonitoringSchemaBuilder_ == null
                ? modelMonitoringSchema_
                : modelMonitoringSchemaBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(com.google.cloud.aiplatform.v1beta1.ModelMonitor result) {
      result.defaultObjectiveCase_ = defaultObjectiveCase_;
      result.defaultObjective_ = this.defaultObjective_;
      if (defaultObjectiveCase_ == 11 && tabularObjectiveBuilder_ != null) {
        result.defaultObjective_ = tabularObjectiveBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.ModelMonitor) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.ModelMonitor) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.ModelMonitor other) {
      if (other == com.google.cloud.aiplatform.v1beta1.ModelMonitor.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasModelMonitoringTarget()) {
        mergeModelMonitoringTarget(other.getModelMonitoringTarget());
      }
      if (other.hasTrainingDataset()) {
        mergeTrainingDataset(other.getTrainingDataset());
      }
      if (other.hasNotificationSpec()) {
        mergeNotificationSpec(other.getNotificationSpec());
      }
      if (other.hasOutputSpec()) {
        mergeOutputSpec(other.getOutputSpec());
      }
      if (other.hasExplanationSpec()) {
        mergeExplanationSpec(other.getExplanationSpec());
      }
      if (other.hasModelMonitoringSchema()) {
        mergeModelMonitoringSchema(other.getModelMonitoringSchema());
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.getSatisfiesPzi() != false) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      switch (other.getDefaultObjectiveCase()) {
        case TABULAR_OBJECTIVE:
          {
            mergeTabularObjective(other.getTabularObjective());
            break;
          }
        case DEFAULTOBJECTIVE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getModelMonitoringTargetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000008;
                break;
              } // case 26
            case 42:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 42
            case 50:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 58
            case 74:
              {
                input.readMessage(
                    getModelMonitoringSchemaFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getTrainingDatasetFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    getTabularObjectiveFieldBuilder().getBuilder(), extensionRegistry);
                defaultObjectiveCase_ = 11;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(
                    getNotificationSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(getOutputSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 106
            case 130:
              {
                input.readMessage(getExplanationSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 130
            case 136:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x00001000;
                break;
              } // case 136
            case 144:
              {
                satisfiesPzi_ = input.readBool();
                bitField0_ |= 0x00002000;
                break;
              } // case 144
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int defaultObjectiveCase_ = 0;
    private java.lang.Object defaultObjective_;

    public DefaultObjectiveCase getDefaultObjectiveCase() {
      return DefaultObjectiveCase.forNumber(defaultObjectiveCase_);
    }

    public Builder clearDefaultObjective() {
      defaultObjectiveCase_ = 0;
      defaultObjective_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                .Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                .TabularObjectiveOrBuilder>
        tabularObjectiveBuilder_;

    /**
     *
     *
     * <pre>
     * Optional default tabular model monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 11;
     * </code>
     *
     * @return Whether the tabularObjective field is set.
     */
    @java.lang.Override
    public boolean hasTabularObjective() {
      return defaultObjectiveCase_ == 11;
    }

    /**
     *
     *
     * <pre>
     * Optional default tabular model monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 11;
     * </code>
     *
     * @return The tabularObjective.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
        getTabularObjective() {
      if (tabularObjectiveBuilder_ == null) {
        if (defaultObjectiveCase_ == 11) {
          return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
              defaultObjective_;
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
            .getDefaultInstance();
      } else {
        if (defaultObjectiveCase_ == 11) {
          return tabularObjectiveBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional default tabular model monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 11;
     * </code>
     */
    public Builder setTabularObjective(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective value) {
      if (tabularObjectiveBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        defaultObjective_ = value;
        onChanged();
      } else {
        tabularObjectiveBuilder_.setMessage(value);
      }
      defaultObjectiveCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional default tabular model monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 11;
     * </code>
     */
    public Builder setTabularObjective(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective.Builder
            builderForValue) {
      if (tabularObjectiveBuilder_ == null) {
        defaultObjective_ = builderForValue.build();
        onChanged();
      } else {
        tabularObjectiveBuilder_.setMessage(builderForValue.build());
      }
      defaultObjectiveCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional default tabular model monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 11;
     * </code>
     */
    public Builder mergeTabularObjective(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective value) {
      if (tabularObjectiveBuilder_ == null) {
        if (defaultObjectiveCase_ == 11
            && defaultObjective_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                    .getDefaultInstance()) {
          defaultObjective_ =
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                              .TabularObjective)
                          defaultObjective_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          defaultObjective_ = value;
        }
        onChanged();
      } else {
        if (defaultObjectiveCase_ == 11) {
          tabularObjectiveBuilder_.mergeFrom(value);
        } else {
          tabularObjectiveBuilder_.setMessage(value);
        }
      }
      defaultObjectiveCase_ = 11;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional default tabular model monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 11;
     * </code>
     */
    public Builder clearTabularObjective() {
      if (tabularObjectiveBuilder_ == null) {
        if (defaultObjectiveCase_ == 11) {
          defaultObjectiveCase_ = 0;
          defaultObjective_ = null;
          onChanged();
        }
      } else {
        if (defaultObjectiveCase_ == 11) {
          defaultObjectiveCase_ = 0;
          defaultObjective_ = null;
        }
        tabularObjectiveBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional default tabular model monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 11;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective.Builder
        getTabularObjectiveBuilder() {
      return getTabularObjectiveFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional default tabular model monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 11;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
            .TabularObjectiveOrBuilder
        getTabularObjectiveOrBuilder() {
      if ((defaultObjectiveCase_ == 11) && (tabularObjectiveBuilder_ != null)) {
        return tabularObjectiveBuilder_.getMessageOrBuilder();
      } else {
        if (defaultObjectiveCase_ == 11) {
          return (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
              defaultObjective_;
        }
        return com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional default tabular model monitoring objective.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective tabular_objective = 11;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                .Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                .TabularObjectiveOrBuilder>
        getTabularObjectiveFieldBuilder() {
      if (tabularObjectiveBuilder_ == null) {
        if (!(defaultObjectiveCase_ == 11)) {
          defaultObjective_ =
              com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                  .getDefaultInstance();
        }
        tabularObjectiveBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec
                    .TabularObjectiveOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.ModelMonitoringObjectiveSpec.TabularObjective)
                    defaultObjective_,
                getParentForChildren(),
                isClean());
        defaultObjective_ = null;
      }
      defaultObjectiveCase_ = 11;
      onChanged();
      return tabularObjectiveBuilder_;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. Resource name of the ModelMonitor. Format:
     * `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Resource name of the ModelMonitor. Format:
     * `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Resource name of the ModelMonitor. Format:
     * `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Resource name of the ModelMonitor. Format:
     * `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Resource name of the ModelMonitor. Format:
     * `projects/{project}/locations/{location}/modelMonitors/{model_monitor}`.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * The display name of the ModelMonitor.
     * The name can be up to 128 characters long and can consist of any UTF-8.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The display name of the ModelMonitor.
     * The name can be up to 128 characters long and can consist of any UTF-8.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The display name of the ModelMonitor.
     * The name can be up to 128 characters long and can consist of any UTF-8.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The display name of the ModelMonitor.
     * The name can be up to 128 characters long and can consist of any UTF-8.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The display name of the ModelMonitor.
     * The name can be up to 128 characters long and can consist of any UTF-8.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
        modelMonitoringTarget_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget,
            com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTargetOrBuilder>
        modelMonitoringTargetBuilder_;

    /**
     *
     *
     * <pre>
     * The entity that is subject to analysis.
     * Currently only models in Vertex AI Model Registry are supported. If you
     * want to analyze the model which is outside the Vertex AI, you could
     * register a model in Vertex AI Model Registry using just a display name.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget model_monitoring_target = 3;
     * </code>
     *
     * @return Whether the modelMonitoringTarget field is set.
     */
    public boolean hasModelMonitoringTarget() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * The entity that is subject to analysis.
     * Currently only models in Vertex AI Model Registry are supported. If you
     * want to analyze the model which is outside the Vertex AI, you could
     * register a model in Vertex AI Model Registry using just a display name.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget model_monitoring_target = 3;
     * </code>
     *
     * @return The modelMonitoringTarget.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
        getModelMonitoringTarget() {
      if (modelMonitoringTargetBuilder_ == null) {
        return modelMonitoringTarget_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                .getDefaultInstance()
            : modelMonitoringTarget_;
      } else {
        return modelMonitoringTargetBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * The entity that is subject to analysis.
     * Currently only models in Vertex AI Model Registry are supported. If you
     * want to analyze the model which is outside the Vertex AI, you could
     * register a model in Vertex AI Model Registry using just a display name.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget model_monitoring_target = 3;
     * </code>
     */
    public Builder setModelMonitoringTarget(
        com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget value) {
      if (modelMonitoringTargetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMonitoringTarget_ = value;
      } else {
        modelMonitoringTargetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The entity that is subject to analysis.
     * Currently only models in Vertex AI Model Registry are supported. If you
     * want to analyze the model which is outside the Vertex AI, you could
     * register a model in Vertex AI Model Registry using just a display name.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget model_monitoring_target = 3;
     * </code>
     */
    public Builder setModelMonitoringTarget(
        com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.Builder
            builderForValue) {
      if (modelMonitoringTargetBuilder_ == null) {
        modelMonitoringTarget_ = builderForValue.build();
      } else {
        modelMonitoringTargetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The entity that is subject to analysis.
     * Currently only models in Vertex AI Model Registry are supported. If you
     * want to analyze the model which is outside the Vertex AI, you could
     * register a model in Vertex AI Model Registry using just a display name.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget model_monitoring_target = 3;
     * </code>
     */
    public Builder mergeModelMonitoringTarget(
        com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget value) {
      if (modelMonitoringTargetBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)
            && modelMonitoringTarget_ != null
            && modelMonitoringTarget_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                    .getDefaultInstance()) {
          getModelMonitoringTargetBuilder().mergeFrom(value);
        } else {
          modelMonitoringTarget_ = value;
        }
      } else {
        modelMonitoringTargetBuilder_.mergeFrom(value);
      }
      if (modelMonitoringTarget_ != null) {
        bitField0_ |= 0x00000008;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The entity that is subject to analysis.
     * Currently only models in Vertex AI Model Registry are supported. If you
     * want to analyze the model which is outside the Vertex AI, you could
     * register a model in Vertex AI Model Registry using just a display name.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget model_monitoring_target = 3;
     * </code>
     */
    public Builder clearModelMonitoringTarget() {
      bitField0_ = (bitField0_ & ~0x00000008);
      modelMonitoringTarget_ = null;
      if (modelMonitoringTargetBuilder_ != null) {
        modelMonitoringTargetBuilder_.dispose();
        modelMonitoringTargetBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The entity that is subject to analysis.
     * Currently only models in Vertex AI Model Registry are supported. If you
     * want to analyze the model which is outside the Vertex AI, you could
     * register a model in Vertex AI Model Registry using just a display name.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget model_monitoring_target = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.Builder
        getModelMonitoringTargetBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getModelMonitoringTargetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * The entity that is subject to analysis.
     * Currently only models in Vertex AI Model Registry are supported. If you
     * want to analyze the model which is outside the Vertex AI, you could
     * register a model in Vertex AI Model Registry using just a display name.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget model_monitoring_target = 3;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTargetOrBuilder
        getModelMonitoringTargetOrBuilder() {
      if (modelMonitoringTargetBuilder_ != null) {
        return modelMonitoringTargetBuilder_.getMessageOrBuilder();
      } else {
        return modelMonitoringTarget_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget
                .getDefaultInstance()
            : modelMonitoringTarget_;
      }
    }

    /**
     *
     *
     * <pre>
     * The entity that is subject to analysis.
     * Currently only models in Vertex AI Model Registry are supported. If you
     * want to analyze the model which is outside the Vertex AI, you could
     * register a model in Vertex AI Model Registry using just a display name.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget model_monitoring_target = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget,
            com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTargetOrBuilder>
        getModelMonitoringTargetFieldBuilder() {
      if (modelMonitoringTargetBuilder_ == null) {
        modelMonitoringTargetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget,
                com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTarget.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitor.ModelMonitoringTargetOrBuilder>(
                getModelMonitoringTarget(), getParentForChildren(), isClean());
        modelMonitoringTarget_ = null;
      }
      return modelMonitoringTargetBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput trainingDataset_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInputOrBuilder>
        trainingDatasetBuilder_;

    /**
     *
     *
     * <pre>
     * Optional training dataset used to train the model.
     * It can serve as a reference dataset to identify changes in production.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput training_dataset = 10;</code>
     *
     * @return Whether the trainingDataset field is set.
     */
    public boolean hasTrainingDataset() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional training dataset used to train the model.
     * It can serve as a reference dataset to identify changes in production.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput training_dataset = 10;</code>
     *
     * @return The trainingDataset.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput getTrainingDataset() {
      if (trainingDatasetBuilder_ == null) {
        return trainingDataset_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance()
            : trainingDataset_;
      } else {
        return trainingDatasetBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional training dataset used to train the model.
     * It can serve as a reference dataset to identify changes in production.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput training_dataset = 10;</code>
     */
    public Builder setTrainingDataset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput value) {
      if (trainingDatasetBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        trainingDataset_ = value;
      } else {
        trainingDatasetBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional training dataset used to train the model.
     * It can serve as a reference dataset to identify changes in production.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput training_dataset = 10;</code>
     */
    public Builder setTrainingDataset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder builderForValue) {
      if (trainingDatasetBuilder_ == null) {
        trainingDataset_ = builderForValue.build();
      } else {
        trainingDatasetBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional training dataset used to train the model.
     * It can serve as a reference dataset to identify changes in production.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput training_dataset = 10;</code>
     */
    public Builder mergeTrainingDataset(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput value) {
      if (trainingDatasetBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && trainingDataset_ != null
            && trainingDataset_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance()) {
          getTrainingDatasetBuilder().mergeFrom(value);
        } else {
          trainingDataset_ = value;
        }
      } else {
        trainingDatasetBuilder_.mergeFrom(value);
      }
      if (trainingDataset_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional training dataset used to train the model.
     * It can serve as a reference dataset to identify changes in production.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput training_dataset = 10;</code>
     */
    public Builder clearTrainingDataset() {
      bitField0_ = (bitField0_ & ~0x00000010);
      trainingDataset_ = null;
      if (trainingDatasetBuilder_ != null) {
        trainingDatasetBuilder_.dispose();
        trainingDatasetBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional training dataset used to train the model.
     * It can serve as a reference dataset to identify changes in production.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput training_dataset = 10;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder
        getTrainingDatasetBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getTrainingDatasetFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional training dataset used to train the model.
     * It can serve as a reference dataset to identify changes in production.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput training_dataset = 10;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringInputOrBuilder
        getTrainingDatasetOrBuilder() {
      if (trainingDatasetBuilder_ != null) {
        return trainingDatasetBuilder_.getMessageOrBuilder();
      } else {
        return trainingDataset_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.getDefaultInstance()
            : trainingDataset_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional training dataset used to train the model.
     * It can serve as a reference dataset to identify changes in production.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringInput training_dataset = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringInputOrBuilder>
        getTrainingDatasetFieldBuilder() {
      if (trainingDatasetBuilder_ == null) {
        trainingDatasetBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInput.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringInputOrBuilder>(
                getTrainingDataset(), getParentForChildren(), isClean());
        trainingDataset_ = null;
      }
      return trainingDatasetBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec notificationSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpecOrBuilder>
        notificationSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Optional default notification spec, it can be overridden in the
     * ModelMonitoringJob notification spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec notification_spec = 12;
     * </code>
     *
     * @return Whether the notificationSpec field is set.
     */
    public boolean hasNotificationSpec() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional default notification spec, it can be overridden in the
     * ModelMonitoringJob notification spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec notification_spec = 12;
     * </code>
     *
     * @return The notificationSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec
        getNotificationSpec() {
      if (notificationSpecBuilder_ == null) {
        return notificationSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec
                .getDefaultInstance()
            : notificationSpec_;
      } else {
        return notificationSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional default notification spec, it can be overridden in the
     * ModelMonitoringJob notification spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec notification_spec = 12;
     * </code>
     */
    public Builder setNotificationSpec(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec value) {
      if (notificationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        notificationSpec_ = value;
      } else {
        notificationSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional default notification spec, it can be overridden in the
     * ModelMonitoringJob notification spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec notification_spec = 12;
     * </code>
     */
    public Builder setNotificationSpec(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec.Builder
            builderForValue) {
      if (notificationSpecBuilder_ == null) {
        notificationSpec_ = builderForValue.build();
      } else {
        notificationSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional default notification spec, it can be overridden in the
     * ModelMonitoringJob notification spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec notification_spec = 12;
     * </code>
     */
    public Builder mergeNotificationSpec(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec value) {
      if (notificationSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && notificationSpec_ != null
            && notificationSpec_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec
                    .getDefaultInstance()) {
          getNotificationSpecBuilder().mergeFrom(value);
        } else {
          notificationSpec_ = value;
        }
      } else {
        notificationSpecBuilder_.mergeFrom(value);
      }
      if (notificationSpec_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional default notification spec, it can be overridden in the
     * ModelMonitoringJob notification spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec notification_spec = 12;
     * </code>
     */
    public Builder clearNotificationSpec() {
      bitField0_ = (bitField0_ & ~0x00000020);
      notificationSpec_ = null;
      if (notificationSpecBuilder_ != null) {
        notificationSpecBuilder_.dispose();
        notificationSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional default notification spec, it can be overridden in the
     * ModelMonitoringJob notification spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec notification_spec = 12;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec.Builder
        getNotificationSpecBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getNotificationSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional default notification spec, it can be overridden in the
     * ModelMonitoringJob notification spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec notification_spec = 12;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpecOrBuilder
        getNotificationSpecOrBuilder() {
      if (notificationSpecBuilder_ != null) {
        return notificationSpecBuilder_.getMessageOrBuilder();
      } else {
        return notificationSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec
                .getDefaultInstance()
            : notificationSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional default notification spec, it can be overridden in the
     * ModelMonitoringJob notification spec.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec notification_spec = 12;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpecOrBuilder>
        getNotificationSpecFieldBuilder() {
      if (notificationSpecBuilder_ == null) {
        notificationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringNotificationSpecOrBuilder>(
                getNotificationSpec(), getParentForChildren(), isClean());
        notificationSpec_ = null;
      }
      return notificationSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec outputSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpecOrBuilder>
        outputSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Optional default monitoring metrics/logs export spec, it can be overridden
     * in the ModelMonitoringJob output spec.
     * If not specified, a default Google Cloud Storage bucket will be created
     * under your project.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec output_spec = 13;</code>
     *
     * @return Whether the outputSpec field is set.
     */
    public boolean hasOutputSpec() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional default monitoring metrics/logs export spec, it can be overridden
     * in the ModelMonitoringJob output spec.
     * If not specified, a default Google Cloud Storage bucket will be created
     * under your project.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec output_spec = 13;</code>
     *
     * @return The outputSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec getOutputSpec() {
      if (outputSpecBuilder_ == null) {
        return outputSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec.getDefaultInstance()
            : outputSpec_;
      } else {
        return outputSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional default monitoring metrics/logs export spec, it can be overridden
     * in the ModelMonitoringJob output spec.
     * If not specified, a default Google Cloud Storage bucket will be created
     * under your project.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec output_spec = 13;</code>
     */
    public Builder setOutputSpec(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec value) {
      if (outputSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        outputSpec_ = value;
      } else {
        outputSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional default monitoring metrics/logs export spec, it can be overridden
     * in the ModelMonitoringJob output spec.
     * If not specified, a default Google Cloud Storage bucket will be created
     * under your project.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec output_spec = 13;</code>
     */
    public Builder setOutputSpec(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec.Builder builderForValue) {
      if (outputSpecBuilder_ == null) {
        outputSpec_ = builderForValue.build();
      } else {
        outputSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional default monitoring metrics/logs export spec, it can be overridden
     * in the ModelMonitoringJob output spec.
     * If not specified, a default Google Cloud Storage bucket will be created
     * under your project.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec output_spec = 13;</code>
     */
    public Builder mergeOutputSpec(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec value) {
      if (outputSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && outputSpec_ != null
            && outputSpec_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec
                    .getDefaultInstance()) {
          getOutputSpecBuilder().mergeFrom(value);
        } else {
          outputSpec_ = value;
        }
      } else {
        outputSpecBuilder_.mergeFrom(value);
      }
      if (outputSpec_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional default monitoring metrics/logs export spec, it can be overridden
     * in the ModelMonitoringJob output spec.
     * If not specified, a default Google Cloud Storage bucket will be created
     * under your project.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec output_spec = 13;</code>
     */
    public Builder clearOutputSpec() {
      bitField0_ = (bitField0_ & ~0x00000040);
      outputSpec_ = null;
      if (outputSpecBuilder_ != null) {
        outputSpecBuilder_.dispose();
        outputSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional default monitoring metrics/logs export spec, it can be overridden
     * in the ModelMonitoringJob output spec.
     * If not specified, a default Google Cloud Storage bucket will be created
     * under your project.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec output_spec = 13;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec.Builder
        getOutputSpecBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getOutputSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional default monitoring metrics/logs export spec, it can be overridden
     * in the ModelMonitoringJob output spec.
     * If not specified, a default Google Cloud Storage bucket will be created
     * under your project.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec output_spec = 13;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpecOrBuilder
        getOutputSpecOrBuilder() {
      if (outputSpecBuilder_ != null) {
        return outputSpecBuilder_.getMessageOrBuilder();
      } else {
        return outputSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec.getDefaultInstance()
            : outputSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional default monitoring metrics/logs export spec, it can be overridden
     * in the ModelMonitoringJob output spec.
     * If not specified, a default Google Cloud Storage bucket will be created
     * under your project.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec output_spec = 13;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpecOrBuilder>
        getOutputSpecFieldBuilder() {
      if (outputSpecBuilder_ == null) {
        outputSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringOutputSpecOrBuilder>(
                getOutputSpec(), getParentForChildren(), isClean());
        outputSpec_ = null;
      }
      return outputSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ExplanationSpec explanationSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExplanationSpec,
            com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder>
        explanationSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Optional model explanation spec. It is used for feature attribution
     * monitoring.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 16;</code>
     *
     * @return Whether the explanationSpec field is set.
     */
    public boolean hasExplanationSpec() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional model explanation spec. It is used for feature attribution
     * monitoring.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 16;</code>
     *
     * @return The explanationSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.ExplanationSpec getExplanationSpec() {
      if (explanationSpecBuilder_ == null) {
        return explanationSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
            : explanationSpec_;
      } else {
        return explanationSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional model explanation spec. It is used for feature attribution
     * monitoring.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 16;</code>
     */
    public Builder setExplanationSpec(com.google.cloud.aiplatform.v1beta1.ExplanationSpec value) {
      if (explanationSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        explanationSpec_ = value;
      } else {
        explanationSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional model explanation spec. It is used for feature attribution
     * monitoring.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 16;</code>
     */
    public Builder setExplanationSpec(
        com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder builderForValue) {
      if (explanationSpecBuilder_ == null) {
        explanationSpec_ = builderForValue.build();
      } else {
        explanationSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional model explanation spec. It is used for feature attribution
     * monitoring.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 16;</code>
     */
    public Builder mergeExplanationSpec(com.google.cloud.aiplatform.v1beta1.ExplanationSpec value) {
      if (explanationSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && explanationSpec_ != null
            && explanationSpec_
                != com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()) {
          getExplanationSpecBuilder().mergeFrom(value);
        } else {
          explanationSpec_ = value;
        }
      } else {
        explanationSpecBuilder_.mergeFrom(value);
      }
      if (explanationSpec_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional model explanation spec. It is used for feature attribution
     * monitoring.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 16;</code>
     */
    public Builder clearExplanationSpec() {
      bitField0_ = (bitField0_ & ~0x00000080);
      explanationSpec_ = null;
      if (explanationSpecBuilder_ != null) {
        explanationSpecBuilder_.dispose();
        explanationSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional model explanation spec. It is used for feature attribution
     * monitoring.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 16;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder getExplanationSpecBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getExplanationSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional model explanation spec. It is used for feature attribution
     * monitoring.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 16;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder
        getExplanationSpecOrBuilder() {
      if (explanationSpecBuilder_ != null) {
        return explanationSpecBuilder_.getMessageOrBuilder();
      } else {
        return explanationSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ExplanationSpec.getDefaultInstance()
            : explanationSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional model explanation spec. It is used for feature attribution
     * monitoring.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ExplanationSpec explanation_spec = 16;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ExplanationSpec,
            com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder>
        getExplanationSpecFieldBuilder() {
      if (explanationSpecBuilder_ == null) {
        explanationSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ExplanationSpec,
                com.google.cloud.aiplatform.v1beta1.ExplanationSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.ExplanationSpecOrBuilder>(
                getExplanationSpec(), getParentForChildren(), isClean());
        explanationSpec_ = null;
      }
      return explanationSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema modelMonitoringSchema_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchemaOrBuilder>
        modelMonitoringSchemaBuilder_;

    /**
     *
     *
     * <pre>
     * Monitoring Schema is to specify the model's features, prediction outputs
     * and ground truth properties. It is used to extract pertinent data from the
     * dataset and to process features based on their properties.
     * Make sure that the schema aligns with your dataset, if it does not, we will
     * be unable to extract data from the dataset.
     * It is required for most models, but optional for Vertex AI AutoML Tables
     * unless the schem information is not available.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema model_monitoring_schema = 9;
     * </code>
     *
     * @return Whether the modelMonitoringSchema field is set.
     */
    public boolean hasModelMonitoringSchema() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Monitoring Schema is to specify the model's features, prediction outputs
     * and ground truth properties. It is used to extract pertinent data from the
     * dataset and to process features based on their properties.
     * Make sure that the schema aligns with your dataset, if it does not, we will
     * be unable to extract data from the dataset.
     * It is required for most models, but optional for Vertex AI AutoML Tables
     * unless the schem information is not available.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema model_monitoring_schema = 9;
     * </code>
     *
     * @return The modelMonitoringSchema.
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema getModelMonitoringSchema() {
      if (modelMonitoringSchemaBuilder_ == null) {
        return modelMonitoringSchema_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.getDefaultInstance()
            : modelMonitoringSchema_;
      } else {
        return modelMonitoringSchemaBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Monitoring Schema is to specify the model's features, prediction outputs
     * and ground truth properties. It is used to extract pertinent data from the
     * dataset and to process features based on their properties.
     * Make sure that the schema aligns with your dataset, if it does not, we will
     * be unable to extract data from the dataset.
     * It is required for most models, but optional for Vertex AI AutoML Tables
     * unless the schem information is not available.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema model_monitoring_schema = 9;
     * </code>
     */
    public Builder setModelMonitoringSchema(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema value) {
      if (modelMonitoringSchemaBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        modelMonitoringSchema_ = value;
      } else {
        modelMonitoringSchemaBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Monitoring Schema is to specify the model's features, prediction outputs
     * and ground truth properties. It is used to extract pertinent data from the
     * dataset and to process features based on their properties.
     * Make sure that the schema aligns with your dataset, if it does not, we will
     * be unable to extract data from the dataset.
     * It is required for most models, but optional for Vertex AI AutoML Tables
     * unless the schem information is not available.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema model_monitoring_schema = 9;
     * </code>
     */
    public Builder setModelMonitoringSchema(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.Builder builderForValue) {
      if (modelMonitoringSchemaBuilder_ == null) {
        modelMonitoringSchema_ = builderForValue.build();
      } else {
        modelMonitoringSchemaBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Monitoring Schema is to specify the model's features, prediction outputs
     * and ground truth properties. It is used to extract pertinent data from the
     * dataset and to process features based on their properties.
     * Make sure that the schema aligns with your dataset, if it does not, we will
     * be unable to extract data from the dataset.
     * It is required for most models, but optional for Vertex AI AutoML Tables
     * unless the schem information is not available.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema model_monitoring_schema = 9;
     * </code>
     */
    public Builder mergeModelMonitoringSchema(
        com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema value) {
      if (modelMonitoringSchemaBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && modelMonitoringSchema_ != null
            && modelMonitoringSchema_
                != com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.getDefaultInstance()) {
          getModelMonitoringSchemaBuilder().mergeFrom(value);
        } else {
          modelMonitoringSchema_ = value;
        }
      } else {
        modelMonitoringSchemaBuilder_.mergeFrom(value);
      }
      if (modelMonitoringSchema_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Monitoring Schema is to specify the model's features, prediction outputs
     * and ground truth properties. It is used to extract pertinent data from the
     * dataset and to process features based on their properties.
     * Make sure that the schema aligns with your dataset, if it does not, we will
     * be unable to extract data from the dataset.
     * It is required for most models, but optional for Vertex AI AutoML Tables
     * unless the schem information is not available.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema model_monitoring_schema = 9;
     * </code>
     */
    public Builder clearModelMonitoringSchema() {
      bitField0_ = (bitField0_ & ~0x00000100);
      modelMonitoringSchema_ = null;
      if (modelMonitoringSchemaBuilder_ != null) {
        modelMonitoringSchemaBuilder_.dispose();
        modelMonitoringSchemaBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Monitoring Schema is to specify the model's features, prediction outputs
     * and ground truth properties. It is used to extract pertinent data from the
     * dataset and to process features based on their properties.
     * Make sure that the schema aligns with your dataset, if it does not, we will
     * be unable to extract data from the dataset.
     * It is required for most models, but optional for Vertex AI AutoML Tables
     * unless the schem information is not available.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema model_monitoring_schema = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.Builder
        getModelMonitoringSchemaBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getModelMonitoringSchemaFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Monitoring Schema is to specify the model's features, prediction outputs
     * and ground truth properties. It is used to extract pertinent data from the
     * dataset and to process features based on their properties.
     * Make sure that the schema aligns with your dataset, if it does not, we will
     * be unable to extract data from the dataset.
     * It is required for most models, but optional for Vertex AI AutoML Tables
     * unless the schem information is not available.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema model_monitoring_schema = 9;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchemaOrBuilder
        getModelMonitoringSchemaOrBuilder() {
      if (modelMonitoringSchemaBuilder_ != null) {
        return modelMonitoringSchemaBuilder_.getMessageOrBuilder();
      } else {
        return modelMonitoringSchema_ == null
            ? com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.getDefaultInstance()
            : modelMonitoringSchema_;
      }
    }

    /**
     *
     *
     * <pre>
     * Monitoring Schema is to specify the model's features, prediction outputs
     * and ground truth properties. It is used to extract pertinent data from the
     * dataset and to process features based on their properties.
     * Make sure that the schema aligns with your dataset, if it does not, we will
     * be unable to extract data from the dataset.
     * It is required for most models, but optional for Vertex AI AutoML Tables
     * unless the schem information is not available.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema model_monitoring_schema = 9;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.Builder,
            com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchemaOrBuilder>
        getModelMonitoringSchemaFieldBuilder() {
      if (modelMonitoringSchemaBuilder_ == null) {
        modelMonitoringSchemaBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchema.Builder,
                com.google.cloud.aiplatform.v1beta1.ModelMonitoringSchemaOrBuilder>(
                getModelMonitoringSchema(), getParentForChildren(), isClean());
        modelMonitoringSchema_ = null;
      }
      return modelMonitoringSchemaBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelMonitor. If
     * set, this ModelMonitor and all sub-resources of this
     * ModelMonitor will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 5;</code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelMonitor. If
     * set, this ModelMonitor and all sub-resources of this
     * ModelMonitor will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 5;</code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelMonitor. If
     * set, this ModelMonitor and all sub-resources of this
     * ModelMonitor will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 5;</code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelMonitor. If
     * set, this ModelMonitor and all sub-resources of this
     * ModelMonitor will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 5;</code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelMonitor. If
     * set, this ModelMonitor and all sub-resources of this
     * ModelMonitor will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 5;</code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      if (encryptionSpec_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelMonitor. If
     * set, this ModelMonitor and all sub-resources of this
     * ModelMonitor will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 5;</code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x00000200);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelMonitor. If
     * set, this ModelMonitor and all sub-resources of this
     * ModelMonitor will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 5;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelMonitor. If
     * set, this ModelMonitor and all sub-resources of this
     * ModelMonitor will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 5;</code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder
        getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Customer-managed encryption key spec for a ModelMonitor. If
     * set, this ModelMonitor and all sub-resources of this
     * ModelMonitor will be secured by this key.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 5;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000400);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000800);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Timestamp when this ModelMonitor was updated most recently.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private boolean satisfiesPzs_;

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00001000);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzi_;

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField0_ = (bitField0_ & ~0x00002000);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.ModelMonitor)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.ModelMonitor)
  private static final com.google.cloud.aiplatform.v1beta1.ModelMonitor DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.ModelMonitor();
  }

  public static com.google.cloud.aiplatform.v1beta1.ModelMonitor getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ModelMonitor> PARSER =
      new com.google.protobuf.AbstractParser<ModelMonitor>() {
        @java.lang.Override
        public ModelMonitor parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ModelMonitor> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ModelMonitor> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ModelMonitor getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
