/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FeatureMonitorJobName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FEATURE_GROUP_FEATURE_MONITOR_FEATURE_MONITOR_JOB = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/featureGroups/{feature_group}/featureMonitors/{feature_monitor}/featureMonitorJobs/{feature_monitor_job}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String featureGroup;
    private final String featureMonitor;
    private final String featureMonitorJob;

    @Deprecated
    protected FeatureMonitorJobName() {
        this.project = null;
        this.location = null;
        this.featureGroup = null;
        this.featureMonitor = null;
        this.featureMonitorJob = null;
    }

    private FeatureMonitorJobName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.featureGroup = (String)Preconditions.checkNotNull((Object)builder.getFeatureGroup());
        this.featureMonitor = (String)Preconditions.checkNotNull((Object)builder.getFeatureMonitor());
        this.featureMonitorJob = (String)Preconditions.checkNotNull((Object)builder.getFeatureMonitorJob());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFeatureGroup() {
        return this.featureGroup;
    }

    public String getFeatureMonitor() {
        return this.featureMonitor;
    }

    public String getFeatureMonitorJob() {
        return this.featureMonitorJob;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FeatureMonitorJobName of(String project, String location, String featureGroup, String featureMonitor, String featureMonitorJob) {
        return FeatureMonitorJobName.newBuilder().setProject(project).setLocation(location).setFeatureGroup(featureGroup).setFeatureMonitor(featureMonitor).setFeatureMonitorJob(featureMonitorJob).build();
    }

    public static String format(String project, String location, String featureGroup, String featureMonitor, String featureMonitorJob) {
        return FeatureMonitorJobName.newBuilder().setProject(project).setLocation(location).setFeatureGroup(featureGroup).setFeatureMonitor(featureMonitor).setFeatureMonitorJob(featureMonitorJob).build().toString();
    }

    public static FeatureMonitorJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_FEATURE_GROUP_FEATURE_MONITOR_FEATURE_MONITOR_JOB.validatedMatch(formattedString, "FeatureMonitorJobName.parse: formattedString not in valid format");
        return FeatureMonitorJobName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("feature_group"), (String)matchMap.get("feature_monitor"), (String)matchMap.get("feature_monitor_job"));
    }

    public static List<FeatureMonitorJobName> parseList(List<String> formattedStrings) {
        ArrayList<FeatureMonitorJobName> list = new ArrayList<FeatureMonitorJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FeatureMonitorJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FeatureMonitorJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FeatureMonitorJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FEATURE_GROUP_FEATURE_MONITOR_FEATURE_MONITOR_JOB.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FeatureMonitorJobName featureMonitorJobName = this;
            synchronized (featureMonitorJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.featureGroup != null) {
                        fieldMapBuilder.put((Object)"feature_group", (Object)this.featureGroup);
                    }
                    if (this.featureMonitor != null) {
                        fieldMapBuilder.put((Object)"feature_monitor", (Object)this.featureMonitor);
                    }
                    if (this.featureMonitorJob != null) {
                        fieldMapBuilder.put((Object)"feature_monitor_job", (Object)this.featureMonitorJob);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_FEATURE_GROUP_FEATURE_MONITOR_FEATURE_MONITOR_JOB.instantiate(new String[]{"project", this.project, "location", this.location, "feature_group", this.featureGroup, "feature_monitor", this.featureMonitor, "feature_monitor_job", this.featureMonitorJob});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FeatureMonitorJobName that = (FeatureMonitorJobName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.featureGroup, that.featureGroup) && Objects.equals(this.featureMonitor, that.featureMonitor) && Objects.equals(this.featureMonitorJob, that.featureMonitorJob);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.featureGroup);
        h *= 1000003;
        h ^= Objects.hashCode(this.featureMonitor);
        h *= 1000003;
        return h ^= Objects.hashCode(this.featureMonitorJob);
    }

    public static class Builder {
        private String project;
        private String location;
        private String featureGroup;
        private String featureMonitor;
        private String featureMonitorJob;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFeatureGroup() {
            return this.featureGroup;
        }

        public String getFeatureMonitor() {
            return this.featureMonitor;
        }

        public String getFeatureMonitorJob() {
            return this.featureMonitorJob;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFeatureGroup(String featureGroup) {
            this.featureGroup = featureGroup;
            return this;
        }

        public Builder setFeatureMonitor(String featureMonitor) {
            this.featureMonitor = featureMonitor;
            return this;
        }

        public Builder setFeatureMonitorJob(String featureMonitorJob) {
            this.featureMonitorJob = featureMonitorJob;
            return this;
        }

        private Builder(FeatureMonitorJobName featureMonitorJobName) {
            this.project = featureMonitorJobName.project;
            this.location = featureMonitorJobName.location;
            this.featureGroup = featureMonitorJobName.featureGroup;
            this.featureMonitor = featureMonitorJobName.featureMonitor;
            this.featureMonitorJob = featureMonitorJobName.featureMonitorJob;
        }

        public FeatureMonitorJobName build() {
            return new FeatureMonitorJobName(this);
        }
    }
}

