/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/machine_resources.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * The metric specification that defines the target resource utilization
 * (CPU utilization, accelerator's duty cycle, and so on) for calculating the
 * desired replica count.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec}
 */
public final class AutoscalingMetricSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec)
    AutoscalingMetricSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use AutoscalingMetricSpec.newBuilder() to construct.
  private AutoscalingMetricSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private AutoscalingMetricSpec() {
    metricName_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new AutoscalingMetricSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.MachineResourcesProto
        .internal_static_google_cloud_aiplatform_v1beta1_AutoscalingMetricSpec_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 3:
        return internalGetMonitoredResourceLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.MachineResourcesProto
        .internal_static_google_cloud_aiplatform_v1beta1_AutoscalingMetricSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.class,
            com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.Builder.class);
  }

  public static final int METRIC_NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object metricName_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource metric name.
   * Supported metrics:
   *
   * * For Online Prediction:
   * * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle`
   * * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
   * * `aiplatform.googleapis.com/prediction/online/request_count`
   * </pre>
   *
   * <code>string metric_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The metricName.
   */
  @java.lang.Override
  public java.lang.String getMetricName() {
    java.lang.Object ref = metricName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      metricName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource metric name.
   * Supported metrics:
   *
   * * For Online Prediction:
   * * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle`
   * * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
   * * `aiplatform.googleapis.com/prediction/online/request_count`
   * </pre>
   *
   * <code>string metric_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for metricName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getMetricNameBytes() {
    java.lang.Object ref = metricName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      metricName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TARGET_FIELD_NUMBER = 2;
  private int target_ = 0;

  /**
   *
   *
   * <pre>
   * The target resource utilization in percentage (1% - 100%) for the given
   * metric; once the real usage deviates from the target by a certain
   * percentage, the machine replicas change. The default value is 60
   * (representing 60%) if not provided.
   * </pre>
   *
   * <code>int32 target = 2;</code>
   *
   * @return The target.
   */
  @java.lang.Override
  public int getTarget() {
    return target_;
  }

  public static final int MONITORED_RESOURCE_LABELS_FIELD_NUMBER = 3;

  private static final class MonitoredResourceLabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.MachineResourcesProto
                .internal_static_google_cloud_aiplatform_v1beta1_AutoscalingMetricSpec_MonitoredResourceLabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> monitoredResourceLabels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String>
      internalGetMonitoredResourceLabels() {
    if (monitoredResourceLabels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          MonitoredResourceLabelsDefaultEntryHolder.defaultEntry);
    }
    return monitoredResourceLabels_;
  }

  public int getMonitoredResourceLabelsCount() {
    return internalGetMonitoredResourceLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The Cloud Monitoring monitored resource labels as key value pairs
   * used for metrics filtering. See Cloud Monitoring Labels
   * https://cloud.google.com/monitoring/api/v3/metric-model#generic-label-info
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; monitored_resource_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public boolean containsMonitoredResourceLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetMonitoredResourceLabels().getMap().containsKey(key);
  }

  /** Use {@link #getMonitoredResourceLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getMonitoredResourceLabels() {
    return getMonitoredResourceLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. The Cloud Monitoring monitored resource labels as key value pairs
   * used for metrics filtering. See Cloud Monitoring Labels
   * https://cloud.google.com/monitoring/api/v3/metric-model#generic-label-info
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; monitored_resource_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getMonitoredResourceLabelsMap() {
    return internalGetMonitoredResourceLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. The Cloud Monitoring monitored resource labels as key value pairs
   * used for metrics filtering. See Cloud Monitoring Labels
   * https://cloud.google.com/monitoring/api/v3/metric-model#generic-label-info
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; monitored_resource_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getMonitoredResourceLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetMonitoredResourceLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. The Cloud Monitoring monitored resource labels as key value pairs
   * used for metrics filtering. See Cloud Monitoring Labels
   * https://cloud.google.com/monitoring/api/v3/metric-model#generic-label-info
   * </pre>
   *
   * <code>
   * map&lt;string, string&gt; monitored_resource_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.lang.String getMonitoredResourceLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map =
        internalGetMonitoredResourceLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, metricName_);
    }
    if (target_ != 0) {
      output.writeInt32(2, target_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetMonitoredResourceLabels(),
        MonitoredResourceLabelsDefaultEntryHolder.defaultEntry,
        3);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(metricName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, metricName_);
    }
    if (target_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, target_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetMonitoredResourceLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> monitoredResourceLabels__ =
          MonitoredResourceLabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(3, monitoredResourceLabels__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec other =
        (com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec) obj;

    if (!getMetricName().equals(other.getMetricName())) return false;
    if (getTarget() != other.getTarget()) return false;
    if (!internalGetMonitoredResourceLabels().equals(other.internalGetMonitoredResourceLabels()))
      return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + METRIC_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getMetricName().hashCode();
    hash = (37 * hash) + TARGET_FIELD_NUMBER;
    hash = (53 * hash) + getTarget();
    if (!internalGetMonitoredResourceLabels().getMap().isEmpty()) {
      hash = (37 * hash) + MONITORED_RESOURCE_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetMonitoredResourceLabels().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The metric specification that defines the target resource utilization
   * (CPU utilization, accelerator's duty cycle, and so on) for calculating the
   * desired replica count.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec)
      com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MachineResourcesProto
          .internal_static_google_cloud_aiplatform_v1beta1_AutoscalingMetricSpec_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMonitoredResourceLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 3:
          return internalGetMutableMonitoredResourceLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MachineResourcesProto
          .internal_static_google_cloud_aiplatform_v1beta1_AutoscalingMetricSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.class,
              com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      metricName_ = "";
      target_ = 0;
      internalGetMutableMonitoredResourceLabels().clear();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.MachineResourcesProto
          .internal_static_google_cloud_aiplatform_v1beta1_AutoscalingMetricSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec build() {
      com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec buildPartial() {
      com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec result =
          new com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.metricName_ = metricName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.target_ = target_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.monitoredResourceLabels_ = internalGetMonitoredResourceLabels();
        result.monitoredResourceLabels_.makeImmutable();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec other) {
      if (other == com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec.getDefaultInstance())
        return this;
      if (!other.getMetricName().isEmpty()) {
        metricName_ = other.metricName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.getTarget() != 0) {
        setTarget(other.getTarget());
      }
      internalGetMutableMonitoredResourceLabels()
          .mergeFrom(other.internalGetMonitoredResourceLabels());
      bitField0_ |= 0x00000004;
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                metricName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                target_ = input.readInt32();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 26:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String>
                    monitoredResourceLabels__ =
                        input.readMessage(
                            MonitoredResourceLabelsDefaultEntryHolder.defaultEntry
                                .getParserForType(),
                            extensionRegistry);
                internalGetMutableMonitoredResourceLabels()
                    .getMutableMap()
                    .put(monitoredResourceLabels__.getKey(), monitoredResourceLabels__.getValue());
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object metricName_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource metric name.
     * Supported metrics:
     *
     * * For Online Prediction:
     * * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle`
     * * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
     * * `aiplatform.googleapis.com/prediction/online/request_count`
     * </pre>
     *
     * <code>string metric_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The metricName.
     */
    public java.lang.String getMetricName() {
      java.lang.Object ref = metricName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        metricName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource metric name.
     * Supported metrics:
     *
     * * For Online Prediction:
     * * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle`
     * * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
     * * `aiplatform.googleapis.com/prediction/online/request_count`
     * </pre>
     *
     * <code>string metric_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for metricName.
     */
    public com.google.protobuf.ByteString getMetricNameBytes() {
      java.lang.Object ref = metricName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        metricName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource metric name.
     * Supported metrics:
     *
     * * For Online Prediction:
     * * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle`
     * * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
     * * `aiplatform.googleapis.com/prediction/online/request_count`
     * </pre>
     *
     * <code>string metric_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The metricName to set.
     * @return This builder for chaining.
     */
    public Builder setMetricName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      metricName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource metric name.
     * Supported metrics:
     *
     * * For Online Prediction:
     * * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle`
     * * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
     * * `aiplatform.googleapis.com/prediction/online/request_count`
     * </pre>
     *
     * <code>string metric_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMetricName() {
      metricName_ = getDefaultInstance().getMetricName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource metric name.
     * Supported metrics:
     *
     * * For Online Prediction:
     * * `aiplatform.googleapis.com/prediction/online/accelerator/duty_cycle`
     * * `aiplatform.googleapis.com/prediction/online/cpu/utilization`
     * * `aiplatform.googleapis.com/prediction/online/request_count`
     * </pre>
     *
     * <code>string metric_name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for metricName to set.
     * @return This builder for chaining.
     */
    public Builder setMetricNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      metricName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int target_;

    /**
     *
     *
     * <pre>
     * The target resource utilization in percentage (1% - 100%) for the given
     * metric; once the real usage deviates from the target by a certain
     * percentage, the machine replicas change. The default value is 60
     * (representing 60%) if not provided.
     * </pre>
     *
     * <code>int32 target = 2;</code>
     *
     * @return The target.
     */
    @java.lang.Override
    public int getTarget() {
      return target_;
    }

    /**
     *
     *
     * <pre>
     * The target resource utilization in percentage (1% - 100%) for the given
     * metric; once the real usage deviates from the target by a certain
     * percentage, the machine replicas change. The default value is 60
     * (representing 60%) if not provided.
     * </pre>
     *
     * <code>int32 target = 2;</code>
     *
     * @param value The target to set.
     * @return This builder for chaining.
     */
    public Builder setTarget(int value) {

      target_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The target resource utilization in percentage (1% - 100%) for the given
     * metric; once the real usage deviates from the target by a certain
     * percentage, the machine replicas change. The default value is 60
     * (representing 60%) if not provided.
     * </pre>
     *
     * <code>int32 target = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearTarget() {
      bitField0_ = (bitField0_ & ~0x00000002);
      target_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        monitoredResourceLabels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMonitoredResourceLabels() {
      if (monitoredResourceLabels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(
            MonitoredResourceLabelsDefaultEntryHolder.defaultEntry);
      }
      return monitoredResourceLabels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableMonitoredResourceLabels() {
      if (monitoredResourceLabels_ == null) {
        monitoredResourceLabels_ =
            com.google.protobuf.MapField.newMapField(
                MonitoredResourceLabelsDefaultEntryHolder.defaultEntry);
      }
      if (!monitoredResourceLabels_.isMutable()) {
        monitoredResourceLabels_ = monitoredResourceLabels_.copy();
      }
      bitField0_ |= 0x00000004;
      onChanged();
      return monitoredResourceLabels_;
    }

    public int getMonitoredResourceLabelsCount() {
      return internalGetMonitoredResourceLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Monitoring monitored resource labels as key value pairs
     * used for metrics filtering. See Cloud Monitoring Labels
     * https://cloud.google.com/monitoring/api/v3/metric-model#generic-label-info
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; monitored_resource_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public boolean containsMonitoredResourceLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetMonitoredResourceLabels().getMap().containsKey(key);
    }

    /** Use {@link #getMonitoredResourceLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMonitoredResourceLabels() {
      return getMonitoredResourceLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Monitoring monitored resource labels as key value pairs
     * used for metrics filtering. See Cloud Monitoring Labels
     * https://cloud.google.com/monitoring/api/v3/metric-model#generic-label-info
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; monitored_resource_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getMonitoredResourceLabelsMap() {
      return internalGetMonitoredResourceLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Monitoring monitored resource labels as key value pairs
     * used for metrics filtering. See Cloud Monitoring Labels
     * https://cloud.google.com/monitoring/api/v3/metric-model#generic-label-info
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; monitored_resource_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getMonitoredResourceLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetMonitoredResourceLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Monitoring monitored resource labels as key value pairs
     * used for metrics filtering. See Cloud Monitoring Labels
     * https://cloud.google.com/monitoring/api/v3/metric-model#generic-label-info
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; monitored_resource_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public java.lang.String getMonitoredResourceLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map =
          internalGetMonitoredResourceLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearMonitoredResourceLabels() {
      bitField0_ = (bitField0_ & ~0x00000004);
      internalGetMutableMonitoredResourceLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Monitoring monitored resource labels as key value pairs
     * used for metrics filtering. See Cloud Monitoring Labels
     * https://cloud.google.com/monitoring/api/v3/metric-model#generic-label-info
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; monitored_resource_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeMonitoredResourceLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableMonitoredResourceLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableMonitoredResourceLabels() {
      bitField0_ |= 0x00000004;
      return internalGetMutableMonitoredResourceLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Monitoring monitored resource labels as key value pairs
     * used for metrics filtering. See Cloud Monitoring Labels
     * https://cloud.google.com/monitoring/api/v3/metric-model#generic-label-info
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; monitored_resource_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putMonitoredResourceLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableMonitoredResourceLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000004;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The Cloud Monitoring monitored resource labels as key value pairs
     * used for metrics filtering. See Cloud Monitoring Labels
     * https://cloud.google.com/monitoring/api/v3/metric-model#generic-label-info
     * </pre>
     *
     * <code>
     * map&lt;string, string&gt; monitored_resource_labels = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder putAllMonitoredResourceLabels(
        java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableMonitoredResourceLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000004;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec)
  private static final com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec();
  }

  public static com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AutoscalingMetricSpec> PARSER =
      new com.google.protobuf.AbstractParser<AutoscalingMetricSpec>() {
        @java.lang.Override
        public AutoscalingMetricSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<AutoscalingMetricSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AutoscalingMetricSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.AutoscalingMetricSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
