/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/memory_bank_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Response message for
 * [MemoryBankService.GenerateMemories][google.cloud.aiplatform.v1beta1.MemoryBankService.GenerateMemories].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse}
 */
public final class GenerateMemoriesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse)
    GenerateMemoriesResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use GenerateMemoriesResponse.newBuilder() to construct.
  private GenerateMemoriesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private GenerateMemoriesResponse() {
    generatedMemories_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new GenerateMemoriesResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.class,
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.Builder.class);
  }

  public interface GeneratedMemoryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The generated Memory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
     *
     * @return Whether the memory field is set.
     */
    boolean hasMemory();

    /**
     *
     *
     * <pre>
     * The generated Memory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
     *
     * @return The memory.
     */
    com.google.cloud.aiplatform.v1beta1.Memory getMemory();

    /**
     *
     *
     * <pre>
     * The generated Memory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
     */
    com.google.cloud.aiplatform.v1beta1.MemoryOrBuilder getMemoryOrBuilder();

    /**
     *
     *
     * <pre>
     * The action that was performed on the Memory.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action action = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for action.
     */
    int getActionValue();

    /**
     *
     *
     * <pre>
     * The action that was performed on the Memory.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action action = 2;
     * </code>
     *
     * @return The action.
     */
    com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action getAction();
  }

  /**
   *
   *
   * <pre>
   * A memory generated by the operation.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory}
   */
  public static final class GeneratedMemory extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory)
      GeneratedMemoryOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use GeneratedMemory.newBuilder() to construct.
    private GeneratedMemory(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private GeneratedMemory() {
      action_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new GeneratedMemory();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesResponse_GeneratedMemory_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesResponse_GeneratedMemory_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.class,
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Builder
                  .class);
    }

    /**
     *
     *
     * <pre>
     * Actions that can be performed on a Memory.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action}
     */
    public enum Action implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Action is unspecified.
       * </pre>
       *
       * <code>ACTION_UNSPECIFIED = 0;</code>
       */
      ACTION_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * The memory was created.
       * </pre>
       *
       * <code>CREATED = 1;</code>
       */
      CREATED(1),
      /**
       *
       *
       * <pre>
       * The memory was updated. The `fact` field may not be updated if the
       * existing fact is still accurate.
       * </pre>
       *
       * <code>UPDATED = 2;</code>
       */
      UPDATED(2),
      /**
       *
       *
       * <pre>
       * The memory was deleted.
       * </pre>
       *
       * <code>DELETED = 3;</code>
       */
      DELETED(3),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Action is unspecified.
       * </pre>
       *
       * <code>ACTION_UNSPECIFIED = 0;</code>
       */
      public static final int ACTION_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * The memory was created.
       * </pre>
       *
       * <code>CREATED = 1;</code>
       */
      public static final int CREATED_VALUE = 1;

      /**
       *
       *
       * <pre>
       * The memory was updated. The `fact` field may not be updated if the
       * existing fact is still accurate.
       * </pre>
       *
       * <code>UPDATED = 2;</code>
       */
      public static final int UPDATED_VALUE = 2;

      /**
       *
       *
       * <pre>
       * The memory was deleted.
       * </pre>
       *
       * <code>DELETED = 3;</code>
       */
      public static final int DELETED_VALUE = 3;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Action valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Action forNumber(int value) {
        switch (value) {
          case 0:
            return ACTION_UNSPECIFIED;
          case 1:
            return CREATED;
          case 2:
            return UPDATED;
          case 3:
            return DELETED;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Action> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Action> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Action>() {
            public Action findValueByNumber(int number) {
              return Action.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Action[] VALUES = values();

      public static Action valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Action(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action)
    }

    private int bitField0_;
    public static final int MEMORY_FIELD_NUMBER = 1;
    private com.google.cloud.aiplatform.v1beta1.Memory memory_;

    /**
     *
     *
     * <pre>
     * The generated Memory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
     *
     * @return Whether the memory field is set.
     */
    @java.lang.Override
    public boolean hasMemory() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The generated Memory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
     *
     * @return The memory.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Memory getMemory() {
      return memory_ == null
          ? com.google.cloud.aiplatform.v1beta1.Memory.getDefaultInstance()
          : memory_;
    }

    /**
     *
     *
     * <pre>
     * The generated Memory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MemoryOrBuilder getMemoryOrBuilder() {
      return memory_ == null
          ? com.google.cloud.aiplatform.v1beta1.Memory.getDefaultInstance()
          : memory_;
    }

    public static final int ACTION_FIELD_NUMBER = 2;
    private int action_ = 0;

    /**
     *
     *
     * <pre>
     * The action that was performed on the Memory.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action action = 2;
     * </code>
     *
     * @return The enum numeric value on the wire for action.
     */
    @java.lang.Override
    public int getActionValue() {
      return action_;
    }

    /**
     *
     *
     * <pre>
     * The action that was performed on the Memory.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action action = 2;
     * </code>
     *
     * @return The action.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action
        getAction() {
      com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action result =
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action
              .forNumber(action_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getMemory());
      }
      if (action_
          != com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action
              .ACTION_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(2, action_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMemory());
      }
      if (action_
          != com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action
              .ACTION_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, action_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory other =
          (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory) obj;

      if (hasMemory() != other.hasMemory()) return false;
      if (hasMemory()) {
        if (!getMemory().equals(other.getMemory())) return false;
      }
      if (action_ != other.action_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMemory()) {
        hash = (37 * hash) + MEMORY_FIELD_NUMBER;
        hash = (53 * hash) + getMemory().hashCode();
      }
      hash = (37 * hash) + ACTION_FIELD_NUMBER;
      hash = (53 * hash) + action_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A memory generated by the operation.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory)
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemoryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesResponse_GeneratedMemory_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesResponse_GeneratedMemory_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.class,
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMemoryFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        memory_ = null;
        if (memoryBuilder_ != null) {
          memoryBuilder_.dispose();
          memoryBuilder_ = null;
        }
        action_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesResponse_GeneratedMemory_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory build() {
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory result =
            new com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.memory_ = memoryBuilder_ == null ? memory_ : memoryBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.action_ = action_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
                .getDefaultInstance()) return this;
        if (other.hasMemory()) {
          mergeMemory(other.getMemory());
        }
        if (other.action_ != 0) {
          setActionValue(other.getActionValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getMemoryFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  action_ = input.readEnum();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.aiplatform.v1beta1.Memory memory_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.Memory,
              com.google.cloud.aiplatform.v1beta1.Memory.Builder,
              com.google.cloud.aiplatform.v1beta1.MemoryOrBuilder>
          memoryBuilder_;

      /**
       *
       *
       * <pre>
       * The generated Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       *
       * @return Whether the memory field is set.
       */
      public boolean hasMemory() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The generated Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       *
       * @return The memory.
       */
      public com.google.cloud.aiplatform.v1beta1.Memory getMemory() {
        if (memoryBuilder_ == null) {
          return memory_ == null
              ? com.google.cloud.aiplatform.v1beta1.Memory.getDefaultInstance()
              : memory_;
        } else {
          return memoryBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The generated Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       */
      public Builder setMemory(com.google.cloud.aiplatform.v1beta1.Memory value) {
        if (memoryBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          memory_ = value;
        } else {
          memoryBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The generated Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       */
      public Builder setMemory(com.google.cloud.aiplatform.v1beta1.Memory.Builder builderForValue) {
        if (memoryBuilder_ == null) {
          memory_ = builderForValue.build();
        } else {
          memoryBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The generated Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       */
      public Builder mergeMemory(com.google.cloud.aiplatform.v1beta1.Memory value) {
        if (memoryBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && memory_ != null
              && memory_ != com.google.cloud.aiplatform.v1beta1.Memory.getDefaultInstance()) {
            getMemoryBuilder().mergeFrom(value);
          } else {
            memory_ = value;
          }
        } else {
          memoryBuilder_.mergeFrom(value);
        }
        if (memory_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The generated Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       */
      public Builder clearMemory() {
        bitField0_ = (bitField0_ & ~0x00000001);
        memory_ = null;
        if (memoryBuilder_ != null) {
          memoryBuilder_.dispose();
          memoryBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The generated Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.Memory.Builder getMemoryBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMemoryFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The generated Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.MemoryOrBuilder getMemoryOrBuilder() {
        if (memoryBuilder_ != null) {
          return memoryBuilder_.getMessageOrBuilder();
        } else {
          return memory_ == null
              ? com.google.cloud.aiplatform.v1beta1.Memory.getDefaultInstance()
              : memory_;
        }
      }

      /**
       *
       *
       * <pre>
       * The generated Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.Memory,
              com.google.cloud.aiplatform.v1beta1.Memory.Builder,
              com.google.cloud.aiplatform.v1beta1.MemoryOrBuilder>
          getMemoryFieldBuilder() {
        if (memoryBuilder_ == null) {
          memoryBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.Memory,
                  com.google.cloud.aiplatform.v1beta1.Memory.Builder,
                  com.google.cloud.aiplatform.v1beta1.MemoryOrBuilder>(
                  getMemory(), getParentForChildren(), isClean());
          memory_ = null;
        }
        return memoryBuilder_;
      }

      private int action_ = 0;

      /**
       *
       *
       * <pre>
       * The action that was performed on the Memory.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action action = 2;
       * </code>
       *
       * @return The enum numeric value on the wire for action.
       */
      @java.lang.Override
      public int getActionValue() {
        return action_;
      }

      /**
       *
       *
       * <pre>
       * The action that was performed on the Memory.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action action = 2;
       * </code>
       *
       * @param value The enum numeric value on the wire for action to set.
       * @return This builder for chaining.
       */
      public Builder setActionValue(int value) {
        action_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The action that was performed on the Memory.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action action = 2;
       * </code>
       *
       * @return The action.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action
          getAction() {
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action result =
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action
                .forNumber(action_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action
                .UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * The action that was performed on the Memory.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action action = 2;
       * </code>
       *
       * @param value The action to set.
       * @return This builder for chaining.
       */
      public Builder setAction(
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action
              value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000002;
        action_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The action that was performed on the Memory.
       * </pre>
       *
       * <code>
       * .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Action action = 2;
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAction() {
        bitField0_ = (bitField0_ & ~0x00000002);
        action_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory)
    private static final com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse
            .GeneratedMemory
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory();
    }

    public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<GeneratedMemory> PARSER =
        new com.google.protobuf.AbstractParser<GeneratedMemory>() {
          @java.lang.Override
          public GeneratedMemory parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<GeneratedMemory> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<GeneratedMemory> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int GENERATED_MEMORIES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory>
      generatedMemories_;

  /**
   *
   *
   * <pre>
   * The generated memories.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory>
      getGeneratedMemoriesList() {
    return generatedMemories_;
  }

  /**
   *
   *
   * <pre>
   * The generated memories.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemoryOrBuilder>
      getGeneratedMemoriesOrBuilderList() {
    return generatedMemories_;
  }

  /**
   *
   *
   * <pre>
   * The generated memories.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
   * </code>
   */
  @java.lang.Override
  public int getGeneratedMemoriesCount() {
    return generatedMemories_.size();
  }

  /**
   *
   *
   * <pre>
   * The generated memories.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
      getGeneratedMemories(int index) {
    return generatedMemories_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The generated memories.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemoryOrBuilder
      getGeneratedMemoriesOrBuilder(int index) {
    return generatedMemories_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < generatedMemories_.size(); i++) {
      output.writeMessage(1, generatedMemories_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < generatedMemories_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, generatedMemories_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse other =
        (com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse) obj;

    if (!getGeneratedMemoriesList().equals(other.getGeneratedMemoriesList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getGeneratedMemoriesCount() > 0) {
      hash = (37 * hash) + GENERATED_MEMORIES_FIELD_NUMBER;
      hash = (53 * hash) + getGeneratedMemoriesList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Response message for
   * [MemoryBankService.GenerateMemories][google.cloud.aiplatform.v1beta1.MemoryBankService.GenerateMemories].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse)
      com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.class,
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (generatedMemoriesBuilder_ == null) {
        generatedMemories_ = java.util.Collections.emptyList();
      } else {
        generatedMemories_ = null;
        generatedMemoriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_GenerateMemoriesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse build() {
      com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse buildPartial() {
      com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse result =
          new com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse result) {
      if (generatedMemoriesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          generatedMemories_ = java.util.Collections.unmodifiableList(generatedMemories_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.generatedMemories_ = generatedMemories_;
      } else {
        result.generatedMemories_ = generatedMemoriesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse result) {
      int from_bitField0_ = bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.getDefaultInstance())
        return this;
      if (generatedMemoriesBuilder_ == null) {
        if (!other.generatedMemories_.isEmpty()) {
          if (generatedMemories_.isEmpty()) {
            generatedMemories_ = other.generatedMemories_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureGeneratedMemoriesIsMutable();
            generatedMemories_.addAll(other.generatedMemories_);
          }
          onChanged();
        }
      } else {
        if (!other.generatedMemories_.isEmpty()) {
          if (generatedMemoriesBuilder_.isEmpty()) {
            generatedMemoriesBuilder_.dispose();
            generatedMemoriesBuilder_ = null;
            generatedMemories_ = other.generatedMemories_;
            bitField0_ = (bitField0_ & ~0x00000001);
            generatedMemoriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getGeneratedMemoriesFieldBuilder()
                    : null;
          } else {
            generatedMemoriesBuilder_.addAllMessages(other.generatedMemories_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
                            .parser(),
                        extensionRegistry);
                if (generatedMemoriesBuilder_ == null) {
                  ensureGeneratedMemoriesIsMutable();
                  generatedMemories_.add(m);
                } else {
                  generatedMemoriesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory>
        generatedMemories_ = java.util.Collections.emptyList();

    private void ensureGeneratedMemoriesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        generatedMemories_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory>(
                generatedMemories_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory,
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemoryOrBuilder>
        generatedMemoriesBuilder_;

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory>
        getGeneratedMemoriesList() {
      if (generatedMemoriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(generatedMemories_);
      } else {
        return generatedMemoriesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public int getGeneratedMemoriesCount() {
      if (generatedMemoriesBuilder_ == null) {
        return generatedMemories_.size();
      } else {
        return generatedMemoriesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
        getGeneratedMemories(int index) {
      if (generatedMemoriesBuilder_ == null) {
        return generatedMemories_.get(index);
      } else {
        return generatedMemoriesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public Builder setGeneratedMemories(
        int index,
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory value) {
      if (generatedMemoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGeneratedMemoriesIsMutable();
        generatedMemories_.set(index, value);
        onChanged();
      } else {
        generatedMemoriesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public Builder setGeneratedMemories(
        int index,
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Builder
            builderForValue) {
      if (generatedMemoriesBuilder_ == null) {
        ensureGeneratedMemoriesIsMutable();
        generatedMemories_.set(index, builderForValue.build());
        onChanged();
      } else {
        generatedMemoriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public Builder addGeneratedMemories(
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory value) {
      if (generatedMemoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGeneratedMemoriesIsMutable();
        generatedMemories_.add(value);
        onChanged();
      } else {
        generatedMemoriesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public Builder addGeneratedMemories(
        int index,
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory value) {
      if (generatedMemoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureGeneratedMemoriesIsMutable();
        generatedMemories_.add(index, value);
        onChanged();
      } else {
        generatedMemoriesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public Builder addGeneratedMemories(
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Builder
            builderForValue) {
      if (generatedMemoriesBuilder_ == null) {
        ensureGeneratedMemoriesIsMutable();
        generatedMemories_.add(builderForValue.build());
        onChanged();
      } else {
        generatedMemoriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public Builder addGeneratedMemories(
        int index,
        com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Builder
            builderForValue) {
      if (generatedMemoriesBuilder_ == null) {
        ensureGeneratedMemoriesIsMutable();
        generatedMemories_.add(index, builderForValue.build());
        onChanged();
      } else {
        generatedMemoriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public Builder addAllGeneratedMemories(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory>
            values) {
      if (generatedMemoriesBuilder_ == null) {
        ensureGeneratedMemoriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, generatedMemories_);
        onChanged();
      } else {
        generatedMemoriesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public Builder clearGeneratedMemories() {
      if (generatedMemoriesBuilder_ == null) {
        generatedMemories_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        generatedMemoriesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public Builder removeGeneratedMemories(int index) {
      if (generatedMemoriesBuilder_ == null) {
        ensureGeneratedMemoriesIsMutable();
        generatedMemories_.remove(index);
        onChanged();
      } else {
        generatedMemoriesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Builder
        getGeneratedMemoriesBuilder(int index) {
      return getGeneratedMemoriesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemoryOrBuilder
        getGeneratedMemoriesOrBuilder(int index) {
      if (generatedMemoriesBuilder_ == null) {
        return generatedMemories_.get(index);
      } else {
        return generatedMemoriesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse
                    .GeneratedMemoryOrBuilder>
        getGeneratedMemoriesOrBuilderList() {
      if (generatedMemoriesBuilder_ != null) {
        return generatedMemoriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(generatedMemories_);
      }
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Builder
        addGeneratedMemoriesBuilder() {
      return getGeneratedMemoriesFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Builder
        addGeneratedMemoriesBuilder(int index) {
      return getGeneratedMemoriesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The generated memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory generated_memories = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Builder>
        getGeneratedMemoriesBuilderList() {
      return getGeneratedMemoriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory,
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory.Builder,
            com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemoryOrBuilder>
        getGeneratedMemoriesFieldBuilder() {
      if (generatedMemoriesBuilder_ == null) {
        generatedMemoriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory,
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse.GeneratedMemory
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse
                    .GeneratedMemoryOrBuilder>(
                generatedMemories_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        generatedMemories_ = null;
      }
      return generatedMemoriesBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse)
  private static final com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse();
  }

  public static com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<GenerateMemoriesResponse> PARSER =
      new com.google.protobuf.AbstractParser<GenerateMemoriesResponse>() {
        @java.lang.Override
        public GenerateMemoriesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<GenerateMemoriesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<GenerateMemoriesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.GenerateMemoriesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
