/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/feature_online_store_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * A query to find a number of similar entities.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.NearestNeighborQuery}
 */
public final class NearestNeighborQuery extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NearestNeighborQuery)
    NearestNeighborQueryOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use NearestNeighborQuery.newBuilder() to construct.
  private NearestNeighborQuery(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private NearestNeighborQuery() {
    stringFilters_ = java.util.Collections.emptyList();
    numericFilters_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new NearestNeighborQuery();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.class,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Builder.class);
  }

  public interface EmbeddingOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. Individual value in the embedding.
     * </pre>
     *
     * <code>repeated float value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the value.
     */
    java.util.List<java.lang.Float> getValueList();

    /**
     *
     *
     * <pre>
     * Optional. Individual value in the embedding.
     * </pre>
     *
     * <code>repeated float value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of value.
     */
    int getValueCount();

    /**
     *
     *
     * <pre>
     * Optional. Individual value in the embedding.
     * </pre>
     *
     * <code>repeated float value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The value at the given index.
     */
    float getValue(int index);
  }

  /**
   *
   *
   * <pre>
   * The embedding vector.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding}
   */
  public static final class Embedding extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding)
      EmbeddingOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Embedding.newBuilder() to construct.
    private Embedding(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Embedding() {
      value_ = emptyFloatList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Embedding();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_Embedding_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_Embedding_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding.class,
              com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding.Builder.class);
    }

    public static final int VALUE_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private com.google.protobuf.Internal.FloatList value_ = emptyFloatList();

    /**
     *
     *
     * <pre>
     * Optional. Individual value in the embedding.
     * </pre>
     *
     * <code>repeated float value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the value.
     */
    @java.lang.Override
    public java.util.List<java.lang.Float> getValueList() {
      return value_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Individual value in the embedding.
     * </pre>
     *
     * <code>repeated float value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of value.
     */
    public int getValueCount() {
      return value_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. Individual value in the embedding.
     * </pre>
     *
     * <code>repeated float value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The value at the given index.
     */
    public float getValue(int index) {
      return value_.getFloat(index);
    }

    private int valueMemoizedSerializedSize = -1;

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      getSerializedSize();
      if (getValueList().size() > 0) {
        output.writeUInt32NoTag(10);
        output.writeUInt32NoTag(valueMemoizedSerializedSize);
      }
      for (int i = 0; i < value_.size(); i++) {
        output.writeFloatNoTag(value_.getFloat(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      {
        int dataSize = 0;
        dataSize = 4 * getValueList().size();
        size += dataSize;
        if (!getValueList().isEmpty()) {
          size += 1;
          size += com.google.protobuf.CodedOutputStream.computeInt32SizeNoTag(dataSize);
        }
        valueMemoizedSerializedSize = dataSize;
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding other =
          (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding) obj;

      if (!getValueList().equals(other.getValueList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (getValueCount() > 0) {
        hash = (37 * hash) + VALUE_FIELD_NUMBER;
        hash = (53 * hash) + getValueList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * The embedding vector.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding)
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.EmbeddingOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_Embedding_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_Embedding_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding.class,
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        value_ = emptyFloatList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_Embedding_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding build() {
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding buildPartial() {
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding result =
            new com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          value_.makeImmutable();
          result.value_ = value_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding
                .getDefaultInstance()) return this;
        if (!other.value_.isEmpty()) {
          if (value_.isEmpty()) {
            value_ = other.value_;
            value_.makeImmutable();
            bitField0_ |= 0x00000001;
          } else {
            ensureValueIsMutable();
            value_.addAll(other.value_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 13:
                {
                  float v = input.readFloat();
                  ensureValueIsMutable();
                  value_.addFloat(v);
                  break;
                } // case 13
              case 10:
                {
                  int length = input.readRawVarint32();
                  int limit = input.pushLimit(length);
                  int alloc = length > 4096 ? 4096 : length;
                  ensureValueIsMutable(alloc / 4);
                  while (input.getBytesUntilLimit() > 0) {
                    value_.addFloat(input.readFloat());
                  }
                  input.popLimit(limit);
                  break;
                } // case 10
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.Internal.FloatList value_ = emptyFloatList();

      private void ensureValueIsMutable() {
        if (!value_.isModifiable()) {
          value_ = makeMutableCopy(value_);
        }
        bitField0_ |= 0x00000001;
      }

      private void ensureValueIsMutable(int capacity) {
        if (!value_.isModifiable()) {
          value_ = makeMutableCopy(value_, capacity);
        }
        bitField0_ |= 0x00000001;
      }

      /**
       *
       *
       * <pre>
       * Optional. Individual value in the embedding.
       * </pre>
       *
       * <code>repeated float value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the value.
       */
      public java.util.List<java.lang.Float> getValueList() {
        value_.makeImmutable();
        return value_;
      }

      /**
       *
       *
       * <pre>
       * Optional. Individual value in the embedding.
       * </pre>
       *
       * <code>repeated float value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of value.
       */
      public int getValueCount() {
        return value_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. Individual value in the embedding.
       * </pre>
       *
       * <code>repeated float value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The value at the given index.
       */
      public float getValue(int index) {
        return value_.getFloat(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. Individual value in the embedding.
       * </pre>
       *
       * <code>repeated float value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(int index, float value) {

        ensureValueIsMutable();
        value_.setFloat(index, value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Individual value in the embedding.
       * </pre>
       *
       * <code>repeated float value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The value to add.
       * @return This builder for chaining.
       */
      public Builder addValue(float value) {

        ensureValueIsMutable();
        value_.addFloat(value);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Individual value in the embedding.
       * </pre>
       *
       * <code>repeated float value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The value to add.
       * @return This builder for chaining.
       */
      public Builder addAllValue(java.lang.Iterable<? extends java.lang.Float> values) {
        ensureValueIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, value_);
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. Individual value in the embedding.
       * </pre>
       *
       * <code>repeated float value = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {
        value_ = emptyFloatList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding)
    private static final com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding();
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Embedding> PARSER =
        new com.google.protobuf.AbstractParser<Embedding>() {
          @java.lang.Override
          public Embedding parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Embedding> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Embedding> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface StringFilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Column names in BigQuery that used as filters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();

    /**
     *
     *
     * <pre>
     * Required. Column names in BigQuery that used as filters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Optional. The allowed tokens.
     * </pre>
     *
     * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the allowTokens.
     */
    java.util.List<java.lang.String> getAllowTokensList();

    /**
     *
     *
     * <pre>
     * Optional. The allowed tokens.
     * </pre>
     *
     * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of allowTokens.
     */
    int getAllowTokensCount();

    /**
     *
     *
     * <pre>
     * Optional. The allowed tokens.
     * </pre>
     *
     * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The allowTokens at the given index.
     */
    java.lang.String getAllowTokens(int index);

    /**
     *
     *
     * <pre>
     * Optional. The allowed tokens.
     * </pre>
     *
     * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowTokens at the given index.
     */
    com.google.protobuf.ByteString getAllowTokensBytes(int index);

    /**
     *
     *
     * <pre>
     * Optional. The denied tokens.
     * </pre>
     *
     * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the denyTokens.
     */
    java.util.List<java.lang.String> getDenyTokensList();

    /**
     *
     *
     * <pre>
     * Optional. The denied tokens.
     * </pre>
     *
     * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of denyTokens.
     */
    int getDenyTokensCount();

    /**
     *
     *
     * <pre>
     * Optional. The denied tokens.
     * </pre>
     *
     * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The denyTokens at the given index.
     */
    java.lang.String getDenyTokens(int index);

    /**
     *
     *
     * <pre>
     * Optional. The denied tokens.
     * </pre>
     *
     * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the denyTokens at the given index.
     */
    com.google.protobuf.ByteString getDenyTokensBytes(int index);
  }

  /**
   *
   *
   * <pre>
   * String filter is used to search a subset of the entities by using boolean
   * rules on string columns.
   * For example: if a query specifies string filter
   * with 'name = color, allow_tokens = {red, blue}, deny_tokens = {purple}','
   * then that query will match entities that are red or blue, but if those
   * points are also purple, then they will be excluded even if they are
   * red/blue. Only string filter is supported for now, numeric filter will be
   * supported in the near future.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter}
   */
  public static final class StringFilter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter)
      StringFilterOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use StringFilter.newBuilder() to construct.
    private StringFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private StringFilter() {
      name_ = "";
      allowTokens_ = com.google.protobuf.LazyStringArrayList.emptyList();
      denyTokens_ = com.google.protobuf.LazyStringArrayList.emptyList();
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new StringFilter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_StringFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_StringFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter.class,
              com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter.Builder.class);
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. Column names in BigQuery that used as filters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Column names in BigQuery that used as filters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int ALLOW_TOKENS_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList allowTokens_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Optional. The allowed tokens.
     * </pre>
     *
     * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the allowTokens.
     */
    public com.google.protobuf.ProtocolStringList getAllowTokensList() {
      return allowTokens_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The allowed tokens.
     * </pre>
     *
     * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of allowTokens.
     */
    public int getAllowTokensCount() {
      return allowTokens_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The allowed tokens.
     * </pre>
     *
     * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The allowTokens at the given index.
     */
    public java.lang.String getAllowTokens(int index) {
      return allowTokens_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The allowed tokens.
     * </pre>
     *
     * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowTokens at the given index.
     */
    public com.google.protobuf.ByteString getAllowTokensBytes(int index) {
      return allowTokens_.getByteString(index);
    }

    public static final int DENY_TOKENS_FIELD_NUMBER = 3;

    @SuppressWarnings("serial")
    private com.google.protobuf.LazyStringArrayList denyTokens_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    /**
     *
     *
     * <pre>
     * Optional. The denied tokens.
     * </pre>
     *
     * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return A list containing the denyTokens.
     */
    public com.google.protobuf.ProtocolStringList getDenyTokensList() {
      return denyTokens_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The denied tokens.
     * </pre>
     *
     * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The count of denyTokens.
     */
    public int getDenyTokensCount() {
      return denyTokens_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The denied tokens.
     * </pre>
     *
     * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the element to return.
     * @return The denyTokens at the given index.
     */
    public java.lang.String getDenyTokens(int index) {
      return denyTokens_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The denied tokens.
     * </pre>
     *
     * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the denyTokens at the given index.
     */
    public com.google.protobuf.ByteString getDenyTokensBytes(int index) {
      return denyTokens_.getByteString(index);
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      for (int i = 0; i < allowTokens_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, allowTokens_.getRaw(i));
      }
      for (int i = 0; i < denyTokens_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 3, denyTokens_.getRaw(i));
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < allowTokens_.size(); i++) {
          dataSize += computeStringSizeNoTag(allowTokens_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getAllowTokensList().size();
      }
      {
        int dataSize = 0;
        for (int i = 0; i < denyTokens_.size(); i++) {
          dataSize += computeStringSizeNoTag(denyTokens_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getDenyTokensList().size();
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter other =
          (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter) obj;

      if (!getName().equals(other.getName())) return false;
      if (!getAllowTokensList().equals(other.getAllowTokensList())) return false;
      if (!getDenyTokensList().equals(other.getDenyTokensList())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (getAllowTokensCount() > 0) {
        hash = (37 * hash) + ALLOW_TOKENS_FIELD_NUMBER;
        hash = (53 * hash) + getAllowTokensList().hashCode();
      }
      if (getDenyTokensCount() > 0) {
        hash = (37 * hash) + DENY_TOKENS_FIELD_NUMBER;
        hash = (53 * hash) + getDenyTokensList().hashCode();
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * String filter is used to search a subset of the entities by using boolean
     * rules on string columns.
     * For example: if a query specifies string filter
     * with 'name = color, allow_tokens = {red, blue}, deny_tokens = {purple}','
     * then that query will match entities that are red or blue, but if those
     * points are also purple, then they will be excluded even if they are
     * red/blue. Only string filter is supported for now, numeric filter will be
     * supported in the near future.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter)
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_StringFilter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_StringFilter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter.class,
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        allowTokens_ = com.google.protobuf.LazyStringArrayList.emptyList();
        denyTokens_ = com.google.protobuf.LazyStringArrayList.emptyList();
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_StringFilter_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter build() {
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter buildPartial() {
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter result =
            new com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.name_ = name_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          allowTokens_.makeImmutable();
          result.allowTokens_ = allowTokens_;
        }
        if (((from_bitField0_ & 0x00000004) != 0)) {
          denyTokens_.makeImmutable();
          result.denyTokens_ = denyTokens_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (!other.allowTokens_.isEmpty()) {
          if (allowTokens_.isEmpty()) {
            allowTokens_ = other.allowTokens_;
            bitField0_ |= 0x00000002;
          } else {
            ensureAllowTokensIsMutable();
            allowTokens_.addAll(other.allowTokens_);
          }
          onChanged();
        }
        if (!other.denyTokens_.isEmpty()) {
          if (denyTokens_.isEmpty()) {
            denyTokens_ = other.denyTokens_;
            bitField0_ |= 0x00000004;
          } else {
            ensureDenyTokensIsMutable();
            denyTokens_.addAll(other.denyTokens_);
          }
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 18:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureAllowTokensIsMutable();
                  allowTokens_.add(s);
                  break;
                } // case 18
              case 26:
                {
                  java.lang.String s = input.readStringRequireUtf8();
                  ensureDenyTokensIsMutable();
                  denyTokens_.add(s);
                  break;
                } // case 26
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object name_ = "";

      /**
       *
       *
       * <pre>
       * Required. Column names in BigQuery that used as filters.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Column names in BigQuery that used as filters.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Column names in BigQuery that used as filters.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Column names in BigQuery that used as filters.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Column names in BigQuery that used as filters.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList allowTokens_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureAllowTokensIsMutable() {
        if (!allowTokens_.isModifiable()) {
          allowTokens_ = new com.google.protobuf.LazyStringArrayList(allowTokens_);
        }
        bitField0_ |= 0x00000002;
      }

      /**
       *
       *
       * <pre>
       * Optional. The allowed tokens.
       * </pre>
       *
       * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the allowTokens.
       */
      public com.google.protobuf.ProtocolStringList getAllowTokensList() {
        allowTokens_.makeImmutable();
        return allowTokens_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The allowed tokens.
       * </pre>
       *
       * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of allowTokens.
       */
      public int getAllowTokensCount() {
        return allowTokens_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. The allowed tokens.
       * </pre>
       *
       * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The allowTokens at the given index.
       */
      public java.lang.String getAllowTokens(int index) {
        return allowTokens_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. The allowed tokens.
       * </pre>
       *
       * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the allowTokens at the given index.
       */
      public com.google.protobuf.ByteString getAllowTokensBytes(int index) {
        return allowTokens_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. The allowed tokens.
       * </pre>
       *
       * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The allowTokens to set.
       * @return This builder for chaining.
       */
      public Builder setAllowTokens(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowTokensIsMutable();
        allowTokens_.set(index, value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The allowed tokens.
       * </pre>
       *
       * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The allowTokens to add.
       * @return This builder for chaining.
       */
      public Builder addAllowTokens(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureAllowTokensIsMutable();
        allowTokens_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The allowed tokens.
       * </pre>
       *
       * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The allowTokens to add.
       * @return This builder for chaining.
       */
      public Builder addAllAllowTokens(java.lang.Iterable<java.lang.String> values) {
        ensureAllowTokensIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowTokens_);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The allowed tokens.
       * </pre>
       *
       * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearAllowTokens() {
        allowTokens_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000002);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The allowed tokens.
       * </pre>
       *
       * <code>repeated string allow_tokens = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the allowTokens to add.
       * @return This builder for chaining.
       */
      public Builder addAllowTokensBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureAllowTokensIsMutable();
        allowTokens_.add(value);
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringArrayList denyTokens_ =
          com.google.protobuf.LazyStringArrayList.emptyList();

      private void ensureDenyTokensIsMutable() {
        if (!denyTokens_.isModifiable()) {
          denyTokens_ = new com.google.protobuf.LazyStringArrayList(denyTokens_);
        }
        bitField0_ |= 0x00000004;
      }

      /**
       *
       *
       * <pre>
       * Optional. The denied tokens.
       * </pre>
       *
       * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return A list containing the denyTokens.
       */
      public com.google.protobuf.ProtocolStringList getDenyTokensList() {
        denyTokens_.makeImmutable();
        return denyTokens_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The denied tokens.
       * </pre>
       *
       * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The count of denyTokens.
       */
      public int getDenyTokensCount() {
        return denyTokens_.size();
      }

      /**
       *
       *
       * <pre>
       * Optional. The denied tokens.
       * </pre>
       *
       * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the element to return.
       * @return The denyTokens at the given index.
       */
      public java.lang.String getDenyTokens(int index) {
        return denyTokens_.get(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. The denied tokens.
       * </pre>
       *
       * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the denyTokens at the given index.
       */
      public com.google.protobuf.ByteString getDenyTokensBytes(int index) {
        return denyTokens_.getByteString(index);
      }

      /**
       *
       *
       * <pre>
       * Optional. The denied tokens.
       * </pre>
       *
       * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param index The index to set the value at.
       * @param value The denyTokens to set.
       * @return This builder for chaining.
       */
      public Builder setDenyTokens(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDenyTokensIsMutable();
        denyTokens_.set(index, value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The denied tokens.
       * </pre>
       *
       * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The denyTokens to add.
       * @return This builder for chaining.
       */
      public Builder addDenyTokens(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureDenyTokensIsMutable();
        denyTokens_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The denied tokens.
       * </pre>
       *
       * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param values The denyTokens to add.
       * @return This builder for chaining.
       */
      public Builder addAllDenyTokens(java.lang.Iterable<java.lang.String> values) {
        ensureDenyTokensIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, denyTokens_);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The denied tokens.
       * </pre>
       *
       * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDenyTokens() {
        denyTokens_ = com.google.protobuf.LazyStringArrayList.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        ;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The denied tokens.
       * </pre>
       *
       * <code>repeated string deny_tokens = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes of the denyTokens to add.
       * @return This builder for chaining.
       */
      public Builder addDenyTokensBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureDenyTokensIsMutable();
        denyTokens_.add(value);
        bitField0_ |= 0x00000004;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter)
    private static final com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter();
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<StringFilter> PARSER =
        new com.google.protobuf.AbstractParser<StringFilter>() {
          @java.lang.Override
          public StringFilter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<StringFilter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<StringFilter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface NumericFilterOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * int value type.
     * </pre>
     *
     * <code>int64 value_int = 2;</code>
     *
     * @return Whether the valueInt field is set.
     */
    boolean hasValueInt();

    /**
     *
     *
     * <pre>
     * int value type.
     * </pre>
     *
     * <code>int64 value_int = 2;</code>
     *
     * @return The valueInt.
     */
    long getValueInt();

    /**
     *
     *
     * <pre>
     * float value type.
     * </pre>
     *
     * <code>float value_float = 3;</code>
     *
     * @return Whether the valueFloat field is set.
     */
    boolean hasValueFloat();

    /**
     *
     *
     * <pre>
     * float value type.
     * </pre>
     *
     * <code>float value_float = 3;</code>
     *
     * @return The valueFloat.
     */
    float getValueFloat();

    /**
     *
     *
     * <pre>
     * double value type.
     * </pre>
     *
     * <code>double value_double = 4;</code>
     *
     * @return Whether the valueDouble field is set.
     */
    boolean hasValueDouble();

    /**
     *
     *
     * <pre>
     * double value type.
     * </pre>
     *
     * <code>double value_double = 4;</code>
     *
     * @return The valueDouble.
     */
    double getValueDouble();

    /**
     *
     *
     * <pre>
     * Required. Column name in BigQuery that used as filters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    java.lang.String getName();

    /**
     *
     *
     * <pre>
     * Required. Column name in BigQuery that used as filters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    com.google.protobuf.ByteString getNameBytes();

    /**
     *
     *
     * <pre>
     * Optional. This MUST be specified for queries and must NOT be specified
     * for database points.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator op = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the op field is set.
     */
    boolean hasOp();

    /**
     *
     *
     * <pre>
     * Optional. This MUST be specified for queries and must NOT be specified
     * for database points.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator op = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for op.
     */
    int getOpValue();

    /**
     *
     *
     * <pre>
     * Optional. This MUST be specified for queries and must NOT be specified
     * for database points.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator op = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The op.
     */
    com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator getOp();

    com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.ValueCase getValueCase();
  }

  /**
   *
   *
   * <pre>
   * Numeric filter is used to search a subset of the entities by using boolean
   * rules on numeric columns.
   * For example:
   * Database Point 0: {name: “a” value_int: 42} {name: “b” value_float: 1.0}
   * Database Point 1:  {name: “a” value_int: 10} {name: “b” value_float: 2.0}
   * Database Point 2: {name: “a” value_int: -1} {name: “b” value_float: 3.0}
   * Query: {name: “a” value_int: 12 operator: LESS}    // Matches Point 1, 2
   * {name: “b” value_float: 2.0 operator: EQUAL} // Matches Point 1
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter}
   */
  public static final class NumericFilter extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter)
      NumericFilterOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use NumericFilter.newBuilder() to construct.
    private NumericFilter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private NumericFilter() {
      name_ = "";
      op_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new NumericFilter();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_NumericFilter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_NumericFilter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.class,
              com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Builder.class);
    }

    /**
     *
     *
     * <pre>
     * Datapoints for which Operator is true relative to the query’s Value
     * field will be allowlisted.
     * </pre>
     *
     * Protobuf enum {@code
     * google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator}
     */
    public enum Operator implements com.google.protobuf.ProtocolMessageEnum {
      /**
       *
       *
       * <pre>
       * Unspecified operator.
       * </pre>
       *
       * <code>OPERATOR_UNSPECIFIED = 0;</code>
       */
      OPERATOR_UNSPECIFIED(0),
      /**
       *
       *
       * <pre>
       * Entities are eligible if their value is &lt; the query's.
       * </pre>
       *
       * <code>LESS = 1;</code>
       */
      LESS(1),
      /**
       *
       *
       * <pre>
       * Entities are eligible if their value is &lt;= the query's.
       * </pre>
       *
       * <code>LESS_EQUAL = 2;</code>
       */
      LESS_EQUAL(2),
      /**
       *
       *
       * <pre>
       * Entities are eligible if their value is == the query's.
       * </pre>
       *
       * <code>EQUAL = 3;</code>
       */
      EQUAL(3),
      /**
       *
       *
       * <pre>
       * Entities are eligible if their value is &gt;= the query's.
       * </pre>
       *
       * <code>GREATER_EQUAL = 4;</code>
       */
      GREATER_EQUAL(4),
      /**
       *
       *
       * <pre>
       * Entities are eligible if their value is &gt; the query's.
       * </pre>
       *
       * <code>GREATER = 5;</code>
       */
      GREATER(5),
      /**
       *
       *
       * <pre>
       * Entities are eligible if their value is != the query's.
       * </pre>
       *
       * <code>NOT_EQUAL = 6;</code>
       */
      NOT_EQUAL(6),
      UNRECOGNIZED(-1),
      ;

      /**
       *
       *
       * <pre>
       * Unspecified operator.
       * </pre>
       *
       * <code>OPERATOR_UNSPECIFIED = 0;</code>
       */
      public static final int OPERATOR_UNSPECIFIED_VALUE = 0;

      /**
       *
       *
       * <pre>
       * Entities are eligible if their value is &lt; the query's.
       * </pre>
       *
       * <code>LESS = 1;</code>
       */
      public static final int LESS_VALUE = 1;

      /**
       *
       *
       * <pre>
       * Entities are eligible if their value is &lt;= the query's.
       * </pre>
       *
       * <code>LESS_EQUAL = 2;</code>
       */
      public static final int LESS_EQUAL_VALUE = 2;

      /**
       *
       *
       * <pre>
       * Entities are eligible if their value is == the query's.
       * </pre>
       *
       * <code>EQUAL = 3;</code>
       */
      public static final int EQUAL_VALUE = 3;

      /**
       *
       *
       * <pre>
       * Entities are eligible if their value is &gt;= the query's.
       * </pre>
       *
       * <code>GREATER_EQUAL = 4;</code>
       */
      public static final int GREATER_EQUAL_VALUE = 4;

      /**
       *
       *
       * <pre>
       * Entities are eligible if their value is &gt; the query's.
       * </pre>
       *
       * <code>GREATER = 5;</code>
       */
      public static final int GREATER_VALUE = 5;

      /**
       *
       *
       * <pre>
       * Entities are eligible if their value is != the query's.
       * </pre>
       *
       * <code>NOT_EQUAL = 6;</code>
       */
      public static final int NOT_EQUAL_VALUE = 6;

      public final int getNumber() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalArgumentException(
              "Can't get the number of an unknown enum value.");
        }
        return value;
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static Operator valueOf(int value) {
        return forNumber(value);
      }

      /**
       * @param value The numeric wire value of the corresponding enum entry.
       * @return The enum associated with the given numeric wire value.
       */
      public static Operator forNumber(int value) {
        switch (value) {
          case 0:
            return OPERATOR_UNSPECIFIED;
          case 1:
            return LESS;
          case 2:
            return LESS_EQUAL;
          case 3:
            return EQUAL;
          case 4:
            return GREATER_EQUAL;
          case 5:
            return GREATER;
          case 6:
            return NOT_EQUAL;
          default:
            return null;
        }
      }

      public static com.google.protobuf.Internal.EnumLiteMap<Operator> internalGetValueMap() {
        return internalValueMap;
      }

      private static final com.google.protobuf.Internal.EnumLiteMap<Operator> internalValueMap =
          new com.google.protobuf.Internal.EnumLiteMap<Operator>() {
            public Operator findValueByNumber(int number) {
              return Operator.forNumber(number);
            }
          };

      public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
        if (this == UNRECOGNIZED) {
          throw new java.lang.IllegalStateException(
              "Can't get the descriptor of an unrecognized enum value.");
        }
        return getDescriptor().getValues().get(ordinal());
      }

      public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
        return getDescriptor();
      }

      public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter
            .getDescriptor()
            .getEnumTypes()
            .get(0);
      }

      private static final Operator[] VALUES = values();

      public static Operator valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
        if (desc.getType() != getDescriptor()) {
          throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
        }
        if (desc.getIndex() == -1) {
          return UNRECOGNIZED;
        }
        return VALUES[desc.getIndex()];
      }

      private final int value;

      private Operator(int value) {
        this.value = value;
      }

      // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator)
    }

    private int bitField0_;
    private int valueCase_ = 0;

    @SuppressWarnings("serial")
    private java.lang.Object value_;

    public enum ValueCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      VALUE_INT(2),
      VALUE_FLOAT(3),
      VALUE_DOUBLE(4),
      VALUE_NOT_SET(0);
      private final int value;

      private ValueCase(int value) {
        this.value = value;
      }

      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static ValueCase valueOf(int value) {
        return forNumber(value);
      }

      public static ValueCase forNumber(int value) {
        switch (value) {
          case 2:
            return VALUE_INT;
          case 3:
            return VALUE_FLOAT;
          case 4:
            return VALUE_DOUBLE;
          case 0:
            return VALUE_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public ValueCase getValueCase() {
      return ValueCase.forNumber(valueCase_);
    }

    public static final int VALUE_INT_FIELD_NUMBER = 2;

    /**
     *
     *
     * <pre>
     * int value type.
     * </pre>
     *
     * <code>int64 value_int = 2;</code>
     *
     * @return Whether the valueInt field is set.
     */
    @java.lang.Override
    public boolean hasValueInt() {
      return valueCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * int value type.
     * </pre>
     *
     * <code>int64 value_int = 2;</code>
     *
     * @return The valueInt.
     */
    @java.lang.Override
    public long getValueInt() {
      if (valueCase_ == 2) {
        return (java.lang.Long) value_;
      }
      return 0L;
    }

    public static final int VALUE_FLOAT_FIELD_NUMBER = 3;

    /**
     *
     *
     * <pre>
     * float value type.
     * </pre>
     *
     * <code>float value_float = 3;</code>
     *
     * @return Whether the valueFloat field is set.
     */
    @java.lang.Override
    public boolean hasValueFloat() {
      return valueCase_ == 3;
    }

    /**
     *
     *
     * <pre>
     * float value type.
     * </pre>
     *
     * <code>float value_float = 3;</code>
     *
     * @return The valueFloat.
     */
    @java.lang.Override
    public float getValueFloat() {
      if (valueCase_ == 3) {
        return (java.lang.Float) value_;
      }
      return 0F;
    }

    public static final int VALUE_DOUBLE_FIELD_NUMBER = 4;

    /**
     *
     *
     * <pre>
     * double value type.
     * </pre>
     *
     * <code>double value_double = 4;</code>
     *
     * @return Whether the valueDouble field is set.
     */
    @java.lang.Override
    public boolean hasValueDouble() {
      return valueCase_ == 4;
    }

    /**
     *
     *
     * <pre>
     * double value type.
     * </pre>
     *
     * <code>double value_double = 4;</code>
     *
     * @return The valueDouble.
     */
    @java.lang.Override
    public double getValueDouble() {
      if (valueCase_ == 4) {
        return (java.lang.Double) value_;
      }
      return 0D;
    }

    public static final int NAME_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. Column name in BigQuery that used as filters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    @java.lang.Override
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Column name in BigQuery that used as filters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int OP_FIELD_NUMBER = 5;
    private int op_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. This MUST be specified for queries and must NOT be specified
     * for database points.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator op = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the op field is set.
     */
    @java.lang.Override
    public boolean hasOp() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. This MUST be specified for queries and must NOT be specified
     * for database points.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator op = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for op.
     */
    @java.lang.Override
    public int getOpValue() {
      return op_;
    }

    /**
     *
     *
     * <pre>
     * Optional. This MUST be specified for queries and must NOT be specified
     * for database points.
     * </pre>
     *
     * <code>
     * optional .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator op = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The op.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator getOp() {
      com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator result =
          com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator.forNumber(
              op_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator
              .UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
      }
      if (valueCase_ == 2) {
        output.writeInt64(2, (long) ((java.lang.Long) value_));
      }
      if (valueCase_ == 3) {
        output.writeFloat(3, (float) ((java.lang.Float) value_));
      }
      if (valueCase_ == 4) {
        output.writeDouble(4, (double) ((java.lang.Double) value_));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeEnum(5, op_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
      }
      if (valueCase_ == 2) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt64Size(
                2, (long) ((java.lang.Long) value_));
      }
      if (valueCase_ == 3) {
        size +=
            com.google.protobuf.CodedOutputStream.computeFloatSize(
                3, (float) ((java.lang.Float) value_));
      }
      if (valueCase_ == 4) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(
                4, (double) ((java.lang.Double) value_));
      }
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, op_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter other =
          (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter) obj;

      if (!getName().equals(other.getName())) return false;
      if (hasOp() != other.hasOp()) return false;
      if (hasOp()) {
        if (op_ != other.op_) return false;
      }
      if (!getValueCase().equals(other.getValueCase())) return false;
      switch (valueCase_) {
        case 2:
          if (getValueInt() != other.getValueInt()) return false;
          break;
        case 3:
          if (java.lang.Float.floatToIntBits(getValueFloat())
              != java.lang.Float.floatToIntBits(other.getValueFloat())) return false;
          break;
        case 4:
          if (java.lang.Double.doubleToLongBits(getValueDouble())
              != java.lang.Double.doubleToLongBits(other.getValueDouble())) return false;
          break;
        case 0:
        default:
      }
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
      if (hasOp()) {
        hash = (37 * hash) + OP_FIELD_NUMBER;
        hash = (53 * hash) + op_;
      }
      switch (valueCase_) {
        case 2:
          hash = (37 * hash) + VALUE_INT_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getValueInt());
          break;
        case 3:
          hash = (37 * hash) + VALUE_FLOAT_FIELD_NUMBER;
          hash = (53 * hash) + java.lang.Float.floatToIntBits(getValueFloat());
          break;
        case 4:
          hash = (37 * hash) + VALUE_DOUBLE_FIELD_NUMBER;
          hash =
              (53 * hash)
                  + com.google.protobuf.Internal.hashLong(
                      java.lang.Double.doubleToLongBits(getValueDouble()));
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Numeric filter is used to search a subset of the entities by using boolean
     * rules on numeric columns.
     * For example:
     * Database Point 0: {name: “a” value_int: 42} {name: “b” value_float: 1.0}
     * Database Point 1:  {name: “a” value_int: 10} {name: “b” value_float: 2.0}
     * Database Point 2: {name: “a” value_int: -1} {name: “b” value_float: 3.0}
     * Query: {name: “a” value_int: 12 operator: LESS}    // Matches Point 1, 2
     * {name: “b” value_float: 2.0 operator: EQUAL} // Matches Point 1
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter)
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilterOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_NumericFilter_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_NumericFilter_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.class,
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        name_ = "";
        op_ = 0;
        valueCase_ = 0;
        value_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_NumericFilter_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter build() {
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter buildPartial() {
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter result =
            new com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        buildPartialOneofs(result);
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000008) != 0)) {
          result.name_ = name_;
        }
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000010) != 0)) {
          result.op_ = op_;
          to_bitField0_ |= 0x00000001;
        }
        result.bitField0_ |= to_bitField0_;
      }

      private void buildPartialOneofs(
          com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter result) {
        result.valueCase_ = valueCase_;
        result.value_ = this.value_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter
                .getDefaultInstance()) return this;
        if (!other.getName().isEmpty()) {
          name_ = other.name_;
          bitField0_ |= 0x00000008;
          onChanged();
        }
        if (other.hasOp()) {
          setOp(other.getOp());
        }
        switch (other.getValueCase()) {
          case VALUE_INT:
            {
              setValueInt(other.getValueInt());
              break;
            }
          case VALUE_FLOAT:
            {
              setValueFloat(other.getValueFloat());
              break;
            }
          case VALUE_DOUBLE:
            {
              setValueDouble(other.getValueDouble());
              break;
            }
          case VALUE_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  name_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000008;
                  break;
                } // case 10
              case 16:
                {
                  value_ = input.readInt64();
                  valueCase_ = 2;
                  break;
                } // case 16
              case 29:
                {
                  value_ = input.readFloat();
                  valueCase_ = 3;
                  break;
                } // case 29
              case 33:
                {
                  value_ = input.readDouble();
                  valueCase_ = 4;
                  break;
                } // case 33
              case 40:
                {
                  op_ = input.readEnum();
                  bitField0_ |= 0x00000010;
                  break;
                } // case 40
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int valueCase_ = 0;
      private java.lang.Object value_;

      public ValueCase getValueCase() {
        return ValueCase.forNumber(valueCase_);
      }

      public Builder clearValue() {
        valueCase_ = 0;
        value_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      /**
       *
       *
       * <pre>
       * int value type.
       * </pre>
       *
       * <code>int64 value_int = 2;</code>
       *
       * @return Whether the valueInt field is set.
       */
      public boolean hasValueInt() {
        return valueCase_ == 2;
      }

      /**
       *
       *
       * <pre>
       * int value type.
       * </pre>
       *
       * <code>int64 value_int = 2;</code>
       *
       * @return The valueInt.
       */
      public long getValueInt() {
        if (valueCase_ == 2) {
          return (java.lang.Long) value_;
        }
        return 0L;
      }

      /**
       *
       *
       * <pre>
       * int value type.
       * </pre>
       *
       * <code>int64 value_int = 2;</code>
       *
       * @param value The valueInt to set.
       * @return This builder for chaining.
       */
      public Builder setValueInt(long value) {

        valueCase_ = 2;
        value_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * int value type.
       * </pre>
       *
       * <code>int64 value_int = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValueInt() {
        if (valueCase_ == 2) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * float value type.
       * </pre>
       *
       * <code>float value_float = 3;</code>
       *
       * @return Whether the valueFloat field is set.
       */
      public boolean hasValueFloat() {
        return valueCase_ == 3;
      }

      /**
       *
       *
       * <pre>
       * float value type.
       * </pre>
       *
       * <code>float value_float = 3;</code>
       *
       * @return The valueFloat.
       */
      public float getValueFloat() {
        if (valueCase_ == 3) {
          return (java.lang.Float) value_;
        }
        return 0F;
      }

      /**
       *
       *
       * <pre>
       * float value type.
       * </pre>
       *
       * <code>float value_float = 3;</code>
       *
       * @param value The valueFloat to set.
       * @return This builder for chaining.
       */
      public Builder setValueFloat(float value) {

        valueCase_ = 3;
        value_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * float value type.
       * </pre>
       *
       * <code>float value_float = 3;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValueFloat() {
        if (valueCase_ == 3) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * double value type.
       * </pre>
       *
       * <code>double value_double = 4;</code>
       *
       * @return Whether the valueDouble field is set.
       */
      public boolean hasValueDouble() {
        return valueCase_ == 4;
      }

      /**
       *
       *
       * <pre>
       * double value type.
       * </pre>
       *
       * <code>double value_double = 4;</code>
       *
       * @return The valueDouble.
       */
      public double getValueDouble() {
        if (valueCase_ == 4) {
          return (java.lang.Double) value_;
        }
        return 0D;
      }

      /**
       *
       *
       * <pre>
       * double value type.
       * </pre>
       *
       * <code>double value_double = 4;</code>
       *
       * @param value The valueDouble to set.
       * @return This builder for chaining.
       */
      public Builder setValueDouble(double value) {

        valueCase_ = 4;
        value_ = value;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * double value type.
       * </pre>
       *
       * <code>double value_double = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValueDouble() {
        if (valueCase_ == 4) {
          valueCase_ = 0;
          value_ = null;
          onChanged();
        }
        return this;
      }

      private java.lang.Object name_ = "";

      /**
       *
       *
       * <pre>
       * Required. Column name in BigQuery that used as filters.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The name.
       */
      public java.lang.String getName() {
        java.lang.Object ref = name_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          name_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Column name in BigQuery that used as filters.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for name.
       */
      public com.google.protobuf.ByteString getNameBytes() {
        java.lang.Object ref = name_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          name_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Column name in BigQuery that used as filters.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The name to set.
       * @return This builder for chaining.
       */
      public Builder setName(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        name_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Column name in BigQuery that used as filters.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearName() {
        name_ = getDefaultInstance().getName();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Column name in BigQuery that used as filters.
       * </pre>
       *
       * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for name to set.
       * @return This builder for chaining.
       */
      public Builder setNameBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        name_ = value;
        bitField0_ |= 0x00000008;
        onChanged();
        return this;
      }

      private int op_ = 0;

      /**
       *
       *
       * <pre>
       * Optional. This MUST be specified for queries and must NOT be specified
       * for database points.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator op = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return Whether the op field is set.
       */
      @java.lang.Override
      public boolean hasOp() {
        return ((bitField0_ & 0x00000010) != 0);
      }

      /**
       *
       *
       * <pre>
       * Optional. This MUST be specified for queries and must NOT be specified
       * for database points.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator op = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The enum numeric value on the wire for op.
       */
      @java.lang.Override
      public int getOpValue() {
        return op_;
      }

      /**
       *
       *
       * <pre>
       * Optional. This MUST be specified for queries and must NOT be specified
       * for database points.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator op = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The enum numeric value on the wire for op to set.
       * @return This builder for chaining.
       */
      public Builder setOpValue(int value) {
        op_ = value;
        bitField0_ |= 0x00000010;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. This MUST be specified for queries and must NOT be specified
       * for database points.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator op = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The op.
       */
      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator
          getOp() {
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator result =
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator
                .forNumber(op_);
        return result == null
            ? com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator
                .UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Optional. This MUST be specified for queries and must NOT be specified
       * for database points.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator op = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The op to set.
       * @return This builder for chaining.
       */
      public Builder setOp(
          com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000010;
        op_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. This MUST be specified for queries and must NOT be specified
       * for database points.
       * </pre>
       *
       * <code>
       * optional .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Operator op = 5 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearOp() {
        bitField0_ = (bitField0_ & ~0x00000010);
        op_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter)
    private static final com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter();
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<NumericFilter> PARSER =
        new com.google.protobuf.AbstractParser<NumericFilter>() {
          @java.lang.Override
          public NumericFilter parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<NumericFilter> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<NumericFilter> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface ParametersOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The number of neighbors to find via approximate search before
     * exact reordering is performed; if set, this value must be &gt;
     * neighbor_count.
     * </pre>
     *
     * <code>int32 approximate_neighbor_candidates = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The approximateNeighborCandidates.
     */
    int getApproximateNeighborCandidates();

    /**
     *
     *
     * <pre>
     * Optional. The fraction of the number of leaves to search, set at query
     * time allows user to tune search performance. This value increase result
     * in both search accuracy and latency increase. The value should be between
     * 0.0 and 1.0.
     * </pre>
     *
     * <code>double leaf_nodes_search_fraction = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The leafNodesSearchFraction.
     */
    double getLeafNodesSearchFraction();
  }

  /**
   *
   *
   * <pre>
   * Parameters that can be overrided in each query to tune query latency and
   * recall.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters}
   */
  public static final class Parameters extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters)
      ParametersOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use Parameters.newBuilder() to construct.
    private Parameters(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private Parameters() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new Parameters();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_Parameters_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_Parameters_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters.class,
              com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters.Builder.class);
    }

    public static final int APPROXIMATE_NEIGHBOR_CANDIDATES_FIELD_NUMBER = 1;
    private int approximateNeighborCandidates_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The number of neighbors to find via approximate search before
     * exact reordering is performed; if set, this value must be &gt;
     * neighbor_count.
     * </pre>
     *
     * <code>int32 approximate_neighbor_candidates = 1 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The approximateNeighborCandidates.
     */
    @java.lang.Override
    public int getApproximateNeighborCandidates() {
      return approximateNeighborCandidates_;
    }

    public static final int LEAF_NODES_SEARCH_FRACTION_FIELD_NUMBER = 2;
    private double leafNodesSearchFraction_ = 0D;

    /**
     *
     *
     * <pre>
     * Optional. The fraction of the number of leaves to search, set at query
     * time allows user to tune search performance. This value increase result
     * in both search accuracy and latency increase. The value should be between
     * 0.0 and 1.0.
     * </pre>
     *
     * <code>double leaf_nodes_search_fraction = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The leafNodesSearchFraction.
     */
    @java.lang.Override
    public double getLeafNodesSearchFraction() {
      return leafNodesSearchFraction_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (approximateNeighborCandidates_ != 0) {
        output.writeInt32(1, approximateNeighborCandidates_);
      }
      if (java.lang.Double.doubleToRawLongBits(leafNodesSearchFraction_) != 0) {
        output.writeDouble(2, leafNodesSearchFraction_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (approximateNeighborCandidates_ != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeInt32Size(
                1, approximateNeighborCandidates_);
      }
      if (java.lang.Double.doubleToRawLongBits(leafNodesSearchFraction_) != 0) {
        size +=
            com.google.protobuf.CodedOutputStream.computeDoubleSize(2, leafNodesSearchFraction_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters other =
          (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters) obj;

      if (getApproximateNeighborCandidates() != other.getApproximateNeighborCandidates())
        return false;
      if (java.lang.Double.doubleToLongBits(getLeafNodesSearchFraction())
          != java.lang.Double.doubleToLongBits(other.getLeafNodesSearchFraction())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + APPROXIMATE_NEIGHBOR_CANDIDATES_FIELD_NUMBER;
      hash = (53 * hash) + getApproximateNeighborCandidates();
      hash = (37 * hash) + LEAF_NODES_SEARCH_FRACTION_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getLeafNodesSearchFraction()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Parameters that can be overrided in each query to tune query latency and
     * recall.
     * </pre>
     *
     * Protobuf type {@code google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters)
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.ParametersOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_Parameters_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_Parameters_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters.class,
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters.Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        approximateNeighborCandidates_ = 0;
        leafNodesSearchFraction_ = 0D;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_Parameters_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters build() {
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters buildPartial() {
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters result =
            new com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.approximateNeighborCandidates_ = approximateNeighborCandidates_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.leafNodesSearchFraction_ = leafNodesSearchFraction_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters
                .getDefaultInstance()) return this;
        if (other.getApproximateNeighborCandidates() != 0) {
          setApproximateNeighborCandidates(other.getApproximateNeighborCandidates());
        }
        if (other.getLeafNodesSearchFraction() != 0D) {
          setLeafNodesSearchFraction(other.getLeafNodesSearchFraction());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  approximateNeighborCandidates_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 17:
                {
                  leafNodesSearchFraction_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 17
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int approximateNeighborCandidates_;

      /**
       *
       *
       * <pre>
       * Optional. The number of neighbors to find via approximate search before
       * exact reordering is performed; if set, this value must be &gt;
       * neighbor_count.
       * </pre>
       *
       * <code>int32 approximate_neighbor_candidates = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The approximateNeighborCandidates.
       */
      @java.lang.Override
      public int getApproximateNeighborCandidates() {
        return approximateNeighborCandidates_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The number of neighbors to find via approximate search before
       * exact reordering is performed; if set, this value must be &gt;
       * neighbor_count.
       * </pre>
       *
       * <code>int32 approximate_neighbor_candidates = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The approximateNeighborCandidates to set.
       * @return This builder for chaining.
       */
      public Builder setApproximateNeighborCandidates(int value) {

        approximateNeighborCandidates_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The number of neighbors to find via approximate search before
       * exact reordering is performed; if set, this value must be &gt;
       * neighbor_count.
       * </pre>
       *
       * <code>int32 approximate_neighbor_candidates = 1 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearApproximateNeighborCandidates() {
        bitField0_ = (bitField0_ & ~0x00000001);
        approximateNeighborCandidates_ = 0;
        onChanged();
        return this;
      }

      private double leafNodesSearchFraction_;

      /**
       *
       *
       * <pre>
       * Optional. The fraction of the number of leaves to search, set at query
       * time allows user to tune search performance. This value increase result
       * in both search accuracy and latency increase. The value should be between
       * 0.0 and 1.0.
       * </pre>
       *
       * <code>double leaf_nodes_search_fraction = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return The leafNodesSearchFraction.
       */
      @java.lang.Override
      public double getLeafNodesSearchFraction() {
        return leafNodesSearchFraction_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The fraction of the number of leaves to search, set at query
       * time allows user to tune search performance. This value increase result
       * in both search accuracy and latency increase. The value should be between
       * 0.0 and 1.0.
       * </pre>
       *
       * <code>double leaf_nodes_search_fraction = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @param value The leafNodesSearchFraction to set.
       * @return This builder for chaining.
       */
      public Builder setLeafNodesSearchFraction(double value) {

        leafNodesSearchFraction_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The fraction of the number of leaves to search, set at query
       * time allows user to tune search performance. This value increase result
       * in both search accuracy and latency increase. The value should be between
       * 0.0 and 1.0.
       * </pre>
       *
       * <code>double leaf_nodes_search_fraction = 2 [(.google.api.field_behavior) = OPTIONAL];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLeafNodesSearchFraction() {
        bitField0_ = (bitField0_ & ~0x00000002);
        leafNodesSearchFraction_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters)
    private static final com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters();
    }

    public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<Parameters> PARSER =
        new com.google.protobuf.AbstractParser<Parameters>() {
          @java.lang.Override
          public Parameters parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<Parameters> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<Parameters> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  private int instanceCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object instance_;

  public enum InstanceCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    ENTITY_ID(1),
    EMBEDDING(2),
    INSTANCE_NOT_SET(0);
    private final int value;

    private InstanceCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InstanceCase valueOf(int value) {
      return forNumber(value);
    }

    public static InstanceCase forNumber(int value) {
      switch (value) {
        case 1:
          return ENTITY_ID;
        case 2:
          return EMBEDDING;
        case 0:
          return INSTANCE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public InstanceCase getInstanceCase() {
    return InstanceCase.forNumber(instanceCase_);
  }

  public static final int ENTITY_ID_FIELD_NUMBER = 1;

  /**
   *
   *
   * <pre>
   * Optional. The entity id whose similar entities should be searched for.
   * If embedding is set, search will use embedding instead of
   * entity_id.
   * </pre>
   *
   * <code>string entity_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return Whether the entityId field is set.
   */
  public boolean hasEntityId() {
    return instanceCase_ == 1;
  }

  /**
   *
   *
   * <pre>
   * Optional. The entity id whose similar entities should be searched for.
   * If embedding is set, search will use embedding instead of
   * entity_id.
   * </pre>
   *
   * <code>string entity_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The entityId.
   */
  public java.lang.String getEntityId() {
    java.lang.Object ref = "";
    if (instanceCase_ == 1) {
      ref = instance_;
    }
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      if (instanceCase_ == 1) {
        instance_ = s;
      }
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The entity id whose similar entities should be searched for.
   * If embedding is set, search will use embedding instead of
   * entity_id.
   * </pre>
   *
   * <code>string entity_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for entityId.
   */
  public com.google.protobuf.ByteString getEntityIdBytes() {
    java.lang.Object ref = "";
    if (instanceCase_ == 1) {
      ref = instance_;
    }
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      if (instanceCase_ == 1) {
        instance_ = b;
      }
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int EMBEDDING_FIELD_NUMBER = 2;

  /**
   *
   *
   * <pre>
   * Optional. The embedding vector that be used for similar search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding embedding = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the embedding field is set.
   */
  @java.lang.Override
  public boolean hasEmbedding() {
    return instanceCase_ == 2;
  }

  /**
   *
   *
   * <pre>
   * Optional. The embedding vector that be used for similar search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding embedding = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The embedding.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding getEmbedding() {
    if (instanceCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding) instance_;
    }
    return com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding.getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Optional. The embedding vector that be used for similar search.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding embedding = 2 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.EmbeddingOrBuilder
      getEmbeddingOrBuilder() {
    if (instanceCase_ == 2) {
      return (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding) instance_;
    }
    return com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding.getDefaultInstance();
  }

  public static final int NEIGHBOR_COUNT_FIELD_NUMBER = 3;
  private int neighborCount_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The number of similar entities to be retrieved from feature view
   * for each query.
   * </pre>
   *
   * <code>int32 neighbor_count = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The neighborCount.
   */
  @java.lang.Override
  public int getNeighborCount() {
    return neighborCount_;
  }

  public static final int STRING_FILTERS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter>
      stringFilters_;

  /**
   *
   *
   * <pre>
   * Optional. The list of string filters.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter>
      getStringFiltersList() {
    return stringFilters_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The list of string filters.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilterOrBuilder>
      getStringFiltersOrBuilderList() {
    return stringFilters_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The list of string filters.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getStringFiltersCount() {
    return stringFilters_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The list of string filters.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter getStringFilters(
      int index) {
    return stringFilters_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. The list of string filters.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilterOrBuilder
      getStringFiltersOrBuilder(int index) {
    return stringFilters_.get(index);
  }

  public static final int NUMERIC_FILTERS_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter>
      numericFilters_;

  /**
   *
   *
   * <pre>
   * Optional. The list of numeric filters.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter>
      getNumericFiltersList() {
    return numericFilters_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The list of numeric filters.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilterOrBuilder>
      getNumericFiltersOrBuilderList() {
    return numericFilters_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The list of numeric filters.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getNumericFiltersCount() {
    return numericFilters_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The list of numeric filters.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter getNumericFilters(
      int index) {
    return numericFilters_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. The list of numeric filters.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilterOrBuilder
      getNumericFiltersOrBuilder(int index) {
    return numericFilters_.get(index);
  }

  public static final int PER_CROWDING_ATTRIBUTE_NEIGHBOR_COUNT_FIELD_NUMBER = 5;
  private int perCrowdingAttributeNeighborCount_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. Crowding is a constraint on a neighbor list produced by nearest
   * neighbor search requiring that no more than
   * sper_crowding_attribute_neighbor_count of the k neighbors returned have the
   * same value of crowding_attribute. It's used for improving result diversity.
   * </pre>
   *
   * <code>
   * int32 per_crowding_attribute_neighbor_count = 5 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The perCrowdingAttributeNeighborCount.
   */
  @java.lang.Override
  public int getPerCrowdingAttributeNeighborCount() {
    return perCrowdingAttributeNeighborCount_;
  }

  public static final int PARAMETERS_FIELD_NUMBER = 7;
  private com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parameters_;

  /**
   *
   *
   * <pre>
   * Optional. Parameters that can be set to tune query on the fly.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parameters = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the parameters field is set.
   */
  @java.lang.Override
  public boolean hasParameters() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Parameters that can be set to tune query on the fly.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parameters = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The parameters.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters getParameters() {
    return parameters_ == null
        ? com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters.getDefaultInstance()
        : parameters_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Parameters that can be set to tune query on the fly.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parameters = 7 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.ParametersOrBuilder
      getParametersOrBuilder() {
    return parameters_ == null
        ? com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters.getDefaultInstance()
        : parameters_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (instanceCase_ == 1) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, instance_);
    }
    if (instanceCase_ == 2) {
      output.writeMessage(
          2, (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding) instance_);
    }
    if (neighborCount_ != 0) {
      output.writeInt32(3, neighborCount_);
    }
    for (int i = 0; i < stringFilters_.size(); i++) {
      output.writeMessage(4, stringFilters_.get(i));
    }
    if (perCrowdingAttributeNeighborCount_ != 0) {
      output.writeInt32(5, perCrowdingAttributeNeighborCount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(7, getParameters());
    }
    for (int i = 0; i < numericFilters_.size(); i++) {
      output.writeMessage(8, numericFilters_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (instanceCase_ == 1) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, instance_);
    }
    if (instanceCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding) instance_);
    }
    if (neighborCount_ != 0) {
      size += com.google.protobuf.CodedOutputStream.computeInt32Size(3, neighborCount_);
    }
    for (int i = 0; i < stringFilters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, stringFilters_.get(i));
    }
    if (perCrowdingAttributeNeighborCount_ != 0) {
      size +=
          com.google.protobuf.CodedOutputStream.computeInt32Size(
              5, perCrowdingAttributeNeighborCount_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getParameters());
    }
    for (int i = 0; i < numericFilters_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, numericFilters_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery other =
        (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery) obj;

    if (getNeighborCount() != other.getNeighborCount()) return false;
    if (!getStringFiltersList().equals(other.getStringFiltersList())) return false;
    if (!getNumericFiltersList().equals(other.getNumericFiltersList())) return false;
    if (getPerCrowdingAttributeNeighborCount() != other.getPerCrowdingAttributeNeighborCount())
      return false;
    if (hasParameters() != other.hasParameters()) return false;
    if (hasParameters()) {
      if (!getParameters().equals(other.getParameters())) return false;
    }
    if (!getInstanceCase().equals(other.getInstanceCase())) return false;
    switch (instanceCase_) {
      case 1:
        if (!getEntityId().equals(other.getEntityId())) return false;
        break;
      case 2:
        if (!getEmbedding().equals(other.getEmbedding())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NEIGHBOR_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getNeighborCount();
    if (getStringFiltersCount() > 0) {
      hash = (37 * hash) + STRING_FILTERS_FIELD_NUMBER;
      hash = (53 * hash) + getStringFiltersList().hashCode();
    }
    if (getNumericFiltersCount() > 0) {
      hash = (37 * hash) + NUMERIC_FILTERS_FIELD_NUMBER;
      hash = (53 * hash) + getNumericFiltersList().hashCode();
    }
    hash = (37 * hash) + PER_CROWDING_ATTRIBUTE_NEIGHBOR_COUNT_FIELD_NUMBER;
    hash = (53 * hash) + getPerCrowdingAttributeNeighborCount();
    if (hasParameters()) {
      hash = (37 * hash) + PARAMETERS_FIELD_NUMBER;
      hash = (53 * hash) + getParameters().hashCode();
    }
    switch (instanceCase_) {
      case 1:
        hash = (37 * hash) + ENTITY_ID_FIELD_NUMBER;
        hash = (53 * hash) + getEntityId().hashCode();
        break;
      case 2:
        hash = (37 * hash) + EMBEDDING_FIELD_NUMBER;
        hash = (53 * hash) + getEmbedding().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A query to find a number of similar entities.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.NearestNeighborQuery}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.NearestNeighborQuery)
      com.google.cloud.aiplatform.v1beta1.NearestNeighborQueryOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.class,
              com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getStringFiltersFieldBuilder();
        getNumericFiltersFieldBuilder();
        getParametersFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (embeddingBuilder_ != null) {
        embeddingBuilder_.clear();
      }
      neighborCount_ = 0;
      if (stringFiltersBuilder_ == null) {
        stringFilters_ = java.util.Collections.emptyList();
      } else {
        stringFilters_ = null;
        stringFiltersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      if (numericFiltersBuilder_ == null) {
        numericFilters_ = java.util.Collections.emptyList();
      } else {
        numericFilters_ = null;
        numericFiltersBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000010);
      perCrowdingAttributeNeighborCount_ = 0;
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      instanceCase_ = 0;
      instance_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.FeatureOnlineStoreServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_NearestNeighborQuery_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery build() {
      com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery buildPartial() {
      com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery result =
          new com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery result) {
      if (stringFiltersBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          stringFilters_ = java.util.Collections.unmodifiableList(stringFilters_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.stringFilters_ = stringFilters_;
      } else {
        result.stringFilters_ = stringFiltersBuilder_.build();
      }
      if (numericFiltersBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)) {
          numericFilters_ = java.util.Collections.unmodifiableList(numericFilters_);
          bitField0_ = (bitField0_ & ~0x00000010);
        }
        result.numericFilters_ = numericFilters_;
      } else {
        result.numericFilters_ = numericFiltersBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.neighborCount_ = neighborCount_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.perCrowdingAttributeNeighborCount_ = perCrowdingAttributeNeighborCount_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.parameters_ = parametersBuilder_ == null ? parameters_ : parametersBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      result.bitField0_ |= to_bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery result) {
      result.instanceCase_ = instanceCase_;
      result.instance_ = this.instance_;
      if (instanceCase_ == 2 && embeddingBuilder_ != null) {
        result.instance_ = embeddingBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery other) {
      if (other == com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.getDefaultInstance())
        return this;
      if (other.getNeighborCount() != 0) {
        setNeighborCount(other.getNeighborCount());
      }
      if (stringFiltersBuilder_ == null) {
        if (!other.stringFilters_.isEmpty()) {
          if (stringFilters_.isEmpty()) {
            stringFilters_ = other.stringFilters_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureStringFiltersIsMutable();
            stringFilters_.addAll(other.stringFilters_);
          }
          onChanged();
        }
      } else {
        if (!other.stringFilters_.isEmpty()) {
          if (stringFiltersBuilder_.isEmpty()) {
            stringFiltersBuilder_.dispose();
            stringFiltersBuilder_ = null;
            stringFilters_ = other.stringFilters_;
            bitField0_ = (bitField0_ & ~0x00000008);
            stringFiltersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getStringFiltersFieldBuilder()
                    : null;
          } else {
            stringFiltersBuilder_.addAllMessages(other.stringFilters_);
          }
        }
      }
      if (numericFiltersBuilder_ == null) {
        if (!other.numericFilters_.isEmpty()) {
          if (numericFilters_.isEmpty()) {
            numericFilters_ = other.numericFilters_;
            bitField0_ = (bitField0_ & ~0x00000010);
          } else {
            ensureNumericFiltersIsMutable();
            numericFilters_.addAll(other.numericFilters_);
          }
          onChanged();
        }
      } else {
        if (!other.numericFilters_.isEmpty()) {
          if (numericFiltersBuilder_.isEmpty()) {
            numericFiltersBuilder_.dispose();
            numericFiltersBuilder_ = null;
            numericFilters_ = other.numericFilters_;
            bitField0_ = (bitField0_ & ~0x00000010);
            numericFiltersBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getNumericFiltersFieldBuilder()
                    : null;
          } else {
            numericFiltersBuilder_.addAllMessages(other.numericFilters_);
          }
        }
      }
      if (other.getPerCrowdingAttributeNeighborCount() != 0) {
        setPerCrowdingAttributeNeighborCount(other.getPerCrowdingAttributeNeighborCount());
      }
      if (other.hasParameters()) {
        mergeParameters(other.getParameters());
      }
      switch (other.getInstanceCase()) {
        case ENTITY_ID:
          {
            instanceCase_ = 1;
            instance_ = other.instance_;
            onChanged();
            break;
          }
        case EMBEDDING:
          {
            mergeEmbedding(other.getEmbedding());
            break;
          }
        case INSTANCE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                java.lang.String s = input.readStringRequireUtf8();
                instanceCase_ = 1;
                instance_ = s;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getEmbeddingFieldBuilder().getBuilder(), extensionRegistry);
                instanceCase_ = 2;
                break;
              } // case 18
            case 24:
              {
                neighborCount_ = input.readInt32();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter
                            .parser(),
                        extensionRegistry);
                if (stringFiltersBuilder_ == null) {
                  ensureStringFiltersIsMutable();
                  stringFilters_.add(m);
                } else {
                  stringFiltersBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 40:
              {
                perCrowdingAttributeNeighborCount_ = input.readInt32();
                bitField0_ |= 0x00000020;
                break;
              } // case 40
            case 58:
              {
                input.readMessage(getParametersFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter
                            .parser(),
                        extensionRegistry);
                if (numericFiltersBuilder_ == null) {
                  ensureNumericFiltersIsMutable();
                  numericFilters_.add(m);
                } else {
                  numericFiltersBuilder_.addMessage(m);
                }
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int instanceCase_ = 0;
    private java.lang.Object instance_;

    public InstanceCase getInstanceCase() {
      return InstanceCase.forNumber(instanceCase_);
    }

    public Builder clearInstance() {
      instanceCase_ = 0;
      instance_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    /**
     *
     *
     * <pre>
     * Optional. The entity id whose similar entities should be searched for.
     * If embedding is set, search will use embedding instead of
     * entity_id.
     * </pre>
     *
     * <code>string entity_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return Whether the entityId field is set.
     */
    @java.lang.Override
    public boolean hasEntityId() {
      return instanceCase_ == 1;
    }

    /**
     *
     *
     * <pre>
     * Optional. The entity id whose similar entities should be searched for.
     * If embedding is set, search will use embedding instead of
     * entity_id.
     * </pre>
     *
     * <code>string entity_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The entityId.
     */
    @java.lang.Override
    public java.lang.String getEntityId() {
      java.lang.Object ref = "";
      if (instanceCase_ == 1) {
        ref = instance_;
      }
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        if (instanceCase_ == 1) {
          instance_ = s;
        }
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The entity id whose similar entities should be searched for.
     * If embedding is set, search will use embedding instead of
     * entity_id.
     * </pre>
     *
     * <code>string entity_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for entityId.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getEntityIdBytes() {
      java.lang.Object ref = "";
      if (instanceCase_ == 1) {
        ref = instance_;
      }
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        if (instanceCase_ == 1) {
          instance_ = b;
        }
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The entity id whose similar entities should be searched for.
     * If embedding is set, search will use embedding instead of
     * entity_id.
     * </pre>
     *
     * <code>string entity_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The entityId to set.
     * @return This builder for chaining.
     */
    public Builder setEntityId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instanceCase_ = 1;
      instance_ = value;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The entity id whose similar entities should be searched for.
     * If embedding is set, search will use embedding instead of
     * entity_id.
     * </pre>
     *
     * <code>string entity_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEntityId() {
      if (instanceCase_ == 1) {
        instanceCase_ = 0;
        instance_ = null;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The entity id whose similar entities should be searched for.
     * If embedding is set, search will use embedding instead of
     * entity_id.
     * </pre>
     *
     * <code>string entity_id = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for entityId to set.
     * @return This builder for chaining.
     */
    public Builder setEntityIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instanceCase_ = 1;
      instance_ = value;
      onChanged();
      return this;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding.Builder,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.EmbeddingOrBuilder>
        embeddingBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The embedding vector that be used for similar search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding embedding = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the embedding field is set.
     */
    @java.lang.Override
    public boolean hasEmbedding() {
      return instanceCase_ == 2;
    }

    /**
     *
     *
     * <pre>
     * Optional. The embedding vector that be used for similar search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding embedding = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The embedding.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding getEmbedding() {
      if (embeddingBuilder_ == null) {
        if (instanceCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding) instance_;
        }
        return com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding
            .getDefaultInstance();
      } else {
        if (instanceCase_ == 2) {
          return embeddingBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The embedding vector that be used for similar search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding embedding = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEmbedding(
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding value) {
      if (embeddingBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        instance_ = value;
        onChanged();
      } else {
        embeddingBuilder_.setMessage(value);
      }
      instanceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The embedding vector that be used for similar search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding embedding = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEmbedding(
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding.Builder
            builderForValue) {
      if (embeddingBuilder_ == null) {
        instance_ = builderForValue.build();
        onChanged();
      } else {
        embeddingBuilder_.setMessage(builderForValue.build());
      }
      instanceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The embedding vector that be used for similar search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding embedding = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEmbedding(
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding value) {
      if (embeddingBuilder_ == null) {
        if (instanceCase_ == 2
            && instance_
                != com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding
                    .getDefaultInstance()) {
          instance_ =
              com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding.newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding)
                          instance_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          instance_ = value;
        }
        onChanged();
      } else {
        if (instanceCase_ == 2) {
          embeddingBuilder_.mergeFrom(value);
        } else {
          embeddingBuilder_.setMessage(value);
        }
      }
      instanceCase_ = 2;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The embedding vector that be used for similar search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding embedding = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEmbedding() {
      if (embeddingBuilder_ == null) {
        if (instanceCase_ == 2) {
          instanceCase_ = 0;
          instance_ = null;
          onChanged();
        }
      } else {
        if (instanceCase_ == 2) {
          instanceCase_ = 0;
          instance_ = null;
        }
        embeddingBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The embedding vector that be used for similar search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding embedding = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding.Builder
        getEmbeddingBuilder() {
      return getEmbeddingFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The embedding vector that be used for similar search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding embedding = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.EmbeddingOrBuilder
        getEmbeddingOrBuilder() {
      if ((instanceCase_ == 2) && (embeddingBuilder_ != null)) {
        return embeddingBuilder_.getMessageOrBuilder();
      } else {
        if (instanceCase_ == 2) {
          return (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding) instance_;
        }
        return com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The embedding vector that be used for similar search.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding embedding = 2 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding.Builder,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.EmbeddingOrBuilder>
        getEmbeddingFieldBuilder() {
      if (embeddingBuilder_ == null) {
        if (!(instanceCase_ == 2)) {
          instance_ =
              com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding
                  .getDefaultInstance();
        }
        embeddingBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding,
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding.Builder,
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.EmbeddingOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Embedding) instance_,
                getParentForChildren(),
                isClean());
        instance_ = null;
      }
      instanceCase_ = 2;
      onChanged();
      return embeddingBuilder_;
    }

    private int neighborCount_;

    /**
     *
     *
     * <pre>
     * Optional. The number of similar entities to be retrieved from feature view
     * for each query.
     * </pre>
     *
     * <code>int32 neighbor_count = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The neighborCount.
     */
    @java.lang.Override
    public int getNeighborCount() {
      return neighborCount_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The number of similar entities to be retrieved from feature view
     * for each query.
     * </pre>
     *
     * <code>int32 neighbor_count = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The neighborCount to set.
     * @return This builder for chaining.
     */
    public Builder setNeighborCount(int value) {

      neighborCount_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The number of similar entities to be retrieved from feature view
     * for each query.
     * </pre>
     *
     * <code>int32 neighbor_count = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNeighborCount() {
      bitField0_ = (bitField0_ & ~0x00000004);
      neighborCount_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter>
        stringFilters_ = java.util.Collections.emptyList();

    private void ensureStringFiltersIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        stringFilters_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter>(
                stringFilters_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter.Builder,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilterOrBuilder>
        stringFiltersBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter>
        getStringFiltersList() {
      if (stringFiltersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(stringFilters_);
      } else {
        return stringFiltersBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getStringFiltersCount() {
      if (stringFiltersBuilder_ == null) {
        return stringFilters_.size();
      } else {
        return stringFiltersBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter getStringFilters(
        int index) {
      if (stringFiltersBuilder_ == null) {
        return stringFilters_.get(index);
      } else {
        return stringFiltersBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setStringFilters(
        int index, com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter value) {
      if (stringFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStringFiltersIsMutable();
        stringFilters_.set(index, value);
        onChanged();
      } else {
        stringFiltersBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setStringFilters(
        int index,
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter.Builder
            builderForValue) {
      if (stringFiltersBuilder_ == null) {
        ensureStringFiltersIsMutable();
        stringFilters_.set(index, builderForValue.build());
        onChanged();
      } else {
        stringFiltersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addStringFilters(
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter value) {
      if (stringFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStringFiltersIsMutable();
        stringFilters_.add(value);
        onChanged();
      } else {
        stringFiltersBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addStringFilters(
        int index, com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter value) {
      if (stringFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureStringFiltersIsMutable();
        stringFilters_.add(index, value);
        onChanged();
      } else {
        stringFiltersBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addStringFilters(
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter.Builder
            builderForValue) {
      if (stringFiltersBuilder_ == null) {
        ensureStringFiltersIsMutable();
        stringFilters_.add(builderForValue.build());
        onChanged();
      } else {
        stringFiltersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addStringFilters(
        int index,
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter.Builder
            builderForValue) {
      if (stringFiltersBuilder_ == null) {
        ensureStringFiltersIsMutable();
        stringFilters_.add(index, builderForValue.build());
        onChanged();
      } else {
        stringFiltersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllStringFilters(
        java.lang.Iterable<
                ? extends com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter>
            values) {
      if (stringFiltersBuilder_ == null) {
        ensureStringFiltersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, stringFilters_);
        onChanged();
      } else {
        stringFiltersBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearStringFilters() {
      if (stringFiltersBuilder_ == null) {
        stringFilters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        stringFiltersBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeStringFilters(int index) {
      if (stringFiltersBuilder_ == null) {
        ensureStringFiltersIsMutable();
        stringFilters_.remove(index);
        onChanged();
      } else {
        stringFiltersBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter.Builder
        getStringFiltersBuilder(int index) {
      return getStringFiltersFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilterOrBuilder
        getStringFiltersOrBuilder(int index) {
      if (stringFiltersBuilder_ == null) {
        return stringFilters_.get(index);
      } else {
        return stringFiltersBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilterOrBuilder>
        getStringFiltersOrBuilderList() {
      if (stringFiltersBuilder_ != null) {
        return stringFiltersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(stringFilters_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter.Builder
        addStringFiltersBuilder() {
      return getStringFiltersFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter.Builder
        addStringFiltersBuilder(int index) {
      return getStringFiltersFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of string filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter string_filters = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter.Builder>
        getStringFiltersBuilderList() {
      return getStringFiltersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter.Builder,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilterOrBuilder>
        getStringFiltersFieldBuilder() {
      if (stringFiltersBuilder_ == null) {
        stringFiltersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter,
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilter.Builder,
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.StringFilterOrBuilder>(
                stringFilters_,
                ((bitField0_ & 0x00000008) != 0),
                getParentForChildren(),
                isClean());
        stringFilters_ = null;
      }
      return stringFiltersBuilder_;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter>
        numericFilters_ = java.util.Collections.emptyList();

    private void ensureNumericFiltersIsMutable() {
      if (!((bitField0_ & 0x00000010) != 0)) {
        numericFilters_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter>(
                numericFilters_);
        bitField0_ |= 0x00000010;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Builder,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilterOrBuilder>
        numericFiltersBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter>
        getNumericFiltersList() {
      if (numericFiltersBuilder_ == null) {
        return java.util.Collections.unmodifiableList(numericFilters_);
      } else {
        return numericFiltersBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getNumericFiltersCount() {
      if (numericFiltersBuilder_ == null) {
        return numericFilters_.size();
      } else {
        return numericFiltersBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter getNumericFilters(
        int index) {
      if (numericFiltersBuilder_ == null) {
        return numericFilters_.get(index);
      } else {
        return numericFiltersBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNumericFilters(
        int index, com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter value) {
      if (numericFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNumericFiltersIsMutable();
        numericFilters_.set(index, value);
        onChanged();
      } else {
        numericFiltersBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setNumericFilters(
        int index,
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Builder
            builderForValue) {
      if (numericFiltersBuilder_ == null) {
        ensureNumericFiltersIsMutable();
        numericFilters_.set(index, builderForValue.build());
        onChanged();
      } else {
        numericFiltersBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNumericFilters(
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter value) {
      if (numericFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNumericFiltersIsMutable();
        numericFilters_.add(value);
        onChanged();
      } else {
        numericFiltersBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNumericFilters(
        int index, com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter value) {
      if (numericFiltersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureNumericFiltersIsMutable();
        numericFilters_.add(index, value);
        onChanged();
      } else {
        numericFiltersBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNumericFilters(
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Builder
            builderForValue) {
      if (numericFiltersBuilder_ == null) {
        ensureNumericFiltersIsMutable();
        numericFilters_.add(builderForValue.build());
        onChanged();
      } else {
        numericFiltersBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addNumericFilters(
        int index,
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Builder
            builderForValue) {
      if (numericFiltersBuilder_ == null) {
        ensureNumericFiltersIsMutable();
        numericFilters_.add(index, builderForValue.build());
        onChanged();
      } else {
        numericFiltersBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllNumericFilters(
        java.lang.Iterable<
                ? extends com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter>
            values) {
      if (numericFiltersBuilder_ == null) {
        ensureNumericFiltersIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, numericFilters_);
        onChanged();
      } else {
        numericFiltersBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearNumericFilters() {
      if (numericFiltersBuilder_ == null) {
        numericFilters_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000010);
        onChanged();
      } else {
        numericFiltersBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeNumericFilters(int index) {
      if (numericFiltersBuilder_ == null) {
        ensureNumericFiltersIsMutable();
        numericFilters_.remove(index);
        onChanged();
      } else {
        numericFiltersBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Builder
        getNumericFiltersBuilder(int index) {
      return getNumericFiltersFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilterOrBuilder
        getNumericFiltersOrBuilder(int index) {
      if (numericFiltersBuilder_ == null) {
        return numericFilters_.get(index);
      } else {
        return numericFiltersBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilterOrBuilder>
        getNumericFiltersOrBuilderList() {
      if (numericFiltersBuilder_ != null) {
        return numericFiltersBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(numericFilters_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Builder
        addNumericFiltersBuilder() {
      return getNumericFiltersFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Builder
        addNumericFiltersBuilder(int index) {
      return getNumericFiltersFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. The list of numeric filters.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter numeric_filters = 8 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Builder>
        getNumericFiltersBuilderList() {
      return getNumericFiltersFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Builder,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilterOrBuilder>
        getNumericFiltersFieldBuilder() {
      if (numericFiltersBuilder_ == null) {
        numericFiltersBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter,
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilter.Builder,
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.NumericFilterOrBuilder>(
                numericFilters_,
                ((bitField0_ & 0x00000010) != 0),
                getParentForChildren(),
                isClean());
        numericFilters_ = null;
      }
      return numericFiltersBuilder_;
    }

    private int perCrowdingAttributeNeighborCount_;

    /**
     *
     *
     * <pre>
     * Optional. Crowding is a constraint on a neighbor list produced by nearest
     * neighbor search requiring that no more than
     * sper_crowding_attribute_neighbor_count of the k neighbors returned have the
     * same value of crowding_attribute. It's used for improving result diversity.
     * </pre>
     *
     * <code>
     * int32 per_crowding_attribute_neighbor_count = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The perCrowdingAttributeNeighborCount.
     */
    @java.lang.Override
    public int getPerCrowdingAttributeNeighborCount() {
      return perCrowdingAttributeNeighborCount_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Crowding is a constraint on a neighbor list produced by nearest
     * neighbor search requiring that no more than
     * sper_crowding_attribute_neighbor_count of the k neighbors returned have the
     * same value of crowding_attribute. It's used for improving result diversity.
     * </pre>
     *
     * <code>
     * int32 per_crowding_attribute_neighbor_count = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The perCrowdingAttributeNeighborCount to set.
     * @return This builder for chaining.
     */
    public Builder setPerCrowdingAttributeNeighborCount(int value) {

      perCrowdingAttributeNeighborCount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Crowding is a constraint on a neighbor list produced by nearest
     * neighbor search requiring that no more than
     * sper_crowding_attribute_neighbor_count of the k neighbors returned have the
     * same value of crowding_attribute. It's used for improving result diversity.
     * </pre>
     *
     * <code>
     * int32 per_crowding_attribute_neighbor_count = 5 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPerCrowdingAttributeNeighborCount() {
      bitField0_ = (bitField0_ & ~0x00000020);
      perCrowdingAttributeNeighborCount_ = 0;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parameters_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters.Builder,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.ParametersOrBuilder>
        parametersBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to tune query on the fly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parameters = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the parameters field is set.
     */
    public boolean hasParameters() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to tune query on the fly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parameters = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The parameters.
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters getParameters() {
      if (parametersBuilder_ == null) {
        return parameters_ == null
            ? com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters
                .getDefaultInstance()
            : parameters_;
      } else {
        return parametersBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to tune query on the fly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parameters = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setParameters(
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters value) {
      if (parametersBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        parameters_ = value;
      } else {
        parametersBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to tune query on the fly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parameters = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setParameters(
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters.Builder
            builderForValue) {
      if (parametersBuilder_ == null) {
        parameters_ = builderForValue.build();
      } else {
        parametersBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to tune query on the fly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parameters = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeParameters(
        com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters value) {
      if (parametersBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && parameters_ != null
            && parameters_
                != com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters
                    .getDefaultInstance()) {
          getParametersBuilder().mergeFrom(value);
        } else {
          parameters_ = value;
        }
      } else {
        parametersBuilder_.mergeFrom(value);
      }
      if (parameters_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to tune query on the fly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parameters = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearParameters() {
      bitField0_ = (bitField0_ & ~0x00000040);
      parameters_ = null;
      if (parametersBuilder_ != null) {
        parametersBuilder_.dispose();
        parametersBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to tune query on the fly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parameters = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters.Builder
        getParametersBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getParametersFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to tune query on the fly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parameters = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.ParametersOrBuilder
        getParametersOrBuilder() {
      if (parametersBuilder_ != null) {
        return parametersBuilder_.getMessageOrBuilder();
      } else {
        return parameters_ == null
            ? com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters
                .getDefaultInstance()
            : parameters_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Parameters that can be set to tune query on the fly.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters parameters = 7 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters.Builder,
            com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.ParametersOrBuilder>
        getParametersFieldBuilder() {
      if (parametersBuilder_ == null) {
        parametersBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters,
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.Parameters.Builder,
                com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery.ParametersOrBuilder>(
                getParameters(), getParentForChildren(), isClean());
        parameters_ = null;
      }
      return parametersBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.NearestNeighborQuery)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.NearestNeighborQuery)
  private static final com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery();
  }

  public static com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<NearestNeighborQuery> PARSER =
      new com.google.protobuf.AbstractParser<NearestNeighborQuery>() {
        @java.lang.Override
        public NearestNeighborQuery parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<NearestNeighborQuery> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<NearestNeighborQuery> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.NearestNeighborQuery getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
