/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/persistent_resource.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Represents long-lasting resources that are dedicated to users to runs custom
 * workloads.
 * A PersistentResource can have multiple node pools and each node
 * pool can have its own machine spec.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.PersistentResource}
 */
public final class PersistentResource extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.PersistentResource)
    PersistentResourceOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use PersistentResource.newBuilder() to construct.
  private PersistentResource(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private PersistentResource() {
    name_ = "";
    displayName_ = "";
    resourcePools_ = java.util.Collections.emptyList();
    state_ = 0;
    network_ = "";
    reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new PersistentResource();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.PersistentResourceProto
        .internal_static_google_cloud_aiplatform_v1beta1_PersistentResource_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 10:
        return internalGetLabels();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.PersistentResourceProto
        .internal_static_google_cloud_aiplatform_v1beta1_PersistentResource_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.PersistentResource.class,
            com.google.cloud.aiplatform.v1beta1.PersistentResource.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Describes the PersistentResource state.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.aiplatform.v1beta1.PersistentResource.State}
   */
  public enum State implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    STATE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * The PROVISIONING state indicates the persistent resources is being
     * created.
     * </pre>
     *
     * <code>PROVISIONING = 1;</code>
     */
    PROVISIONING(1),
    /**
     *
     *
     * <pre>
     * The RUNNING state indicates the persistent resource is healthy and fully
     * usable.
     * </pre>
     *
     * <code>RUNNING = 3;</code>
     */
    RUNNING(3),
    /**
     *
     *
     * <pre>
     * The STOPPING state indicates the persistent resource is being deleted.
     * </pre>
     *
     * <code>STOPPING = 4;</code>
     */
    STOPPING(4),
    /**
     *
     *
     * <pre>
     * The ERROR state indicates the persistent resource may be unusable.
     * Details can be found in the `error` field.
     * </pre>
     *
     * <code>ERROR = 5;</code>
     */
    ERROR(5),
    /**
     *
     *
     * <pre>
     * The REBOOTING state indicates the persistent resource is being rebooted
     * (PR is not available right now but is expected to be ready again later).
     * </pre>
     *
     * <code>REBOOTING = 6;</code>
     */
    REBOOTING(6),
    /**
     *
     *
     * <pre>
     * The UPDATING state indicates the persistent resource is being updated.
     * </pre>
     *
     * <code>UPDATING = 7;</code>
     */
    UPDATING(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Not set.
     * </pre>
     *
     * <code>STATE_UNSPECIFIED = 0;</code>
     */
    public static final int STATE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * The PROVISIONING state indicates the persistent resources is being
     * created.
     * </pre>
     *
     * <code>PROVISIONING = 1;</code>
     */
    public static final int PROVISIONING_VALUE = 1;

    /**
     *
     *
     * <pre>
     * The RUNNING state indicates the persistent resource is healthy and fully
     * usable.
     * </pre>
     *
     * <code>RUNNING = 3;</code>
     */
    public static final int RUNNING_VALUE = 3;

    /**
     *
     *
     * <pre>
     * The STOPPING state indicates the persistent resource is being deleted.
     * </pre>
     *
     * <code>STOPPING = 4;</code>
     */
    public static final int STOPPING_VALUE = 4;

    /**
     *
     *
     * <pre>
     * The ERROR state indicates the persistent resource may be unusable.
     * Details can be found in the `error` field.
     * </pre>
     *
     * <code>ERROR = 5;</code>
     */
    public static final int ERROR_VALUE = 5;

    /**
     *
     *
     * <pre>
     * The REBOOTING state indicates the persistent resource is being rebooted
     * (PR is not available right now but is expected to be ready again later).
     * </pre>
     *
     * <code>REBOOTING = 6;</code>
     */
    public static final int REBOOTING_VALUE = 6;

    /**
     *
     *
     * <pre>
     * The UPDATING state indicates the persistent resource is being updated.
     * </pre>
     *
     * <code>UPDATING = 7;</code>
     */
    public static final int UPDATING_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static State valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static State forNumber(int value) {
      switch (value) {
        case 0:
          return STATE_UNSPECIFIED;
        case 1:
          return PROVISIONING;
        case 3:
          return RUNNING;
        case 4:
          return STOPPING;
        case 5:
          return ERROR;
        case 6:
          return REBOOTING;
        case 7:
          return UPDATING;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<State> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<State> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<State>() {
          public State findValueByNumber(int number) {
            return State.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PersistentResource.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final State[] VALUES = values();

    public static State valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private State(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.aiplatform.v1beta1.PersistentResource.State)
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Immutable. Resource name of a PersistentResource.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Immutable. Resource name of a PersistentResource.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The display name of the PersistentResource.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The display name of the PersistentResource.
   * The name can be up to 128 characters long and can consist of any UTF-8
   * characters.
   * </pre>
   *
   * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int RESOURCE_POOLS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1beta1.ResourcePool> resourcePools_;

  /**
   *
   *
   * <pre>
   * Required. The spec of the pools of different resources.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1beta1.ResourcePool> getResourcePoolsList() {
    return resourcePools_;
  }

  /**
   *
   *
   * <pre>
   * Required. The spec of the pools of different resources.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ResourcePoolOrBuilder>
      getResourcePoolsOrBuilderList() {
    return resourcePools_;
  }

  /**
   *
   *
   * <pre>
   * Required. The spec of the pools of different resources.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public int getResourcePoolsCount() {
    return resourcePools_.size();
  }

  /**
   *
   *
   * <pre>
   * Required. The spec of the pools of different resources.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ResourcePool getResourcePools(int index) {
    return resourcePools_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Required. The spec of the pools of different resources.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ResourcePoolOrBuilder getResourcePoolsOrBuilder(
      int index) {
    return resourcePools_.get(index);
  }

  public static final int STATE_FIELD_NUMBER = 5;
  private int state_ = 0;

  /**
   *
   *
   * <pre>
   * Output only. The detailed state of a Study.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PersistentResource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The enum numeric value on the wire for state.
   */
  @java.lang.Override
  public int getStateValue() {
    return state_;
  }

  /**
   *
   *
   * <pre>
   * Output only. The detailed state of a Study.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PersistentResource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The state.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PersistentResource.State getState() {
    com.google.cloud.aiplatform.v1beta1.PersistentResource.State result =
        com.google.cloud.aiplatform.v1beta1.PersistentResource.State.forNumber(state_);
    return result == null
        ? com.google.cloud.aiplatform.v1beta1.PersistentResource.State.UNRECOGNIZED
        : result;
  }

  public static final int ERROR_FIELD_NUMBER = 6;
  private com.google.rpc.Status error_;

  /**
   *
   *
   * <pre>
   * Output only. Only populated when persistent resource's state is `STOPPING`
   * or `ERROR`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return Whether the error field is set.
   */
  @java.lang.Override
  public boolean hasError() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Only populated when persistent resource's state is `STOPPING`
   * or `ERROR`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The error.
   */
  @java.lang.Override
  public com.google.rpc.Status getError() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Only populated when persistent resource's state is `STOPPING`
   * or `ERROR`.
   * </pre>
   *
   * <code>.google.rpc.Status error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
    return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
  }

  public static final int CREATE_TIME_FIELD_NUMBER = 7;
  private com.google.protobuf.Timestamp createTime_;

  /**
   *
   *
   * <pre>
   * Output only. Time when the PersistentResource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the createTime field is set.
   */
  @java.lang.Override
  public boolean hasCreateTime() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when the PersistentResource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The createTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getCreateTime() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when the PersistentResource was created.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
    return createTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : createTime_;
  }

  public static final int START_TIME_FIELD_NUMBER = 8;
  private com.google.protobuf.Timestamp startTime_;

  /**
   *
   *
   * <pre>
   * Output only. Time when the PersistentResource for the first time entered
   * the `RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the startTime field is set.
   */
  @java.lang.Override
  public boolean hasStartTime() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when the PersistentResource for the first time entered
   * the `RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The startTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getStartTime() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when the PersistentResource for the first time entered
   * the `RUNNING` state.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
    return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
  }

  public static final int UPDATE_TIME_FIELD_NUMBER = 9;
  private com.google.protobuf.Timestamp updateTime_;

  /**
   *
   *
   * <pre>
   * Output only. Time when the PersistentResource was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the updateTime field is set.
   */
  @java.lang.Override
  public boolean hasUpdateTime() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when the PersistentResource was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The updateTime.
   */
  @java.lang.Override
  public com.google.protobuf.Timestamp getUpdateTime() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Time when the PersistentResource was most recently updated.
   * </pre>
   *
   * <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
    return updateTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : updateTime_;
  }

  public static final int LABELS_FIELD_NUMBER = 10;

  private static final class LabelsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.PersistentResourceProto
                .internal_static_google_cloud_aiplatform_v1beta1_PersistentResource_LabelsEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
    if (labels_ == null) {
      return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
    }
    return labels_;
  }

  public int getLabelsCount() {
    return internalGetLabels().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize
   * PersistentResource.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public boolean containsLabels(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetLabels().getMap().containsKey(key);
  }

  /** Use {@link #getLabelsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getLabels() {
    return getLabelsMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize
   * PersistentResource.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
    return internalGetLabels().getMap();
  }

  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize
   * PersistentResource.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getLabelsOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Optional. The labels with user-defined metadata to organize
   * PersistentResource.
   *
   * Label keys and values can be no longer than 64 characters
   * (Unicode codepoints), can only contain lowercase letters, numeric
   * characters, underscores and dashes. International characters are allowed.
   *
   * See https://goo.gl/xmQnxf for more information and examples of labels.
   * </pre>
   *
   * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   */
  @java.lang.Override
  public java.lang.String getLabelsOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int NETWORK_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private volatile java.lang.Object network_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The full name of the Compute Engine
   * [network](/compute/docs/networks-and-firewalls#networks) to peered with
   * Vertex AI to host the persistent resources.
   * For example, `projects/12345/global/networks/myVPC`.
   * [Format](/compute/docs/reference/rest/v1/networks/insert)
   * is of the form `projects/{project}/global/networks/{network}`.
   * Where {project} is a project number, as in `12345`, and {network} is a
   * network name.
   *
   * To specify this field, you must have already [configured VPC Network
   * Peering for Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
   *
   * If this field is left unspecified, the resources aren't peered with any
   * network.
   * </pre>
   *
   * <code>
   * string network = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The network.
   */
  @java.lang.Override
  public java.lang.String getNetwork() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      network_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The full name of the Compute Engine
   * [network](/compute/docs/networks-and-firewalls#networks) to peered with
   * Vertex AI to host the persistent resources.
   * For example, `projects/12345/global/networks/myVPC`.
   * [Format](/compute/docs/reference/rest/v1/networks/insert)
   * is of the form `projects/{project}/global/networks/{network}`.
   * Where {project} is a project number, as in `12345`, and {network} is a
   * network name.
   *
   * To specify this field, you must have already [configured VPC Network
   * Peering for Vertex
   * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
   *
   * If this field is left unspecified, the resources aren't peered with any
   * network.
   * </pre>
   *
   * <code>
   * string network = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for network.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNetworkBytes() {
    java.lang.Object ref = network_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      network_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PSC_INTERFACE_CONFIG_FIELD_NUMBER = 17;
  private com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig pscInterfaceConfig_;

  /**
   *
   *
   * <pre>
   * Optional. Configuration for PSC-I for PersistentResource.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the pscInterfaceConfig field is set.
   */
  @java.lang.Override
  public boolean hasPscInterfaceConfig() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Configuration for PSC-I for PersistentResource.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The pscInterfaceConfig.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig getPscInterfaceConfig() {
    return pscInterfaceConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.getDefaultInstance()
        : pscInterfaceConfig_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Configuration for PSC-I for PersistentResource.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 17 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PscInterfaceConfigOrBuilder
      getPscInterfaceConfigOrBuilder() {
    return pscInterfaceConfig_ == null
        ? com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.getDefaultInstance()
        : pscInterfaceConfig_;
  }

  public static final int ENCRYPTION_SPEC_FIELD_NUMBER = 12;
  private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;

  /**
   *
   *
   * <pre>
   * Optional. Customer-managed encryption key spec for a PersistentResource.
   * If set, this PersistentResource and all sub-resources of this
   * PersistentResource will be secured by this key.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the encryptionSpec field is set.
   */
  @java.lang.Override
  public boolean hasEncryptionSpec() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Customer-managed encryption key spec for a PersistentResource.
   * If set, this PersistentResource and all sub-resources of this
   * PersistentResource will be secured by this key.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The encryptionSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Customer-managed encryption key spec for a PersistentResource.
   * If set, this PersistentResource and all sub-resources of this
   * PersistentResource will be secured by this key.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder getEncryptionSpecOrBuilder() {
    return encryptionSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
        : encryptionSpec_;
  }

  public static final int RESOURCE_RUNTIME_SPEC_FIELD_NUMBER = 13;
  private com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec resourceRuntimeSpec_;

  /**
   *
   *
   * <pre>
   * Optional. Persistent Resource runtime spec.
   * For example, used for Ray cluster configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec resource_runtime_spec = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the resourceRuntimeSpec field is set.
   */
  @java.lang.Override
  public boolean hasResourceRuntimeSpec() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Persistent Resource runtime spec.
   * For example, used for Ray cluster configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec resource_runtime_spec = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The resourceRuntimeSpec.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec getResourceRuntimeSpec() {
    return resourceRuntimeSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec.getDefaultInstance()
        : resourceRuntimeSpec_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Persistent Resource runtime spec.
   * For example, used for Ray cluster configuration.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec resource_runtime_spec = 13 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpecOrBuilder
      getResourceRuntimeSpecOrBuilder() {
    return resourceRuntimeSpec_ == null
        ? com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec.getDefaultInstance()
        : resourceRuntimeSpec_;
  }

  public static final int RESOURCE_RUNTIME_FIELD_NUMBER = 14;
  private com.google.cloud.aiplatform.v1beta1.ResourceRuntime resourceRuntime_;

  /**
   *
   *
   * <pre>
   * Output only. Runtime information of the Persistent Resource.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ResourceRuntime resource_runtime = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return Whether the resourceRuntime field is set.
   */
  @java.lang.Override
  public boolean hasResourceRuntime() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Output only. Runtime information of the Persistent Resource.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ResourceRuntime resource_runtime = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   *
   * @return The resourceRuntime.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ResourceRuntime getResourceRuntime() {
    return resourceRuntime_ == null
        ? com.google.cloud.aiplatform.v1beta1.ResourceRuntime.getDefaultInstance()
        : resourceRuntime_;
  }

  /**
   *
   *
   * <pre>
   * Output only. Runtime information of the Persistent Resource.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.ResourceRuntime resource_runtime = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.ResourceRuntimeOrBuilder
      getResourceRuntimeOrBuilder() {
    return resourceRuntime_ == null
        ? com.google.cloud.aiplatform.v1beta1.ResourceRuntime.getDefaultInstance()
        : resourceRuntime_;
  }

  public static final int RESERVED_IP_RANGES_FIELD_NUMBER = 15;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList reservedIpRanges_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * Optional. A list of names for the reserved IP ranges under the VPC network
   * that can be used for this persistent resource.
   *
   * If set, we will deploy the persistent resource within the provided IP
   * ranges. Otherwise, the persistent resource is deployed to any IP
   * ranges under the provided VPC network.
   *
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return A list containing the reservedIpRanges.
   */
  public com.google.protobuf.ProtocolStringList getReservedIpRangesList() {
    return reservedIpRanges_;
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of names for the reserved IP ranges under the VPC network
   * that can be used for this persistent resource.
   *
   * If set, we will deploy the persistent resource within the provided IP
   * ranges. Otherwise, the persistent resource is deployed to any IP
   * ranges under the provided VPC network.
   *
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The count of reservedIpRanges.
   */
  public int getReservedIpRangesCount() {
    return reservedIpRanges_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of names for the reserved IP ranges under the VPC network
   * that can be used for this persistent resource.
   *
   * If set, we will deploy the persistent resource within the provided IP
   * ranges. Otherwise, the persistent resource is deployed to any IP
   * ranges under the provided VPC network.
   *
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the element to return.
   * @return The reservedIpRanges at the given index.
   */
  public java.lang.String getReservedIpRanges(int index) {
    return reservedIpRanges_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. A list of names for the reserved IP ranges under the VPC network
   * that can be used for this persistent resource.
   *
   * If set, we will deploy the persistent resource within the provided IP
   * ranges. Otherwise, the persistent resource is deployed to any IP
   * ranges under the provided VPC network.
   *
   * Example: ['vertex-ai-ip-range'].
   * </pre>
   *
   * <code>repeated string reserved_ip_ranges = 15 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the reservedIpRanges at the given index.
   */
  public com.google.protobuf.ByteString getReservedIpRangesBytes(int index) {
    return reservedIpRanges_.getByteString(index);
  }

  public static final int SATISFIES_PZS_FIELD_NUMBER = 18;
  private boolean satisfiesPzs_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzs = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzs.
   */
  @java.lang.Override
  public boolean getSatisfiesPzs() {
    return satisfiesPzs_;
  }

  public static final int SATISFIES_PZI_FIELD_NUMBER = 19;
  private boolean satisfiesPzi_ = false;

  /**
   *
   *
   * <pre>
   * Output only. Reserved for future use.
   * </pre>
   *
   * <code>bool satisfies_pzi = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   *
   * @return The satisfiesPzi.
   */
  @java.lang.Override
  public boolean getSatisfiesPzi() {
    return satisfiesPzi_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    for (int i = 0; i < resourcePools_.size(); i++) {
      output.writeMessage(4, resourcePools_.get(i));
    }
    if (state_
        != com.google.cloud.aiplatform.v1beta1.PersistentResource.State.STATE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(5, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(6, getError());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(7, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeMessage(8, getStartTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      output.writeMessage(9, getUpdateTime());
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetLabels(), LabelsDefaultEntryHolder.defaultEntry, 10);
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 11, network_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(12, getEncryptionSpec());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      output.writeMessage(13, getResourceRuntimeSpec());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      output.writeMessage(14, getResourceRuntime());
    }
    for (int i = 0; i < reservedIpRanges_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, reservedIpRanges_.getRaw(i));
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeMessage(17, getPscInterfaceConfig());
    }
    if (satisfiesPzs_ != false) {
      output.writeBool(18, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      output.writeBool(19, satisfiesPzi_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    for (int i = 0; i < resourcePools_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, resourcePools_.get(i));
    }
    if (state_
        != com.google.cloud.aiplatform.v1beta1.PersistentResource.State.STATE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(5, state_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(6, getError());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(7, getCreateTime());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, getStartTime());
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getUpdateTime());
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetLabels().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
          LabelsDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, labels__);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(network_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(11, network_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(12, getEncryptionSpec());
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(13, getResourceRuntimeSpec());
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(14, getResourceRuntime());
    }
    {
      int dataSize = 0;
      for (int i = 0; i < reservedIpRanges_.size(); i++) {
        dataSize += computeStringSizeNoTag(reservedIpRanges_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getReservedIpRangesList().size();
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(17, getPscInterfaceConfig());
    }
    if (satisfiesPzs_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(18, satisfiesPzs_);
    }
    if (satisfiesPzi_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(19, satisfiesPzi_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.PersistentResource)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.PersistentResource other =
        (com.google.cloud.aiplatform.v1beta1.PersistentResource) obj;

    if (!getName().equals(other.getName())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getResourcePoolsList().equals(other.getResourcePoolsList())) return false;
    if (state_ != other.state_) return false;
    if (hasError() != other.hasError()) return false;
    if (hasError()) {
      if (!getError().equals(other.getError())) return false;
    }
    if (hasCreateTime() != other.hasCreateTime()) return false;
    if (hasCreateTime()) {
      if (!getCreateTime().equals(other.getCreateTime())) return false;
    }
    if (hasStartTime() != other.hasStartTime()) return false;
    if (hasStartTime()) {
      if (!getStartTime().equals(other.getStartTime())) return false;
    }
    if (hasUpdateTime() != other.hasUpdateTime()) return false;
    if (hasUpdateTime()) {
      if (!getUpdateTime().equals(other.getUpdateTime())) return false;
    }
    if (!internalGetLabels().equals(other.internalGetLabels())) return false;
    if (!getNetwork().equals(other.getNetwork())) return false;
    if (hasPscInterfaceConfig() != other.hasPscInterfaceConfig()) return false;
    if (hasPscInterfaceConfig()) {
      if (!getPscInterfaceConfig().equals(other.getPscInterfaceConfig())) return false;
    }
    if (hasEncryptionSpec() != other.hasEncryptionSpec()) return false;
    if (hasEncryptionSpec()) {
      if (!getEncryptionSpec().equals(other.getEncryptionSpec())) return false;
    }
    if (hasResourceRuntimeSpec() != other.hasResourceRuntimeSpec()) return false;
    if (hasResourceRuntimeSpec()) {
      if (!getResourceRuntimeSpec().equals(other.getResourceRuntimeSpec())) return false;
    }
    if (hasResourceRuntime() != other.hasResourceRuntime()) return false;
    if (hasResourceRuntime()) {
      if (!getResourceRuntime().equals(other.getResourceRuntime())) return false;
    }
    if (!getReservedIpRangesList().equals(other.getReservedIpRangesList())) return false;
    if (getSatisfiesPzs() != other.getSatisfiesPzs()) return false;
    if (getSatisfiesPzi() != other.getSatisfiesPzi()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    if (getResourcePoolsCount() > 0) {
      hash = (37 * hash) + RESOURCE_POOLS_FIELD_NUMBER;
      hash = (53 * hash) + getResourcePoolsList().hashCode();
    }
    hash = (37 * hash) + STATE_FIELD_NUMBER;
    hash = (53 * hash) + state_;
    if (hasError()) {
      hash = (37 * hash) + ERROR_FIELD_NUMBER;
      hash = (53 * hash) + getError().hashCode();
    }
    if (hasCreateTime()) {
      hash = (37 * hash) + CREATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getCreateTime().hashCode();
    }
    if (hasStartTime()) {
      hash = (37 * hash) + START_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getStartTime().hashCode();
    }
    if (hasUpdateTime()) {
      hash = (37 * hash) + UPDATE_TIME_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateTime().hashCode();
    }
    if (!internalGetLabels().getMap().isEmpty()) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetLabels().hashCode();
    }
    hash = (37 * hash) + NETWORK_FIELD_NUMBER;
    hash = (53 * hash) + getNetwork().hashCode();
    if (hasPscInterfaceConfig()) {
      hash = (37 * hash) + PSC_INTERFACE_CONFIG_FIELD_NUMBER;
      hash = (53 * hash) + getPscInterfaceConfig().hashCode();
    }
    if (hasEncryptionSpec()) {
      hash = (37 * hash) + ENCRYPTION_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getEncryptionSpec().hashCode();
    }
    if (hasResourceRuntimeSpec()) {
      hash = (37 * hash) + RESOURCE_RUNTIME_SPEC_FIELD_NUMBER;
      hash = (53 * hash) + getResourceRuntimeSpec().hashCode();
    }
    if (hasResourceRuntime()) {
      hash = (37 * hash) + RESOURCE_RUNTIME_FIELD_NUMBER;
      hash = (53 * hash) + getResourceRuntime().hashCode();
    }
    if (getReservedIpRangesCount() > 0) {
      hash = (37 * hash) + RESERVED_IP_RANGES_FIELD_NUMBER;
      hash = (53 * hash) + getReservedIpRangesList().hashCode();
    }
    hash = (37 * hash) + SATISFIES_PZS_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzs());
    hash = (37 * hash) + SATISFIES_PZI_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getSatisfiesPzi());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.PersistentResource parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PersistentResource parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PersistentResource parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PersistentResource parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PersistentResource parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.PersistentResource parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PersistentResource parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PersistentResource parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PersistentResource parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PersistentResource parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.PersistentResource parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.PersistentResource parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.PersistentResource prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Represents long-lasting resources that are dedicated to users to runs custom
   * workloads.
   * A PersistentResource can have multiple node pools and each node
   * pool can have its own machine spec.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.PersistentResource}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.PersistentResource)
      com.google.cloud.aiplatform.v1beta1.PersistentResourceOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.PersistentResourceProto
          .internal_static_google_cloud_aiplatform_v1beta1_PersistentResource_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 10:
          return internalGetLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 10:
          return internalGetMutableLabels();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.PersistentResourceProto
          .internal_static_google_cloud_aiplatform_v1beta1_PersistentResource_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.PersistentResource.class,
              com.google.cloud.aiplatform.v1beta1.PersistentResource.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.PersistentResource.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getResourcePoolsFieldBuilder();
        getErrorFieldBuilder();
        getCreateTimeFieldBuilder();
        getStartTimeFieldBuilder();
        getUpdateTimeFieldBuilder();
        getPscInterfaceConfigFieldBuilder();
        getEncryptionSpecFieldBuilder();
        getResourceRuntimeSpecFieldBuilder();
        getResourceRuntimeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      displayName_ = "";
      if (resourcePoolsBuilder_ == null) {
        resourcePools_ = java.util.Collections.emptyList();
      } else {
        resourcePools_ = null;
        resourcePoolsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000004);
      state_ = 0;
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      internalGetMutableLabels().clear();
      network_ = "";
      pscInterfaceConfig_ = null;
      if (pscInterfaceConfigBuilder_ != null) {
        pscInterfaceConfigBuilder_.dispose();
        pscInterfaceConfigBuilder_ = null;
      }
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      resourceRuntimeSpec_ = null;
      if (resourceRuntimeSpecBuilder_ != null) {
        resourceRuntimeSpecBuilder_.dispose();
        resourceRuntimeSpecBuilder_ = null;
      }
      resourceRuntime_ = null;
      if (resourceRuntimeBuilder_ != null) {
        resourceRuntimeBuilder_.dispose();
        resourceRuntimeBuilder_ = null;
      }
      reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      satisfiesPzs_ = false;
      satisfiesPzi_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.PersistentResourceProto
          .internal_static_google_cloud_aiplatform_v1beta1_PersistentResource_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PersistentResource getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.PersistentResource.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PersistentResource build() {
      com.google.cloud.aiplatform.v1beta1.PersistentResource result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PersistentResource buildPartial() {
      com.google.cloud.aiplatform.v1beta1.PersistentResource result =
          new com.google.cloud.aiplatform.v1beta1.PersistentResource(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.PersistentResource result) {
      if (resourcePoolsBuilder_ == null) {
        if (((bitField0_ & 0x00000004) != 0)) {
          resourcePools_ = java.util.Collections.unmodifiableList(resourcePools_);
          bitField0_ = (bitField0_ & ~0x00000004);
        }
        result.resourcePools_ = resourcePools_;
      } else {
        result.resourcePools_ = resourcePoolsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.PersistentResource result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.state_ = state_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.error_ = errorBuilder_ == null ? error_ : errorBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.createTime_ = createTimeBuilder_ == null ? createTime_ : createTimeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.startTime_ = startTimeBuilder_ == null ? startTime_ : startTimeBuilder_.build();
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.updateTime_ = updateTimeBuilder_ == null ? updateTime_ : updateTimeBuilder_.build();
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.labels_ = internalGetLabels();
        result.labels_.makeImmutable();
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.network_ = network_;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.pscInterfaceConfig_ =
            pscInterfaceConfigBuilder_ == null
                ? pscInterfaceConfig_
                : pscInterfaceConfigBuilder_.build();
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.encryptionSpec_ =
            encryptionSpecBuilder_ == null ? encryptionSpec_ : encryptionSpecBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.resourceRuntimeSpec_ =
            resourceRuntimeSpecBuilder_ == null
                ? resourceRuntimeSpec_
                : resourceRuntimeSpecBuilder_.build();
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.resourceRuntime_ =
            resourceRuntimeBuilder_ == null ? resourceRuntime_ : resourceRuntimeBuilder_.build();
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        reservedIpRanges_.makeImmutable();
        result.reservedIpRanges_ = reservedIpRanges_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.satisfiesPzs_ = satisfiesPzs_;
      }
      if (((from_bitField0_ & 0x00010000) != 0)) {
        result.satisfiesPzi_ = satisfiesPzi_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.PersistentResource) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.PersistentResource) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.PersistentResource other) {
      if (other == com.google.cloud.aiplatform.v1beta1.PersistentResource.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (resourcePoolsBuilder_ == null) {
        if (!other.resourcePools_.isEmpty()) {
          if (resourcePools_.isEmpty()) {
            resourcePools_ = other.resourcePools_;
            bitField0_ = (bitField0_ & ~0x00000004);
          } else {
            ensureResourcePoolsIsMutable();
            resourcePools_.addAll(other.resourcePools_);
          }
          onChanged();
        }
      } else {
        if (!other.resourcePools_.isEmpty()) {
          if (resourcePoolsBuilder_.isEmpty()) {
            resourcePoolsBuilder_.dispose();
            resourcePoolsBuilder_ = null;
            resourcePools_ = other.resourcePools_;
            bitField0_ = (bitField0_ & ~0x00000004);
            resourcePoolsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getResourcePoolsFieldBuilder()
                    : null;
          } else {
            resourcePoolsBuilder_.addAllMessages(other.resourcePools_);
          }
        }
      }
      if (other.state_ != 0) {
        setStateValue(other.getStateValue());
      }
      if (other.hasError()) {
        mergeError(other.getError());
      }
      if (other.hasCreateTime()) {
        mergeCreateTime(other.getCreateTime());
      }
      if (other.hasStartTime()) {
        mergeStartTime(other.getStartTime());
      }
      if (other.hasUpdateTime()) {
        mergeUpdateTime(other.getUpdateTime());
      }
      internalGetMutableLabels().mergeFrom(other.internalGetLabels());
      bitField0_ |= 0x00000100;
      if (!other.getNetwork().isEmpty()) {
        network_ = other.network_;
        bitField0_ |= 0x00000200;
        onChanged();
      }
      if (other.hasPscInterfaceConfig()) {
        mergePscInterfaceConfig(other.getPscInterfaceConfig());
      }
      if (other.hasEncryptionSpec()) {
        mergeEncryptionSpec(other.getEncryptionSpec());
      }
      if (other.hasResourceRuntimeSpec()) {
        mergeResourceRuntimeSpec(other.getResourceRuntimeSpec());
      }
      if (other.hasResourceRuntime()) {
        mergeResourceRuntime(other.getResourceRuntime());
      }
      if (!other.reservedIpRanges_.isEmpty()) {
        if (reservedIpRanges_.isEmpty()) {
          reservedIpRanges_ = other.reservedIpRanges_;
          bitField0_ |= 0x00004000;
        } else {
          ensureReservedIpRangesIsMutable();
          reservedIpRanges_.addAll(other.reservedIpRanges_);
        }
        onChanged();
      }
      if (other.getSatisfiesPzs() != false) {
        setSatisfiesPzs(other.getSatisfiesPzs());
      }
      if (other.getSatisfiesPzi() != false) {
        setSatisfiesPzi(other.getSatisfiesPzi());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 34:
              {
                com.google.cloud.aiplatform.v1beta1.ResourcePool m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.ResourcePool.parser(),
                        extensionRegistry);
                if (resourcePoolsBuilder_ == null) {
                  ensureResourcePoolsIsMutable();
                  resourcePools_.add(m);
                } else {
                  resourcePoolsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 40:
              {
                state_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 40
            case 50:
              {
                input.readMessage(getErrorFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(getCreateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case 58
            case 66:
              {
                input.readMessage(getStartTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000040;
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getUpdateTimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000080;
                break;
              } // case 74
            case 82:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> labels__ =
                    input.readMessage(
                        LabelsDefaultEntryHolder.defaultEntry.getParserForType(),
                        extensionRegistry);
                internalGetMutableLabels()
                    .getMutableMap()
                    .put(labels__.getKey(), labels__.getValue());
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 90:
              {
                network_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000200;
                break;
              } // case 90
            case 98:
              {
                input.readMessage(getEncryptionSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                input.readMessage(
                    getResourceRuntimeSpecFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 114:
              {
                input.readMessage(getResourceRuntimeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00002000;
                break;
              } // case 114
            case 122:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureReservedIpRangesIsMutable();
                reservedIpRanges_.add(s);
                break;
              } // case 122
            case 138:
              {
                input.readMessage(
                    getPscInterfaceConfigFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 138
            case 144:
              {
                satisfiesPzs_ = input.readBool();
                bitField0_ |= 0x00008000;
                break;
              } // case 144
            case 152:
              {
                satisfiesPzi_ = input.readBool();
                bitField0_ |= 0x00010000;
                break;
              } // case 152
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Immutable. Resource name of a PersistentResource.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Resource name of a PersistentResource.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Immutable. Resource name of a PersistentResource.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Resource name of a PersistentResource.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Immutable. Resource name of a PersistentResource.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The display name of the PersistentResource.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The display name of the PersistentResource.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The display name of the PersistentResource.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The display name of the PersistentResource.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The display name of the PersistentResource.
     * The name can be up to 128 characters long and can consist of any UTF-8
     * characters.
     * </pre>
     *
     * <code>string display_name = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1beta1.ResourcePool> resourcePools_ =
        java.util.Collections.emptyList();

    private void ensureResourcePoolsIsMutable() {
      if (!((bitField0_ & 0x00000004) != 0)) {
        resourcePools_ =
            new java.util.ArrayList<com.google.cloud.aiplatform.v1beta1.ResourcePool>(
                resourcePools_);
        bitField0_ |= 0x00000004;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ResourcePool,
            com.google.cloud.aiplatform.v1beta1.ResourcePool.Builder,
            com.google.cloud.aiplatform.v1beta1.ResourcePoolOrBuilder>
        resourcePoolsBuilder_;

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.ResourcePool> getResourcePoolsList() {
      if (resourcePoolsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(resourcePools_);
      } else {
        return resourcePoolsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public int getResourcePoolsCount() {
      if (resourcePoolsBuilder_ == null) {
        return resourcePools_.size();
      } else {
        return resourcePoolsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ResourcePool getResourcePools(int index) {
      if (resourcePoolsBuilder_ == null) {
        return resourcePools_.get(index);
      } else {
        return resourcePoolsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setResourcePools(
        int index, com.google.cloud.aiplatform.v1beta1.ResourcePool value) {
      if (resourcePoolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourcePoolsIsMutable();
        resourcePools_.set(index, value);
        onChanged();
      } else {
        resourcePoolsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder setResourcePools(
        int index, com.google.cloud.aiplatform.v1beta1.ResourcePool.Builder builderForValue) {
      if (resourcePoolsBuilder_ == null) {
        ensureResourcePoolsIsMutable();
        resourcePools_.set(index, builderForValue.build());
        onChanged();
      } else {
        resourcePoolsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addResourcePools(com.google.cloud.aiplatform.v1beta1.ResourcePool value) {
      if (resourcePoolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourcePoolsIsMutable();
        resourcePools_.add(value);
        onChanged();
      } else {
        resourcePoolsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addResourcePools(
        int index, com.google.cloud.aiplatform.v1beta1.ResourcePool value) {
      if (resourcePoolsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureResourcePoolsIsMutable();
        resourcePools_.add(index, value);
        onChanged();
      } else {
        resourcePoolsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addResourcePools(
        com.google.cloud.aiplatform.v1beta1.ResourcePool.Builder builderForValue) {
      if (resourcePoolsBuilder_ == null) {
        ensureResourcePoolsIsMutable();
        resourcePools_.add(builderForValue.build());
        onChanged();
      } else {
        resourcePoolsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addResourcePools(
        int index, com.google.cloud.aiplatform.v1beta1.ResourcePool.Builder builderForValue) {
      if (resourcePoolsBuilder_ == null) {
        ensureResourcePoolsIsMutable();
        resourcePools_.add(index, builderForValue.build());
        onChanged();
      } else {
        resourcePoolsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder addAllResourcePools(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1beta1.ResourcePool> values) {
      if (resourcePoolsBuilder_ == null) {
        ensureResourcePoolsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, resourcePools_);
        onChanged();
      } else {
        resourcePoolsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder clearResourcePools() {
      if (resourcePoolsBuilder_ == null) {
        resourcePools_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000004);
        onChanged();
      } else {
        resourcePoolsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public Builder removeResourcePools(int index) {
      if (resourcePoolsBuilder_ == null) {
        ensureResourcePoolsIsMutable();
        resourcePools_.remove(index);
        onChanged();
      } else {
        resourcePoolsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ResourcePool.Builder getResourcePoolsBuilder(
        int index) {
      return getResourcePoolsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ResourcePoolOrBuilder getResourcePoolsOrBuilder(
        int index) {
      if (resourcePoolsBuilder_ == null) {
        return resourcePools_.get(index);
      } else {
        return resourcePoolsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1beta1.ResourcePoolOrBuilder>
        getResourcePoolsOrBuilderList() {
      if (resourcePoolsBuilder_ != null) {
        return resourcePoolsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(resourcePools_);
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ResourcePool.Builder addResourcePoolsBuilder() {
      return getResourcePoolsFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1beta1.ResourcePool.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ResourcePool.Builder addResourcePoolsBuilder(
        int index) {
      return getResourcePoolsFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1beta1.ResourcePool.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Required. The spec of the pools of different resources.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.ResourcePool resource_pools = 4 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1beta1.ResourcePool.Builder>
        getResourcePoolsBuilderList() {
      return getResourcePoolsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ResourcePool,
            com.google.cloud.aiplatform.v1beta1.ResourcePool.Builder,
            com.google.cloud.aiplatform.v1beta1.ResourcePoolOrBuilder>
        getResourcePoolsFieldBuilder() {
      if (resourcePoolsBuilder_ == null) {
        resourcePoolsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ResourcePool,
                com.google.cloud.aiplatform.v1beta1.ResourcePool.Builder,
                com.google.cloud.aiplatform.v1beta1.ResourcePoolOrBuilder>(
                resourcePools_,
                ((bitField0_ & 0x00000004) != 0),
                getParentForChildren(),
                isClean());
        resourcePools_ = null;
      }
      return resourcePoolsBuilder_;
    }

    private int state_ = 0;

    /**
     *
     *
     * <pre>
     * Output only. The detailed state of a Study.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PersistentResource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The enum numeric value on the wire for state.
     */
    @java.lang.Override
    public int getStateValue() {
      return state_;
    }

    /**
     *
     *
     * <pre>
     * Output only. The detailed state of a Study.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PersistentResource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The enum numeric value on the wire for state to set.
     * @return This builder for chaining.
     */
    public Builder setStateValue(int value) {
      state_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The detailed state of a Study.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PersistentResource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The state.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.PersistentResource.State getState() {
      com.google.cloud.aiplatform.v1beta1.PersistentResource.State result =
          com.google.cloud.aiplatform.v1beta1.PersistentResource.State.forNumber(state_);
      return result == null
          ? com.google.cloud.aiplatform.v1beta1.PersistentResource.State.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Output only. The detailed state of a Study.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PersistentResource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @param value The state to set.
     * @return This builder for chaining.
     */
    public Builder setState(com.google.cloud.aiplatform.v1beta1.PersistentResource.State value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      state_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. The detailed state of a Study.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PersistentResource.State state = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearState() {
      bitField0_ = (bitField0_ & ~0x00000008);
      state_ = 0;
      onChanged();
      return this;
    }

    private com.google.rpc.Status error_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        errorBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Only populated when persistent resource's state is `STOPPING`
     * or `ERROR`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return Whether the error field is set.
     */
    public boolean hasError() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Only populated when persistent resource's state is `STOPPING`
     * or `ERROR`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The error.
     */
    public com.google.rpc.Status getError() {
      if (errorBuilder_ == null) {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      } else {
        return errorBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only populated when persistent resource's state is `STOPPING`
     * or `ERROR`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        error_ = value;
      } else {
        errorBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only populated when persistent resource's state is `STOPPING`
     * or `ERROR`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setError(com.google.rpc.Status.Builder builderForValue) {
      if (errorBuilder_ == null) {
        error_ = builderForValue.build();
      } else {
        errorBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only populated when persistent resource's state is `STOPPING`
     * or `ERROR`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergeError(com.google.rpc.Status value) {
      if (errorBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0)
            && error_ != null
            && error_ != com.google.rpc.Status.getDefaultInstance()) {
          getErrorBuilder().mergeFrom(value);
        } else {
          error_ = value;
        }
      } else {
        errorBuilder_.mergeFrom(value);
      }
      if (error_ != null) {
        bitField0_ |= 0x00000010;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only populated when persistent resource's state is `STOPPING`
     * or `ERROR`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearError() {
      bitField0_ = (bitField0_ & ~0x00000010);
      error_ = null;
      if (errorBuilder_ != null) {
        errorBuilder_.dispose();
        errorBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Only populated when persistent resource's state is `STOPPING`
     * or `ERROR`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.Status.Builder getErrorBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getErrorFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Only populated when persistent resource's state is `STOPPING`
     * or `ERROR`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.rpc.StatusOrBuilder getErrorOrBuilder() {
      if (errorBuilder_ != null) {
        return errorBuilder_.getMessageOrBuilder();
      } else {
        return error_ == null ? com.google.rpc.Status.getDefaultInstance() : error_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Only populated when persistent resource's state is `STOPPING`
     * or `ERROR`.
     * </pre>
     *
     * <code>.google.rpc.Status error = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.rpc.Status, com.google.rpc.Status.Builder, com.google.rpc.StatusOrBuilder>
        getErrorFieldBuilder() {
      if (errorBuilder_ == null) {
        errorBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.rpc.Status,
                com.google.rpc.Status.Builder,
                com.google.rpc.StatusOrBuilder>(getError(), getParentForChildren(), isClean());
        error_ = null;
      }
      return errorBuilder_;
    }

    private com.google.protobuf.Timestamp createTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        createTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the createTime field is set.
     */
    public boolean hasCreateTime() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The createTime.
     */
    public com.google.protobuf.Timestamp getCreateTime() {
      if (createTimeBuilder_ == null) {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      } else {
        return createTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        createTime_ = value;
      } else {
        createTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setCreateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (createTimeBuilder_ == null) {
        createTime_ = builderForValue.build();
      } else {
        createTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeCreateTime(com.google.protobuf.Timestamp value) {
      if (createTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && createTime_ != null
            && createTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getCreateTimeBuilder().mergeFrom(value);
        } else {
          createTime_ = value;
        }
      } else {
        createTimeBuilder_.mergeFrom(value);
      }
      if (createTime_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearCreateTime() {
      bitField0_ = (bitField0_ & ~0x00000020);
      createTime_ = null;
      if (createTimeBuilder_ != null) {
        createTimeBuilder_.dispose();
        createTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getCreateTimeBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getCreateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getCreateTimeOrBuilder() {
      if (createTimeBuilder_ != null) {
        return createTimeBuilder_.getMessageOrBuilder();
      } else {
        return createTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : createTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was created.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp create_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getCreateTimeFieldBuilder() {
      if (createTimeBuilder_ == null) {
        createTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getCreateTime(), getParentForChildren(), isClean());
        createTime_ = null;
      }
      return createTimeBuilder_;
    }

    private com.google.protobuf.Timestamp startTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        startTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource for the first time entered
     * the `RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the startTime field is set.
     */
    public boolean hasStartTime() {
      return ((bitField0_ & 0x00000040) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource for the first time entered
     * the `RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The startTime.
     */
    public com.google.protobuf.Timestamp getStartTime() {
      if (startTimeBuilder_ == null) {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      } else {
        return startTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource for the first time entered
     * the `RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        startTime_ = value;
      } else {
        startTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource for the first time entered
     * the `RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setStartTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (startTimeBuilder_ == null) {
        startTime_ = builderForValue.build();
      } else {
        startTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource for the first time entered
     * the `RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeStartTime(com.google.protobuf.Timestamp value) {
      if (startTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000040) != 0)
            && startTime_ != null
            && startTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getStartTimeBuilder().mergeFrom(value);
        } else {
          startTime_ = value;
        }
      } else {
        startTimeBuilder_.mergeFrom(value);
      }
      if (startTime_ != null) {
        bitField0_ |= 0x00000040;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource for the first time entered
     * the `RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearStartTime() {
      bitField0_ = (bitField0_ & ~0x00000040);
      startTime_ = null;
      if (startTimeBuilder_ != null) {
        startTimeBuilder_.dispose();
        startTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource for the first time entered
     * the `RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getStartTimeBuilder() {
      bitField0_ |= 0x00000040;
      onChanged();
      return getStartTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource for the first time entered
     * the `RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getStartTimeOrBuilder() {
      if (startTimeBuilder_ != null) {
        return startTimeBuilder_.getMessageOrBuilder();
      } else {
        return startTime_ == null ? com.google.protobuf.Timestamp.getDefaultInstance() : startTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource for the first time entered
     * the `RUNNING` state.
     * </pre>
     *
     * <code>.google.protobuf.Timestamp start_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getStartTimeFieldBuilder() {
      if (startTimeBuilder_ == null) {
        startTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getStartTime(), getParentForChildren(), isClean());
        startTime_ = null;
      }
      return startTimeBuilder_;
    }

    private com.google.protobuf.Timestamp updateTime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        updateTimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the updateTime field is set.
     */
    public boolean hasUpdateTime() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The updateTime.
     */
    public com.google.protobuf.Timestamp getUpdateTime() {
      if (updateTimeBuilder_ == null) {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      } else {
        return updateTimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateTime_ = value;
      } else {
        updateTimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setUpdateTime(com.google.protobuf.Timestamp.Builder builderForValue) {
      if (updateTimeBuilder_ == null) {
        updateTime_ = builderForValue.build();
      } else {
        updateTimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeUpdateTime(com.google.protobuf.Timestamp value) {
      if (updateTimeBuilder_ == null) {
        if (((bitField0_ & 0x00000080) != 0)
            && updateTime_ != null
            && updateTime_ != com.google.protobuf.Timestamp.getDefaultInstance()) {
          getUpdateTimeBuilder().mergeFrom(value);
        } else {
          updateTime_ = value;
        }
      } else {
        updateTimeBuilder_.mergeFrom(value);
      }
      if (updateTime_ != null) {
        bitField0_ |= 0x00000080;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearUpdateTime() {
      bitField0_ = (bitField0_ & ~0x00000080);
      updateTime_ = null;
      if (updateTimeBuilder_ != null) {
        updateTimeBuilder_.dispose();
        updateTimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.Timestamp.Builder getUpdateTimeBuilder() {
      bitField0_ |= 0x00000080;
      onChanged();
      return getUpdateTimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.protobuf.TimestampOrBuilder getUpdateTimeOrBuilder() {
      if (updateTimeBuilder_ != null) {
        return updateTimeBuilder_.getMessageOrBuilder();
      } else {
        return updateTime_ == null
            ? com.google.protobuf.Timestamp.getDefaultInstance()
            : updateTime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Time when the PersistentResource was most recently updated.
     * </pre>
     *
     * <code>
     * .google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Timestamp,
            com.google.protobuf.Timestamp.Builder,
            com.google.protobuf.TimestampOrBuilder>
        getUpdateTimeFieldBuilder() {
      if (updateTimeBuilder_ == null) {
        updateTimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Timestamp,
                com.google.protobuf.Timestamp.Builder,
                com.google.protobuf.TimestampOrBuilder>(
                getUpdateTime(), getParentForChildren(), isClean());
        updateTime_ = null;
      }
      return updateTimeBuilder_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> labels_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetLabels() {
      if (labels_ == null) {
        return com.google.protobuf.MapField.emptyMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      return labels_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableLabels() {
      if (labels_ == null) {
        labels_ = com.google.protobuf.MapField.newMapField(LabelsDefaultEntryHolder.defaultEntry);
      }
      if (!labels_.isMutable()) {
        labels_ = labels_.copy();
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return labels_;
    }

    public int getLabelsCount() {
      return internalGetLabels().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize
     * PersistentResource.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public boolean containsLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetLabels().getMap().containsKey(key);
    }

    /** Use {@link #getLabelsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getLabels() {
      return getLabelsMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize
     * PersistentResource.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getLabelsMap() {
      return internalGetLabels().getMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize
     * PersistentResource.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getLabelsOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize
     * PersistentResource.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    @java.lang.Override
    public java.lang.String getLabelsOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetLabels().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearLabels() {
      bitField0_ = (bitField0_ & ~0x00000100);
      internalGetMutableLabels().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize
     * PersistentResource.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder removeLabels(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableLabels().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableLabels() {
      bitField0_ |= 0x00000100;
      return internalGetMutableLabels().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize
     * PersistentResource.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putLabels(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableLabels().getMutableMap().put(key, value);
      bitField0_ |= 0x00000100;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The labels with user-defined metadata to organize
     * PersistentResource.
     *
     * Label keys and values can be no longer than 64 characters
     * (Unicode codepoints), can only contain lowercase letters, numeric
     * characters, underscores and dashes. International characters are allowed.
     *
     * See https://goo.gl/xmQnxf for more information and examples of labels.
     * </pre>
     *
     * <code>map&lt;string, string&gt; labels = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    public Builder putAllLabels(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableLabels().getMutableMap().putAll(values);
      bitField0_ |= 0x00000100;
      return this;
    }

    private java.lang.Object network_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to peered with
     * Vertex AI to host the persistent resources.
     * For example, `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * To specify this field, you must have already [configured VPC Network
     * Peering for Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
     *
     * If this field is left unspecified, the resources aren't peered with any
     * network.
     * </pre>
     *
     * <code>
     * string network = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The network.
     */
    public java.lang.String getNetwork() {
      java.lang.Object ref = network_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        network_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to peered with
     * Vertex AI to host the persistent resources.
     * For example, `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * To specify this field, you must have already [configured VPC Network
     * Peering for Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
     *
     * If this field is left unspecified, the resources aren't peered with any
     * network.
     * </pre>
     *
     * <code>
     * string network = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for network.
     */
    public com.google.protobuf.ByteString getNetworkBytes() {
      java.lang.Object ref = network_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        network_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to peered with
     * Vertex AI to host the persistent resources.
     * For example, `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * To specify this field, you must have already [configured VPC Network
     * Peering for Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
     *
     * If this field is left unspecified, the resources aren't peered with any
     * network.
     * </pre>
     *
     * <code>
     * string network = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The network to set.
     * @return This builder for chaining.
     */
    public Builder setNetwork(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      network_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to peered with
     * Vertex AI to host the persistent resources.
     * For example, `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * To specify this field, you must have already [configured VPC Network
     * Peering for Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
     *
     * If this field is left unspecified, the resources aren't peered with any
     * network.
     * </pre>
     *
     * <code>
     * string network = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNetwork() {
      network_ = getDefaultInstance().getNetwork();
      bitField0_ = (bitField0_ & ~0x00000200);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The full name of the Compute Engine
     * [network](/compute/docs/networks-and-firewalls#networks) to peered with
     * Vertex AI to host the persistent resources.
     * For example, `projects/12345/global/networks/myVPC`.
     * [Format](/compute/docs/reference/rest/v1/networks/insert)
     * is of the form `projects/{project}/global/networks/{network}`.
     * Where {project} is a project number, as in `12345`, and {network} is a
     * network name.
     *
     * To specify this field, you must have already [configured VPC Network
     * Peering for Vertex
     * AI](https://cloud.google.com/vertex-ai/docs/general/vpc-peering).
     *
     * If this field is left unspecified, the resources aren't peered with any
     * network.
     * </pre>
     *
     * <code>
     * string network = 11 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for network to set.
     * @return This builder for chaining.
     */
    public Builder setNetworkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      network_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    private com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig pscInterfaceConfig_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig,
            com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.PscInterfaceConfigOrBuilder>
        pscInterfaceConfigBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PersistentResource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the pscInterfaceConfig field is set.
     */
    public boolean hasPscInterfaceConfig() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PersistentResource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The pscInterfaceConfig.
     */
    public com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig getPscInterfaceConfig() {
      if (pscInterfaceConfigBuilder_ == null) {
        return pscInterfaceConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.getDefaultInstance()
            : pscInterfaceConfig_;
      } else {
        return pscInterfaceConfigBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PersistentResource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPscInterfaceConfig(
        com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig value) {
      if (pscInterfaceConfigBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        pscInterfaceConfig_ = value;
      } else {
        pscInterfaceConfigBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PersistentResource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setPscInterfaceConfig(
        com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.Builder builderForValue) {
      if (pscInterfaceConfigBuilder_ == null) {
        pscInterfaceConfig_ = builderForValue.build();
      } else {
        pscInterfaceConfigBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PersistentResource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergePscInterfaceConfig(
        com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig value) {
      if (pscInterfaceConfigBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && pscInterfaceConfig_ != null
            && pscInterfaceConfig_
                != com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.getDefaultInstance()) {
          getPscInterfaceConfigBuilder().mergeFrom(value);
        } else {
          pscInterfaceConfig_ = value;
        }
      } else {
        pscInterfaceConfigBuilder_.mergeFrom(value);
      }
      if (pscInterfaceConfig_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PersistentResource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearPscInterfaceConfig() {
      bitField0_ = (bitField0_ & ~0x00000400);
      pscInterfaceConfig_ = null;
      if (pscInterfaceConfigBuilder_ != null) {
        pscInterfaceConfigBuilder_.dispose();
        pscInterfaceConfigBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PersistentResource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.Builder
        getPscInterfaceConfigBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getPscInterfaceConfigFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PersistentResource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.PscInterfaceConfigOrBuilder
        getPscInterfaceConfigOrBuilder() {
      if (pscInterfaceConfigBuilder_ != null) {
        return pscInterfaceConfigBuilder_.getMessageOrBuilder();
      } else {
        return pscInterfaceConfig_ == null
            ? com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.getDefaultInstance()
            : pscInterfaceConfig_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Configuration for PSC-I for PersistentResource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.PscInterfaceConfig psc_interface_config = 17 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig,
            com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.Builder,
            com.google.cloud.aiplatform.v1beta1.PscInterfaceConfigOrBuilder>
        getPscInterfaceConfigFieldBuilder() {
      if (pscInterfaceConfigBuilder_ == null) {
        pscInterfaceConfigBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig,
                com.google.cloud.aiplatform.v1beta1.PscInterfaceConfig.Builder,
                com.google.cloud.aiplatform.v1beta1.PscInterfaceConfigOrBuilder>(
                getPscInterfaceConfig(), getParentForChildren(), isClean());
        pscInterfaceConfig_ = null;
      }
      return pscInterfaceConfigBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.EncryptionSpec encryptionSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        encryptionSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for a PersistentResource.
     * If set, this PersistentResource and all sub-resources of this
     * PersistentResource will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the encryptionSpec field is set.
     */
    public boolean hasEncryptionSpec() {
      return ((bitField0_ & 0x00000800) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for a PersistentResource.
     * If set, this PersistentResource and all sub-resources of this
     * PersistentResource will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The encryptionSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec getEncryptionSpec() {
      if (encryptionSpecBuilder_ == null) {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      } else {
        return encryptionSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for a PersistentResource.
     * If set, this PersistentResource and all sub-resources of this
     * PersistentResource will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        encryptionSpec_ = value;
      } else {
        encryptionSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for a PersistentResource.
     * If set, this PersistentResource and all sub-resources of this
     * PersistentResource will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setEncryptionSpec(
        com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder builderForValue) {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpec_ = builderForValue.build();
      } else {
        encryptionSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for a PersistentResource.
     * If set, this PersistentResource and all sub-resources of this
     * PersistentResource will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeEncryptionSpec(com.google.cloud.aiplatform.v1beta1.EncryptionSpec value) {
      if (encryptionSpecBuilder_ == null) {
        if (((bitField0_ & 0x00000800) != 0)
            && encryptionSpec_ != null
            && encryptionSpec_
                != com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()) {
          getEncryptionSpecBuilder().mergeFrom(value);
        } else {
          encryptionSpec_ = value;
        }
      } else {
        encryptionSpecBuilder_.mergeFrom(value);
      }
      if (encryptionSpec_ != null) {
        bitField0_ |= 0x00000800;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for a PersistentResource.
     * If set, this PersistentResource and all sub-resources of this
     * PersistentResource will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearEncryptionSpec() {
      bitField0_ = (bitField0_ & ~0x00000800);
      encryptionSpec_ = null;
      if (encryptionSpecBuilder_ != null) {
        encryptionSpecBuilder_.dispose();
        encryptionSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for a PersistentResource.
     * If set, this PersistentResource and all sub-resources of this
     * PersistentResource will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder getEncryptionSpecBuilder() {
      bitField0_ |= 0x00000800;
      onChanged();
      return getEncryptionSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for a PersistentResource.
     * If set, this PersistentResource and all sub-resources of this
     * PersistentResource will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder
        getEncryptionSpecOrBuilder() {
      if (encryptionSpecBuilder_ != null) {
        return encryptionSpecBuilder_.getMessageOrBuilder();
      } else {
        return encryptionSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.EncryptionSpec.getDefaultInstance()
            : encryptionSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Customer-managed encryption key spec for a PersistentResource.
     * If set, this PersistentResource and all sub-resources of this
     * PersistentResource will be secured by this key.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.EncryptionSpec encryption_spec = 12 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>
        getEncryptionSpecFieldBuilder() {
      if (encryptionSpecBuilder_ == null) {
        encryptionSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.EncryptionSpecOrBuilder>(
                getEncryptionSpec(), getParentForChildren(), isClean());
        encryptionSpec_ = null;
      }
      return encryptionSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec resourceRuntimeSpec_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec,
            com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpecOrBuilder>
        resourceRuntimeSpecBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Persistent Resource runtime spec.
     * For example, used for Ray cluster configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec resource_runtime_spec = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the resourceRuntimeSpec field is set.
     */
    public boolean hasResourceRuntimeSpec() {
      return ((bitField0_ & 0x00001000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Persistent Resource runtime spec.
     * For example, used for Ray cluster configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec resource_runtime_spec = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The resourceRuntimeSpec.
     */
    public com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec getResourceRuntimeSpec() {
      if (resourceRuntimeSpecBuilder_ == null) {
        return resourceRuntimeSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec.getDefaultInstance()
            : resourceRuntimeSpec_;
      } else {
        return resourceRuntimeSpecBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Persistent Resource runtime spec.
     * For example, used for Ray cluster configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec resource_runtime_spec = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setResourceRuntimeSpec(
        com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec value) {
      if (resourceRuntimeSpecBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceRuntimeSpec_ = value;
      } else {
        resourceRuntimeSpecBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Persistent Resource runtime spec.
     * For example, used for Ray cluster configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec resource_runtime_spec = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setResourceRuntimeSpec(
        com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec.Builder builderForValue) {
      if (resourceRuntimeSpecBuilder_ == null) {
        resourceRuntimeSpec_ = builderForValue.build();
      } else {
        resourceRuntimeSpecBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Persistent Resource runtime spec.
     * For example, used for Ray cluster configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec resource_runtime_spec = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeResourceRuntimeSpec(
        com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec value) {
      if (resourceRuntimeSpecBuilder_ == null) {
        if (((bitField0_ & 0x00001000) != 0)
            && resourceRuntimeSpec_ != null
            && resourceRuntimeSpec_
                != com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec.getDefaultInstance()) {
          getResourceRuntimeSpecBuilder().mergeFrom(value);
        } else {
          resourceRuntimeSpec_ = value;
        }
      } else {
        resourceRuntimeSpecBuilder_.mergeFrom(value);
      }
      if (resourceRuntimeSpec_ != null) {
        bitField0_ |= 0x00001000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Persistent Resource runtime spec.
     * For example, used for Ray cluster configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec resource_runtime_spec = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearResourceRuntimeSpec() {
      bitField0_ = (bitField0_ & ~0x00001000);
      resourceRuntimeSpec_ = null;
      if (resourceRuntimeSpecBuilder_ != null) {
        resourceRuntimeSpecBuilder_.dispose();
        resourceRuntimeSpecBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Persistent Resource runtime spec.
     * For example, used for Ray cluster configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec resource_runtime_spec = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec.Builder
        getResourceRuntimeSpecBuilder() {
      bitField0_ |= 0x00001000;
      onChanged();
      return getResourceRuntimeSpecFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Persistent Resource runtime spec.
     * For example, used for Ray cluster configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec resource_runtime_spec = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpecOrBuilder
        getResourceRuntimeSpecOrBuilder() {
      if (resourceRuntimeSpecBuilder_ != null) {
        return resourceRuntimeSpecBuilder_.getMessageOrBuilder();
      } else {
        return resourceRuntimeSpec_ == null
            ? com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec.getDefaultInstance()
            : resourceRuntimeSpec_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Persistent Resource runtime spec.
     * For example, used for Ray cluster configuration.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec resource_runtime_spec = 13 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec,
            com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec.Builder,
            com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpecOrBuilder>
        getResourceRuntimeSpecFieldBuilder() {
      if (resourceRuntimeSpecBuilder_ == null) {
        resourceRuntimeSpecBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec,
                com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpec.Builder,
                com.google.cloud.aiplatform.v1beta1.ResourceRuntimeSpecOrBuilder>(
                getResourceRuntimeSpec(), getParentForChildren(), isClean());
        resourceRuntimeSpec_ = null;
      }
      return resourceRuntimeSpecBuilder_;
    }

    private com.google.cloud.aiplatform.v1beta1.ResourceRuntime resourceRuntime_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ResourceRuntime,
            com.google.cloud.aiplatform.v1beta1.ResourceRuntime.Builder,
            com.google.cloud.aiplatform.v1beta1.ResourceRuntimeOrBuilder>
        resourceRuntimeBuilder_;

    /**
     *
     *
     * <pre>
     * Output only. Runtime information of the Persistent Resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntime resource_runtime = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return Whether the resourceRuntime field is set.
     */
    public boolean hasResourceRuntime() {
      return ((bitField0_ & 0x00002000) != 0);
    }

    /**
     *
     *
     * <pre>
     * Output only. Runtime information of the Persistent Resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntime resource_runtime = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     *
     * @return The resourceRuntime.
     */
    public com.google.cloud.aiplatform.v1beta1.ResourceRuntime getResourceRuntime() {
      if (resourceRuntimeBuilder_ == null) {
        return resourceRuntime_ == null
            ? com.google.cloud.aiplatform.v1beta1.ResourceRuntime.getDefaultInstance()
            : resourceRuntime_;
      } else {
        return resourceRuntimeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Runtime information of the Persistent Resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntime resource_runtime = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResourceRuntime(com.google.cloud.aiplatform.v1beta1.ResourceRuntime value) {
      if (resourceRuntimeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        resourceRuntime_ = value;
      } else {
        resourceRuntimeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Runtime information of the Persistent Resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntime resource_runtime = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder setResourceRuntime(
        com.google.cloud.aiplatform.v1beta1.ResourceRuntime.Builder builderForValue) {
      if (resourceRuntimeBuilder_ == null) {
        resourceRuntime_ = builderForValue.build();
      } else {
        resourceRuntimeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Runtime information of the Persistent Resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntime resource_runtime = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder mergeResourceRuntime(com.google.cloud.aiplatform.v1beta1.ResourceRuntime value) {
      if (resourceRuntimeBuilder_ == null) {
        if (((bitField0_ & 0x00002000) != 0)
            && resourceRuntime_ != null
            && resourceRuntime_
                != com.google.cloud.aiplatform.v1beta1.ResourceRuntime.getDefaultInstance()) {
          getResourceRuntimeBuilder().mergeFrom(value);
        } else {
          resourceRuntime_ = value;
        }
      } else {
        resourceRuntimeBuilder_.mergeFrom(value);
      }
      if (resourceRuntime_ != null) {
        bitField0_ |= 0x00002000;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Runtime information of the Persistent Resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntime resource_runtime = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public Builder clearResourceRuntime() {
      bitField0_ = (bitField0_ & ~0x00002000);
      resourceRuntime_ = null;
      if (resourceRuntimeBuilder_ != null) {
        resourceRuntimeBuilder_.dispose();
        resourceRuntimeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Runtime information of the Persistent Resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntime resource_runtime = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ResourceRuntime.Builder getResourceRuntimeBuilder() {
      bitField0_ |= 0x00002000;
      onChanged();
      return getResourceRuntimeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Output only. Runtime information of the Persistent Resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntime resource_runtime = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.ResourceRuntimeOrBuilder
        getResourceRuntimeOrBuilder() {
      if (resourceRuntimeBuilder_ != null) {
        return resourceRuntimeBuilder_.getMessageOrBuilder();
      } else {
        return resourceRuntime_ == null
            ? com.google.cloud.aiplatform.v1beta1.ResourceRuntime.getDefaultInstance()
            : resourceRuntime_;
      }
    }

    /**
     *
     *
     * <pre>
     * Output only. Runtime information of the Persistent Resource.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.ResourceRuntime resource_runtime = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.ResourceRuntime,
            com.google.cloud.aiplatform.v1beta1.ResourceRuntime.Builder,
            com.google.cloud.aiplatform.v1beta1.ResourceRuntimeOrBuilder>
        getResourceRuntimeFieldBuilder() {
      if (resourceRuntimeBuilder_ == null) {
        resourceRuntimeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.ResourceRuntime,
                com.google.cloud.aiplatform.v1beta1.ResourceRuntime.Builder,
                com.google.cloud.aiplatform.v1beta1.ResourceRuntimeOrBuilder>(
                getResourceRuntime(), getParentForChildren(), isClean());
        resourceRuntime_ = null;
      }
      return resourceRuntimeBuilder_;
    }

    private com.google.protobuf.LazyStringArrayList reservedIpRanges_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureReservedIpRangesIsMutable() {
      if (!reservedIpRanges_.isModifiable()) {
        reservedIpRanges_ = new com.google.protobuf.LazyStringArrayList(reservedIpRanges_);
      }
      bitField0_ |= 0x00004000;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved IP ranges under the VPC network
     * that can be used for this persistent resource.
     *
     * If set, we will deploy the persistent resource within the provided IP
     * ranges. Otherwise, the persistent resource is deployed to any IP
     * ranges under the provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return A list containing the reservedIpRanges.
     */
    public com.google.protobuf.ProtocolStringList getReservedIpRangesList() {
      reservedIpRanges_.makeImmutable();
      return reservedIpRanges_;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved IP ranges under the VPC network
     * that can be used for this persistent resource.
     *
     * If set, we will deploy the persistent resource within the provided IP
     * ranges. Otherwise, the persistent resource is deployed to any IP
     * ranges under the provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The count of reservedIpRanges.
     */
    public int getReservedIpRangesCount() {
      return reservedIpRanges_.size();
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved IP ranges under the VPC network
     * that can be used for this persistent resource.
     *
     * If set, we will deploy the persistent resource within the provided IP
     * ranges. Otherwise, the persistent resource is deployed to any IP
     * ranges under the provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the element to return.
     * @return The reservedIpRanges at the given index.
     */
    public java.lang.String getReservedIpRanges(int index) {
      return reservedIpRanges_.get(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved IP ranges under the VPC network
     * that can be used for this persistent resource.
     *
     * If set, we will deploy the persistent resource within the provided IP
     * ranges. Otherwise, the persistent resource is deployed to any IP
     * ranges under the provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the reservedIpRanges at the given index.
     */
    public com.google.protobuf.ByteString getReservedIpRangesBytes(int index) {
      return reservedIpRanges_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved IP ranges under the VPC network
     * that can be used for this persistent resource.
     *
     * If set, we will deploy the persistent resource within the provided IP
     * ranges. Otherwise, the persistent resource is deployed to any IP
     * ranges under the provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param index The index to set the value at.
     * @param value The reservedIpRanges to set.
     * @return This builder for chaining.
     */
    public Builder setReservedIpRanges(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.set(index, value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved IP ranges under the VPC network
     * that can be used for this persistent resource.
     *
     * If set, we will deploy the persistent resource within the provided IP
     * ranges. Otherwise, the persistent resource is deployed to any IP
     * ranges under the provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addReservedIpRanges(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.add(value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved IP ranges under the VPC network
     * that can be used for this persistent resource.
     *
     * If set, we will deploy the persistent resource within the provided IP
     * ranges. Otherwise, the persistent resource is deployed to any IP
     * ranges under the provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param values The reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addAllReservedIpRanges(java.lang.Iterable<java.lang.String> values) {
      ensureReservedIpRangesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, reservedIpRanges_);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved IP ranges under the VPC network
     * that can be used for this persistent resource.
     *
     * If set, we will deploy the persistent resource within the provided IP
     * ranges. Otherwise, the persistent resource is deployed to any IP
     * ranges under the provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearReservedIpRanges() {
      reservedIpRanges_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00004000);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A list of names for the reserved IP ranges under the VPC network
     * that can be used for this persistent resource.
     *
     * If set, we will deploy the persistent resource within the provided IP
     * ranges. Otherwise, the persistent resource is deployed to any IP
     * ranges under the provided VPC network.
     *
     * Example: ['vertex-ai-ip-range'].
     * </pre>
     *
     * <code>repeated string reserved_ip_ranges = 15 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The bytes of the reservedIpRanges to add.
     * @return This builder for chaining.
     */
    public Builder addReservedIpRangesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureReservedIpRangesIsMutable();
      reservedIpRanges_.add(value);
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }

    private boolean satisfiesPzs_;

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzs.
     */
    @java.lang.Override
    public boolean getSatisfiesPzs() {
      return satisfiesPzs_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzs to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzs(boolean value) {

      satisfiesPzs_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzs = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzs() {
      bitField0_ = (bitField0_ & ~0x00008000);
      satisfiesPzs_ = false;
      onChanged();
      return this;
    }

    private boolean satisfiesPzi_;

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return The satisfiesPzi.
     */
    @java.lang.Override
    public boolean getSatisfiesPzi() {
      return satisfiesPzi_;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @param value The satisfiesPzi to set.
     * @return This builder for chaining.
     */
    public Builder setSatisfiesPzi(boolean value) {

      satisfiesPzi_ = value;
      bitField0_ |= 0x00010000;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Output only. Reserved for future use.
     * </pre>
     *
     * <code>bool satisfies_pzi = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSatisfiesPzi() {
      bitField0_ = (bitField0_ & ~0x00010000);
      satisfiesPzi_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.PersistentResource)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.PersistentResource)
  private static final com.google.cloud.aiplatform.v1beta1.PersistentResource DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.PersistentResource();
  }

  public static com.google.cloud.aiplatform.v1beta1.PersistentResource getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<PersistentResource> PARSER =
      new com.google.protobuf.AbstractParser<PersistentResource>() {
        @java.lang.Override
        public PersistentResource parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<PersistentResource> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<PersistentResource> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.PersistentResource getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
