/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/memory_bank_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Request message for
 * [MemoryBankService.RetrieveMemories][google.cloud.aiplatform.v1beta1.MemoryBankService.RetrieveMemories].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest}
 */
public final class RetrieveMemoriesRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest)
    RetrieveMemoriesRequestOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RetrieveMemoriesRequest.newBuilder() to construct.
  private RetrieveMemoriesRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RetrieveMemoriesRequest() {
    parent_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RetrieveMemoriesRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesRequest_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 8:
        return internalGetScope();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.class,
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.Builder.class);
  }

  public interface SimilaritySearchParamsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. Query to use for similarity search retrieval. If provided, then
     * the parent ReasoningEngine must have
     * [ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig][google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig]
     * set.
     * </pre>
     *
     * <code>string search_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The searchQuery.
     */
    java.lang.String getSearchQuery();

    /**
     *
     *
     * <pre>
     * Required. Query to use for similarity search retrieval. If provided, then
     * the parent ReasoningEngine must have
     * [ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig][google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig]
     * set.
     * </pre>
     *
     * <code>string search_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for searchQuery.
     */
    com.google.protobuf.ByteString getSearchQueryBytes();

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of memories to return.
     * The service may return fewer than this value. If unspecified, at most 3
     * memories will be returned. The maximum value is 100; values above 100
     * will be coerced to 100.
     * </pre>
     *
     * <code>int32 top_k = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The topK.
     */
    int getTopK();
  }

  /**
   *
   *
   * <pre>
   * Parameters for semantic similarity search based retrieval.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams}
   */
  public static final class SimilaritySearchParams extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams)
      SimilaritySearchParamsOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use SimilaritySearchParams.newBuilder() to construct.
    private SimilaritySearchParams(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SimilaritySearchParams() {
      searchQuery_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SimilaritySearchParams();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesRequest_SimilaritySearchParams_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesRequest_SimilaritySearchParams_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
                  .class,
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
                  .Builder.class);
    }

    public static final int SEARCH_QUERY_FIELD_NUMBER = 1;

    @SuppressWarnings("serial")
    private volatile java.lang.Object searchQuery_ = "";

    /**
     *
     *
     * <pre>
     * Required. Query to use for similarity search retrieval. If provided, then
     * the parent ReasoningEngine must have
     * [ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig][google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig]
     * set.
     * </pre>
     *
     * <code>string search_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The searchQuery.
     */
    @java.lang.Override
    public java.lang.String getSearchQuery() {
      java.lang.Object ref = searchQuery_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        searchQuery_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. Query to use for similarity search retrieval. If provided, then
     * the parent ReasoningEngine must have
     * [ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig][google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig]
     * set.
     * </pre>
     *
     * <code>string search_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for searchQuery.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getSearchQueryBytes() {
      java.lang.Object ref = searchQuery_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        searchQuery_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    public static final int TOP_K_FIELD_NUMBER = 2;
    private int topK_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of memories to return.
     * The service may return fewer than this value. If unspecified, at most 3
     * memories will be returned. The maximum value is 100; values above 100
     * will be coerced to 100.
     * </pre>
     *
     * <code>int32 top_k = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The topK.
     */
    @java.lang.Override
    public int getTopK() {
      return topK_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(searchQuery_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 1, searchQuery_);
      }
      if (topK_ != 0) {
        output.writeInt32(2, topK_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(searchQuery_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, searchQuery_);
      }
      if (topK_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(2, topK_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams other =
          (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams) obj;

      if (!getSearchQuery().equals(other.getSearchQuery())) return false;
      if (getTopK() != other.getTopK()) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + SEARCH_QUERY_FIELD_NUMBER;
      hash = (53 * hash) + getSearchQuery().hashCode();
      hash = (37 * hash) + TOP_K_FIELD_NUMBER;
      hash = (53 * hash) + getTopK();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Parameters for semantic similarity search based retrieval.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams)
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
            .SimilaritySearchParamsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesRequest_SimilaritySearchParams_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesRequest_SimilaritySearchParams_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
                    .class,
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        searchQuery_ = "";
        topK_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesRequest_SimilaritySearchParams_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
          build() {
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams result =
            new com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.searchQuery_ = searchQuery_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.topK_ = topK_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
              other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
                .getDefaultInstance()) return this;
        if (!other.getSearchQuery().isEmpty()) {
          searchQuery_ = other.searchQuery_;
          bitField0_ |= 0x00000001;
          onChanged();
        }
        if (other.getTopK() != 0) {
          setTopK(other.getTopK());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  searchQuery_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 16:
                {
                  topK_ = input.readInt32();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 16
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private java.lang.Object searchQuery_ = "";

      /**
       *
       *
       * <pre>
       * Required. Query to use for similarity search retrieval. If provided, then
       * the parent ReasoningEngine must have
       * [ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig][google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig]
       * set.
       * </pre>
       *
       * <code>string search_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The searchQuery.
       */
      public java.lang.String getSearchQuery() {
        java.lang.Object ref = searchQuery_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          searchQuery_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Query to use for similarity search retrieval. If provided, then
       * the parent ReasoningEngine must have
       * [ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig][google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig]
       * set.
       * </pre>
       *
       * <code>string search_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return The bytes for searchQuery.
       */
      public com.google.protobuf.ByteString getSearchQueryBytes() {
        java.lang.Object ref = searchQuery_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          searchQuery_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Required. Query to use for similarity search retrieval. If provided, then
       * the parent ReasoningEngine must have
       * [ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig][google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig]
       * set.
       * </pre>
       *
       * <code>string search_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The searchQuery to set.
       * @return This builder for chaining.
       */
      public Builder setSearchQuery(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        searchQuery_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Query to use for similarity search retrieval. If provided, then
       * the parent ReasoningEngine must have
       * [ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig][google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig]
       * set.
       * </pre>
       *
       * <code>string search_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearSearchQuery() {
        searchQuery_ = getDefaultInstance().getSearchQuery();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. Query to use for similarity search retrieval. If provided, then
       * the parent ReasoningEngine must have
       * [ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig][google.cloud.aiplatform.v1beta1.ReasoningEngineContextSpec.MemoryBankConfig.SimilaritySearchConfig]
       * set.
       * </pre>
       *
       * <code>string search_query = 1 [(.google.api.field_behavior) = REQUIRED];</code>
       *
       * @param value The bytes for searchQuery to set.
       * @return This builder for chaining.
       */
      public Builder setSearchQueryBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        searchQuery_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      private int topK_;

      /**
       *
       *
       * <pre>
       * Optional. The maximum number of memories to return.
       * The service may return fewer than this value. If unspecified, at most 3
       * memories will be returned. The maximum value is 100; values above 100
       * will be coerced to 100.
       * </pre>
       *
       * <code>int32 top_k = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The topK.
       */
      @java.lang.Override
      public int getTopK() {
        return topK_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The maximum number of memories to return.
       * The service may return fewer than this value. If unspecified, at most 3
       * memories will be returned. The maximum value is 100; values above 100
       * will be coerced to 100.
       * </pre>
       *
       * <code>int32 top_k = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The topK to set.
       * @return This builder for chaining.
       */
      public Builder setTopK(int value) {

        topK_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The maximum number of memories to return.
       * The service may return fewer than this value. If unspecified, at most 3
       * memories will be returned. The maximum value is 100; values above 100
       * will be coerced to 100.
       * </pre>
       *
       * <code>int32 top_k = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTopK() {
        bitField0_ = (bitField0_ & ~0x00000002);
        topK_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams)
    private static final com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
            .SimilaritySearchParams
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams();
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SimilaritySearchParams> PARSER =
        new com.google.protobuf.AbstractParser<SimilaritySearchParams>() {
          @java.lang.Override
          public SimilaritySearchParams parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SimilaritySearchParams> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SimilaritySearchParams> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public interface SimpleRetrievalParamsOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of memories to return.
     * The service may return fewer than this value. If unspecified, at most 3
     * memories will be returned. The maximum value is 100; values above 100
     * will be coerced to 100.
     * </pre>
     *
     * <code>int32 page_size = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageSize.
     */
    int getPageSize();

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous `RetrieveMemories` call.
     * Provide this to retrieve the subsequent page.
     * </pre>
     *
     * <code>string page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageToken.
     */
    java.lang.String getPageToken();

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous `RetrieveMemories` call.
     * Provide this to retrieve the subsequent page.
     * </pre>
     *
     * <code>string page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pageToken.
     */
    com.google.protobuf.ByteString getPageTokenBytes();
  }

  /**
   *
   *
   * <pre>
   * Parameters for simple (non-similarity search) retrieval.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams}
   */
  public static final class SimpleRetrievalParams extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams)
      SimpleRetrievalParamsOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use SimpleRetrievalParams.newBuilder() to construct.
    private SimpleRetrievalParams(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private SimpleRetrievalParams() {
      pageToken_ = "";
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new SimpleRetrievalParams();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesRequest_SimpleRetrievalParams_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesRequest_SimpleRetrievalParams_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
                  .class,
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
                  .Builder.class);
    }

    public static final int PAGE_SIZE_FIELD_NUMBER = 1;
    private int pageSize_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The maximum number of memories to return.
     * The service may return fewer than this value. If unspecified, at most 3
     * memories will be returned. The maximum value is 100; values above 100
     * will be coerced to 100.
     * </pre>
     *
     * <code>int32 page_size = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageSize.
     */
    @java.lang.Override
    public int getPageSize() {
      return pageSize_;
    }

    public static final int PAGE_TOKEN_FIELD_NUMBER = 2;

    @SuppressWarnings("serial")
    private volatile java.lang.Object pageToken_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous `RetrieveMemories` call.
     * Provide this to retrieve the subsequent page.
     * </pre>
     *
     * <code>string page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The pageToken.
     */
    @java.lang.Override
    public java.lang.String getPageToken() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        return (java.lang.String) ref;
      } else {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        pageToken_ = s;
        return s;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A page token, received from a previous `RetrieveMemories` call.
     * Provide this to retrieve the subsequent page.
     * </pre>
     *
     * <code>string page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for pageToken.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getPageTokenBytes() {
      java.lang.Object ref = pageToken_;
      if (ref instanceof java.lang.String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        pageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (pageSize_ != 0) {
        output.writeInt32(1, pageSize_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 2, pageToken_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (pageSize_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(1, pageSize_);
      }
      if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(pageToken_)) {
        size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, pageToken_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams other =
          (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams) obj;

      if (getPageSize() != other.getPageSize()) return false;
      if (!getPageToken().equals(other.getPageToken())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + PAGE_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getPageSize();
      hash = (37 * hash) + PAGE_TOKEN_FIELD_NUMBER;
      hash = (53 * hash) + getPageToken().hashCode();
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
            prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Parameters for simple (non-similarity search) retrieval.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams)
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParamsOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesRequest_SimpleRetrievalParams_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesRequest_SimpleRetrievalParams_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
                    .class,
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
                    .Builder.class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        pageSize_ = 0;
        pageToken_ = "";
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesRequest_SimpleRetrievalParams_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
          build() {
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams result =
            new com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams(
                this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
              result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.pageSize_ = pageSize_;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.pageToken_ = pageToken_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams)
                  other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
                .getDefaultInstance()) return this;
        if (other.getPageSize() != 0) {
          setPageSize(other.getPageSize());
        }
        if (!other.getPageToken().isEmpty()) {
          pageToken_ = other.pageToken_;
          bitField0_ |= 0x00000002;
          onChanged();
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  pageSize_ = input.readInt32();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              case 18:
                {
                  pageToken_ = input.readStringRequireUtf8();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 18
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int pageSize_;

      /**
       *
       *
       * <pre>
       * Optional. The maximum number of memories to return.
       * The service may return fewer than this value. If unspecified, at most 3
       * memories will be returned. The maximum value is 100; values above 100
       * will be coerced to 100.
       * </pre>
       *
       * <code>int32 page_size = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The pageSize.
       */
      @java.lang.Override
      public int getPageSize() {
        return pageSize_;
      }

      /**
       *
       *
       * <pre>
       * Optional. The maximum number of memories to return.
       * The service may return fewer than this value. If unspecified, at most 3
       * memories will be returned. The maximum value is 100; values above 100
       * will be coerced to 100.
       * </pre>
       *
       * <code>int32 page_size = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The pageSize to set.
       * @return This builder for chaining.
       */
      public Builder setPageSize(int value) {

        pageSize_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. The maximum number of memories to return.
       * The service may return fewer than this value. If unspecified, at most 3
       * memories will be returned. The maximum value is 100; values above 100
       * will be coerced to 100.
       * </pre>
       *
       * <code>int32 page_size = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageSize() {
        bitField0_ = (bitField0_ & ~0x00000001);
        pageSize_ = 0;
        onChanged();
        return this;
      }

      private java.lang.Object pageToken_ = "";

      /**
       *
       *
       * <pre>
       * Optional. A page token, received from a previous `RetrieveMemories` call.
       * Provide this to retrieve the subsequent page.
       * </pre>
       *
       * <code>string page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The pageToken.
       */
      public java.lang.String getPageToken() {
        java.lang.Object ref = pageToken_;
        if (!(ref instanceof java.lang.String)) {
          com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
          java.lang.String s = bs.toStringUtf8();
          pageToken_ = s;
          return s;
        } else {
          return (java.lang.String) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. A page token, received from a previous `RetrieveMemories` call.
       * Provide this to retrieve the subsequent page.
       * </pre>
       *
       * <code>string page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return The bytes for pageToken.
       */
      public com.google.protobuf.ByteString getPageTokenBytes() {
        java.lang.Object ref = pageToken_;
        if (ref instanceof String) {
          com.google.protobuf.ByteString b =
              com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
          pageToken_ = b;
          return b;
        } else {
          return (com.google.protobuf.ByteString) ref;
        }
      }

      /**
       *
       *
       * <pre>
       * Optional. A page token, received from a previous `RetrieveMemories` call.
       * Provide this to retrieve the subsequent page.
       * </pre>
       *
       * <code>string page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageToken(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        pageToken_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A page token, received from a previous `RetrieveMemories` call.
       * Provide this to retrieve the subsequent page.
       * </pre>
       *
       * <code>string page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearPageToken() {
        pageToken_ = getDefaultInstance().getPageToken();
        bitField0_ = (bitField0_ & ~0x00000002);
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Optional. A page token, received from a previous `RetrieveMemories` call.
       * Provide this to retrieve the subsequent page.
       * </pre>
       *
       * <code>string page_token = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
       *
       * @param value The bytes for pageToken to set.
       * @return This builder for chaining.
       */
      public Builder setPageTokenBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        pageToken_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams)
    private static final com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
            .SimpleRetrievalParams
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams();
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<SimpleRetrievalParams> PARSER =
        new com.google.protobuf.AbstractParser<SimpleRetrievalParams>() {
          @java.lang.Override
          public SimpleRetrievalParams parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<SimpleRetrievalParams> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<SimpleRetrievalParams> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int retrievalParamsCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object retrievalParams_;

  public enum RetrievalParamsCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    SIMILARITY_SEARCH_PARAMS(6),
    SIMPLE_RETRIEVAL_PARAMS(7),
    RETRIEVALPARAMS_NOT_SET(0);
    private final int value;

    private RetrievalParamsCase(int value) {
      this.value = value;
    }

    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static RetrievalParamsCase valueOf(int value) {
      return forNumber(value);
    }

    public static RetrievalParamsCase forNumber(int value) {
      switch (value) {
        case 6:
          return SIMILARITY_SEARCH_PARAMS;
        case 7:
          return SIMPLE_RETRIEVAL_PARAMS;
        case 0:
          return RETRIEVALPARAMS_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public RetrievalParamsCase getRetrievalParamsCase() {
    return RetrievalParamsCase.forNumber(retrievalParamsCase_);
  }

  public static final int SIMILARITY_SEARCH_PARAMS_FIELD_NUMBER = 6;

  /**
   *
   *
   * <pre>
   * Parameters for semantic similarity search based retrieval.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams similarity_search_params = 6;
   * </code>
   *
   * @return Whether the similaritySearchParams field is set.
   */
  @java.lang.Override
  public boolean hasSimilaritySearchParams() {
    return retrievalParamsCase_ == 6;
  }

  /**
   *
   *
   * <pre>
   * Parameters for semantic similarity search based retrieval.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams similarity_search_params = 6;
   * </code>
   *
   * @return The similaritySearchParams.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
      getSimilaritySearchParams() {
    if (retrievalParamsCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams)
          retrievalParams_;
    }
    return com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Parameters for semantic similarity search based retrieval.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams similarity_search_params = 6;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParamsOrBuilder
      getSimilaritySearchParamsOrBuilder() {
    if (retrievalParamsCase_ == 6) {
      return (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams)
          retrievalParams_;
    }
    return com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        .getDefaultInstance();
  }

  public static final int SIMPLE_RETRIEVAL_PARAMS_FIELD_NUMBER = 7;

  /**
   *
   *
   * <pre>
   * Parameters for simple (non-similarity search) retrieval.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams simple_retrieval_params = 7;
   * </code>
   *
   * @return Whether the simpleRetrievalParams field is set.
   */
  @java.lang.Override
  public boolean hasSimpleRetrievalParams() {
    return retrievalParamsCase_ == 7;
  }

  /**
   *
   *
   * <pre>
   * Parameters for simple (non-similarity search) retrieval.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams simple_retrieval_params = 7;
   * </code>
   *
   * @return The simpleRetrievalParams.
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
      getSimpleRetrievalParams() {
    if (retrievalParamsCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams)
          retrievalParams_;
    }
    return com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        .getDefaultInstance();
  }

  /**
   *
   *
   * <pre>
   * Parameters for simple (non-similarity search) retrieval.
   * </pre>
   *
   * <code>
   * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams simple_retrieval_params = 7;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParamsOrBuilder
      getSimpleRetrievalParamsOrBuilder() {
    if (retrievalParamsCase_ == 7) {
      return (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams)
          retrievalParams_;
    }
    return com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        .getDefaultInstance();
  }

  public static final int PARENT_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object parent_ = "";

  /**
   *
   *
   * <pre>
   * Required. The resource name of the ReasoningEngine to retrieve memories
   * from. Format:
   * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  @java.lang.Override
  public java.lang.String getParent() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      parent_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The resource name of the ReasoningEngine to retrieve memories
   * from. Format:
   * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParentBytes() {
    java.lang.Object ref = parent_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      parent_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int SCOPE_FIELD_NUMBER = 8;

  private static final class ScopeDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<java.lang.String, java.lang.String> defaultEntry =
        com.google.protobuf.MapEntry.<java.lang.String, java.lang.String>newDefaultInstance(
            com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
                .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesRequest_ScopeEntry_descriptor,
            com.google.protobuf.WireFormat.FieldType.STRING,
            "",
            com.google.protobuf.WireFormat.FieldType.STRING,
            "");
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<java.lang.String, java.lang.String> scope_;

  private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetScope() {
    if (scope_ == null) {
      return com.google.protobuf.MapField.emptyMapField(ScopeDefaultEntryHolder.defaultEntry);
    }
    return scope_;
  }

  public int getScopeCount() {
    return internalGetScope().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Required. The scope of the memories to retrieve. A memory must have
   * exactly the same scope (`Memory.scope`) as the scope provided here to be
   * retrieved (same keys and values). Order does not matter, but it is
   * case-sensitive.
   * </pre>
   *
   * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public boolean containsScope(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetScope().getMap().containsKey(key);
  }

  /** Use {@link #getScopeMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, java.lang.String> getScope() {
    return getScopeMap();
  }

  /**
   *
   *
   * <pre>
   * Required. The scope of the memories to retrieve. A memory must have
   * exactly the same scope (`Memory.scope`) as the scope provided here to be
   * retrieved (same keys and values). Order does not matter, but it is
   * case-sensitive.
   * </pre>
   *
   * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, java.lang.String> getScopeMap() {
    return internalGetScope().getMap();
  }

  /**
   *
   *
   * <pre>
   * Required. The scope of the memories to retrieve. A memory must have
   * exactly the same scope (`Memory.scope`) as the scope provided here to be
   * retrieved (same keys and values). Order does not matter, but it is
   * case-sensitive.
   * </pre>
   *
   * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public /* nullable */ java.lang.String getScopeOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetScope().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Required. The scope of the memories to retrieve. A memory must have
   * exactly the same scope (`Memory.scope`) as the scope provided here to be
   * retrieved (same keys and values). Order does not matter, but it is
   * case-sensitive.
   * </pre>
   *
   * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public java.lang.String getScopeOrThrow(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, java.lang.String> map = internalGetScope().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, parent_);
    }
    if (retrievalParamsCase_ == 6) {
      output.writeMessage(
          6,
          (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams)
              retrievalParams_);
    }
    if (retrievalParamsCase_ == 7) {
      output.writeMessage(
          7,
          (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams)
              retrievalParams_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output, internalGetScope(), ScopeDefaultEntryHolder.defaultEntry, 8);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(parent_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, parent_);
    }
    if (retrievalParamsCase_ == 6) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              6,
              (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams)
                  retrievalParams_);
    }
    if (retrievalParamsCase_ == 7) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              7,
              (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams)
                  retrievalParams_);
    }
    for (java.util.Map.Entry<java.lang.String, java.lang.String> entry :
        internalGetScope().getMap().entrySet()) {
      com.google.protobuf.MapEntry<java.lang.String, java.lang.String> scope__ =
          ScopeDefaultEntryHolder.defaultEntry
              .newBuilderForType()
              .setKey(entry.getKey())
              .setValue(entry.getValue())
              .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(8, scope__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest other =
        (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest) obj;

    if (!getParent().equals(other.getParent())) return false;
    if (!internalGetScope().equals(other.internalGetScope())) return false;
    if (!getRetrievalParamsCase().equals(other.getRetrievalParamsCase())) return false;
    switch (retrievalParamsCase_) {
      case 6:
        if (!getSimilaritySearchParams().equals(other.getSimilaritySearchParams())) return false;
        break;
      case 7:
        if (!getSimpleRetrievalParams().equals(other.getSimpleRetrievalParams())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARENT_FIELD_NUMBER;
    hash = (53 * hash) + getParent().hashCode();
    if (!internalGetScope().getMap().isEmpty()) {
      hash = (37 * hash) + SCOPE_FIELD_NUMBER;
      hash = (53 * hash) + internalGetScope().hashCode();
    }
    switch (retrievalParamsCase_) {
      case 6:
        hash = (37 * hash) + SIMILARITY_SEARCH_PARAMS_FIELD_NUMBER;
        hash = (53 * hash) + getSimilaritySearchParams().hashCode();
        break;
      case 7:
        hash = (37 * hash) + SIMPLE_RETRIEVAL_PARAMS_FIELD_NUMBER;
        hash = (53 * hash) + getSimpleRetrievalParams().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Request message for
   * [MemoryBankService.RetrieveMemories][google.cloud.aiplatform.v1beta1.MemoryBankService.RetrieveMemories].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest)
      com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesRequest_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 8:
          return internalGetScope();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 8:
          return internalGetMutableScope();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.class,
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (similaritySearchParamsBuilder_ != null) {
        similaritySearchParamsBuilder_.clear();
      }
      if (simpleRetrievalParamsBuilder_ != null) {
        simpleRetrievalParamsBuilder_.clear();
      }
      parent_ = "";
      internalGetMutableScope().clear();
      retrievalParamsCase_ = 0;
      retrievalParams_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesRequest_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest build() {
      com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest buildPartial() {
      com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest result =
          new com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.parent_ = parent_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.scope_ = internalGetScope();
        result.scope_.makeImmutable();
      }
    }

    private void buildPartialOneofs(
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest result) {
      result.retrievalParamsCase_ = retrievalParamsCase_;
      result.retrievalParams_ = this.retrievalParams_;
      if (retrievalParamsCase_ == 6 && similaritySearchParamsBuilder_ != null) {
        result.retrievalParams_ = similaritySearchParamsBuilder_.build();
      }
      if (retrievalParamsCase_ == 7 && simpleRetrievalParamsBuilder_ != null) {
        result.retrievalParams_ = simpleRetrievalParamsBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest other) {
      if (other == com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.getDefaultInstance())
        return this;
      if (!other.getParent().isEmpty()) {
        parent_ = other.parent_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      internalGetMutableScope().mergeFrom(other.internalGetScope());
      bitField0_ |= 0x00000008;
      switch (other.getRetrievalParamsCase()) {
        case SIMILARITY_SEARCH_PARAMS:
          {
            mergeSimilaritySearchParams(other.getSimilaritySearchParams());
            break;
          }
        case SIMPLE_RETRIEVAL_PARAMS:
          {
            mergeSimpleRetrievalParams(other.getSimpleRetrievalParams());
            break;
          }
        case RETRIEVALPARAMS_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                parent_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 10
            case 50:
              {
                input.readMessage(
                    getSimilaritySearchParamsFieldBuilder().getBuilder(), extensionRegistry);
                retrievalParamsCase_ = 6;
                break;
              } // case 50
            case 58:
              {
                input.readMessage(
                    getSimpleRetrievalParamsFieldBuilder().getBuilder(), extensionRegistry);
                retrievalParamsCase_ = 7;
                break;
              } // case 58
            case 66:
              {
                com.google.protobuf.MapEntry<java.lang.String, java.lang.String> scope__ =
                    input.readMessage(
                        ScopeDefaultEntryHolder.defaultEntry.getParserForType(), extensionRegistry);
                internalGetMutableScope().getMutableMap().put(scope__.getKey(), scope__.getValue());
                bitField0_ |= 0x00000008;
                break;
              } // case 66
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int retrievalParamsCase_ = 0;
    private java.lang.Object retrievalParams_;

    public RetrievalParamsCase getRetrievalParamsCase() {
      return RetrievalParamsCase.forNumber(retrievalParamsCase_);
    }

    public Builder clearRetrievalParams() {
      retrievalParamsCase_ = 0;
      retrievalParams_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams,
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
                .Builder,
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
                .SimilaritySearchParamsOrBuilder>
        similaritySearchParamsBuilder_;

    /**
     *
     *
     * <pre>
     * Parameters for semantic similarity search based retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams similarity_search_params = 6;
     * </code>
     *
     * @return Whether the similaritySearchParams field is set.
     */
    @java.lang.Override
    public boolean hasSimilaritySearchParams() {
      return retrievalParamsCase_ == 6;
    }

    /**
     *
     *
     * <pre>
     * Parameters for semantic similarity search based retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams similarity_search_params = 6;
     * </code>
     *
     * @return The similaritySearchParams.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
        getSimilaritySearchParams() {
      if (similaritySearchParamsBuilder_ == null) {
        if (retrievalParamsCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
                  .SimilaritySearchParams)
              retrievalParams_;
        }
        return com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
            .getDefaultInstance();
      } else {
        if (retrievalParamsCase_ == 6) {
          return similaritySearchParamsBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Parameters for semantic similarity search based retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams similarity_search_params = 6;
     * </code>
     */
    public Builder setSimilaritySearchParams(
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams value) {
      if (similaritySearchParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retrievalParams_ = value;
        onChanged();
      } else {
        similaritySearchParamsBuilder_.setMessage(value);
      }
      retrievalParamsCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters for semantic similarity search based retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams similarity_search_params = 6;
     * </code>
     */
    public Builder setSimilaritySearchParams(
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams.Builder
            builderForValue) {
      if (similaritySearchParamsBuilder_ == null) {
        retrievalParams_ = builderForValue.build();
        onChanged();
      } else {
        similaritySearchParamsBuilder_.setMessage(builderForValue.build());
      }
      retrievalParamsCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters for semantic similarity search based retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams similarity_search_params = 6;
     * </code>
     */
    public Builder mergeSimilaritySearchParams(
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams value) {
      if (similaritySearchParamsBuilder_ == null) {
        if (retrievalParamsCase_ == 6
            && retrievalParams_
                != com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
                    .SimilaritySearchParams.getDefaultInstance()) {
          retrievalParams_ =
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
                              .SimilaritySearchParams)
                          retrievalParams_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          retrievalParams_ = value;
        }
        onChanged();
      } else {
        if (retrievalParamsCase_ == 6) {
          similaritySearchParamsBuilder_.mergeFrom(value);
        } else {
          similaritySearchParamsBuilder_.setMessage(value);
        }
      }
      retrievalParamsCase_ = 6;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters for semantic similarity search based retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams similarity_search_params = 6;
     * </code>
     */
    public Builder clearSimilaritySearchParams() {
      if (similaritySearchParamsBuilder_ == null) {
        if (retrievalParamsCase_ == 6) {
          retrievalParamsCase_ = 0;
          retrievalParams_ = null;
          onChanged();
        }
      } else {
        if (retrievalParamsCase_ == 6) {
          retrievalParamsCase_ = 0;
          retrievalParams_ = null;
        }
        similaritySearchParamsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters for semantic similarity search based retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams similarity_search_params = 6;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
            .Builder
        getSimilaritySearchParamsBuilder() {
      return getSimilaritySearchParamsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Parameters for semantic similarity search based retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams similarity_search_params = 6;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
            .SimilaritySearchParamsOrBuilder
        getSimilaritySearchParamsOrBuilder() {
      if ((retrievalParamsCase_ == 6) && (similaritySearchParamsBuilder_ != null)) {
        return similaritySearchParamsBuilder_.getMessageOrBuilder();
      } else {
        if (retrievalParamsCase_ == 6) {
          return (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
                  .SimilaritySearchParams)
              retrievalParams_;
        }
        return com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Parameters for semantic similarity search based retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams similarity_search_params = 6;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams,
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
                .Builder,
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
                .SimilaritySearchParamsOrBuilder>
        getSimilaritySearchParamsFieldBuilder() {
      if (similaritySearchParamsBuilder_ == null) {
        if (!(retrievalParamsCase_ == 6)) {
          retrievalParams_ =
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
                  .getDefaultInstance();
        }
        similaritySearchParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams,
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
                    .SimilaritySearchParamsOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimilaritySearchParams)
                    retrievalParams_,
                getParentForChildren(),
                isClean());
        retrievalParams_ = null;
      }
      retrievalParamsCase_ = 6;
      onChanged();
      return similaritySearchParamsBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams,
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
                .Builder,
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
                .SimpleRetrievalParamsOrBuilder>
        simpleRetrievalParamsBuilder_;

    /**
     *
     *
     * <pre>
     * Parameters for simple (non-similarity search) retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams simple_retrieval_params = 7;
     * </code>
     *
     * @return Whether the simpleRetrievalParams field is set.
     */
    @java.lang.Override
    public boolean hasSimpleRetrievalParams() {
      return retrievalParamsCase_ == 7;
    }

    /**
     *
     *
     * <pre>
     * Parameters for simple (non-similarity search) retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams simple_retrieval_params = 7;
     * </code>
     *
     * @return The simpleRetrievalParams.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
        getSimpleRetrievalParams() {
      if (simpleRetrievalParamsBuilder_ == null) {
        if (retrievalParamsCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams)
              retrievalParams_;
        }
        return com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
            .getDefaultInstance();
      } else {
        if (retrievalParamsCase_ == 7) {
          return simpleRetrievalParamsBuilder_.getMessage();
        }
        return com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Parameters for simple (non-similarity search) retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams simple_retrieval_params = 7;
     * </code>
     */
    public Builder setSimpleRetrievalParams(
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams value) {
      if (simpleRetrievalParamsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        retrievalParams_ = value;
        onChanged();
      } else {
        simpleRetrievalParamsBuilder_.setMessage(value);
      }
      retrievalParamsCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters for simple (non-similarity search) retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams simple_retrieval_params = 7;
     * </code>
     */
    public Builder setSimpleRetrievalParams(
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams.Builder
            builderForValue) {
      if (simpleRetrievalParamsBuilder_ == null) {
        retrievalParams_ = builderForValue.build();
        onChanged();
      } else {
        simpleRetrievalParamsBuilder_.setMessage(builderForValue.build());
      }
      retrievalParamsCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters for simple (non-similarity search) retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams simple_retrieval_params = 7;
     * </code>
     */
    public Builder mergeSimpleRetrievalParams(
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams value) {
      if (simpleRetrievalParamsBuilder_ == null) {
        if (retrievalParamsCase_ == 7
            && retrievalParams_
                != com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
                    .getDefaultInstance()) {
          retrievalParams_ =
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
                  .newBuilder(
                      (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
                              .SimpleRetrievalParams)
                          retrievalParams_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          retrievalParams_ = value;
        }
        onChanged();
      } else {
        if (retrievalParamsCase_ == 7) {
          simpleRetrievalParamsBuilder_.mergeFrom(value);
        } else {
          simpleRetrievalParamsBuilder_.setMessage(value);
        }
      }
      retrievalParamsCase_ = 7;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters for simple (non-similarity search) retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams simple_retrieval_params = 7;
     * </code>
     */
    public Builder clearSimpleRetrievalParams() {
      if (simpleRetrievalParamsBuilder_ == null) {
        if (retrievalParamsCase_ == 7) {
          retrievalParamsCase_ = 0;
          retrievalParams_ = null;
          onChanged();
        }
      } else {
        if (retrievalParamsCase_ == 7) {
          retrievalParamsCase_ = 0;
          retrievalParams_ = null;
        }
        simpleRetrievalParamsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Parameters for simple (non-similarity search) retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams simple_retrieval_params = 7;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams.Builder
        getSimpleRetrievalParamsBuilder() {
      return getSimpleRetrievalParamsFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Parameters for simple (non-similarity search) retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams simple_retrieval_params = 7;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
            .SimpleRetrievalParamsOrBuilder
        getSimpleRetrievalParamsOrBuilder() {
      if ((retrievalParamsCase_ == 7) && (simpleRetrievalParamsBuilder_ != null)) {
        return simpleRetrievalParamsBuilder_.getMessageOrBuilder();
      } else {
        if (retrievalParamsCase_ == 7) {
          return (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams)
              retrievalParams_;
        }
        return com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
            .getDefaultInstance();
      }
    }

    /**
     *
     *
     * <pre>
     * Parameters for simple (non-similarity search) retrieval.
     * </pre>
     *
     * <code>
     * .google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams simple_retrieval_params = 7;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams,
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
                .Builder,
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
                .SimpleRetrievalParamsOrBuilder>
        getSimpleRetrievalParamsFieldBuilder() {
      if (simpleRetrievalParamsBuilder_ == null) {
        if (!(retrievalParamsCase_ == 7)) {
          retrievalParams_ =
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
                  .getDefaultInstance();
        }
        simpleRetrievalParamsBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams,
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest
                    .SimpleRetrievalParamsOrBuilder>(
                (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest.SimpleRetrievalParams)
                    retrievalParams_,
                getParentForChildren(),
                isClean());
        retrievalParams_ = null;
      }
      retrievalParamsCase_ = 7;
      onChanged();
      return simpleRetrievalParamsBuilder_;
    }

    private java.lang.Object parent_ = "";

    /**
     *
     *
     * <pre>
     * Required. The resource name of the ReasoningEngine to retrieve memories
     * from. Format:
     * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The parent.
     */
    public java.lang.String getParent() {
      java.lang.Object ref = parent_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        parent_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the ReasoningEngine to retrieve memories
     * from. Format:
     * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return The bytes for parent.
     */
    public com.google.protobuf.ByteString getParentBytes() {
      java.lang.Object ref = parent_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        parent_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the ReasoningEngine to retrieve memories
     * from. Format:
     * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The parent to set.
     * @return This builder for chaining.
     */
    public Builder setParent(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      parent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the ReasoningEngine to retrieve memories
     * from. Format:
     * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParent() {
      parent_ = getDefaultInstance().getParent();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The resource name of the ReasoningEngine to retrieve memories
     * from. Format:
     * `projects/{project}/locations/{location}/reasoningEngines/{reasoning_engine}`
     * </pre>
     *
     * <code>
     * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
     * </code>
     *
     * @param value The bytes for parent to set.
     * @return This builder for chaining.
     */
    public Builder setParentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      parent_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> scope_;

    private com.google.protobuf.MapField<java.lang.String, java.lang.String> internalGetScope() {
      if (scope_ == null) {
        return com.google.protobuf.MapField.emptyMapField(ScopeDefaultEntryHolder.defaultEntry);
      }
      return scope_;
    }

    private com.google.protobuf.MapField<java.lang.String, java.lang.String>
        internalGetMutableScope() {
      if (scope_ == null) {
        scope_ = com.google.protobuf.MapField.newMapField(ScopeDefaultEntryHolder.defaultEntry);
      }
      if (!scope_.isMutable()) {
        scope_ = scope_.copy();
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return scope_;
    }

    public int getScopeCount() {
      return internalGetScope().getMap().size();
    }

    /**
     *
     *
     * <pre>
     * Required. The scope of the memories to retrieve. A memory must have
     * exactly the same scope (`Memory.scope`) as the scope provided here to be
     * retrieved (same keys and values). Order does not matter, but it is
     * case-sensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    @java.lang.Override
    public boolean containsScope(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetScope().getMap().containsKey(key);
    }

    /** Use {@link #getScopeMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getScope() {
      return getScopeMap();
    }

    /**
     *
     *
     * <pre>
     * Required. The scope of the memories to retrieve. A memory must have
     * exactly the same scope (`Memory.scope`) as the scope provided here to be
     * retrieved (same keys and values). Order does not matter, but it is
     * case-sensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    @java.lang.Override
    public java.util.Map<java.lang.String, java.lang.String> getScopeMap() {
      return internalGetScope().getMap();
    }

    /**
     *
     *
     * <pre>
     * Required. The scope of the memories to retrieve. A memory must have
     * exactly the same scope (`Memory.scope`) as the scope provided here to be
     * retrieved (same keys and values). Order does not matter, but it is
     * case-sensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    @java.lang.Override
    public /* nullable */ java.lang.String getScopeOrDefault(
        java.lang.String key,
        /* nullable */
        java.lang.String defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetScope().getMap();
      return map.containsKey(key) ? map.get(key) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Required. The scope of the memories to retrieve. A memory must have
     * exactly the same scope (`Memory.scope`) as the scope provided here to be
     * retrieved (same keys and values). Order does not matter, but it is
     * case-sensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    @java.lang.Override
    public java.lang.String getScopeOrThrow(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<java.lang.String, java.lang.String> map = internalGetScope().getMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return map.get(key);
    }

    public Builder clearScope() {
      bitField0_ = (bitField0_ & ~0x00000008);
      internalGetMutableScope().getMutableMap().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The scope of the memories to retrieve. A memory must have
     * exactly the same scope (`Memory.scope`) as the scope provided here to be
     * retrieved (same keys and values). Order does not matter, but it is
     * case-sensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder removeScope(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableScope().getMutableMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<java.lang.String, java.lang.String> getMutableScope() {
      bitField0_ |= 0x00000008;
      return internalGetMutableScope().getMutableMap();
    }

    /**
     *
     *
     * <pre>
     * Required. The scope of the memories to retrieve. A memory must have
     * exactly the same scope (`Memory.scope`) as the scope provided here to be
     * retrieved (same keys and values). Order does not matter, but it is
     * case-sensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder putScope(java.lang.String key, java.lang.String value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableScope().getMutableMap().put(key, value);
      bitField0_ |= 0x00000008;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The scope of the memories to retrieve. A memory must have
     * exactly the same scope (`Memory.scope`) as the scope provided here to be
     * retrieved (same keys and values). Order does not matter, but it is
     * case-sensitive.
     * </pre>
     *
     * <code>map&lt;string, string&gt; scope = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder putAllScope(java.util.Map<java.lang.String, java.lang.String> values) {
      internalGetMutableScope().getMutableMap().putAll(values);
      bitField0_ |= 0x00000008;
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest)
  private static final com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest();
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RetrieveMemoriesRequest> PARSER =
      new com.google.protobuf.AbstractParser<RetrieveMemoriesRequest>() {
        @java.lang.Override
        public RetrieveMemoriesRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RetrieveMemoriesRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RetrieveMemoriesRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
