/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1beta1/memory_bank_service.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.aiplatform.v1beta1;

/**
 *
 *
 * <pre>
 * Response message for
 * [MemoryBankService.RetrieveMemories][google.cloud.aiplatform.v1beta1.MemoryBankService.RetrieveMemories].
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse}
 */
public final class RetrieveMemoriesResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse)
    RetrieveMemoriesResponseOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use RetrieveMemoriesResponse.newBuilder() to construct.
  private RetrieveMemoriesResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private RetrieveMemoriesResponse() {
    retrievedMemories_ = java.util.Collections.emptyList();
    nextPageToken_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new RetrieveMemoriesResponse();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
        .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.class,
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.Builder.class);
  }

  public interface RetrievedMemoryOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The retrieved Memory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
     *
     * @return Whether the memory field is set.
     */
    boolean hasMemory();

    /**
     *
     *
     * <pre>
     * The retrieved Memory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
     *
     * @return The memory.
     */
    com.google.cloud.aiplatform.v1beta1.Memory getMemory();

    /**
     *
     *
     * <pre>
     * The retrieved Memory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
     */
    com.google.cloud.aiplatform.v1beta1.MemoryOrBuilder getMemoryOrBuilder();

    /**
     *
     *
     * <pre>
     * The distance between the query and the retrieved Memory. Smaller values
     * indicate more similar memories. This is only set if similarity search was
     * used for retrieval.
     * </pre>
     *
     * <code>double distance = 2;</code>
     *
     * @return The distance.
     */
    double getDistance();
  }

  /**
   *
   *
   * <pre>
   * A retrieved memory.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory}
   */
  public static final class RetrievedMemory extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory)
      RetrievedMemoryOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use RetrievedMemory.newBuilder() to construct.
    private RetrievedMemory(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private RetrievedMemory() {}

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new RetrievedMemory();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesResponse_RetrievedMemory_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesResponse_RetrievedMemory_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory.class,
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory.Builder
                  .class);
    }

    private int bitField0_;
    public static final int MEMORY_FIELD_NUMBER = 1;
    private com.google.cloud.aiplatform.v1beta1.Memory memory_;

    /**
     *
     *
     * <pre>
     * The retrieved Memory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
     *
     * @return Whether the memory field is set.
     */
    @java.lang.Override
    public boolean hasMemory() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * The retrieved Memory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
     *
     * @return The memory.
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.Memory getMemory() {
      return memory_ == null
          ? com.google.cloud.aiplatform.v1beta1.Memory.getDefaultInstance()
          : memory_;
    }

    /**
     *
     *
     * <pre>
     * The retrieved Memory.
     * </pre>
     *
     * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
     */
    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.MemoryOrBuilder getMemoryOrBuilder() {
      return memory_ == null
          ? com.google.cloud.aiplatform.v1beta1.Memory.getDefaultInstance()
          : memory_;
    }

    public static final int DISTANCE_FIELD_NUMBER = 2;
    private double distance_ = 0D;

    /**
     *
     *
     * <pre>
     * The distance between the query and the retrieved Memory. Smaller values
     * indicate more similar memories. This is only set if similarity search was
     * used for retrieval.
     * </pre>
     *
     * <code>double distance = 2;</code>
     *
     * @return The distance.
     */
    @java.lang.Override
    public double getDistance() {
      return distance_;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (((bitField0_ & 0x00000001) != 0)) {
        output.writeMessage(1, getMemory());
      }
      if (java.lang.Double.doubleToRawLongBits(distance_) != 0) {
        output.writeDouble(2, distance_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (((bitField0_ & 0x00000001) != 0)) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getMemory());
      }
      if (java.lang.Double.doubleToRawLongBits(distance_) != 0) {
        size += com.google.protobuf.CodedOutputStream.computeDoubleSize(2, distance_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof
          com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory)) {
        return super.equals(obj);
      }
      com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory other =
          (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory) obj;

      if (hasMemory() != other.hasMemory()) return false;
      if (hasMemory()) {
        if (!getMemory().equals(other.getMemory())) return false;
      }
      if (java.lang.Double.doubleToLongBits(getDistance())
          != java.lang.Double.doubleToLongBits(other.getDistance())) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      if (hasMemory()) {
        hash = (37 * hash) + MEMORY_FIELD_NUMBER;
        hash = (53 * hash) + getMemory().hashCode();
      }
      hash = (37 * hash) + DISTANCE_FIELD_NUMBER;
      hash =
          (53 * hash)
              + com.google.protobuf.Internal.hashLong(
                  java.lang.Double.doubleToLongBits(getDistance()));
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
        parseFrom(java.nio.ByteBuffer data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
        parseFrom(
            java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
        parseFrom(com.google.protobuf.ByteString data)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
        parseFrom(
            com.google.protobuf.ByteString data,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
        parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
        parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
        parseFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
        parseFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
        parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
        parseFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * A retrieved memory.
     * </pre>
     *
     * Protobuf type {@code
     * google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory)
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemoryOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesResponse_RetrievedMemory_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesResponse_RetrievedMemory_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory.class,
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
          getMemoryFieldBuilder();
        }
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        memory_ = null;
        if (memoryBuilder_ != null) {
          memoryBuilder_.dispose();
          memoryBuilder_ = null;
        }
        distance_ = 0D;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
            .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesResponse_RetrievedMemory_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
          getDefaultInstanceForType() {
        return com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory build() {
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
          buildPartial() {
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory result =
            new com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory result) {
        int from_bitField0_ = bitField0_;
        int to_bitField0_ = 0;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.memory_ = memoryBuilder_ == null ? memory_ : memoryBuilder_.build();
          to_bitField0_ |= 0x00000001;
        }
        if (((from_bitField0_ & 0x00000002) != 0)) {
          result.distance_ = distance_;
        }
        result.bitField0_ |= to_bitField0_;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory) {
          return mergeFrom(
              (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory other) {
        if (other
            == com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
                .getDefaultInstance()) return this;
        if (other.hasMemory()) {
          mergeMemory(other.getMemory());
        }
        if (other.getDistance() != 0D) {
          setDistance(other.getDistance());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 10:
                {
                  input.readMessage(getMemoryFieldBuilder().getBuilder(), extensionRegistry);
                  bitField0_ |= 0x00000001;
                  break;
                } // case 10
              case 17:
                {
                  distance_ = input.readDouble();
                  bitField0_ |= 0x00000002;
                  break;
                } // case 17
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private com.google.cloud.aiplatform.v1beta1.Memory memory_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.Memory,
              com.google.cloud.aiplatform.v1beta1.Memory.Builder,
              com.google.cloud.aiplatform.v1beta1.MemoryOrBuilder>
          memoryBuilder_;

      /**
       *
       *
       * <pre>
       * The retrieved Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       *
       * @return Whether the memory field is set.
       */
      public boolean hasMemory() {
        return ((bitField0_ & 0x00000001) != 0);
      }

      /**
       *
       *
       * <pre>
       * The retrieved Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       *
       * @return The memory.
       */
      public com.google.cloud.aiplatform.v1beta1.Memory getMemory() {
        if (memoryBuilder_ == null) {
          return memory_ == null
              ? com.google.cloud.aiplatform.v1beta1.Memory.getDefaultInstance()
              : memory_;
        } else {
          return memoryBuilder_.getMessage();
        }
      }

      /**
       *
       *
       * <pre>
       * The retrieved Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       */
      public Builder setMemory(com.google.cloud.aiplatform.v1beta1.Memory value) {
        if (memoryBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          memory_ = value;
        } else {
          memoryBuilder_.setMessage(value);
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The retrieved Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       */
      public Builder setMemory(com.google.cloud.aiplatform.v1beta1.Memory.Builder builderForValue) {
        if (memoryBuilder_ == null) {
          memory_ = builderForValue.build();
        } else {
          memoryBuilder_.setMessage(builderForValue.build());
        }
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The retrieved Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       */
      public Builder mergeMemory(com.google.cloud.aiplatform.v1beta1.Memory value) {
        if (memoryBuilder_ == null) {
          if (((bitField0_ & 0x00000001) != 0)
              && memory_ != null
              && memory_ != com.google.cloud.aiplatform.v1beta1.Memory.getDefaultInstance()) {
            getMemoryBuilder().mergeFrom(value);
          } else {
            memory_ = value;
          }
        } else {
          memoryBuilder_.mergeFrom(value);
        }
        if (memory_ != null) {
          bitField0_ |= 0x00000001;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * The retrieved Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       */
      public Builder clearMemory() {
        bitField0_ = (bitField0_ & ~0x00000001);
        memory_ = null;
        if (memoryBuilder_ != null) {
          memoryBuilder_.dispose();
          memoryBuilder_ = null;
        }
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The retrieved Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.Memory.Builder getMemoryBuilder() {
        bitField0_ |= 0x00000001;
        onChanged();
        return getMemoryFieldBuilder().getBuilder();
      }

      /**
       *
       *
       * <pre>
       * The retrieved Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       */
      public com.google.cloud.aiplatform.v1beta1.MemoryOrBuilder getMemoryOrBuilder() {
        if (memoryBuilder_ != null) {
          return memoryBuilder_.getMessageOrBuilder();
        } else {
          return memory_ == null
              ? com.google.cloud.aiplatform.v1beta1.Memory.getDefaultInstance()
              : memory_;
        }
      }

      /**
       *
       *
       * <pre>
       * The retrieved Memory.
       * </pre>
       *
       * <code>.google.cloud.aiplatform.v1beta1.Memory memory = 1;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.cloud.aiplatform.v1beta1.Memory,
              com.google.cloud.aiplatform.v1beta1.Memory.Builder,
              com.google.cloud.aiplatform.v1beta1.MemoryOrBuilder>
          getMemoryFieldBuilder() {
        if (memoryBuilder_ == null) {
          memoryBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.cloud.aiplatform.v1beta1.Memory,
                  com.google.cloud.aiplatform.v1beta1.Memory.Builder,
                  com.google.cloud.aiplatform.v1beta1.MemoryOrBuilder>(
                  getMemory(), getParentForChildren(), isClean());
          memory_ = null;
        }
        return memoryBuilder_;
      }

      private double distance_;

      /**
       *
       *
       * <pre>
       * The distance between the query and the retrieved Memory. Smaller values
       * indicate more similar memories. This is only set if similarity search was
       * used for retrieval.
       * </pre>
       *
       * <code>double distance = 2;</code>
       *
       * @return The distance.
       */
      @java.lang.Override
      public double getDistance() {
        return distance_;
      }

      /**
       *
       *
       * <pre>
       * The distance between the query and the retrieved Memory. Smaller values
       * indicate more similar memories. This is only set if similarity search was
       * used for retrieval.
       * </pre>
       *
       * <code>double distance = 2;</code>
       *
       * @param value The distance to set.
       * @return This builder for chaining.
       */
      public Builder setDistance(double value) {

        distance_ = value;
        bitField0_ |= 0x00000002;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * The distance between the query and the retrieved Memory. Smaller values
       * indicate more similar memories. This is only set if similarity search was
       * used for retrieval.
       * </pre>
       *
       * <code>double distance = 2;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearDistance() {
        bitField0_ = (bitField0_ & ~0x00000002);
        distance_ = 0D;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory)
    private static final com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse
            .RetrievedMemory
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory();
    }

    public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<RetrievedMemory> PARSER =
        new com.google.protobuf.AbstractParser<RetrievedMemory>() {
          @java.lang.Override
          public RetrievedMemory parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<RetrievedMemory> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<RetrievedMemory> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int RETRIEVED_MEMORIES_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private java.util.List<
          com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory>
      retrievedMemories_;

  /**
   *
   *
   * <pre>
   * The retrieved memories.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory>
      getRetrievedMemoriesList() {
    return retrievedMemories_;
  }

  /**
   *
   *
   * <pre>
   * The retrieved memories.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
   * </code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemoryOrBuilder>
      getRetrievedMemoriesOrBuilderList() {
    return retrievedMemories_;
  }

  /**
   *
   *
   * <pre>
   * The retrieved memories.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
   * </code>
   */
  @java.lang.Override
  public int getRetrievedMemoriesCount() {
    return retrievedMemories_.size();
  }

  /**
   *
   *
   * <pre>
   * The retrieved memories.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
      getRetrievedMemories(int index) {
    return retrievedMemories_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The retrieved memories.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemoryOrBuilder
      getRetrievedMemoriesOrBuilder(int index) {
    return retrievedMemories_.get(index);
  }

  public static final int NEXT_PAGE_TOKEN_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object nextPageToken_ = "";

  /**
   *
   *
   * <pre>
   * A token that can be sent as `page_token` to retrieve the next page.
   * If this field is omitted, there are no subsequent pages.
   * This token is not set if similarity search was used for retrieval.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The nextPageToken.
   */
  @java.lang.Override
  public java.lang.String getNextPageToken() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      nextPageToken_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * A token that can be sent as `page_token` to retrieve the next page.
   * If this field is omitted, there are no subsequent pages.
   * This token is not set if similarity search was used for retrieval.
   * </pre>
   *
   * <code>string next_page_token = 2;</code>
   *
   * @return The bytes for nextPageToken.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNextPageTokenBytes() {
    java.lang.Object ref = nextPageToken_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      nextPageToken_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < retrievedMemories_.size(); i++) {
      output.writeMessage(1, retrievedMemories_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, nextPageToken_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < retrievedMemories_.size(); i++) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(1, retrievedMemories_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(nextPageToken_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, nextPageToken_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse other =
        (com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse) obj;

    if (!getRetrievedMemoriesList().equals(other.getRetrievedMemoriesList())) return false;
    if (!getNextPageToken().equals(other.getNextPageToken())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getRetrievedMemoriesCount() > 0) {
      hash = (37 * hash) + RETRIEVED_MEMORIES_FIELD_NUMBER;
      hash = (53 * hash) + getRetrievedMemoriesList().hashCode();
    }
    hash = (37 * hash) + NEXT_PAGE_TOKEN_FIELD_NUMBER;
    hash = (53 * hash) + getNextPageToken().hashCode();
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * Response message for
   * [MemoryBankService.RetrieveMemories][google.cloud.aiplatform.v1beta1.MemoryBankService.RetrieveMemories].
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse)
      com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.class,
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (retrievedMemoriesBuilder_ == null) {
        retrievedMemories_ = java.util.Collections.emptyList();
      } else {
        retrievedMemories_ = null;
        retrievedMemoriesBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000001);
      nextPageToken_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1beta1.MemoryBankServiceProto
          .internal_static_google_cloud_aiplatform_v1beta1_RetrieveMemoriesResponse_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse
        getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse build() {
      com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse buildPartial() {
      com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse result =
          new com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse result) {
      if (retrievedMemoriesBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          retrievedMemories_ = java.util.Collections.unmodifiableList(retrievedMemories_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.retrievedMemories_ = retrievedMemories_;
      } else {
        result.retrievedMemories_ = retrievedMemoriesBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.nextPageToken_ = nextPageToken_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse) {
        return mergeFrom((com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse other) {
      if (other
          == com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.getDefaultInstance())
        return this;
      if (retrievedMemoriesBuilder_ == null) {
        if (!other.retrievedMemories_.isEmpty()) {
          if (retrievedMemories_.isEmpty()) {
            retrievedMemories_ = other.retrievedMemories_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureRetrievedMemoriesIsMutable();
            retrievedMemories_.addAll(other.retrievedMemories_);
          }
          onChanged();
        }
      } else {
        if (!other.retrievedMemories_.isEmpty()) {
          if (retrievedMemoriesBuilder_.isEmpty()) {
            retrievedMemoriesBuilder_.dispose();
            retrievedMemoriesBuilder_ = null;
            retrievedMemories_ = other.retrievedMemories_;
            bitField0_ = (bitField0_ & ~0x00000001);
            retrievedMemoriesBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getRetrievedMemoriesFieldBuilder()
                    : null;
          } else {
            retrievedMemoriesBuilder_.addAllMessages(other.retrievedMemories_);
          }
        }
      }
      if (!other.getNextPageToken().isEmpty()) {
        nextPageToken_ = other.nextPageToken_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
                            .parser(),
                        extensionRegistry);
                if (retrievedMemoriesBuilder_ == null) {
                  ensureRetrievedMemoriesIsMutable();
                  retrievedMemories_.add(m);
                } else {
                  retrievedMemoriesBuilder_.addMessage(m);
                }
                break;
              } // case 10
            case 18:
              {
                nextPageToken_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.util.List<
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory>
        retrievedMemories_ = java.util.Collections.emptyList();

    private void ensureRetrievedMemoriesIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        retrievedMemories_ =
            new java.util.ArrayList<
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory>(
                retrievedMemories_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory,
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory.Builder,
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemoryOrBuilder>
        retrievedMemoriesBuilder_;

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory>
        getRetrievedMemoriesList() {
      if (retrievedMemoriesBuilder_ == null) {
        return java.util.Collections.unmodifiableList(retrievedMemories_);
      } else {
        return retrievedMemoriesBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public int getRetrievedMemoriesCount() {
      if (retrievedMemoriesBuilder_ == null) {
        return retrievedMemories_.size();
      } else {
        return retrievedMemoriesBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
        getRetrievedMemories(int index) {
      if (retrievedMemoriesBuilder_ == null) {
        return retrievedMemories_.get(index);
      } else {
        return retrievedMemoriesBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public Builder setRetrievedMemories(
        int index,
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory value) {
      if (retrievedMemoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRetrievedMemoriesIsMutable();
        retrievedMemories_.set(index, value);
        onChanged();
      } else {
        retrievedMemoriesBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public Builder setRetrievedMemories(
        int index,
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory.Builder
            builderForValue) {
      if (retrievedMemoriesBuilder_ == null) {
        ensureRetrievedMemoriesIsMutable();
        retrievedMemories_.set(index, builderForValue.build());
        onChanged();
      } else {
        retrievedMemoriesBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public Builder addRetrievedMemories(
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory value) {
      if (retrievedMemoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRetrievedMemoriesIsMutable();
        retrievedMemories_.add(value);
        onChanged();
      } else {
        retrievedMemoriesBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public Builder addRetrievedMemories(
        int index,
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory value) {
      if (retrievedMemoriesBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureRetrievedMemoriesIsMutable();
        retrievedMemories_.add(index, value);
        onChanged();
      } else {
        retrievedMemoriesBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public Builder addRetrievedMemories(
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory.Builder
            builderForValue) {
      if (retrievedMemoriesBuilder_ == null) {
        ensureRetrievedMemoriesIsMutable();
        retrievedMemories_.add(builderForValue.build());
        onChanged();
      } else {
        retrievedMemoriesBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public Builder addRetrievedMemories(
        int index,
        com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory.Builder
            builderForValue) {
      if (retrievedMemoriesBuilder_ == null) {
        ensureRetrievedMemoriesIsMutable();
        retrievedMemories_.add(index, builderForValue.build());
        onChanged();
      } else {
        retrievedMemoriesBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public Builder addAllRetrievedMemories(
        java.lang.Iterable<
                ? extends
                    com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory>
            values) {
      if (retrievedMemoriesBuilder_ == null) {
        ensureRetrievedMemoriesIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, retrievedMemories_);
        onChanged();
      } else {
        retrievedMemoriesBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public Builder clearRetrievedMemories() {
      if (retrievedMemoriesBuilder_ == null) {
        retrievedMemories_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        retrievedMemoriesBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public Builder removeRetrievedMemories(int index) {
      if (retrievedMemoriesBuilder_ == null) {
        ensureRetrievedMemoriesIsMutable();
        retrievedMemories_.remove(index);
        onChanged();
      } else {
        retrievedMemoriesBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory.Builder
        getRetrievedMemoriesBuilder(int index) {
      return getRetrievedMemoriesFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemoryOrBuilder
        getRetrievedMemoriesOrBuilder(int index) {
      if (retrievedMemoriesBuilder_ == null) {
        return retrievedMemories_.get(index);
      } else {
        return retrievedMemoriesBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public java.util.List<
            ? extends
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse
                    .RetrievedMemoryOrBuilder>
        getRetrievedMemoriesOrBuilderList() {
      if (retrievedMemoriesBuilder_ != null) {
        return retrievedMemoriesBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(retrievedMemories_);
      }
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory.Builder
        addRetrievedMemoriesBuilder() {
      return getRetrievedMemoriesFieldBuilder()
          .addBuilder(
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory.Builder
        addRetrievedMemoriesBuilder(int index) {
      return getRetrievedMemoriesFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
                  .getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * The retrieved memories.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory retrieved_memories = 1;
     * </code>
     */
    public java.util.List<
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory.Builder>
        getRetrievedMemoriesBuilderList() {
      return getRetrievedMemoriesFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory,
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory.Builder,
            com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemoryOrBuilder>
        getRetrievedMemoriesFieldBuilder() {
      if (retrievedMemoriesBuilder_ == null) {
        retrievedMemoriesBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory,
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse.RetrievedMemory
                    .Builder,
                com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse
                    .RetrievedMemoryOrBuilder>(
                retrievedMemories_,
                ((bitField0_ & 0x00000001) != 0),
                getParentForChildren(),
                isClean());
        retrievedMemories_ = null;
      }
      return retrievedMemoriesBuilder_;
    }

    private java.lang.Object nextPageToken_ = "";

    /**
     *
     *
     * <pre>
     * A token that can be sent as `page_token` to retrieve the next page.
     * If this field is omitted, there are no subsequent pages.
     * This token is not set if similarity search was used for retrieval.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The nextPageToken.
     */
    public java.lang.String getNextPageToken() {
      java.lang.Object ref = nextPageToken_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        nextPageToken_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A token that can be sent as `page_token` to retrieve the next page.
     * If this field is omitted, there are no subsequent pages.
     * This token is not set if similarity search was used for retrieval.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return The bytes for nextPageToken.
     */
    public com.google.protobuf.ByteString getNextPageTokenBytes() {
      java.lang.Object ref = nextPageToken_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        nextPageToken_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * A token that can be sent as `page_token` to retrieve the next page.
     * If this field is omitted, there are no subsequent pages.
     * This token is not set if similarity search was used for retrieval.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageToken(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A token that can be sent as `page_token` to retrieve the next page.
     * If this field is omitted, there are no subsequent pages.
     * This token is not set if similarity search was used for retrieval.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearNextPageToken() {
      nextPageToken_ = getDefaultInstance().getNextPageToken();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * A token that can be sent as `page_token` to retrieve the next page.
     * If this field is omitted, there are no subsequent pages.
     * This token is not set if similarity search was used for retrieval.
     * </pre>
     *
     * <code>string next_page_token = 2;</code>
     *
     * @param value The bytes for nextPageToken to set.
     * @return This builder for chaining.
     */
    public Builder setNextPageTokenBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      nextPageToken_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse)
  private static final com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse();
  }

  public static com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<RetrieveMemoriesResponse> PARSER =
      new com.google.protobuf.AbstractParser<RetrieveMemoriesResponse>() {
        @java.lang.Override
        public RetrieveMemoriesResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<RetrieveMemoriesResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<RetrieveMemoriesResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1beta1.RetrieveMemoriesResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
