/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.artifactregistry.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VersionName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_REPOSITORY_PACKAGE_VERSION = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/repositories/{repository}/packages/{package}/versions/{version}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String repository;
    private final String package_;
    private final String version;

    @Deprecated
    protected VersionName() {
        this.project = null;
        this.location = null;
        this.repository = null;
        this.package_ = null;
        this.version = null;
    }

    private VersionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.repository = (String)Preconditions.checkNotNull((Object)builder.getRepository());
        this.package_ = (String)Preconditions.checkNotNull((Object)builder.getPackage());
        this.version = (String)Preconditions.checkNotNull((Object)builder.getVersion());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getRepository() {
        return this.repository;
    }

    public String getPackage() {
        return this.package_;
    }

    public String getVersion() {
        return this.version;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VersionName of(String project, String location, String repository, String package_, String version) {
        return VersionName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setPackage(package_).setVersion(version).build();
    }

    public static String format(String project, String location, String repository, String package_, String version) {
        return VersionName.newBuilder().setProject(project).setLocation(location).setRepository(repository).setPackage(package_).setVersion(version).build().toString();
    }

    public static VersionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_REPOSITORY_PACKAGE_VERSION.validatedMatch(formattedString, "VersionName.parse: formattedString not in valid format");
        return VersionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("repository"), (String)matchMap.get("package"), (String)matchMap.get("version"));
    }

    public static List<VersionName> parseList(List<String> formattedStrings) {
        ArrayList<VersionName> list = new ArrayList<VersionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VersionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VersionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VersionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_REPOSITORY_PACKAGE_VERSION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VersionName versionName = this;
            synchronized (versionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.repository != null) {
                        fieldMapBuilder.put((Object)"repository", (Object)this.repository);
                    }
                    if (this.package_ != null) {
                        fieldMapBuilder.put((Object)"package", (Object)this.package_);
                    }
                    if (this.version != null) {
                        fieldMapBuilder.put((Object)"version", (Object)this.version);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_REPOSITORY_PACKAGE_VERSION.instantiate(new String[]{"project", this.project, "location", this.location, "repository", this.repository, "package", this.package_, "version", this.version});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            VersionName that = (VersionName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.repository, that.repository) && Objects.equals(this.package_, that.package_) && Objects.equals(this.version, that.version);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.repository);
        h *= 1000003;
        h ^= Objects.hashCode(this.package_);
        h *= 1000003;
        return h ^= Objects.hashCode(this.version);
    }

    public static class Builder {
        private String project;
        private String location;
        private String repository;
        private String package_;
        private String version;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getPackage() {
            return this.package_;
        }

        public String getVersion() {
            return this.version;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setRepository(String repository) {
            this.repository = repository;
            return this;
        }

        public Builder setPackage(String package_) {
            this.package_ = package_;
            return this;
        }

        public Builder setVersion(String version) {
            this.version = version;
            return this;
        }

        private Builder(VersionName versionName) {
            this.project = versionName.project;
            this.location = versionName.location;
            this.repository = versionName.repository;
            this.package_ = versionName.package_;
            this.version = versionName.version;
        }

        public VersionName build() {
            return new VersionName(this);
        }
    }
}

